<a id="section-approximation"></a>18.9. <a id="c18s9"></a>Approximation and inexact numbers
-------------------------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ji'i</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">approximately</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">su'e</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">at most</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">su'o</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">at least</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">me'i</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">less than</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">za'u</p></td><td class="selmaho"><p class="selmaho">PA</p></td><td class="description"><p class="description">more than</p></td></tr></tbody></table>

<a id="id-1.19.11.4.1" class="indexterm"></a><a id="id-1.19.11.4.2" class="indexterm"></a>The cmavo _<a id="id-1.19.11.4.3.1" class="indexterm"></a>[_ji'i_](../go01#valsi-jihi)_ (of selma'o PA) is used in several ways to indicate approximate or rounded numbers. If it appears at the beginning of a number, the whole number is approximate:

<div class="interlinear-gloss-example example">
<a id="example-random-id-YLcy"></a>

**Example 18.60. <a id="c18e9d1"></a><a id="id-1.19.11.5.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ji'i</td><td>vo</td><td>no</td></tr><tr class="gloss"><td>approximation</td><td>four</td><td>zero</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">approximately 40</p></td></tr></tbody></table>

</div>  

<a id="id-1.19.11.6.1" class="indexterm"></a>If _<a id="id-1.19.11.6.2.1" class="indexterm"></a>[_ji'i_](../go01#valsi-jihi)_ appears in the middle of a number, all the digits following it are approximate:

<div class="interlinear-gloss-example example">
<a id="example-random-id-BANC"></a>

**Example 18.61. <a id="c18e9d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>vo</td><td>no</td><td>ji'i</td><td>mu</td><td>no</td></tr><tr class="gloss"><td>four</td><td>zero</td><td>approximation</td><td>five</td><td>zero</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">roughly 4050 (where the <span class="quote">“<span class="quote">four thousand</span>”</span> is exact, but the <span class="quote">“<span class="quote">fifty</span>”</span> is approximate)</p></td></tr></tbody></table>

</div>  

<a id="id-1.19.11.8.1" class="indexterm"></a><a id="id-1.19.11.8.2" class="indexterm"></a>If _<a id="id-1.19.11.8.3.1" class="indexterm"></a>[_ji'i_](../go01#valsi-jihi)_ appears at the end of a number, it indicates that the number has been rounded. In addition, it can then be followed by a sign cmavo ( _<a id="id-1.19.11.8.4.1" class="indexterm"></a>[_ma'u_](../go01#valsi-mahu)_ or _<a id="id-1.19.11.8.5.1" class="indexterm"></a>[_ni'u_](../go01#valsi-nihu)_), which indicate truncation towards positive or negative infinity respectively.

<div class="interlinear-gloss-example example">
<a id="example-random-id-qIc5"></a>

**Example 18.62. <a id="c18e9d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>re</td><td>pi</td><td>ze</td><td>re</td><td>ji'i</td></tr><tr class="gloss"><td>two</td><td>point</td><td>seven</td><td>two</td><td>approximation</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">2.72 (rounded)</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qicz"></a>

**Example 18.63. <a id="c18e9d4"></a><a id="id-1.19.11.10.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>re</td><td>pi</td><td>ze</td><td>re</td><td>ji'i</td><td>ma'u</td></tr><tr class="gloss"><td>two</td><td>point</td><td>seven</td><td>two</td><td>approximation</td><td>positive-sign</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">2.72 (rounded up)</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qiDE"></a>

**Example 18.64. <a id="c18e9d5"></a><a id="id-1.19.11.11.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>re</td><td>pi</td><td>ze</td><td>pa</td><td>ji'i</td><td>ni'u</td></tr><tr class="gloss"><td>two</td><td>point</td><td>seven</td><td>one</td><td>approximation</td><td>negative-sign</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">2.71 (rounded down)</p></td></tr></tbody></table>

</div>  

<a id="id-1.19.11.12.1" class="indexterm"></a>[Example 18.62](../section-approximation#example-random-id-qIc5) through [Example 18.64](../section-approximation#example-random-id-qiDE) are all approximations to _<a id="id-1.19.11.12.4.1" class="indexterm"></a>[_te'o_](../go01#valsi-teho)_ (exponential e). _<a id="id-1.19.11.12.5.1" class="indexterm"></a>[_ji'i_](../go01#valsi-jihi)_ can also appear by itself, in which case it means “approximately the typical value in this context”.

<a id="id-1.19.11.13.1" class="indexterm"></a>The four cmavo _<a id="id-1.19.11.13.2.1" class="indexterm"></a>[_su'e_](../go01#valsi-suhe)_ , _<a id="id-1.19.11.13.3.1" class="indexterm"></a>[_su'o_](../go01#valsi-suho)_ , _<a id="id-1.19.11.13.4.1" class="indexterm"></a>[_me'i_](../go01#valsi-mehi)_ , and _<a id="id-1.19.11.13.5.1" class="indexterm"></a>[_za'u_](../go01#valsi-zahu)_ , also of selma'o PA, express inexact numbers with upper or lower bounds:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qidi"></a>

**Example 18.65. <a id="c18e9d6"></a><a id="id-1.19.11.14.1.2" class="indexterm"></a><a id="id-1.19.11.14.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>catlu</td><td>su'e</td><td>re</td><td>prenu</td></tr><tr class="gloss"><td>I</td><td>look-at</td><td>at-most</td><td>two</td><td>persons</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qiE3"></a>

**Example 18.66. <a id="c18e9d7"></a><a id="id-1.19.11.15.1.2" class="indexterm"></a><a id="id-1.19.11.15.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>catlu</td><td>su'o</td><td>re</td><td>prenu</td></tr><tr class="gloss"><td>I</td><td>look-at</td><td>at-least</td><td>two</td><td>persons</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qIe7"></a>

**Example 18.67. <a id="c18e9d8"></a><a id="id-1.19.11.16.1.2" class="indexterm"></a><a id="id-1.19.11.16.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>catlu</td><td>me'i</td><td>re</td><td>prenu</td></tr><tr class="gloss"><td>I</td><td>look-at</td><td>less-than</td><td>two</td><td>persons</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qIfM"></a>

**Example 18.68. <a id="c18e9d9"></a><a id="id-1.19.11.17.1.2" class="indexterm"></a><a id="id-1.19.11.17.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>catlu</td><td>za'u</td><td>re</td><td>prenu</td></tr><tr class="gloss"><td>I</td><td>look-at</td><td>more-than</td><td>two</td><td>persons</td></tr></tbody></table>

</div>  

<a id="id-1.19.11.18.1" class="indexterm"></a><a id="id-1.19.11.18.2" class="indexterm"></a><a id="id-1.19.11.18.3" class="indexterm"></a><a id="id-1.19.11.18.4" class="indexterm"></a><a id="id-1.19.11.18.5" class="indexterm"></a><a id="id-1.19.11.18.6" class="indexterm"></a>Each of these is a subtly different claim: [Example 18.66](../section-approximation#example-random-id-qiE3) is true of two or any greater number, whereas [Example 18.68](../section-approximation#example-random-id-qIfM) requires three persons or more. Likewise, [Example 18.65](../section-approximation#example-random-id-qidi) refers to zero, one, or two; [Example 18.67](../section-approximation#example-random-id-qIe7) to zero or one. (Of course, when the context allows numbers other than non-negative integers, _<a id="id-1.19.11.18.11.1" class="indexterm"></a>me'i re_ can be any number less than 2, and likewise with the other cases.) The exact quantifier, “exactly 2, neither more nor less” is just _<a id="id-1.19.11.18.13.1" class="indexterm"></a>[_re_](../go01#valsi-re)_. Note that _<a id="id-1.19.11.18.14.1" class="indexterm"></a>su'ore_ is the exact Lojban equivalent of English plurals.

<a id="id-1.19.11.19.1" class="indexterm"></a><a id="id-1.19.11.19.2" class="indexterm"></a><a id="id-1.19.11.19.3" class="indexterm"></a><a id="id-1.19.11.19.4" class="indexterm"></a>If no number follows one of these cmavo, _<a id="id-1.19.11.19.5.1" class="indexterm"></a>[_pa_](../go01#valsi-pa)_ is understood: therefore,

<div class="interlinear-gloss-example example">
<a id="example-random-id-brir"></a>

**Example 18.69. <a id="c18e9d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>catlu</td><td>su'o</td><td>prenu</td></tr><tr class="gloss"><td>I</td><td>look-at</td><td>at-least-[one]</td><td>person</td></tr></tbody></table>

</div>  

is a meaningful claim.

<a id="id-1.19.11.22.1" class="indexterm"></a>Like the numbers in [Section 18.8](../section-indefinite-numbers) , all of these cmavo may be preceded by _<a id="id-1.19.11.22.3.1" class="indexterm"></a>[_pi_](../go01#valsi-pi)_ to make the corresponding quantifiers for part of a whole. For example, _<a id="id-1.19.11.22.4.1" class="indexterm"></a>[_pisu'o_](../go01#valsi-pisuho)_ means “at least some part of”. The quantifiers _<a id="id-1.19.11.22.6.1" class="indexterm"></a>[_ro_](../go01#valsi-ro)_ , _<a id="id-1.19.11.22.7.1" class="indexterm"></a>[_su'o_](../go01#valsi-suho)_ , _<a id="id-1.19.11.22.8.1" class="indexterm"></a>[_piro_](../go01#valsi-piro)_ , and _<a id="id-1.19.11.22.9.1" class="indexterm"></a>[_pisu'o_](../go01#valsi-pisuho)_ are particularly important in Lojban, as they are implicitly used in the descriptions introduced by the cmavo of selma'o LA and LE, as explained in [Section 6.7](../section-quantified-descriptions). Descriptions in general are outside the scope of this chapter.