<a id="section-any"></a>16.8. <a id="c16s8"></a>The problem of “any”
--------------------------------------------------------------------

Consider the English sentence<a id="id-1.17.10.2.1" class="indexterm"></a>

<div class="example">
<a id="example-random-id-R4mX"></a>

**Example 16.47. <a id="c16e8d1"></a><a id="id-1.17.10.3.1.2" class="indexterm"></a>** 

Anyone who goes to the store, walks across the field.

</div>  

Using the facilities already discussed, a plausible translation might be

<div class="interlinear-gloss-example example">
<a id="example-random-id-7Kn8"></a>

**Example 16.48. <a id="c16e8d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ro</td><td>da</td><td>poi</td><td>klama</td><td>le</td><td>zarci</td><td>cu</td><td>cadzu</td><td>le</td><td>foldi</td></tr><tr class="gloss"><td>All</td><td>X</td><td>such-that-it</td><td>goes-to</td><td>the</td><td>store</td><td></td><td>walks-on</td><td>the</td><td>field.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Everyone who goes to the store walks across the field.</p></td></tr></tbody></table>

</div>  

<a id="id-1.17.10.6.1" class="indexterm"></a><a id="id-1.17.10.6.2" class="indexterm"></a><a id="id-1.17.10.6.3" class="indexterm"></a>But there is a subtle difference between [Example 16.47](../section-any#example-random-id-R4mX) and [Example 16.48](../section-any#example-random-id-7Kn8). [Example 16.48](../section-any#example-random-id-7Kn8) tells us that, in fact, there are people who go to the store, and that they walk across the field. A sumti of the type _<a id="id-1.17.10.6.7.1" class="indexterm"></a>ro da poi klama_ requires that there are things which _<a id="id-1.17.10.6.8.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ : Lojban universal claims always imply the corresponding existential claims as well. [Example 16.47](../section-any#example-random-id-R4mX) , on the other hand, does not require that there are any people who go to the store: it simply states, conditionally, that if there is anyone who goes to the store, he or she walks across the field as well. This conditional form mirrors the true Lojban translation of [Example 16.47](../section-any#example-random-id-R4mX) :

<div class="interlinear-gloss-example example">
<a id="example-random-id-BwU7"></a>

**Example 16.49. <a id="c16e8d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ro</td><td>da</td><td>zo'u</td><td>da</td><td>go</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>For-every</td><td>X</td><td>:</td><td>X</td><td>if-and-only-if</td><td>it-is-a-goer-to</td><td>the</td><td>store</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>gi</td><td>cadzu</td><td>le</td><td>foldi</td></tr><tr class="gloss"><td></td><td>is-a-walker-on</td><td>the</td><td>field.</td></tr></tbody></table>

</div>  

<a id="id-1.17.10.8.1" class="indexterm"></a>Although [Example 16.49](../section-any#example-random-id-BwU7) is a universal claim as well, its universality only implies that there are objects of some sort or another in the universe of discourse. Because the claim is conditional, nothing is implied about the existence of goers-to-the-store or of walkers-on-the-field, merely that any entity which is one is also the other.

<a id="id-1.17.10.9.1" class="indexterm"></a>There is another use of “any” in English that is not universal but existential. Consider

<div class="example">
<a id="example-random-id-7Eu9"></a>

**Example 16.50. <a id="c16e8d4"></a>** 

I need any box that is bigger than this one.

</div>  

<a id="id-1.17.10.11.1" class="indexterm"></a><a id="id-1.17.10.11.2" class="indexterm"></a>[Example 16.50](../section-any#example-random-id-7Eu9) does not at all mean that I need every box bigger than this one, for indeed I do not; I require only one box. But the naive translation

<div class="interlinear-gloss-example example">
<a id="example-random-id-KHya"></a>

**Example 16.51. <a id="c16e8d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nitcu</td><td>da</td><td>poi</td><td>tanxe</td><td>gi'e</td><td>bramau</td><td>ti</td></tr><tr class="gloss"><td>I</td><td>need</td><td>some-X</td><td>which</td><td>is-a-box</td><td>and</td><td>is-bigger-than</td><td>this-one</td></tr></tbody></table>

</div>  

does not work either, because it asserts that there really is such a box, as the prenex paraphrase demonstrates:

<div class="interlinear-gloss-example example">
<a id="example-random-id-fAo5"></a>

**Example 16.52. <a id="c16e8d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>da</td><td>poi</td><td>tanxe</td><td>gi'e</td><td>bramau</td><td>ti</td><td>zo'u</td><td>mi</td><td>nitcu</td><td>da</td></tr><tr class="gloss"><td>There-is-an-X</td><td>which</td><td>is-a-box</td><td>and</td><td>is-bigger-than</td><td>this</td><td>:</td><td>I</td><td>need</td><td>X.</td></tr></tbody></table>

</div>  

What to do? Well, the x2 place of _<a id="id-1.17.10.15.2.1" class="indexterm"></a>[_nitcu_](../go01#valsi-nitcu)_ can be filled with an event as well as an object, and in fact [Example 16.51](../section-any#example-random-id-KHya) can also be paraphrased as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-e7ta"></a>

**Example 16.53. <a id="c16e8d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nitcu</td><td>lo</td><td>nu</td><td>mi</td><td>ponse</td><td>lo</td><td>tanxe</td></tr><tr class="gloss"><td>I</td><td>need</td><td>an</td><td>event-of</td><td>I</td><td>possess</td><td>some</td><td>box(es)</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>poi</td><td>bramau</td><td>ti</td></tr><tr class="gloss"><td>which-are</td><td>bigger-than</td><td>this-one.</td></tr></tbody></table>

</div>  

Rewritten using variables, [Example 16.53](../section-any#example-random-id-e7ta) becomes

<div class="interlinear-gloss-example example">
<a id="example-random-id-4Pz8"></a>

**Example 16.54. <a id="c16e8d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nitcu</td><td>lo</td><td>nu</td><td>da</td><td>zo'u</td></tr><tr class="gloss"><td>I</td><td>need</td><td>an</td><td>event-of</td><td>there-being-an-X</td><td>such-that:</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>da</td><td>se</td><td>ponse</td><td>mi</td></tr><tr class="gloss"><td>X</td><td></td><td>is-possessed-by</td><td>me</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>gi'e</td><td>tanxe</td><td>gi'e</td><td>bramau</td><td>ti</td></tr><tr class="gloss"><td>and</td><td>is-a-box</td><td>and</td><td>is-bigger-than</td><td>this-thing.</td></tr></tbody></table>

</div>  

<a id="id-1.17.10.19.1" class="indexterm"></a><a id="id-1.17.10.19.2" class="indexterm"></a><a id="id-1.17.10.19.3" class="indexterm"></a>So we see that a prenex can be attached to a bridi that is within a sentence. By default, a variable always behaves as if it is bound in the prenex which (notionally) is attached to the smallest enclosing bridi, and its scope does not extend beyond that bridi. However, the variable may be placed in an outer prenex explicitly:

<div class="interlinear-gloss-example example">
<a id="example-random-id-7KKM"></a>

**Example 16.55. <a id="c16e8d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>da</td><td>poi</td><td>tanxe</td><td>gi'e</td><td>bramau</td><td>ti</td><td>zo'u</td></tr><tr class="gloss"><td>There-is-an-X</td><td>which</td><td>is-a-box</td><td>and</td><td>is-bigger-than</td><td>this-one</td><td>such-that:</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nitcu</td><td>le</td><td>nu</td><td>mi</td><td>ponse</td><td>da</td></tr><tr class="gloss"><td>I</td><td>need</td><td>the</td><td>event-of</td><td>my</td><td>possessing</td><td>X.</td></tr></tbody></table>

</div>  

<a id="id-1.17.10.21.1" class="indexterm"></a><a id="id-1.17.10.21.2" class="indexterm"></a>But what are the implications of [Example 16.53](../section-any#example-random-id-e7ta) and [Example 16.55](../section-any#example-random-id-7KKM) ? The main difference is that in [Example 16.55](../section-any#example-random-id-7KKM) , the _<a id="id-1.17.10.21.6.1" class="indexterm"></a>[_da_](../go01#valsi-da)_ is said to exist in the real world of the outer bridi; but in [Example 16.53](../section-any#example-random-id-e7ta) , the existence is only within the inner bridi, which is a mere event that need not necessarily come to pass. So [Example 16.55](../section-any#example-random-id-7KKM) means

<div class="example">
<a id="example-random-id-xC32"></a>

**Example 16.56. <a id="c16e8d10"></a>** 

There's a box, bigger than this one, that I need

</div>  

<a id="id-1.17.10.23.1" class="indexterm"></a>which is what [Example 16.52](../section-any#example-random-id-fAo5) says, whereas [Example 16.53](../section-any#example-random-id-e7ta) turns out to be an effective translation of our original [Example 16.47](../section-any#example-random-id-R4mX). So uses of “any” that aren't universal end up being reflected by variables bound in the prenex of a subordinate bridi.