<a id="section-anomalous-lujvo"></a>12.14. <a id="c12s14"></a>Anomalous lujvo
-----------------------------------------------------------------------------

Some lujvo that have been coined and actually employed in Lojban writing do not follow the guidelines expressed above, either because the places that are equivalent in the seltau and the tertau are in an unusual position, or because the seltau and tertau are related in a complex way, or both. An example of the first kind is _<a id="id-1.13.16.2.1.1" class="indexterm"></a>[_jdaselsku_](../go01#valsi-jdaselsku)_ , meaning “prayer” , which was mentioned in [Section 12.7](../section-order-of-places). The gismu places are:

<div class="example">
<a id="example-random-id-qJEQ"></a>

**Example 12.75. <a id="c12e14d1"></a>** 

_<a id="id-1.13.16.3.2.1.1" class="indexterm"></a>[_lijda_](../go01#valsi-lijda)_ : l1 is a religion with believers l2 and beliefs l3

_<a id="id-1.13.16.3.3.1.1" class="indexterm"></a>[_cusku_](../go01#valsi-cusku)_ : c1 expresses text c2 to audience c3 in medium c4

</div>  

and _<a id="id-1.13.16.4.1.1" class="indexterm"></a>[_selsku_](../go01#valsi-selsku)_ , the tertau of _<a id="id-1.13.16.4.2.1" class="indexterm"></a>[_jdaselsku_](../go01#valsi-jdaselsku)_ , has the place structure

<div class="example">
<a id="example-random-id-qW3w"></a>

**Example 12.76. <a id="c12e14d2"></a>** 

> s1 is a text expressed by s2 to audience s3 in medium s4

</div>  

Now it is easy to see that the l2 and s2 places are equivalent: the believer in the religion (l2) is the one who expresses the prayer (s2). This is not one of the cases for which a place ordering rule has been given in [Section 12.7](../section-order-of-places) or [Section 12.13](../section-implicit-abstraction) ; therefore, for lack of a better rule, we put the tertau places first and the remaining seltau places after them, leading to the place structure:

<div class="example">
<a id="example-random-id-41dc"></a>

**Example 12.77. <a id="c12e14d3"></a>** 

> s1 is a prayer expressed by s2=l2 to audience s3 in medium s4 pertaining to religion l1

</div>  

The l3 place (the beliefs of the religion) is dependent on the l1 place (the religion) and so is omitted.

We could make this lujvo less messy by replacing it with _<a id="id-1.13.16.9.1.1" class="indexterm"></a>se seljdasku_ , where _seljdasku_ is a normal symmetrical lujvo with place structure:

<div class="example">
<a id="example-random-id-7Tdb"></a>

**Example 12.78. <a id="c12e14d4"></a>** 

> c1=l2 religiously expresses prayer c2 to audience c3 in medium s4 pertaining to religion l1

</div>  

which, according to the rule expressed in [Section 12.9](../section-seltau-SE) , can be further expressed as _selseljdasku_. However, there is no need for the ugly _<a id="id-1.13.16.11.3.1" class="indexterm"></a>selsel-_ prefix just to get the rules right: _<a id="id-1.13.16.11.4.1" class="indexterm"></a>[_jdaselsku_](../go01#valsi-jdaselsku)_ is a reasonable, if anomalous, lujvo.

However, there is a further problem with _<a id="id-1.13.16.12.1.1" class="indexterm"></a>[_jdaselsku_](../go01#valsi-jdaselsku)_ , not resolvable by using _seljdasku_. No veljvo involving just the two gismu _<a id="id-1.13.16.12.3.1" class="indexterm"></a>[_lijda_](../go01#valsi-lijda)_ and _<a id="id-1.13.16.12.4.1" class="indexterm"></a>[_cusku_](../go01#valsi-cusku)_ can fully express the relationship implicit in prayer. A prayer is not just anything said by the adherents of a religion; nor is it even anything said by them acting as adherents of that religion. Rather, it is what they say under the authority of that religion, or using the religion as a medium, or following the rules associated with the religion, or something of the kind. So the veljvo is somewhat elliptical.

As a result, both _seljdasku_ and _<a id="id-1.13.16.13.2.1" class="indexterm"></a>[_jdaselsku_](../go01#valsi-jdaselsku)_ belong to the second class of anomalous lujvo: the veljvo doesn't really supply all that the lujvo requires.

Another example of this kind of anomalous lujvo, drawn from the tanru lists in [Section 5.14](../section-asymmetric-tanru) , is _lange'u_ , meaning “sheepdog”. Clearly a sheepdog is not a dog which is a sheep (the symmetrical interpretation is wrong), nor a dog of the sheep breed (the asymmetrical interpretation is wrong). Indeed, there is simply no overlap in the places of _<a id="id-1.13.16.14.4.1" class="indexterm"></a>[_lanme_](../go01#valsi-lanme)_ and _<a id="id-1.13.16.14.5.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_ at all. Rather, the lujvo refers to a dog which controls sheep flocks, a _<a id="id-1.13.16.14.6.1" class="indexterm"></a>terlanme jitro gerku_ , the lujvo from which is _terlantroge'u_ with place structure:

<div class="example">
<a id="example-random-id-TW5Q"></a>

**Example 12.79. <a id="c12e14d5"></a>** 

> g1=j1 is a dog that controls sheep flock l3=j2 made up of sheep l1 in activity j3 of dog breed g2

</div>  

based on the gismu place structures

<div class="example">
<a id="example-random-id-CXeL"></a>

**Example 12.80. <a id="c12e14d6"></a>** 

_<a id="id-1.13.16.17.2.1.1" class="indexterm"></a>[_lanme_](../go01#valsi-lanme)_ : l1 is a sheep of breed l2 belonging to flock l3

_<a id="id-1.13.16.17.3.1.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_ : g1 is a dog of breed g2

_<a id="id-1.13.16.17.4.1.1" class="indexterm"></a>[_jitro_](../go01#valsi-jitro)_ : j1 controls j2 in activity j3

</div>  

Note that this lujvo is symmetrical between _<a id="id-1.13.16.18.1.1" class="indexterm"></a>[_lantro_](../go01#valsi-lantro)_ (sheep-controller) and _<a id="id-1.13.16.18.2.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_ , but _<a id="id-1.13.16.18.3.1" class="indexterm"></a>[_lantro_](../go01#valsi-lantro)_ is itself an asymmetrical lujvo. The l2 place, the breed of sheep, is removed as dependent on l1. However, the lujvo _lange'u_ is both shorter than _terlantroge'u_ and sufficiently clear to warrant its use: its place structure, however, should be the same as that of the longer lujvo, for which _lange'u_ can be understood as an abbreviation.

Another example is _xanmi'e_ , “to command by hand, to beckon”. The component place structures are:

<div class="example">
<a id="example-random-id-VjbP"></a>

**Example 12.81. <a id="c12e14d7"></a>** 

_<a id="id-1.13.16.20.2.1.1" class="indexterm"></a>[_xance_](../go01#valsi-xance)_ : xa1 is the hand of xa2

_<a id="id-1.13.16.20.3.1.1" class="indexterm"></a>[_minde_](../go01#valsi-minde)_ : m1 gives commands to m2 to cause m3 to happen

</div>  

The relation between the seltau and tertau is close enough for there to be an overlap: xa2 (the person with the hand) is the same as m1 (the one who commands). But interpreting _xanmi'e_ as a symmetrical lujvo with an elided _<a id="id-1.13.16.21.2.1" class="indexterm"></a>sel-_ in the seltau, as if from _<a id="id-1.13.16.21.3.1" class="indexterm"></a>se xance minde_ , misses the point: the real relation expressed by the lujvo is not just “one who commands and has a hand” , but “to command using the hand”. The concept of “using” suggests the gismu _<a id="id-1.13.16.21.7.1" class="indexterm"></a>[_pilno_](../go01#valsi-pilno)_ , with place structure

<div class="example">
<a id="example-random-id-sqQN"></a>

**Example 12.82. <a id="c12e14d8"></a>** 

> p1 uses tool p2 for purpose p3

</div>  

Some possible three-part veljvo are (depending on how strictly you want to constrain the veljvo)

<div class="interlinear-gloss-example example">
<a id="example-random-id-qfe4"></a>

**Example 12.83. <a id="c12e14d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>[ke]</td><td>xance</td><td>pilno</td><td>[ke'e]</td><td></td><td>minde</td></tr><tr class="gloss"><td>(</td><td>hand</td><td>user</td><td>)</td><td>type-of</td><td>commander</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qFen"></a>

**Example 12.84. <a id="c12e14d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>[ke]</td><td>minde</td><td>xance</td><td>[ke'e]</td><td></td><td>pilno</td></tr><tr class="gloss"><td>(</td><td>commander</td><td>hand</td><td>)</td><td>type-of</td><td>user</td></tr></tbody></table>

</div>  

or even

<div class="interlinear-gloss-example example">
<a id="example-random-id-yCod"></a>

**Example 12.85. <a id="c12e14d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>minde</td><td></td><td>ke</td><td>xance</td><td>pilno</td><td>[ke'e]</td></tr><tr class="gloss"><td>commander</td><td>type-of</td><td>(</td><td>hand</td><td>user</td><td>)</td></tr></tbody></table>

</div>  

which lead to the three different lujvo _xanplimi'e_ , _mi'erxanpli_ , and _minkemxanpli_ respectively.

<a id="id-1.13.16.29.1" class="indexterm"></a>Does this make _xanmi'e_ wrong? By no means. But it does mean that there is a latent component to the meaning of _xanmi'e_ , the gismu _<a id="id-1.13.16.29.4.1" class="indexterm"></a>[_pilno_](../go01#valsi-pilno)_ , which is not explicit in the veljvo. And it also means that, for a place structure derivation that actually makes sense, rather than being ad-hoc, the Lojbanist should probably go through a derivation for _xancypliminde_ or one of the other possibilities that is analogous to the analysis of _terlantroge'u_ above, even if he or she decides to stick with a shorter, more convenient form like _xanmi'e_. In addition, of course, the possibilities of elliptical lujvo increase their potential ambiguity enormously – an unavoidable fact which should be borne in mind.