<a id="section-anglophone-phonetics"></a>3.10. <a id="c3s10"></a>IPA for English speakers
-----------------------------------------------------------------------------------------

<a id="id-1.4.12.2.1" class="indexterm"></a><a id="id-1.4.12.2.2" class="indexterm"></a><a id="id-1.4.12.2.3" class="indexterm"></a><a id="id-1.4.12.2.4" class="indexterm"></a>There are many dialects of English, thus making it difficult to define the standardized symbols of the IPA in terms useful to every reader. All the symbols used in this chapter are repeated here, in more or less alphabetical order, with examples drawn from General American. In addition, some attention is given to the Received Pronunciation of (British) English. These two dialects are referred to as GA and RP respectively. Speakers of other dialects should consult a book on phonetics or their local television sets.

<table class="vertsep"><colgroup></colgroup><tbody><tr><td><span class="IPA">[ˈ]</span></td><td>An IPA indicator of primary stress; the syllable which follows <span class="IPA">[ˈ]</span> receives primary stress.</td></tr><tr><td><span class="IPA">[ʔ]</span></td><td>An allowed variant of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.</em></span>. This sound is not usually considered part of English. It is the catch in your throat that sometimes occurs prior to the beginning of a word (and sometimes a syllable) which starts with a vowel. In some dialects, like Cockney and some kinds of American English, it is used between vowels instead of <span class="quote">“<span class="quote">t</span>”</span> : <span class="quote">“<span class="quote">bottle</span>”</span> <span class="IPA">[boʔl̩]</span>. The English interjection <span class="quote">“<span class="quote">uh-oh!</span>”</span> almost always has it between the syllables.</td></tr><tr><td><span class="IPA">[ː]</span></td><td>A symbol indicating that the previous vowel is to be spoken for a longer time than usual. Lojban vowels can be pronounced long in order to make a greater contrast with buffer vowels.</td></tr><tr><td><span class="IPA">[a]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">a</em></span>. This sound doesn't occur in GA, but sounds somewhat like the <span class="quote">“<span class="quote">ar</span>”</span> of <span class="quote">“<span class="quote">park</span>”</span> , as spoken in RP or New England American. It is pronounced further forward in the mouth than <span class="IPA">[ɑ]</span>.</td></tr><tr><td><span class="IPA">[ɑ]</span></td><td>An allowed variant of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">a</em></span>. The <span class="quote">“<span class="quote">a</span>”</span> of GA <span class="quote">“<span class="quote">father</span>”</span>. The sound <span class="IPA">[a]</span> is preferred because GA speakers often relax an unstressed <span class="IPA">[ɑ]</span> into a schwa <span class="IPA">[ə]</span> , as in the usual pronunciations of <span class="quote">“<span class="quote">about</span>”</span> and <span class="quote">“<span class="quote">sofa</span>”</span>. Because schwa is a distinct vowel in Lojban, English speakers must either learn to avoid this shift or to use <span class="IPA">[a]</span> instead: the Lojban word for <span class="quote">“<span class="quote">sofa</span>”</span> is <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.4.12.4.6.2.11.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-sfofa"><em class="glossterm">sfofa</em></a></em></span> , pronounced <span class="IPA">[sfofa]</span> or <span class="IPA">[sfofɑ]</span> but never <span class="IPA">[sfofə]</span> which would be the non-word <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">sfofy</em></span>.</td></tr><tr><td><span class="IPA">[æ]</span></td><td>Not a Lojban sound. The <span class="quote">“<span class="quote">a</span>”</span> of English <span class="quote">“<span class="quote">cat</span>”</span>.</td></tr><tr><td><span class="IPA">[b]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">b</em></span>. As in English <span class="quote">“<span class="quote">boy</span>”</span> , <span class="quote">“<span class="quote">sober</span>”</span> , or <span class="quote">“<span class="quote">job</span>”</span>.</td></tr><tr><td><span class="IPA">[β]</span></td><td>An allowed variant of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">v</em></span>. Not an English sound; the Spanish <span xml:lang="es" class="quote" lang="es">“<span class="quote">b</span>”</span> or <span xml:lang="es" class="quote" lang="es">“<span class="quote">v</span>”</span> between vowels. This sound should not be used for Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">b</em></span>.</td></tr><tr><td><span class="IPA">[d]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">d</em></span>. As in English <span class="quote">“<span class="quote">dog</span>”</span> , <span class="quote">“<span class="quote">soda</span>”</span> , or <span class="quote">“<span class="quote">mad</span>”</span>.</td></tr><tr><td><span class="IPA">[ɛ]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">e</em></span>. The <span class="quote">“<span class="quote">e</span>”</span> of English <span class="quote">“<span class="quote">met</span>”</span>.</td></tr><tr><td><span class="IPA">[e]</span></td><td>An allowed variant of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">e</em></span>. This sound is not found in English, but is the Spanish <span xml:lang="es" class="quote" lang="es">“<span class="quote">e</span>”</span> , or the tense <span xml:lang="it" class="quote" lang="it">«<span class="quote">e</span>»</span> of Italian. The vowel of English <span class="quote">“<span class="quote">say</span>”</span> is similar except for the off-glide: you can learn to make this sound by holding your tongue steady while saying the first part of the English vowel.</td></tr><tr><td><span class="IPA">[ə]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">y</em></span>. As in the <span class="quote">“<span class="quote">a</span>”</span> of English <span class="quote">“<span class="quote">sofa</span>”</span> or <span class="quote">“<span class="quote">about</span>”</span>. Schwa is generally unstressed in Lojban, as it is in English. It is a totally relaxed sound made with the tongue in the middle of the mouth.</td></tr><tr><td><span class="IPA">[f]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">f</em></span>. As in <span class="quote">“<span class="quote">fee</span>”</span> , <span class="quote">“<span class="quote">loafer</span>”</span> , or <span class="quote">“<span class="quote">chef</span>”</span>.</td></tr><tr><td><span class="IPA">[ɸ]</span></td><td>An allowed variant of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">f</em></span>. Not an English sound; the Japanese <span class="quote">“<span class="quote">f</span>”</span> sound.</td></tr><tr><td><span class="IPA">[g]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">g</em></span>. As in English <span class="quote">“<span class="quote">go</span>”</span> , <span class="quote">“<span class="quote">eagle</span>”</span> , or <span class="quote">“<span class="quote">dog</span>”</span>.</td></tr><tr><td><span class="IPA">[h]</span></td><td>The preferred pronunciation of the Lojban apostrophe sound. As in English <span class="quote">“<span class="quote">aha</span>”</span> or the second "h" in <span class="quote">“<span class="quote">oh, hello</span>”</span>.</td></tr><tr><td><span class="IPA">[i]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">i</em></span>. Essentially like the English vowel of <span class="quote">“<span class="quote">pizza</span>”</span> or <span class="quote">“<span class="quote">machine</span>”</span> , although the English vowel is sometimes pronounced with an off-glide, which should not be present in Lojban.</td></tr><tr><td><span class="IPA">[ɪ]</span></td><td>A possible Lojban buffer vowel. The <span class="quote">“<span class="quote">i</span>”</span> of English <span class="quote">“<span class="quote">bit</span>”</span>.</td></tr><tr><td><span class="IPA">[ɨ]</span></td><td>A possible Lojban buffer vowel. The <span class="quote">“<span class="quote">u</span>”</span> of <span class="quote">“<span class="quote">just</span>”</span> in some varieties of GA, those which make the word sound more or less like <span class="quote">“<span class="quote">jist</span>”</span>. Also Russian <span xml:lang="ru" class="quote" lang="ru">«<span class="quote">y</span>»</span> as in <span xml:lang="ru" class="quote" lang="ru">«<span class="quote">byt'</span>»</span> (to be); like a schwa <span class="IPA">[ə]</span> , but higher in the mouth.</td></tr><tr><td><span class="IPA">[j]</span></td><td>Used in Lojban diphthongs beginning or ending with <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">i</em></span>. Like the <span class="quote">“<span class="quote">y</span>”</span> in English <span class="quote">“<span class="quote">yard</span>”</span> or <span class="quote">“<span class="quote">say</span>”</span>.</td></tr><tr><td><span class="IPA">[k]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">k</em></span>. As in English <span class="quote">“<span class="quote">kill</span>”</span> , <span class="quote">“<span class="quote">token</span>”</span> , or <span class="quote">“<span class="quote">flak</span>”</span>.</td></tr><tr><td><span class="IPA">[l]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">l</em></span>. As in English <span class="quote">“<span class="quote">low</span>”</span> , <span class="quote">“<span class="quote">nylon</span>”</span> , or <span class="quote">“<span class="quote">excel</span>”</span>.</td></tr><tr><td>[l̩]</td><td>The syllabic version of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">l</em></span> , as in English <span class="quote">“<span class="quote">bottle</span>”</span> or <span class="quote">“<span class="quote">middle</span>”</span>.</td></tr><tr><td><span class="IPA">[m]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">m</em></span>. As in English <span class="quote">“<span class="quote">me</span>”</span> , <span class="quote">“<span class="quote">humor</span>”</span> , or <span class="quote">“<span class="quote">ham</span>”</span>.</td></tr><tr><td>[m̩]</td><td>The syllabic version of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">m</em></span>. As in English <span class="quote">“<span class="quote">catch 'em</span>”</span> or <span class="quote">“<span class="quote">bottom</span>”</span>.</td></tr><tr><td><span class="IPA">[n]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">n</em></span>. As in English <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.4.12.4.27.2.2.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-no"><em class="glossterm">no</em></a></em></span> , <span class="quote">“<span class="quote">honor</span>”</span> , or <span class="quote">“<span class="quote">son</span>”</span>.</td></tr><tr><td>[n̩]</td><td>The syllabic version of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">n</em></span>. As in English <span class="quote">“<span class="quote">button</span>”</span>.</td></tr><tr><td><span class="IPA">[ŋ]</span></td><td>An allowed variant of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">n</em></span> , especially in Lojbanized names and before <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">g</em></span> or <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">k</em></span>. As in English <span class="quote">“<span class="quote">sing</span>”</span> or <span class="quote">“<span class="quote">singer</span>”</span> (but not <span class="quote">“<span class="quote">finger</span>”</span> or <span class="quote">“<span class="quote">danger</span>”</span>).</td></tr><tr><td>[ŋ̍]</td><td>An allowed variant of Lojban syllabic <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">n</em></span> , especially in Lojbanized names.</td></tr><tr><td><span class="IPA">[o]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">o</em></span>. As in the French <span xml:lang="fr" class="quote" lang="fr">«&nbsp;<span class="quote">haute (cuisine)</span>&nbsp;»</span> or Spanish <span xml:lang="es" class="quote" lang="es">“<span class="quote">como</span>”</span>. There is no exact English equivalent of this sound. The nearest GA equivalent is the <span class="quote">“<span class="quote">o</span>”</span> of <span class="quote">“<span class="quote">dough</span>”</span> or <span class="quote">“<span class="quote">joke</span>”</span> , but it is essential that the off-glide (a <span class="IPA">[w]</span> -like sound) at the end of the vowel is not pronounced when speaking Lojban. The RP sound in these words is <span class="IPA">[əw]</span> in IPA terms, and has no <span class="IPA">[o]</span> in it at all; unless you can speak with a Scots, Irish, or American accent, you may have trouble with this sound.</td></tr><tr><td><span class="IPA">[ɔ]</span></td><td>An allowed variant of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">o</em></span> , especially before <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">r</em></span>. This sound is a shortened form of the <span class="quote">“<span class="quote">aw</span>”</span> in GA <span class="quote">“<span class="quote">dawn</span>”</span> (for those people who don't pronounce <span class="quote">“<span class="quote">dawn</span>”</span> and <span class="quote">“<span class="quote">Don</span>”</span> alike; if you do, you may have trouble with this sound). In RP, but not GA, it is the <span class="quote">“<span class="quote">o</span>”</span> of <span class="quote">“<span class="quote">hot</span>”</span>.</td></tr><tr><td><span class="IPA">[p]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">p</em></span>. As in English <span class="quote">“<span class="quote">pay</span>”</span> , <span class="quote">“<span class="quote">super</span>”</span> , or <span class="quote">“<span class="quote">up</span>”</span>.</td></tr><tr><td><span class="IPA">[r]</span></td><td>One version of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">r</em></span>. Not an English sound. The Spanish <span xml:lang="es" class="quote" lang="es">“<span class="quote">rr</span>”</span> and the Scots <span class="quote">“<span class="quote">r</span>”</span> , a tongue-tip trill.</td></tr><tr><td><span class="IPA">[ɹ]</span></td><td>One version of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">r</em></span>. As in GA <span class="quote">“<span class="quote">right</span>”</span> , <span class="quote">“<span class="quote">baron</span>”</span> , or <span class="quote">“<span class="quote">car</span>”</span>. Not found in RP.</td></tr><tr><td><span class="IPA">[ɾ]</span></td><td>One version of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">r</em></span>. In GA, appears as a variant of <span class="quote">“<span class="quote">t</span>”</span> or <span class="quote">“<span class="quote">d</span>”</span> in the words <span class="quote">“<span class="quote">metal</span>”</span> and <span class="quote">“<span class="quote">medal</span>”</span> respectively. A tongue-tip flap.</td></tr><tr><td><span class="IPA">[ʀ]</span></td><td>One version of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">r</em></span>. Not an English sound. The French or German <span xml:lang="de" class="phrase" lang="de"><span xml:lang="fr" class="quote" lang="fr">«&nbsp;<span class="quote">r</span>&nbsp;»</span></span> in <span xml:lang="fr" class="quote" lang="fr">«&nbsp;<span class="quote">reine</span>&nbsp;»</span> or <span xml:lang="de" class="quote" lang="de">„<span class="quote">rot</span>“</span> respectively. A uvular trill.</td></tr><tr><td><span class="IPA">[r̩]</span> , <span class="IPA">[ɹ̩]</span> , <span class="IPA">[ʀ̩]</span></td><td>Syllabic versions of the above. <span class="IPA">[ɹ̩]</span> appears in the GA (but not RP) pronunciation of <span class="quote">“<span class="quote">bird</span>”</span>.</td></tr><tr><td><span class="IPA">[s]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">s</em></span>. As in English <span class="quote">“<span class="quote">so</span>”</span> , <span class="quote">“<span class="quote">basin</span>”</span> , or <span class="quote">“<span class="quote">yes</span>”</span>.</td></tr><tr><td><span class="IPA">[ʃ]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">c</em></span>. The <span class="quote">“<span class="quote">sh</span>”</span> of English <span class="quote">“<span class="quote">ship</span>”</span> , <span class="quote">“<span class="quote">ashen</span>”</span> , or <span class="quote">“<span class="quote">dish</span>”</span>.</td></tr><tr><td><span class="IPA">[ʂ]</span></td><td>An allowed variant of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">c</em></span>. Not an English sound. The Hindi retroflex <span xml:lang="hi" class="quote" lang="hi">“<span class="quote">s</span>”</span> with dot below, or Klingon <span xml:lang="tlh" class="quote" lang="tlh">“<span class="quote">S</span>”</span>.</td></tr><tr><td><span class="IPA">[t]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">t</em></span>. As in English <span class="quote">“<span class="quote">tea</span>”</span> , <span class="quote">“<span class="quote">later</span>”</span> , or <span class="quote">“<span class="quote">not</span>”</span>. It is important to avoid the GA habit of pronouncing the <span class="quote">“<span class="quote">t</span>”</span> between vowels as <span class="IPA">[d]</span> or <span class="IPA">[ɾ]</span>.</td></tr><tr><td><span class="IPA">[θ]</span></td><td>Not normally a Lojban sound, but a possible variant of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">'</em></span>. The <span class="quote">“<span class="quote">th</span>”</span> of English <span class="quote">“<span class="quote">thin</span>”</span> (but not <span class="quote">“<span class="quote">then</span>”</span>).</td></tr><tr><td><span class="IPA">[u]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">u</em></span>. As in the French <span xml:lang="fr" class="quote" lang="fr">«&nbsp;<span class="quote">boule</span>&nbsp;»</span> or German <span xml:lang="de" class="quote" lang="de">„<span class="quote">Stuhl</span>“</span>. There is no exact English equivalent of this sound. The nearest sound appears in <span class="quote">“<span class="quote">boot</span>”</span> or <span class="quote">“<span class="quote">cool</span>”</span>, but many dialects pronounce these with an off-glide, which should not be present when speaking Lojban.</td></tr><tr><td><span class="IPA">[v]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">v</em></span>. As in English <span class="quote">“<span class="quote">voice</span>”</span> , <span class="quote">“<span class="quote">savor</span>”</span> , or <span class="quote">“<span class="quote">live</span>”</span>.</td></tr><tr><td><span class="IPA">[w]</span></td><td>Used in Lojban diphthongs beginning or ending with <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">u</em></span>. Like the <span class="quote">“<span class="quote">w</span>”</span> in English <span class="quote">“<span class="quote">wet</span>”</span> <span class="IPA">[wɛt]</span> or <span class="quote">“<span class="quote">cow</span>”</span> <span class="IPA">[kɑw]</span>.</td></tr><tr><td><span class="IPA">[x]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">x</em></span>. Not normally an English sound, but used in some pronunciations of <span class="quote">“<span class="quote">loch</span>”</span> and <span class="quote">“<span class="quote">Bach</span>”</span> ; <span class="quote">“<span class="quote">gh</span>”</span> in Scots <span class="quote">“<span class="quote">might</span>”</span> and <span class="quote">“<span class="quote">night</span>”</span>. The German <span xml:lang="de" class="quote" lang="de">„<span class="quote">Ach-Laut</span>“</span>. To pronounce <span class="IPA">[x]</span> , force air through your throat without vibrating your vocal chords; there should be lots of scrape.</td></tr><tr><td><span class="IPA">[ʏ]</span></td><td>A possible Lojban buffer vowel. Not an English sound: the <span xml:lang="de" class="quote" lang="de">„<span class="quote">ü</span>“</span> of German <span xml:lang="de" class="quote" lang="de">„<span class="quote">hübsch</span>“</span>.</td></tr><tr><td><span class="IPA">[z]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">z</em></span>. As in English <span class="quote">“<span class="quote">zoo</span>”</span> , <span class="quote">“<span class="quote">hazard</span>”</span> , or <span class="quote">“<span class="quote">fizz</span>”</span>.</td></tr><tr><td><span class="IPA">[ʒ]</span></td><td>The preferred pronunciation of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">j</em></span>. The <span class="quote">“<span class="quote">si</span>”</span> of English <span class="quote">“<span class="quote">vision</span>”</span> , or the consonant at the end of GA <span class="quote">“<span class="quote">garage</span>”</span>.</td></tr><tr><td><span class="IPA">[ʐ]</span></td><td>An allowed variant of Lojban <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">j</em></span>. Not an English sound. The voiced version of <span class="IPA">[ʂ]</span>.</td></tr></tbody></table>