<a id="section-alien-alphabets"></a>17.5. <a id="c17s5"></a>Alien alphabets
---------------------------------------------------------------------------

As stated in [Section 17.1](../chapter-letterals#section-letterals-introduction) , Lojban's goal of cultural neutrality demands a standard set of lerfu words for the lerfu of as many other writing systems as possible. When we meet these lerfu in written text (particularly, though not exclusively, mathematical text), we need a standard Lojbanic way to pronounce them.

There are certainly hundreds of alphabets and other writing systems in use around the world, and it is probably an unachievable goal to create a single system which can express all of them, but if perfection is not demanded, a usable system can be created from the raw material which Lojban provides.

<a id="id-1.18.7.4.1" class="indexterm"></a><a id="id-1.18.7.4.2" class="indexterm"></a>One possibility would be to use the lerfu word associated with the language itself, Lojbanized and with _<a id="id-1.18.7.4.3.1" class="indexterm"></a>[_bu_](../go01#valsi-bu)_ added. Indeed, an isolated Greek “alpha” in running Lojban text is probably most easily handled by calling it _<a id="id-1.18.7.4.5.1" class="indexterm"></a>.alfas. bu_. Here the Greek lerfu word has been made into a Lojbanized name by adding _s_ and then into a Lojban lerfu word by adding _<a id="id-1.18.7.4.7.1" class="indexterm"></a>[_bu_](../go01#valsi-bu)_. Note that the pause after _<a id="id-1.18.7.4.8.1" class="indexterm"></a>.alfas._ is still needed.

<a id="id-1.18.7.5.1" class="indexterm"></a>Likewise, the easiest way to handle the Latin letters “h” , “q” , and “w” that are not used in Lojban is by a consonant lerfu word with _<a id="id-1.18.7.5.5.1" class="indexterm"></a>[_bu_](../go01#valsi-bu)_ attached. The following assignments have been made:

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.18.7.6.2.1.1.1" class="indexterm"></a>.y'y.bu</em></span></td><td><p>h</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.18.7.6.3.1.1.1" class="indexterm"></a>ky.bu</em></span></td><td><p>q</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.18.7.6.4.1.1.1" class="indexterm"></a>vy.bu</em></span></td><td><p>w</p></td></tr></tbody></table>

As an example, the English word “quack” would be spelled in Lojban thus:

<div class="interlinear-gloss-example example">
<a id="example-random-id-0oAR"></a>

**Example 17.11. <a id="c17e5d1"></a><a id="id-1.18.7.8.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ky.bu</td><td>.ubu</td><td>.abu</td><td>cy.</td><td>ky.</td></tr><tr class="gloss"><td>q</td><td>u</td><td>a</td><td>c</td><td>k</td></tr></tbody></table>

</div>  

<a id="id-1.18.7.9.1" class="indexterm"></a><a id="id-1.18.7.9.2" class="indexterm"></a>Note that the fact that the letter “c” in this word has nothing to do with the sound of the Lojban letter _c_ is irrelevant; we are spelling an English word and English rules control the choice of letters, but we are speaking Lojban and Lojban rules control the pronunciations of those letters.

A few more possibilities for Latin-alphabet letters used in languages other than English:

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.18.7.11.2.1.1.1" class="indexterm"></a>ty.bu</em></span></td><td><p>þ (thorn)</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.18.7.11.3.1.1.1" class="indexterm"></a>dy.bu</em></span></td><td><p>ð (edh)</p></td></tr></tbody></table>

However, this system is not ideal for all purposes. For one thing, it is verbose. The native lerfu words are often quite long, and with _<a id="id-1.18.7.12.1.1" class="indexterm"></a>[_bu_](../go01#valsi-bu)_ added they become even longer: the worst-case Greek lerfu word would be _<a id="id-1.18.7.12.2.1" class="indexterm"></a>.Omikron. bu_ , with four syllables and two mandatory pauses. In addition, alphabets that are used by many languages have separate sets of lerfu words for each language, and which set is Lojban to choose?

<a id="id-1.18.7.13.1" class="indexterm"></a><a id="id-1.18.7.13.2" class="indexterm"></a><a id="id-1.18.7.13.3" class="indexterm"></a><a id="id-1.18.7.13.4" class="indexterm"></a><a id="id-1.18.7.13.5" class="indexterm"></a>The alternative plan, therefore, is to use a shift word similar to those introduced in [Section 17.3](../section-upper-case). After the appearance of such a shift word, the regular lerfu words are re-interpreted to represent the lerfu of the alphabet now in use. After a shift to the Greek alphabet, for example, the lerfu word _<a id="id-1.18.7.13.7.1" class="indexterm"></a>[_ty._](../go01#valsi-ty)_ would represent not Latin “t” but Greek “tau”. Why “tau” ? Because it is, in some sense, the closest counterpart of “t” within the Greek lerfu system. In principle it would be all right to map _<a id="id-1.18.7.13.12.1" class="indexterm"></a>[_ty._](../go01#valsi-ty)_ to “phi” or even “omega” , but such an arbitrary relationship would be extremely hard to remember.

<a id="id-1.18.7.14.1" class="indexterm"></a><a id="id-1.18.7.14.2" class="indexterm"></a>Where no obvious closest counterpart exists, some more or less arbitrary choice must be made. Some alien lerfu may simply not have any shifted equivalent, forcing the speaker to fall back on a _<a id="id-1.18.7.14.3.1" class="indexterm"></a>[_bu_](../go01#valsi-bu)_ form. Since a _<a id="id-1.18.7.14.4.1" class="indexterm"></a>[_bu_](../go01#valsi-bu)_ form may mean different things in different alphabets, it is safest to employ a shift word even when _<a id="id-1.18.7.14.5.1" class="indexterm"></a>[_bu_](../go01#valsi-bu)_ forms are in use.

Shifts for several alphabets have been assigned cmavo of selma'o BY:

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.18.7.16.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-loha"><em class="glossterm">lo'a</em></a></em></span></td><td><p>Latin/Roman/Lojban alphabet</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.18.7.16.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-geho"><em class="glossterm">ge'o</em></a></em></span></td><td><p>Greek alphabet</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.18.7.16.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-jeho"><em class="glossterm">je'o</em></a></em></span></td><td><p>Hebrew alphabet</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.18.7.16.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-joho"><em class="glossterm">jo'o</em></a></em></span></td><td><p>Arabic alphabet</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.18.7.16.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ruho"><em class="glossterm">ru'o</em></a></em></span></td><td><p>Cyrillic alphabet</p></td></tr></tbody></table>

<a id="id-1.18.7.17.1" class="indexterm"></a><a id="id-1.18.7.17.2" class="indexterm"></a><a id="id-1.18.7.17.3" class="indexterm"></a><a id="id-1.18.7.17.4" class="indexterm"></a><a id="id-1.18.7.17.5" class="indexterm"></a><a id="id-1.18.7.17.6" class="indexterm"></a><a id="id-1.18.7.17.7" class="indexterm"></a><a id="id-1.18.7.17.8" class="indexterm"></a>The cmavo _<a id="id-1.18.7.17.9.1" class="indexterm"></a>[_zai_](../go01#valsi-zai)_ (of selma'o LAU) is used to create shift words to still other alphabets. The BY word which must follow any LAU cmavo would typically be a name representing the alphabet with _<a id="id-1.18.7.17.10.1" class="indexterm"></a>[_bu_](../go01#valsi-bu)_ suffixed:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qHT3"></a>

**Example 17.12. <a id="c17e5d2"></a><a id="id-1.18.7.18.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">zai .devanagar. bu</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Devanagari (Hindi) alphabet</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qhTV"></a>

**Example 17.13. <a id="c17e5d3"></a><a id="id-1.18.7.19.1.2" class="indexterm"></a><a id="id-1.18.7.19.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">zai .katakan. bu</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Japanese katakana syllabary</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qhud"></a>

**Example 17.14. <a id="c17e5d4"></a><a id="id-1.18.7.20.1.2" class="indexterm"></a><a id="id-1.18.7.20.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">zai .xiragan. bu</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Japanese hiragana syllabary</p></td></tr></tbody></table>

</div>  

<a id="id-1.18.7.21.1" class="indexterm"></a>Unlike the cmavo above, these shift words have not been standardized and probably will not be until someone actually has a need for them. (Note the _._ characters marking leading and following pauses.)

<a id="id-1.18.7.22.1" class="indexterm"></a><a id="id-1.18.7.22.2" class="indexterm"></a><a id="id-1.18.7.22.3" class="indexterm"></a><a id="id-1.18.7.22.4" class="indexterm"></a><a id="id-1.18.7.22.5" class="indexterm"></a><a id="id-1.18.7.22.6" class="indexterm"></a>In addition, there may be multiple visible representations within a single alphabet for a given letter: roman vs. italics, handwriting vs. print, Baskerville vs. Comic. These traditional “font and face” distinctions are also represented by shift words, indicated with the cmavo _<a id="id-1.18.7.22.8.1" class="indexterm"></a>[_ce'a_](../go01#valsi-ceha)_ (of selma'o LAU) and a following BY word:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qhV0"></a>

**Example 17.15. <a id="c17e5d5"></a><a id="id-1.18.7.23.1.2" class="indexterm"></a><a id="id-1.18.7.23.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">ce'a .komik. bu</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Comic font</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qhv2"></a>

**Example 17.16. <a id="c17e5d6"></a><a id="id-1.18.7.24.1.2" class="indexterm"></a><a id="id-1.18.7.24.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">ce'a .xancisk. bu</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">handwriting</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qhVb"></a>

**Example 17.17. <a id="c17e5d7"></a><a id="id-1.18.7.25.1.2" class="indexterm"></a><a id="id-1.18.7.25.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">ce'a .pavrel. bu</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">12-point font size</p></td></tr></tbody></table>

</div>  

<a id="id-1.18.7.26.1" class="indexterm"></a><a id="id-1.18.7.26.2" class="indexterm"></a><a id="id-1.18.7.26.3" class="indexterm"></a><a id="id-1.18.7.26.4" class="indexterm"></a>The cmavo _<a id="id-1.18.7.26.5.1" class="indexterm"></a>[_na'a_](../go01#valsi-naha)_ (of selma'o BY) is a universal shift-word cancel: it returns the interpretation of lerfu words to the default of lower-case Lojban with no specific font. It is more general than _<a id="id-1.18.7.26.6.1" class="indexterm"></a>[_lo'a_](../go01#valsi-loha)_ , which changes the alphabet only, potentially leaving font and case shifts in place.

Several sections at the end of this chapter contain tables of proposed lerfu word assignments for various languages.