<a id="section-afterthought-connectives-grouping"></a>14.8. <a id="c14s8"></a>Grouping of afterthought connectives
------------------------------------------------------------------------------------------------------------------

<a id="id-1.15.10.2.1" class="indexterm"></a><a id="id-1.15.10.2.2" class="indexterm"></a><a id="id-1.15.10.2.3" class="indexterm"></a>There are several ways in Lojban to render [Example 14.35](../section-more-propositions#example-random-id-BSuT) using afterthought only. The simplest method is to make use of the cmavo _<a id="id-1.15.10.2.5.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ (of selma'o BO). This cmavo has several functions in Lojban, but is always associated with high precedence and short scope. In particular, if _<a id="id-1.15.10.2.6.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ is placed after an ijek, the result is a grammatically distinct kind of ijek which overrides the regular left-grouping rule. Connections marked with _<a id="id-1.15.10.2.7.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ are interpreted before connections not so marked. [Example 14.39](../section-afterthought-connectives-grouping#example-random-id-Uu7D) is equivalent in meaning to [Example 14.38](../section-more-propositions#example-random-id-1Dd2) :

<div class="interlinear-gloss-example example">
<a id="example-random-id-Uu7D"></a>

**Example 14.39. <a id="c14e8d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nelci</td><td>la</td><td>.djan.</td><td>.ije</td><td>mi</td><td>nelci</td><td>la</td><td>.martas.</td></tr><tr class="gloss"><td>I</td><td>like</td><td>that-named</td><td>John,</td><td>and</td><td>I</td><td>like</td><td>that-named</td><td>Martha</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ijabo</td><td>mi</td><td>nelci</td><td>la</td><td>.meris.</td></tr><tr class="gloss"><td>or</td><td>I</td><td>like</td><td>that-named</td><td>Mary.</td></tr></tbody></table>

</div>  

The English translation feebly indicates with a comma what the Lojban marks far more clearly: the “I like Martha” and “I like Mary” sentences are joined by _<a id="id-1.15.10.4.3.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ _<a id="id-1.15.10.4.4.1" class="indexterm"></a>[_ja_](../go01#valsi-ja)_ first, before the result is joined to “I like John” by _<a id="id-1.15.10.4.6.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ _<a id="id-1.15.10.4.7.1" class="indexterm"></a>[_je_](../go01#valsi-je)_.

Eks can have _<a id="id-1.15.10.5.1.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ attached in exactly the same way, so that [Example 14.40](../section-afterthought-connectives-grouping#example-random-id-JVhK) is equivalent in meaning to [Example 14.39](../section-afterthought-connectives-grouping#example-random-id-Uu7D) :

<div class="interlinear-gloss-example example">
<a id="example-random-id-JVhK"></a>

**Example 14.40. <a id="c14e8d2"></a>** 

<a id="id-1.15.10.6.2.1" class="indexterm"></a>mi nelci la .djan. .e la .martas. .abo la .meris.

</div>  

<a id="id-1.15.10.7.1" class="indexterm"></a><a id="id-1.15.10.7.2" class="indexterm"></a>Forethought connectives, however, never can be suffixed with _<a id="id-1.15.10.7.3.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ , for every use of forethought connectives clearly indicates the intended pattern of grouping.

What happens if _<a id="id-1.15.10.8.1.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ is used on both connectives, giving them the same high precedence, as in [Example 14.41](../section-afterthought-connectives-grouping#example-random-id-YJeE) ?

<div class="interlinear-gloss-example example">
<a id="example-random-id-YJeE"></a>

**Example 14.41. <a id="c14e8d3"></a>** 

<a id="id-1.15.10.9.2.1" class="indexterm"></a>mi nelci la .djan. .ebo la .martas. .abo la .meris.

</div>  

<a id="id-1.15.10.10.1" class="indexterm"></a><a id="id-1.15.10.10.2" class="indexterm"></a>Does this wind up meaning the same as [Example 14.34](../section-more-propositions#example-random-id-mLo1) and [Example 14.36](../section-more-propositions#example-random-id-dPcI) ? Not at all. A second rule relating to _<a id="id-1.15.10.10.5.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ is that where several _<a id="id-1.15.10.10.6.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ -marked connectives are used in succession, the normal Lojban left-grouping rule is replaced by a right-grouping rule. As a result, [Example 14.41](../section-afterthought-connectives-grouping#example-random-id-YJeE) in fact means the same as [Example 14.39](../section-afterthought-connectives-grouping#example-random-id-Uu7D) and [Example 14.40](../section-afterthought-connectives-grouping#example-random-id-JVhK). This rule may be occasionally exploited for special effects, but is tricky to keep straight; in writing intended to be easy to understand, multiple consecutive connectives marked with _<a id="id-1.15.10.10.10.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ should be avoided.

<a id="id-1.15.10.11.1" class="indexterm"></a><a id="id-1.15.10.11.2" class="indexterm"></a><a id="id-1.15.10.11.3" class="indexterm"></a>The use of _<a id="id-1.15.10.11.4.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ , therefore, gets tricky in complex connections of more than three sentences. Looking back at the English translations of [Example 14.37](../section-more-propositions#example-random-id-487z) and [Example 14.38](../section-more-propositions#example-random-id-1Dd2) , parentheses were used to clarify the grouping. These parentheses have their Lojban equivalents, two sets of them actually. _<a id="id-1.15.10.11.7.1" class="indexterm"></a>[_tu'e_](../go01#valsi-tuhe)_ and _<a id="id-1.15.10.11.8.1" class="indexterm"></a>[_tu'u_](../go01#valsi-tuhu)_ are used with ijeks, and _<a id="id-1.15.10.11.9.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ and _<a id="id-1.15.10.11.10.1" class="indexterm"></a>[_ke'e_](../go01#valsi-kehe)_ with eks and other connectives to be discussed later. ( _<a id="id-1.15.10.11.11.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ and _<a id="id-1.15.10.11.12.1" class="indexterm"></a>[_ke'e_](../go01#valsi-kehe)_ are also used in other roles in the language, but always as grouping markers). Consider the English sentence:

<div class="example">
<a id="example-random-id-aqIg"></a>

**Example 14.42. <a id="c14e8d4"></a>** 

I kiss you and you kiss me, if I love you and you love me.

</div>  

<a id="id-1.15.10.13.1" class="indexterm"></a>where the semantics tells us that the instances of “and” are meant to have higher precedence than that of “if”. If we wish to express [Example 14.42](../section-afterthought-connectives-grouping#example-random-id-aqIg) in afterthought, we can say:

<div class="interlinear-gloss-example example">
<a id="example-random-id-1PSK"></a>

**Example 14.43. <a id="c14e8d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cinba</td><td>do</td><td>.ije[bo]</td><td>do</td><td>cinba</td><td>mi</td></tr><tr class="gloss"><td>I</td><td>kiss</td><td>you</td><td>and</td><td>you</td><td>kiss</td><td>me,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ijanai</td><td>mi</td><td>prami</td><td>do</td><td>.ijebo</td><td>do</td><td>prami</td><td>mi</td></tr><tr class="gloss"><td>if</td><td>I</td><td>love</td><td>you</td><td>and</td><td>you</td><td>love</td><td>me.</td></tr></tbody></table>

</div>  

marking two of the ijeks with _<a id="id-1.15.10.15.1.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ for high precedence. (The first _<a id="id-1.15.10.15.2.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ is not strictly necessary, because of the left-grouping rule, and is shown here in brackets.)

<a id="id-1.15.10.16.1" class="indexterm"></a>But it may be clearer to use explicit parenthesis words and say:

<div class="interlinear-gloss-example example">
<a id="example-random-id-erTb"></a>

**Example 14.44. <a id="c14e8d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>tu'e</td><td>mi</td><td>cinba</td><td>do</td><td>.ije</td><td>do</td><td>cinba</td><td>mi</td><td>tu'u</td></tr><tr class="gloss"><td>(</td><td>I</td><td>kiss</td><td>you</td><td>and</td><td>you</td><td>kiss</td><td>me</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ijanai</td><td>tu'e</td><td>mi</td><td>prami</td><td>do</td><td>.ije</td><td>do</td><td>prami</td><td>mi</td><td>[tu'u]</td></tr><tr class="gloss"><td>if</td><td>(</td><td>I</td><td>love</td><td>you</td><td>and</td><td>you</td><td>love</td><td>me</td><td>).</td></tr></tbody></table>

</div>  

where the _<a id="id-1.15.10.18.1.1" class="indexterm"></a>[_tu'e_](../go01#valsi-tuhe)_ … _<a id="id-1.15.10.18.2.1" class="indexterm"></a>[_tu'u_](../go01#valsi-tuhu)_ pairs set off the structure. The cmavo _<a id="id-1.15.10.18.3.1" class="indexterm"></a>[_tu'u_](../go01#valsi-tuhu)_ is an elidable terminator, and its second occurrence in [Example 14.44](../section-afterthought-connectives-grouping#example-random-id-erTb) is bracketed, because all terminators may be elided at the end of a text.

In addition, parentheses are a general solution: multiple parentheses may be nested inside one another, and additional afterthought material may be added without upsetting the existing structure. Neither of these two advantages apply to _<a id="id-1.15.10.19.1.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ grouping. In general, afterthought constructions trade generality for simplicity.

Because of the left-grouping rule, the first set of _<a id="id-1.15.10.20.1.1" class="indexterm"></a>[_tu'e_](../go01#valsi-tuhe)_ … _<a id="id-1.15.10.20.2.1" class="indexterm"></a>[_tu'u_](../go01#valsi-tuhu)_ parentheses may actually be left off altogether, producing:

<div class="interlinear-gloss-example example">
<a id="example-random-id-QGBz"></a>

**Example 14.45. <a id="c14e8d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cinba</td><td>do</td><td>.ije</td><td>do</td><td>cinba</td><td>mi</td></tr><tr class="gloss"><td>I</td><td>kiss</td><td>you</td><td>and</td><td>you</td><td>kiss</td><td>me</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ijanai</td><td>tu'e</td><td>mi</td><td>prami</td><td>do</td><td>.ije</td><td>do</td><td>prami</td><td>mi</td><td>[tu'u]</td></tr><tr class="gloss"><td>if</td><td>(</td><td>I</td><td>love</td><td>you</td><td>and</td><td>you</td><td>love</td><td>me</td><td>).</td></tr></tbody></table>

</div>  

What about parenthesized sumti connection? Consider

<div class="example">
<a id="example-random-id-y9CC"></a>

**Example 14.46. <a id="c14e8d8"></a>** 

I walk to either the market and the house, or the school and the office.

</div>  

<a id="id-1.15.10.24.1" class="indexterm"></a><a id="id-1.15.10.24.2" class="indexterm"></a><a id="id-1.15.10.24.3" class="indexterm"></a>Two pairs of parentheses, analogous to [Example 14.44](../section-afterthought-connectives-grouping#example-random-id-erTb) , would seem to be the right approach. However, it is a rule of Lojban grammar that a sumti may not begin with _<a id="id-1.15.10.24.5.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ , so the first set of parentheses must be omitted, producing [Example 14.47](../section-afterthought-connectives-grouping#example-random-id-0mJM) , which is instead parallel to [Example 14.45](../section-afterthought-connectives-grouping#example-random-id-QGBz) :

<div class="interlinear-gloss-example example">
<a id="example-random-id-0mJM"></a>

**Example 14.47. <a id="c14e8d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>dzukla</td><td>le</td><td>zarci</td><td>.e</td><td>le</td><td>zdani</td></tr><tr class="gloss"><td>I</td><td>walk-to</td><td>the</td><td>market</td><td>and</td><td>the</td><td>house</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.a</td><td>ke</td><td>le</td><td>ckule</td><td>.e</td><td>le</td><td>briju</td><td>[ke'e]</td></tr><tr class="gloss"><td>or</td><td>(</td><td>the</td><td>school</td><td>and</td><td>the</td><td>office</td><td>).</td></tr></tbody></table>

</div>  

<a id="id-1.15.10.26.1" class="indexterm"></a>If sumti were allowed to begin with _<a id="id-1.15.10.26.2.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ , unavoidable ambiguities would result, so _<a id="id-1.15.10.26.3.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ grouping of sumti is allowed only just after a logical connective. This rule does not apply to _<a id="id-1.15.10.26.4.1" class="indexterm"></a>[_tu'e_](../go01#valsi-tuhe)_ grouping of bridi, as [Example 14.44](../section-afterthought-connectives-grouping#example-random-id-erTb) shows.

Now we have enough facilities to handle the problem of [Example 14.33](../section-more-propositions#example-random-id-3zE1) : “I am German, rich, and a man – or else none of these.” The following paraphrase has the correct meaning:

<div class="interlinear-gloss-example example">
<a id="example-random-id-KyHw"></a>

**Example 14.48. <a id="c14e8d10"></a><a id="id-1.15.10.28.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>[tu'e]</td><td>mi</td><td>dotco</td><td>.ijo</td><td>mi</td><td>ricfu</td><td>[tu'u]</td></tr><tr class="gloss"><td>(</td><td>I</td><td>am-German</td><td>if-and-only-if</td><td>I</td><td>am-rich</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ije</td><td>tu'e</td><td>mi</td><td>dotco</td><td>.ijo</td><td>mi</td><td>nanmu</td><td>[tu'u]</td></tr><tr class="gloss"><td>and</td><td>(</td><td>I</td><td>am-German</td><td>if-and-only-if</td><td>I</td><td>am-a-man</td><td>).</td></tr></tbody></table>

</div>  

The truth table, when worked out, produces T if and only if all three component sentences are true or all three are false.