<a id="section-acronyms"></a>17.12. <a id="c17s12"></a>Acronyms
---------------------------------------------------------------

<a id="id-1.18.14.2.1" class="indexterm"></a>An acronym is a name constructed of lerfu. English examples are “DNA” , “NATO” , “CIA”. In English, some of these are spelled out (like “DNA” and “CIA”) and others are pronounced more or less as if they were ordinary English words (like “NATO”). Some acronyms fluctuate between the two pronunciations: “SQL” may be “ess cue ell” or “sequel”.

<a id="id-1.18.14.3.1" class="indexterm"></a><a id="id-1.18.14.3.2" class="indexterm"></a>In Lojban, a name is often represented by one cmevla (a word that ends in a consonant and is surrounded by pauses). The easiest way to Lojbanize acronym names is to glue the lerfu words together, using _'_ wherever two vowels would come together (pauses are illegal in cmevla) and adding a final consonant:

<div class="interlinear-gloss-example example">
<a id="example-random-id-736i"></a>

**Example 17.40. <a id="c17e12d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">la .dyny'abub. .i la .ny'abuty'obub. .i la .cy'ibu'abub.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">DNA. NATO. CIA.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">… .i la .sykybulyl. .i la .ibubymym. .i la .ny'ybucyc.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">… SQL. IBM. NYC.</p></td></tr></tbody></table>

</div>  

<a id="id-1.18.14.5.1" class="indexterm"></a>There is no fixed convention for assigning the final consonant. In [Example 17.40](../section-acronyms#example-random-id-736i) , the last consonant of the lerfu string has been replicated into final position.

<a id="id-1.18.14.6.1" class="indexterm"></a><a id="id-1.18.14.6.2" class="indexterm"></a>Some compression can be done by leaving out _<a id="id-1.18.14.6.3.1" class="indexterm"></a>[_bu_](../go01#valsi-bu)_ after vowel lerfu words (except for _<a id="id-1.18.14.6.4.1" class="indexterm"></a>[_.ybu_](../go01#valsi-ybu)_ , wherein the _<a id="id-1.18.14.6.5.1" class="indexterm"></a>[_bu_](../go01#valsi-bu)_ cannot be omitted without ambiguity). Compression is moderately important because it's hard to say long cmevla without introducing an involuntary (and illegal) pause:

<div class="interlinear-gloss-example example">
<a id="example-random-id-0sin"></a>

**Example 17.41. <a id="c17e12d2"></a><a id="id-1.18.14.7.1.2" class="indexterm"></a><a id="id-1.18.14.7.1.3" class="indexterm"></a><a id="id-1.18.14.7.1.4" class="indexterm"></a><a id="id-1.18.14.7.1.5" class="indexterm"></a><a id="id-1.18.14.7.1.6" class="indexterm"></a><a id="id-1.18.14.7.1.7" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">la .dyny'am. .i la .ny'aty'om. .i la .cy'i'am.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">DNA. NATO. CIA.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">… .i la .sykybulym. .i la .ibymym. .i la .ny'ybucym.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">… SQL. IBM. NYC.</p></td></tr></tbody></table>

</div>  

In [Example 17.41](../section-acronyms#example-random-id-0sin) , the final consonant _m_ stands for _<a id="id-1.18.14.8.3.1" class="indexterm"></a>[_merko_](../go01#valsi-merko)_ , indicating the source culture of these acronyms.

<a id="id-1.18.14.9.1" class="indexterm"></a><a id="id-1.18.14.9.2" class="indexterm"></a>Another approach, which some may find easier to say and which is compatible with older versions of the language that did not have a _'_ character, is to use the consonant _z_ instead of _'_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-Js6m"></a>

**Example 17.42. <a id="c17e12d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">la .dynyzaz. .i la .nyzatyzoz. .i la .cyzizaz.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">DNA. NATO. CIA.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">… .i la .sykybulyz. .i la .ibymyz. .i la .nyzybucyz.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">… SQL. IBM. NYC.</p></td></tr></tbody></table>

</div>  

<a id="id-1.18.14.11.1" class="indexterm"></a><a id="id-1.18.14.11.2" class="indexterm"></a>One more alternative to these lengthy cmevla is to use the lerfu string itself prefixed with _<a id="id-1.18.14.11.3.1" class="indexterm"></a>[_me_](../go01#valsi-me)_ , the cmavo that makes sumti into selbri:

<div class="interlinear-gloss-example example">
<a id="example-random-id-iMRB"></a>

**Example 17.43. <a id="c17e12d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>me</td><td>dy</td><td>ny.</td><td>.abu</td></tr><tr class="gloss"><td>that-named</td><td>what-pertains-to</td><td><span class="quote">“<span class="quote">d</span>”</span></td><td><span class="quote">“<span class="quote">n</span>”</span></td><td><span class="quote">“<span class="quote">a</span>”</span></td></tr></tbody></table>

</div>  

This works because _<a id="id-1.18.14.13.1.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ , the cmavo that normally introduces cmevla used as sumti, may also be used before a predicate to indicate that the predicate is a (meaningful) name:

<div class="interlinear-gloss-example example">
<a id="example-random-id-7KLi"></a>

**Example 17.44. <a id="c17e12d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>cribe</td><td>cu</td><td>ciska</td></tr><tr class="gloss"><td>That-named</td><td><span class="quote">“<span class="quote">Bear</span>”</span></td><td>&nbsp;</td><td>writes.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Bear is a writer.</p></td></tr></tbody></table>

</div>  

[Example 17.44](../section-acronyms#example-random-id-7KLi) does not of course refer to a bear ( _<a id="id-1.18.14.15.2.1" class="indexterm"></a>le cribe_ or _<a id="id-1.18.14.15.3.1" class="indexterm"></a>lo cribe_) but to something else, probably a person, named “Bear”. Similarly, _<a id="id-1.18.14.15.5.1" class="indexterm"></a>me dy ny. .abu_ is a predicate which can be used as a name, producing a kind of acronym which can have pauses between the individual lerfu words.