<a id="section-SE"></a>9.4. <a id="c9s4"></a>Conversion: SE
-----------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">se</p></td><td class="selmaho"><p class="selmaho">SE</p></td><td class="description"><p class="description">2nd place conversion</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">te</p></td><td class="selmaho"><p class="selmaho">SE</p></td><td class="description"><p class="description">3rd place conversion</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ve</p></td><td class="selmaho"><p class="selmaho">SE</p></td><td class="description"><p class="description">4th place conversion</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">xe</p></td><td class="selmaho"><p class="selmaho">SE</p></td><td class="description"><p class="description">5th place conversion</p></td></tr></tbody></table>

<a id="id-1.10.6.4.1" class="indexterm"></a><a id="id-1.10.6.4.2" class="indexterm"></a><a id="id-1.10.6.4.3" class="indexterm"></a><a id="id-1.10.6.4.4" class="indexterm"></a><a id="id-1.10.6.4.5" class="indexterm"></a><a id="id-1.10.6.4.6" class="indexterm"></a>So far we have seen ways to move sumti around within a bridi, but the actual place structure of the selbri has always remained untouched. The conversion cmavo of selma'o SE are incorporated within the selbri itself, and produce a new selbri (called a converted selbri) with a different place structure. In particular, after the application of any SE cmavo, the number and purposes of the places remain the same, but two of them have been exchanged, the x1 place and another. Which place has been exchanged with x1 depends on the cmavo chosen. Thus, for example, when _<a id="id-1.10.6.4.9.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ is used, the x1 place is swapped with the x2 place.

<a id="id-1.10.6.5.1" class="indexterm"></a><a id="id-1.10.6.5.2" class="indexterm"></a>Note that the cmavo of SE begin with consecutive consonants in alphabetical order. There is no “1st place conversion” cmavo, because exchanging the x1 place with itself is a pointless maneuver.

<a id="id-1.10.6.6.1" class="indexterm"></a><a id="id-1.10.6.6.2" class="indexterm"></a>Here are the place structures of _<a id="id-1.10.6.6.3.1" class="indexterm"></a>se klama_ :

> x1 is the destination of x2's going from x3 via x4 using x5

and _<a id="id-1.10.6.8.1.1" class="indexterm"></a>te klama_ :

> x1 is the origin and x2 the destination of x3 going via x4 using x5

and _<a id="id-1.10.6.10.1.1" class="indexterm"></a>ve klama_ :

> x1 is the route to x2 from x3 used by x4 going via x5

and _<a id="id-1.10.6.12.1.1" class="indexterm"></a>xe klama_ :

> x1 is the means in going to x2 from x3 via x4 employed by x5

<a id="id-1.10.6.14.1" class="indexterm"></a>Note that the place structure numbers in each case continue to be listed in the usual order, x1 to x5.

Consider the following pair of examples:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qmHh"></a>

**Example 9.18. <a id="c9e4d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.bastn.</td><td>cu</td><td>se&nbsp;klama</td><td>mi</td></tr><tr class="gloss"><td>That-named</td><td>Boston</td><td></td><td>is-the-destination</td><td>of-me.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Boston is my destination.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">Boston is gone to by me.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qMHH"></a>

**Example 9.19. <a id="c9e4d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>fe</td><td>la</td><td>.bastn.</td><td>cu</td><td>klama</td><td>fa</td><td>mi</td></tr><tr class="gloss"><td>x<sub>2</sub>=</td><td>that-named</td><td>Boston</td><td></td><td>go</td><td>x<sub>1</sub>=</td><td>I.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">To Boston go I.</p></td></tr></tbody></table>

</div>  

<a id="id-1.10.6.18.1" class="indexterm"></a><a id="id-1.10.6.18.2" class="indexterm"></a><a id="id-1.10.6.18.3" class="indexterm"></a><a id="id-1.10.6.18.4" class="indexterm"></a><a id="id-1.10.6.18.5" class="indexterm"></a>[Example 9.18](../section-SE#example-random-id-qmHh) and [Example 9.19](../section-SE#example-random-id-qMHH) mean the same thing, in the sense that there is a relationship of going with the speaker as the agent and Boston as the destination (and with unspecified origin, route, and means). Structurally, however, they are quite different. [Example 9.18](../section-SE#example-random-id-qmHh) has _<a id="id-1.10.6.18.9.1" class="indexterm"></a>la .bastn._ in the x1 place and _<a id="id-1.10.6.18.11.1" class="indexterm"></a>[_mi_](../go01#valsi-mi)_ in the x2 place of the selbri _<a id="id-1.10.6.18.13.1" class="indexterm"></a>se klama_ , and uses standard bridi order; [Example 9.19](../section-SE#example-random-id-qMHH) has _<a id="id-1.10.6.18.15.1" class="indexterm"></a>[_mi_](../go01#valsi-mi)_ in the x1 place and _<a id="id-1.10.6.18.17.1" class="indexterm"></a>la .bastn._ in the x2 place of the selbri _<a id="id-1.10.6.18.19.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ , and uses a non-standard order.

<a id="id-1.10.6.19.1" class="indexterm"></a><a id="id-1.10.6.19.2" class="indexterm"></a><a id="id-1.10.6.19.3" class="indexterm"></a>The most important use of conversion is in the construction of descriptions. A description is a sumti which begins with a cmavo of selma'o LA or LE, called the descriptor, and contains (in the simplest case) a selbri. We have already seen the descriptions _<a id="id-1.10.6.19.4.1" class="indexterm"></a>le dargu_ and _<a id="id-1.10.6.19.5.1" class="indexterm"></a>le karce_. To this we could add:

<div class="interlinear-gloss-example example">
<a id="example-random-id-3YoA"></a>

**Example 9.20. <a id="id-1.10.6.20.1.1" class="indexterm"></a><a id="c9e4d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>klama</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the go-er, the one who goes</p></td></tr></tbody></table>

</div>  

<a id="id-1.10.6.21.1" class="indexterm"></a><a id="id-1.10.6.21.2" class="indexterm"></a><a id="id-1.10.6.21.3" class="indexterm"></a>In every case, the description is about something which fits into the x1 place of the selbri. In order to get a description of a destination (that is, something fitting the x2 place of _<a id="id-1.10.6.21.6.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_), we must convert the selbri to _<a id="id-1.10.6.21.7.1" class="indexterm"></a>se klama_ , whose x1 place is a destination. The result is

<div class="interlinear-gloss-example example">
<a id="example-random-id-brDN"></a>

**Example 9.21. <a id="id-1.10.6.22.1.1" class="indexterm"></a><a id="c9e4d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>se</td><td>klama</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the destination gone to by someone</p></td></tr></tbody></table>

</div>  

Likewise, we can create three more converted descriptions:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qMIQ"></a>

**Example 9.22. <a id="c9e4d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>te</td><td>klama</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the origin of someone's going</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qMjE"></a>

**Example 9.23. <a id="c9e4d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>ve</td><td>klama</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the route of someone's going</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qmji"></a>

**Example 9.24. <a id="c9e4d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>xe</td><td>klama</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the means by which someone goes</p></td></tr></tbody></table>

</div>  

<a id="id-1.10.6.27.1" class="indexterm"></a><a id="id-1.10.6.27.2" class="indexterm"></a><a id="id-1.10.6.27.3" class="indexterm"></a><a id="id-1.10.6.27.4" class="indexterm"></a><a id="id-1.10.6.27.5" class="indexterm"></a><a id="id-1.10.6.27.6" class="indexterm"></a><a id="id-1.10.6.27.7" class="indexterm"></a>[Example 9.23](../section-SE#example-random-id-qMjE) does not mean “the route” plain and simple: that is _<a id="id-1.10.6.27.10.1" class="indexterm"></a>le pluta_ , using a different selbri. It means a route that is used by someone for an act of _<a id="id-1.10.6.27.11.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ ; that is, a journey with origin and destination. A “road” on Mars, on which no one has traveled or is ever likely to, may be called _<a id="id-1.10.6.27.13.1" class="indexterm"></a>le pluta_ , but it cannot be _<a id="id-1.10.6.27.14.1" class="indexterm"></a>le ve klama_ , since there exists no one for whom it is _<a id="id-1.10.6.27.15.1" class="indexterm"></a>le ve klama be fo da_ (the route taken in an actual journey by someone \[da\]).

<a id="id-1.10.6.28.1" class="indexterm"></a><a id="id-1.10.6.28.2" class="indexterm"></a><a id="id-1.10.6.28.3" class="indexterm"></a><a id="id-1.10.6.28.4" class="indexterm"></a>When converting selbri that are more complex than a single brivla, it is important to realize that the scope of a SE cmavo is only the following brivla (or equivalent unit). In order to convert an entire tanru, it is necessary to enclose the tanru in _<a id="id-1.10.6.28.5.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ … _<a id="id-1.10.6.28.6.1" class="indexterm"></a>[_ke'e_](../go01#valsi-kehe)_ brackets:

<div class="interlinear-gloss-example example">
<a id="example-random-id-wQbB"></a>

**Example 9.25. <a id="id-1.10.6.29.1.1" class="indexterm"></a><a id="c9e4d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>se</td><td>ke</td><td>blanu</td><td>zdani</td><td>[ke'e]</td><td>ti</td></tr><tr class="gloss"><td>I</td><td>[2nd-conversion]</td><td>(</td><td>blue</td><td>house</td><td>)</td><td>this-thing</td></tr></tbody></table>

</div>  

The place structure of _<a id="id-1.10.6.30.1.1" class="indexterm"></a>blanu zdani_ (blue house) is the same as that of _<a id="id-1.10.6.30.2.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ , by the rule given in [Section 9.1](../chapter-sumti-tcita#section-sumti-tcita-introduction). The place structure of _<a id="id-1.10.6.30.4.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ is:

> _<a id="id-1.10.6.31.1.1.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ x1 is a house/nest/lair/den for inhabitant x2

The place structure of _<a id="id-1.10.6.32.1.1" class="indexterm"></a>se ke blanu zdani \[ke'e\]_ is therefore:

> x1 is the inhabitant of the blue house (etc.) x2

Consequently, [Example 9.25](../section-SE#example-random-id-wQbB) means:

> I am the inhabitant of the blue house which is this thing.

Conversion applied to only part of a tanru has subtler effects which are explained in [Section 5.11](../section-place-conversion).

<a id="id-1.10.6.37.1" class="indexterm"></a><a id="id-1.10.6.37.2" class="indexterm"></a><a id="id-1.10.6.37.3" class="indexterm"></a>It is grammatical to convert a selbri more than once with SE; later (inner) conversions are applied before earlier (outer) ones. For example, the place structure of _<a id="id-1.10.6.37.4.1" class="indexterm"></a>se te klama_ is achieved by exchanging the x1 and x2 place of _<a id="id-1.10.6.37.7.1" class="indexterm"></a>te klama_ , producing:<a id="id-1.10.6.37.8" class="indexterm"></a>

> x1 is the destination and x2 is the origin of x3 going via x4 using x5

On the other hand, _<a id="id-1.10.6.39.1.1" class="indexterm"></a>te se klama_ has a place structure derived from swapping the x1 and x3 places of _<a id="id-1.10.6.39.4.1" class="indexterm"></a>se klama_ :

> x1 is the origin of x2's going to x3 via x4 using x5

<a id="id-1.10.6.41.1" class="indexterm"></a>which is quite different. However, multiple conversions like this are never necessary. Arbitrary scrambling of places can be achieved more easily and far more intelligibly with FA tags, and only a single conversion is ever needed in a description.

<a id="id-1.10.6.42.1" class="indexterm"></a>(Although no one has made any real use of it, it is perhaps worth noting that compound conversions of the form _<a id="id-1.10.6.42.2.1" class="indexterm"></a>setese_ , where the first and third cmavo are the same, effectively swap the two given places while leaving the others, including x1, alone: _<a id="id-1.10.6.42.4.1" class="indexterm"></a>setese_ (or equivalently _<a id="id-1.10.6.42.5.1" class="indexterm"></a>tesete_) swap the x2 and x3 places, whereas _<a id="id-1.10.6.42.8.1" class="indexterm"></a>texete_ (or _<a id="id-1.10.6.42.9.1" class="indexterm"></a>xetexe_) swap the x3 and x5 places.)