<a id="section-BAI"></a>9.6. <a id="c9s6"></a>Modal tags: BAI
-------------------------------------------------------------

<a id="id-1.10.8.2.1" class="indexterm"></a>There are certain selbri which seem particularly useful in constructing modal tags. In particular, _<a id="id-1.10.8.2.2.1" class="indexterm"></a>[_pilno_](../go01#valsi-pilno)_ is one of them. The place structure of _<a id="id-1.10.8.2.3.1" class="indexterm"></a>[_pilno_](../go01#valsi-pilno)_ is:

> _<a id="id-1.10.8.3.1.1.1" class="indexterm"></a>[_pilno_](../go01#valsi-pilno)_ x1 uses x2 as a tool for purpose x3

<a id="id-1.10.8.4.1" class="indexterm"></a>and almost any selbri which represents an action may need to specify a tool. Having to say _<a id="id-1.10.8.4.2.1" class="indexterm"></a>fi'o se pilno_ frequently would make many Lojban sentences unnecessarily verbose and clunky, so an abbreviation is provided in the language design: the compound cmavo _<a id="id-1.10.8.4.3.1" class="indexterm"></a>[_sepi'o_](../go01#valsi-sepiho)_.

<a id="id-1.10.8.5.1" class="indexterm"></a><a id="id-1.10.8.5.2" class="indexterm"></a><a id="id-1.10.8.5.3" class="indexterm"></a><a id="id-1.10.8.5.4" class="indexterm"></a>Here _<a id="id-1.10.8.5.5.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ is used before a cmavo, namely _<a id="id-1.10.8.5.6.1" class="indexterm"></a>[_pi'o_](../go01#valsi-piho)_ , rather than before a brivla. The meaning of this cmavo, which belongs to selma'o BAI, is exactly the same as that of _<a id="id-1.10.8.5.7.1" class="indexterm"></a>fi'o pilno fe'u_. Since what we want is a tag based on _<a id="id-1.10.8.5.8.1" class="indexterm"></a>se pilno_ rather than _<a id="id-1.10.8.5.9.1" class="indexterm"></a>pilno-_ the tool, not the tool user – the grammar allows a BAI cmavo to be converted using a SE cmavo. [Example 9.27](../section-selbri-modals#example-random-id-Lu15) may therefore be rewritten as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-N32m"></a>

**Example 9.28. <a id="c9e6d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>do</td><td>sepi'o</td><td>le</td><td>zunle</td><td>kanla</td></tr><tr class="gloss"><td>I</td><td>see</td><td>you</td><td>with-tool:</td><td>the</td><td>left</td><td>eye</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I see you using my left eye.</p></td></tr></tbody></table>

</div>  

The compound cmavo _<a id="id-1.10.8.7.1.1" class="indexterm"></a>[_sepi'o_](../go01#valsi-sepiho)_ is much shorter than _<a id="id-1.10.8.7.2.1" class="indexterm"></a>fi'o se pilno \[fe'u\]_ and can be thought of as a single word meaning “with-tool”. The modal tag _<a id="id-1.10.8.7.4.1" class="indexterm"></a>[_pi'o_](../go01#valsi-piho)_ , with no _<a id="id-1.10.8.7.5.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ , similarly means “with-tool-user” , probably a less useful concept. Nevertheless, the parallelism with the place structure of _<a id="id-1.10.8.7.7.1" class="indexterm"></a>[_pilno_](../go01#valsi-pilno)_ makes the additional syllable worthwhile.

<a id="id-1.10.8.8.1" class="indexterm"></a><a id="id-1.10.8.8.2" class="indexterm"></a>Some BAI cmavo make sense with as well as without a SE cmavo; for example, _<a id="id-1.10.8.8.3.1" class="indexterm"></a>[_ka'a_](../go01#valsi-kaha)_ , the BAI corresponding to the gismu _<a id="id-1.10.8.8.4.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ , has five usable forms corresponding to the five places of _<a id="id-1.10.8.8.5.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ respectively:

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.10.8.9.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-kaha"><em class="glossterm">ka'a</em></a></em></span></td><td><p>with-goer</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.10.8.9.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-sekaha"><em class="glossterm">seka'a</em></a></em></span></td><td><p>with-destination</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.10.8.9.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-tekaha"><em class="glossterm">teka'a</em></a></em></span></td><td><p>with-origin</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.10.8.9.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-vekaha"><em class="glossterm">veka'a</em></a></em></span></td><td><p>with-route</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.10.8.9.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-xekaha"><em class="glossterm">xeka'a</em></a></em></span></td><td><p>with-means-of-transport</p></td></tr></tbody></table>

Any of these tags may be used to provide modal places for bridi, as in the following examples:

<div class="interlinear-gloss-example example">
<a id="example-random-id-r0QA"></a>

**Example 9.29. <a id="id-1.10.8.11.1.1" class="indexterm"></a><a id="id-1.10.8.11.1.2" class="indexterm"></a><a id="c9e6d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.eivn.</td><td>cu</td><td>vecnu</td><td>loi</td><td>flira</td><td>cinta</td><td>ka'a</td><td>mi</td></tr><tr class="gloss"><td>That-named</td><td>Avon</td><td></td><td>sells</td><td>a-mass-of</td><td>face</td><td>paint</td><td>with-goer</td><td>me.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am a traveling cosmetics salesperson for Avon.</p></td></tr></tbody></table>

</div>  

( [Example 9.29](../section-BAI#example-random-id-r0QA) may seem a bit strained, but it illustrates the way in which an existing selbri, _<a id="id-1.10.8.12.2.1" class="indexterm"></a>[_vecnu_](../go01#valsi-vecnu)_ in this case, may have a place added to it which might otherwise seem utterly unrelated.)

<div class="interlinear-gloss-example example">
<a id="example-random-id-qmJM"></a>

**Example 9.30. <a id="c9e6d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cadzu</td><td>seka'a</td><td>la</td><td>.bratfyd.</td></tr><tr class="gloss"><td>I</td><td>walk</td><td>with-destination</td><td>that-named</td><td>Bradford.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am walking to Bradford.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qMjz"></a>

**Example 9.31. <a id="c9e6d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>bloti</td><td>teka'a</td><td>la</td><td>.nu,IORK.</td></tr><tr class="gloss"><td>[Observative:]-is-a-boat</td><td>with-origin</td><td>that-named</td><td>New-York</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">A boat from New York!</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qmLX"></a>

**Example 9.32. <a id="c9e6d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>bajra</td><td>veka'a</td><td>lo</td><td>djine</td></tr><tr class="gloss"><td>You</td><td>run</td><td>with-route</td><td>a</td><td>circle.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">You are running in circles.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qMMX"></a>

**Example 9.33. <a id="c9e6d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>citka</td><td>xeka'a</td><td>le</td><td>vinji</td></tr><tr class="gloss"><td>I</td><td>eat</td><td>with-means-of-transport</td><td>the</td><td>airplane.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I eat in the airplane.</p></td></tr></tbody></table>

</div>  

<a id="id-1.10.8.17.1" class="indexterm"></a><a id="id-1.10.8.17.2" class="indexterm"></a><a id="id-1.10.8.17.3" class="indexterm"></a>There are sixty-odd cmavo of selma'o BAI, based on selected gismu that seemed useful in a variety of settings. The list is somewhat biased toward English, because many of the cmavo were selected on the basis of corresponding English prepositions and preposition compounds such as “with” , “without” , and “by means of”. The BAI cmavo, however, are far more precise than English prepositions, because their meanings are fixed by the place structures of the corresponding gismu.

<a id="id-1.10.8.18.1" class="indexterm"></a>All BAI cmavo have the form CV'V or CVV. Most of them are CV'V, where the C is the first consonant of the corresponding gismu and the two Vs are the two vowels of the gismu. The table in [Section 9.16](../section-irregular-BAI) shows the exceptions.

<a id="id-1.10.8.19.1" class="indexterm"></a><a id="id-1.10.8.19.2" class="indexterm"></a>There is one additional BAI cmavo that is not derived from a gismu: _<a id="id-1.10.8.19.3.1" class="indexterm"></a>[_do'e_](../go01#valsi-dohe)_. This cmavo is used when an extra place is needed, but it seems useful to be vague about the semantic implications of the extra place:

<div class="interlinear-gloss-example example">
<a id="example-random-id-2vMd"></a>

**Example 9.34. <a id="c9e6d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>nanmu</td><td>be&nbsp;do'e</td><td>le</td><td>berti</td><td>cu</td><td>klama</td><td>le</td><td>tcadu</td></tr><tr class="gloss"><td>Some</td><td>man</td><td>[related-to]</td><td>the</td><td>north</td><td></td><td>came</td><td>to-the</td><td>city.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">A man of the north came to the city.</p></td></tr></tbody></table>

</div>  

<a id="id-1.10.8.21.1" class="indexterm"></a><a id="id-1.10.8.21.2" class="indexterm"></a><a id="id-1.10.8.21.3" class="indexterm"></a>Here _<a id="id-1.10.8.21.4.1" class="indexterm"></a>le berti_ is provided as a modal place of the selbri _<a id="id-1.10.8.21.5.1" class="indexterm"></a>[_nanmu_](../go01#valsi-nanmu)_ , but its exact significance is vague, and is paralleled in the colloquial translation by the vague English preposition “of”. [Example 9.34](../section-BAI#example-random-id-2vMd) also illustrates a modal place bound into a selbri with _<a id="id-1.10.8.21.8.1" class="indexterm"></a>[_be_](../go01#valsi-be)_. This construction is useful when the selbri of a description requires a modal place; this and other uses of _<a id="id-1.10.8.21.9.1" class="indexterm"></a>[_be_](../go01#valsi-be)_ are more fully explained in [Section 5.7](../section-be-sumti).