<a id="id-1"></a>The Incomplete Lojban Language
===============================================

Chrestomathy included
---------------------

### John Woldemar Cowan

### An unofficial publication, community edition (not by the LLG)

Version geklojban-1.2.15, Generated 2022-10-30

**Table of Contents**

[1\. Lojban as we mangle it in Lojbanistan: about this book](../chapter-about)

[1.1. What is Lojban?](../chapter-about#section-what-is-lojban)

[1.2. What is this book?](../section-what-is-cll)

[1.3. What are the typographical conventions of this book?](../section-conventions)

[1.4. Disclaimers](../section-disclaimers)

[1.5. Acknowledgements and credits](../credits)

[1.6. Informal bibliography](../section-bibliography)

[1.7. Captions to pictures](../section-captions)

[1.8. Boring legalities](../section-copyright)

[2\. A quick tour of Lojban grammar, with diagrams](../chapter-tour)

[2.1. The concept of the bridi](../chapter-tour#section-bridi)

[2.2. Pronunciation](../section-pronunciation)

[2.3. Words that can act as sumti](../section-sumti-cmavo)

[2.4. Some words used to indicate selbri relations](../section-some-selbri)

[2.5. Some simple Lojban bridi](../section-some-simple-bridi)

[2.6. Variant bridi structure](../section-variant-bridi-structure)

[2.7. Varying the order of sumti](../section-order-of-sumti)

[2.8. The basic structure of longer utterances](../section-structure-of-utterances)

[2.9. tanru](../section-basic-tanru)

[2.10. Description sumti](../section-description-sumti)

[2.11. Examples of brivla](../section-some-brivla)

[2.12. The sumti _di'u_ and _la'e di'u_](../section-dihu-and-lahe-dihu)

[2.13. Possession](../section-possession)

[2.14. Vocatives and commands](../section-vocatives-and-commands)

[2.15. Questions](../section-basic-questions)

[2.16. Indicators](../section-attitudinals)

[2.17. Tenses](../section-tenses)

[2.18. Lojban grammatical terms](../section-terms)

[3\. The hills are alive with the sounds of Lojban](../chapter-phonology)

[3.1. Orthography](../chapter-phonology#section-orthography)

[3.2. Basic phonetics](../section-basic-phonetics)

[3.3. The special Lojban characters](../section-lojban-characters)

[3.4. Diphthongs and syllabic consonants](../section-diphthongs)

[3.5. Vowel pairs](../section-vowel-pairs)

[3.6. Consonant clusters](../section-clusters)

[3.7. Initial consonant pairs](../section-initial-pairs)

[3.8. Buffering of consonant clusters](../section-buffer-vowels)

[3.9. Syllabication and stress](../section-stress)

[3.10. IPA for English speakers](../section-anglophone-phonetics)

[3.11. English analogues for Lojban diphthongs](../section-anglophone-diphthongs)

[3.12. Oddball orthographies](../section-oddball-orthographies)

[4\. The shape of words to come: Lojban morphology](../chapter-morphology)

[4.1. Introductory](../chapter-morphology#section-morphology-introduction)

[4.2. cmavo](../section-cmavo)

[4.3. brivla](../section-morphology-brivla)

[4.4. gismu](../section-gismu)

[4.5. lujvo](../section-lujvo)

[4.6. rafsi](../section-rafsi)

[4.7. fu'ivla](../section-fuhivla)

[4.8. cmevla](../section-cmevla)

[4.9. Rules for inserting pauses](../section-pauses)

[4.10. Considerations for making lujvo](../section-lujvo-considerations)

[4.11. The lujvo-making algorithm](../section-lujvo-making)

[4.12. The lujvo scoring algorithm](../section-lujvo-scoring)

[4.13. lujvo-making examples](../section-lujvo-making-examples)

[4.14. The gismu creation algorithm](../section-gismu-making)

[4.15. Cultural and other non-algorithmic gismu](../section-cultural-gismu)

[4.16. rafsi fu'ivla: a proposal](../section-rafsi-fuhivla)

[5\. “Pretty little girls' school”: the structure of Lojban selbri](../chapter-selbri)

[5.1. Lojban content words: brivla](../chapter-selbri#section-content-words-brivla)

[5.2. Simple tanru](../section-simple-tanru)

[5.3. Three-part tanru grouping with _bo_](../section-three-part-tanru)

[5.4. Complex tanru grouping](../section-complex-grouping)

[5.5. Complex tanru with _ke_ and _ke'e_](../section-ke-grouping)

[5.6. Logical connection within tanru](../section-logical-connection)

[5.7. Linked sumti: _be_ - _bei_ - _be'o_](../section-be-sumti)

[5.8. Inversion of tanru: _co_](../section-co-inversion)

[5.9. Other kinds of simple selbri](../section-cmavo-selbri)

[5.10. selbri based on sumti: _me_](../section-me-selbri)

[5.11. Conversion of simple selbri](../section-place-conversion)

[5.12. Scalar negation of selbri](../section-selbri-scalar-negation)

[5.13. Tenses and bridi negation](../section-bridi-negation-tenses)

[5.14. Some types of asymmetrical tanru](../section-asymmetric-tanru)

[5.15. Some types of symmetrical tanru](../section-symmetric-tanru)

[5.16. “Pretty little girls' school” : forty ways to say it](../section-pretty-school-groupings)

[6\. To speak of many things: the Lojban sumti](../chapter-sumti)

[6.1. The five kinds of simple sumti](../chapter-sumti#section-simple-sumti-kinds)

[6.2. The three basic description types](../section-basic-descriptors)

[6.3. Individuals and masses](../section-masses)

[6.4. Masses and sets](../section-sets)

[6.5. Descriptors for typical objects](../section-typicals)

[6.6. Quantified sumti](../section-quantified-sumti)

[6.7. Quantified descriptions](../section-quantified-descriptions)

[6.8. Indefinite descriptions](../section-indefinite-descriptions)

[6.9. sumti-based descriptions](../section-sumti-based-descriptions)

[6.10. sumti qualifiers](../section-sumti-qualifiers)

[6.11. The syntax of vocative phrases](../section-vocative-syntax)

[6.12. Lojban names](../section-names)

[6.13. Pro-sumti summary](../section-pro-sumti)

[6.14. Quotation summary](../section-quotation)

[6.15. Number summary](../section-number-summary)

[7\. Brevity is the soul of language: pro-sumti and pro-bridi](../chapter-anaphoric-cmavo)

[7.1. What are pro-sumti and pro-bridi? What are they for?](../chapter-anaphoric-cmavo#section-anaphoric-cmavo-introduction)

[7.2. Personal pro-sumti: the mi-series](../section-mi-series)

[7.3. Demonstrative pro-sumti: the ti-series](../section-ti-series)

[7.4. Utterance pro-sumti: the di'u-series](../section-dihu-series)

[7.5. Assignable pro-sumti and pro-bridi: the ko'a-series and the broda-series](../section-koha-broda-series)

[7.6. Anaphoric pro-sumti and pro-bridi: the ri-series and the go'i-series](../section-ri-gohi-series)

[7.7. Indefinite pro-sumti and pro-bridi: the zo'e-series and the co'e-series](../section-zohe-cohe-series)

[7.8. Reflexive and reciprocal pro-sumti: the vo'a-series](../section-voha-series)

[7.9. sumti and bridi questions: _ma_ and _mo_](../section-sumti-and-bridi-questions)

[7.10. Relativized pro-sumti: _ke'a_](../section-keha)

[7.11. Abstraction focus pro-sumti: _ce'u_](../section-cehu)

[7.12. Bound variable pro-sumti and pro-bridi: the da-series and the bu'a-series](../section-da-buha-series)

[7.13. Pro-sumti and pro-bridi cancelling](../section-daho)

[7.14. The identity predicate: du](../section-du)

[7.15. lujvo based on pro-sumti](../section-anaphoric-rafsi)

[7.16. KOhA cmavo by series](../section-koha-summary)

[7.17. GOhA and other pro-bridi by series](../section-goha-summary)

[7.18. Other cmavo discussed in this chapter](../section-other-summary)

[8\. Relative clauses, which make sumti even more complicated](../chapter-relative-clauses)

[8.1. What are you pointing at?](../chapter-relative-clauses#section-poi)

[8.2. Incidental relative clauses](../section-noi)

[8.3. Relative phrases](../section-relative-phrases)

[8.4. Multiple relative clauses: _zi'e_](../section-zihe)

[8.5. Non-veridical relative clauses: _voi_](../section-voi)

[8.6. Relative clauses and descriptors](../section-descriptors)

[8.7. Possessive sumti](../section-possessive-sumti)

[8.8. Relative clauses and complex sumti: _vu'o_](../section-vuho)

[8.9. Relative clauses in vocative phrases](../section-relative-clauses-and-vocatives)

[8.10. Relative clauses within relative clauses](../section-nesting)

[8.11. Index of relative clause cmavo](../section-relative-clause-cmavo-summary)

[9\. To Boston via the Road go I, with an excursion into the land of modals](../chapter-sumti-tcita)

[9.1. Introductory](../chapter-sumti-tcita#section-sumti-tcita-introduction)

[9.2. Standard bridi form: _cu_](../section-cu)

[9.3. Tagging places: FA](../section-FA)

[9.4. Conversion: SE](../section-SE)

[9.5. Modal places: FIhO, FEhU](../section-selbri-modals)

[9.6. Modal tags: BAI](../section-BAI)

[9.7. Modal sentence connection: the causals](../section-causals)

[9.8. Other modal connections](../section-modal-connectives)

[9.9. Modal selbri](../section-modal-selbri)

[9.10. Modal relative phrases; Comparison](../section-modal-relative-phrases)

[9.11. Mixed modal connection](../section-mixed-connection)

[9.12. Modal conversion: JAI](../section-modal-jai)

[9.13. Modal negation](../section-modal-negation)

[9.14. Sticky modals](../section-sticky-modals)

[9.15. Logical and non-logical connection of modals](../section-connected-modals)

[9.16. CV'V cmavo of selma'o BAI with irregular forms](../section-irregular-BAI)

[9.17. Complete table of BAI cmavo with rough English equivalents](../section-all-BAI)

[10\. Imaginary journeys: the Lojban space/time tense system](../chapter-tenses)

[10.1. Introductory](../chapter-tenses#section-tenses-introduction)

[10.2. Spatial tenses: FAhA and VA](../section-spatial-tenses)

[10.3. Compound spatial tenses](../section-compound-spatial-tenses)

[10.4. Temporal tenses: PU and ZI](../section-temporal-tenses)

[10.5. Interval sizes: VEhA and ZEhA](../section-interval-sizes)

[10.6. Vague intervals and non-specific tenses](../section-vagueness)

[10.7. Dimensionality: VIhA](../section-dimensionality)

[10.8. Movement in space: MOhI](../section-movement)

[10.9. Interval properties: TAhE and _roi_](../section-interval-properties)

[10.10. Event contours: ZAhO and _re'u_](../section-event-contours)

[10.11. Space interval modifiers: FEhE](../section-fehe)

[10.12. Tenses as sumtcita](../section-tcita)

[10.13. Sticky and multiple tenses: KI](../section-sticky-tenses)

[10.14. Story time](../section-story-time)

[10.15. Tenses in subordinate bridi](../section-sub-bridi-tenses)

[10.16. Tense relations between sentences](../section-tense-connection)

[10.17. Tensed logical connectives](../section-tense-logical-connection)

[10.18. Tense negation](../section-tense-negation)

[10.19. Actuality, potentiality, capability: CAhA](../section-caha)

[10.20. Logical and non-logical connections between tenses](../section-connected-tenses)

[10.21. Sub-events](../section-sub-events)

[10.22. Conversion of sumtcita: JAI](../section-jai)

[10.23. Tenses versus modals](../section-tenses-vs-modals)

[10.24. Tense questions: _cu'e_](../section-tense-questions)

[10.25. Explicit magnitudes](../section-explicit-magnitudes)

[10.26. Finally (an exercise for the much-tried reader)](../section-exercise)

[10.27. Summary of tense selma'o](../section-tense-selmaho-summary)

[10.28. List of spatial directions and direction-like relations](../section-direction-cmavo)

[11\. Events, qualities, quantities, and other vague words: on Lojban abstraction](../chapter-abstractions)

[11.1. The syntax of abstraction](../chapter-abstractions#section-syntax)

[11.2. Event abstraction](../section-events)

[11.3. Types of event abstractions](../section-event-types)

[11.4. Property abstractions](../section-properties)

[11.5. Amount abstractions](../section-amounts)

[11.6. Truth-value abstraction: _jei_](../section-truth-values)

[11.7. Predication/sentence abstraction](../section-predications)

[11.8. Indirect questions](../section-indirect-questions)

[11.9. Minor abstraction types](../section-minor-abstractions)

[11.10. Lojban sumti raising](../section-sumti-raising)

[11.11. Event-type abstractors and event contour tenses](../section-events-and-contours)

[11.12. Abstractor connection](../section-abstractor-connection)

[11.13. Table of abstractors](../section-summary)

[12\. Dog house and white house: determining lujvo place structures](../chapter-lujvo)

[12.1. Why have lujvo?](../chapter-lujvo#section-why-lujvo)

[12.2. The meaning of tanru: a necessary detour](../section-tanru-meanings)

[12.3. The meaning of lujvo](../section-lujvo-meanings)

[12.4. Selecting places](../section-selecting-places)

[12.5. Symmetrical and asymmetrical lujvo](../section-symmetrical-asymmetrical)

[12.6. Dependent places](../section-dependent-places)

[12.7. Ordering lujvo places.](../section-order-of-places)

[12.8. lujvo with more than two parts.](../section-n-part-lujvo)

[12.9. Eliding SE rafsi from seltau](../section-seltau-SE)

[12.10. Eliding SE rafsi from tertau](../section-tertau-SE)

[12.11. Eliding KE and KEhE rafsi from lujvo](../section-eliding-ke-kehe)

[12.12. Abstract lujvo](../section-abstraction-lujvo)

[12.13. Implicit-abstraction lujvo](../section-implicit-abstraction)

[12.14. Anomalous lujvo](../section-anomalous-lujvo)

[12.15. Comparatives and superlatives](../section-comparatives)

[12.16. Notes on gismu place structures](../section-gismu-place-structures)

[13\. Oooh! Arrgh! Ugh! Yecch! Attitudinal and emotional indicators](../chapter-attitudinals)

[13.1. What are attitudinal indicators?](../chapter-attitudinals#section-attitudinals-introduction)

[13.2. Pure emotion indicators](../section-pure-emotions)

[13.3. Propositional attitude indicators](../section-propositional-emotions)

[13.4. Attitudes as scales](../section-intensity-scale)

[13.5. The space of emotions](../section-attitudinal-space)

[13.6. Emotional categories](../section-categories)

[13.7. Attitudinal modifiers](../section-modifiers)

[13.8. Compound indicators](../section-compound-attitudinals)

[13.9. The uses of indicators](../section-scope)

[13.10. Attitude questions; empathy; attitude contours](../section-questions-empathy-contours)

[13.11. Evidentials](../section-evidentials)

[13.12. Discursives](../section-discursives)

[13.13. Miscellaneous indicators](../section-miscellanious)

[13.14. Vocative scales](../section-vocative-scales)

[13.15. A sample dialogue](../section-sample-dialogue)

[13.16. Tentative conclusion](../section-attitudinals-conclusion)

[14\. If wishes were horses: the Lojban connective system](../chapter-connectives)

[14.1. Logical connection and truth tables](../chapter-connectives#section-connectives-introduction)

[14.2. The four basic vowels](../section-four-basics)

[14.3. The six types of logical connectives](../section-six-types)

[14.4. Logical connection of bridi](../section-bridi-connection)

[14.5. Forethought bridi connection](../section-forethought-bridi-connection)

[14.6. sumti connection](../section-sumti-connection)

[14.7. More than two propositions](../section-more-propositions)

[14.8. Grouping of afterthought connectives](../section-afterthought-connectives-grouping)

[14.9. Compound bridi](../section-compound-bridi)

[14.10. Multiple compound bridi](../section-multiple-compound-bridi)

[14.11. Termset logical connection](../section-termsets)

[14.12. Logical connection within tanru](../section-tanru)

[14.13. Truth questions and connective questions](../section-truth-and-connective-questions)

[14.14. Non-logical connectives](../section-non-logical-connectives)

[14.15. More about non-logical connectives](../section-non-logical-continued)

[14.16. Interval connectives and forethought non-logical connection](../section-non-logical-continued-continued)

[14.17. Logical and non-logical connectives within mekso](../section-mekso-connections)

[14.18. Tenses, modals, and logical connection](../section-sumtcita)

[14.19. Abstractor connection and connection within abstractions](../section-abstractors)

[14.20. Constructs and appropriate connectives](../section-constructs-summary)

[14.21. Truth functions and corresponding logical connectives](../section-truth-functions-summary)

[14.22. Rules for making logical and non-logical connectives](../section-construction-summary)

[14.23. Locations of other tables](../section-other-tables)

[15\. “No” problems: on Lojban negation](../chapter-negation)

[15.1. Introductory](../chapter-negation#section-negation-introduction)

[15.2. bridi negation](../section-bridi-negation)

[15.3. Scalar negation](../section-scalar-negation)

[15.4. selbri and tanru negation](../section-nahe)

[15.5. Expressing scales in selbri negation](../section-scales-negation)

[15.6. sumti negation](../section-sumti-negation)

[15.7. Negation of minor grammatical constructs](../section-other-negation)

[15.8. Truth questions](../section-truth-questions)

[15.9. Affirmations](../section-affirmations)

[15.10. Metalinguistic negation forms](../section-metalinguistic-negation)

[15.11. Summary – are all possible questions about negation now answered?](../section-are-all-questions-answered)

[16\. “Who did you pass on the road? Nobody”: Lojban and logic](../chapter-quantifiers)

[16.1. What's wrong with this picture?](../chapter-quantifiers#section-quantifiers-introduction)

[16.2. Existential claims, prenexes, and variables](../section-da-and-zohu)

[16.3. Universal claims](../section-universal-claims)

[16.4. Restricted claims: _da poi_](../section-restricted-claims)

[16.5. Dropping the prenex](../section-prenex-elision)

[16.6. Variables with generalized quantifiers](../section-quantified-variables)

[16.7. Grouping of quantifiers](../section-quantifier-grouping)

[16.8. The problem of “any”](../section-any)

[16.9. Negation boundaries](../section-negation-boundaries)

[16.10. bridi negation and logical connectives](../section-connectives)

[16.11. Using _naku_ outside a prenex](../section-na-outside-prenex)

[16.12. Logical connectives and DeMorgan's law](../section-demorgans-law)

[16.13. selbri variables](../section-selbri-variables)

[16.14. A few notes on variables](../section-notes-on-variables)

[16.15. Conclusion](../section-logic-conclusion)

[17\. As easy as A-B-C? The Lojban letteral system and its uses](../chapter-letterals)

[17.1. What's a letteral, anyway?](../chapter-letterals#section-letterals-introduction)

[17.2. A to Z in Lojban, plus one](../section-lerfu-liste)

[17.3. Upper and lower cases](../section-upper-case)

[17.4. The universal _bu_](../section-bu)

[17.5. Alien alphabets](../section-alien-alphabets)

[17.6. Accent marks and compound lerfu words](../section-accents)

[17.7. Punctuation marks](../section-punctuation)

[17.8. What about Chinese characters?](../section-chinese-characters)

[17.9. lerfu words as pro-sumti](../section-lerfu-pro-sumti)

[17.10. References to lerfu](../section-meho)

[17.11. Mathematical uses of lerfu strings](../section-math)

[17.12. Acronyms](../section-acronyms)

[17.13. Computerized character codes](../section-character-codes)

[17.14. List of all auxiliary lerfu-word cmavo](../section-lerfu-cmavo-summary)

[17.15. Proposed lerfu words – introduction](../section-proposed-lerfu-words)

[17.16. Proposed lerfu words for the Greek alphabet](../section-greek)

[17.17. Proposed lerfu words for the Cyrillic alphabet](../section-cyrillic)

[17.18. Proposed lerfu words for the Hebrew alphabet](../section-hebrew)

[17.19. Proposed lerfu words for some accent marks and multiple letters](../section-accents-multiple-letters)

[17.20. Proposed lerfu words for radio communication](../section-ICAO-alphabet)

[18\. lojbau mekso: mathematical expressions in Lojban](../chapter-mekso)

[18.1. Introductory](../chapter-mekso#section-mekso-introduction)

[18.2. Lojban numbers](../section-mekso-numbers)

[18.3. Signs and numerical punctuation](../section-signs-punctuation)

[18.4. Special numbers](../section-constants)

[18.5. Simple infix expressions and equations](../section-simple-infix)

[18.6. Forethought operators (Polish notation, functions)](../section-forethought)

[18.7. Other useful selbri for mekso bridi](../section-useful-selbri)

[18.8. Indefinite numbers](../section-indefinite-numbers)

[18.9. Approximation and inexact numbers](../section-approximation)

[18.10. Non-decimal and compound bases](../section-radixen)

[18.11. Special mekso selbri](../section-mekso-selbri)

[18.12. Number questions](../section-number-questions)

[18.13. Subscripts](../section-subscripts-math)

[18.14. Infix operators revisited](../section-infix-again)

[18.15. Vectors and matrices](../section-vectors-matrices)

[18.16. Reverse Polish notation](../section-reverse-polish-notation)

[18.17. Logical and non-logical connectives within mekso](../section-connectives-within-mekso)

[18.18. Using Lojban resources within mekso](../section-lojban-within-mekso)

[18.19. Other uses of mekso](../section-other-mekso-uses)

[18.20. Explicit operator precedence](../section-explicit-operator-precedence)

[18.21. Miscellany](../section-miscellany)

[18.22. Four score and seven: a mekso problem](../section-four-score-and-seven)

[18.23. mekso selma'o summary](../section-selmaho-summary)

[18.24. Complete table of VUhU cmavo, with operand structures](../section-vuhu)

[18.25. Complete table of PA cmavo: digits, punctuation, and other numbers](../section-pa)

[18.26. Table of MOI cmavo, with associated rafsi and place structures](../section-moi)

[19\. Putting it all together: notes on the structure of Lojban texts](../chapter-structure)

[19.1. Introductory](../chapter-structure#section-structure-introduction)

[19.2. Sentences: I](../section-i)

[19.3. Paragraphs: NIhO](../section-niho)

[19.4. Topic-comment sentences: ZOhU](../section-topic-comments)

[19.5. Questions and answers](../section-questions-and-answers)

[19.6. Subscripts: XI](../section-subscripts-general)

[19.7. Utterance ordinals: MAI](../section-utterance-ordinals)

[19.8. Attitude scope markers: FUhE/FUhO](../section-attitudinal-scope)

[19.9. Quotations: LU, LIhU, LOhU, LEhU](../section-quotations)

[19.10. More on quotations: ZO, ZOI](../section-more-quotations)

[19.11. Contrastive emphasis: BAhE](../section-bahe)

[19.12. Parenthesis and metalinguistic commentary: TO, TOI, SEI](../section-parentheses)

[19.13. Erasure: SI, SA, SU](../section-erasure)

[19.14. Hesitation: Y](../section-hesitation)

[19.15. No more to say: FAhO](../section-faho)

[19.16. List of cmavo interactions](../section-cmavo-interactions)

[19.17. List of elidable terminators](../section-elidable-terminators)

[20\. A catalogue of selma'o](../chapter-catalogue)

[20.1. A catalogue of selma'o](../chapter-catalogue#section-index)

[21\. Formal grammars](../chapter-grammars)

[21.1. EBNF grammar of Lojban](../chapter-grammars#section-EBNF)

[Chrestomathy](../volume-chrestomathy)

[1\. The North Wind and the Sun](../volume-chrestomathy#section-north-wind)

[2\. Terry, the Tiger, visits the big city](../section-terry)

[3\. There will come soft rains](../section-soft-rains)

[4\. Alice in Wonderland](../section-alice01)

[5\. Kubla Khan](../section-in-xanadu)

[Lojban Words Glossary](../go01)

[Lojban Words Index](../ix01)

[General Index](../ix02)