<a id="chapter-tour"></a>Chapter 2. <a id="c2"></a>A quick tour of Lojban grammar, with diagrams
================================================================================================

<a id="chapter-tour-picture"></a>![The picture for chapter 2](/assets//books/uncll/media/chapter-tour.svg.png)

<a id="section-bridi"></a>2.1. <a id="c2s1"></a>The concept of the bridi
------------------------------------------------------------------------

<a id="id-1.3.3.2.1" class="indexterm"></a>This chapter gives diagrammed examples of basic Lojban sentence structures. The most general pattern is covered first, followed by successive variations on the basic components of the Lojban sentence. There are many more capabilities not covered in this chapter, but covered in detail in later chapters, so this chapter is a “quick tour” of the material later covered more slowly throughout the book. It also introduces most of the Lojban words used to discuss Lojban grammar.

Let us consider John and Sam and three statements about them:

<div class="example">
<a id="example-random-id-qIuj"></a>

**Example 2.1. <a id="id-1.3.3.4.1.1" class="indexterm"></a><a id="id-1.3.3.4.1.2" class="indexterm"></a><a id="c2e1d1"></a>** 

John is the father of Sam.

</div>  
<div class="example">
<a id="example-random-id-qiuQ"></a>

**Example 2.2. <a id="id-1.3.3.5.1.1" class="indexterm"></a><a id="id-1.3.3.5.1.2" class="indexterm"></a><a id="c2e1d2"></a>** 

John hits Sam.

</div>  
<div class="example">
<a id="example-random-id-qIuS"></a>

**Example 2.3. <a id="id-1.3.3.6.1.1" class="indexterm"></a><a id="id-1.3.3.6.1.2" class="indexterm"></a><a id="c2e1d3"></a>** 

John is taller than Sam.

</div>  

<a id="id-1.3.3.7.1" class="indexterm"></a><a id="id-1.3.3.7.2" class="indexterm"></a><a id="id-1.3.3.7.3" class="indexterm"></a><a id="id-1.3.3.7.4" class="indexterm"></a><a id="id-1.3.3.7.5" class="indexterm"></a><a id="id-1.3.3.7.6" class="indexterm"></a>These examples all describe relationships between John and Sam. However, in English, we use the noun “father” to describe a static relationship in [Example 2.1](../chapter-tour#example-random-id-qIuj), the verb “hits” to describe an active relationship in [Example 2.2](../chapter-tour#example-random-id-qiuQ), and the adjective “taller” to describe an attributive relationship in [Example 2.3](../chapter-tour#example-random-id-qIuS). In Lojban we make no such grammatical distinctions; these three sentences, when expressed in Lojban, are structurally identical. The same part of speech is used to represent the relationship. In formal logic this whole structure is called a “predication”; in Lojban it is called a _<a id="id-1.3.3.7.14.1" class="indexterm"></a>[_bridi_](../go01#valsi-bridi)_, and the central part of speech is the _<a id="id-1.3.3.7.15.1" class="indexterm"></a>[_selbri_](../go01#valsi-selbri)_. Logicians refer to the things thus related as “arguments”, while Lojbanists call them _<a id="id-1.3.3.7.17.1" class="indexterm"></a>[_sumti_](../go01#valsi-sumti)_. These Lojban terms will be used for the rest of the book.

![bridi (predication) ______________|__________________ | | John is the father of Sam |____| |______________| |___| | | | sumti selbri (predicate) sumti (argument)](/assets//books/uncll/media/chapter-2-diagram.svg.png)

In a relationship, there are a definite number of things being related. In English, for example, “give” has three places: the donor, the recipient and the gift. For example:

<div class="example">
<a id="example-random-id-DE08"></a>

**Example 2.4. <a id="c2e1d4"></a><a id="id-1.3.3.10.1.2" class="indexterm"></a>** 

John gives Sam the book.

</div>  

and

<div class="example">
<a id="example-random-id-IBBE"></a>

**Example 2.5. <a id="c2e1d5"></a><a id="id-1.3.3.12.1.2" class="indexterm"></a>** 

Sam gives John the book.

</div>  

mean two different things because the relative positions of “John” and “Sam” have been switched. Further,

<div class="example">
<a id="example-random-id-DxbA"></a>

**Example 2.6. <a id="c2e1d6"></a><a id="id-1.3.3.14.1.2" class="indexterm"></a>** 

The book gives John Sam.

</div>  

seems strange to us merely because the places are being filled by unorthodox arguments. The relationship expressed by “give” has not changed.

<a id="id-1.3.3.16.1" class="indexterm"></a>In Lojban, each selbri has a specified number and type of arguments, known collectively as its “place structure”. The simplest kind of selbri consists of a single root word, called a _<a id="id-1.3.3.16.3.1" class="indexterm"></a>[_gismu_](../go01#valsi-gismu)_, and the definition in a dictionary gives the place structure explicitly. The primary task of constructing a Lojban sentence, after choosing the relationship itself, is deciding what you will use to fill in the sumti places.

This book uses the Lojban terms _<a id="id-1.3.3.17.1.1" class="indexterm"></a>[_bridi_](../go01#valsi-bridi)_, _<a id="id-1.3.3.17.2.1" class="indexterm"></a>[_sumti_](../go01#valsi-sumti)_, and _<a id="id-1.3.3.17.3.1" class="indexterm"></a>[_selbri_](../go01#valsi-selbri)_, because it is best to come to understand them independently of the English associations of the corresponding words, which are only roughly similar in meaning anyhow.

<a id="id-1.3.3.18.1" class="indexterm"></a><a id="id-1.3.3.18.2" class="indexterm"></a><a id="id-1.3.3.18.3" class="indexterm"></a>The Lojban examples in this chapter (but not in the rest of the book) use boldface (as well as the usual italics) for selbri, to help you to tell them apart.