<a id="chapter-tenses"></a>Chapter 10. <a id="c10"></a>Imaginary journeys: the Lojban space/time tense system
=============================================================================================================

<a id="chapter-tenses-picture"></a>![The picture for chapter 10](/assets//books/uncll/media/chapter-tenses.gif)

<a id="section-tenses-introduction"></a>10.1. <a id="c10s1"></a>Introductory
----------------------------------------------------------------------------

<a id="id-1.11.3.2.1" class="indexterm"></a>This chapter attempts to document and explain the space/time tense system of Lojban. It does not attempt to answer all questions of the form “How do I say such-and-such (an English tense) in Lojban?” Instead, it explores the Lojban tense system from the inside, attempting to educate the reader into a Lojbanic viewpoint. Once the overall system is understood and the resources that it makes available are familiar, the reader should have some hope of using appropriate tense constructs and being correctly understood.

<a id="id-1.11.3.3.1" class="indexterm"></a>The system of Lojban tenses presented here may seem really complex because of all the pieces and all the options; indeed, this chapter is the longest one in this book. But tense is in fact complex in every language. In your native language, the subtleties of tense are intuitive. In foreign languages, you are seldom taught the entire system until you have reached an advanced level. Lojban tenses are extremely systematic and productive, allowing you to express subtleties based on what they mean rather than on how they act similarly to English tenses. This chapter concentrates on presenting an intuitive approach to the meaning of Lojban tense words and how they may be creatively and productively combined.

<a id="id-1.11.3.4.1" class="indexterm"></a><a id="id-1.11.3.4.2" class="indexterm"></a><a id="id-1.11.3.4.3" class="indexterm"></a><a id="id-1.11.3.4.4" class="indexterm"></a>What is “tense” ? Historically, “tense” is the attribute of verbs in English and related languages that expresses the time of the action. In English, three tenses are traditionally recognized, conventionally called the past, the present, and the future. There are also a variety of compound tenses used in English. However, there is no simple relationship between the form of an English tense and the time actually expressed:

*   I go to London tomorrow.

*   I will go to London tomorrow.

*   I am going to London tomorrow.

all mean the same thing, even though the first sentence uses the present tense; the second, the future tense; and the third, a compound tense usually called “present progressive”. Likewise, a newspaper headline says “JONES DIES” , although it is obvious that the time referred to must be in the past. Tense is a mandatory category of English: every sentence must be marked for tense, even if in a way contrary to logic, because every main verb has a tense marker built into to it. By contrast, Lojban brivla have no implicit tense marker attached to them.

<a id="id-1.11.3.7.1" class="indexterm"></a><a id="id-1.11.3.7.2" class="indexterm"></a><a id="id-1.11.3.7.3" class="indexterm"></a><a id="id-1.11.3.7.4" class="indexterm"></a><a id="id-1.11.3.7.5" class="indexterm"></a><a id="id-1.11.3.7.6" class="indexterm"></a>In Lojban, the concept of tense extends to every selbri, not merely the verb-like ones. In addition, tense structures provide information about location in space as well as in time. All tense information is optional in Lojban: a sentence like:

<div class="interlinear-gloss-example example">
<a id="example-random-id-cKSK"></a>

**Example 10.1. <a id="c10e1d1"></a><a id="id-1.11.3.8.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

can be understood as:

*   I went to the market.

*   I am going to the market.

*   I have gone to the market.

*   I will go to the market.

*   I continually go to the market.

as well as many other possibilities: context resolves which is correct.

<a id="id-1.11.3.12.1" class="indexterm"></a><a id="id-1.11.3.12.2" class="indexterm"></a><a id="id-1.11.3.12.3" class="indexterm"></a><a id="id-1.11.3.12.4" class="indexterm"></a>The placement of a tense construct within a Lojban bridi is easy: right before the selbri. It goes immediately after the _<a id="id-1.11.3.12.5.1" class="indexterm"></a>[_cu_](../go01#valsi-cu)_ , and can in fact always replace the _<a id="id-1.11.3.12.6.1" class="indexterm"></a>[_cu_](../go01#valsi-cu)_ (although in very complex sentences the rules for eliding terminators may be changed as a result). In the following examples, _<a id="id-1.11.3.12.7.1" class="indexterm"></a>[_pu_](../go01#valsi-pu)_ is the tense marker for “past time” :

<div class="interlinear-gloss-example example">
<a id="example-random-id-nFgv"></a>

**Example 10.2. <a id="c10e1d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cu</td><td>pu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="jbo"><td>mi</td><td></td><td>pu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td></td><td>in-the-past</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I went to the market.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.3.14.1" class="indexterm"></a><a id="id-1.11.3.14.2" class="indexterm"></a><a id="id-1.11.3.14.3" class="indexterm"></a>It is also possible to put the tense somewhere else in the bridi by adding _<a id="id-1.11.3.14.4.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ after it. This _<a id="id-1.11.3.14.5.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ is an elidable terminator, but it's almost never possible to actually elide it except at the end of the bridi:

<div class="interlinear-gloss-example example">
<a id="example-random-id-5V3Y"></a>

**Example 10.3. <a id="c10e1d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>puku</td><td>mi</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>In-the-past</td><td>I</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Earlier, I went to the market.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-DpEI"></a>

**Example 10.4. <a id="c10e1d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>puku</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>go-to</td><td>in-the-past</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I went earlier to the market.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-0f11"></a>

**Example 10.5. <a id="c10e1d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>le</td><td>zarci</td><td>pu</td><td>[ku]</td></tr><tr class="gloss"><td>I</td><td>go-to</td><td>the</td><td>market</td><td>in-the-past.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I went to the market earlier.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.3.18.1" class="indexterm"></a><a id="id-1.11.3.18.2" class="indexterm"></a>[Example 10.2](../chapter-tenses#example-random-id-nFgv) through [Example 10.5](../chapter-tenses#example-random-id-0f11) are different only in emphasis. Abnormal order, such as [Example 10.3](../chapter-tenses#example-random-id-5V3Y) through [Example 10.5](../chapter-tenses#example-random-id-0f11) exhibit, adds emphasis to the words that have been moved; in this case, the tense cmavo _<a id="id-1.11.3.18.7.1" class="indexterm"></a>[_pu_](../go01#valsi-pu)_. Words at either end of the sentence tend to be more noticeable.