<a id="chapter-phonology"></a>Chapter 3. <a id="c3"></a>The hills are alive with the sounds of Lojban
=====================================================================================================

<a id="chapter-phonology-picture"></a>![The picture for chapter 3](/assets//books/uncll/media/chapter-phonology.gif)

<a id="section-orthography"></a>3.1. <a id="c3s1"></a>Orthography
-----------------------------------------------------------------

<a id="id-1.4.3.2.1" class="indexterm"></a><a id="id-1.4.3.2.2" class="indexterm"></a><a id="id-1.4.3.2.3" class="indexterm"></a><a id="id-1.4.3.2.4" class="indexterm"></a>Lojban is designed so that any properly spoken Lojban utterance can be uniquely transcribed in writing, and any properly written Lojban can be spoken so as to be uniquely reproduced by another person. As a consequence, the standard Lojban orthography must assign to each distinct sound, or phoneme, a unique letter or symbol. Each letter or symbol has only one sound or, more accurately, a limited range of sounds that are permitted pronunciations for that phoneme. Some symbols indicate stress (speech emphasis) and pause, which are also essential to Lojban word recognition. In addition, everything that is represented in other languages by punctuation (when written) or by tone of voice (when spoken) is represented in Lojban by words. These two properties together are known technically as “audio-visual isomorphism”.

<a id="id-1.4.3.3.1" class="indexterm"></a><a id="id-1.4.3.3.2" class="indexterm"></a><a id="id-1.4.3.3.3" class="indexterm"></a>Lojban uses a variant of the Latin (Roman) alphabet, consisting of the following letters and symbols:

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td>'</td><td>,</td><td>.</td><td>a</td><td>b</td><td>c</td><td>d</td><td>e</td><td>f</td><td>g</td><td>i</td><td>j</td><td>k</td></tr><tr><td>l</td><td>m</td><td>n</td><td>o</td><td>p</td><td>r</td><td>s</td><td>t</td><td>u</td><td>v</td><td>x</td><td>y</td><td>z</td></tr></tbody></table>

omitting the letters “h” , “q” , and “w”.

<a id="id-1.4.3.4.1" class="indexterm"></a>The alphabetic order given above is that of the ASCII coded character set, widely used in computers. By making Lojban alphabetical order the same as ASCII, computerized sorting and searching of Lojban text is facilitated.

<a id="id-1.4.3.5.1" class="indexterm"></a><a id="id-1.4.3.5.2" class="indexterm"></a>Capital letters are used only to represent non-standard stress, which can appear only in the representation of Lojbanized names. Thus the English name “Josephine” , as normally pronounced, is Lojbanized as _.DJOsefin._ , pronounced \['ʔdʒosɛfinʔ\]. (See [Section 3.2](../section-basic-phonetics) for an explanation of the symbols within square brackets.) Technically, it is sufficient to capitalize the vowel letter, in this case _O_ , but it is easier on the reader to capitalize the whole syllable.

Without the capitalization, the ordinary rules of Lojban stress would cause the _<a id="id-1.4.3.6.1.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ syllable to be stressed. Lojbanized names are meant to represent the pronunciation of names from other languages with as little distortion as may be; as such, they are exempt from many of the regular rules of Lojban phonology, as will appear in the rest of this chapter.