<a id="chapter-morphology"></a>Chapter 4. <a id="c4"></a>The shape of words to come: Lojban morphology
======================================================================================================

<a id="chapter-morphology-picture"></a>![The picture for chapter 4](/assets//books/uncll/media/chapter-morphology.gif)

<a id="section-morphology-introduction"></a>4.1. <a id="c4s1"></a>Introductory
------------------------------------------------------------------------------

<a id="id-1.5.3.2.1" class="indexterm"></a><a id="id-1.5.3.2.2" class="indexterm"></a><a id="id-1.5.3.2.3" class="indexterm"></a>Morphology is the part of grammar that deals with the form of words. Lojban's morphology is fairly simple compared to that of many languages, because Lojban words don't change form depending on how they are used. English has only a small number of such changes compared to languages like Russian, but it does have changes like “boys” as the plural of “boy” , or “walked” as the past-tense form of “walk”. To make plurals or past tenses in Lojban, you add separate words to the sentence that express the number of boys, or the time when the walking was going on.

<a id="id-1.5.3.3.1" class="indexterm"></a><a id="id-1.5.3.3.2" class="indexterm"></a><a id="id-1.5.3.3.3" class="indexterm"></a>However, Lojban does have what is called “derivational morphology” : the capability of building new words from old words. In addition, the form of words tells us something about their grammatical uses, and sometimes about the means by which they entered the language. Lojban has very orderly rules for the formation of words of various types, both the words that already exist and new words yet to be created by speakers and writers.

<a id="id-1.5.3.4.1" class="indexterm"></a>A stream of Lojban sounds can be uniquely broken up into its component words according to specific rules. These so-called “morphology rules” are summarized in this chapter. (However, a detailed algorithm for breaking sounds into words has not yet been fully debugged, and so is not presented in this book.) First, here are some conventions used to talk about groups of Lojban letters, including vowels and consonants.

1.  <a id="id-1.5.3.5.1.1.1" class="indexterm"></a><a id="id-1.5.3.5.1.1.2" class="indexterm"></a><a id="id-1.5.3.5.1.1.3" class="indexterm"></a>V represents any single Lojban vowel except _y_ ; that is, it represents _a_ , _e_ , _i_ , _o_ , or _u_.

2.  <a id="id-1.5.3.5.2.1.1" class="indexterm"></a>VV represents either a diphthong, one of the following:

    <table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">ai</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">ei</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">oi</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">au</em></span></td></tr></tbody></table>

    or a two-syllable vowel pair with an apostrophe separating the vowels, one of the following:

    <table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">a'a</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">a'e</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">a'i</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">a'o</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">a'u</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">e'a</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">e'e</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">e'i</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">e'o</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">e'u</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">i'a</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">i'e</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">i'i</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">i'o</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">i'u</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">o'a</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">o'e</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">o'i</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">o'o</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">o'u</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">u'a</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">u'e</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">u'i</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">u'o</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">u'u</em></span></td></tr></tbody></table>

3.  <a id="id-1.5.3.5.3.1.1" class="indexterm"></a><a id="id-1.5.3.5.3.1.2" class="indexterm"></a><a id="id-1.5.3.5.3.1.3" class="indexterm"></a><a id="id-1.5.3.5.3.1.4" class="indexterm"></a><a id="id-1.5.3.5.3.1.5" class="indexterm"></a><a id="id-1.5.3.5.3.1.6" class="indexterm"></a>C represents a single Lojban consonant, not including the apostrophe, one of _b_ , _c_ , _d_ , _f_ , _g_ , _j_ , _k_ , _l_ , _m_ , _n_ , _p_ , _r_ , _s_ , _t_ , _v_ , _x_ , or _z_ . Syllabic _l_ , _m_ , _n_ , and _r_ always count as consonants for the purposes of this chapter.

4.  <a id="id-1.5.3.5.4.1.1" class="indexterm"></a>CC represents two adjacent consonants of type C which constitute one of the 48 permissible initial consonant pairs:

    <table class="noborder"><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">pl</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">pr</em></span></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">fl</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">fr</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">bl</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">br</em></span></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">vl</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">vr</em></span></td></tr><tr><td><p></p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">cp</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">cf</em></span></td><td></td><td></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">ct</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">ck</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">cm</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">cn</em></span></td><td></td><td></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">cl</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">cr</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">jb</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">jv</em></span></td><td></td><td></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">jd</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">jg</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">jm</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">sp</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">sf</em></span></td><td></td><td></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">st</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">sk</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">sm</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">sn</em></span></td><td></td><td></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">sl</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">sr</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">zb</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">zv</em></span></td><td></td><td></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">zd</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">zg</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">zm</em></span></td></tr><tr><td><p></p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">tc</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">tr</em></span></td><td></td><td></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">ts</em></span></td><td></td><td></td><td></td><td></td><td></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">kl</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">kr</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">dj</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">dr</em></span></td><td></td><td></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">dz</em></span></td><td></td><td></td><td></td><td></td><td></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">gl</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">gr</em></span></td></tr><tr><td><p></p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">ml</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">mr</em></span></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">xl</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">xr</em></span></td></tr></tbody></table>

5.  <a id="id-1.5.3.5.5.1.1" class="indexterm"></a>C/C represents two adjacent consonants which constitute one of the permissible consonant pairs (not necessarily a permissible initial consonant pair). The permissible consonant pairs are explained in [Section 3.6](../section-clusters). In brief, any consonant pair is permissible unless it: contains two identical letters, contains both a voiced (excluding _r_ , _l_ , _m_ , _n_) and an unvoiced consonant, or is one of certain specified forbidden pairs.

6.  <a id="id-1.5.3.5.6.1.1" class="indexterm"></a>C/CC represents a consonant triple. The first two consonants must constitute a permissible consonant pair; the last two consonants must constitute a permissible initial consonant pair.

<a id="id-1.5.3.6.1" class="indexterm"></a><a id="id-1.5.3.6.2" class="indexterm"></a><a id="id-1.5.3.6.3" class="indexterm"></a><a id="id-1.5.3.6.4" class="indexterm"></a><a id="id-1.5.3.6.5" class="indexterm"></a>Lojban has three basic word classes – parts of speech – in contrast to the eight that are traditional in English. These three classes are called cmavo, brivla, and cmevla. Each of these classes has uniquely identifying properties – an arrangement of letters that allows the word to be uniquely and unambiguously recognized as a separate word in a string of Lojban, upon either reading or hearing, and as belonging to a specific word-class.

They are also functionally different: cmavo are the structure words, corresponding to English words like “and” , “if” , “the” and “to” ; brivla are the content words, corresponding to English words like “come” , “red” , “doctor” , and “freely” ; cmevla are proper names, corresponding to English “James” , “Afghanistan” , and “Pope John Paul II”.