<a id="chapter-lujvo"></a>Chapter 12. <a id="c12"></a>Dog house and white house: determining lujvo place structures
===================================================================================================================

<a id="chapter-lujvo-picture"></a>![The picture for chapter 12](/assets//books/uncll/media/chapter-lujvo.svg.png)

<a id="section-why-lujvo"></a>12.1. <a id="c12s1"></a>Why have lujvo?
---------------------------------------------------------------------

The Lojban vocabulary is founded on its list of 1350-plus gismu, made up by combining word lists from various sources. These gismu are not intended to be either a complete vocabulary for the language nor a minimal list of semantic primitives. Instead, the gismu list serves as a basis for the creation of compound words, or lujvo. The intention is that (except in certain semantically broad but shallow fields such as cultures, nations, foods, plants, and animals) suitable lujvo can be devised to cover the ten million or so concepts expressible in all the world's languages taken together. Grammatically, lujvo behave just like gismu: they have place structures and function as selbri.

<a id="id-1.13.3.3.1" class="indexterm"></a>There is a close relationship between lujvo and tanru. In fact, lujvo are condensed forms of tanru:

<div class="interlinear-gloss-example example">
<a id="example-random-id-m9zv"></a>

**Example 12.1. <a id="c12e1d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ti</td><td></td><td>fagri</td><td>festi</td></tr><tr class="gloss"><td>That</td><td>is</td><td>fire</td><td>waste.</td></tr></tbody></table>

</div>  

contains a tanru which can be reduced to the lujvo in:

<div class="interlinear-gloss-example example">
<a id="example-random-id-rYj5"></a>

**Example 12.2. <a id="c12e1d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ti</td><td>fagyfesti</td></tr><tr class="gloss"><td>That</td><td>is-fire-waste.</td></tr><tr class="gloss"><td>That</td><td>is-ashes.</td></tr></tbody></table>

</div>  

Although the lujvo _<a id="id-1.13.3.7.1.1" class="indexterm"></a>[_fagyfesti_](../go01#valsi-fagyfesti)_ is derived from the tanru _<a id="id-1.13.3.7.2.1" class="indexterm"></a>fagri festi_ , it is not equivalent in meaning to it. In particular, _<a id="id-1.13.3.7.3.1" class="indexterm"></a>[_fagyfesti_](../go01#valsi-fagyfesti)_ has a distinct place structure of its own, not the same as that of _<a id="id-1.13.3.7.4.1" class="indexterm"></a>[_festi_](../go01#valsi-festi)_. (In contrast, the tanru does have the same place structure as _<a id="id-1.13.3.7.5.1" class="indexterm"></a>[_festi_](../go01#valsi-festi)_.) The lujvo needs to take account of the places of _<a id="id-1.13.3.7.6.1" class="indexterm"></a>[_fagri_](../go01#valsi-fagri)_ as well. When a tanru is made into a lujvo, there is no equivalent of _<a id="id-1.13.3.7.7.1" class="indexterm"></a>[_be_](../go01#valsi-be)_ … _<a id="id-1.13.3.7.8.1" class="indexterm"></a>[_bei_](../go01#valsi-bei)_ … _<a id="id-1.13.3.7.9.1" class="indexterm"></a>[_be'o_](../go01#valsi-beho)_ (described in [Section 5.7](../section-be-sumti)) to incorporate sumti into the middle of the lujvo.

<a id="id-1.13.3.8.1" class="indexterm"></a><a id="id-1.13.3.8.2" class="indexterm"></a>So why have lujvo? Primarily to reduce semantic ambiguity. On hearing a tanru, there is a burden on the listener to figure out what the tanru might mean. Adding further terms to the tanru reduces ambiguity in one sense, by providing more information; but it increases ambiguity in another sense, because there are more and more tanru joints, each with an ambiguous significance. Since lujvo, like other brivla, have a fixed place structure and a single meaning, encapsulating a commonly-used tanru into a lujvo relieves the listener of the burden of creative understanding. In addition, lujvo are typically shorter than the corresponding tanru.

<a id="id-1.13.3.9.1" class="indexterm"></a><a id="id-1.13.3.9.2" class="indexterm"></a><a id="id-1.13.3.9.3" class="indexterm"></a><a id="id-1.13.3.9.4" class="indexterm"></a>There are no absolute laws fixing the place structure of a newly created lujvo. The maker must consider the place structures of all the components of the tanru and then decide which are still relevant and which can be removed. What is said in this chapter represents guidelines, presented as one possible standard, not necessarily complete, and not the only possible standard. There may well be lujvo that are built without regard for these guidelines, or in accordance with entirely different guidelines, should such alternative guidelines someday be developed. The reason for presenting any guidelines at all is so that Lojbanists have a starting point for deciding on a likely place structure – one that others seeing the same word can also arrive at by similar consideration.

<a id="id-1.13.3.10.1" class="indexterm"></a>If the tanru includes connective cmavo such as _<a id="id-1.13.3.10.2.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ , _<a id="id-1.13.3.10.3.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ , _<a id="id-1.13.3.10.4.1" class="indexterm"></a>[_ke'e_](../go01#valsi-kehe)_ , or _<a id="id-1.13.3.10.5.1" class="indexterm"></a>[_je_](../go01#valsi-je)_ , or conversion or abstraction cmavo such as _<a id="id-1.13.3.10.6.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ or _<a id="id-1.13.3.10.7.1" class="indexterm"></a>[_nu_](../go01#valsi-nu)_ , there are ways of incorporating them into the lujvo as well. Sometimes this makes the lujvo excessively long; if so, the cmavo may be dropped. This leads to the possibility that more than one tanru could produce the same lujvo. Typically, however, only one of the possible tanru is useful enough to justify making a lujvo for it.

The exact workings of the lujvo-making algorithm, which takes a tanru built from gismu (and possibly cmavo) and produces a lujvo from it, are described in [Section 4.11](../section-lujvo-making).