<a id="chapter-letterals"></a>Chapter 17. <a id="c17"></a>As easy as A-B-C? The Lojban letteral system and its uses
===================================================================================================================

<a id="chapter-letterals-picture"></a>![The picture for chapter 17](/assets//books/uncll/media/chapter-letterals.svg.png)

<a id="section-letterals-introduction"></a>17.1. <a id="c17s1"></a>What's a letteral, anyway?
---------------------------------------------------------------------------------------------

<a id="id-1.18.3.2.1" class="indexterm"></a><a id="id-1.18.3.2.2" class="indexterm"></a><a id="id-1.18.3.2.3" class="indexterm"></a>James Cooke Brown, the founder of the Loglan Project, coined the word “letteral” (by analogy with “numeral”) to mean a letter of the alphabet, such as “f” or “z”. A typical example of its use might be

<div class="example">
<a id="example-random-id-tvHm"></a>

**Example 17.1. <a id="c17e1d1"></a><a id="id-1.18.3.3.1.2" class="indexterm"></a>** 

There are fourteen occurrences of the letteral “e” in this sentence.

</div>  

<a id="id-1.18.3.4.1" class="indexterm"></a>(Don't forget the one within quotation marks.) Using the word “letteral” avoids confusion with “letter” , the kind you write to someone. Not surprisingly, there is a Lojban gismu for “letteral” , namely _<a id="id-1.18.3.4.5.1" class="indexterm"></a>[_lerfu_](../go01#valsi-lerfu)_ , and this word will be used in the rest of this chapter.

<a id="id-1.18.3.5.1" class="indexterm"></a><a id="id-1.18.3.5.2" class="indexterm"></a>Lojban uses the Latin alphabet, just as English does, right? Then why is there a need for a chapter like this? After all, everyone who can read it already knows the alphabet. The answer is twofold:

<a id="id-1.18.3.6.1" class="indexterm"></a>First, in English there are a set of words that correspond to and represent the English lerfu. These words are rarely written down in English and have no standard spellings, but if you pronounce the English alphabet to yourself you will hear them: ay, bee, cee, dee ... . They are used in spelling out words and in pronouncing most acronyms. The Lojban equivalents of these words are standardized and must be documented somehow.

<a id="id-1.18.3.7.1" class="indexterm"></a>Second, English has names only for the lerfu used in writing English. (There are also English names for Greek and Hebrew lerfu: English-speakers usually refer to the Greek lerfu conventionally spelled “phi” as “fye” , whereas “fee” would more nearly represent the name used by Greek-speakers. Still, not all English-speakers know these English names.) Lojban, in order to be culturally neutral, needs a more comprehensive system that can handle, at least potentially, all of the world's alphabets and other writing systems.

Letterals have several uses in Lojban: in forming acronyms and abbreviations, as mathematical symbols, and as pro-sumti – the equivalent of English pronouns.

<a id="id-1.18.3.9.1" class="indexterm"></a><a id="id-1.18.3.9.2" class="indexterm"></a><a id="id-1.18.3.9.3" class="indexterm"></a><a id="id-1.18.3.9.4" class="indexterm"></a>In earlier writings about Lojban, there has been a tendency to use the word _<a id="id-1.18.3.9.5.1" class="indexterm"></a>[_lerfu_](../go01#valsi-lerfu)_ for both the letterals themselves and for the Lojban words which represent them. In this chapter, that tendency will be ruthlessly suppressed, and the term “lerfu word” will invariably be used for the latter. The Lojban equivalent would be _<a id="id-1.18.3.9.7.1" class="indexterm"></a>lerfu valsi_ or _<a id="id-1.18.3.9.8.1" class="indexterm"></a>[_lervla_](../go01#valsi-lervla)_.