<a id="chapter-catalogue"></a>Chapter 20. <a id="c20"></a>A catalogue of selma'o
================================================================================

<a id="chapter-catalogue-picture"></a>![The picture for chapter 20](/assets//books/uncll/media/chapter-catalogue.svg.png)

<a id="section-index"></a>20.1. <a id="c20s1"></a>A catalogue of selma'o
------------------------------------------------------------------------

<a id="id-1.21.3.2.1" class="indexterm"></a>The following paragraphs list all the selma'o of Lojban, with a brief explanation of what each one is about, and reference to the chapter number where each is explained more fully. As usual, all selma'o names are given in capital letters (with “h” serving as the capital of “'”) and are the names of a representative cmavo, often the most important or the first in alphabetical order. One example is given of each selma'o: for selma'o which have several uses, the most common use is shown.

### <a id="id-1.21.3.3"></a><a id="A"></a>selma'o A ( [Section 14.6](../section-sumti-connection))

Specifies a logical connection (e.g. “and”, “or”, “if”), usually between sumti.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la&nbsp;.djan.</td><td>a</td><td>la&nbsp;.djein.</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>John</td><td>and/or</td><td>Jane</td><td>goes-to</td><td>the</td><td>store</td></tr></tbody></table>

Also used to create vowel lerfu words when followed with “bu”.

### <a id="id-1.21.3.7"></a><a id="BAI"></a>selma'o BAI ( [Section 9.6](../section-BAI))

May be prefixed to a sumti to specify an additional place, not otherwise present in the place structure of the selbri, and derived from a single place of some other selbri.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>tavla</td><td>bau</td><td>la&nbsp;.lojban.</td></tr><tr class="gloss"><td>I</td><td>speak</td><td>in-language</td><td>Lojban.</td></tr></tbody></table>

### <a id="id-1.21.3.10"></a><a id="BAhE"></a>selma'o BAhE ( [Section 19.11](../section-bahe))

Emphasizes the next single word, or marks it as a nonce word (one invented for the occasion).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la&nbsp;ba'e&nbsp;.djordj.</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td><span class="emphasis"><em>George</em></span></td><td>goes-to</td><td>the</td><td>store.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">It is George who goes to the store.</p></td></tr></tbody></table>

### <a id="id-1.21.3.14"></a><a id="BE"></a>selma'o BE ( [Section 5.7](../section-be-sumti))

Attaches sumti which fill the place structure of a single unit making up a tanru. Unless otherwise indicated, the sumti fill the x2, x3, and successive places in that order. [BE](../chapter-catalogue#BE) is most useful in descriptions formed with [LE](../chapter-catalogue#LE). See [BEI](../chapter-catalogue#BEI) , [BEhO](../chapter-catalogue#BEhO).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td></td><td>klama</td><td>be</td><td>ta</td><td>&nbsp;</td><td>troci</td></tr><tr class="gloss"><td>I</td><td>am-a</td><td>(goer</td><td>to</td><td>that)</td><td>type-of</td><td>trier.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I try to go to that place.</p></td></tr></tbody></table>

### <a id="id-1.21.3.18"></a><a id="BEI"></a>selma'o BEI ( [Section 5.7](../section-be-sumti))

Separates multiple sumti attached by [BE](../chapter-catalogue#BE) to a tanru unit.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td></td><td>klama</td><td>be</td><td>le</td><td>zarci</td><td>bei</td><td>le</td><td>zdani</td><td>be'o</td><td>&nbsp;</td><td>troci</td></tr><tr class="gloss"><td>I</td><td>am-a</td><td>(goer</td><td>to</td><td>the</td><td>store</td><td>from</td><td>the</td><td>home</td><td>)</td><td>type-of</td><td>trier.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I try to go from the home to the market.</p></td></tr></tbody></table>

### <a id="id-1.21.3.22"></a><a id="BEhO"></a>selma'o BEhO ( [Section 5.7](../section-be-sumti))

Elidable terminator for [BE](../chapter-catalogue#BE). Terminates sumti that are attached to a tanru unit.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td></td><td>klama</td><td>be</td><td>le</td><td>zarci</td><td>be'o</td><td>&nbsp;</td><td>troci</td></tr><tr class="gloss"><td>I</td><td>am-a</td><td>(goer</td><td>to</td><td>the</td><td>market</td><td>)</td><td>type-of</td><td>trier.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I try to go to the market.</p></td></tr></tbody></table>

### <a id="id-1.21.3.26"></a><a id="BIhE"></a>selma'o BIhE ( [Section 18.5](../section-simple-infix))

Prefixed to a mathematical operator to mark it as higher priority than other mathematical operators, binding its operands more closely.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ci</td><td>bi'e</td><td>pi'i</td><td>vo</td><td>su'i</td><td>mu</td><td>du</td><td>li</td><td>paze</td></tr><tr class="gloss"><td>The-number</td><td>3</td><td>[priority]</td><td>times</td><td>4</td><td>plus</td><td>5</td><td>equals</td><td>the-number</td><td>17.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"></p><div class="informalequation"><span class="mathphrase">3 × 4 + 5 = 17</span></div><p class="natlang"></p></td></tr></tbody></table>

### <a id="id-1.21.3.30"></a><a id="BIhI"></a>selma'o BIhI ( [Section 14.16](../section-non-logical-continued-continued))

Joins sumti or tanru units (as well as some other things) to form intervals. See [GAhO](../chapter-catalogue#GAhO).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ca</td><td>sanli</td><td>la&nbsp;.drezdn.</td><td>bi'i</td><td>la&nbsp;.frankfurt.</td></tr><tr class="gloss"><td>I</td><td>[present]</td><td>stand-on-surface</td><td>Dresden</td><td>[interval]</td><td>Frankfurt.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am standing between Dresden and Frankfurt.</p></td></tr></tbody></table>

### <a id="id-1.21.3.34"></a><a id="BO"></a>selma'o BO ( [Section 5.3](../section-three-part-tanru) , [Section 15.6](../section-sumti-negation) , [Section 18.17](../section-connectives-within-mekso))

Joins tanru units, binding them together closely. Also used to bind logically or non-logically connected phrases, sentences, etc. [BO](../chapter-catalogue#BO) is always high precedence and right-grouping.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>cmalu</td><td></td><td>nixli</td><td>bo</td><td>ckule</td></tr><tr class="gloss"><td>That</td><td>is-a-small</td><td>type-of</td><td>(girl</td><td>type-of</td><td>school).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That is a small school for girls.</p></td></tr></tbody></table>

### <a id="id-1.21.3.38"></a><a id="BOI"></a>selma'o BOI ( [Section 18.6](../section-forethought))

Elidable terminator for [PA](../chapter-catalogue#PA) or [BY](../chapter-catalogue#BY). Used to terminate a number (string of numeric cmavo) or lerfu string (string of letter words) when another string immediately follows.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>re</td><td>du</td><td>li</td><td>vu'u</td><td>vo&nbsp;boi</td><td></td><td>re</td></tr><tr class="gloss"><td>The-number</td><td>two</td><td>equals</td><td>the-number</td><td>the-difference-of</td><td>four</td><td>and</td><td>two.</td></tr></tbody></table>

### <a id="id-1.21.3.41"></a><a id="BU"></a>selma'o BU ( [Section 17.4](../section-bu))

A suffix which can be attached to any word, typically a word representing a letter of the alphabet or else a name, to make a word for a symbol or a different letter of the alphabet. In particular, attached to single-vowel cmavo to make words for vowel letters.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.abu</td><td>.ebu</td><td>.ibu</td><td>.obu</td><td>.ubu</td><td>.ybu</td></tr><tr class="gloss"><td>a,</td><td>e,</td><td>i,</td><td>o,</td><td>u,</td><td>y.</td></tr></tbody></table>

### <a id="id-1.21.3.44"></a><a id="BY"></a>selma'o BY ( [Section 17.2](../section-lerfu-liste))

Words representing the letters of the Lojban alphabet, plus various shift words which alter the interpretation of other letter words. Terminated by BOI.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.abu</td><td>tavla</td><td>by</td><td></td><td>le</td><td>&nbsp;</td><td>la&nbsp;.ibymym.</td><td>skami</td></tr><tr class="gloss"><td>A</td><td>talks-to</td><td>B</td><td>about</td><td>the</td><td>of-</td><td>IBM</td><td>computers.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">A talks to B about IBM computers.</p></td></tr></tbody></table>

### <a id="id-1.21.3.48"></a><a id="CAI"></a>selma'o CAI ( [Section 13.4](../section-intensity-scale))

Indicates the intensity of an emotion: maximum, strong, weak, or not at all. Typically follows another particle which specifies the emotion.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ei</td><td>cai</td><td>mi</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>[Obligation!]</td><td>[Intense!]</td><td>I</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I must go to the market.</p></td></tr></tbody></table>

### <a id="id-1.21.3.52"></a><a id="CAhA"></a>selma'o CAhA ( [Section 10.19](../section-caha))

Specifies whether a bridi refers to an actual fact, a potential (achieved or not), or merely an innate capability.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ro</td><td>datka</td><td>ka'e</td><td>flulimna</td></tr><tr class="gloss"><td>All</td><td>ducks</td><td>[capability]</td><td>are-float-swimmers.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">All ducks have the capability of swimming by floating.</p></td></tr></tbody></table>

### <a id="id-1.21.3.56"></a><a id="CEI"></a>selma'o CEI ( [Section 7.5](../section-koha-broda-series))

Assigns a selbri definition to one of the five pro-bridi gismu: “broda”, “brode”, “brodi”, “brodo”, or “brodu”, for later use.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">ti slasi je mlatu bo cidja lante gacri cei broda</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">This is a plastic cat-food can cover, or thingy.</p></td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">.i le crino broda cu barda .i le xunre broda cu cmalu</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The green thingy is large. The red thingy is small.</p></td></tr></tbody></table>

### <a id="id-1.21.3.62"></a><a id="CEhE"></a>selma'o CEhE ( [Section 14.11](../section-termsets) , [Section 16.7](../section-quantifier-grouping))

Joins multiple terms into a termset. Termsets are used to associate several terms for logical connectives, for equal quantifier scope, or for special constructs in tenses.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ce'e</td><td>do</td><td>pe'e</td><td>je</td><td>la&nbsp;.djan.</td><td>ce'e</td><td>la&nbsp;.djeimyz.</td><td>cu</td><td>pendo</td></tr><tr class="gloss"><td>I</td><td>[,]</td><td>you</td><td>[joint]</td><td>and</td><td>John</td><td>[,]</td><td>James</td><td>&nbsp;</td><td>are-friends-of.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am a friend of you, and John is a friend of James.</p></td></tr></tbody></table>

### <a id="id-1.21.3.66"></a><a id="CO"></a>selma'o CO ( [Section 5.8](../section-co-inversion))

When inserted between the components of a tanru, inverts it, so that the following tanru unit modifies the previous one.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>troci</td><td>co</td><td>klama</td><td>le</td><td>zarci</td><td></td><td>le</td><td>zdani</td></tr><tr class="gloss"><td>I</td><td>am-a-trier</td><td>of-type</td><td>(goer-to</td><td>the</td><td>market</td><td>from</td><td>the</td><td>house).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I try to go to the market from the house.</p></td></tr></tbody></table>

### <a id="id-1.21.3.70"></a><a id="COI"></a>selma'o COI ( [Section 6.11](../section-vocative-syntax) , [Section 13.14](../section-vocative-scales))

When prefixed to a cmevla, description, or sumti, produces a vocative: a phrase which indicates who is being spoken to (or who is speaking). Vocatives are used in conversational protocols, including greeting, farewell, and radio communication. Terminated by [DOhU](../chapter-catalogue#DOhU). See [DOI](../chapter-catalogue#DOI).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>coi</td><td>.djan.</td></tr><tr class="gloss"><td>Greetings,</td><td>John.</td></tr></tbody></table>

### <a id="id-1.21.3.73"></a><a id="CU"></a>selma'o CU ( [Section 9.2](../section-cu))

Separates the selbri of a bridi from any sumti which precede it. Never strictly necessary, but often useful to eliminate various elidable terminators.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>gerku</td><td>cu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>The</td><td>dog</td><td>&nbsp;</td><td>goes-to</td><td>the</td><td>store.</td></tr></tbody></table>

### <a id="id-1.21.3.76"></a><a id="CUhE"></a>selma'o CUhE ( [Section 10.24](../section-tense-questions))

Forms a question which asks when, where, or in what mode the rest of the bridi is true. See [PU](../chapter-catalogue#PU) , [CAhA](../chapter-catalogue#CAhA) , [TAhE](../chapter-catalogue#TAhE) , and [BAI](../chapter-catalogue#BAI).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>cu'e</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>You</td><td>[When/Where?]</td><td>go-to</td><td>the</td><td>store?</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">When are you going to the store?</p></td></tr></tbody></table>

### <a id="id-1.21.3.80"></a><a id="DAhO"></a>selma'o DAhO ( [Section 7.13](../section-daho))

Cancels the assigned significance of all sumti cmavo (of selma'o [KOhA](../chapter-catalogue#KOhA)) and bridi cmavo (of selma'o [GOhA](../chapter-catalogue#GOhA)).

### <a id="id-1.21.3.82"></a><a id="DOI"></a>selma'o DOI ( [Section 13.14](../section-vocative-scales))

The non-specific vocative indicator. See [DOhU](../chapter-catalogue#DOhU).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>doi</td><td>.frank.</td><td>mi</td><td>tavla</td><td>do</td></tr><tr class="gloss"><td>O</td><td>Frank,</td><td>I</td><td>speak-to</td><td>you.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Frank, I'm talking to you.</p></td></tr></tbody></table>

### <a id="id-1.21.3.86"></a><a id="DOhU"></a>selma'o DOhU ( [Section 13.14](../section-vocative-scales))

Elidable terminator for [COI](../chapter-catalogue#COI) or [DOI](../chapter-catalogue#DOI). Signals the end of a vocative.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>coi</td><td>do'u</td></tr><tr class="gloss"><td>Greetings</td><td>[terminator]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Greetings, O unspecified one!</p></td></tr></tbody></table>

### <a id="id-1.21.3.90"></a><a id="FA"></a>selma'o FA ( [Section 9.3](../section-FA))

Prefix for a sumti, indicating which numbered place in the place structure the sumti belongs in; overrides word order.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>fa</td><td>mi</td><td>cu</td><td>klama</td><td>fi</td><td>la&nbsp;.atlantas.</td></tr><tr class="gloss"><td>x<sub>1</sub>=</td><td>I</td><td>&nbsp;</td><td>go</td><td>x<sub>3</sub>=</td><td>Atlanta</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>fe</td><td>la&nbsp;.bastn.</td><td>fo</td><td>le</td><td>dargu</td><td>fu</td><td>le</td><td>karce</td></tr><tr class="gloss"><td>x<sub>2</sub>=</td><td>Boston</td><td>x<sub>4</sub>=</td><td>the</td><td>road</td><td>x<sub>5</sub>=</td><td>the</td><td>car.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I go from Atlanta to Boston via the road using the car.</p></td></tr></tbody></table>

### <a id="id-1.21.3.95"></a><a id="FAhA"></a>selma'o FAhA ( [Section 10.2](../section-spatial-tenses))

Specifies the direction in which, or toward which (when marked with [MOhI](../chapter-catalogue#MOhI)) or along which (when prefixed by [VEhA](../chapter-catalogue#VEhA) or [VIhA](../chapter-catalogue#VIhA)) the action of the bridi takes place.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>zu'a</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td>[left]</td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">To my left, the man bites the dog.</p></td></tr></tbody></table>

### <a id="id-1.21.3.99"></a><a id="FAhO"></a>selma'o FAhO ( [Section 19.15](../section-faho))

A mechanical signal, outside the grammar, indicating that there is no more text. Useful in talking to computers.

### <a id="id-1.21.3.101"></a><a id="FEhE"></a>selma'o FEhE ( [Section 10.11](../section-fehe))

Indicates that the following interval modifier (using [TAhE](../chapter-catalogue#TAhE) , [ROI](../chapter-catalogue#ROI) , or [ZAhO](../chapter-catalogue#ZAhO)) refers to space rather than time.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ko</td><td>vi'i</td><td>fe'e</td><td>di'i</td><td>sombo</td><td>le</td><td>gurni</td></tr><tr class="gloss"><td>You-imperative</td><td>[1-dimensional]</td><td>[space]</td><td>[regularly]</td><td>sow</td><td>the</td><td>grain.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Sow the grain in a line and evenly!</p></td></tr></tbody></table>

### <a id="id-1.21.3.105"></a><a id="FEhU"></a>selma'o FEhU ( [Section 9.5](../section-selbri-modals))

Elidable terminator for [FIhO](../chapter-catalogue#FIhO). Indicates the end of an ad hoc modal tag: the tagged sumti immediately follows.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>do</td><td>fi'o</td><td>kanla</td><td>[fe'u]</td><td>le</td><td>zunle</td></tr><tr class="gloss"><td>I</td><td>see</td><td>you</td><td>[modal]</td><td>eye</td><td>:</td><td>the</td><td>left-thing</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I see you with the left eye.</p></td></tr></tbody></table>

### <a id="id-1.21.3.109"></a><a id="FIhO"></a>selma'o FIhO ( [Section 9.5](../section-selbri-modals))

When placed before a selbri, transforms the selbri into a modal tag, grammatically and semantically equivalent to a member of selma'o [BAI](../chapter-catalogue#BAI). Terminated by [FEhU](../chapter-catalogue#FEhU).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>do</td><td>fi'o</td><td>kanla</td><td>le</td><td>zunle</td></tr><tr class="gloss"><td>I</td><td>see</td><td>you</td><td>with</td><td>eye</td><td>the</td><td>left-thing</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I see you with my left eye.</p></td></tr></tbody></table>

### <a id="id-1.21.3.113"></a><a id="FOI"></a>selma'o FOI ( [Section 17.6](../section-accents))

Signals the end of a compound alphabet letter word that begins with [TEI](../chapter-catalogue#TEI). Not an elidable terminator.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>tei</td><td>.ebu</td><td>.akut.&nbsp;bu</td><td>foi</td></tr><tr class="gloss"><td>(</td><td>“e”</td><td>“acute”</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the letter “e” with an acute accent</p></td></tr></tbody></table>

### <a id="id-1.21.3.117"></a><a id="FUhA"></a>selma'o FUhA ( [Section 18.16](../section-reverse-polish-notation))

Indicates that the following mathematical expression is to be interpreted as reverse Polish (RP), a mode in which mathematical operators follow their operands.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>fu'a</td><td>reboi</td><td>re[boi]</td><td>su'i</td><td>du</td><td>li</td><td>vo</td></tr><tr class="gloss"><td>the-number</td><td>[RP!]</td><td>two,</td><td>two,</td><td>plus</td><td>equals</td><td>the-number</td><td>four</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"></p><div class="informalequation"><span class="mathphrase">2 + 2 = 4</span></div><p class="natlang"></p></td></tr></tbody></table>

### <a id="id-1.21.3.121"></a><a id="FUhE"></a>selma'o FUhE ( [Section 19.8](../section-attitudinal-scope))

Indicates that the following indicator(s) of selma'o [UI](../chapter-catalogue#UI) affect not the preceding word, as usual, but rather all following words until a [FUhO](../chapter-catalogue#FUhO).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>le</td><td>fu'e</td><td>.ia</td><td>blanu</td><td>zdani</td><td>fu'o</td><td>ponse</td></tr><tr class="gloss"><td>I</td><td>see</td><td>the</td><td>[start]</td><td>[belief]</td><td>blue</td><td>house</td><td>[end]</td><td>possessor</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I see the owner of a blue house, or what I believe to be one.</p></td></tr></tbody></table>

### <a id="id-1.21.3.125"></a><a id="FUhO"></a>selma'o FUhO ( [Section 19.8](../section-attitudinal-scope))

Cancels all indicators of selma'o [UI](../chapter-catalogue#UI) which are in effect.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>le</td><td>fu'e</td><td>.ia</td><td>blanu</td><td>zdani</td><td>fu'o</td><td>ponse</td></tr><tr class="gloss"><td>I</td><td>see</td><td>the</td><td>[start]</td><td>[belief]</td><td>blue</td><td>house</td><td>[end]</td><td>possessor.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I see the owner of what I believe to be a blue house.</p></td></tr></tbody></table>

### <a id="id-1.21.3.129"></a><a id="GA"></a>selma'o GA ( [Section 14.5](../section-forethought-bridi-connection))

Indicates the beginning of two logically connected sumti, bridi-tails, or various other things. Logical connections include “both ... and”, “either ... or”, “if ... then”, and so on. See [GI](../chapter-catalogue#GI).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">ga la .djan. nanmu gi la .djeimyz. ninmu</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Either John is a man or James is a woman (or both).</p></td></tr></tbody></table>

### <a id="id-1.21.3.133"></a><a id="GAhO"></a>selma'o GAhO ( [Section 14.16](../section-non-logical-continued-continued))

Specifies whether an interval specified by [BIhI](../chapter-catalogue#BIhI) includes or excludes its endpoints. Used in pairs before and after the [BIhI](../chapter-catalogue#BIhI) cmavo, to specify the nature of both the left- and the right-hand endpoints.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ca</td><td>sanli</td><td>la&nbsp;.drezdn.</td></tr><tr class="gloss"><td>I</td><td>[present]</td><td>stand</td><td>Dresden</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ga'o</td><td>bi'i</td><td>ga'o</td><td>la&nbsp;.frankfurt.</td></tr><tr class="gloss"><td>[inclusive]</td><td>[interval]</td><td>[inclusive]</td><td>Frankfurt.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am standing between Dresden and Frankfurt, inclusive of both.</p></td></tr></tbody></table>

### <a id="id-1.21.3.138"></a><a id="GEhU"></a>selma'o GEhU ( [Section 8.3](../section-relative-phrases))

Elidable terminator for [GOI](../chapter-catalogue#GOI). Marks the end of a relative phrase. See [KUhO](../chapter-catalogue#KUhO).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la&nbsp;.djan.</td><td>goi</td><td>ko'a</td><td>ge'u</td><td>blanu</td></tr><tr class="gloss"><td>John</td><td>(referred&nbsp;to&nbsp;as</td><td>it-1</td><td>)</td><td>is-blue.</td></tr></tbody></table>

### <a id="id-1.21.3.141"></a><a id="GI"></a>selma'o GI ( [Section 14.5](../section-forethought-bridi-connection))

Separates two logically or non-logically connected sumti, tanru units, bridi-tails, or other things, when the prefix is a forethought connective involving [GA](../chapter-catalogue#GA) , [GUhA](../chapter-catalogue#GUhA) , or [JOI](../chapter-catalogue#JOI).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">ge la .djan. nanmu gi la .djeimyz. ninmu</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">(It is true that) both John is a man and James is a woman.</p></td></tr></tbody></table>

### <a id="id-1.21.3.145"></a><a id="GIhA"></a>selma'o GIhA ( [Section 14.3](../section-six-types))

Specifies a logical connective (e.g. “and”, “or”, “if”) between two bridi-tails: a bridi-tail is a selbri with any associated following sumti, but not including any preceding sumti.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>le</td><td>zarci</td><td>gi'e</td><td>nelci</td><td>la&nbsp;.djan.</td></tr><tr class="gloss"><td>I</td><td>go-to</td><td>the</td><td>market</td><td>and</td><td>like</td><td>John.</td></tr></tbody></table>

### <a id="id-1.21.3.148"></a><a id="GOI"></a>selma'o GOI ( [Section 8.3](../section-relative-phrases))

Specifies the beginning of a relative phrase, which associates a subordinate sumti (following) to another sumti (preceding). Terminated by [GEhU](../chapter-catalogue#GEhU) See [NOI](../chapter-catalogue#NOI).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la&nbsp;.djan.</td><td>goi</td><td>ko'a</td><td>cu</td><td>blanu</td></tr><tr class="gloss"><td>John</td><td>(referred&nbsp;to&nbsp;as</td><td>it-1)</td><td>&nbsp;</td><td>is-blue.</td></tr></tbody></table>

### <a id="id-1.21.3.151"></a><a id="GOhA"></a>selma'o GOhA ( [Section 7.6](../section-ri-gohi-series))

A general selma'o for all cmavo which can take the place of brivla. There are several groups of these.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">A: mi klama le zarci</p></td></tr><tr class="para"><td colspan="12321"><p class="jbophrase">B: mi go'i</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">A: I'm going to the market.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">B: Me, too.</p></td></tr></tbody></table>

### <a id="id-1.21.3.155"></a><a id="GUhA"></a>selma'o GUhA ( [Section 14.3](../section-six-types))

Indicates the beginning of two logically connected tanru units. Takes the place of [GA](../chapter-catalogue#GA) when forming logically-connected tanru. See [GI](../chapter-catalogue#GI).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la&nbsp;.alis.</td><td>gu'e</td><td>ricfu</td><td>gi</td><td>blanu</td></tr><tr class="gloss"><td>Alice</td><td>is&nbsp;both</td><td>rich</td><td>and</td><td>blue.</td></tr></tbody></table>

### <a id="id-1.21.3.158"></a><a id="I"></a>selma'o I ( [Section 19.2](../section-i))

Separates two sentences from each other.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>le</td><td>zarci</td><td>.i</td><td>mi</td><td>klama</td><td>le</td><td>zdani</td></tr><tr class="gloss"><td>I</td><td>go-to</td><td>the</td><td>market</td><td>.</td><td>I</td><td>go-to</td><td>the</td><td>house.</td></tr></tbody></table>

### <a id="id-1.21.3.161"></a><a id="JA"></a>selma'o JA ( [Section 14.3](../section-six-types))

Specifies a logical connection (e.g. “and”, “or”, “if”) between two tanru units, mathematical operands, tenses, or abstractions.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ti</td><td>blanu</td><td>je</td><td>zdani</td></tr><tr class="gloss"><td>This</td><td>is-blue</td><td>and</td><td>a-house.</td></tr></tbody></table>

### <a id="id-1.21.3.164"></a><a id="JAI"></a>selma'o JAI ( [Section 9.12](../section-modal-jai))

When followed by a tense or modal, creates a conversion operator attachable to a selbri which exchanges the modal place with the x1 place of the selbri. When alone, is a conversion operator exchanging the x1 place of the selbri (which should be an abstract sumti) with one of the places of the abstracted-over bridi.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>jai&nbsp;gau</td><td>galfi</td><td>le</td><td>bitmu</td><td>se&nbsp;skari</td></tr><tr class="gloss"><td>I</td><td>am-the-actor-in</td><td>modifying</td><td>the</td><td>wall</td><td>color.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I act so as to modify the wall color.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">I change the color of the wall.</p></td></tr></tbody></table>

### <a id="id-1.21.3.168"></a><a id="JOI"></a>selma'o JOI ( [Section 14.14](../section-non-logical-connectives))

Specifies a non-logical connection (e.g. together-with-as-mass, -set, or -sequence) between two sumti, tanru units, or various other things. When immediately followed by [GI](../chapter-catalogue#GI) , provides forethought non-logical connection analogous to [GA](../chapter-catalogue#GA).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la&nbsp;.djan.</td><td>joi</td><td>la&nbsp;.alis.</td><td>cu</td><td>bevri</td><td>le</td><td>pipno</td></tr><tr class="gloss"><td>John</td><td>massed-with</td><td>Alice</td><td>&nbsp;</td><td>carry</td><td>the</td><td>piano.</td></tr></tbody></table>

### <a id="id-1.21.3.171"></a><a id="JOhI"></a>selma'o JOhI ( [Section 18.15](../section-vectors-matrices))

Indicates that the following mathematical operands (a list terminated by [TEhU](../chapter-catalogue#TEhU)) form a mathematical vector (one-dimensional array).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>jo'i</td><td>paboi</td><td>reboi</td><td>te'u</td><td>su'i</td><td>jo'i</td><td>ciboi</td><td>voboi</td><td>du</td></tr><tr class="gloss"><td>The-number</td><td>array(</td><td>one,</td><td>two</td><td>)</td><td>plus</td><td>array(</td><td>three,</td><td>four)</td><td>equals</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>jo'i</td><td>voboi</td><td>xaboi</td></tr><tr class="gloss"><td>the-number</td><td>array(</td><td>four,</td><td>six).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"></p><div class="informalequation"><span class="mathphrase">(1,2) + (3,4) = (4,6)</span></div><p class="natlang"></p></td></tr></tbody></table>

### <a id="id-1.21.3.176"></a><a id="KE"></a>selma'o KE ( [Section 5.5](../section-ke-grouping))

Groups everything between itself and a following [KEhE](../chapter-catalogue#KEhE) for purposes of logical connection, tanru construction, or other purposes. [KE](../chapter-catalogue#KE) and [KEhE](../chapter-catalogue#KEhE) are not used for mathematical (see [VEI](../chapter-catalogue#VEI) and [VEhO](../chapter-catalogue#VEhO)) or discursive (see [TO](../chapter-catalogue#TO) and [TOI](../chapter-catalogue#TOI)) purposes.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>ke</td><td>melbi</td><td>cmalu</td><td>ke'e</td><td>nixli</td><td>ckule</td></tr><tr class="gloss"><td>That</td><td>is-a-(</td><td>pretty</td><td>little</td><td>)</td><td>girl</td><td>school.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That is a school for girls who are pretty in their littleness.</p></td></tr></tbody></table>

### <a id="id-1.21.3.180"></a><a id="KEI"></a>selma'o KEI ( [Section 11.1](../chapter-abstractions#section-syntax))

Elidable terminator for [NU](../chapter-catalogue#NU). Marks the end of an abstraction bridi.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la&nbsp;.djan.</td><td>cu</td><td>nu</td><td>sonci</td><td>kei</td><td></td><td>djica</td></tr><tr class="gloss"><td>John</td><td>&nbsp;</td><td>is-an-(event-of</td><td>being-a-soldier</td><td>)</td><td>type-of</td><td>desirer.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John wants to be a soldier.</p></td></tr></tbody></table>

### <a id="id-1.21.3.184"></a><a id="KEhE"></a>selma'o KEhE ( [Section 5.5](../section-ke-grouping))

Elidable terminator for [KE](../chapter-catalogue#KE). Marks the end of a grouping.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>ke</td><td>melbi</td><td>cmalu</td><td>ke'e</td><td>nixli</td><td>ckule</td></tr><tr class="gloss"><td>That</td><td>is-a-(</td><td>pretty</td><td>little</td><td>)</td><td>girl</td><td>school.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That is a school for girls who are pretty in their littleness.</p></td></tr></tbody></table>

### <a id="id-1.21.3.188"></a><a id="KI"></a>selma'o KI ( [Section 10.13](../section-sticky-tenses))

When preceded by a tense or modal, makes it “sticky”, so that it applies to all further bridi until reset by another appearance of [KI](../chapter-catalogue#KI). When alone, eliminates all sticky tenses.

### <a id="id-1.21.3.190"></a><a id="KOhA"></a>selma'o KOhA ( [Section 7.1](../chapter-anaphoric-cmavo#section-anaphoric-cmavo-introduction))

A general selma'o which contains all cmavo which can substitute for sumti. These cmavo are divided into several groups.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>blanu</td><td>zdani</td><td>goi</td><td>ko'a</td><td>cu</td><td>barda</td></tr><tr class="gloss"><td>The</td><td>blue</td><td>house</td><td>(referred&nbsp;to&nbsp;as</td><td>it-1)</td><td>&nbsp;</td><td>is-big.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>ko'a</td><td>na</td><td>cmamau</td><td>ti</td></tr><tr class="gloss"><td>&nbsp;</td><td>It-1</td><td>is-not</td><td>smaller-than</td><td>this-thing.</td></tr></tbody></table>

### <a id="id-1.21.3.194"></a><a id="KU"></a>selma'o KU ( [Section 6.2](../section-basic-descriptors) , [Section 10.1](../chapter-tenses#section-tenses-introduction))

Elidable terminator for [LE](../chapter-catalogue#LE) and some uses of [LA](../chapter-catalogue#LA). Indicates the end of a description sumti. Also used after a tense or modal to indicate that no sumti follows, and in the compound [NA](../chapter-catalogue#NA) + [KU](../chapter-catalogue#KU) to indicate natural language-style negation.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>prenu</td><td>ku</td><td></td><td>le</td><td>zdani</td><td>ku</td><td>klama</td></tr><tr class="gloss"><td>The</td><td>person</td><td>,</td><td>to</td><td>the</td><td>house</td><td>,</td><td>goes.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The person goes to the house.</p></td></tr></tbody></table>

### <a id="id-1.21.3.198"></a><a id="KUhE"></a>selma'o KUhE ( [Section 18.6](../section-forethought))

Elidable terminator for [PEhO](../chapter-catalogue#PEhO) : indicates the end of a forethought mathematical expression (one in which the operator precedes the operands).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>pe'o</td><td>su'i</td><td>reboi</td><td>reboi</td><td>re[boi]</td><td>ku'e</td></tr><tr class="gloss"><td>The-number</td><td>[forethought]</td><td>the-sum-of</td><td>two</td><td>two</td><td>two</td><td>[end]</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>du</td><td>li</td><td>xa</td></tr><tr class="gloss"><td>equals</td><td>the-number</td><td>six.</td></tr></tbody></table>

### <a id="id-1.21.3.202"></a><a id="KUhO"></a>selma'o KUhO ( [Section 8.1](../chapter-relative-clauses#section-poi))

Elidable terminator for [NOI](../chapter-catalogue#NOI). Indicates the end of a relative clause.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>zdani</td><td>poi</td><td>blanu</td><td>ku'o</td><td>barda</td></tr><tr class="gloss"><td>The</td><td>house</td><td>that(</td><td>is-blue</td><td>)</td><td>is-big.</td></tr></tbody></table>

### <a id="id-1.21.3.205"></a><a id="LA"></a>selma'o LA ( [Section 6.2](../section-basic-descriptors))

Descriptors which change name words (or selbri) into sumti which identify people or things by name. Similar to [LE](../chapter-catalogue#LE). May be terminated with [KU](../chapter-catalogue#KU) if followed by a description selbri.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la&nbsp;.kikeros.</td><td>du</td><td>la&nbsp;.tulis.</td></tr><tr class="gloss"><td>Cicero</td><td>is</td><td>Tully.</td></tr></tbody></table>

### <a id="id-1.21.3.208"></a><a id="LAU"></a>selma'o LAU ( [Section 17.14](../section-lerfu-cmavo-summary))

Combines with the following alphabetic letter to represent a single marker: change from lower to upper case, change of font, punctuation, etc.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>tau</td><td>sy</td><td>.ibu</td></tr><tr class="gloss"><td>[single-shift]</td><td>“s”</td><td>“i”</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Si (chemical symbol for silicon)</p></td></tr></tbody></table>

### <a id="id-1.21.3.212"></a><a id="LAhE"></a>selma'o LAhE ( [Section 6.10](../section-sumti-qualifiers))

Qualifiers which, when prefixed to a sumti, change it into another sumti with related meaning. Qualifiers can also consist of a cmavo from selma'o [NAhE](../chapter-catalogue#NAhE) plus [BO](../chapter-catalogue#BO). Terminated by [LUhU](../chapter-catalogue#LUhU).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>la'e</td><td>zoi</td><td>.kuot.</td><td>A&nbsp;Tale&nbsp;of&nbsp;Two&nbsp;Cities</td><td>.kuot</td></tr><tr class="gloss"><td>I</td><td>see</td><td>that-represented-by</td><td>the-text</td><td>“</td><td>A&nbsp;Tale&nbsp;of&nbsp;Two&nbsp;Cities</td><td>”.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I see the book “A Tale of Two Cities”.</p></td></tr></tbody></table>

### <a id="id-1.21.3.216"></a><a id="LE"></a>selma'o LE ( [Section 6.2](../section-basic-descriptors))

Descriptors which make selbri into sumti which describe or specify things that fit into the x1 place of the selbri. Terminated by [KU](../chapter-catalogue#KU). See [LA](../chapter-catalogue#LA).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>gerku</td><td>cu</td><td>klama</td><td>le</td><td>zdani</td></tr><tr class="gloss"><td>The</td><td>dog</td><td>&nbsp;</td><td>goes-to</td><td>the</td><td>house.</td></tr></tbody></table>

### <a id="id-1.21.3.219"></a><a id="LEhU"></a>selma'o LEhU ( [Section 19.9](../section-quotations))

Indicates the end of a quotation begun with [LOhU](../chapter-catalogue#LOhU). Not an elidable terminator.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo'u</td><td>mi&nbsp;du&nbsp;do&nbsp;du&nbsp;mi</td><td>le'u</td><td>cu</td><td>na</td><td>lojbo</td><td>drani</td></tr><tr class="gloss"><td>[quote]</td><td>mi&nbsp;du&nbsp;do&nbsp;du&nbsp;mi</td><td>[unquote]</td><td>&nbsp;</td><td>is-not</td><td>Lojbanically</td><td>correct.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">“mi du do du mi” is not correct Lojban.</p></td></tr></tbody></table>

### <a id="id-1.21.3.223"></a><a id="LI"></a>selma'o LI ( [Section 18.5](../section-simple-infix))

Descriptors which change numbers or other mathematical expressions into sumti which specify numbers or numerical expressions. Terminated by [LOhO](../chapter-catalogue#LOhO).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>re</td><td>vu'u</td><td>re</td><td>na</td><td>du</td><td>li</td><td>vo</td><td>su'i</td><td>vo</td></tr><tr class="gloss"><td>The-number</td><td>2</td><td>minus</td><td>2</td><td>not</td><td>equals</td><td>the-number</td><td>4</td><td>plus</td><td>4.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"></p><div class="informalequation"><span class="mathphrase">2 - 2 ≠ 4 + 4</span></div><p class="natlang"></p></td></tr></tbody></table>

### <a id="id-1.21.3.227"></a><a id="LIhU"></a>selma'o LIhU ( [Section 19.9](../section-quotations))

Elidable terminator for [LU](../chapter-catalogue#LU). Indicates the end of a text quotation.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cusku</td><td>lu</td><td>mi</td><td>klama</td><td>le</td><td>zarci</td><td>li'u</td></tr><tr class="gloss"><td>I</td><td>express</td><td>[quote]</td><td>I</td><td>go-to</td><td>the</td><td>market</td><td>[end-quote].</td></tr></tbody></table>

### <a id="id-1.21.3.230"></a><a id="LOhO"></a>selma'o LOhO ( [Section 18.17](../section-connectives-within-mekso))

Elidable terminator for [LI](../chapter-catalogue#LI). Indicates the end of a mathematical expression used in a [LI](../chapter-catalogue#LI) description.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>vo</td><td>lo'o</td><td>li</td><td>ci</td><td>lo'o</td><td>cu</td><td>zmadu</td></tr><tr class="gloss"><td>The-number</td><td>4</td><td>[end-number],</td><td>the-number</td><td>3</td><td>[end-number],</td><td>&nbsp;</td><td>is-greater.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">4 &gt; 3</p></td></tr></tbody></table>

### <a id="id-1.21.3.234"></a><a id="LOhU"></a>selma'o LOhU ( [Section 19.9](../section-quotations))

Indicates the beginning of a quotation (a sumti) which is grammatical as long as the quoted material consists of Lojban words, whether they form a text or not. Terminated by [LEhU](../chapter-catalogue#LEhU).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>cusku</td><td>lo'u</td><td>mi&nbsp;du&nbsp;do&nbsp;du&nbsp;ko'a</td><td>le'u</td></tr><tr class="gloss"><td>You</td><td>express</td><td>[quote]</td><td>mi&nbsp;du&nbsp;do&nbsp;du&nbsp;ko'a</td><td>[end-quote].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">You said, “mi du do du ko'a”.</p></td></tr></tbody></table>

### <a id="id-1.21.3.238"></a><a id="LU"></a>selma'o LU ( [Section 19.9](../section-quotations))

Indicates the beginning of a quotation (a sumti) which is grammatical only if the quoted material also forms a grammatical Lojban text. Terminated by [LIhU](../chapter-catalogue#LIhU).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cusku</td><td>lu</td><td>mi</td><td>klama</td><td>le</td><td>zarci</td><td>li'u</td></tr><tr class="gloss"><td>I</td><td>express</td><td>[quote]</td><td>I</td><td>go-to</td><td>the</td><td>market</td><td>[end-quote].</td></tr></tbody></table>

### <a id="id-1.21.3.241"></a><a id="LUhU"></a>selma'o LUhU ( [Section 6.10](../section-sumti-qualifiers))

Elidable terminator for [LAhE](../chapter-catalogue#LAhE) and [NAhE](../chapter-catalogue#NAhE) + [BO](../chapter-catalogue#BO). Indicates the end of a qualified sumti.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>la'e</td><td>lu</td><td>barda</td><td>gerku</td><td>li'u</td><td>lu'u</td></tr><tr class="gloss"><td>I</td><td>see</td><td>the-referent-of</td><td>[quote]</td><td>big</td><td>dog</td><td>[end-quote]</td><td>[end-ref]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I saw “Big Dog” [not the words, but a book or movie].</p></td></tr></tbody></table>

### <a id="id-1.21.3.245"></a><a id="MAI"></a>selma'o MAI ( [Section 18.19](../section-other-mekso-uses) , [Section 19.1](../chapter-structure#section-structure-introduction))

When suffixed to a number or string of letter words, produces a free modifier which serves as an index number within a text.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>pamai</td><td>mi</td><td>pu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>1-thly,</td><td>I</td><td>[past]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">First, I went to the market.</p></td></tr></tbody></table>

### <a id="id-1.21.3.249"></a><a id="MAhO"></a>selma'o MAhO ( [Section 18.6](../section-forethought))

Produces a mathematical operator from a letter or other operand. Terminated by [TEhU](../chapter-catalogue#TEhU). See [VUhU](../chapter-catalogue#VUhU).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ma'o</td><td>fy.</td><td>boi</td><td>xy.</td></tr><tr class="gloss"><td>[operator]</td><td>f</td><td>&nbsp;</td><td>x</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"><span class="emphasis"><em>f(x)</em></span></p></td></tr></tbody></table>

### <a id="id-1.21.3.253"></a><a id="ME"></a>selma'o ME ( [Section 5.10](../section-me-selbri) , [Section 18.1](../chapter-mekso#section-mekso-introduction))

Produces a tanru unit from a sumti, which is applicable to the things referenced by the sumti. Terminated by [MEhU](../chapter-catalogue#MEhU).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>me&nbsp;la&nbsp;.ford.</td><td>karce</td></tr><tr class="gloss"><td>That</td><td>is-a-Ford-type</td><td>car</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That's a Ford car.</p></td></tr></tbody></table>

### <a id="id-1.21.3.257"></a><a id="MEhU"></a>selma'o MEhU ( [Section 5.11](../section-place-conversion))

The elidable terminator for [ME](../chapter-catalogue#ME). Indicates the end of a sumti converted to a tanru unit.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">ta me mi me'u zdani</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That's a me type of house.</p></td></tr></tbody></table>

### <a id="id-1.21.3.261"></a><a id="MOI"></a>selma'o MOI ( [Section 5.11](../section-place-conversion) , [Section 18.18](../section-lojban-within-mekso))

Suffixes added to numbers or other quantifiers to make various numerically-based selbri.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la&nbsp;.djan.</td><td>joi</td><td>la&nbsp;.frank.</td><td>cu</td><td>bruna</td><td></td><td>remei</td></tr><tr class="gloss"><td>John</td><td>in-a-mass-with</td><td>Frank</td><td>&nbsp;</td><td>are-a-brother</td><td>type-of</td><td>twosome.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John and Frank are two brothers.</p></td></tr></tbody></table>

### <a id="id-1.21.3.265"></a><a id="MOhE"></a>selma'o MOhE ( [Section 18.18](../section-lojban-within-mekso))

Produces a mathematical operand from a sumti; used to make dimensioned units. Terminated by [TEhU](../chapter-catalogue#TEhU).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>mo'e</td><td>re</td><td>ratcu</td><td>su'i</td><td>mo'e</td><td>re</td><td>ractu</td></tr><tr class="gloss"><td>The-number</td><td>[operand]</td><td>two</td><td>rats</td><td>plus</td><td>[operand]</td><td>two</td><td>rabbits</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>cu</td><td>du</td><td>li</td><td>mo'e</td><td>vo</td><td>danlu</td></tr><tr class="gloss"><td>&nbsp;</td><td>equals</td><td>the-number</td><td>[operand]</td><td>four</td><td>animals.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">2 rats + 2 rabbits = 4 animals.</p></td></tr></tbody></table>

### <a id="id-1.21.3.270"></a><a id="MOhI"></a>selma'o MOhI ( [Section 10.8](../section-movement))

A tense flag indicating movement in space, in a direction specified by a following [FAhA](../chapter-catalogue#FAhA) cmavo.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>verba</td><td>mo'i</td><td>ri'u</td><td>cadzu</td><td>le</td><td>bisli</td></tr><tr class="gloss"><td>The</td><td>child</td><td>[movement]</td><td>[right]</td><td>walks-on</td><td>the</td><td>ice.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The child walks toward my right on the ice.</p></td></tr></tbody></table>

### <a id="id-1.21.3.274"></a><a id="NA"></a>selma'o NA ( [Section 14.3](../section-six-types) , [Section 15.7](../section-other-negation))

Contradictory negators, asserting that a whole bridi is false (or true).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">mi na klama le zarci</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">It is not true that I go to the market.</p></td></tr></tbody></table>

Also used to construct logical connective compound cmavo.

### <a id="id-1.21.3.279"></a><a id="NAI"></a>selma'o NAI ( [Section 14.3](../section-six-types) , [Section 15.7](../section-other-negation))

Negates the previous word, but can only be used with certain selma'o as specified by the grammar.

### <a id="id-1.21.3.281"></a><a id="NAhE"></a>selma'o NAhE ( [Section 15.4](../section-nahe))

Scalar negators, modifying a selbri or a sumti to a value other than the one stated, the opposite of the one stated, etc. Also used with following [BO](../chapter-catalogue#BO) to construct a sumti qualifier; see [LAhE](../chapter-catalogue#LAhE).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>na'e</td><td>blanu</td><td>zdani</td></tr><tr class="gloss"><td>That</td><td>is-a-non-</td><td>blue</td><td>house.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That is a house which is other than blue.</p></td></tr></tbody></table>

### <a id="id-1.21.3.285"></a><a id="NAhU"></a>selma'o NAhU ( [Section 18.18](../section-lojban-within-mekso))

Creates a mathematical operator from a selbri. Terminated by [TEhU](../chapter-catalogue#TEhU). See [VUhU](../chapter-catalogue#VUhU).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>na'u</td><td>tanjo</td><td>te'u</td></tr><tr class="gloss"><td>The-number</td><td>the-operator(</td><td>tangent</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>vei</td><td>pai</td><td>fe'i</td><td>re</td><td>[ve'o]</td><td>du</td><td>li</td><td>ci'i</td></tr><tr class="gloss"><td>(</td><td>π</td><td>/</td><td>2</td><td>)</td><td>=</td><td>the-number</td><td>infinity.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">tan(π/2) = ∞</p></td></tr></tbody></table>

### <a id="id-1.21.3.290"></a><a id="NIhE"></a>selma'o NIhE ( [Section 18.18](../section-lojban-within-mekso))

Creates a mathematical operand from a selbri, usually a “ _<a id="id-1.21.3.291.1.1" class="indexterm"></a>[_ni_](../go01#valsi-ni)_ ” abstraction. Terminated by [TEhU](../chapter-catalogue#TEhU).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ni'e</td><td>ni</td><td>clani</td><td>[te'u]</td><td>pi'i</td></tr><tr class="gloss"><td>The-number</td><td>&nbsp;</td><td>quantity-of</td><td>length</td><td>&nbsp;</td><td>times</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ni'e</td><td>ni</td><td>ganra</td><td>[te'u]</td><td>pi'i</td></tr><tr class="gloss"><td>&nbsp;</td><td>quantity-of</td><td>width</td><td>&nbsp;</td><td>times</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ni'e</td><td>ni</td><td>condi</td><td>te'u</td><td>du</td><td>li</td><td>ni'e</td><td>ni</td><td>canlu</td></tr><tr class="gloss"><td>&nbsp;</td><td>quantity-of</td><td>depth</td><td>&nbsp;</td><td>equals</td><td>the-number</td><td>&nbsp;</td><td>quantity-of</td><td>volume.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Length × Width × Depth = Volume</p></td></tr></tbody></table>

### <a id="id-1.21.3.296"></a><a id="NIhO"></a>selma'o NIhO ( [Section 19.3](../section-niho))

Marks the beginning of a new paragraph, and indicates whether it contains old or new subject matter.

### <a id="id-1.21.3.298"></a><a id="NOI"></a>selma'o NOI ( [Section 8.1](../chapter-relative-clauses#section-poi))

Introduces relative clauses. The following bridi modifies the preceding sumti. Terminated by [KUhO](../chapter-catalogue#KUhO). See [GOI](../chapter-catalogue#GOI).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>zdani</td><td>poi</td><td>blanu</td><td>cu</td><td>cmalu</td></tr><tr class="gloss"><td>The</td><td>house</td><td>which</td><td>is-blue</td><td>&nbsp;</td><td>is-small.</td></tr></tbody></table>

### <a id="id-1.21.3.301"></a><a id="NU"></a>selma'o NU ( [Section 11.1](../chapter-abstractions#section-syntax))

Abstractors which, when prefixed to a bridi, create abstraction selbri. Terminated by [KEI](../chapter-catalogue#KEI).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la&nbsp;.djan.</td><td>cu</td><td>djica</td><td>le</td><td>nu</td><td>sonci</td><td>[kei]</td></tr><tr class="gloss"><td>John</td><td>&nbsp;</td><td>desires</td><td>the</td><td>event-of</td><td>being-a-soldier.</td></tr></tbody></table>

### <a id="id-1.21.3.304"></a><a id="NUhA"></a>selma'o NUhA ( [Section 18.19](../section-other-mekso-uses))

Creates a selbri from a mathematical operator. See [VUhU](../chapter-catalogue#VUhU).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ni'umu</td><td>cu</td><td>nu'a&nbsp;va'a</td><td>li</td><td>ma'umu</td></tr><tr class="gloss"><td>The-number</td><td>-5</td><td>&nbsp;</td><td>is-the-negation-of</td><td>the-number</td><td>+5</td></tr></tbody></table>

### <a id="id-1.21.3.307"></a><a id="NUhI"></a>selma'o NUhI ( [Section 14.11](../section-termsets) , [Section 16.7](../section-quantifier-grouping))

Marks the beginning of a termset, which is used to make simultaneous claims involving two or more different places of a selbri. Terminated by [NUhU](../chapter-catalogue#NUhU).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>nu'i</td><td>ge</td><td></td><td>le</td><td>zarci</td><td>&nbsp;</td><td>le</td><td>briju</td></tr><tr class="gloss"><td>I</td><td>go</td><td>[start]</td><td>both</td><td>to</td><td>the</td><td>market</td><td>from</td><td>the</td><td>office</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>nu'u</td><td>gi</td><td></td><td>le</td><td>zdani</td><td>&nbsp;</td><td>le</td><td>ckule</td><td>[nu'u]</td></tr><tr class="gloss"><td>[joint]</td><td>and</td><td>to</td><td>the</td><td>house</td><td>from</td><td>the</td><td>school.</td></tr></tbody></table>

### <a id="id-1.21.3.311"></a><a id="NUhU"></a>selma'o NUhU ( [Section 14.11](../section-termsets))

Elidable terminator for [NUhI](../chapter-catalogue#NUhI). Marks the end of a termset.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>nu'i</td><td>ge</td><td></td><td>le</td><td>zarci</td><td>&nbsp;</td><td>le</td><td>briju</td></tr><tr class="gloss"><td>I</td><td>go</td><td>[start]</td><td>both</td><td>to</td><td>the</td><td>market</td><td>from</td><td>the</td><td>office</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>nu'u</td><td>gi</td><td></td><td>le</td><td>zdani</td><td>&nbsp;</td><td>le</td><td>ckule</td><td>[nu'u]</td></tr><tr class="gloss"><td>[joint]</td><td>and</td><td>to</td><td>the</td><td>house</td><td>from</td><td>the</td><td>school.</td></tr></tbody></table>

### <a id="id-1.21.3.315"></a><a id="PA"></a>selma'o PA ( [Section 18.2](../section-mekso-numbers))

Digits and related quantifiers (some, all, many, etc.). Terminated by [BOI](../chapter-catalogue#BOI).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>speni</td><td>re</td><td>ninmu</td></tr><tr class="gloss"><td>I</td><td>am-married-to</td><td>two</td><td>women.</td></tr></tbody></table>

### <a id="id-1.21.3.318"></a><a id="PEhE"></a>selma'o PEhE ( [Section 14.11](../section-termsets))

Precedes a logical or non-logical connective that joins two termsets. Termsets (see [CEhE](../chapter-catalogue#CEhE)) are used to associate several terms for logical connectives, for equal quantifier scope, or for special constructs in tenses.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ce'e</td><td>do</td><td>pe'e</td><td>je</td><td>la&nbsp;.djan.</td><td>ce'e</td><td>la&nbsp;.djeimyz.</td><td>cu</td><td>pendo</td></tr><tr class="gloss"><td>I</td><td>[,]</td><td>you</td><td>[joint]</td><td>and</td><td>John</td><td>[,]</td><td>James</td><td>&nbsp;</td><td>are-friends-of.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am a friend of you, and John is a friend of James.</p></td></tr></tbody></table>

### <a id="id-1.21.3.322"></a><a id="PEhO"></a>selma'o PEhO ( [Section 18.6](../section-forethought))

An optional signal of forethought mathematical operators, which precede their operands. Terminated by [KUhE](../chapter-catalogue#KUhE).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>vo</td><td>du</td><td>li</td><td>pe'o</td><td>su'i</td><td>reboi</td><td>re</td></tr><tr class="gloss"><td>The-number</td><td>four</td><td>equals</td><td>the-number</td><td>[forethought]</td><td>sum-of</td><td>two</td><td>two.</td></tr></tbody></table>

### <a id="id-1.21.3.325"></a><a id="PU"></a>selma'o PU ( [Section 10.4](../section-temporal-tenses))

Specifies simple time directions (future, past, or neither).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I went to the market.</p></td></tr></tbody></table>

### <a id="id-1.21.3.329"></a><a id="RAhO"></a>selma'o RAhO ( [Section 7.6](../section-ri-gohi-series))

The pro-bridi update flag: changes the meaning of sumti implicitly attached to a pro-bridi (see [GOhA](../chapter-catalogue#GOhA)) to fit the current context rather than the original context.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="para"><td colspan="12321"><p class="jbophrase">A: mi ba lumci le mi karce</p></td></tr><tr class="para"><td colspan="12321"><p class="jbophrase">B: mi go'i</p></td></tr><tr class="para"><td colspan="12321"><p class="jbophrase">A: mi ba lumci le mi karce</p></td></tr><tr class="para"><td colspan="12321"><p class="jbophrase">B: mi go'i ra'o</p></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">A: I [future] wash my car.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">B: I do-the-same-thing (i.e. wash A's car).</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">A: I [future] wash my car.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">B: I do-the-corresponding-thing (i.e. wash B's car).</p></td></tr></tbody></table>

### <a id="id-1.21.3.333"></a><a id="ROI"></a>selma'o ROI ( [Section 10.9](../section-interval-properties))

When suffixed to a number, makes an extensional tense (e.g. once, twice, many times).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>reroi</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>twice</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

### <a id="id-1.21.3.336"></a><a id="SA"></a>selma'o SA ( [Section 19.13](../section-erasure))

Erases the previous phrase or sentence.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>sa</td><td>do</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>go,</td><td>er,</td><td>you</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

### <a id="id-1.21.3.339"></a><a id="SE"></a>selma'o SE ( [Section 5.11](../section-place-conversion) , [Section 9.4](../section-SE))

Converts a selbri, rearranging the order of places by exchanging the x1 place with a specified numbered place.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>zarci</td><td>cu</td><td>se&nbsp;klama</td><td>mi</td></tr><tr class="gloss"><td>The</td><td>market</td><td>&nbsp;</td><td>is-gone-to-by</td><td>me.</td></tr></tbody></table>

Also used in constructing connective and modal compound cmavo.

### <a id="id-1.21.3.343"></a><a id="SEI"></a>selma'o SEI ( [Section 19.12](../section-parentheses))

Marks the beginning of metalinguistic insertions which comment on the main bridi. Terminated by [SEhU](../chapter-catalogue#SEhU).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la&nbsp;.frank.</td><td>prami</td><td>sei</td><td></td><td>gleki</td><td>[se'u]</td><td>la&nbsp;.djein.</td></tr><tr class="gloss"><td>Frank</td><td>loves</td><td>(</td><td>[he]</td><td>is-happy</td><td>)</td><td>Jane.</td></tr></tbody></table>

### <a id="id-1.21.3.346"></a><a id="SEhU"></a>selma'o SEhU ( [Section 19.12](../section-parentheses))

Elidable terminator for [SEI](../chapter-catalogue#SEI) and [SOI](../chapter-catalogue#SOI). Ends metalinguistic insertions.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la&nbsp;.frank.</td><td>prami</td><td>sei</td><td></td><td>gleki</td><td>se'u</td><td>la&nbsp;.djein.</td></tr><tr class="gloss"><td>Frank</td><td>loves</td><td>(</td><td>[he]</td><td>is-happy</td><td>)</td><td>Jane.</td></tr></tbody></table>

### <a id="id-1.21.3.349"></a><a id="SI"></a>selma'o SI ( [Section 19.13](../section-erasure))

Erases the previous single word.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>si</td><td>do</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I,</td><td>er,</td><td>you</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

### <a id="id-1.21.3.352"></a><a id="SOI"></a>selma'o SOI ( [Section 7.8](../section-voha-series))

Marks reciprocity between two sumti (like “vice versa” in English).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>prami</td><td>do</td><td>soi</td><td>mi</td></tr><tr class="gloss"><td>I</td><td>love</td><td>you</td><td>[reciprocally]</td><td>me.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I love you and vice versa.</p></td></tr></tbody></table>

### <a id="id-1.21.3.356"></a><a id="SU"></a>selma'o SU ( [Section 19.13](../section-erasure))

Closes and erases the entire previous discourse.

### <a id="id-1.21.3.358"></a><a id="TAhE"></a>selma'o TAhE ( [Section 10.9](../section-interval-properties))

A tense modifier specifying frequencies within an interval of time or space (regularly, habitually, etc.).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>verba</td><td>ta'e</td><td>klama</td><td>le</td><td>ckule</td></tr><tr class="gloss"><td>The</td><td>child</td><td>habitually</td><td>goes-to</td><td>the</td><td>school.</td></tr></tbody></table>

### <a id="id-1.21.3.361"></a><a id="TEI"></a>selma'o TEI ( [Section 17.6](../section-accents))

Signals the beginning of a compound letter word, which acts grammatically like a single letter. Compound letter words end with the non-elidable selma'o [FOI](../chapter-catalogue#FOI).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>tei</td><td>.ebu</td><td>.akut.&nbsp;bu</td><td>foi</td></tr><tr class="gloss"><td>(</td><td>“e”</td><td>“acute”</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the letter “e” with an acute accent</p></td></tr></tbody></table>

### <a id="id-1.21.3.365"></a><a id="TEhU"></a>selma'o TEhU ( [Section 18.15](../section-vectors-matrices))

Elidable terminator for [JOhI](../chapter-catalogue#JOhI) , [MAhO](../chapter-catalogue#MAhO) , [MOhE](../chapter-catalogue#MOhE) , [NAhU](../chapter-catalogue#NAhU) , or [NIhE](../chapter-catalogue#NIhE). Marks the end of a mathematical conversion construct.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>jo'i</td><td>paboi</td><td>reboi</td><td>te'u</td><td>su'i</td><td>jo'i</td><td>ciboi</td><td>voboi</td><td>du</td></tr><tr class="gloss"><td>The-number</td><td>array(</td><td>one,</td><td>two</td><td>)</td><td>plus</td><td>array(</td><td>three,</td><td>four)</td><td>equals</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>jo'i</td><td>voboi</td><td>xaboi</td></tr><tr class="gloss"><td>the-number</td><td>array(</td><td>four,</td><td>six).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"></p><div class="informalequation"><span class="mathphrase">(1,2) + (3,4) = (4,6)</span></div><p class="natlang"></p></td></tr></tbody></table>

### <a id="id-1.21.3.370"></a><a id="TO"></a>selma'o TO ( [Section 19.12](../section-parentheses))

Left discursive parenthesis: allows inserting a digression. Terminated by [TOI](../chapter-catalogue#TOI).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>doi</td><td>.lisas.</td><td>mi</td><td>djica</td><td>le</td><td>nu</td></tr><tr class="gloss"><td>O</td><td>Lisa,</td><td>I</td><td>desire</td><td>the</td><td>event-of</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>to</td><td>doi</td><td>.frank.</td><td>ko</td><td>sisti</td><td>toi</td><td>do</td><td>viska</td><td>le</td><td>mlatu</td></tr><tr class="gloss"><td>(</td><td>O</td><td>Frank,</td><td>[imperative]</td><td>stop!</td><td>)</td><td>you</td><td>see</td><td>the</td><td>cat.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Lisa, I want you to (Frank! Stop!) see the cat.</p></td></tr></tbody></table>

### <a id="id-1.21.3.375"></a><a id="TOI"></a>selma'o TOI ( [Section 19.12](../section-parentheses))

Elidable terminator for [TO](../chapter-catalogue#TO). The right discursive parenthesis.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>doi</td><td>.lisas.</td><td>mi</td><td>djica</td><td>le</td><td>nu</td></tr><tr class="gloss"><td>O</td><td>Lisa,</td><td>I</td><td>desire</td><td>the</td><td>event-of</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>to</td><td>doi</td><td>.frank.</td><td>ko</td><td>sisti</td><td>toi</td><td>do</td><td>viska</td><td>le</td><td>mlatu</td></tr><tr class="gloss"><td>(</td><td>O</td><td>Frank,</td><td>[imperative]</td><td>stop!</td><td>)</td><td>you</td><td>see</td><td>the</td><td>cat.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Lisa, I want you to (Frank! Stop!) see the cat.</p></td></tr></tbody></table>

### <a id="id-1.21.3.380"></a><a id="TUhE"></a>selma'o TUhE ( [Section 19.2](../section-i))

Groups multiple sentences or paragraphs into a logical unit. Terminated by [TUhU](../chapter-catalogue#TUhU).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>xagmau</td><td>zo'u</td><td>tu'e</td><td>ganai</td><td>cidja</td><td>gi</td><td>citno</td></tr><tr class="gloss"><td>Some</td><td>best</td><td>:</td><td>[start]</td><td>If</td><td>food,</td><td>then</td><td>new.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>ganai</td><td>vanju</td><td>gi</td><td>tolci'o</td><td>[tu'u]</td></tr><tr class="gloss"><td>&nbsp;</td><td>If</td><td>wine,</td><td>then</td><td>old.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">As for what is best: if food, then new [is best]; if wine, then old [is best].</p></td></tr></tbody></table>

### <a id="id-1.21.3.385"></a><a id="TUhU"></a>selma'o TUhU ( [Section 19.2](../section-i))

Elidable terminator for [TUhE](../chapter-catalogue#TUhE). Marks the end of a multiple sentence group.

### <a id="id-1.21.3.387"></a><a id="UI"></a>selma'o UI ( [Section 13.1](../chapter-attitudinals#section-attitudinals-introduction))

Particles which indicate the speaker's emotional state or source of knowledge, or the present stage of discourse.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ui</td><td>la&nbsp;.djan.</td><td>klama</td></tr><tr class="gloss"><td>[Happiness!]</td><td>John</td><td>is-coming.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Hurrah! John is coming!</p></td></tr></tbody></table>

### <a id="id-1.21.3.391"></a><a id="VA"></a>selma'o VA ( [Section 10.2](../section-spatial-tenses))

A tense indicating distance in space (near, far, or neither).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>va</td><td>batci</td><td>le</td><td>gerku</td></tr><tr class="gloss"><td>The</td><td>man</td><td>[medium-distance]</td><td>bites</td><td>the</td><td>dog.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Over there the man is biting the dog.</p></td></tr></tbody></table>

### <a id="id-1.21.3.395"></a><a id="VAU"></a>selma'o VAU ( [Section 14.9](../section-compound-bridi))

Elidable terminator for a simple bridi, or for each bridi-tail of a [GIhA](../chapter-catalogue#GIhA) logical connection.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>dunda</td><td>le</td><td>cukta</td><td>[vau]</td><td>gi'e</td></tr><tr class="gloss"><td>I</td><td>(give</td><td>the</td><td>book</td><td>)</td><td>and</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lebna</td><td>lo</td><td>jdini</td><td>vau</td><td></td><td>do</td><td>[vau]</td></tr><tr class="gloss"><td>(take</td><td>some</td><td>money</td><td>)</td><td>to/from</td><td>you.</td></tr></tbody></table>

### <a id="id-1.21.3.399"></a><a id="VEI"></a>selma'o VEI ( [Section 18.5](../section-simple-infix))

Left mathematical parenthesis: groups mathematical operations. Terminated by [VEhO](../chapter-catalogue#VEhO).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>vei</td><td>ny.</td><td>su'i</td><td>pa</td><td>ve'o</td></tr><tr class="gloss"><td>The-number</td><td>(</td><td>“n”</td><td>plus</td><td>one</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>pi'i</td><td>vei</td><td>ny.</td><td>su'i</td><td>pa</td><td>[ve'o]</td><td>du</td></tr><tr class="gloss"><td>times</td><td>(</td><td>“n”</td><td>plus</td><td>one</td><td>)</td><td>equals</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ny.</td><td>[bi'e]</td><td>te'a</td><td>re</td></tr><tr class="gloss"><td>the-number</td><td>n</td><td>[priority]</td><td>power</td><td>two</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>su'i</td><td>re</td><td>bi'e</td><td>pi'i</td><td>ny.</td><td>su'i</td><td>pa</td></tr><tr class="gloss"><td>plus</td><td>two</td><td>[priority]</td><td>times</td><td>“n”</td><td>plus</td><td>1.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"></p><div class="informalequation"><span class="mathphrase">(n + 1)(n + 1) = n <sup>2</sup> + 2n + 1</span></div><p class="natlang"></p></td></tr></tbody></table>

### <a id="id-1.21.3.406"></a><a id="VEhA"></a>selma'o VEhA ( [Section 10.5](../section-interval-sizes))

A tense indicating the size of an interval in space (long, medium, or short).

### <a id="id-1.21.3.408"></a><a id="VEhO"></a>selma'o VEhO ( [Section 19.5](../section-questions-and-answers))

Elidable terminator for [VEI](../chapter-catalogue#VEI) : right mathematical parenthesis.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>vei</td><td>ny.</td><td>su'i</td><td>pa</td><td>ve'o</td><td>pi'i</td></tr><tr class="gloss"><td>The-number</td><td>(</td><td>“n”</td><td>plus</td><td>one</td><td>)</td><td>times</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>vei</td><td>ny.</td><td>su'i</td><td>pa</td><td>[ve'o]</td><td>du</td></tr><tr class="gloss"><td>(</td><td>“n”</td><td>plus</td><td>one</td><td>)</td><td>equals</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ny.</td><td>[bi'e]</td><td>te'a</td><td>re</td><td>su'i</td></tr><tr class="gloss"><td>the-number</td><td>n</td><td>[priority]</td><td>power</td><td>two</td><td>plus</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>re</td><td>bi'e</td><td>pi'i</td><td>ny.</td><td>su'i</td><td>pa</td></tr><tr class="gloss"><td>two</td><td>[priority]</td><td>times</td><td>“n”</td><td>plus</td><td>1.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"></p><div class="informalequation"><span class="mathphrase">(n + 1)(n + 1) = n <sup>2</sup> + 2n + 1</span></div><p class="natlang"></p></td></tr></tbody></table>

### <a id="id-1.21.3.415"></a><a id="VIhA"></a>selma'o VIhA ( [Section 10.7](../section-dimensionality))

A tense indicating dimensionality in space (line, plane, volume, or space-time interval).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>verba</td><td>ve'a</td></tr><tr class="gloss"><td>The</td><td>child</td><td>[medium-space-interval]</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>vi'a</td><td>cadzu</td><td>le</td><td>bisli</td></tr><tr class="gloss"><td>[2-dimensional]</td><td>walks-on</td><td>the</td><td>ice.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">In a medium-sized area, the child walks on the ice.</p></td></tr></tbody></table>

### <a id="id-1.21.3.420"></a><a id="VUhO"></a>selma'o VUhO ( [Section 8.8](../section-vuho))

Attaches relative clauses or phrases to a whole (possibly connected) sumti, rather than simply to the leftmost portion of the sumti.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la&nbsp;.frank.</td><td>ce</td><td>la&nbsp;.djordj.</td><td>vu'o</td><td>noi</td><td>gidva</td><td>cu</td><td>zvati</td><td>le</td><td>kumfa</td></tr><tr class="gloss"><td>Frank</td><td>[in-set-with]</td><td>George</td><td>,</td><td>which</td><td>are-guides</td><td>,</td><td>are-in</td><td>the</td><td>room.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Frank and George, who are guides, are in the room.</p></td></tr></tbody></table>

### <a id="id-1.21.3.424"></a><a id="VUhU"></a>selma'o VUhU ( [Section 18.5](../section-simple-infix))

Mathematical operators (e.g. +, −). See [MAhO](../chapter-catalogue#MAhO).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>mu</td><td>vu'u</td><td>re</td><td>du</td><td>li</td><td>ci</td></tr><tr class="gloss"><td>The-number</td><td>5</td><td>minus</td><td>2</td><td>equals</td><td>the-number</td><td>3.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"></p><div class="informalequation"><span class="mathphrase">5 − 2 = 3</span></div><p class="natlang"></p></td></tr></tbody></table>

### <a id="id-1.21.3.428"></a><a id="XI"></a>selma'o XI ( [Section 18.13](../section-subscripts-math))

The subscript marker: the following number or lerfu string is a subscript for whatever precedes it.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>xy.</td><td>xi</td><td>re</td></tr><tr class="gloss"><td>x</td><td>sub</td><td>2</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang"></p><div class="informalequation"><span class="mathphrase">x <sub>2</sub></span></div><p class="natlang"></p></td></tr></tbody></table>

### <a id="id-1.21.3.432"></a><a id="Y"></a>selma'o Y ( [Section 19.14](../section-hesitation))

Hesitation noise: content-free, but holds the floor or continues the conversation. It is different from silence in that silence may be interpreted as having nothing more to say.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>doi</td><td>.y.</td><td>.y.</td><td>.djan</td></tr><tr class="gloss"><td>O,</td><td>uh,</td><td>uh,</td><td>John!</td></tr></tbody></table>

### <a id="id-1.21.3.435"></a><a id="ZAhO"></a>selma'o ZAhO ( [Section 10.10](../section-event-contours))

A tense modifier specifying the contour of an event (e.g. beginning, ending, continuing).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu'o</td><td>damba</td></tr><tr class="gloss"><td>I</td><td>[prospective]</td><td>fight.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I'm on the verge of fighting.</p></td></tr></tbody></table>

### <a id="id-1.21.3.439"></a><a id="ZEI"></a>selma'o ZEI ( [Section 4.6](../section-rafsi))

A morphological glue word, which joins the two words it stands between into the equivalent of a lujvo.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>xy.</td><td>zei</td><td>kantu</td><td>kacma</td></tr><tr class="gloss"><td>That</td><td>is-an-(X</td><td></td><td>ray)</td><td>camera.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That is an X-ray camera.</p></td></tr></tbody></table>

### <a id="id-1.21.3.443"></a><a id="ZEhA"></a>selma'o ZEhA ( [Section 10.5](../section-interval-sizes))

A tense indicating the size of an interval in time (long, medium, or short).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>ze'i</td><td>citka</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>[short-interval]</td><td>eat.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I ate for a little while.</p></td></tr></tbody></table>

### <a id="id-1.21.3.447"></a><a id="ZI"></a>selma'o ZI ( [Section 10.4](../section-temporal-tenses))

A tense indicating distance in time (a long, medium or short time ago or in the future).

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>zi</td><td>citka</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>[short-distance]</td><td>eat.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I ate a little while ago.</p></td></tr></tbody></table>

### <a id="id-1.21.3.451"></a><a id="ZIhE"></a>selma'o ZIhE ( [Section 8.4](../section-zihe))

Joins multiple relative phrases or clauses which apply to the same sumti. Although generally translated with “and”, it is not considered a logical connective.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ponse</td><td>pa</td><td>gerku</td><td>ku</td><td>poi</td><td>blabi</td></tr><tr class="gloss"><td>I</td><td>own</td><td>one</td><td>dog</td><td>&nbsp;</td><td>such-that</td><td>it-is-white</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>zi'e</td><td>noi</td><td>mi</td><td>prami</td><td>ke'a</td></tr><tr class="gloss"><td>and</td><td>such-that-incidentally</td><td>I</td><td>love</td><td>it.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I own a dog that is white and which, incidentally, I love.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">I own a white dog, which I love.</p></td></tr></tbody></table>

### <a id="id-1.21.3.456"></a><a id="ZO"></a>selma'o ZO ( [Section 19.10](../section-more-quotations))

Single-word quotation: quotes the following single Lojban word.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>zo</td><td>si</td><td>cu</td><td>lojbo</td><td>valsi</td></tr><tr class="gloss"><td>The-word</td><td>“si”</td><td>&nbsp;</td><td>is-a-Lojbanic</td><td>word.</td></tr></tbody></table>

### <a id="id-1.21.3.459"></a><a id="ZOI"></a>selma'o ZOI ( [Section 19.10](../section-more-quotations))

Non-Lojban quotation: quotes any text using a delimiting word (which can be any single Lojban word) placed before and after the text. The delimiting word must not appear in the text, and must be separated from the text by pauses.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>zoi</td><td>.kuot.</td><td>Socrates&nbsp;is&nbsp;mortal</td><td>.kuot.</td><td>cu</td><td>glico</td><td>jufra</td></tr><tr class="gloss"><td>The-text</td><td>“</td><td>Socrates&nbsp;is&nbsp;mortal</td><td>”</td><td>&nbsp;</td><td>is-an-English</td><td>sentence.</td></tr></tbody></table>

### <a id="id-1.21.3.462"></a><a id="ZOhU"></a>selma'o ZOhU ( [Section 16.2](../section-da-and-zohu) , [Section 19.4](../section-topic-comments))

Separates a logical prenex from a bridi or group of sentences to which it applies. Also separates a topic from a comment in topic/comment sentences.

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>su'o</td><td>da</td><td>poi</td><td>remna</td></tr><tr class="gloss"><td>For-at-least-one</td><td>X</td><td>which</td><td>is-a-human,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ro</td><td>de</td><td>poi</td><td>finpe</td><td>zo'u</td><td>da</td><td>prami</td><td>de</td></tr><tr class="gloss"><td>for-all</td><td>Ys</td><td>which</td><td>are-fish</td><td>:</td><td>X</td><td>loves</td><td>Y</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">There is someone who loves all fish.</p></td></tr></tbody></table>