<a id="chapter-attitudinals"></a>Chapter 13. <a id="c13"></a>Oooh! Arrgh! Ugh! Yecch! Attitudinal and emotional indicators
==========================================================================================================================

<a id="chapter-attitudinals-picture"></a>![The picture for chapter 13](/assets//books/uncll/media/chapter-attitudinals.gif)

<a id="section-attitudinals-introduction"></a>13.1. <a id="c13s1"></a>What are attitudinal indicators?
------------------------------------------------------------------------------------------------------

<a id="id-1.14.3.2.1" class="indexterm"></a>This chapter explains the various words that Lojban provides for expressing attitude and related notions. In natural languages, attitudes are usually expressed by the tone of voice when speaking, and (very imperfectly) by punctuation when writing. For example, the bare words

<div class="example">
<a id="example-random-id-EWHQ"></a>

**Example 13.1. <a id="c13e1d1"></a>** 

John is coming.

</div>  

can be made, through tone of voice, to express the speaker's feeling of happiness, pity, hope, surprise, or disbelief. These fine points of tone cannot be expressed in writing. Attitudes are also expressed with various sounds which show up in print as oddly spelled words, such as the “Oooh!” , “Arrgh!” , “Ugh!” , and “Yecch!” in the title. These are part of the English language; people born to other languages use a different set; yet you won't find any of these words in a dictionary.

<a id="id-1.14.3.5.1" class="indexterm"></a>In Lojban, everything that can be spoken can also be written. Therefore, these tones of voice must be represented by explicit words known as “attitudinal indicators” , or just “attitudinals”. This rule seems awkward and clunky to English-speakers at first, but is an essential part of the Lojbanic way of doing things.

<a id="id-1.14.3.6.1" class="indexterm"></a><a id="id-1.14.3.6.2" class="indexterm"></a>The simplest way to use attitudinal indicators is to place them at the beginning of a text. In that case, they express the speaker's prevailing attitude. Here are some examples, correlated with the attitudes mentioned following [Example 13.1](../chapter-attitudinals#example-random-id-EWHQ) :

<div class="interlinear-gloss-example example">
<a id="example-random-id-qFfd"></a>

**Example 13.2. <a id="c13e1d2"></a><a id="id-1.14.3.7.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ui</td><td>la</td><td>djan</td><td>klama</td></tr><tr class="gloss"><td>[Whee!]</td><td>that-named</td><td>John</td><td>is-coming!</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qFFo"></a>

**Example 13.3. <a id="c13e1d3"></a><a id="id-1.14.3.8.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.uu</td><td>la</td><td>djan</td><td>klama</td></tr><tr class="gloss"><td>[Alas!]</td><td>that-named</td><td>John</td><td>is-coming.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfFV"></a>

**Example 13.4. <a id="c13e1d4"></a><a id="id-1.14.3.9.1.2" class="indexterm"></a><a id="id-1.14.3.9.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.a'o</td><td>la</td><td>djan</td><td>klama</td></tr><tr class="gloss"><td>[Hopefully]</td><td>that-named</td><td>John</td><td>is-coming.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qffW"></a>

**Example 13.5. <a id="c13e1d5"></a><a id="id-1.14.3.10.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ue</td><td>la</td><td>djan</td><td>klama</td></tr><tr class="gloss"><td>[Wow!]</td><td>that-named</td><td>John</td><td>is-coming!</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfgA"></a>

**Example 13.6. <a id="c13e1d6"></a><a id="id-1.14.3.11.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ianai</td><td>la</td><td>djan</td><td>klama</td></tr><tr class="gloss"><td>[Nonsense!]</td><td>that-named</td><td>John</td><td>is-coming.</td></tr></tbody></table>

</div>  

<a id="id-1.14.3.12.1" class="indexterm"></a>The primary Lojban attitudinals are all the cmavo of the form VV or V'V: one of the few cases where cmavo have been classified solely by their form. There are 39 of these cmavo: all 25 possible vowel pairs of the form V'V, the four standard diphthongs ( _<a id="id-1.14.3.12.2.1" class="indexterm"></a>[_.ai_](../go01#valsi-ai)_ , _<a id="id-1.14.3.12.3.1" class="indexterm"></a>[_.au_](../go01#valsi-au)_ , _<a id="id-1.14.3.12.4.1" class="indexterm"></a>[_.ei_](../go01#valsi-ei)_ , and _<a id="id-1.14.3.12.5.1" class="indexterm"></a>[_.oi_](../go01#valsi-oi)_), and the ten more diphthongs that are permitted only in these attitudinal indicators and in Lojbanized names and borrowings ( _<a id="id-1.14.3.12.6.1" class="indexterm"></a>[_.ia_](../go01#valsi-ia)_ , _<a id="id-1.14.3.12.7.1" class="indexterm"></a>[_.ie_](../go01#valsi-ie)_ , _<a id="id-1.14.3.12.8.1" class="indexterm"></a>[_.ii_](../go01#valsi-ii)_ , _<a id="id-1.14.3.12.9.1" class="indexterm"></a>[_.io_](../go01#valsi-io)_ , _<a id="id-1.14.3.12.10.1" class="indexterm"></a>[_.iu_](../go01#valsi-iu)_ , _<a id="id-1.14.3.12.11.1" class="indexterm"></a>[_.ua_](../go01#valsi-ua)_ , _<a id="id-1.14.3.12.12.1" class="indexterm"></a>[_.ue_](../go01#valsi-ue)_ , _<a id="id-1.14.3.12.13.1" class="indexterm"></a>[_.ui_](../go01#valsi-ui)_ , _<a id="id-1.14.3.12.14.1" class="indexterm"></a>[_.uo_](../go01#valsi-uo)_ , and _<a id="id-1.14.3.12.15.1" class="indexterm"></a>[_.uu_](../go01#valsi-uu)_). Note that each of these cmavo has a period before it, marking the pause that is mandatory before every word beginning with a vowel. Attitudinals, like most of the other kinds of indicators described in this chapter, belong to selma'o UI.

<a id="id-1.14.3.13.1" class="indexterm"></a>Attitudinals can also be compound cmavo, of the types explained in Sections 4-8; [Example 13.6](../chapter-attitudinals#example-random-id-qfgA) illustrates one such possibility, the compound attitudinal _<a id="id-1.14.3.13.3.1" class="indexterm"></a>[_.ianai_](../go01#valsi-ianai)_. In attitudinals, _<a id="id-1.14.3.13.4.1" class="indexterm"></a>\-nai_ indicates polar negation: the opposite of the simple attitudinal without the _<a id="id-1.14.3.13.5.1" class="indexterm"></a>\-nai_. Thus, as you might suppose, _<a id="id-1.14.3.13.6.1" class="indexterm"></a>[_.ia_](../go01#valsi-ia)_ expresses belief, since _<a id="id-1.14.3.13.7.1" class="indexterm"></a>[_.ianai_](../go01#valsi-ianai)_ expresses disbelief.

<a id="id-1.14.3.14.1" class="indexterm"></a><a id="id-1.14.3.14.2" class="indexterm"></a>In addition to the attitudinals, there are other classes of indicators: intensity markers, emotion categories, attitudinal modifiers, observationals, and discursives. All of them are grammatically equivalent, which is why they are treated together in this chapter.

Every indicator behaves in more or less the same way with respect to the grammar of the rest of the language. In general, one or more indicators can be inserted at the beginning of an utterance or after any word. Indicators at the beginning apply to the whole utterance; otherwise, they apply to the word that they follow. More details can be found in [Section 13.9](../section-scope).

Throughout this chapter, tables of indicators will be written in four columns. The first column is the cmavo itself. The second column is a corresponding English word, not necessarily a literal translation. The fourth column represents the opposite of the second column, and shows the approximate meaning of the attitudinal when suffixed with _<a id="id-1.14.3.16.1.1" class="indexterm"></a>\-nai_. The third column, which is sometimes omitted, indicates a neutral point between the second and fourth columns, and shows the approximate meaning of the attitudinal when it is suffixed with _<a id="id-1.14.3.16.2.1" class="indexterm"></a>\-cu'i_. The cmavo _<a id="id-1.14.3.16.3.1" class="indexterm"></a>[_cu'i_](../go01#valsi-cuhi)_ belongs to selma'o CAI, and is explained more fully in [Section 13.4](../section-intensity-scale).

One flaw that the English glosses are particularly subject to is that in English it is often difficult to distinguish between expressing your feelings and talking about them, particularly with the limited resource of the written word. So the gloss for _<a id="id-1.14.3.17.1.1" class="indexterm"></a>[_.ui_](../go01#valsi-ui)_ should not really be “happiness” but some sound or tone that expresses happiness. However, there aren't nearly enough of those that have unambiguous or obvious meanings in English to go around for all the many, many different emotions Lojban speakers can readily express.

Many indicators of CV'V form are loosely derived from specific gismu. The gismu should be thought of as a memory hook, not an equivalent of the cmavo. Such gismu are shown in this chapter between square brackets, thus: \[gismu\].