/**
 *  © 2023–2024 KudoAI & contributors under the MIT license.
 *  Source: https://github.com/KudoAI/chatgpt.js
 *  User guide: https://chatgptjs.org/userguide
 *  Latest minified release: https://cdn.jsdelivr.net/npm/@kudoai/chatgpt.js/chatgpt.min.js
 */
localStorage.alertQueue=JSON.stringify([]),localStorage.notifyProps=JSON.stringify({queue:{topRight:[],bottomRight:[],bottomLeft:[],topLeft:[]}});let chatgpt={openAIaccessToken:{},endpoints:{assets:"https://cdn.jsdelivr.net/gh/KudoAI/chatgpt.js@0a17dd78389917e751fb4a68c42cbf4d0f70c6e4",openAI:{session:"https://chatgpt.com/api/auth/session",chats:"https://chatgpt.com/backend-api/conversations",chat:"https://chatgpt.com/backend-api/conversation",share_create:"https://chatgpt.com/backend-api/share/create",share:"https://chatgpt.com/backend-api/share",instructions:"https://chatgpt.com/backend-api/user_system_messages"}},actAs(s){return new Promise((o,a)=>{let n=new XMLHttpRequest;n.open("GET","https://raw.githubusercontent.com/KudoAI/chat-prompts/main/dist/personas.min.json",!0),n.send(),n.onload=()=>{if(200!==n.status)return a("🤖 chatgpt.js >> Request failed. Cannot retrieve prompts data.");var e=JSON.parse(n.responseText).personas;if(s){var t=e.find(e=>e.title.toLowerCase()==s.toLowerCase());if(!t)return a(`🤖 chatgpt.js >> Persona '${s}' was not found!`);chatgpt.send(t.prompt,"click"),console.info(`Loading ${s} persona...`),chatgpt.isIdle().then(()=>{console.info("Persona activated!")})}else{console.log("\n%c🤖 chatgpt.js personas\n","font-family: sans-serif ; font-size: xxx-large ; font-weight: bold");for(var r of e)console.log("%c"+r.title,"font-family: monospace ; font-size: larger ;")}return o()}})},activateDarkMode(){document.documentElement.classList.replace("light","dark"),document.documentElement.style.colorScheme="dark",localStorage.setItem("theme","dark")},activateLightMode(){document.documentElement.classList.replace("dark","light"),document.documentElement.style.colorScheme="light",localStorage.setItem("theme","light")},alert(r,o,e,a,t){let n=chatgpt.isDarkMode()?"dark":"light",s=chatgpt.browser.isMobile(),i=document.createElement("div"),c=(i.id=Math.floor(1e6*chatgpt.randomFloat())+Date.now(),i.classList.add("chatgpt-modal"),document.createElement("div")),l=document.createElement("h2"),d=document.createElement("p");var g=20231203;let u=document.querySelector("#chatgpt-modal-style"),p=((!u||parseInt(u.getAttribute("last-updated"),10)<g)&&(u||((u=document.createElement("style")).id="chatgpt-modal-style",u.setAttribute("last-updated",g.toString()),document.head.append(u)),u.innerText=".no-mobile-tap-outline { outline: none ; -webkit-tap-highlight-color: transparent }.chatgpt-modal {position: fixed ; top: 0 ; left: 0 ; width: 100% ; height: 100% ;background-color: rgba(67, 70, 72, 0) ;transition: background-color 0.05s ease ;display: flex ; justify-content: center ; align-items: center ; z-index: 9999 }.chatgpt-modal > div {opacity: 0 ; transform: translateX(-2px) translateY(5px) ; max-width: 75vw ; word-wrap: break-word ;transition: opacity 0.1s cubic-bezier(.165,.84,.44,1), transform 0.2s cubic-bezier(.165,.84,.44,1) ;"+`background-color: ${"dark"==n?"black":"white"} ;`+("dark"!=n?"border: 1px solid rgba(0, 0, 0, 0.3) ;":"")+"padding: 20px ; margin: 12px 23px ; border-radius: 15px ; box-shadow: 0 30px 60px rgba(0, 0, 0, .12) ; -webkit-user-select: none ; -moz-user-select: none ; -ms-user-select: none ; user-select: none ; }.chatgpt-modal h2 { margin-bottom: 9px }"+`.chatgpt-modal a { color: ${"dark"==n?"#00cfff":"#1e9ebb"}}`+".chatgpt-modal.animated > div { opacity: 1 ; transform: translateX(0) translateY(0) }@keyframes alert-zoom-fade-out { 0% { opacity: 1 ; transform: scale(1) }50% { opacity: 0.25 ; transform: scale(1.05) }100% { opacity: 0 ; transform: scale(1.35) }}.modal-buttons { display: flex ; justify-content: flex-end ; margin: 20px -5px -3px 0 ;"+(s?"flex-direction: column-reverse":"")+"}.chatgpt-modal button {"+`margin-left: ${s?0:10}px ; padding: ${s?15:4}px 18px ; border-radius: 15px ;`+(s?"margin-top: 5px ; margin-bottom: 3px ;":"")+`border: 1px solid ${"dark"==n?"white":"black"}}`+".primary-modal-btn {"+`border: 1px solid ${"dark"==n?"white":"black"} ;`+`background: ${"dark"==n?"white":"black"} ;`+`color: ${"dark"==n?"black":"white"}}`+".chatgpt-modal button:hover { color: #3d5d71 ; border-color: #6d9cb9 ;background-color: "+("dark"==n?"#00cfff":"#9cdaff")+";box-shadow: 2px 1px "+("dark"==n?"54px #00cfff":"30px #9cdaff")+"}.modal-close-btn {cursor: pointer ; width: 29px ; height: 29px ; border-radius: 17px ;float: right ; position: relative ; right: -6px ; top: -5px }.modal-close-btn svg { margin: 10px }"+`.modal-close-btn:hover { background-color: #f2f2f2${"dark"==n?"00":""}}`+".chatgpt-modal .checkbox-group { display: flex ; margin-top: -18px }.chatgpt-modal .checkbox-group label {font-size: .7rem ; margin: -.04rem 0 0px .3rem ;"+`color: ${"dark"==n?"#e1e1e1":"#1e1e1e"}}`+'.chatgpt-modal input[type="checkbox"] { transform: scale(0.7) ;'+`border: 1px solid ${"dark"==n?"white":"black"}}`+'.chatgpt-modal input[type="checkbox"]:checked {'+`border: 1px solid ${"dark"==n?"white":"black"} ;`+'background-color: black ; position: inherit }.chatgpt-modal input[type="checkbox"]:focus { outline: none ; box-shadow: none }'),l.innerText=r||"",d.innerText=o||"",chatgpt.renderHTML(d),document.createElement("div"));p.classList.add("modal-buttons","no-mobile-tap-outline"),e&&(e=Array.isArray(e)?e:[e]).forEach(e=>{var t=document.createElement("button");t.textContent=e.name.replace(/[_-]\w/g,e=>e.slice(1).toUpperCase()).replace(/([A-Z])/g," $1").replace(/^\w/,e=>e.toUpperCase()),t.onclick=()=>{y(),e()},p.insertBefore(t,p.firstChild)});g=document.createElement("button"),g.textContent=e?"Dismiss":"OK",p.insertBefore(g,p.firstChild),p.lastChild.classList.add("primary-modal-btn"),r=document.createElement("div");if(a){r.classList.add("checkbox-group");let e=a,t=document.createElement("input");t.type="checkbox",t.onchange=e;o=document.createElement("label");o.onclick=()=>{t.checked=!t.checked,e()},o.textContent=e.name.charAt(0).toUpperCase()+e.name.slice(1).replace(/([A-Z])/g,(e,t)=>" "+t.toLowerCase()).replace(/\b(\w+)nt\b/gi,"$1n't").trim(),r.append(t),r.append(o)}e=document.createElement("div"),e.title="Close",e.classList.add("modal-close-btn","no-mobile-tap-outline"),a=document.createElementNS("http://www.w3.org/2000/svg","svg"),a.setAttribute("height","10px"),a.setAttribute("viewBox","0 0 14 14"),a.setAttribute("fill","none"),o=document.createElementNS("http://www.w3.org/2000/svg","path");o.setAttribute("fill-rule","evenodd"),o.setAttribute("clip-rule","evenodd"),o.setAttribute("fill",chatgpt.isDarkMode()?"white":"black"),o.setAttribute("d","M13.7071 1.70711C14.0976 1.31658 14.0976 0.683417 13.7071 0.292893C13.3166 -0.0976312 12.6834 -0.0976312 12.2929 0.292893L7 5.58579L1.70711 0.292893C1.31658 -0.0976312 0.683417 -0.0976312 0.292893 0.292893C-0.0976312 0.683417 -0.0976312 1.31658 0.292893 1.70711L5.58579 7L0.292893 12.2929C-0.0976312 12.6834 -0.0976312 13.3166 0.292893 13.7071C0.683417 14.0976 1.31658 14.0976 1.70711 13.7071L7 8.41421L12.2929 13.7071C12.6834 14.0976 13.3166 14.0976 13.7071 13.7071C14.0976 13.3166 14.0976 12.6834 13.7071 12.2929L8.41421 7L13.7071 1.70711Z"),a.append(o),e.append(a),[e,l,d,p,r].forEach(e=>{c.append(e)}),c.style.width=`${t||458}px`,i.append(c),document.body.append(i);let h=JSON.parse(localStorage.alertQueue),m=(h.push(i.id),localStorage.alertQueue=JSON.stringify(h),i.style.display="none",1===h.length&&(i.style.display="",setTimeout(()=>{i.style.backgroundColor=`rgba(67, 70, 72, ${"dark"==n?.62:.1})`,i.classList.add("animated")},100)),e=>{(e.target==e.currentTarget||e.target instanceof SVGPathElement)&&y()}),f=e=>{if([" ","Spacebar","Enter","Return","Escape","Esc"].includes(e.key)||[32,13,27].includes(e.keyCode))for(var t of h){var t=document.getElementById(t);if(t&&"none"!==t.style.display)return void(e.key.includes("Esc")||27==e.keyCode?y():([" ","Spacebar","Enter","Return"].includes(e.key)||[32,13].includes(e.keyCode))&&(t=t.querySelector(".modal-buttons").lastChild)&&(t.click(),e.preventDefault()))}},y=([i,e,a,g].forEach(e=>e.onclick=m),document.addEventListener("keydown",f),()=>{i.style.backgroundColor="transparent",c.style.animation="alert-zoom-fade-out 0.075s ease-out",setTimeout(()=>{if(i.remove(),(h=JSON.parse(localStorage.alertQueue)).shift(),localStorage.alertQueue=JSON.stringify(h),document.removeEventListener("keydown",f),0<h.length){let e=document.getElementById(h[0]);setTimeout(()=>{e.style.display="",setTimeout(()=>{e.classList.add("animated")},100)},500)}},50)});return i.id},async askAndGetReply(e){return chatgpt.send(e),await chatgpt.isIdle(),chatgpt.getChatData("active","msg","chatgpt","latest")},autoRefresh:{activate(e){if(this.isActive)console.log("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Auto refresh already active!");else{let r=this,o=(this.toggle.refreshFrame(),t=>{var e=Math.max(2,Math.floor(21*chatgpt.randomFloat()-10));r.isActive=setTimeout(()=>{var e=document.querySelector('script[src*="_ssgManifest.js"]');e&&(document.querySelector("#refresh-frame").src=e.src+"?"+Date.now(),console.log("↻ ChatGPT >> ["+r.nowTimeStamp()+"] ChatGPT session refreshed")),o(t)},1e3*(t+e))});o(e?parseInt(e,10):30),console.log("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Auto refresh activated"),navigator.userAgent.includes("Chrome")&&void 0!==document.hidden&&document.addEventListener("visibilitychange",this.toggle.beacons)}},deactivate(){this.isActive?(this.toggle.refreshFrame(),document.removeEventListener("visibilitychange",this.toggle.beacons),clearTimeout(this.isActive),this.isActive=null,console.log("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Auto refresh de-activated")):console.log("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Auto refresh already inactive!")},nowTimeStamp(){var e=new Date,t=e.getHours()%12||12;let r=e.getMinutes(),o=e.getSeconds();r<10&&(r="0"+r),o<10&&(o="0"+o);e=e.getHours()<12?"AM":"PM";return t+":"+r+":"+o+" "+e},toggle:{beacons(){chatgpt.autoRefresh.beaconID?(clearInterval(chatgpt.autoRefresh.beaconID),chatgpt.autoRefresh.beaconID=null,console.log("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Beacons de-activated")):(chatgpt.autoRefresh.beaconID=setInterval(()=>{navigator.sendBeacon("https://httpbin.org/post",new Uint8Array),console.log("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Beacon sent")},9e4),console.log("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Beacons activated"))},refreshFrame(){let e=document.querySelector("#refresh-frame");e?e.remove():(e=Object.assign(document.createElement("iframe"),{id:"refresh-frame",style:"display: none"}),document.head.prepend(e))}}},browser:{isLightMode(){return window.matchMedia?.("(prefers-color-scheme: light)")?.matches},isDarkMode(){return window.matchMedia?.("(prefers-color-scheme: dark)")?.matches},isChromium(){return!!JSON.stringify(navigator.userAgentData?.brands)?.includes("Chromium")},isChrome(){return!!JSON.stringify(navigator.userAgentData?.brands)?.includes("Chrome")},isEdge(){return!!JSON.stringify(navigator.userAgentData?.brands)?.includes("Edge")},isBrave(){return!!JSON.stringify(navigator.userAgentData?.brands)?.includes("Brave")},isFirefox(){return navigator.userAgent.includes("Firefox")},isFullScreen(){var e=navigator.userAgent;return e.includes("Chrome")?window.matchMedia("(display-mode: fullscreen)").matches:e.includes("Firefox")?window.fullScreen:/MSIE|rv:/.test(e)?document.msFullscreenElement:document.webkitIsFullScreen},isMobile(){return/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)}},async clearChats(){return new Promise((r,o)=>{chatgpt.getAccessToken().then(e=>{let t=new XMLHttpRequest;t.open("PATCH",chatgpt.endpoints.openAI.chats,!0),t.setRequestHeader("Content-Type","application/json"),t.setRequestHeader("Authorization","Bearer "+e),t.onload=()=>{if(200!==t.status)return o("🤖 chatgpt.js >> Request failed. Cannot clear chats.");console.info("Chats successfully cleared"),r()},t.send(JSON.stringify({is_visible:!1}))}).catch(e=>o(new Error(e.message)))})},code:{async execute(e){return e?"string"!=typeof e?console.error("Code argument must be a string!"):(chatgpt.send("Display the output as if you were terminal:\n\n"+e),console.info("Executing code..."),await chatgpt.isIdle(),chatgpt.code.extract(await chatgpt.getChatData("active","msg","chatgpt","latest"))):console.error("Code argument not supplied. Pass some code!")},extract(e){var t=e.match(/(?<=```.*\n)[\s\S]*?(?=```)/g);return t?t[t.length-1]:e},async isIdle(t=null){let a={childList:!0,subtree:!0},n={msgDiv:"div[data-message-author-role]",replyDiv:'div[data-message-author-role="assistant"]'};var e=t?new Promise(e=>setTimeout(()=>e(!1),t)):null,r=(async()=>{await new Promise(r=>{document.querySelector(n.msgDiv)?r():new MutationObserver((e,t)=>{document.querySelector(n.msgDiv)&&(t.disconnect(),r())}).observe(document.body,a)}),await new Promise(r=>{new MutationObserver((e,t)=>{chatgpt.getStopBtn()&&(t.disconnect(),r())}).observe(document.body,{childList:!0,subtree:!0})});let e=document.querySelectorAll(n.replyDiv),o=e[e.length-1];return await new Promise(r=>{new MutationObserver((e,t)=>{o?.querySelector("pre")&&(t.disconnect(),r())}).observe(document.body,a)}),new Promise(r=>{new MutationObserver((e,t)=>{!o?.querySelector("pre")?.nextElementSibling&&chatgpt.getStopBtn()||(t.disconnect(),r(!0))}).observe(document.body,a)})})();return e?Promise.race([r,e]):r},async minify(e){return e?"string"!=typeof e?console.error("Code argument must be a string!"):(chatgpt.send("Minify the following code:\n\n"+e),console.info("Minifying code..."),await chatgpt.isIdle(),chatgpt.code.extract(await chatgpt.getChatData("active","msg","chatgpt","latest"))):console.error("Code argument not supplied. Pass some code!")},async obfuscate(e){return e?"string"!=typeof e?console.error("Code argument must be a string!"):(chatgpt.send("Obfuscate the following code:\n\n"+e),console.info("Obfuscating code..."),await chatgpt.isIdle(),chatgpt.code.extract(await chatgpt.getChatData("active","msg","chatgpt","latest"))):console.error("Code argument not supplied. Pass some code!")},async refactor(e,t){if(!e)return console.error("Code (1st) argument not supplied. Pass some code!");for(let e=0;e<arguments.length;e++)if("string"!=typeof arguments[e])return console.error(`Argument ${e+1} must be a string.`);return chatgpt.send("Refactor the following code for "+(t||"brevity")+":\n\n"+e),console.info("Refactoring code..."),await chatgpt.isIdle(),chatgpt.code.extract(await chatgpt.getChatData("active","msg","chatgpt","latest"))},async review(e){return e?"string"!=typeof e?console.error("Code argument must be a string!"):(chatgpt.send("Review the following code for me:\n\n"+e),console.info("Reviewing code..."),await chatgpt.isIdle(),chatgpt.getChatData("active","msg","chatgpt","latest")):console.error("Code argument not supplied. Pass some code!")},async unminify(e){return e?"string"!=typeof e?console.error("Code argument must be a string!"):(chatgpt.send("Unminify the following code.:\n\n"+e),console.info("Unminifying code..."),await chatgpt.isIdle(),chatgpt.code.extract(await chatgpt.getChatData("active","msg","chatgpt","latest"))):console.error("Code argument not supplied. Pass some code!")},async write(e,t){if(!e)return console.error("Prompt (1st) argument not supplied. Pass a prompt!");if(!t)return console.error("outputLang (2nd) argument not supplied. Pass a language!");for(let e=0;e<arguments.length;e++)if("string"!=typeof arguments[e])return console.error(`Argument ${e+1} must be a string.`);return chatgpt.send(e+"\n\nWrite this as code in "+t),console.info("Writing code..."),await chatgpt.isIdle(),chatgpt.code.extract(await chatgpt.getChatData("active","msg","chatgpt","latest"))}},continue(){chatgpt.response.continue()},async detectLanguage(e){return e?"string"!=typeof e?console.error("Text argument must be a string!"):(chatgpt.send("Detect the language of the following text:\n\n"+e+"\n\nOnly respond with the name of the language"),console.info("Reviewing text..."),await chatgpt.isIdle(),chatgpt.getChatData("active","msg","chatgpt","latest")):console.error("Text argument not supplied. Pass some text!")},executeCode(){chatgpt.code.execute()},async exportChat(e,t){e=e?Number.isInteger(e)||/^\d+$/.test(e)?parseInt(e,10):e:"active",t=t.toLowerCase()||"html",console.info("Generating transcript...");let a="",r;if(/te?xt/.test(t)){var o=new Date,n=o.getDate().toString().padStart(2,"0"),s=(o.getMonth()+1).toString().padStart(2,"0"),i=o.getFullYear(),c=o.getHours().toString().padStart(2,"0"),o=o.getMinutes().toString().padStart(2,"0");if(r=`ChatGPT_${n}-${s}-${i}_${c}-${o}.txt`,"active"==e&&/\/\w{8}-\w{4}-\w{4}-\w{4}-\w{12}$/.test(window.location.href)){n=document.querySelectorAll("main > div > div > div > div > div > div[class*=group]");if(0===n.length)return console.error("Chat is empty!");let r=[],o=!0;n.forEach(e=>{var t=o?"USER":"CHATGPT",e=(o=!o,Array.from(e.childNodes).map(e=>e.innerText).join("\n\n").replace("Copy code",""));r.push(t+": "+e)}),a=r.join("\n\n")}else for(var l of await chatgpt.getChatData(e,"msg","both","all"))a=(a+=`USER: ${l.user}

`)+`CHATGPT: ${l.chatgpt}

`}else{s=await(await fetch(await chatgpt.shareChat(e))).text(),i=(new DOMParser).parseFromString(s,"text/html");r=`${i.querySelector("title").textContent||"ChatGPT conversation"}.html`,i.querySelectorAll('link[rel="stylesheet"]').forEach(e=>{var t=e.getAttribute("href");t?.startsWith("/")&&e.setAttribute("href","https://chat.openai.com"+t)}),a=(new XMLSerializer).serializeToString(i)}if(console.info(`Exporting transcript as ${t.toUpperCase()}...`),"pdf"==t){a=a.replace(/<svg.*?<\/svg>/g,e=>`<img src="${"data:image/svg+xml,"+encodeURIComponent(e)}">`);let e=window.open("","","toolbar=0, location=0, menubar=0, height=600, width=800");e.document.write(a),setTimeout(()=>{e.print({toPDF:!0})},100)}else{"md"==t&&(c=/<.*(?:<h1(.|\n)*?href=".*?continue[^"]*".*?\/a>.*?)<[^/]/.exec(a)[1],a=c||a,r=r.replace(".html",".md"));o=new Blob([a],{type:"text/"+("html"==t?"html":"md"==t?"markdown":"plain")}),n=document.createElement("a"),e=URL.createObjectURL(o);n.href=e,n.download=r,document.body.append(n),n.click(),document.body.removeChild(n),URL.revokeObjectURL(e)}},extractCode(){chatgpt.code.extract()},focusChatbar(){chatgpt.getChatBox()?.focus()},footer:{get(){return document.querySelector("main form")?.parentNode.parentNode.nextElementSibling},hide(){var e=chatgpt.footer.get();return e?"hidden"==e.style.visibility?console.info("Footer already hidden!"):(e.style.visibility="hidden",void(e.style.height="3px")):console.error("Footer element not found!")},show(){var e=chatgpt.footer.get();return e?"hidden"!=e.style.visibility?console.info("Footer already shown!"):void(e.style.visibility=e.style.height="inherit"):console.error("Footer element not found!")}},generateRandomIP(){var e=Array.from({length:4},()=>Math.floor(256*chatgpt.randomFloat())).join(".");return console.info("IP generated: "+e),e},get(e,t=""){if("string"!=typeof e||"string"!=typeof t)throw new TypeError("Invalid arguments. Both arguments must be strings.");if(!cjsTargetTypes.includes(e.toLowerCase()))throw new Error("Invalid targetType: "+e+". Valid values are: "+JSON.stringify(cjsTargetTypes));var r,o=[],a=new RegExp("^get(.*)"+e+"$","i");for(r in chatgpt)"function"==typeof chatgpt[r]&&a.test(r)&&o.push(r.replace(a,"$1").toLowerCase());if(!o.includes(t.toLowerCase()))throw new Error("Invalid targetName: "+t+". "+(0<o.length?"Valid values are: "+JSON.stringify(o):"targetType "+e.toLowerCase()+" does not require additional options."));let n=("get"+t+e).toLowerCase();return this[Object.keys(this).find(e=>e.toLowerCase()==n)]()},getAccessToken(){return new Promise((e,t)=>{if(0<Object.keys(chatgpt.openAIaccessToken).length&&0<=Date.parse(chatgpt.openAIaccessToken.expireDate)-Date.parse(new Date))return e(chatgpt.openAIaccessToken.token);let r=new XMLHttpRequest;r.open("GET",chatgpt.endpoints.openAI.session,!0),r.setRequestHeader("Content-Type","application/json"),r.onload=()=>200!==r.status?t("🤖 chatgpt.js >> Request failed. Cannot retrieve access token."):(console.info("Token expiration: "+new Date(JSON.parse(r.responseText).expires).toLocaleString().replace(","," at")),chatgpt.openAIaccessToken={token:JSON.parse(r.responseText).accessToken,expireDate:JSON.parse(r.responseText).expires},e(chatgpt.openAIaccessToken.token)),r.send()})},getAccountDetails(...s){var e,t=["email","id","image","name","picture"];for(e of s=arguments[0]?Array.isArray(arguments[0])?arguments[0]:Array.from(arguments):t)if(!t.includes(e))return console.error("Invalid detail arg '"+e+"' supplied. Valid details are:\n                    ["+t+"]");return new Promise((o,a)=>{let n=new XMLHttpRequest;n.open("GET",chatgpt.endpoints.openAI.session,!0),n.setRequestHeader("Content-Type","application/json"),n.onload=()=>{if(200!==n.status)return a("🤖 chatgpt.js >> Request failed. Cannot retrieve account details.");var e,t=JSON.parse(n.responseText).user,r={};for(e of s)r[e]=t[e];return o(r)},n.send()})},getChatBox(){return document.getElementById("prompt-textarea")},getChatData(d=1,o="all",p="all",h="all"){var e,t=["all","id","title","create_time","update_time","msg"],r=["all","both","user","chatgpt"];d=d?Number.isInteger(d)||/^\d+$/.test(d)?0===parseInt(d,10)?0:parseInt(d,10)-1:d:"active",o=["all",""].includes(o)?t.filter(e=>/^(?!all$|msg$).*/.test(e)):Array.isArray(o)?o:[o],p=p?r.includes(p)?p:"invalid":"all",h=Number.isInteger(h)||/^\d+$/.test(h)?0===parseInt(h,10)?0:parseInt(h,10)-1:["all","latest"].includes(h.toLowerCase())?h.toLowerCase():h?"invalid":"all";for(e of o)if(!t.includes(e))return console.error("Invalid detail arg '"+e+"' passed. Valid details are:\n                    ["+t+"]");if("invalid"==p)return console.error("Invalid sender arg passed. Valid senders are:\n                    ["+r+"]");if("invalid"==h)return console.error("Invalid msgToGet arg passed. Valid msg's to get are:\n                    [ 'all' | 'latest' | index of msg to get ]");let a=(e,c)=>{let l=/\w{8}-\w{4}-\w{4}-\w{4}-\w{12}/;return new Promise((t,s)=>{let i=new XMLHttpRequest;i.open("GET",chatgpt.endpoints.openAI.chats,!0),i.setRequestHeader("Content-Type","application/json"),i.setRequestHeader("Authorization","Bearer "+e),i.onload=()=>{if(200!==i.status)return s("🤖 chatgpt.js >> Request failed. Cannot retrieve chat details.");var r=JSON.parse(i.responseText).items;if(r.length<=0)return s("🤖 chatgpt.js >> Chat list is empty.");var o={};if(Number.isInteger(d)||"latest"==d||"active"==d&&!new RegExp("/"+l.source+"$").test(window.location.href)){if((d=Number.isInteger(d)?d:0)>r.length)return s("🤖 chatgpt.js >> Chat with index "+(d+1)+" is out of bounds. Only "+r.length+" chats exist!");for(var e of c)o[e]=r[d][e]}else{var a,n="active"==d||new RegExp("^"+l.source+"$").test(d)?"id":"title";"active"==d&&(d=l.exec(window.location.href)[0]);let e,t;for(e=0;e<r.length;e++)if(r[e][n]==d){t=!0;break}if(!t)return s("🤖 chatgpt.js >> No chat with "+n+" = "+d+" found.");for(a of c)o[a]=r[e][a]}return t(o)},i.send()})};return new Promise(r=>chatgpt.getAccessToken().then(e=>{return r(o.includes("msg")?(t=e,new Promise((d,g)=>{let u=new XMLHttpRequest;a(t,["id"]).then(e=>{u.open("GET",chatgpt.endpoints.openAI.chat+"/"+e.id,!0),u.setRequestHeader("Content-Type","application/json"),u.setRequestHeader("Authorization","Bearer "+t),u.onload=()=>{if(200!==u.status)return g("🤖 chatgpt.js >> Request failed. Cannot retrieve chat messages.");var e,t,r=JSON.parse(u.responseText).mapping,o=[],a=[],n=[];for(e in r)null!=r[e].message&&"user"==r[e].message.author.role&&o.push({id:r[e].id,msg:r[e].message});if(o.sort((e,t)=>e.msg.create_time-t.msg.create_time),parseInt(h,10)+1>o.length)return g("🤖 chatgpt.js >> Message/response with index "+(h+1)+" is out of bounds. Only "+o.length+" messages/responses exist!");for(t of o){let e=[];for(var s in r)null!=r[s].message&&"assistant"==r[s].message.author.role&&r[s].parent==t.id&&e.push(r[s].message);e.sort((e,t)=>e.create_time-t.create_time),e=1===(e=e.map(e=>{switch(e.content.content_type){case"code":return e.content.text;case"text":return e.content.parts[0];default:return}})).length?e[0]:e,a.push(e)}if("user"==p)for(var i in o)n.push(o[i].msg.content.parts[0]);else if("chatgpt"==p)for(var c of a)n.push("latest"==h?a[a.length-1]:c);else{let e=0;for(var l in o)n.push({user:o[l].msg.content.parts[0],chatgpt:"latest"==h?a[e][a[e].length-1]:a[e]}),e++}return d("all"==h?n:"latest"==h?n[n.length-1]:n[h])},u.send()})})):a(e,o));var t}))},getChatInput(){return chatgpt.getChatBox().firstChild.innerText},getContinueButton(){return document.querySelector('button.btn:has([d^="M4.47189"])')},getFooterDiv(){return chatgpt.footer.get()},getHeaderDiv(){return chatgpt.header.get()},getLastPrompt(){return chatgpt.getChatData("active","msg","user","latest")},getLastResponse(){return chatgpt.getChatData("active","msg","chatgpt","latest")},getNewChatButton(){return document.querySelector('button[data-testid*="new-chat-button"]')},getNewChatLink(){return document.querySelector('nav a[href="/"]')},getRegenerateButton(){return document.querySelector('button:has([d^="M3.06957"])')},getResponse(){return chatgpt.response.get(...arguments)},getResponseFromAPI(e,t){return chatgpt.response.getFromAPI(e,t)},getResponseFromDOM(e){return chatgpt.response.getFromDOM(e)},getScrollToBottomButton(){return document.querySelector('button:has([d^="M12 21C11.7348"])')},getSendButton(){return document.querySelector('[data-testid="send-button"]')},getStopButton(){return document.querySelector('button[data-testid="stop-button"]')},getUserLanguage(){return navigator.languages[0]||navigator.language||navigator.browserLanguage||navigator.systemLanguage||navigator.userLanguage||""},header:{get(){return document.querySelector("main .sticky")},hide(){chatgpt.header.get().style.display="none"},show(){chatgpt.header.get().style.display="flex"}},hideFooter(){chatgpt.footer.hide()},hideHeader(){chatgpt.header.hide()},history:{async isLoaded(t=null){var e=t?new Promise(e=>setTimeout(()=>e(!1),t)):null,r=new Promise(r=>{document.querySelector("nav")?r(!0):new MutationObserver((e,t)=>{document.querySelector("nav")&&(t.disconnect(),r(!0))}).observe(document.body,{childList:!0,subtree:!0})});return e?Promise.race([r,e]):r}},instructions:{add(o,a){var e;return o?"string"!=typeof o?console.error("Instruction must be a string"):(e=["user","chatgpt"],a?"string"!=typeof a?console.error("Target must be a string"):(a=a.toLowerCase(),e.includes(a)?(o=`

`+o,new Promise(r=>{chatgpt.getAccessToken().then(async e=>{var t=await this.fetchData();return"user"==a?t.about_user_message+=o:"chatgpt"==a&&(t.about_model_message+=o),await this.sendRequest("POST",e,t),r()})})):console.error(`Invalid target ${a}. Valid targets are [${e}]`)):console.error("Please provide a valid target!")):console.error("Please provide an instruction")},clear(o){var e=["user","chatgpt"];return o?"string"!=typeof o?console.error("Target must be a string"):(o=o.toLowerCase(),e.includes(o)?new Promise(r=>{chatgpt.getAccessToken().then(async e=>{var t=await this.fetchData();return"user"==o?t.about_user_message="":"chatgpt"==o&&(t.about_model_message=""),await this.sendRequest("POST",e,t),r()})}):console.error(`Invalid target ${o}. Valid targets are [${e}]`)):console.error("Please provide a valid target!")},fetchData(){return new Promise(t=>{chatgpt.getAccessToken().then(async e=>t(await this.sendRequest("GET",e)))})},sendRequest(a,e,n){for(let e=0;e<arguments.length-1;e++)if("string"!=typeof arguments[e])return console.error(`Argument ${e+1} must be a string`);var t=["POST","GET"];return(a=(a||"").trim().toUpperCase())&&t.includes(a)?e?n&&"object"!=typeof n?console.error(`Invalid body data type. Got ${typeof n}, expected object`):new Promise((t,r)=>{let o=new XMLHttpRequest;o.open(a,chatgpt.endpoints.openAI.instructions,!0),o.setRequestHeader("Accept-Language","en-US"),o.setRequestHeader("Authorization","Bearer "+e),"POST"==a&&o.setRequestHeader("Content-Type","application/json"),o.onload=()=>{var e=JSON.parse(o.responseText);return 422===o.status?r("🤖 chatgpt.js >> Character limit exceeded. Custom instructions can have a maximum length of 1500 characters."):403===o.status&&"content_policy"==e.detail.reason?r("🤖 chatgpt.js >> "+e.detail.description):200!==o.status?r("🤖 chatgpt.js >> Request failed. Cannot contact custom instructions endpoint."):(console.info("Custom instructions successfully contacted with method "+a),t(e||{}))},o.send(JSON.stringify(n)||"")}):console.error("Please provide a valid access token!"):console.error("Valid methods are "+t)},turnOff(){return new Promise(r=>{chatgpt.getAccessToken().then(async e=>{var t=await this.fetchData();return t.enabled=!1,await this.sendRequest("POST",e,t),r()})})},turnOn(){return new Promise(r=>{chatgpt.getAccessToken().then(async e=>{var t=await this.fetchData();return t.enabled=!0,await this.sendRequest("POST",e,t),r()})})},toggle(){return new Promise(t=>{this.fetchData().then(async e=>(await(e.enabled?this.turnOff():this.turnOn()),t()))})}},isDarkMode(){return document.documentElement.classList.toString().includes("dark")},isFullScreen(){return chatgpt.browser.isFullScreen()},async isIdle(t=null){let e={childList:!0,subtree:!0},o="div[data-message-author-role]";var r=t?new Promise(e=>setTimeout(()=>e(!1),t)):null,a=(async()=>(await new Promise(r=>{document.querySelector(o)?r():new MutationObserver((e,t)=>{document.querySelector(o)&&(t.disconnect(),r())}).observe(document.body,e)}),await new Promise(r=>{new MutationObserver((e,t)=>{chatgpt.getStopBtn()&&(t.disconnect(),r())}).observe(document.body,e)}),new Promise(r=>{new MutationObserver((e,t)=>{chatgpt.getStopBtn()||(t.disconnect(),r(!0))}).observe(document.body,e)})))();return r?Promise.race([a,r]):a},async isLoaded(t=null){var e=t?new Promise(e=>setTimeout(()=>e(!1),t)):null,r=new Promise(r=>{chatgpt.getNewChatBtn()?r(!0):new MutationObserver((e,t)=>{chatgpt.getNewChatBtn()&&(t.disconnect(),r(!0))}).observe(document.body,{childList:!0,subtree:!0})});return e?Promise.race([r,e]):r},isLightMode(){return document.documentElement.classList.toString().includes("light")},logout(){window.location.href="https://chat.openai.com/auth/logout"},menu:{elements:[],addedEvent:!1,append(e,t={}){var r=["button","dropdown"];if(!e||"string"!=typeof e)return console.error("🤖 chatgpt.js >> Please supply a valid string element name!");if(e=e.toLowerCase(),!r.includes(e))return console.error(`🤖 chatgpt.js >> Invalid element! Valid elements are [${r}]`);let o=document.createElement("dropdown"==e?"select":"button"==e?"a":e);if(o.id=Math.floor(1e6*chatgpt.randomFloat())+Date.now(),"button"==e){o.textContent=t?.label&&"string"==typeof t.label?t.label:"chatgpt.js button";r=document.createElement("img");r.src=t?.icon&&"string"==typeof t.icon?t.icon:chatgpt.endpoints.assets+"/starters/chrome/extension/icons/icon128.png",r.width=18,o.insertBefore(r,o.firstChild),o.onclick=t?.onclick&&"function"==typeof t.onclick?t.onclick:function(){}}else if("dropdown"==e){if(t?.items&&Array.isArray(t.items)&&t.items.length||(t.items=[{text:"🤖 chatgpt.js option",value:"chatgpt.js option value"}]),!t.items.every(e=>"object"==typeof e))return console.error("'items' must be an array of objects!");o.style="background-color: #000; width: 100%; border: none;",t.items.forEach(e=>{var t=document.createElement("option");t.textContent=e?.text,t.value=e?.value,o.add(t)})}let a=()=>{var e,t=document.querySelectorAll('a[role="menuitem"]');let r;for(e of t)if("Settings"==e.textContent){r=e.classList;break}let o=t[0].parentNode;chatgpt.menu.elements.forEach(e=>{if(e.setAttribute("class",r),!o.contains(e))try{o.insertBefore(e,o.firstChild)}catch(e){console.error(e)}})};this.elements.push(o);r=document.querySelector('nav button[id*="headless"]');return this.addedEvent||(r?.addEventListener("click",()=>{setTimeout(a,25)}),this.addedEvent=!0),o.id},close(){try{document.querySelector('nav [id*="menu-button"][aria-expanded="true"]').click()}catch(e){console.error(e.message)}},open(){try{document.querySelector('nav [id*="menu-button"][aria-expanded="false"]').click()}catch(e){console.error(e.message)}}},minify(){chatgpt.code.minify()},notify(e,t,r,o){r=r?+r:1.75;let a=document.createElement("div");a.id=Math.floor(1e6*chatgpt.randomFloat())+Date.now(),a.classList.add("chatgpt-notif"),a.innerText=e,document.body.append(a);var e=document.createElement("div"),n=(e.title="Dismiss",e.classList.add("notif-close-btn","no-mobile-tap-outline"),document.createElementNS("http://www.w3.org/2000/svg","svg")),s=(n.setAttribute("height","8px"),n.setAttribute("viewBox","0 0 14 14"),n.setAttribute("fill","none"),n.style.height=n.style.width="8px",document.createElementNS("http://www.w3.org/2000/svg","path"));s.setAttribute("fill-rule","evenodd"),s.setAttribute("clip-rule","evenodd"),s.setAttribute("fill","white"),s.setAttribute("d","M13.7071 1.70711C14.0976 1.31658 14.0976 0.683417 13.7071 0.292893C13.3166 -0.0976312 12.6834 -0.0976312 12.2929 0.292893L7 5.58579L1.70711 0.292893C1.31658 -0.0976312 0.683417 -0.0976312 0.292893 0.292893C-0.0976312 0.683417 -0.0976312 1.31658 0.292893 1.70711L5.58579 7L0.292893 12.2929C-0.0976312 12.6834 -0.0976312 13.3166 0.292893 13.7071C0.683417 14.0976 1.31658 14.0976 1.70711 13.7071L7 8.41421L12.2929 13.7071C12.6834 14.0976 13.3166 14.0976 13.7071 13.7071C14.0976 13.3166 14.0976 12.6834 13.7071 12.2929L8.41421 7L13.7071 1.70711Z"),n.append(s),e.append(n),a.append(e),a.isTop=!t||!/low|bottom/i.test(t),a.isRight=!t||!/left/i.test(t),a.quadrant=(a.isTop?"top":"bottom")+(a.isRight?"Right":"Left");let i=document.querySelector("#chatgpt-notif-style"),c=((!i||parseInt(i.getAttribute("last-updated"),10)<20231110)&&(i||((i=document.createElement("style")).id="chatgpt-notif-style",i.setAttribute("last-updated",20231110..toString()),document.head.append(i)),i.innerText=".chatgpt-notif {.no-mobile-tap-outline { outline: none ; -webkit-tap-highlight-color: transparent }background-color: black ; padding: 10px 13px 10px 18px ; border-radius: 11px ; border: 1px solid #f5f5f7 ;opacity: 0 ; position: fixed ; z-index: 9999 ; font-size: 1.8rem ; color: white ;-webkit-user-select: none ; -moz-user-select: none ; -ms-user-select: none ; user-select: none ;"+`transform: translateX(${a.isRight?"":"-"}35px) ;`+(o?"box-shadow: -8px 13px 25px 0 "+(/\b(shadow|on)\b/gi.test(o)?"gray":o):"")+"}.notif-close-btn { cursor: pointer ; float: right ; position: relative ; right: -4px ; margin-left: -3px ;display: grid }@keyframes notif-zoom-fade-out { 0% { opacity: 1 ; transform: scale(1) }15% { opacity: 0.35 ; transform: rotateX(-27deg) scale(1.05) }45% { opacity: 0.05 ; transform: rotateX(-81deg) }100% { opacity: 0 ; transform: rotateX(-180deg) scale(1.15) }}"),JSON.parse(localStorage.notifyProps));c.queue[a.quadrant].push(a.id),localStorage.notifyProps=JSON.stringify(c),a.style.top=a.isTop?23..toString()+"px":"",a.style.bottom=a.isTop?"":23..toString()+"px",a.style.right=a.isRight?27..toString()+"px":"",a.style.left=a.isRight?"":27..toString()+"px";s=c.queue[a.quadrant];if(1<s.length)try{for(var l of s.slice(0,-1)){var d=document.getElementById(l),g=d.style.top?"top":"bottom",u=+/\d+/.exec(d.style[g])[0]+5+d.getBoundingClientRect().height;d.style[g]=u+"px"}}catch(e){}setTimeout(()=>{a.style.opacity=chatgpt.isDarkMode()?.8:.67,a.style.transform="translateX(0)",a.style.transition="transform 0.15s ease, opacity 0.15s ease"},10);e=()=>{a.style.animation="notif-zoom-fade-out 0.35s ease-out",clearTimeout(p)};let p=setTimeout(e,1e3*(r<.35?0:r-.35));return n.onclick=e,a.onanimationend=()=>{a.remove(),(c=JSON.parse(localStorage.notifyProps)).queue[a.quadrant].shift(),localStorage.notifyProps=JSON.stringify(c)},a},obfuscate(){chatgpt.code.obfuscate()},printAllFunctions(){let r={cmdPrompt:["#ff00ff","#00ff00"],objName:["#0611e9","#f9ee16"],methodName:["#005aff","#ffa500"],entryType:["#467e06","#b981f9"],srcMethod:["#ff0000","#00ffff"]};Object.keys(r).forEach(e=>{r[e][1]=r[e][1]||"#"+(16777215^Number("0x1"+r[e][0].replace(/^#/,""))).toString(16).substring(1).toUpperCase()});var e=[];for(let t in this)if("function"==typeof this[t]){var o=!Object.keys(this).find(e=>Object.keys(this[e]).includes(this[t].name));e.push([o?"chatgpt":"other",t])}else if("object"==typeof this[t])for(var a in this[t])"function"==typeof this[t][a]&&e.push([t,a]);e.sort((e,t)=>e[0].localeCompare(t[0])||e[1].localeCompare(t[1]));var n=window.matchMedia("(prefers-color-scheme: dark)").matches,s="font-family: monospace ; font-size: larger ; ";console.log("\n%c🤖 chatgpt.js methods\n","font-family: sans-serif ; font-size: xxx-large ; font-weight: bold");for(let t of e){var i=/chatgpt|other/.test(t[0]),c="chatgpt"==t[0]?this[t[1]].name:"other"!==t[0]?t[0]+"."+t[1]:Object.keys(this).find(e=>Object.keys(this[e]).includes(this[t[1]].name))+"."+this[t[1]].name,l="AsyncFunction"==this[t[1]]?.constructor.name;console.log("%c>> %c"+(i?"":t[0]+".%c")+t[1]+" - https://chatgptjs.org/userguide/"+/(?:.*\.)?(.*)/.exec(c)[1].toLowerCase()+(l?"-async":"")+"\n%c[%c"+("chatgpt"==t[0]&&t[1]==this[t[1]].name||!i?"Function":"Alias of")+"%c: %c"+c+"%c]",s+"font-weight: bold ; color:"+r.cmdPrompt[+n],s+"font-weight: bold ;color:"+r[i?"methodName":"objName"][+n],s+"font-weight: "+(i?"initial":"bold")+";color:"+(i?"initial":r.methodName[+n]),s+"font-weight: "+(i?"bold":"initial")+";color:"+(i?r.entryType[+n]:"initial"),s+"font-weight: "+(i?"initial":"bold")+";color:"+(i?"initial":r.entryType[+n]),s+(i?"font-style: italic":"font-weight: initial")+";color:"+(i?r.srcMethod[+n]:"initial"),s+(i?"font-weight: initial":"font-style: italic")+";color:"+(i?"initial":r.srcMethod[+n]),i?"":s+"color: initial ; font-weight: initial")}},randomFloat(){return(window.crypto||window.msCrypto)?.getRandomValues(new Uint32Array(1))[0]/4294967295||Math.random()},refactor(){chatgpt.code.refactor()},regenerate(){chatgpt.response.regenerate()},renderHTML(s){var i,e=/<([a-z\d]+)\b([^>]*)>([\s\S]*?)<\/\1>/g,c=/(\S+)=['"]?((?:.(?!['"]?\s+\S+=|[>']))+.)['"]?/g,t=s.childNodes;chatgpt.renderHTML.preWrapSet||(s.style.whiteSpace="pre-wrap",chatgpt.renderHTML.preWrapSet=!0,setTimeout(()=>{chatgpt.renderHTML.preWrapSet=!1},100));for(i of t)if(i.nodeType==Node.TEXT_NODE){var l=i.nodeValue,d=Array.from(l.matchAll(e));if(0<d.length){let e=d[0],[t,r,o,a]=e.slice(0,4),n=document.createElement(r);n.textContent=a;Array.from(o.matchAll(c)).forEach(e=>{var t=e[1],e=e[2].replace(/['"]/g,"");n.setAttribute(t,e)});var d=chatgpt.renderHTML(n),g=document.createTextNode(l.substring(0,e.index)),l=document.createTextNode(l.substring(e.index+t.length));s.replaceChild(g,i),s.insertBefore(d,g.nextSibling),s.insertBefore(l,d.nextSibling)}}else i.nodeType==Node.ELEMENT_NODE&&chatgpt.renderHTML(i);return s},async resend(){chatgpt.send(await chatgpt.getChatData("latest","msg","user","latest"))},response:{continue(){try{chatgpt.getContinueBtn().click()}catch(e){console.error(e.message)}},get(){return(window.location.href.startsWith("https://chatgpt.com/c/")?this.getFromDOM:this.getFromAPI).apply(null,arguments)},getFromAPI(e,t){return e=e||"latest",t=t||"latest",chatgpt.getChatData(e,"msg","chatgpt",t)},getFromDOM(e){var t=document.querySelectorAll('div[data-message-author-role="assistant"]'),r=e.toString().toLowerCase();let o="";return t.length?o=(o=(/last|final/.test(r)?t[t.length-1]:t[(Number.isInteger(e)?e:/^\d+/.test(r)?/^\d+/.exec(r)[0]:(/^(?:1|one|fir)(?:st)?$/.test(r)?1:/^(?:2|tw(?:o|en|el(?:ve|f))|seco)(?:nd|t[yi])?(?:e?th)?$/.test(r)?2:/^(?:3|th(?:ree|ir?))(?:rd|teen|t[yi])?(?:e?th)?$/.test(r)?3:/^(?:4|fou?r)(?:teen|t[yi])?(?:e?th)?$/.test(r)?4:/^(?:5|fi(?:ve|f))(?:teen|t[yi])?(?:e?th)?$/.test(r)?5:/^(?:6|six)(?:teen|t[yi])?(?:e?th)?$/.test(r)?6:/^(?:7|seven)(?:teen|t[yi])?(?:e?th)?$/.test(r)?7:/^(?:8|eight?)(?:teen|t[yi])?(?:e?th)?$/.test(r)?8:/^(?:9|nine?)(?:teen|t[yi])?(?:e?th)?$/.test(r)?9:/^(?:10|ten)(?:th)?$/.test(r)?10:1)*(/(ty|ieth)$/.test(r)?10:1)+(/teen(th)?$/.test(r)?10:0))-1]).textContent).replace(/^ChatGPT(?:ChatGPT)?/,""):console.error("No conversation found!")},getLast(){return chatgpt.getChatData("active","msg","chatgpt","latest")},regenerate(){try{chatgpt.getRegenerateBtn().click()}catch(e){console.error(e.message)}},stopGenerating(){try{chatgpt.getStopBtn().click()}catch(e){console.error(e.message)}}},reviewCode(){chatgpt.code.review()},scrollToBottom(){try{chatgpt.getScrollBtn().click()}catch(e){console.error(e.message)}},send(e,r=""){for(let e=0;e<arguments.length;e++)if("string"!=typeof arguments[e])return console.error(`Argument ${e+1} must be a string!`);let o=chatgpt.getChatBox();if(!o)return console.error("Chatbar element not found!");var t=document.createElement("p");t.textContent=e,o.replaceChild(t,o.querySelector("p")),o.dispatchEvent(new Event("input",{bubbles:!0})),setTimeout(function e(){var t=chatgpt.getSendButton();t?.hasAttribute("disabled")?setTimeout(e,222):"click"==r.toLowerCase()||chatgpt.browser.isMobile()?t.click():o.dispatchEvent(new KeyboardEvent("keydown",{key:"Enter",bubbles:!0}))},222)},sendInNewChat(e){if("string"!=typeof e)return console.error("Message must be a string!");try{chatgpt.getNewChatBtn().click()}catch(e){return console.error(e.message)}setTimeout(()=>{chatgpt.send(e)},500)},settings:{scheme:{isDark(){return document.documentElement.classList.contains("dark")},isLight(){return document.documentElement.classList.contains("light")},set(e){var t=["dark","light","system"];if(!e)return console.error("Please specify a scheme value!");if(!t.includes(e))return console.error(`Invalid scheme value. Valid values are [${t}]`);let r=e;"system"==e&&(r=window.matchMedia("(prefers-color-scheme: dark)").matches?"dark":"light"),localStorage.setItem("theme",e),console.info(`Scheme set to ${e.toUpperCase()}.`),document.documentElement.classList.contains(r)||this.toggle()},toggle(){var[e,t]=this.isDark()?["dark","light"]:["light","dark"];document.documentElement.classList.replace(e,t),document.documentElement.style.colorScheme=t,localStorage.setItem("theme",t)}}},async sentiment(e,t){for(let e=0;e<arguments.length;e++)if("string"!=typeof arguments[e])return console.error(`Argument ${e+1} must be a string.`);return chatgpt.send("What is the sentiment of the following text"+(t?` towards the entity ${t},`:"")+" from strongly negative to strongly positive?\n\n"+e),console.info("Analyzing sentiment..."),await chatgpt.isIdle(),chatgpt.getChatData("active","msg","chatgpt","latest")},setScheme(e){chatgpt.settings.scheme.set(e)},shareChat(s,i="clipboard"){var e=["alert","notify","notification","clipboard","copy"];if(!e.includes(i))return console.error("Invalid method '"+i+"' passed. Valid methods are ["+e+"].");return new Promise(r=>{chatgpt.getAccessToken().then(t=>{var a;a=t,new Promise((t,r)=>{let o=new XMLHttpRequest;chatgpt.getChatData(s).then(e=>{o.open("GET",chatgpt.endpoints.openAI.chat+"/"+e.id,!0),o.setRequestHeader("Content-Type","application/json"),o.setRequestHeader("Authorization","Bearer "+a),o.onload=()=>200!==o.status?r("🤖 chatgpt.js >> Request failed. Cannot retrieve chat node."):t(JSON.parse(o.responseText).current_node),o.send()})}).then(e=>{var a,n;a=t,n=e,new Promise((t,r)=>{let o=new XMLHttpRequest;chatgpt.getChatData(s).then(e=>{o.open("POST",chatgpt.endpoints.openAI.share_create,!0),o.setRequestHeader("Content-Type","application/json"),o.setRequestHeader("Authorization","Bearer "+a),o.onload=()=>200!==o.status?r("🤖 chatgpt.js >> Request failed. Cannot initialize share chat."):t(JSON.parse(o.responseText)),o.send(JSON.stringify({current_node_id:n,conversation_id:e.id,is_anonymous:!0}))})}).then(e=>{var o,a;o=t,a=e,new Promise((e,t)=>{let r=new XMLHttpRequest;r.open("PATCH",chatgpt.endpoints.openAI.share+"/"+a.share_id,!0),r.setRequestHeader("Content-Type","application/json"),r.setRequestHeader("Authorization","Bearer "+o),r.onload=()=>200!==r.status?t("🤖 chatgpt.js >> Request failed. Cannot share chat."):(console.info(`Chat shared at '${a.share_url}'`),e()),r.send(JSON.stringify({share_id:a.share_id,highlighted_message_id:a.highlighted_message_id,title:a.title,is_public:!0,is_visible:a.is_visible,is_anonymous:a.is_anonymous}))}).then(()=>{["copy","clipboard"].includes(i)?navigator.clipboard.writeText(e.share_url):chatgpt.alert("🚀 Share link created!",'"'+e.title+'" is available at: <a target="blank" rel="noopener" href="'+e.share_url+'" >'+e.share_url+"</a>",[function(){window.open(e.share_url,"_blank","noopener")},function(){navigator.clipboard.writeText(e.share_url)}]),r(e.share_url)})})})})})},showFooter(){chatgpt.footer.show()},showHeader(){chatgpt.header.show()},sidebar:{elements:[],observer:{},activateObserver(){if(this.observer instanceof MutationObserver)try{this.observer.disconnect()}catch(e){}if(!this.elements.length)return console.error("🤖 chatgpt.js >> No elements to append!");let t;for(var e of document.querySelectorAll("nav a"))if(/.*chat/.exec(e.text)[0]){t=e.classList,e.parentNode.style.margin="2px 0";break}this.elements.forEach(e=>{e.setAttribute("class",t),e.style.maxHeight=e.style.minHeight="44px",e.style.margin="2px 0"});let r=document.querySelector("nav");if(!r)return console.error("Sidebar element not found!");this.observer=new MutationObserver(e=>{e.forEach(e=>{("childList"==e.type&&e.addedNodes.length||"attributes"==e.type&&"data-chatgptjs"==e.attributeName)&&this.elements.forEach(e=>{if(!r.contains(e))try{r.insertBefore(e,r.querySelector("a").parentNode)}catch(e){console.error(e)}})})}),this.observer.observe(document.documentElement,{childList:!0,subtree:!0,attributes:!0})},append(e,t={}){var r=["button","dropdown"];if(!e||"string"!=typeof e)return console.error("🤖 chatgpt.js >> Please supply a valid string element name!");if(e=e.toLowerCase(),!r.includes(e))return console.error(`🤖 chatgpt.js >> Invalid element! Valid elements are [${r}]`);let o=document.createElement("dropdown"==e?"select":e);if(o.id=Math.floor(1e6*chatgpt.randomFloat())+Date.now(),"button"==e){o.textContent=t?.label&&"string"==typeof t.label?t.label:"chatgpt.js button";r=document.createElement("img");r.src=t?.icon&&"string"==typeof t.icon?t.icon:chatgpt.endpoints.assets+"/starters/chrome/extension/icons/icon128.png",r.width=18,o.insertBefore(r,o.firstChild),o.onclick=t?.onclick&&"function"==typeof t.onclick?t.onclick:function(){}}else if("dropdown"==e){if(t?.items&&Array.isArray(t.items)&&t.items.length||(t.items=[{text:"🤖 chatgpt.js option",value:"chatgpt.js option value"}]),!t.items.every(e=>"object"==typeof e))return console.error("'items' must be an array of objects!");t.items.forEach(e=>{var t=document.createElement("option");t.textContent=e?.text,t.value=e?.value,o.add(t)})}return"dropdown"==e&&(o.style.backgroundColor="var(--gray-900, rgb(32, 33, 35))"),this.elements.push(o),this.activateObserver(),document.body.setAttribute("data-chatgptjs","observer-trigger"),o.id},exists(){return!!chatgpt.getNewChatLink()},hide(){this.isOn()?this.toggle():console.info("Sidebar already hidden!")},show(){this.isOff()?this.toggle():console.info("Sidebar already shown!")},isOff(){return!this.isOn()},isOn(){var e=chatgpt.sidebar.exists()?document.querySelector('[class*="sidebar"]'):null;return e?chatgpt.browser.isMobile()?"hidden"==document.documentElement.style.overflow:"hidden"!=e.style.visibility&&"0px"!=e.style.width:(console.error("Sidebar element not found!"),!1)},toggle(){var e=document.querySelector('button[data-testid*="sidebar-button"]');e||console.error("Sidebar toggle not found!"),e.click()},async isLoaded(t=5e3){await chatgpt.isLoaded();var e=new Promise(e=>setTimeout(()=>{e(!1)},t)),r=new Promise(r=>{chatgpt.getNewChatLink()?r(!0):new MutationObserver((e,t)=>{chatgpt.getNewChatLink()&&(t.disconnect(),r(!0))}).observe(document.body,{childList:!0,subtree:!0})});return Promise.race([r,e])}},startNewChat(){try{chatgpt.getNewChatBtn().click()}catch(e){console.error(e.message)}},stop(){chatgpt.response.stopGenerating()},async suggest(e,t){if(!e)return console.error("ideaType (1st argument) not supplied(e.g. 'gifts', 'names', 'recipes', etc.)");for(let e=0;e<arguments.length;e++)if("string"!=typeof arguments[e])return console.error(`Argument ${e+1} must be a string.`);return chatgpt.send("Suggest some names. "+(t||"")),console.info(`Creating ${e}...`),await chatgpt.isIdle(),chatgpt.getChatData("active","msg","chatgpt","latest")},speak(e,t={}){var r,{voice:o=2,pitch:a=2,speed:n=1.1}=t;if("string"!=typeof e)return console.error("Message must be a string!");for(r in t){var s=t[r];if("number"!=typeof s&&!/^\d+$/.test(s))return console.error(`Invalid ${r} index '${s}'. Must be a number!`)}try{var i=speechSynthesis.getVoices(),c=new SpeechSynthesisUtterance;c.text=e,c.voice=i[o],c.pitch=a,c.rate=n,speechSynthesis.speak(c)}catch(e){console.error(e)}},async summarize(e){return e?"string"!=typeof e?console.error("Text argument must be a string!"):(chatgpt.send("Summarize the following text:\n\n"+e),console.info("Summarizing text..."),await chatgpt.isIdle(),chatgpt.getChatData("active","msg","chatgpt","latest")):console.error("Text (1st) argument not supplied. Pass some text!")},toggleScheme(){chatgpt.settings.scheme.toggle()},async translate(e,t){if(!e)return console.error("Text (1st) argument not supplied. Pass some text!");if(!t)return console.error("outputLang (2nd) argument not supplied. Pass a language!");for(let e=0;e<arguments.length;e++)if("string"!=typeof arguments[e])return console.error(`Argument ${e+1} must be a string!`);return chatgpt.send("Translate the following text to "+t+". Only reply with the translation.\n\n"+e),console.info("Translating text..."),await chatgpt.isIdle(),chatgpt.getChatData("active","msg","chatgpt","latest")},unminify(){chatgpt.code.unminify()},uuidv4(){let r=(new Date).getTime();return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,e=>{var t=(r+window.crypto.getRandomValues(new Uint32Array(1))[0]/(Math.pow(2,32)-1)*16)%16|0;return r=Math.floor(r/16),("x"==e?t:3&t|8).toString(16)})},writeCode(){chatgpt.code.write()}},cjsBtnActions=(chatgpt.scheme={...chatgpt.settings.scheme},["click","get"]),cjsTargetTypes=["button","link","div","response"];for(let t of cjsBtnActions)chatgpt[t+"Button"]=function(r){var e=/^[.#]/.test(r)?document.querySelector(r):/send/i.test(r)?document.querySelector('form button[class*="bottom"]'):/scroll/i.test(r)?document.querySelector('button[class*="cursor"]'):(()=>{for(var e of document.querySelectorAll("button"))if(e.textContent.toLowerCase().includes(r.toLowerCase()))return e;for(var t of document.querySelectorAll("nav a"))if(t.textContent.toLowerCase().includes(r.toLowerCase()))return t})();if("click"!=t)return e;e.click()};let cjsFuncAliases=[["actAs","actas","act","become","persona","premadePrompt","preMadePrompt","prePrompt","preprompt","roleplay","rolePlay","rp"],["activateAutoRefresh","activateAutoRefresher","activateRefresher","activateSessionRefresher","autoRefresh","autoRefresher","autoRefreshSession","refresher","sessionRefresher"],["continue","continueChat","continueGenerating","continueResponse"],["deactivateAutoRefresh","deactivateAutoRefresher","deactivateRefresher","deactivateSessionRefresher"],["detectLanguage","getLanguage"],["executeCode","codeExecute"],["exists","isAvailable","isExistent","isPresent"],["exportChat","chatExport","export"],["getFooterDiv","getFooter"],["getHeaderDiv","getHeader"],["getLastPrompt","getLastQuery","getMyLastMsg","getMyLastQuery"],["getContinueButton","getContinueGeneratingButton"],["getScrollToBottomButton","getScrollButton"],["getStopButton","getStopGeneratingButton"],["getTextarea","getTextArea","getChatbar","getChatBar","getChatbox","getChatBox"],["isFullScreen","isFullscreen","isfullscreen"],["isLoaded","isloaded"],["logOut","logout","logOff","logoff","signOut","signout","signOff","signoff"],["minify","codeMinify","minifyCode"],["new","newChat","startNewChat"],["obfuscate","codeObfuscate","obfuscateCode"],["printAllFunctions","showAllFunctions"],["refactor","codeRefactor","refactorCode"],["refreshReply","regenerate","regenerateReply"],["refreshSession","sessionRefresh"],["renderHTML","renderHtml","renderLinks","renderTags"],["reviewCode","codeReview"],["send","sendChat","sendMsg"],["sendInNewChat","sendNewChat"],["sentiment","analyzeSentiment","sentimentAnalysis"],["startNewChat","new","newChat"],["stop","stopChat","stopGenerating","stopResponse"],["suggest","suggestion","recommend"],["toggleAutoRefresh","toggleAutoRefresher","toggleRefresher","toggleSessionRefresher"],["toggleScheme","toggleMode"],["translate","translation","translator"],["unminify","unminifyCode","codeUnminify"],["writeCode","codeWrite"]],cjsFuncSynonyms=[["account","acct"],["activate","turnOn"],["analyze","check","evaluate","review"],["ask","send","submit"],["button","btn"],["continue","resume"],["chats","history"],["chat","conversation","convo"],["clear","delete","remove"],["data","details"],["deactivate","deActivate","turnOff"],["execute","interpret","interpreter","run"],["firefox","ff"],["generating","generation"],["minify","uglify"],["refactor","rewrite"],["regenerate","regen"],["render","parse"],["reply","response"],["sentiment","attitude","emotion","feeling","opinion","perception"],["speak","say","speech","talk","tts"],["summarize","tldr"],["unminify","beautify","prettify","prettyPrint"]],camelCaser=e=>e.map((e,t)=>0===t||"s"==e?e:e.charAt(0).toUpperCase()+e.slice(1)).join("");for(let o in chatgpt){for(let r of cjsFuncAliases)if(r.includes(o))if(r.some(e=>e.includes("."))){let t=r.find(e=>e.includes(".")).split(".")[1];for(let e of r)/^(\w+)/.exec(e)[1]!==o&&(chatgpt[e]=chatgpt[o][t])}else for(let e of r)e!==o&&(chatgpt[e]=chatgpt[o]);do{var newFunctionsCreated=!1;for(let a in chatgpt)if("function"==typeof chatgpt[a]){let o=a.split(/(?=[A-Zs])/);for(let r of o){let e=[].concat(...cjsFuncSynonyms.filter(e=>e.includes(r.toLowerCase())).map(e=>e.filter(e=>e!==r.toLowerCase())));for(let t of e){let e=camelCaser(o.map(e=>e==r?t:e));chatgpt[e]||(chatgpt[e]=chatgpt[a],newFunctionsCreated=!0)}}}}while(newFunctionsCreated)}let consolePrefix="🤖 chatgpt.js >> ",ogError=console.error,ogInfo=console.info;console.error=(...e)=>{e[0].startsWith(consolePrefix)?ogError(...e):ogError(consolePrefix+e[0],...e.slice(1))},console.info=e=>{e.startsWith(consolePrefix)?ogInfo(e):ogInfo(consolePrefix+e)};try{window.chatgpt=chatgpt}catch(e){}try{module.exports=chatgpt}catch(e){}