const functionAliases=[["actAs","actas","act","become","persona","premadePrompt","preMadePrompt","prePrompt","preprompt","roleplay","rolePlay","rp"],["activateAutoRefresh","activateAutoRefresher","activateRefresher","activateSessionRefresher","autoRefresh","autoRefresher","autoRefreshSession","refresher","sessionRefresher"],["deactivateAutoRefresh","deactivateAutoRefresher","deactivateRefresher","deactivateSessionRefresher"],["detectLanguage","getLanguage"],["executeCode","codeExecute"],["exportChat","chatExport","export"],["getLastPrompt","getLastQuery","getMyLastMsg","getMyLastQuery"],["getTextarea","getTextArea","getChatbox","getChatBox"],["isFullScreen","isFullscreen"],["logOut","logout","logOff","logoff","signOut","signout","signOff","signoff"],["minify","codeMinify","minifyCode"],["new","newChat","startNewChat"],["obfuscate","codeObfuscate","obfuscateCode"],["printAllFunctions","showAllFunctions"],["refactor","codeRefactor","refactorCode"],["refreshReply","regenerate","regenerateReply"],["refreshSession","sessionRefresh"],["renderHTML","renderHtml","renderLinks","renderTags"],["reviewCode","codeReview"],["send","sendChat","sendMsg"],["sendInNewChat","sendNewChat"],["sentiment","analyzeSentiment","sentimentAnalysis"],["stop","stopGenerating"],["suggest","suggestion","recommend"],["toggleAutoRefresh","toggleAutoRefresher","toggleRefresher","toggleSessionRefresher"],["toggleScheme","toggleMode"],["translate","translation","translator"],["unminify","unminifyCode","codeUnminify"],["writeCode","codeWrite"]];const synonyms=[["account","acct"],["activate","turnOn"],["analyze","check","evaluate","review"],["ask","send","submit"],["chat","conversation","convo"],["data","details"],["deactivate","deActivate","turnOff"],["execute","interpret","interpreter","run"],["generating","generation"],["minify","uglify"],["refactor","rewrite"],["regenerate","regen"],["render","parse"],["reply","response"],["sentiment","attitude","emotion","feeling","opinion","perception"],["speak","say","speech","talk","tts"],["summarize","tldr"],["unminify","beautify","prettify","prettyPrint"]];const endpoints={assets:"https://raw.githubusercontent.com/KudoAI/chatgpt.js/main",openAI:{session:"https://chat.openai.com/api/auth/session",chats:"https://chat.openai.com/backend-api/conversations",chat:"https://chat.openai.com/backend-api/conversation",share_create:"https://chat.openai.com/backend-api/share/create",share:"https://chat.openai.com/backend-api/share",instructions:"https://chat.openai.com/backend-api/user_system_messages"}};localStorage.alertQueue=JSON.stringify([]);localStorage.notifyProps=JSON.stringify({queue:{topRight:[],bottomRight:[],bottomLeft:[],topLeft:[]},lastNthAudio:0});const isChromeUserScript=navigator.userAgent.includes("Chrome")&&typeof unsafeWindow!="undefined",isFFuserScript=navigator.userAgent.includes("Firefox")&&typeof unsafeWindow!="undefined",isFFtmScript=isFFuserScript&&GM_info.scriptHandler=="Tampermonkey";let cjsMessages;if(!isChromeUserScript&&!(isFFuserScript&&!isFFtmScript)){(async()=>{const cjsMsgsLoaded=new Promise(resolve=>{const userLanguage=navigator.languages[0]||navigator.language||navigator.browserLanguage||navigator.systemLanguage||navigator.userLanguage||"",msgHostDir=endpoints.assets+"/data/_locales/",msgLocaleDir=(userLanguage?userLanguage.replace("-","_"):"en")+"/";let msgHref=msgHostDir+msgLocaleDir+"messages.json",msgXHRtries=0;(function loadMsgs(){const xhr=new XMLHttpRequest;xhr.open("GET",msgHref);xhr.send();xhr.onload=()=>{try{const messages=new Proxy(JSON.parse(xhr.responseText),{get(target,prop){if(typeof target[prop]=="object"&&target[prop]!==null&&"message"in target[prop]){return target[prop].message}}});resolve(messages)}catch(err){msgXHRtries++;if(msgXHRtries===3)resolve({});msgHref=userLanguage.includes("-")&&msgXHRtries===1?msgHref.replace(/(.*)_.*(\/.*)/,"$1$2"):msgHostDir+"en/messages.json";loadMsgs()}};xhr.onerror=()=>{resolve({})}})()});cjsMessages=await cjsMsgsLoaded})()}const chatgpt={openAIaccessToken:{},actAs:function(persona){const promptsUrl="https://raw.githubusercontent.com/KudoAI/chat-prompts/main/dist/personas.min.json";return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;xhr.open("GET",promptsUrl,true);xhr.send();xhr.onload=()=>{if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot retrieve prompts data.");const data=JSON.parse(xhr.responseText).personas;if(!persona){console.log("\n%c🤖 chatgpt.js personas\n","font-family: sans-serif ; font-size: xxx-large ; font-weight: bold");for(const prompt of data)console.log(`%c${prompt.title}`,"font-family: monospace ; font-size: larger ;");return resolve()}const selectedPrompt=data.find(obj=>obj.title.toLowerCase()==persona.toLowerCase());if(!selectedPrompt)return reject(`🤖 chatgpt.js >> Persona '${persona}' was not found!`);chatgpt.send(selectedPrompt.prompt,"click");console.info(`Loading ${persona} persona...`);chatgpt.isIdle().then(()=>{console.info("Persona activated!")});return resolve()}})},activateDarkMode:function(){document.documentElement.classList.replace("light","dark");document.documentElement.style.colorScheme="dark";localStorage.setItem("theme","dark")},activateLightMode:function(){document.documentElement.classList.replace("dark","light");document.documentElement.style.colorScheme="light";localStorage.setItem("theme","light")},alert:function(title,msg,btns,checkbox,width){const scheme=chatgpt.isDarkMode()?"dark":"light";const modalContainer=document.createElement("div");modalContainer.id=Math.floor(chatgpt.randomFloat()*1e6)+Date.now();modalContainer.classList.add("chatgpt-modal");const modal=document.createElement("div"),modalTitle=document.createElement("h2"),modalMessage=document.createElement("p");const thisUpdated=20231110;let modalStyle=document.querySelector("#chatgpt-modal-style");if(!modalStyle||parseInt(modalStyle.getAttribute("last-updated"),10)<thisUpdated){if(!modalStyle){modalStyle=document.createElement("style");modalStyle.id="chatgpt-modal-style";modalStyle.setAttribute("last-updated",thisUpdated.toString());document.head.appendChild(modalStyle)}modalStyle.innerText=".chatgpt-modal {"+"position: fixed ; top: 0 ; left: 0 ; width: 100% ; height: 100% ;"+"background-color: rgba(67, 70, 72, 0) ;"+"transition: background-color 0.05s ease ;"+"display: flex ; justify-content: center ; align-items: center ; z-index: 9999 }"+".chatgpt-modal > div {"+"opacity: 0 ; transform: translateX(-2px) translateY(5px) ;"+"transition: opacity 0.1s cubic-bezier(.165,.84,.44,1), transform 0.2s cubic-bezier(.165,.84,.44,1) ;"+`background-color: ${scheme=="dark"?"black":"white"} ;`+(scheme!="dark"?"border: 1px solid rgba(0, 0, 0, 0.3) ;":"")+"padding: 20px ; margin: 12px 23px ; border-radius: 15px ; box-shadow: 0 30px 60px rgba(0,0,0,.12) ;"+" -webkit-user-select: none ; -moz-user-select: none ; -ms-user-select: none ; user-select: none ; }"+".chatgpt-modal h2 { margin-bottom: 9px }"+`.chatgpt-modal a { color: ${scheme=="dark"?"#00cfff":"#1e9ebb"}}`+".chatgpt-modal.animated > div { opacity: 1 ; transform: translateX(0) translateY(0) }"+"@keyframes alert-zoom-fade-out { 0% { opacity: 1 ; transform: scale(1) }"+"50% { opacity: 0.25 ; transform: scale(1.35) }"+"100% { opacity: 0 ; transform: scale(2) }}"+".modal-buttons { display: flex ; justify-content: flex-end ; margin: 20px -5px -3px 0 }"+".chatgpt-modal button {"+"margin-left: 10px ; padding: 4px 18px ; border-radius: 15px ;"+`border: 1px solid ${scheme=="dark"?"white":"black"}}`+".primary-modal-btn {"+`border: 1px solid ${scheme=="dark"?"white":"black"} ;`+`background: ${scheme=="dark"?"white":"black"} ;`+`color: ${scheme=="dark"?"black":"white"}}`+".chatgpt-modal button:hover { color: #3d5d71 ; border-color: #6d9cb9 ;"+"background-color: "+(scheme=="dark"?"#00cfff":"#9cdaff")+";"+"box-shadow: 2px 1px "+(scheme=="dark"?"54px #00cfff":"30px #9cdaff")+"}"+".modal-close-btn {"+"cursor: pointer ; width: 20px ; height: 20px ; float: right ; position: relative ; right: -2px }"+".modal-close-btn svg { margin: 5px 5px }"+`.modal-close-btn:hover { background-color: #f2f2f2${scheme=="dark"?"00":""}}`+".chatgpt-modal .checkbox-group { display: flex ; margin-top: -18px }"+".chatgpt-modal .checkbox-group label {"+"font-size: .7rem ; margin: -.04rem 0 0px .3rem ;"+`color: ${scheme=="dark"?"#e1e1e1":"#1e1e1e"}}`+'.chatgpt-modal input[type="checkbox"] { transform: scale(0.7) ;'+`border: 1px solid ${scheme=="dark"?"white":"black"}}`+'.chatgpt-modal input[type="checkbox"]:checked {'+`border: 1px solid ${scheme=="dark"?"white":"black"} ;`+"background-color: black ; position: inherit }"+'.chatgpt-modal input[type="checkbox"]:focus { outline: none ; box-shadow: none }'}modalTitle.innerText=title||"";modalMessage.innerText=msg||"";this.renderHTML(modalMessage);const modalButtons=document.createElement("div");modalButtons.classList.add("modal-buttons");if(btns){if(!Array.isArray(btns))btns=[btns];btns.forEach(buttonFn=>{const button=document.createElement("button");button.textContent=buttonFn.name.replace(/[_-]\w/g,match=>match.slice(1).toUpperCase()).replace(/([A-Z])/g," $1").replace(/^\w/,firstChar=>firstChar.toUpperCase());button.addEventListener("click",()=>{dismissAlert();buttonFn()});modalButtons.insertBefore(button,modalButtons.firstChild)})}const dismissBtn=document.createElement("button");dismissBtn.textContent=btns?"Dismiss":"OK";modalButtons.insertBefore(dismissBtn,modalButtons.firstChild);modalButtons.lastChild.classList.add("primary-modal-btn");const checkboxDiv=document.createElement("div");if(checkbox){checkboxDiv.classList.add("checkbox-group");const checkboxFn=checkbox,checkboxInput=document.createElement("input");checkboxInput.type="checkbox";checkboxInput.addEventListener("change",checkboxFn);const checkboxLabel=document.createElement("label");checkboxLabel.addEventListener("click",()=>{checkboxInput.checked=!checkboxInput.checked;checkboxFn()});checkboxLabel.textContent=checkboxFn.name.charAt(0).toUpperCase()+checkboxFn.name.slice(1).replace(/([A-Z])/g,(match,letter)=>" "+letter.toLowerCase()).replace(/\b(\w+)nt\b/gi,"$1n't").trim();checkboxDiv.appendChild(checkboxInput);checkboxDiv.appendChild(checkboxLabel)}const closeBtn=document.createElement("div");closeBtn.title=cjsMessages?.tooltip_close||"Close";closeBtn.classList.add("modal-close-btn");const closeSVG=document.createElementNS("http://www.w3.org/2000/svg","svg");closeSVG.setAttribute("height","10px");closeSVG.setAttribute("viewBox","0 0 14 14");closeSVG.setAttribute("fill","none");const closeSVGpath=document.createElementNS("http://www.w3.org/2000/svg","path");closeSVGpath.setAttribute("fill-rule","evenodd");closeSVGpath.setAttribute("clip-rule","evenodd");closeSVGpath.setAttribute("fill",chatgpt.isDarkMode()?"white":"black");closeSVGpath.setAttribute("d","M13.7071 1.70711C14.0976 1.31658 14.0976 0.683417 13.7071 0.292893C13.3166 -0.0976312 12.6834 -0.0976312 12.2929 0.292893L7 5.58579L1.70711 0.292893C1.31658 -0.0976312 0.683417 -0.0976312 0.292893 0.292893C-0.0976312 0.683417 -0.0976312 1.31658 0.292893 1.70711L5.58579 7L0.292893 12.2929C-0.0976312 12.6834 -0.0976312 13.3166 0.292893 13.7071C0.683417 14.0976 1.31658 14.0976 1.70711 13.7071L7 8.41421L12.2929 13.7071C12.6834 14.0976 13.3166 14.0976 13.7071 13.7071C14.0976 13.3166 14.0976 12.6834 13.7071 12.2929L8.41421 7L13.7071 1.70711Z");closeSVG.appendChild(closeSVGpath);closeBtn.appendChild(closeSVG);const modalElems=[closeBtn,modalTitle,modalMessage,modalButtons,checkboxDiv];modalElems.forEach(elem=>{modal.appendChild(elem)});modal.style.width=`${width||458}px`;modalContainer.appendChild(modal);document.body.appendChild(modalContainer);let alertQueue=JSON.parse(localStorage.alertQueue);alertQueue.push(modalContainer.id);localStorage.alertQueue=JSON.stringify(alertQueue);modalContainer.style.display="none";if(alertQueue.length===1){modalContainer.style.display="";setTimeout(()=>{modalContainer.style.backgroundColor=`rgba(67, 70, 72, ${scheme==="dark"?.62:.18})`;modalContainer.classList.add("animated")},100)}const clickHandler=event=>{if(event.target==event.currentTarget||event.target instanceof SVGPathElement)dismissAlert()};const keyHandler=event=>{const dismissKeys=[13,27];if(dismissKeys.includes(event.keyCode)){for(const alertId of alertQueue){const alert=document.getElementById(alertId);if(alert&&alert.style.display!=="none"){if(event.keyCode===27)dismissAlert();else if(event.keyCode===13){const mainButton=alert.querySelector(".modal-buttons").lastChild;if(mainButton){mainButton.click();event.preventDefault()}}return}}}};const dismissElems=[modalContainer,closeBtn,closeSVG,dismissBtn];dismissElems.forEach(elem=>{elem.addEventListener("click",clickHandler)});document.addEventListener("keydown",keyHandler);const dismissAlert=()=>{modalContainer.style.backgroundColor="transparent";modal.style.animation="alert-zoom-fade-out 0.075s ease-out";setTimeout(()=>{modalContainer.remove();alertQueue=JSON.parse(localStorage.alertQueue);alertQueue.shift();localStorage.alertQueue=JSON.stringify(alertQueue);dismissElems.forEach(elem=>{elem.removeEventListener("click",clickHandler)});document.removeEventListener("keydown",keyHandler);if(alertQueue.length>0){const nextAlert=document.getElementById(alertQueue[0]);setTimeout(()=>{nextAlert.style.display="";setTimeout(()=>{nextAlert.classList.add("animated")},100)},500)}},50)};return modalContainer.id},askAndGetReply:async function(query){chatgpt.send(query);await chatgpt.isIdle();return chatgpt.getChatData("active","msg","chatgpt","latest")},autoRefresh:{activate:function(interval){if(this.isActive){console.log("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Auto refresh already active!");return}const autoRefresh=this;this.toggle.refreshFrame();const scheduleRefreshes=interval=>{const randomDelay=Math.max(2,Math.floor(chatgpt.randomFloat()*21-10));autoRefresh.isActive=setTimeout(()=>{const manifestScript=document.querySelector('script[src*="_ssgManifest.js"]');document.querySelector("#refresh-frame").src=manifestScript.src+"?"+Date.now();console.log("↻ ChatGPT >> ["+autoRefresh.nowTimeStamp()+"] ChatGPT session refreshed");scheduleRefreshes(interval)},(interval+randomDelay)*1e3)};scheduleRefreshes(interval?parseInt(interval,10):30);console.log("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Auto refresh activated");if(navigator.userAgent.includes("Chrome")&&typeof document.hidden!=="undefined"){document.addEventListener("visibilitychange",this.toggle.beacons)}},deactivate:function(){if(this.isActive){this.toggle.refreshFrame();document.removeEventListener("visibilitychange",this.toggle.beacons);clearTimeout(this.isActive);this.isActive=null;console.log("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Auto refresh de-activated")}else{console.log("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Auto refresh already inactive!")}},nowTimeStamp:function(){const now=new Date;const hours=now.getHours()%12||12;let minutes=now.getMinutes(),seconds=now.getSeconds();if(minutes<10)minutes="0"+minutes;if(seconds<10)seconds="0"+seconds;const meridiem=now.getHours()<12?"AM":"PM";return hours+":"+minutes+":"+seconds+" "+meridiem},toggle:{beacons:function(){if(chatgpt.autoRefresh.beaconID){clearInterval(chatgpt.autoRefresh.beaconID);chatgpt.autoRefresh.beaconID=null;console.log("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Beacons de-activated")}else{chatgpt.autoRefresh.beaconID=setInterval(()=>{navigator.sendBeacon("https://httpbin.org/post",new Uint8Array);console.log("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Beacon sent")},9e4);console.log("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Beacons activated")}},refreshFrame:function(){let refreshFrame=document.querySelector("#refresh-frame");if(refreshFrame)refreshFrame.remove();else{refreshFrame=Object.assign(document.createElement("iframe"),{id:"refresh-frame",style:"display: none"});document.head.prepend(refreshFrame)}}}},clearChats:async function(method){const validMethods=["api","dom"];method=(method||"dom").trim().toLowerCase();if(method&&!validMethods.includes(method))return console.log(`Method argument must be one of: [${validMethods}]`);if(method=="dom"){try{await chatgpt.getChatData()}catch{return}chatgpt.menu.open();setTimeout(()=>{const menuItems=document.querySelectorAll('a[role="menuitem"]')||[];for(const menuItem of menuItems)if(/settings/i.test(menuItem.text)){menuItem.click();break}setTimeout(()=>{const settingsBtns=document.querySelectorAll("[id*=radix] button");for(const settingsBtn of settingsBtns)if(/^clear/i.test(settingsBtn.textContent)){settingsBtn.click();break}setTimeout(()=>{document.querySelector("[id*=radix] button").click();setTimeout(()=>{exitMenu();try{document.querySelector("#prompt-textarea").focus()}catch(err){}},10)},10)},333)},10);const exitMenu=()=>{document.querySelector("div[id*=radix] button").click()}}else{return new Promise((resolve,reject)=>{chatgpt.getAccessToken().then(token=>{const xhr=new XMLHttpRequest;xhr.open("PATCH",endpoints.openAI.chats,true);xhr.setRequestHeader("Content-Type","application/json");xhr.setRequestHeader("Authorization","Bearer "+token);xhr.onload=()=>{if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot clear chats.");console.info("Chats successfully cleared");resolve()};xhr.send(JSON.stringify({is_visible:false}))}).catch(reject)})}},code:{execute:async function(code){if(!code)return console.error("Code argument not supplied. Pass some code!");if(typeof code!=="string")return console.error("Code argument must be a string!");chatgpt.send("Display the output as if you were terminal:\n\n"+code);console.info("Executing code...");await chatgpt.isIdle();return chatgpt.code.extract(await chatgpt.getChatData("active","msg","chatgpt","latest"))},extract:function(msg){const codeBlocks=msg.match(/(?<=```.*\n)[\s\S]*?(?=```)/g);return codeBlocks?codeBlocks[codeBlocks.length-1]:msg},minify:async function(code){if(!code)return console.error("Code argument not supplied. Pass some code!");if(typeof code!=="string")return console.error("Code argument must be a string!");chatgpt.send("Minify the following code:\n\n"+code);console.info("Minifying code...");await chatgpt.isIdle();return chatgpt.code.extract(await chatgpt.getChatData("active","msg","chatgpt","latest"))},obfuscate:async function(code){if(!code)return console.error("Code argument not supplied. Pass some code!");if(typeof code!=="string")return console.error("Code argument must be a string!");chatgpt.send("Obfuscate the following code:\n\n"+code);console.info("Obfuscating code...");await chatgpt.isIdle();return chatgpt.code.extract(await chatgpt.getChatData("active","msg","chatgpt","latest"))},refactor:async function(code,objective){if(!code)return console.error("Code (1st) argument not supplied. Pass some code!");for(let i=0;i<arguments.length;i++)if(typeof arguments[i]!=="string")return console.error(`Argument ${i+1} must be a string.`);chatgpt.send("Refactor the following code for "+(objective||"brevity")+":\n\n"+code);console.info("Refactoring code...");await chatgpt.isIdle();return chatgpt.code.extract(await chatgpt.getChatData("active","msg","chatgpt","latest"))},review:async function(code){if(!code)return console.error("Code argument not supplied. Pass some code!");if(typeof code!=="string")return console.error("Code argument must be a string!");chatgpt.send("Review the following code for me:\n\n"+code);console.info("Reviewing code...");await chatgpt.isIdle();return chatgpt.getChatData("active","msg","chatgpt","latest")},unminify:async function(code){if(!code)return console.error("Code argument not supplied. Pass some code!");if(typeof code!=="string")return console.error("Code argument must be a string!");chatgpt.send("Unminify the following code.:\n\n"+code);console.info("Unminifying code...");await chatgpt.isIdle();return chatgpt.code.extract(await chatgpt.getChatData("active","msg","chatgpt","latest"))},write:async function(prompt,outputLang){if(!prompt)return console.error("Prompt (1st) argument not supplied. Pass a prompt!");if(!outputLang)return console.error("outputLang (2nd) argument not supplied. Pass a language!");for(let i=0;i<arguments.length;i++)if(typeof arguments[i]!=="string")return console.error(`Argument ${i+1} must be a string.`);chatgpt.send(prompt+"\n\nWrite this as code in "+outputLang);console.info("Writing code...");await chatgpt.isIdle();return chatgpt.code.extract(await chatgpt.getChatData("active","msg","chatgpt","latest"))}},detectLanguage:async function(text){if(!text)return console.error("Text argument not supplied. Pass some text!");if(typeof text!=="string")return console.error("Text argument must be a string!");chatgpt.send("Detect the language of the following text:\n\n"+text+"\n\nOnly respond with the name of the language");console.info("Reviewing text...");await chatgpt.isIdle();return chatgpt.getChatData("active","msg","chatgpt","latest")},executeCode:function(){chatgpt.code.execute()},exportChat:async function(chatToGet,format){chatToGet=!chatToGet?"active":Number.isInteger(chatToGet)||/^\d+$/.test(chatToGet)?parseInt(chatToGet,10):chatToGet;format=format.toLowerCase()||"html";console.info("Generating transcript...");let transcript="",filename;if(/te?xt/.test(format)){const now=new Date,day=now.getDate().toString().padStart(2,"0"),month=(now.getMonth()+1).toString().padStart(2,"0"),year=now.getFullYear(),hour=now.getHours().toString().padStart(2,"0"),minute=now.getMinutes().toString().padStart(2,"0");filename=`ChatGPT_${day}-${month}-${year}_${hour}-${minute}.txt`;if(chatToGet=="active"&&/\/\w{8}-(\w{4}-){3}\w{12}$/.test(window.location.href)){const chatDivs=document.querySelectorAll("main > div > div > div > div > div > div[class*=group]");if(chatDivs.length===0)return console.error("Chat is empty!");const msgs=[];let isUserMsg=true;chatDivs.forEach(div=>{const sender=isUserMsg?"USER":"CHATGPT";isUserMsg=!isUserMsg;let msg=Array.from(div.childNodes).map(node=>node.innerText).join("\n\n").replace("Copy code","");msgs.push(sender+": "+msg)});transcript=msgs.join("\n\n")}else{for(const entry of await chatgpt.getChatData(chatToGet,"msg","both","all")){transcript+=`USER: ${entry.user}\n\n`;transcript+=`CHATGPT: ${entry.chatgpt}\n\n`}}}else{const response=await fetch(await chatgpt.shareChat(chatToGet)),htmlContent=await response.text();const parser=new DOMParser,parsedHtml=parser.parseFromString(htmlContent,"text/html");filename=parsedHtml.querySelector("title").textContent+".html";const cssLinks=parsedHtml.querySelectorAll('link[rel="stylesheet"]');cssLinks.forEach(link=>{const href=link.getAttribute("href");if(href?.startsWith("/"))link.setAttribute("href","https://chat.openai.com"+href)});transcript=(new XMLSerializer).serializeToString(parsedHtml)}console.info(`Exporting transcript as ${format.toUpperCase()}...`);if(format=="pdf"){transcript=transcript.replace(/<svg.*?<\/svg>/g,match=>{const dataURL="data:image/svg+xml,"+encodeURIComponent(match);return`<img src="${dataURL}">`});const transcriptPopup=window.open("","","toolbar=0, location=0, menubar=0, height=600, width=800");transcriptPopup.document.write(transcript);setTimeout(()=>{transcriptPopup.print({toPDF:true})},100)}else{if(format=="md"){const mdMatch=/<!?.*(<h1(.|\n)*?href=".*?continue.*?".*?\/a>.*?)<[^/]/.exec(transcript)[1];transcript=mdMatch||transcript;filename=filename.replace(".html",".md")}const blob=new Blob([transcript],{type:"text/"+(format=="html"?"html":format=="md"?"markdown":"plain")});const link=document.createElement("a"),blobURL=URL.createObjectURL(blob);link.href=blobURL;link.download=filename;document.body.appendChild(link);link.click();document.body.removeChild(link);URL.revokeObjectURL(blobURL)}},extractCode:function(){chatgpt.code.extract()},generateRandomIP:function(){const ip=Array.from({length:4},()=>Math.floor(chatgpt.randomFloat()*256)).join(".");console.info("IP generated: "+ip);return ip},get:function(targetType,targetName=""){if(typeof targetType!=="string"||typeof targetName!=="string"){throw new TypeError("Invalid arguments. Both arguments must be strings.")}if(!targetTypes.includes(targetType.toLowerCase())){throw new Error("Invalid targetType: "+targetType+". Valid values are: "+JSON.stringify(targetTypes))}const targetNames=[],reTargetName=new RegExp("^get(.*)"+targetType+"$","i");for(const prop in chatgpt){if(typeof chatgpt[prop]=="function"&&reTargetName.test(prop)){targetNames.push(prop.replace(reTargetName,"$1").toLowerCase())}}if(!targetNames.includes(targetName.toLowerCase())){throw new Error("Invalid targetName: "+targetName+". "+(targetNames.length>0?"Valid values are: "+JSON.stringify(targetNames):"targetType "+targetType.toLowerCase()+" does not require additional options."))}const targetFuncNameLower=("get"+targetName+targetType).toLowerCase();const targetFuncName=Object.keys(this).find(name=>{return name.toLowerCase()==targetFuncNameLower});return this[targetFuncName]()},getAccessToken:function(){return new Promise((resolve,reject)=>{if(Object.keys(chatgpt.openAIaccessToken).length>0&&Date.parse(chatgpt.openAIaccessToken.expireDate)-Date.parse(new Date)>=0)return resolve(chatgpt.openAIaccessToken.token);const xhr=new XMLHttpRequest;xhr.open("GET",endpoints.openAI.session,true);xhr.setRequestHeader("Content-Type","application/json");xhr.onload=()=>{if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot retrieve access token.");console.info("Token expiration: "+new Date(JSON.parse(xhr.responseText).expires).toLocaleString().replace(","," at"));chatgpt.openAIaccessToken={token:JSON.parse(xhr.responseText).accessToken,expireDate:JSON.parse(xhr.responseText).expires};return resolve(chatgpt.openAIaccessToken.token)};xhr.send()})},getAccountDetails:function(...details){const validDetails=["email","id","image","name","picture"];details=!arguments[0]?validDetails:Array.isArray(arguments[0])?arguments[0]:Array.from(arguments);for(const detail of details){if(!validDetails.includes(detail)){return console.error("Invalid detail arg '"+detail+"' supplied. Valid details are:\n"+"                    ["+validDetails+"]")}}return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;xhr.open("GET",endpoints.openAI.session,true);xhr.setRequestHeader("Content-Type","application/json");xhr.onload=()=>{if(xhr.status===200){const data=JSON.parse(xhr.responseText).user,detailsToReturn={};for(const detail of details)detailsToReturn[detail]=data[detail];return resolve(detailsToReturn)}else return reject("🤖 chatgpt.js >> Request failed. Cannot retrieve account details.")};xhr.send()})},getChatBox:function(){return document.getElementById("prompt-textarea")},getChatData:function(chatToGet=1,detailsToGet="all",sender="all",msgToGet="all"){const validDetails=["all","id","title","create_time","update_time","msg"];const validSenders=["all","both","user","chatgpt"];chatToGet=!chatToGet?"active":Number.isInteger(chatToGet)||/^\d+$/.test(chatToGet)?parseInt(chatToGet,10)===0?0:parseInt(chatToGet,10)-1:chatToGet;detailsToGet=["all",""].includes(detailsToGet)?validDetails.filter(detail=>/^(?!all$|msg$).*/.test(detail)):Array.isArray(detailsToGet)?detailsToGet:[detailsToGet];sender=!sender?"all":validSenders.includes(sender)?sender:"invalid";msgToGet=Number.isInteger(msgToGet)||/^\d+$/.test(msgToGet)?parseInt(msgToGet,10)===0?0:parseInt(msgToGet,10)-1:["all","latest"].includes(msgToGet.toLowerCase())?msgToGet.toLowerCase():!msgToGet?"all":"invalid";for(const detail of detailsToGet){if(!validDetails.includes(detail)){return console.error("Invalid detail arg '"+detail+"' passed. Valid details are:\n"+"                    ["+validDetails+"]")}}if(sender=="invalid"){return console.error("Invalid sender arg passed. Valid senders are:\n"+"                    ["+validSenders+"]")}if(msgToGet=="invalid"){return console.error("Invalid msgToGet arg passed. Valid msg's to get are:\n"+"                    [ 'all' | 'latest' | index of msg to get ]")}const getChatDetails=(token,detailsToGet)=>{const re_chatID=/\w{8}-(\w{4}-){3}\w{12}/;return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;xhr.open("GET",endpoints.openAI.chats,true);xhr.setRequestHeader("Content-Type","application/json");xhr.setRequestHeader("Authorization","Bearer "+token);xhr.onload=()=>{if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot retrieve chat details.");const data=JSON.parse(xhr.responseText).items;if(data.length<=0)return reject("🤖 chatgpt.js >> Chat list is empty.");const detailsToReturn={};if(Number.isInteger(chatToGet)||chatToGet=="latest"||chatToGet=="active"&&!new RegExp("/"+re_chatID.source+"$").test(window.location.href)){chatToGet=Number.isInteger(chatToGet)?chatToGet:0;if(chatToGet>data.length){return reject("🤖 chatgpt.js >> Chat with index "+(chatToGet+1)+" is out of bounds. Only "+data.length+" chats exist!")}for(const detail of detailsToGet)detailsToReturn[detail]=data[chatToGet][detail];return resolve(detailsToReturn)}const chatIdentifier=chatToGet=="active"||new RegExp("^"+re_chatID.source+"$").test(chatToGet)?"id":"title";if(chatToGet=="active")chatToGet=re_chatID.exec(window.location.href)[0];let idx,chatFound;for(idx=0;idx<data.length;idx++){if(data[idx][chatIdentifier]==chatToGet){chatFound=true;break}}if(!chatFound)return reject("🤖 chatgpt.js >> No chat with "+chatIdentifier+" = "+chatToGet+" found.");for(const detail of detailsToGet)detailsToReturn[detail]=data[idx][detail];return resolve(detailsToReturn)};xhr.send()})};const getChatMsgs=token=>{return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;getChatDetails(token,["id"]).then(chat=>{xhr.open("GET",`${endpoints.openAI.chat}/${chat.id}`,true);xhr.setRequestHeader("Content-Type","application/json");xhr.setRequestHeader("Authorization","Bearer "+token);xhr.onload=()=>{if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot retrieve chat messages.");const data=JSON.parse(xhr.responseText).mapping;const userMessages=[],chatGPTMessages=[],msgsToReturn=[];for(const key in data)if("message"in data[key]&&data[key].message.author.role=="user")userMessages.push({id:data[key].id,msg:data[key].message});userMessages.sort((a,b)=>a.msg.create_time-b.msg.create_time);if(parseInt(msgToGet,10)+1>userMessages.length)return reject("🤖 chatgpt.js >> Message/response with index "+(msgToGet+1)+" is out of bounds. Only "+userMessages.length+" messages/responses exist!");for(const userMessage of userMessages){let sub=[];for(const key in data){if("message"in data[key]&&data[key].message.author.role=="assistant"&&data[key].parent==userMessage.id){sub.push(data[key].message)}}sub.sort((a,b)=>a.create_time-b.create_time);sub=sub.map(x=>x.content.parts[0]);sub=sub.length===1?sub[0]:sub;chatGPTMessages.push(sub)}if(sender=="user")for(const userMessage in userMessages)msgsToReturn.push(userMessages[userMessage].msg.content.parts[0]);else if(sender=="chatgpt")for(const chatGPTMessage of chatGPTMessages)msgsToReturn.push(msgToGet=="latest"?chatGPTMessages[chatGPTMessages.length-1]:chatGPTMessage);else{let i=0;for(const message in userMessages){msgsToReturn.push({user:userMessages[message].msg.content.parts[0],chatgpt:msgToGet=="latest"?chatGPTMessages[i][chatGPTMessages[i].length-1]:chatGPTMessages[i]});i++}}return resolve(msgToGet=="all"?msgsToReturn:msgToGet=="latest"?msgsToReturn[msgsToReturn.length-1]:msgsToReturn[msgToGet])};xhr.send()})})};return new Promise(resolve=>{chatgpt.getAccessToken().then(token=>{if(!detailsToGet.includes("msg"))getChatDetails(token,detailsToGet).then(data=>{return resolve(data)});else getChatMsgs(token).then(messages=>{return resolve(messages)})})})},getChatInput:function(){return chatgpt.getChatBox().value},getContinueGeneratingButton:function(){for(const formButton of document.querySelectorAll("form button")){if(formButton.textContent.toLowerCase().includes("continue")){return formButton}}},getLastPrompt:function(){return chatgpt.getChatData("active","msg","user","latest")},getLastResponse:function(){return chatgpt.getChatData("active","msg","chatgpt","latest")},getNewChatLink:function(){for(const navLink of document.querySelectorAll('nav[aria-label="Chat history"] a')){if(/(new|clear) chat/i.test(navLink.text)){return navLink}}},getRegenerateButton:function(){if(chatgpt.isGizmoUI()){for(const mainSVG of document.querySelectorAll("main svg")){if(mainSVG.querySelector('path[d*="10.8763C3.62354"]'))return mainSVG.parentNode.parentNode}}else{for(const formButton of document.querySelectorAll("form button")){if(formButton.textContent.toLowerCase().includes("regenerate"))return formButton}}},getResponse:function(){if(window.location.href.startsWith("https://chat.openai.com/c/"))return chatgpt.getResponseFromDOM.apply(null,arguments);else return chatgpt.getResponseFromAPI.apply(null,arguments)},getResponseFromAPI:function(chatToGet,responseToGet){return chatgpt.response.getFromAPI(chatToGet,responseToGet)},getResponseFromDOM:function(pos){return chatgpt.response.getFromDOM(pos)},getSendButton:function(){return document.querySelector('form button[class*="bottom"]')},getStopGeneratingButton:function(){for(const formButton of document.querySelectorAll("form button")){if(formButton.textContent.toLowerCase().includes("stop")){return formButton}}},getUserLanguage:function(){return navigator.languages[0]||navigator.language||navigator.browserLanguage||navigator.systemLanguage||navigator.userLanguage||""},history:{isLoaded:function(){return new Promise(resolve=>{const checkChatHistory=()=>{if(document.querySelector('nav[aria-label="Chat history"]'))resolve();else setTimeout(checkChatHistory,100)};checkChatHistory()})},activate:function(){this.isOff()?this.toggle():console.info("Chat history is already enabled!")},deactivate:function(){this.isOn()?this.toggle():console.info("Chat history is already disabled!")},isOn:function(){if(chatgpt.isGizmoUI()){const navDivs=document.querySelectorAll('nav[aria-label="Chat history"] div'),offDiv=[...navDivs].find(div=>div.textContent.includes("Chat History is off"))||{};return offDiv.classList.toString().includes("invisible")}else{for(const navLink of document.querySelectorAll('nav[aria-label="Chat history"] a')){if(/clear chat/i.test(navLink.text))return false}return true}},isOff:function(){return!this.isOn()},toggle:function(){for(const navBtn of document.querySelectorAll('nav[aria-label="Chat history"] button')){if(/chat history/i.test(navBtn.textContent)){navBtn.click();return}}}},instructions:{add:function(instruction,target){if(!instruction)return console.error("Please provide an instruction");if(typeof instruction!=="string")return console.error("Instruction must be a string");const validTargets=["user","chatgpt"];if(!target)return console.error("Please provide a valid target!");if(typeof target!=="string")return console.error("Target must be a string");target=target.toLowerCase();if(!validTargets.includes(target))return console.error(`Invalid target ${target}. Valid targets are [${validTargets}]`);instruction=`\n\n${instruction}`;return new Promise(resolve=>{chatgpt.getAccessToken().then(async token=>{const instructionsData=await this.fetchData();if(target=="user")instructionsData.about_user_message+=instruction;else if(target=="chatgpt")instructionsData.about_model_message+=instruction;await this.sendRequest("POST",token,instructionsData);return resolve()})})},clear:function(target){const validTargets=["user","chatgpt"];if(!target)return console.error("Please provide a valid target!");if(typeof target!=="string")return console.error("Target must be a string");target=target.toLowerCase();if(!validTargets.includes(target))return console.error(`Invalid target ${target}. Valid targets are [${validTargets}]`);return new Promise(resolve=>{chatgpt.getAccessToken().then(async token=>{const instructionsData=await this.fetchData();if(target=="user")instructionsData.about_user_message="";else if(target=="chatgpt")instructionsData.about_model_message="";await this.sendRequest("POST",token,instructionsData);return resolve()})})},fetchData:function(){return new Promise(resolve=>{chatgpt.getAccessToken().then(async token=>{return resolve(await this.sendRequest("GET",token))})})},sendRequest:function(method,token,body){for(let i=0;i<arguments.length-1;i++)if(typeof arguments[i]!=="string")return console.error(`Argument ${i+1} must be a string`);const validMethods=["POST","GET"];method=(method||"").trim().toUpperCase();if(!method||!validMethods.includes(method))return console.error(`Valid methods are ${validMethods}`);if(!token)return console.error("Please provide a valid access token!");if(body&&typeof body!=="object")return console.error(`Invalid body data type. Got ${typeof body}, expected object`);return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;xhr.open(method,endpoints.openAI.instructions,true);xhr.setRequestHeader("Accept-Language","en-US");xhr.setRequestHeader("Authorization","Bearer "+token);if(method=="POST")xhr.setRequestHeader("Content-Type","application/json");xhr.onload=()=>{const responseData=JSON.parse(xhr.responseText);if(xhr.status===422)return reject("🤖 chatgpt.js >> Character limit exceeded. Custom instructions can have a maximum length of 1500 characters.");else if(xhr.status===403&&responseData.detail.reason=="content_policy")return reject("🤖 chatgpt.js >> "+responseData.detail.description);else if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot contact custom instructions endpoint.");console.info(`Custom instructions successfully contacted with method ${method}`);return resolve(responseData||{})};xhr.send(JSON.stringify(body)||"")})},turnOff:function(){return new Promise(resolve=>{chatgpt.getAccessToken().then(async token=>{const instructionsData=await this.fetchData();instructionsData.enabled=false;await this.sendRequest("POST",token,instructionsData);return resolve()})})},turnOn:function(){return new Promise(resolve=>{chatgpt.getAccessToken().then(async token=>{const instructionsData=await this.fetchData();instructionsData.enabled=true;await this.sendRequest("POST",token,instructionsData);return resolve()})})},toggle:function(){return new Promise(resolve=>{this.fetchData().then(async instructionsData=>{await(instructionsData.enabled?this.turnOff():this.turnOn());return resolve()})})}},isDarkMode:function(){return!document.documentElement.classList.toString().includes("dark")?false:window.matchMedia?.("(prefers-color-scheme: dark)")?.matches},isFullScreen:function(){const userAgentStr=navigator.userAgent;return userAgentStr.includes("Chrome")?window.matchMedia("(display-mode: fullscreen)").matches:userAgentStr.includes("Firefox")?window.fullScreen:/MSIE|rv:/.test(userAgentStr)?document.msFullscreenElement:document.webkitIsFullScreen},isGizmoUI:function(){return document.documentElement.classList.toString().includes("gizmo")},isIdle:function(){return new Promise(resolve=>{const intervalId=setInterval(()=>{if(chatgpt.getRegenerateButton()){clearInterval(intervalId);resolve()}},100)})},isLoaded:function(){return new Promise(resolve=>{const intervalId=setInterval(()=>{if(document.querySelector('nav button[id*="menu"]')){clearInterval(intervalId);setTimeout(()=>{resolve()},500)}},100)})},isLightMode:function(){return document.documentElement.classList.contains("light")},logout:function(){window.location.href="https://chat.openai.com/auth/logout"},menu:{elements:[],addedEvent:false,append:function(element,attrs={}){const validElements=["button","dropdown"];if(!element||typeof element!=="string")return console.error("🤖 chatgpt.js >> Please supply a valid string element name!");element=element.toLowerCase();if(!validElements.includes(element))return console.error(`🤖 chatgpt.js >> Invalid element! Valid elements are [${validElements}]`);const newElement=document.createElement(element=="dropdown"?"select":element=="button"?"a":element);newElement.id=Math.floor(chatgpt.randomFloat()*1e6)+Date.now();if(element=="button"){newElement.textContent=attrs?.label&&typeof attrs.label=="string"?attrs.label:"chatgpt.js button";const icon=document.createElement("img");icon.src=attrs?.icon&&typeof attrs.icon=="string"?attrs.icon:endpoints.assets+"/starters/chrome/extension/icons/icon128.png";icon.width=18;newElement.insertBefore(icon,newElement.firstChild);newElement.onclick=attrs?.onclick&&typeof attrs.onclick=="function"?attrs.onclick:function(){}}else if(element=="dropdown"){if(!attrs?.items||!Array.isArray(attrs.items)||!attrs.items.length)attrs.items=[{text:"🤖 chatgpt.js option",value:"chatgpt.js option value"}];if(!attrs.items.every(el=>typeof el=="object"))return console.error("'items' must be an array of objects!");newElement.style="background-color: #000; width: 100%; border: none;";attrs.items.forEach(item=>{const optionElement=document.createElement("option");optionElement.textContent=item?.text;optionElement.value=item?.value;newElement.add(optionElement)})}const addElementsToMenu=()=>{const optionButtons=document.querySelectorAll('a[role="menuitem"]');let cssClasses;for(let navLink of optionButtons)if(navLink.textContent=="Settings"){cssClasses=navLink.classList;break}const headlessNav=optionButtons[0].parentNode;chatgpt.menu.elements.forEach(element=>{element.setAttribute("class",cssClasses);if(!headlessNav.contains(element))try{headlessNav.insertBefore(element,headlessNav.firstChild)}catch(error){console.error(error)}})};this.elements.push(newElement);const menuBtn=document.querySelector('nav button[id*="headless"]');if(!this.addedEvent){menuBtn.addEventListener("click",()=>{setTimeout(addElementsToMenu,25)});this.addedEvent=true}return newElement.id},close:function(){const menuBtn=document.querySelector('nav [id*="menu-button"][aria-expanded="true"]');if(menuBtn)try{menuBtn.click()}catch(err){console.error("Error while closing the menu");throw new Error(err)}else{console.error("Menu already hidden!");throw new Error}},open:function(){const menuBtn=document.querySelector('nav [id*="menu-button"][aria-expanded="false"]');if(menuBtn)try{menuBtn.click()}catch(err){console.error("Error while closing the menu");throw new Error(err)}else{console.error("Menu already hidden!");throw new Error}}},minify:function(){chatgpt.code.minify()},notify:async function(msg,position,notifDuration,shadow){notifDuration=notifDuration?+notifDuration:1.75;const fadeDuration=.3,vpYoffset=23,vpXoffset=27;const notificationDiv=document.createElement("div");notificationDiv.id=Math.floor(chatgpt.randomFloat()*1e6)+Date.now();notificationDiv.classList.add("chatgpt-notif");notificationDiv.innerText=msg;document.body.appendChild(notificationDiv);const closeBtn=document.createElement("div");closeBtn.title=cjsMessages?.tooltip_dismiss||"Dismiss";closeBtn.classList.add("notif-close-btn");const closeSVG=document.createElementNS("http://www.w3.org/2000/svg","svg");closeSVG.setAttribute("height","8px");closeSVG.setAttribute("viewBox","0 0 14 14");closeSVG.setAttribute("fill","none");closeSVG.style.height=closeSVG.style.width="8px";const closeSVGpath=document.createElementNS("http://www.w3.org/2000/svg","path");closeSVGpath.setAttribute("fill-rule","evenodd");closeSVGpath.setAttribute("clip-rule","evenodd");closeSVGpath.setAttribute("fill","white");closeSVGpath.setAttribute("d","M13.7071 1.70711C14.0976 1.31658 14.0976 0.683417 13.7071 0.292893C13.3166 -0.0976312 12.6834 -0.0976312 12.2929 0.292893L7 5.58579L1.70711 0.292893C1.31658 -0.0976312 0.683417 -0.0976312 0.292893 0.292893C-0.0976312 0.683417 -0.0976312 1.31658 0.292893 1.70711L5.58579 7L0.292893 12.2929C-0.0976312 12.6834 -0.0976312 13.3166 0.292893 13.7071C0.683417 14.0976 1.31658 14.0976 1.70711 13.7071L7 8.41421L12.2929 13.7071C12.6834 14.0976 13.3166 14.0976 13.7071 13.7071C14.0976 13.3166 14.0976 12.6834 13.7071 12.2929L8.41421 7L13.7071 1.70711Z");closeSVG.appendChild(closeSVGpath);closeBtn.appendChild(closeSVG);notificationDiv.appendChild(closeBtn);notificationDiv.isTop=!position||!/low|bottom/i.test(position);notificationDiv.isRight=!position||!/left/i.test(position);notificationDiv.quadrant=(notificationDiv.isTop?"top":"bottom")+(notificationDiv.isRight?"Right":"Left");const thisUpdated=20231110;let notifStyle=document.querySelector("#chatgpt-notif-style");if(!notifStyle||parseInt(notifStyle.getAttribute("last-updated"),10)<thisUpdated){if(!notifStyle){notifStyle=document.createElement("style");notifStyle.id="chatgpt-notif-style";notifStyle.setAttribute("last-updated",thisUpdated.toString());document.head.appendChild(notifStyle)}notifStyle.innerText=".chatgpt-notif {"+"background-color: black ; padding: 10px 13px 10px 18px ; border-radius: 11px ; border: 1px solid #f5f5f7 ;"+"opacity: 0 ; position: fixed ; z-index: 9999 ; font-size: 1.8rem ; color: white ;"+"-webkit-user-select: none ; -moz-user-select: none ; -ms-user-select: none ; user-select: none ;"+`transform: translateX(${!notificationDiv.isRight?"-":""}35px) ;`+(shadow?"box-shadow: -8px 13px 25px 0 "+(/\b(shadow|on)\b/gi.test(shadow)?"gray":shadow):"")+"}"+".notif-close-btn { cursor: pointer ; float: right ; position: relative ; right: -4px ; margin-left: -3px ;"+"display: grid }"+"@keyframes notif-zoom-fade-out { 0% { opacity: 1 ; transform: scale(1) }"+"15% { opacity: 0.35 ; transform: rotateX(-27deg) scale(1.05) }"+"45% { opacity: 0.05 ; transform: rotateX(-81deg) }"+"100% { opacity: 0 ; transform: rotateX(-180deg) scale(1.15) }}"}let notifyProps=JSON.parse(localStorage.notifyProps);notifyProps.queue[notificationDiv.quadrant].push(notificationDiv.id);localStorage.notifyProps=JSON.stringify(notifyProps);notificationDiv.style.top=notificationDiv.isTop?vpYoffset.toString()+"px":"";notificationDiv.style.bottom=!notificationDiv.isTop?vpYoffset.toString()+"px":"";notificationDiv.style.right=notificationDiv.isRight?vpXoffset.toString()+"px":"";notificationDiv.style.left=!notificationDiv.isRight?vpXoffset.toString()+"px":"";const thisQuadrantQueue=notifyProps.queue[notificationDiv.quadrant];if(thisQuadrantQueue.length>1){try{for(const divId of thisQuadrantQueue.slice(0,-1)){const oldDiv=document.getElementById(divId),offsetProp=oldDiv.style.top?"top":"bottom",vOffset=+/\d+/.exec(oldDiv.style[offsetProp])[0]+5+oldDiv.getBoundingClientRect().height;oldDiv.style[offsetProp]=`${vOffset}px`}}catch(err){}}setTimeout(()=>{notificationDiv.style.opacity=chatgpt.isDarkMode()?.8:.67;notificationDiv.style.transform="translateX(0)";notificationDiv.style.transition="transform 0.15s ease, opacity 0.15s ease"},10);const hideDelay=fadeDuration>notifDuration?0:notifDuration-fadeDuration;let dismissAudio,dismissAudioTID;if(isFFtmScript){let nthAudio;do{nthAudio=Math.floor(Math.random()*3)+1}while(nthAudio===notifyProps.lastNthAudio);notifyProps.lastNthAudio=nthAudio;localStorage.notifyProps=JSON.stringify(notifyProps);dismissAudio=new Audio;dismissAudio.src=endpoints.assets+"/media/audio/notifications/bubble-pop/"+`${nthAudio}-${notificationDiv.isRight?"right":"left"}.mp3`;dismissAudioTID=setTimeout(()=>dismissAudio.play().catch(()=>{}),hideDelay*1e3)}const dismissNotif=()=>{notificationDiv.style.animation=`notif-zoom-fade-out ${fadeDuration}s ease-out`;if(isFFtmScript)dismissAudio?.play().catch(()=>{});clearTimeout(dismissFuncTID);clearTimeout(dismissAudioTID)};const dismissFuncTID=setTimeout(dismissNotif,hideDelay*1e3);closeSVG.addEventListener("click",dismissNotif,{once:true});notificationDiv.addEventListener("animationend",()=>{notificationDiv.remove();notifyProps=JSON.parse(localStorage.notifyProps);notifyProps.queue[notificationDiv.quadrant].shift();localStorage.notifyProps=JSON.stringify(notifyProps)},{once:true})},obfuscate:function(){chatgpt.code.obfuscate()},printAllFunctions:function(){const colors={cmdPrompt:["#ff00ff","#00ff00"],objName:["#0611e9","#f9ee16"],methodName:["#005aff","#ffa500"],entryType:["#467e06","#b981f9"],srcMethod:["#ff0000","#00ffff"]};Object.keys(colors).forEach(element=>{colors[element][1]=colors[element][1]||"#"+(Number(`0x1${colors[element][0].replace(/^#/,"")}`)^16777215).toString(16).substring(1).toUpperCase()});const functionNames=[];for(const prop in this){if(typeof this[prop]=="function"){const chatgptIsParent=!Object.keys(this).find(obj=>Object.keys(this[obj]).includes(this[prop].name)),functionParent=chatgptIsParent?"chatgpt":"other";functionNames.push([functionParent,prop])}else if(typeof this[prop]=="object"){for(const nestedProp in this[prop]){if(typeof this[prop][nestedProp]=="function"){functionNames.push([prop,nestedProp])}}}}functionNames.sort((a,b)=>{return a[0].localeCompare(b[0])||a[1].localeCompare(b[1])});const isDarkMode=window.matchMedia("(prefers-color-scheme: dark)").matches,baseFontStyles="font-family: monospace ; font-size: larger ; ";console.log("\n%c🤖 chatgpt.js methods\n","font-family: sans-serif ; font-size: xxx-large ; font-weight: bold");for(const functionName of functionNames){const isChatGptObjParent=/chatgpt|other/.test(functionName[0]),rootFunction=functionName[0]=="chatgpt"?this[functionName[1]].name:functionName[0]!=="other"?functionName[0]+"."+functionName[1]:Object.keys(this).find(obj=>Object.keys(this[obj]).includes(this[functionName[1]].name))+"."+this[functionName[1]].name,isAsync=this[functionName[1]]?.constructor.name=="AsyncFunction";console.log("%c>> %c"+(isChatGptObjParent?"":`${functionName[0]}.%c`)+functionName[1]+" - https://chatgptjs.org/userguide/"+/(?:.*\.)?(.*)/.exec(rootFunction)[1].toLowerCase()+(isAsync?"-async":"")+"\n%c[%c"+(functionName[0]=="chatgpt"&&functionName[1]==this[functionName[1]].name||!isChatGptObjParent?"Function":"Alias of")+"%c: %c"+rootFunction+"%c]",baseFontStyles+"font-weight: bold ; color:"+colors.cmdPrompt[+isDarkMode],baseFontStyles+"font-weight: bold ;"+"color:"+colors[isChatGptObjParent?"methodName":"objName"][+isDarkMode],baseFontStyles+"font-weight: "+(isChatGptObjParent?"initial":"bold")+";"+"color:"+(isChatGptObjParent?"initial":colors.methodName[+isDarkMode]),baseFontStyles+"font-weight: "+(isChatGptObjParent?"bold":"initial")+";"+"color:"+(isChatGptObjParent?colors.entryType[+isDarkMode]:"initial"),baseFontStyles+"font-weight: "+(isChatGptObjParent?"initial":"bold")+";"+"color:"+(isChatGptObjParent?"initial":colors.entryType[+isDarkMode]),baseFontStyles+(isChatGptObjParent?"font-style: italic":"font-weight: initial")+";"+"color:"+(isChatGptObjParent?colors.srcMethod[+isDarkMode]:"initial"),baseFontStyles+(isChatGptObjParent?"font-weight: initial":"font-style: italic")+";"+"color:"+(isChatGptObjParent?"initial":colors.srcMethod[+isDarkMode]),isChatGptObjParent?"":baseFontStyles+"color: initial ; font-weight: initial")}},randomFloat:function(){const crypto=window.crypto||window.msCrypto;return crypto.getRandomValues(new Uint32Array(1))[0]/4294967295},refactor:function(){chatgpt.code.refactor()},regenerate:function(){for(const formButton of document.querySelectorAll("form button")){if(formButton.textContent.toLowerCase().includes("regenerate")){formButton.click();return}}},renderHTML:function(node){const reTags=/<([a-z\d]+)\b([^>]*)>([\s\S]*?)<\/\1>/g,reAttributes=/(\S+)=['"]?((?:.(?!['"]?\s+(?:\S+)=|[>']))+.)['"]?/g,nodeContent=node.childNodes;if(!this.renderHTML.preWrapSet){node.style.whiteSpace="pre-wrap";this.renderHTML.preWrapSet=true;setTimeout(()=>{this.renderHTML.preWrapSet=false},100)}for(const childNode of nodeContent){if(childNode.nodeType==Node.TEXT_NODE){const text=childNode.nodeValue,elems=Array.from(text.matchAll(reTags));if(elems.length>0){const elem=elems[0],[tagContent,tagName,tagAttributes,tagText]=elem.slice(0,4),tagNode=document.createElement(tagName);tagNode.textContent=tagText;const attributes=Array.from(tagAttributes.matchAll(reAttributes));attributes.forEach(attribute=>{const name=attribute[1],value=attribute[2].replace(/['"]/g,"");tagNode.setAttribute(name,value)});const renderedNode=this.renderHTML(tagNode);const beforeTextNode=document.createTextNode(text.substring(0,elem.index)),afterTextNode=document.createTextNode(text.substring(elem.index+tagContent.length));node.replaceChild(beforeTextNode,childNode);node.insertBefore(renderedNode,beforeTextNode.nextSibling);node.insertBefore(afterTextNode,renderedNode.nextSibling)}}else if(childNode.nodeType==Node.ELEMENT_NODE)this.renderHTML(childNode)}return node},resend:async function(){chatgpt.send(await chatgpt.getChatData("latest","msg","user","latest"))},response:{get:function(){if(window.location.href.startsWith("https://chat.openai.com/c/"))return this.getFromDOM.apply(null,arguments);else return this.getFromAPI.apply(null,arguments)},getFromAPI:function(chatToGet,responseToGet){chatToGet=chatToGet||"latest";responseToGet=responseToGet||"latest";return chatgpt.getChatData(chatToGet,"msg","chatgpt",responseToGet)},getFromDOM:function(pos){const responseDivs=document.querySelectorAll("main > div > div > div > div > div[class*=group]"),strPos=pos.toString().toLowerCase();if(/last|final/.test(strPos)){return responseDivs.length?responseDivs[responseDivs.length-1].textContent:""}else{const nthOfResponse=Number.isInteger(pos)?pos:/^\d+/.test(strPos)?/^\d+/.exec(strPos)[0]:(/^(1|one|fir)(st)?$/.test(strPos)?1:/^(2|tw(o|en|el(ve|f))|seco)(nd|t[yi])?(e?th)?$/.test(strPos)?2:/^(3|th(ree|ir?))(rd|teen|t[yi])?(e?th)?$/.test(strPos)?3:/^(4|fou?r)(teen|t[yi])?(e?th)?$/.test(strPos)?4:/^(5|fi(ve|f))(teen|t[yi])?(e?th)?$/.test(strPos)?5:/^(6|six)(teen|t[yi])?(e?th)?$/.test(strPos)?6:/^(7|seven)(teen|t[yi])?(e?th)?$/.test(strPos)?7:/^(8|eight?)(teen|t[yi])?(e?th)?$/.test(strPos)?8:/^(9|nine?)(teen|t[yi])?(e?th)?$/.test(strPos)?9:/^(10|ten)(th)?$/.test(strPos)?10:1)*(/(ty|ieth)$/.test(strPos)?10:1)+(/teen(th)?$/.test(strPos)?10:0);return responseDivs.length?responseDivs[nthOfResponse-1].textContent:""}},getLast:function(){return chatgpt.getChatData("active","msg","chatgpt","latest")},regenerate:function(){for(const formButton of document.querySelectorAll("form button")){if(formButton.textContent.toLowerCase().includes("regenerate")){formButton.click();return}}},stopGenerating:function(){for(const formButton of document.querySelectorAll("form button")){if(formButton.textContent.toLowerCase().includes("stop")){formButton.click();return}}}},reviewCode:function(){chatgpt.code.review()},scrollToBottom:function(){try{document.querySelector('button[class*="cursor"][class*="bottom"]').click()}catch(err){console.error("",err)}},send:function(msg,method=""){for(let i=0;i<arguments.length;i++)if(typeof arguments[i]!=="string")return console.error(`Argument ${i+1} must be a string!`);const textArea=document.querySelector("form textarea"),sendButton=document.querySelector('form button[class*="bottom"]');textArea.value=msg;textArea.dispatchEvent(new Event("input",{bubbles:true}));const delaySend=setInterval(()=>{if(!sendButton.hasAttribute("disabled")){method.toLowerCase()=="click"?sendButton.click():textArea.dispatchEvent(new KeyboardEvent("keydown",{keyCode:13,bubbles:true}));clearInterval(delaySend)}},25)},sendInNewChat:function(msg){if(typeof msg!=="string")return console.error("Message must be a string!");for(const navLink of document.querySelectorAll('nav[aria-label="Chat history"] a')){if(/(new|clear) chat/i.test(navLink.text)){navLink.click();break}}setTimeout(()=>{chatgpt.send(msg)},500)},settings:{scheme:{isDark:function(){return document.documentElement.classList.contains("dark")},isLight:function(){return document.documentElement.classList.contains("light")},set:function(value){const validValues=["dark","light","system"];if(!value)return console.error("Please specify a scheme value!");if(!validValues.includes(value))return console.error(`Invalid scheme value. Valid values are [${validValues}]`);let schemeToSet=value;if(value=="system")schemeToSet=window.matchMedia("(prefers-color-scheme: dark)").matches?"dark":"light";localStorage.setItem("theme",value);console.info(`Scheme set to ${value.toUpperCase()}.`);if(!document.documentElement.classList.contains(schemeToSet))this.toggle()},toggle:function(){const[schemeToRemove,schemeToAdd]=this.isDark()?["dark","light"]:["light","dark"];document.documentElement.classList.replace(schemeToRemove,schemeToAdd);document.documentElement.style.colorScheme=schemeToAdd;localStorage.setItem("theme",schemeToAdd)}}},sentiment:async function(text,entity){for(let i=0;i<arguments.length;i++)if(typeof arguments[i]!=="string")return console.error(`Argument ${i+1} must be a string.`);chatgpt.send("What is the sentiment of the following text"+(entity?` towards the entity ${entity},`:"")+" from strongly negative to strongly positive?\n\n"+text);console.info("Analyzing sentiment...");await chatgpt.isIdle();return chatgpt.getChatData("active","msg","chatgpt","latest")},setScheme:function(value){chatgpt.settings.scheme.set(value)},shareChat:function(chatToGet,method="clipboard"){const validMethods=["alert","notify","notification","clipboard","copy"];if(!validMethods.includes(method))return console.error("Invalid method '"+method+"' passed. Valid methods are ["+validMethods+"].");const getChatNode=token=>{return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;chatgpt.getChatData(chatToGet).then(chat=>{xhr.open("GET",`${endpoints.openAI.chat}/${chat.id}`,true);xhr.setRequestHeader("Content-Type","application/json");xhr.setRequestHeader("Authorization","Bearer "+token);xhr.onload=()=>{if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot retrieve chat node.");return resolve(JSON.parse(xhr.responseText).current_node)};xhr.send()})})};const makeChatToShare=(token,node)=>{return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;chatgpt.getChatData(chatToGet).then(chat=>{xhr.open("POST",endpoints.openAI.share_create,true);xhr.setRequestHeader("Content-Type","application/json");xhr.setRequestHeader("Authorization","Bearer "+token);xhr.onload=()=>{if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot initialize share chat.");return resolve(JSON.parse(xhr.responseText))};xhr.send(JSON.stringify({current_node_id:node,conversation_id:chat.id,is_anonymous:true}))})})};const confirmShareChat=(token,data)=>{return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;xhr.open("PATCH",`${endpoints.openAI.share}/${data.share_id}`,true);xhr.setRequestHeader("Content-Type","application/json");xhr.setRequestHeader("Authorization","Bearer "+token);xhr.onload=()=>{if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot share chat.");console.info(`Chat shared at '${data.share_url}'`);return resolve()};xhr.send(JSON.stringify({share_id:data.share_id,highlighted_message_id:data.highlighted_message_id,title:data.title,is_public:true,is_visible:data.is_visible,is_anonymous:data.is_anonymous}))})};return new Promise(resolve=>{chatgpt.getAccessToken().then(token=>{getChatNode(token).then(node=>{makeChatToShare(token,node).then(data=>{confirmShareChat(token,data).then(()=>{if(["copy","clipboard"].includes(method))navigator.clipboard.writeText(data.share_url);else chatgpt.alert("🚀 Share link created!",'"'+data.title+'" is available at: <a target="blank" rel="noopener" href="'+data.share_url+'" >'+data.share_url+"</a>",[function openLink(){window.open(data.share_url,"_blank","noopener")},function copyLink(){navigator.clipboard.writeText(data.share_url)}]);resolve(data.share_url)})})})})})},sidebar:{elements:[],observer:{},activateObserver:function(){const chatHistoryNav=document.querySelector('nav[aria-label="Chat history"]'),firstButton=chatHistoryNav.querySelector("a");if(chatgpt.history.isOff())try{firstButton.parentNode.nextElementSibling.style.display="none"}catch(error){}if(this.observer instanceof MutationObserver)try{this.observer.disconnect()}catch(e){}if(!this.elements.length)return console.error("🤖 chatgpt.js >> No elements to append!");let cssClasses;for(let navLink of document.querySelectorAll('nav[aria-label="Chat history"] a')){if(/.*chat/.exec(navLink.text)[0]){cssClasses=navLink.classList;navLink.parentNode.style.margin="2px 0";break}}this.elements.forEach(element=>{element.setAttribute("class",cssClasses);element.style.maxHeight=element.style.minHeight="44px";element.style.margin="2px 0"});const navBar=document.querySelector('nav[aria-label="Chat history"]');this.observer=new MutationObserver(mutations=>{mutations.forEach(mutation=>{if(mutation.type=="childList"&&mutation.addedNodes.length||mutation.type=="attributes"&&mutation.attributeName=="data-chatgptjs")this.elements.forEach(element=>{if(!navBar.contains(element))try{navBar.insertBefore(element,navBar.querySelector("a").parentNode)}catch(error){console.error(error)}})})});this.observer.observe(document.documentElement,{childList:true,subtree:true,attributes:true})},append:function(element,attrs={}){const validElements=["button","dropdown"];if(!element||typeof element!=="string")return console.error("🤖 chatgpt.js >> Please supply a valid string element name!");element=element.toLowerCase();if(!validElements.includes(element))return console.error(`🤖 chatgpt.js >> Invalid element! Valid elements are [${validElements}]`);const newElement=document.createElement(element=="dropdown"?"select":element);newElement.id=Math.floor(chatgpt.randomFloat()*1e6)+Date.now();if(element=="button"){newElement.textContent=attrs?.label&&typeof attrs.label=="string"?attrs.label:"chatgpt.js button";const icon=document.createElement("img");icon.src=attrs?.icon&&typeof attrs.icon=="string"?attrs.icon:endpoints.assets+"/starters/chrome/extension/icons/icon128.png";icon.width=18;newElement.insertBefore(icon,newElement.firstChild);newElement.onclick=attrs?.onclick&&typeof attrs.onclick=="function"?attrs.onclick:function(){}}else if(element=="dropdown"){if(!attrs?.items||!Array.isArray(attrs.items)||!attrs.items.length)attrs.items=[{text:"🤖 chatgpt.js option",value:"chatgpt.js option value"}];if(!attrs.items.every(el=>typeof el=="object"))return console.error("'items' must be an array of objects!");attrs.items.forEach(item=>{const optionElement=document.createElement("option");optionElement.textContent=item?.text;optionElement.value=item?.value;newElement.add(optionElement)})}if(element=="dropdown")newElement.style.backgroundColor="var(--gray-900, rgb(32, 33, 35))";this.elements.push(newElement);this.activateObserver();document.body.setAttribute("data-chatgptjs","observer-trigger");return newElement.id},hide:function(){this.isOn()?this.toggle():console.info("Sidebar already hidden!")},show:function(){this.isOff()?this.toggle():console.info("Sidebar already shown!")},isOff:function(){return!this.isOn()},isOn:function(){return chatgpt.isGizmoUI()?document.querySelector("#__next > div > div").style.visibility!="hidden":!document.querySelector('button[aria-label*="Open sidebar"]')},toggle:function(){const isGizmoUI=chatgpt.isGizmoUI(),navBtnSelector=isGizmoUI?"main button":'nav[aria-label="Chat history"] a',isToggleBtn=isGizmoUI?btn=>Array.from(btn.querySelectorAll("*")).some(child=>child.style.transform.includes("translateY")):btn=>/close sidebar/i.test(btn.text);for(const btn of document.querySelectorAll(navBtnSelector))if(isToggleBtn(btn)){btn.click();return}}},startNewChat:function(){for(const navLink of document.querySelectorAll('nav[aria-label="Chat history"] a')){if(/(new|clear) chat/i.test(navLink.text)){navLink.click();return}}},stop:function(){for(const formButton of document.querySelectorAll("form button")){if(formButton.textContent.toLowerCase().includes("stop")){formButton.click();return}}},suggest:async function(ideaType,details){if(!ideaType)return console.error("ideaType (1st argument) not supplied"+"(e.g. 'gifts', 'names', 'recipes', etc.)");for(let i=0;i<arguments.length;i++)if(typeof arguments[i]!=="string")return console.error(`Argument ${i+1} must be a string.`);chatgpt.send("Suggest some names. "+(details||""));console.info(`Creating ${ideaType}...`);await chatgpt.isIdle();return chatgpt.getChatData("active","msg","chatgpt","latest")},speak:function(msg,options={}){const{voice=2,pitch=2,speed=1.1}=options;if(typeof msg!=="string")return console.error("Message must be a string!");for(let key in options){const value=options[key];if(typeof value!=="number"&&!/^\d+$/.test(value))return console.error(`Invalid ${key} index '${value}'. Must be a number!`)}try{const voices=speechSynthesis.getVoices(),utterance=new SpeechSynthesisUtterance;utterance.text=msg;utterance.voice=voices[voice];utterance.pitch=pitch;utterance.rate=speed;speechSynthesis.speak(utterance)}catch(err){console.error("",err)}},summarize:async function(text){if(!text)return console.error("Text (1st) argument not supplied. Pass some text!");if(typeof text!=="string")return console.error("Text argument must be a string!");chatgpt.send("Summarize the following text:\n\n"+text);console.info("Summarizing text...");await chatgpt.isIdle();return chatgpt.getChatData("active","msg","chatgpt","latest")},toggleScheme:function(){chatgpt.settings.scheme.toggle()},translate:async function(text,outputLang){if(!text)return console.error("Text (1st) argument not supplied. Pass some text!");if(!outputLang)return console.error("outputLang (2nd) argument not supplied. Pass a language!");for(let i=0;i<arguments.length;i++)if(typeof arguments[i]!=="string")return console.error(`Argument ${i+1} must be a string!`);chatgpt.send("Translate the following text to "+outputLang+". Only reply with the translation.\n\n"+text);console.info("Translating text...");await chatgpt.isIdle();return chatgpt.getChatData("active","msg","chatgpt","latest")},unminify:function(){chatgpt.code.unminify()},uuidv4:function(){let d=(new Date).getTime();const uuid="xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,c=>{const r=(d+window.crypto.getRandomValues(new Uint32Array(1))[0]/(Math.pow(2,32)-1)*16)%16|0;d=Math.floor(d/16);return(c=="x"?r:r&3|8).toString(16)});return uuid},writeCode:function(){chatgpt.code.write()}};chatgpt.scheme={...chatgpt.settings.scheme};const buttonActions=["click","get"],targetTypes=["button","link","div","response"];for(const buttonAction of buttonActions){chatgpt[buttonAction+"Button"]=function handleButton(buttonIdentifier){const button=/^[.#]/.test(buttonIdentifier)?document.querySelector(buttonIdentifier):/send/i.test(buttonIdentifier)?document.querySelector('form button[class*="bottom"]'):/scroll/i.test(buttonIdentifier)?document.querySelector('button[class*="cursor"]'):function(){for(const button of document.querySelectorAll("button")){if(button.textContent.toLowerCase().includes(buttonIdentifier.toLowerCase())){return button}}for(const navLink of document.querySelectorAll("nav a")){if(navLink.textContent.toLowerCase().includes(buttonIdentifier.toLowerCase())){return navLink}}}();if(buttonAction=="click"){button.click()}else{return button}}}const camelCaser=words=>{return words.map((word,index)=>index===0||word=="s"?word:word.charAt(0).toUpperCase()+word.slice(1)).join("")};for(const prop in chatgpt){for(const subAliases of functionAliases){if(subAliases.includes(prop)){if(subAliases.some(element=>element.includes("."))){const nestedFunction=subAliases.find(element=>element.includes(".")).split(".")[1];for(const nestAlias of subAliases){if(/^(\w+)/.exec(nestAlias)[1]!==prop){chatgpt[nestAlias]=chatgpt[prop][nestedFunction]}}}else{for(const dirAlias of subAliases){if(dirAlias!==prop){chatgpt[dirAlias]=chatgpt[prop]}}}}}do{var newFunctionsCreated=false;for(const funcName in chatgpt){if(typeof chatgpt[funcName]=="function"){const funcWords=funcName.split(/(?=[A-Zs])/);for(const funcWord of funcWords){const synonymValues=[].concat(...synonyms.filter(arr=>arr.includes(funcWord.toLowerCase())).map(arr=>arr.filter(synonym=>synonym!==funcWord.toLowerCase())));for(const synonym of synonymValues){const newFuncName=camelCaser(funcWords.map(word=>word==funcWord?synonym:word));if(!chatgpt[newFuncName]){chatgpt[newFuncName]=chatgpt[funcName];newFunctionsCreated=true}}}}}}while(newFunctionsCreated)}const consolePrefix="🤖 chatgpt.js >> ",ogError=console.error,ogInfo=console.info;console.error=(...args)=>{if(!args[0].startsWith(consolePrefix))ogError(consolePrefix+args[0],...args.slice(1));else ogError(...args)};console.info=msg=>{if(!msg.startsWith(consolePrefix))ogInfo(consolePrefix+msg);else ogInfo(msg)};try{window.chatgpt=chatgpt}catch(err){}try{module.exports=chatgpt}catch(err){}