const endpoints={session:"https://chat.openai.com/api/auth/session",chats:"https://chat.openai.com/backend-api/conversations",chat:"https://chat.openai.com/backend-api/conversation",share_create:"https://chat.openai.com/backend-api/share/create",share:"https://chat.openai.com/backend-api/share"};var alertQueue=[];localStorage.alertQueue=JSON.stringify(alertQueue);var notifyQueue={quadrants:{topRight:[],bottomRight:[],bottomLeft:[],topLeft:[]}};localStorage.notifyQueue=JSON.stringify(notifyQueue);const chatgpt={openAIaccessToken:{},activateDarkMode:function(){document.documentElement.classList.replace("light","dark");document.documentElement.style.colorScheme="dark"},activateLightMode:function(){document.documentElement.classList.replace("dark","light");document.documentElement.style.colorScheme="light"},alert:function(title,msg,btns,checkbox,width){const modalContainer=document.createElement("div");modalContainer.id=Math.floor(chatgpt.randomFloat()*1e6)+Date.now();modalContainer.classList.add("chatgpt-modal");const modal=document.createElement("div");const modalTitle=document.createElement("h2");const modalMessage=document.createElement("p");let modalStyle;if(!document.querySelector("#chatgpt-alert-style")){modalStyle=document.createElement("style");modalStyle.id="chatgpt-alert-style";document.head.appendChild(modalStyle)}else modalStyle=document.querySelector("#chatgpt-alert-style");const scheme=chatgpt.isDarkMode()?"dark":"light";modalStyle.innerText=".chatgpt-modal {"+"position: fixed ; top: 0 ; left: 0 ; width: 100% ; height: 100% ;"+"background-color: rgba(67, 70, 72, 0.75) ;"+"display: flex ; justify-content: center ; align-items: center ; z-index: 9999 }"+".chatgpt-modal > div {"+`background-color: ${scheme=="dark"?"black":"white"} ;`+(width?`width: ${width}px`:"max-width: 458px ")+" ;"+"padding: 20px ; margin: 12px 23px ; border-radius: 5px ; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.3) }"+".chatgpt-modal h2 { margin-bottom: 9px }"+`.chatgpt-modal a { color: ${scheme=="dark"?"#00cfff":"#1e9ebb"}}`+".modal-buttons { display: flex ; justify-content: flex-end ; margin: 20px -5px -3px 0 }"+".chatgpt-modal button {"+"margin-left: 10px ; padding: 4px 18px ; border-radius: 15px ;"+`border: 1px solid ${scheme=="dark"?"white":"black"}}`+".primary-modal-btn {"+`border: 1px solid ${scheme=="dark"?"white":"black"} ;`+`background: ${scheme=="dark"?"white":"black"} ;`+`color: ${scheme=="dark"?"black":"white"}}`+".chatgpt-modal button:hover { background-color: #42B4BF ; border-color: #42B4BF ; color: black }"+".chatgpt-modal .checkbox-group { display: flex ; margin-top: -18px }"+".chatgpt-modal .checkbox-group label {"+"font-size: .7rem ; margin: -.04rem 0 0px .3rem ;"+`color: ${scheme=="dark"?"#e1e1e1":"#1e1e1e"}}`+'.chatgpt-modal input[type="checkbox"] { transform: scale(0.7) ;'+`border: 1px solid ${scheme=="dark"?"white":"black"}}`+'.chatgpt-modal input[type="checkbox"]:checked {'+`border: 1px solid ${scheme=="dark"?"white":"black"} ;`+"background-color: black ; position: inherit }"+'.chatgpt-modal input[type="checkbox"]:focus { outline: none ; box-shadow: none }';modalTitle.innerText=title||"";modalMessage.innerText=msg||"";this.renderHTML(modalMessage);const modalButtons=document.createElement("div");modalButtons.classList.add("modal-buttons");if(btns){if(!Array.isArray(btns))btns=[btns];btns.forEach(buttonFn=>{const button=document.createElement("button");button.textContent=buttonFn.name.replace(/[_-]\w/g,match=>match.slice(1).toUpperCase()).replace(/([A-Z])/g," $1").replace(/^\w/,firstChar=>firstChar.toUpperCase());button.addEventListener("click",()=>{destroyAlert();buttonFn()});modalButtons.insertBefore(button,modalButtons.firstChild)})}const dismissBtn=document.createElement("button");dismissBtn.textContent=btns?"Dismiss":"OK";dismissBtn.addEventListener("click",destroyAlert);modalButtons.insertBefore(dismissBtn,modalButtons.firstChild);modalButtons.lastChild.classList.add("primary-modal-btn");const checkboxDiv=document.createElement("div");if(checkbox){checkboxDiv.classList.add("checkbox-group");const checkboxFn=checkbox;const checkboxInput=document.createElement("input");checkboxInput.type="checkbox";checkboxInput.addEventListener("change",checkboxFn);const checkboxLabel=document.createElement("label");checkboxLabel.addEventListener("click",function(){checkboxInput.checked=!checkboxInput.checked;checkboxFn()});checkboxLabel.textContent=checkboxFn.name.charAt(0).toUpperCase()+checkboxFn.name.slice(1).replace(/([A-Z])/g,(match,letter)=>" "+letter.toLowerCase()).replace(/\b(\w+)nt\b/gi,"$1n't").trim();checkboxDiv.appendChild(checkboxInput);checkboxDiv.appendChild(checkboxLabel)}const elements=[modalTitle,modalMessage,modalButtons,checkboxDiv];elements.forEach(element=>{modal.appendChild(element)});modalContainer.appendChild(modal);document.body.appendChild(modalContainer);alertQueue=JSON.parse(localStorage.alertQueue);alertQueue.push(modalContainer.id);localStorage.alertQueue=JSON.stringify(alertQueue);document.addEventListener("keydown",keyHandler);modalContainer.addEventListener("click",event=>{if(event.target===modalContainer)destroyAlert()});modalContainer.style.display=alertQueue.length===1?"":"none";function destroyAlert(){modalContainer.remove();alertQueue=JSON.parse(localStorage.alertQueue);alertQueue.shift();localStorage.alertQueue=JSON.stringify(alertQueue);modalContainer.removeEventListener("click",destroyAlert);document.removeEventListener("keydown",keyHandler);dismissBtn.removeEventListener("click",destroyAlert);if(alertQueue.length>0){const nextAlert=document.getElementById(alertQueue[0]);setTimeout(()=>{nextAlert.style.display="flex"},500)}}function keyHandler(event){const dismissKeys=[13,27];if(dismissKeys.includes(event.keyCode)){for(const alertId of alertQueue){const alert=document.getElementById(alertId);if(alert&&alert.style.display!=="none"){if(event.keyCode===27)destroyAlert();else if(event.keyCode===13){const mainButton=alert.querySelector(".modal-buttons").lastChild;if(mainButton){mainButton.click();event.preventDefault()}}return}}}}return modalContainer.id},askAndGetReply:async function(query){chatgpt.send(query);await chatgpt.isIdle();return chatgpt.getChatData("active","msg","chatgpt","latest")},autoRefresh:{activate:function(interval){if(this.isActive){console.info("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Auto refresh already active!");return}const autoRefresh=this;this.toggle.refreshFrame();scheduleRefreshes(interval?parseInt(interval,10):30);console.info("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Auto refresh activated");if(navigator.userAgent.includes("Chrome")&&typeof document.hidden!=="undefined"){document.addEventListener("visibilitychange",this.toggle.beacons)}function scheduleRefreshes(interval){const randomDelay=Math.max(2,Math.floor(chatgpt.randomFloat()*21-10));autoRefresh.isActive=setTimeout(()=>{const manifestScript=document.querySelector('script[src*="_ssgManifest.js"]');document.querySelector("#refresh-frame").src=manifestScript.src+"?"+Date.now();console.info("↻ ChatGPT >> ["+autoRefresh.nowTimeStamp()+"] ChatGPT session refreshed");scheduleRefreshes(interval)},(interval+randomDelay)*1e3)}},deactivate:function(){if(this.isActive){this.toggle.refreshFrame();document.removeEventListener("visibilitychange",this.toggle.beacons);clearTimeout(this.isActive);this.isActive=null;console.info("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Auto refresh de-activated")}else{console.info("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Auto refresh already inactive!")}},nowTimeStamp:function(){const now=new Date;const hours=now.getHours()%12||12;let minutes=now.getMinutes(),seconds=now.getSeconds();if(minutes<10)minutes="0"+minutes;if(seconds<10)seconds="0"+seconds;const meridiem=now.getHours()<12?"AM":"PM";return hours+":"+minutes+":"+seconds+" "+meridiem},toggle:{beacons:function(){if(chatgpt.autoRefresh.beaconID){clearInterval(chatgpt.autoRefresh.beaconID);chatgpt.autoRefresh.beaconID=null;console.info("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Beacons de-activated")}else{chatgpt.autoRefresh.beaconID=setInterval(function(){navigator.sendBeacon("https://httpbin.org/post",new Uint8Array);console.info("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Beacon sent")},9e4);console.info("↻ ChatGPT >> ["+chatgpt.autoRefresh.nowTimeStamp()+"] Beacons activated")}},refreshFrame:function(){let refreshFrame=document.querySelector("#refresh-frame");if(refreshFrame)refreshFrame.remove();else{refreshFrame=Object.assign(document.createElement("iframe"),{id:"refresh-frame",style:"display: none"});document.head.prepend(refreshFrame)}}}},clearChats:async function(){try{await chatgpt.getChatData()}catch{return}const menuBtn=document.querySelector('nav button[id*="headless"]')||{};try{menuBtn.click()}catch(error){console.error("🤖 chatgpt.js >> Headless menu not found");return}setTimeout(()=>{const menuItems=document.querySelectorAll('a[role="menuitem"]')||[];for(const menuItem of menuItems)if(/settings/i.test(menuItem.text)){menuItem.click();break}setTimeout(()=>{const settingsBtns=document.querySelectorAll("[id*=radix] button");for(const settingsBtn of settingsBtns)if(/^clear/i.test(settingsBtn.textContent)){settingsBtn.click();break}setTimeout(()=>{document.querySelector("[id*=radix] button").click();setTimeout(exitMenu,10)},10)},10)},10);function exitMenu(){document.querySelector("div[id*=radix] button").click()}},exportChat:function(){const chatDivs=document.querySelectorAll("main > div > div > div > div > div[class*=group]");if(chatDivs.length===0){console.error("🤖 chatgpt.js >> Chat is empty!");return}const msgs=[];chatDivs.forEach(div=>{const sender=div.textContent.startsWith("ChatGPTChatGPT")?"CHATGPT":"USER";let msg=Array.from(div.childNodes).map(node=>node.innerText).join("\n\n").replace("Copy code","");if(sender==="CHATGPT")msg=msg.replace(/^ChatGPT\n\n/,"");msgs.push(sender+": "+msg)});const blob=new Blob([msgs.join("\n\n")],{type:"text/plain"});const now=new Date;const day=now.getDate().toString().padStart(2,"0");const month=(now.getMonth()+1).toString().padStart(2,"0");const year=now.getFullYear();const hour=now.getHours().toString().padStart(2,"0");const minute=now.getMinutes().toString().padStart(2,"0");const filename=`ChatGPT_${day}-${month}-${year}_${hour}-${minute}.txt`;const url=URL.createObjectURL(blob),link=document.createElement("a");link.href=url;link.download=filename;document.body.appendChild(link);link.click();document.body.removeChild(link);URL.revokeObjectURL(url)},generateRandomIP:function(){const ip=Array.from({length:4},()=>Math.floor(chatgpt.randomFloat()*256)).join(".");console.info("🤖 chatgpt.js >> IP generated: "+ip);return ip},get:function(targetType,targetName=""){if(typeof targetType!=="string"||typeof targetName!=="string"){throw new TypeError("Invalid arguments. Both arguments must be strings.")}if(!targetTypes.includes(targetType.toLowerCase())){throw new Error("Invalid targetType: "+targetType+". Valid values are: "+JSON.stringify(targetTypes))}const targetNames=[],reTargetName=new RegExp("^get(.*)"+targetType+"$","i");for(const prop in chatgpt){if(typeof chatgpt[prop]==="function"&&reTargetName.test(prop)){targetNames.push(prop.replace(reTargetName,"$1").toLowerCase())}}if(!targetNames.includes(targetName.toLowerCase())){throw new Error("Invalid targetName: "+targetName+". "+(targetNames.length>0?"Valid values are: "+JSON.stringify(targetNames):"targetType "+targetType.toLowerCase()+" does not require additional options."))}const targetFuncNameLower=("get"+targetName+targetType).toLowerCase();const targetFuncName=Object.keys(this).find(function(name){return name.toLowerCase()===targetFuncNameLower});return this[targetFuncName]()},getAccessToken:function(){return new Promise((resolve,reject)=>{if(Object.keys(chatgpt.openAIaccessToken).length>0&&Date.parse(chatgpt.openAIaccessToken.expireDate)-Date.parse(new Date)>=0)return resolve(chatgpt.openAIaccessToken.token);const xhr=new XMLHttpRequest;xhr.open("GET",endpoints.session,true);xhr.setRequestHeader("Content-Type","application/json");xhr.onload=()=>{if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot retrieve access token.");console.info("🤖 chatgpt.js >> Token expiration: "+new Date(JSON.parse(xhr.responseText).expires).toLocaleString().replace(","," at"));chatgpt.openAIaccessToken={token:JSON.parse(xhr.responseText).accessToken,expireDate:JSON.parse(xhr.responseText).expires};return resolve(chatgpt.openAIaccessToken.token)};xhr.send()})},getAccountDetails:function(...details){const validDetails=["email","id","image","name","picture"];details=!arguments[0]?validDetails:Array.isArray(arguments[0])?arguments[0]:Array.from(arguments);for(const detail of details){if(!validDetails.includes(detail)){return console.error("🤖 chatgpt.js >> Invalid detail arg '"+detail+"' supplied. Valid details are:\n"+"                    ["+validDetails+"]")}}return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;xhr.open("GET",endpoints.session,true);xhr.setRequestHeader("Content-Type","application/json");xhr.onload=()=>{if(xhr.status===200){const data=JSON.parse(xhr.responseText).user,detailsToReturn={};for(const detail of details)detailsToReturn[detail]=data[detail];return resolve(detailsToReturn)}else return reject("🤖 chatgpt.js >> Request failed. Cannot retrieve account details.")};xhr.send()})},getChatBox:function(){return document.getElementById("prompt-textarea")},getChatData:function(chatToGet=1,detailsToGet="all",sender="all",msgToGet="all"){const validDetails=["all","id","title","create_time","update_time","msg"];const validSenders=["all","both","user","chatgpt"];chatToGet=!chatToGet?"active":Number.isInteger(chatToGet)||/^\d+$/.test(chatToGet)?parseInt(chatToGet,10)===0?0:parseInt(chatToGet,10)-1:chatToGet;detailsToGet=["all",""].includes(detailsToGet)?validDetails.filter(detail=>/^(?!all$|msg$).*/.test(detail)):Array.isArray(detailsToGet)?detailsToGet:[detailsToGet];sender=!sender?"all":validSenders.includes(sender)?sender:"invalid";msgToGet=Number.isInteger(msgToGet)||/^\d+$/.test(msgToGet)?parseInt(msgToGet,10)===0?0:parseInt(msgToGet,10)-1:["all","latest"].includes(msgToGet.toLowerCase())?msgToGet.toLowerCase():!msgToGet?"all":"invalid";for(const detail of detailsToGet){if(!validDetails.includes(detail)){return console.error("🤖 chatgpt.js >> Invalid detail arg '"+detail+"' passed. Valid details are:\n"+"                    ["+validDetails+"]")}}if(sender==="invalid"){return console.error("🤖 chatgpt.js >> Invalid sender arg passed. Valid senders are:\n"+"                    ["+validSenders+"]")}if(msgToGet==="invalid"){return console.error("🤖 chatgpt.js >> Invalid msgToGet arg passed. Valid msg's to get are:\n"+"                    [ 'all' | 'latest' | index of msg to get ]")}return new Promise(resolve=>{chatgpt.getAccessToken().then(token=>{if(!detailsToGet.includes("msg"))getChatDetails(token,detailsToGet).then(data=>{return resolve(data)});else getChatMsgs(token).then(messages=>{return resolve(messages)})})});function getChatDetails(token,detailsToGet){const re_chatID=/\w{8}-(\w{4}-){3}\w{12}/;return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;xhr.open("GET",endpoints.chats,true);xhr.setRequestHeader("Content-Type","application/json");xhr.setRequestHeader("Authorization","Bearer "+token);xhr.onload=()=>{if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot retrieve chat details.");const data=JSON.parse(xhr.responseText).items;if(data.length<=0)return reject("🤖 chatgpt.js >> Chat list is empty.");const detailsToReturn={};if(Number.isInteger(chatToGet)||chatToGet=="latest"||chatToGet=="active"&&!new RegExp("/"+re_chatID.source+"$").test(window.location.href)){chatToGet=Number.isInteger(chatToGet)?chatToGet:0;if(chatToGet>data.length){return reject("🤖 chatgpt.js >> Chat with index "+(chatToGet+1)+" is out of bounds. Only "+data.length+" chats exist!")}for(const detail of detailsToGet)detailsToReturn[detail]=data[chatToGet][detail];return resolve(detailsToReturn)}const chatIdentifier=chatToGet=="active"||new RegExp("^"+re_chatID.source+"$").test(chatToGet)?"id":"title";if(chatToGet=="active")chatToGet=re_chatID.exec(window.location.href)[0];let idx,chatFound;for(idx=0;idx<data.length;idx++){if(data[idx][chatIdentifier]===chatToGet){chatFound=true;break}}if(!chatFound)return reject("🤖 chatgpt.js >> No chat with "+chatIdentifier+" = "+chatToGet+" found.");for(const detail of detailsToGet)detailsToReturn[detail]=data[idx][detail];return resolve(detailsToReturn)};xhr.send()})}function getChatMsgs(token){return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;getChatDetails(token,["id"]).then(chat=>{xhr.open("GET",`${endpoints.chat}/${chat.id}`,true);xhr.setRequestHeader("Content-Type","application/json");xhr.setRequestHeader("Authorization","Bearer "+token);xhr.onload=()=>{if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot retrieve chat messages.");const data=JSON.parse(xhr.responseText).mapping;const userMessages=[],chatGPTMessages=[],msgsToReturn=[];for(const key in data)if("message"in data[key]&&data[key].message.author.role==="user")userMessages.push({id:data[key].id,msg:data[key].message});userMessages.sort((a,b)=>a.msg.create_time-b.msg.create_time);if(parseInt(msgToGet,10)+1>userMessages.length)return reject("🤖 chatgpt.js >> Message/response with index "+(msgToGet+1)+" is out of bounds. Only "+userMessages.length+" messages/responses exist!");for(const userMessage of userMessages){let sub=[];for(const key in data){if("message"in data[key]&&data[key].message.author.role==="assistant"&&data[key].parent===userMessage.id){sub.push(data[key].message)}}sub.sort((a,b)=>a.create_time-b.create_time);sub=sub.map(x=>x.content.parts[0]);sub=sub.length===1?sub[0]:sub;chatGPTMessages.push(sub)}if(sender==="user")for(const userMessage in userMessages)msgsToReturn.push(userMessages[userMessage].msg.content.parts[0]);else if(sender==="chatgpt")for(const chatGPTMessage of chatGPTMessages)msgsToReturn.push(msgToGet==="latest"?chatGPTMessages[chatGPTMessages.length-1]:chatGPTMessage);else{let i=0;for(const message in userMessages){msgsToReturn.push({user:userMessages[message].msg.content.parts[0],chatgpt:msgToGet==="latest"?chatGPTMessages[i][chatGPTMessages[i].length-1]:chatGPTMessages[i]});i++}}return resolve(msgToGet==="all"?msgsToReturn:msgToGet==="latest"?msgsToReturn[msgsToReturn.length-1]:msgsToReturn[msgToGet])};xhr.send()})})}},getChatInput:function(){return chatgpt.getChatBox().value},getContinueGeneratingButton:function(){for(const formButton of document.querySelectorAll("form button")){if(formButton.textContent.toLowerCase().includes("continue")){return formButton}}},getLastPrompt:function(){return chatgpt.getChatData("active","msg","user","latest")},getLastResponse:function(){return chatgpt.getChatData("active","msg","chatgpt","latest")},getNewChatLink:function(){for(const navLink of document.querySelectorAll('nav[aria-label="Chat history"] a')){if(/(new|clear) chat/i.test(navLink.text)){return navLink}}},getRegenerateButton:function(){for(const formButton of document.querySelectorAll("form button")){if(formButton.textContent.toLowerCase().includes("regenerate")){return formButton}}},getResponse:function(){if(window.location.href.startsWith("https://chat.openai.com/c/"))return chatgpt.getResponseFromDOM.apply(null,arguments);else return chatgpt.getResponseFromAPI.apply(null,arguments)},getResponseFromAPI:function(chatToGet,responseToGet){return chatgpt.response.getFromAPI(chatToGet,responseToGet)},getResponseFromDOM:function(pos){return chatgpt.response.getFromDOM(pos)},getSendButton:function(){return document.querySelector('form button[class*="bottom"]')},getStopGeneratingButton:function(){for(const formButton of document.querySelectorAll("form button")){if(formButton.textContent.toLowerCase().includes("stop")){return formButton}}},getUserLanguage:function(){return navigator.languages[0]||navigator.language||navigator.browserLanguage||navigator.systemLanguage||navigator.userLanguage||""},history:{isOn:function(){for(const navLink of document.querySelectorAll('nav[aria-label="Chat history"] a')){if(/clear chat/i.test(navLink.text))return false}return true},isOff:function(){return!this.isOn()},activate:function(){this.isOff()?this.toggle():console.info("🤖 chatgpt.js >> Chat history is already enabled!")},deactivate:function(){this.isOn()?this.toggle():console.info("🤖 chatgpt.js >> Chat history is already disabled!")},toggle:function(){for(const navBtn of document.querySelectorAll('nav[aria-label="Chat history"] button')){if(/chat history/i.test(navBtn.textContent))navBtn.click();return}}},isDarkMode:function(){return document.documentElement.classList.contains("dark")},isFullScreen:function(){const userAgentStr=navigator.userAgent;return userAgentStr.includes("Chrome")?window.matchMedia("(display-mode: fullscreen)").matches:userAgentStr.includes("Firefox")?window.fullScreen:/MSIE|rv:/.test(userAgentStr)?document.msFullscreenElement:document.webkitIsFullScreen},isIdle:function(){return new Promise(resolve=>{const intervalId=setInterval(()=>{if(chatgpt.getRegenerateButton()){clearInterval(intervalId);resolve()}},100)})},isLoaded:function(){return new Promise(resolve=>{const intervalId=setInterval(()=>{if(document.querySelector('nav button[id*="menu"]')){clearInterval(intervalId);resolve()}},100)})},isLightMode:function(){return document.documentElement.classList.contains("light")},logout:function(){const menuBtn=document.querySelector('nav button[id*="headless"]')||{};try{menuBtn.click()}catch(error){console.error("🤖 chatgpt.js >> Headless menu not found");return}setTimeout(()=>{const menuItems=document.querySelectorAll('a[role="menuitem"]')||[];for(const menuItem of menuItems){if(/log out/i.test(menuItem.textContent)){menuItem.click();break}}},10)},notify:function(msg,position,notifDuration,shadow){notifDuration=notifDuration?+notifDuration:1.75;const fadeDuration=.6;const vpYoffset=23,vpXoffset=27;const notificationDiv=document.createElement("div");notificationDiv.id=Math.floor(chatgpt.randomFloat()*1e6)+Date.now();notificationDiv.style.cssText=" background-color: black ; padding: 10px ; border-radius: 8px ; "+" opacity: 0 ; position: fixed ; z-index: 9999 ; font-size: 1.8rem ; color: white ; "+" -webkit-user-select: none ; -moz-user-select: none ; -ms-user-select: none ; user-select: none ; "+(shadow?"box-shadow: -8px 13px 25px 0 "+(/\b(shadow|on)\b/gi.test(shadow)?"gray":shadow):"");document.body.appendChild(notificationDiv);notificationDiv.isTop=!position||!/low|bottom/i.test(position);notificationDiv.isRight=!position||!/left/i.test(position);notificationDiv.quadrant=(notificationDiv.isTop?"top":"bottom")+(notificationDiv.isRight?"Right":"Left");notifyQueue=JSON.parse(localStorage.notifyQueue);notifyQueue.quadrants[notificationDiv.quadrant].push(notificationDiv.id);localStorage.notifyQueue=JSON.stringify(notifyQueue);notificationDiv.style.top=notificationDiv.isTop?vpYoffset.toString()+"px":"";notificationDiv.style.bottom=!notificationDiv.isTop?vpYoffset.toString()+"px":"";notificationDiv.style.right=notificationDiv.isRight?vpXoffset.toString()+"px":"";notificationDiv.style.left=!notificationDiv.isRight?vpXoffset.toString()+"px":"";const thisQuadrantDivIDs=notifyQueue.quadrants[notificationDiv.quadrant];if(thisQuadrantDivIDs.length>1){try{for(const divId of thisQuadrantDivIDs.slice(0,-1)){const oldDiv=document.getElementById(divId);const offsetProp=oldDiv.style.top?"top":"bottom";const vOffset=+/\d+/.exec(oldDiv.style[offsetProp])[0]+5+oldDiv.getBoundingClientRect().height;oldDiv.style[offsetProp]=`${vOffset}px`}}catch(error){}}notificationDiv.innerText=msg;notificationDiv.style.transition="none";notificationDiv.style.opacity=1;const hideDelay=fadeDuration>notifDuration?0:notifDuration-fadeDuration;notificationDiv.hideTimer=setTimeout(()=>{notificationDiv.style.transition="opacity "+fadeDuration.toString()+"s";notificationDiv.style.opacity=0;notificationDiv.hideTimer=null},hideDelay*1e3);notificationDiv.destroyTimer=setTimeout(()=>{notificationDiv.remove();notifyQueue=JSON.parse(localStorage.notifyQueue);notifyQueue.quadrants[notificationDiv.quadrant].shift();localStorage.notifyQueue=JSON.stringify(notifyQueue);notificationDiv.destroyTimer=null},Math.max(fadeDuration,notifDuration)*1e3)},printAllFunctions:function(){const functionNames=[];for(const prop in this){if(typeof this[prop]==="function"){const chatgptIsParent=!Object.keys(this).find(obj=>Object.keys(this[obj]).includes(this[prop].name));const functionParent=chatgptIsParent?"chatgpt":"other";functionNames.push([functionParent,prop])}else if(typeof this[prop]==="object"){for(const nestedProp in this[prop]){if(typeof this[prop][nestedProp]==="function"){functionNames.push([prop,nestedProp])}}}}functionNames.sort(function(a,b){return a[0].localeCompare(b[0])||a[1].localeCompare(b[1])});for(const functionName of functionNames){console.info("🤖 chatgpt.js >> "+(/chatgpt|other/.test(functionName[0])?"":functionName[0]+".")+functionName[1]+": ["+(functionName[0]==="chatgpt"&&functionName[1]===this[functionName[1]].name||!/chatgpt|other/.test(functionName[0])?"Function":"Alias of")+": "+(functionName[0]==="chatgpt"?this[functionName[1]].name:functionName[0]!=="other"?functionName[0]+"."+functionName[1]:Object.keys(this).find(obj=>Object.keys(this[obj]).includes(this[functionName[1]].name))+"."+this[functionName[1]].name)+"]")}},randomFloat:function(){const crypto=window.crypto||window.msCrypto;return crypto.getRandomValues(new Uint32Array(1))[0]/4294967295},regenerate:function(){for(const formButton of document.querySelectorAll("form button")){if(formButton.textContent.toLowerCase().includes("regenerate")){formButton.click();return}}},renderHTML:function(node){const reTags=/<([a-z\d]+)\b([^>]*)>([\s\S]*?)<\/\1>/g;const reAttributes=/(\S+)=['"]?((?:.(?!['"]?\s+(?:\S+)=|[>']))+.)['"]?/g;const nodeContent=node.childNodes;if(!this.renderHTML.preWrapSet){node.style.whiteSpace="pre-wrap";this.renderHTML.preWrapSet=true;setTimeout(()=>{this.renderHTML.preWrapSet=false},100)}for(const childNode of nodeContent){if(childNode.nodeType===Node.TEXT_NODE){const text=childNode.nodeValue;const elems=Array.from(text.matchAll(reTags));if(elems.length>0){const elem=elems[0];const[tagContent,tagName,tagAttributes,tagText]=elem.slice(0,4);const tagNode=document.createElement(tagName);tagNode.textContent=tagText;const attributes=Array.from(tagAttributes.matchAll(reAttributes));attributes.forEach(attribute=>{const name=attribute[1],value=attribute[2].replace(/['"]/g,"");tagNode.setAttribute(name,value)});const renderedNode=this.renderHTML(tagNode);const beforeTextNode=document.createTextNode(text.substring(0,elem.index));const afterTextNode=document.createTextNode(text.substring(elem.index+tagContent.length));node.replaceChild(beforeTextNode,childNode);node.insertBefore(renderedNode,beforeTextNode.nextSibling);node.insertBefore(afterTextNode,renderedNode.nextSibling)}}else if(childNode.nodeType===Node.ELEMENT_NODE)this.renderHTML(childNode)}return node},resend:async function(){chatgpt.send(await chatgpt.getChatData("latest","msg","user","latest"))},response:{get:function(){if(window.location.href.startsWith("https://chat.openai.com/c/"))return this.getFromDOM.apply(null,arguments);else return this.getFromAPI.apply(null,arguments)},getFromAPI:function(chatToGet,responseToGet){chatToGet=chatToGet||"latest";responseToGet=responseToGet||"latest";return chatgpt.getChatData(chatToGet,"msg","chatgpt",responseToGet)},getFromDOM:function(pos){const responseDivs=document.querySelectorAll("main > div > div > div > div > div[class*=group]");const strPos=pos.toString().toLowerCase();if(/last|final/.test(strPos)){return responseDivs.length?responseDivs[responseDivs.length-1].textContent:""}else{const nthOfResponse=Number.isInteger(pos)?pos:/^\d+/.test(strPos)?/^\d+/.exec(strPos)[0]:(/^(1|one|fir)(st)?$/.test(strPos)?1:/^(2|tw(o|en|el(ve|f))|seco)(nd|t[yi])?(e?th)?$/.test(strPos)?2:/^(3|th(ree|ir?))(rd|teen|t[yi])?(e?th)?$/.test(strPos)?3:/^(4|fou?r)(teen|t[yi])?(e?th)?$/.test(strPos)?4:/^(5|fi(ve|f))(teen|t[yi])?(e?th)?$/.test(strPos)?5:/^(6|six)(teen|t[yi])?(e?th)?$/.test(strPos)?6:/^(7|seven)(teen|t[yi])?(e?th)?$/.test(strPos)?7:/^(8|eight?)(teen|t[yi])?(e?th)?$/.test(strPos)?8:/^(9|nine?)(teen|t[yi])?(e?th)?$/.test(strPos)?9:/^(10|ten)(th)?$/.test(strPos)?10:1)*(/(ty|ieth)$/.test(strPos)?10:1)+(/teen(th)?$/.test(strPos)?10:0);return responseDivs.length?responseDivs[nthOfResponse-1].textContent:""}},getLast:function(){return chatgpt.getChatData("active","msg","chatgpt","latest")},regenerate:function(){for(const formButton of document.querySelectorAll("form button")){if(formButton.textContent.toLowerCase().includes("regenerate")){formButton.click();return}}},stopGenerating:function(){for(const formButton of document.querySelectorAll("form button")){if(formButton.textContent.toLowerCase().includes("stop")){formButton.click();return}}}},scheme:{isDark:function(){return document.documentElement.classList.contains("dark")},isLight:function(){return document.documentElement.classList.contains("light")},toggle:function(){const[schemeToRemove,schemeToAdd]=this.isDark()?["dark","light"]:["light","dark"];document.documentElement.classList.replace(schemeToRemove,schemeToAdd);document.documentElement.style.colorScheme=schemeToAdd}},scrollToBottom:function(){try{document.querySelector('button[class*="cursor"][class*="bottom"]').click()}catch(error){console.error("🤖 chatgpt.js >> ",error)}},send:function(msg,method=""){const textArea=document.querySelector("form textarea");const sendButton=document.querySelector('form button[class*="bottom"]');textArea.value=msg;textArea.dispatchEvent(new Event("input",{bubbles:true}));const delaySend=setInterval(()=>{if(!sendButton.hasAttribute("disabled")){method.toLowerCase()=="click"?sendButton.click():textArea.dispatchEvent(new KeyboardEvent("keydown",{keyCode:13,bubbles:true}));clearInterval(delaySend)}},25)},sendInNewChat:function(msg){for(const navLink of document.querySelectorAll('nav[aria-label="Chat history"] a')){if(/(new|clear) chat/i.test(navLink.text)){navLink.click();break}}setTimeout(()=>{chatgpt.send(msg)},500)},shareChat:function(chatToGet,method="clipboard"){const validMethods=["alert","notify","notification","clipboard","copy"];if(!validMethods.includes(method))return console.error("🤖 chatgpt.js >> Invalid method '"+method+"' passed. Valid methods are ["+validMethods+"].");return new Promise(resolve=>{chatgpt.getAccessToken().then(token=>{getChatNode(token).then(node=>{makeChatToShare(token,node).then(data=>{confirmShareChat(token,data).then(()=>{resolve();if(["copy","clipboard"].includes(method))navigator.clipboard.writeText(data.share_url);else chatgpt.alert("🚀 Share link created!",'"'+data.title+'" is available at: <a target="blank" rel="noopener" href="'+data.share_url+'" >'+data.share_url+"</a>",[function openLink(){window.open(data.share_url,"_blank","noopener")},function copyLink(){navigator.clipboard.writeText(data.share_url)}])})})})})});function getChatNode(token){return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;chatgpt.getChatData(chatToGet).then(chat=>{xhr.open("GET",`${endpoints.chat}/${chat.id}`,true);xhr.setRequestHeader("Content-Type","application/json");xhr.setRequestHeader("Authorization","Bearer "+token);xhr.onload=()=>{if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot retrieve chat node.");return resolve(JSON.parse(xhr.responseText).current_node)};xhr.send()})})}function makeChatToShare(token,node){return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;chatgpt.getChatData(chatToGet).then(chat=>{xhr.open("POST",endpoints.share_create,true);xhr.setRequestHeader("Content-Type","application/json");xhr.setRequestHeader("Authorization","Bearer "+token);xhr.onload=()=>{if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot initialize share chat.");return resolve(JSON.parse(xhr.responseText))};xhr.send(JSON.stringify({current_node_id:node,conversation_id:chat.id,is_anonymous:true}))})})}function confirmShareChat(token,data){return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;xhr.open("PATCH",`${endpoints.share}/${data.share_id}`,true);xhr.setRequestHeader("Content-Type","application/json");xhr.setRequestHeader("Authorization","Bearer "+token);xhr.onload=()=>{if(xhr.status!==200)return reject("🤖 chatgpt.js >> Request failed. Cannot share chat.");console.info(`🤖 chatgpt.js >> Chat shared at '${data.share_url}'`);return resolve()};xhr.send(JSON.stringify({share_id:data.share_id,highlighted_message_id:data.highlighted_message_id,title:data.title,is_public:true,is_visible:data.is_visible,is_anonymous:data.is_anonymous}))})}},sidebar:{isOn:function(){return!document.querySelector('button[aria-label*="Open sidebar"]')},isOff:function(){return!!document.querySelector('button[aria-label*="Open sidebar"]')},hide:function(){this.isOn()?this.toggle():console.info("🤖 chatgpt.js >> Sidebar already hidden!")},show:function(){this.isOff()?this.toggle():console.info("🤖 chatgpt.js >> Sidebar already shown!")},toggle:function(){for(const navLink of document.querySelectorAll('nav[aria-label="Chat history"] a')){if(/close sidebar/i.test(navLink.text)){navLink.click();return}}}},startNewChat:function(){for(const navLink of document.querySelectorAll('nav[aria-label="Chat history"] a')){if(/(new|clear) chat/i.test(navLink.text)){navLink.click();return}}},stop:function(){for(const formButton of document.querySelectorAll("form button")){if(formButton.textContent.toLowerCase().includes("stop")){formButton.click();return}}},speak:function(msg,options={}){const{voice=2,pitch=2,speed=1.1}=options;for(let key in options){const value=options[key];if(typeof value!=="number"&&!/^\d+$/.test(value))return console.error(`🤖 chatgpt.js >> Invalid ${key} index '${value}'. Must be a number`)}try{const voices=speechSynthesis.getVoices(),utterance=new SpeechSynthesisUtterance;utterance.text=msg;utterance.voice=voices[voice];utterance.pitch=pitch;utterance.rate=speed;speechSynthesis.speak(utterance)}catch(error){console.error("🤖 chatgpt.js >>",error)}},toggleScheme:function(){const[schemeToRemove,schemeToAdd]=document.documentElement.classList.contains("dark")?["dark","light"]:["light","dark"];document.documentElement.classList.replace(schemeToRemove,schemeToAdd);document.documentElement.style.colorScheme=schemeToAdd},uuidv4:function(){let d=(new Date).getTime();const uuid="xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,c=>{const r=(d+window.crypto.getRandomValues(new Uint32Array(1))[0]/(Math.pow(2,32)-1)*16)%16|0;d=Math.floor(d/16);return(c=="x"?r:r&3|8).toString(16)});return uuid}};const buttonActions=["click","get"],targetTypes=["button","link","div","response"];for(const buttonAction of buttonActions){chatgpt[buttonAction+"Button"]=function handleButton(buttonIdentifier){const button=/^[.#]/.test(buttonIdentifier)?document.querySelector(buttonIdentifier):/send/i.test(buttonIdentifier)?document.querySelector('form button[class*="bottom"]'):/scroll/i.test(buttonIdentifier)?document.querySelector('button[class*="cursor"]'):function(){for(const button of document.querySelectorAll("button")){if(button.textContent.toLowerCase().includes(buttonIdentifier.toLowerCase())){return button}}for(const navLink of document.querySelectorAll("nav a")){if(navLink.textContent.toLowerCase().includes(buttonIdentifier.toLowerCase())){return navLink}}}();if(buttonAction==="click"){button.click()}else{return button}}}const functionAliases=[["activateAutoRefresh","activateAutoRefresher","activateRefresher","activateSessionRefresher","autoRefresh","autoRefresher","autoRefreshSession","refresher","sessionRefresher"],["deactivateAutoRefresh","deactivateAutoRefresher","deactivateRefresher","deactivateSessionRefresher"],["exportChat","chatExport"],["getLastPrompt","getLastQuery","getMyLastMsg","getMyLastQuery"],["getTextarea","getTextArea","getChatbox","getChatBox"],["isFullScreen","isFullscreen"],["logOut","logout","logOff","logoff","signOut","signout","signOff","signoff"],["new","newChat","startNewChat"],["printAllFunctions","showAllFunctions"],["refreshSession","sessionRefresh"],["refreshReply","regenerate","regenerateReply"],["renderHTML","renderHtml","renderLinks","renderTags"],["send","sendChat","sendMsg"],["sendInNewChat","sendNewChat"],["stop","stopGenerating"],["toggleScheme","toggleMode"],["toggleAutoRefresh","toggleAutoRefresher","toggleRefresher","toggleSessionRefresher"]];const synonyms=[["activate","turnOn"],["account","acct"],["ask","send","submit"],["chat","conversation","convo"],["data","details"],["deactivate","deActivate","turnOff"],["generating","generation"],["render","parse"],["reply","response"],["speak","say","speech","talk","tts"]];for(const prop in chatgpt){for(const subAliases of functionAliases){if(subAliases.includes(prop)){if(subAliases.some(element=>element.includes("."))){const nestedFunction=subAliases.find(element=>element.includes(".")).split(".")[1];for(const nestAlias of subAliases){if(/^(\w+)/.exec(nestAlias)[1]!==prop){chatgpt[nestAlias]=chatgpt[prop][nestedFunction]}}}else{for(const dirAlias of subAliases){if(dirAlias!==prop){chatgpt[dirAlias]=chatgpt[prop]}}}}}do{var newFunctionsCreated=false;for(const funcName in chatgpt){if(typeof chatgpt[funcName]==="function"){const funcWords=funcName.split(/(?=[A-Zs])/);for(const funcWord of funcWords){const synonymValues=[].concat(...synonyms.filter(arr=>arr.includes(funcWord.toLowerCase())).map(arr=>arr.filter(synonym=>synonym!==funcWord.toLowerCase())));for(const synonym of synonymValues){const newWords=[...funcWords];newWords[newWords.indexOf(funcWord)]=synonym;const newFuncName=newWords.map((newWord,index)=>index===0||newWord==="s"?newWord:newWord.charAt(0).toUpperCase()+newWord.slice(1)).join("");if(!chatgpt[newFuncName]){chatgpt[newFuncName]=chatgpt[funcName];newFunctionsCreated=true}}}}}}while(newFunctionsCreated)}try{window.chatgpt=chatgpt}catch(error){}try{module.exports=chatgpt}catch(error){}