import type { FormSchema } from "formbuilder-core";

export const mockForm: FormSchema = {
	id: 1,
	settings: {
		importAliasComponents: "aa",
		importAliasUtils: "az",
		noDescription: false,
		noPlaceholder: false,
	},
	framework: "next",
	name: "User Registration Form",
	fields: [
		[
			{
				id: "username",
				label: "Username",
				placeholder: "username",
				key: "username",
				kind: "text",
				variant: "next-shadcn-text-input",
				defaultValue: "",
				required: true,
				validation: { min: 1, max: 255 },
			},
			{
				id: "mmm",
				label: "Number",
				key: "myNumber",
				kind: "number",
				variant: "next-shadcn-number-input",
				required: true,
				validation: { min: 1, max: 9999 },
			},
		],
		[
			{
				id: "email",
				label: "Email",
				key: "email",
				kind: "text",
				variant: "next-shadcn-text-markdown",
				required: true,
				defaultValue: "",
				validation: { min: 1, max: 255, email: true },
			},
			{
				id: "bool",
				label: "Security emails",
				description: "Receive emails about your account security.",
				key: "securityEmails",
				defaultValue: false,
				kind: "boolean",
				variant: "next-shadcn-boolean-toggle",
				required: true,
			},
		],
		[
			{
				id: "dateee",
				label: "Date of birth",
				placeholder: "Pick a date",
				description: "Your date of birth is used to calculate your age.",
				key: "dateOfBirth",
				kind: "date",
				variant: "next-shadcn-date-calendar-picker",
				required: true,
			},
			{
				id: "aeenum",
				label: "Notify me about",
				key: "notify",
				enumValues: [
					{
						id: Date.now().toString(),
						label: "All new messages",
						value: "all",
					},
					{
						id: Date.now().toString(),
						label: "Direct messages and mentions",
						value: "dm",
					},
					{ id: Date.now().toString(), label: "Nothing", value: "none" },
				],
				kind: "enum",
				variant: "next-shadcn-enum-radio",
				enumName: "languagee",
				required: true,
			},
		],
		[
			{
				id: "enum",
				label: "Language",
				description: "This is the language that will be used in the dashboard.",
				key: "language",
				enumName: "language",
				enumValues: [
					{ id: Date.now().toString(), label: "English", value: "en" },
					{ id: Date.now().toString(), label: "Arabic", value: "ar" },
					{ id: Date.now().toString(), label: "Kurdish", value: "ku" },
				],
				kind: "enum",
				variant: "next-shadcn-enum-combobox",
				required: true,
			},
			{
				id: "enummm",
				label: "Language",
				description: "Select a language",
				placeholder: "Select a value",
				key: "languageSelect",
				enumValues: [
					{ id: Date.now().toString(), label: "English", value: "en" },
					{ id: Date.now().toString(), label: "Arabic", value: "ar" },
					{ id: Date.now().toString(), label: "Kurdish", value: "ku" },
				],
				enumName: "languageee",
				kind: "enum",
				variant: "next-shadcn-enum-combobox",
				required: true,
			},
		],
	],
};
