# 🤔 Q & A

## TA 如何区分会话？

根据 **群组** _(群聊场景)_ 、**私聊** _(个人)_ 区分会话，即 **同一群组内共享**一个会话，**私聊窗口独占**一个会话。**不同人格**的会话和记忆**完全独立**

## TA 是如何产生回复的？

TA 会根据下面的信息**生成 prompt 模板**：

- **对话上下文** _(即最近几条聊天记录 不论是否与 TA 相关)_
- **过往记忆** _(过去聊天记录的总结)_
- 发起 `@` 或 `提及` 的**用户印象** _(根据与该用户的聊天记录总结)_

然后通过 OpenAI 的接口产生对应的回复发送，并且把产生的回复再填加入相应的聊天记录中

## TA 如何记忆用户印象？

TA 会根据下面的信息自动**总结**产生对每个用户的印象：

- 用户对 TA 发起 `@` 或 `提及` 的**聊天记录**
- **历史印象**
- **API 响应**

该印象记录**与会话无关** (即多个会话共享)，但**各个人格**之间信息**相互独立**

## 插件如何实现记录持久化保存？

由于本项目的记忆保存与人格预设存在一定耦合，  
故使用了 `pickle` (新版本默认使用 `json`) 直接对程序中使用的数据信息进行**序列化后保存为本地文件**，然后在程序启动的时候加载

这样做的好处是代码实现简便，  
但由于运行过程数据信息几乎都保存在内存中，  
如果您的 bot 活跃**用户过多** _(>1K)_ 、或者**人格预设过多** _(>100)_ ，可能会造成**一定的性能负担**，  
**敬请见谅！**

## 为什么我在编辑了配置文件中的人格预设信息后重载插件，编辑没有生效？

由于用户数据信息与人格预设信息高度绑定，如果已经生成过数据文件后插件**不会再读取配置文件中人格预设的修改**，而是会**直接读取已有的数据文件**中的信息

您可以尝试以下方案：

- **使用 [人格指令](commands.md#人格指令)** 根据响应提示直接进行编辑
- **直接删除数据文件** 后重载程序重新生成 (注意：**该方法会造成 bot 记忆丢失**)
- 如果你的数据文件为 `json` 格式，则可以选择**手动编辑数据文件** (**如果不懂请不要轻易编辑！**)

## 为什么出现出现验证错误，无法自动生成config/naturel_gpt_config.yml文件？

通过pip安装下载的nb-cli会采用新的pydantic v2版本语法，与现有代码的写法冲突。可通过降级pydantic 到v1解决。

```pip install --force-reinstall 'pydantic~=1.10'```

参考来源：https://nonebot.dev/docs/appendices/config
