import { defineConfig, devices } from '@playwright/test';

export default defineConfig({
    // Look for test files in the "tests" directory, relative to this configuration file.
    testDir: 'e2e',

    // Run all tests in parallel.
    fullyParallel: true,

    // Retry on CI only.
    retries: 2,
    timeout: 10 * 1000,
    reporter: [['html', { open: 'never', outputFolder: 'dist' }]],
    projects: [
        {
            name: 'webkit',
            use: { ...devices['Desktop Safari'] },
        },
        // {
        //     name: 'chromium',
        //     use: { ...devices['Desktop Chrome'] },
        // },
        // {
        //     name: 'firefox',
        //     use: { ...devices['Desktop Firefox'] },
        // },
    ],
});
