import { InputTemplate } from '../../interface';

/** 创建头部的注释字符串, 包含版本信息和字体的头部信息 */
export const createHeaderComment = (
    fontData: Record<string, string>,
    opts: InputTemplate['css'],
) => {
    const commentSetting = opts?.comment || {};
    if (opts?.comment === false) return '';
    const nameTableString =
        commentSetting.nameTable !== false
            ? '\nOrigin File Name Table:\n' +
              Object.entries(fontData)
                  .map((i) => i.join(': '))
                  .join('\n')
            : '';
    const baseMessage =
        commentSetting.base !== false
            ? `Generated By cn-font-split@${__cn_font_split_version__} https://www.npmjs.com/package/cn-font-split` +
              `\nCreateTime: ${new Date().toUTCString()};`
            : '';
    const header = `/* ` + baseMessage + nameTableString + '\n */\n\n';
    return header;
};
