﻿using System.ComponentModel;
using System.Windows;

namespace ModernWpf.DesignTime
{
    public static class Design
    {
        #region RequestedTheme

        public static ElementTheme GetRequestedTheme(FrameworkElement element)
        {
            return (ElementTheme)element.GetValue(RequestedThemeProperty);
        }

        public static void SetRequestedTheme(FrameworkElement element, ElementTheme value)
        {
            element.SetValue(RequestedThemeProperty, value);
        }

        public static readonly DependencyProperty RequestedThemeProperty = DependencyProperty.RegisterAttached(
            "RequestedTheme",
            typeof(ElementTheme),
            typeof(Design),
            new PropertyMetadata(ElementTheme.Default, OnRequestedThemeChanged));

        private static void OnRequestedThemeChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            if (DesignerProperties.GetIsInDesignMode(d))
            {
                var element = (FrameworkElement)d;
                ThemeManager.SetRequestedTheme(element, (ElementTheme)e.NewValue);
            }
        }

        #endregion
    }
}
