TPrintPreview
=============

The [TPrintPreview](TPrintPreview.md) control is a descendent of Delphi's `TScrollBox` control. This control can be used for creating, displaying, manipulating, and printing pages.

Here are the key features of the [TPrintPreview](TPrintPreview.md) control:

  - supports almost unlimited amount of pages
  - automatically adjusts printer's paper size and orientation at the print time
  - automatically adjusts mapping modes
  - previewed pages can be scaled with an arbitrarily zoom factor
  - shows created pages while new pages are being processed
  - displayed pages can be scrolled by mouse dragging
  - pages can be saved to and restored from file
  - each page is accessible as a Windows Metafile image
  - has some methods for rendering rich text format
  - can manage custom printer forms (custom paper sizes)
  - allows background and annotation for both print and preview pages
  - both preview and print pages can be converted to grayscale, and you can adjust brightness and contrast of them
  - allows inserting, replacing, editing, deleting, and reordering of pages freely at any time
  - can save pages as PDF document by using [Synopse PDF Engine](https://github.com/synopse/SynPDF) or [dsPDF Library](https://torry.net/authorsmore.php?id=2851)
  - can save pages as multi-frame TIFF image.
  - has a complete set of properties and events

See:
  - [Properties](TPrintPreview.Properties.md)
  - [Methods](TPrintPreview.Methods.md)
  - [Events](TPrintPreview.Events.md)
  - [Keyboard Shortcuts](TPrintPreview.Keyboard.md)
  - [Mouse Wheel Functions](TPrintPreview.Mouse.md)
  - [Known Issues](TPrintPreview.Issues.md)
