TPrintPreview Properties
========================

In addition to the standard properties of Delphi's `TScrollBox` control, the [TPrintPreview](TPrintPreview.md) control offers the following extra properties:

- **`Annotation: Boolean`** \
  Indicates whether the annotation drawing is active.

- **`Background: Boolean`** \
  Indicates whether the background drawing is active.

- **`CacheSize: Integer`** \
  Determines the maximum number of pages that the control can keep in memory.

- **`CanScrollHorz: Boolean`** (read-only) \
  Indicates whether the preview page can scroll horizontally.

- **`CanScrollVert: Boolean`** (read-only) \
  Indicates whether the preview page can scroll vertically.

- **`Canvas: TCanvas`** (read-only) \
  Provides access to a drawing surface that represents the page. Each page has its own canvas and any access to this property must be inside `BeginDoc`/`EndDoc`, `BeginEdit`/`EndEdit`, `BeginReplace`/`EndReplace`, `BeginInsert`/`EndInsert`, or `BeginAppend`/`EndAppend` call blocks.

- **`CanvasPageNo: Integer`** (read-only) \
  Gets the page number that owns `Canvas` property. The value of this property is zero when the control's canvas is not a page canvas.

- **`CurrentPage: Integer`** \
  Determines the page number of currently visible page.

- **`DirectPrint: Boolean`** \
  Determines whether the control should create preview pages or should directly print pages on the printer.

- **`Grayscale: TGrayscaleOptions`** \
  `TGrayscaleOptions = set of TGrayscaleOption` \
  `TGrayscaleOption = (gsPreview, gsPrint)` \
  Indicates whether the preview and/or print pages should be converted to grayscale.

  | Value       | Description                                                                                           |
  |-------------|-------------------------------------------------------------------------------------------------------|
  | gsPreview   | Shows preview pages in grayscale. However, background and annotation items keep their original colors |
  | gsPrint     | Print pages in grayscale                                                                              |
- **`GrayBrightness: -100..100`**
  Determines brightness of pages in grayscale mode.

- **`GrayContrast: -100..100`**
  Determines contrast of pages in grayscale mode.

- **`IsDummyFormName: Boolean`** (read-only) \
  Indicates whether the FormName property represents a standard printer's form name, or a dummy name generated by the control.

- **`IsPaperCustom: Boolean`** (read-only) \
  Indicates whether a custom paper is in use.

- **`IsPaperRotated: Boolean`** (read-only) \
  Indicates whether the paper's orientation is landscape.

- **`Font: TFont`** \
  Specifies the default font for each new page. It is recommended to use a scalable font (e.g. TrueType or OpenType).

- **`FormName: String`** \
  Determines the name of selected form for the paper size.

- **`Orientation: TPrinterOrientation`** \
  `TPrinterOrientation = (poPortrait, poLandscape)` \
  Determines the the paper orientation of pages that will be created. The paper orientation cannot be changed inside the `BeginDoc` and `EndDoc` block.

- **`PDFDocumentInfo: TPDFDocumentInfo`** \
  Specifies _Producer_, _Author_, _Creator_, _Subject_, and _Title_ of the generated PDF document.

- **`Pages[PageNo: Integer]: TMetaFile`** (read-only) \
  Contains the list of prepared pages.

- **`PageBounds: TRect`** (read-only) \
  Gets the bounding rectangle of the page in logical coordinates.

- **`PageSize: TPoint`** (read-only) \
  Gets the paper size in logical coordinates.

- **`PageDevicePixels: TPoint`** (read-only) \
  Gets the paper size in device coordinates (pixels).

- **`PageLogicalPixels: TPoint`** (read-only) \
  Gets the paper size in screen coordinates (pixels).

- **`PaperType: TPaperType`** \
  Specifies the paper size by the paper's type. \
  By setting this property to `pCustom`, you can use `PaperWidth` and `PaperHeight` properties to set your own custom paper size.

- **`PaperHeight: Integer`** \
  Determines the physical height of the paper in logical units. \
  Changing this property will change `PaperType` to `pCustom`. The value of `PaperHeight` must be between 1 and 32767.

- **`PaperWidth: Integer`** \
  Determines the physical width of the paper in logical units. \
  Changing this property will change `PaperType` to `pCustom`. The value of `PaperWidth` must be between 1 and 32767.

- **`PaperView: TPaperPreviewOptions`** \
  Contains display parameters of the visible preview page. \
  See [TPaperPreview](TPaperPreview.md) component for details.

- **`PaperViewControl: TPaperPreview`** \
  Provides access to the control that displays a page. \
  See [TPaperPreview](TPaperPreview.md) component for details.

- **`PrintableAreaColor: Color`** \
  Determines the color to mark printer's printable area.

- **`Printer: TPrinter`** (read-only) \
  Gets a global instance of `TPrinter` to manage interactions with the printer.

- **`PrinterInstalled: Boolean`** (read-only) \
  Indicates whether there is any installed printer (driver) on the system.

- **`PrinterPageBounds: TRect`** (read-only) \
  Specifies the bounding rectangle of the printer's printable area in logical coordinates.

- **`PrintJobTitle: String`** \
  Specifies the title of the print job on the system's print queue.

- **`ShowPrintableArea: Boolean`** \
  Specifies whether to show bounding rectangle of the printer's printable area on the preview.

- **`State: TPreviewState`** (read-only) \
  `TPreviewState = (psReady, psCreating, psPrinting, psEditing, psLoading, psSaving, psSavingPDF, psSavingTIF)` \
  Determines the current state of the control.
  
  | Value         | Description                                                                                          |
  |---------------|------------------------------------------------------------------------------------------------------|
  | psReady       | The control is idle                                                                                  |
  | psCreating    | The `BeginDoc` method is called and the control is preparing the preview pages to display            |
  | psPrinting    | One of the print methods is called and the control is printing pages on the printer                  |
  | psEditing     | The `BeginEdit` method is called and control is editing a page                                       |
  | psReplacing   | The `BeginReplace` method is called and control is replacing a page with a new one                   |
  | psInserting   | Either `BeginInsert` or `BeginAppend` method is called and control is inserting/appending a new page |
  | psLoading     | The control is loading pages form a stream or file                                                   |
  | psSaving      | The control is saving pages to a stream or file                                                      |
  | psSavingPDF   | The control is saving pages as a PDF document                                                        |
  | psSavingTIF   | The control is saving pages as a multi-page TIFF image                                               |

- **`SystemDefaultUnits: TUnits`** (read-only) \
  Specifies the default measurement unit of the system. This unit is either mmHiMetric or mmHiEnglish.

- **`TotalPages: Integer`** (read-only) \
  Determines the total number of available pages to preview/print.

- **`Units: TUnits`** \
  `TUnits = (mmPixel, mmLoMetric, mmHiMetric, mmLoEnglish, mmHiEnglish, mmTWIPS, mmPoints)` \
  Determines how the control interprets the measurement values (e.g. paper size, margins, font height, pen width, coordinates, and so on).

  | Value         | Unit            |
  |---------------|-----------------|
  | mmPixel       | 1 pixel         |
  | mmLoMetric    | 0.1 millimeter  |
  | mmHiMetric    | 0.01 millimeter |
  | mmLoEnglish   | 0.01 inch       |
  | mmHiEnglish   | 0.001 inch      |
  | mmTWIPS       | 1/1440 inch     |
  | mmPoints      | 1/72 inch       |

- **`UsePrinterOptions: Boolean`** \
  Specifies where the control looks for the page information. When this property is `true`, the control uses the printer's paper size and orientation; otherwise, it uses the paper size and orientation set in the control's properties.

- **`Zoom: Integer`** \
  Specifies how much the control scales pages on the screen. Changing this property will change `ZoomState` to `zsZoomOther`.

- **`ZoomState: TZoomState`** \
  `TZoomState = (zsZoomOther, zsZoomToWidth, zsZoomToHeight, zsZoomToFit)` \
  Determines how the control scales pages on the screen.

  | Value            | Description                                             |
  |------------------|---------------------------------------------------------|
  | zsZoomOther      | The scaling factor is determined by the `Zoom` property |
  | zsZoomToWidth    | The whole width of page will be visible                 |
  | zsZoomToHeight   | The whole height of page will be visible                |
  | zsZoomToFit      | The whole page will be visible                          |

- **`UserDefaultUnits: TUnits`** (read-only) \
  Gets the preferred measurement unit of the user. This unit is either `mmHiMetric` or `mmHiEnglish`.

- **`ZoomSavePos: Boolean`** \
  Indicates whether the control keeps the old scroll positions when the zoom factor is changing.

- **`ZoomStep: Integer`** \
  Determines the amount of changes in zoom percentage when it increments or decrements by a keyboard shortcut or mouse wheel movement.

- **`ZoomMin: Integer`** \
  Determines the minimum allowed value for the `Zoom` property.

- **`ZoomMax: Integer`** \
  Determines the maximum allowed value for the `Zoom` property.
