# WPF-IM
一款参考QQ、微信的即时通讯软件。采用CS结构，客户端基于.Net与WPF开发，服务端使用Java开发。

## 环境准备

1. 数据库准备：需要先运行MySQL脚本，进行数据库表的创建
2. 服务器准备：修改Server项目中的application.xaml文件，配置OAuth2授权平台的相关信息以及项目的端口等信息后启动服务端。（其中第三方授权依赖引入自我的阿里云私服，Maven无法直接下载，可前往我的Github：[openauth-spring-boot-starter](https://github.com/Ken-Chy129/openauth-spring-boot-starter)进行下载）
3. 客户端准备：进入App.xaml.cs文件配置服务端的IP地址，同时在HttpUtil工具类中接入AI机器人接口、短信验证服务接口等，正确地配置SocketUtil中的连接。

## 运行说明

1. 打开软件后首先进入登录界面，如果已经完成注册，则通过输入手机号码和密码进行登录，也可以使用QQ进行授权登录。如果未注册则可以点击注册账号按钮进入注册界面。

   <img src="https://website.ken-chy129.cn/article/202306080118756.png" alt="image-20230608011840400" style="zoom:67%;" />

2. 进入注册界面后，点击头像框的从本地选择图片作为头像，紧接着填写用户名、密码以及手机号码，用户名和密码会有长度的限制，而手机号码会进行合法性的校验。手机号码合法的情况下，点击获取验证码按钮之后，对应的手机号就可以收到验证短信。接着填写验证码之后就可以点击注册按钮完成注册。

   <img src="https://website.ken-chy129.cn/article/202306080121483.png" alt="image-20230608012107352" style="zoom:67%;" />

3. 注册成功之后会自动跳转到登录界面，接着输入注册的手机号码和密码之后点击登录（或键入回车键）就可以进入主界面。用户在注册后系统会自动添加一个名为 Robot的AI好友，可以通过在消息框输入内容后点击发送按钮或键入回车键发送消息与其进行对话。

   <img src="https://website.ken-chy129.cn/article/202306080122039.png" alt="image-20230608012240341" style="zoom:67%;" />

4. 用户也可以点击添加按钮进入添加好友界面，通过输入用户名搜索其他用户（支持模糊查询）。

   ![image-20230608012514776](https://website.ken-chy129.cn/article/202306080125637.png)

   ![image-20230608012537088](https://website.ken-chy129.cn/article/202306080125079.png)

5. 用户可以点击查询结果项进入用户的个人资料界面查看用户相关信息。

   ![image-20230613182431662](https://website.ken-chy129.cn/article/202306131824551.png)

6. 如果想要添加用户则通过点击+号按钮，进入好友请求界面。在该界面可以通过点击用户名后的铅笔按钮为用户设置备注名，同时填写验证消息，最后通过点击发送请求按钮来发送好友请求。

   ![image-20230608013003891](https://website.ken-chy129.cn/article/202306080130276.png)

   ![image-20230608013014916](https://website.ken-chy129.cn/article/202306080130564.png)

7. 另一个用户可以通过点击好友请求按钮进入好友请求列表界面，查看发送给自己的添加好友请求。可以通过点击√按钮来接受请求，也可以通过点击×按钮来拒绝请求。之后同样可以通过点击用户名后面的铅笔按钮为好友设置备注名。

   ![image-20230608013238301](https://website.ken-chy129.cn/article/202306080132981.png)

   ![image-20230608013255018](https://website.ken-chy129.cn/article/202306080132070.png)



8. 接受请求之后双方便成为好友关系，并且可以在各自的好友列表中看到对方的存在。好友列表会有一个带颜色的圆圈表示用户状态，绿色表示用户在线，灰色表示用户离线。用户可以点击好友来进入与其的会话框，之后即可以与好友进行通讯。用户还可以点击群聊按钮进去群聊列表，之后同样可以选择一个群聊进行通讯。

   ![image-20230608013607364](https://website.ken-chy129.cn/article/202306080141557.png)

   ![image-20230608013738335](https://website.ken-chy129.cn/article/202306080141892.png)

9. 用户可以通过列表上访的搜索框进行搜索，如果当前是在好友列表则搜索显示匹配的好友；如果当前切换到了群组列表，则搜索显示出匹配的群组。

10. 用户还可以通过点击上方的房子形状的按钮进入个人主页。在该界面中用户可以通过点击铅笔按钮进入修改模式，点击之后用户可以上传头像，修改用户名、个性签名、性别、邮箱号、所在地区等信息，对于账号，手机号码和注册时间等信息则无法进行修改。修改完成之后点击Save则完成保存并且同步渲染到主界面，如果点击Cancel则会将所有信息重置到修改以前。

    ![image-20230613182519003](https://website.ken-chy129.cn/article/202306131825656.png)

11. 用户通过右键指定的好友可以唤起一个菜单，其中可以选择显示好友资料或者删除好友。如果点击删除好友则会弹出提示框询问是否确认操作，在确认删除之后则会解除双方的好友消息，同时将双方从对方的好友列表中移除，此外被删除方还会收到被对方删除的提示消息。

    ![image-20230608014346891](https://website.ken-chy129.cn/article/202306080143076.png)

    ![image-20230608014409209](https://website.ken-chy129.cn/article/202306080144004.png)

12. 当用户进入主界面之后，点击界面右上方的x按钮并不会退出软件，而只是最小化到系统托盘。如果用户想真正退出程序，应该通过右键系统托盘选择退出项进行退出。

<img src="https://website.ken-chy129.cn/article/202306080241124.png" alt="image-20230608014609622" style="zoom:67%;" />
