/* This file is part of KeY - https://key-project.org
 * KeY is licensed under the GNU General Public License Version 2
 * SPDX-License-Identifier: GPL-2.0-only */
package de.uka.ilkd.key.gui.fonticons;

import java.awt.*;
import java.io.IOException;

/**
 * Copyright (c) 2016 jIconFont <BR>
 * <BR>
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:<BR>
 * <BR>
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.<BR>
 * <BR>
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
public enum Entypo implements IconFont {
    ADDRESS('\uE723'), ADJUST('\u25D1'), AIR('\uE753'), ARCHIVE('\uE738'), ARROW_COMBO('\uE74F'),
    ATTENTION('\u26A0'), BACK_IN_TIME('\uE771'), BASKET('\uE73D'), BEHANCE('\uF34E'),
    BRUSH('\uE79A'), BUCKET('\uE756'), CANCEL('\u2715'), CANCEL_CIRCLED('\u2716'),
    CANCEL_SQUARED('\u274E'), CC('\uE7A5'), CCW('\u27F2'), CC_BY('\uE7A6'), CC_NC('\uE7A7'),
    CC_NC_EU('\uE7A8'), CC_NC_JP('\uE7A9'), CC_ND('\uE7AB'), CC_PD('\uE7AC'), CC_REMIX('\uE7AF'),
    CC_SA('\uE7AA'), CC_SHARE('\uE7AE'), CC_ZERO('\uE7AD'), CHART_PIE('\uE751'), CHAT('\uE720'),
    CHECK('\u2713'), CLOUD('\u2601'), CLOUD_THUNDER('\u26C8'), CODE('\uE714'), COG('\u2699'),
    COMMENT('\uE718'), COMPASS('\uE728'), CUP('\u2615'), CW('\u27F3'), DATABASE('\uE754'),
    DB_SHAPE('\uF600'), DIRECTION('\u27A2'), DOC('\uE730'), DOCS('\uE736'), DOC_LANDSCAPE('\uE737'),
    DOC_TEXT_INV('\uE731'), DOT('\uE78B'), DOT_2('\uE78C'), DOT_3('\uE78D'), DOWN('\u2B07'),
    DOWN_BOLD('\uE4B0'), DOWN_CIRCLED('\uE758'), DOWN_DIR('\u25BE'), DOWN_OPEN('\uE75C'),
    DOWN_OPEN_BIG('\uE764'), DOWN_OPEN_MINI('\uE760'), DOWN_THIN('\u2193'), DRIBBBLE('\uF31B'),
    DRIBBBLE_CIRCLED('\uF31C'), DRIVE('\uE755'), DROPBOX('\uF330'), ERASE('\u232B'),
    EVERNOTE('\uF333'), EXPORT('\uE715'), EYE('\uE70A'), FACEBOOK('\uF30C'),
    FACEBOOK_CIRCLED('\uF30D'), FACEBOOK_SQUARED('\uF30E'), FAST_BACKWARD('\u23EA'),
    FAST_FORWARD('\u23E9'), FEATHER('\u2712'), FLAG('\u2691'), FLASH('\u26A1'), FLATTR('\uF336'),
    FLICKR('\uF303'), FLICKR_CIRCLED('\uF304'), FLIGHT('\u2708'), FLOW_BRANCH('\uE791'),
    FLOW_CASCADE('\uE790'), FLOW_LINE('\uE793'), FLOW_PARALLEL('\uE794'), FLOW_TREE('\uE792'),
    FORWARD('\u27A6'), GAUGE('\uE7A2'), GITHUB('\uF300'), GITHUB_CIRCLED('\uF301'),
    GOOGLE_CIRCLES('\uF351'), GPLUS('\uF30F'), GPLUS_CIRCLED('\uF310'), HEART('\u2665'),
    HEART_EMPTY('\u2661'), HELP('\u2753'), HELP_CIRCLED('\uE704'), HOME('\u2302'),
    HOURGLASS('\u23F3'), INBOX('\uE777'), INFINITY('\u221E'), INFO('\u2139'),
    INFO_CIRCLED('\uE705'), INSTAGREM('\uF32D'), INSTALL('\uE778'), KEYBOARD('\u2328'),
    LANGUAGE('\uE752'), LASTFM('\uF321'), LASTFM_CIRCLED('\uF322'), LAYOUT('\u268F'),
    LEFT('\u2B05'), LEFT_BOLD('\uE4AD'), LEFT_CIRCLED('\uE759'), LEFT_DIR('\u25C2'),
    LEFT_OPEN('\uE75D'), LEFT_OPEN_BIG('\uE765'), LEFT_OPEN_MINI('\uE761'), LEFT_THIN('\u2190'),
    LEVEL_DOWN('\u21B3'), LEVEL_UP('\u21B0'), LIFEBUOY('\uE788'), LINKEDIN('\uF318'),
    LINKEDIN_CIRCLED('\uF319'), LIST('\uE005'), LIST_ADD('\uE003'), LOCATION('\uE724'),
    LOGIN('\uE740'), LOGOUT('\uE741'), LOGO_DB('\uF603'), MAGNET('\uE7A1'), MAIL('\u2709'),
    MAP('\uE727'), MENU('\u2630'), MINUS_CIRCLED('\u2796'), MINUS_SQUARED('\u229F'), MIXI('\uF34B'),
    MOON('\u263D'), MOUSE('\uE789'), NETWORK('\uE776'), NOTE('\u266A'), NOTE_BEAMED('\u266B'),
    PAPER_PLANE('\uE79B'), PAUSE('\u2389'), PAYPAL('\uF342'), PENCIL('\u270E'), PICASA('\uF345'),
    PINTEREST('\uF312'), PINTEREST_CIRCLED('\uF313'), PLAY('\u25B6'), PLUS_CIRCLED('\u2795'),
    PLUS_SQUARED('\u229E'), POPUP('\uE74C'), PRINT('\uE716'), PROGRESS_0('\uE768'),
    PROGRESS_1('\uE769'), PROGRESS_2('\uE76A'), PROGRESS_3('\uE76B'), PUBLISH('\uE74D'),
    QQ('\uF32A'), QUOTE('\u275E'), RDIO('\uF324'), RDIO_CIRCLED('\uF325'), RECORD('\u26AB'),
    RENREN('\uF33C'), REPLY('\uE712'), REPLY_ALL('\uE713'), RESIZE_FULL('\uE744'),
    RESIZE_SMALL('\uE746'), RETWEET('\uE717'), RIGHT('\u27A1'), RIGHT_BOLD('\uE4AE'),
    RIGHT_CIRCLED('\uE75A'), RIGHT_DIR('\u25B8'), RIGHT_OPEN('\uE75E'), RIGHT_OPEN_BIG('\uE766'),
    RIGHT_OPEN_MINI('\uE762'), RIGHT_THIN('\u2192'), RSS('\uE73A'), SHARE('\uE73C'),
    SHAREABLE('\uE73E'), SINA_WEIBO('\uF33F'), SKYPE('\uF339'), SKYPE_CIRCLED('\uF33A'),
    SMASHING('\uF357'), SOUNDCLOUD('\uF348'), SPOTIFY('\uF327'), SPOTIFY_CIRCLED('\uF328'),
    STAR('\u2605'), STAR_EMPTY('\u2606'), STOP('\u25A0'), STUMBLEUPON('\uF31E'),
    STUMBLEUPON_CIRCLED('\uF31F'), SUITCASE('\uE78E'), SWEDEN('\uF601'), SWITCH('\u21C6'),
    TAG('\uE70C'), TAPE('\u2707'), THERMOMETER('\uE757'), TOOLS('\u2692'), TO_END('\u23ED'),
    TO_START('\u23EE'), TRAFFIC_CONE('\uE7A3'), TRASH('\uE729'), TUMBLR('\uF315'),
    TUMBLR_CIRCLED('\uF316'), TWITTER('\uF309'), TWITTER_CIRCLED('\uF30A'), UP('\u2B06'),
    UPLOAD_CLOUD('\uE711'), UP_BOLD('\uE4AF'), UP_CIRCLED('\uE75B'), UP_DIR('\u25B4'),
    UP_OPEN('\uE75F'), UP_OPEN_BIG('\uE767'), UP_OPEN_MINI('\uE763'), UP_THIN('\u2191'),
    USER_ADD('\uE700'), VCARD('\uE722'), VIMEO('\uF306'), VIMEO_CIRCLED('\uF307'),
    VKONTAKTE('\uF354'), VOLUME('\uE742'), WINDOW('\uE74E');

    private final char character;

    Entypo(char character) {
        this.character = character;
    }

    @Override
    public char getUnicode() {
        return character;
    }

    public Font getFont() throws IOException, FontFormatException {
        return Font.createFont(Font.TRUETYPE_FONT,
            Entypo.class.getResourceAsStream("/fonts/entypo.ttf"));
    }
}
