
public class SymmArray {

    public int[][] ar;

    /*@ public invariant
      @   ar != null &&
      @   (\forall int i; i >= 0 && i < ar.length;
      @                   ar[i] != null && ar[i].length == ar.length) &&
      @   (\forall int i, j; i >= 0 && i < ar.length && j >= 0 && j < ar.length && i != j;
      @                      ar[i] != ar[j]);
      @*/

    /*@ public normal_behavior
      @   assignable \nothing;
      @   ensures \result ==
      @     (\forall int i, j; i >= 0 && i < ar.length && j >= 0 && j < ar.length;
      @                        ar[i][j] == ar[j][i]);
      @*/
    public boolean IsSymmetric() {}

    /*@ public normal_behavior
      @   requires
      @     ar.length >= 10 &&
      @     (\forall int i, j; i >= 0 && i < ar.length && j >= 0 && j < ar.length;
      @                        ar[i][j] == ar[j][i]);
      @   ensures
      @     (\forall int i, j; i >= 0 && i < ar.length && j >= 0 && j < ar.length;
      @                        ar[i][j] == ar[j][i]);
      @*/
    public void assignA() {
	ar[0][0] = 0;
	ar[1][1] = 1;
	ar[2][2] = 2;
	ar[3][3] = 3;
	ar[4][4] = 4;
	ar[5][5] = 5;
	ar[6][6] = 6;
	ar[7][7] = 7;
	ar[8][8] = 8;
	ar[9][9] = 9;
    }

    /*@ public normal_behavior
      @   requires ar.length >= 10 && IsSymmetric();
      @   ensures IsSymmetric();
      @*/
    public void assignB() {
	ar[0][0] = 0;
	ar[1][1] = 1;
	ar[2][2] = 2;
	ar[3][3] = 3;
	ar[4][4] = 4;
	ar[5][5] = 5;
	ar[6][6] = 6;
	ar[7][7] = 7;
	ar[8][8] = 8;
	ar[9][9] = 9;
    }
}
