/* This file is part of KeY - https://key-project.org
 * KeY is licensed under the GNU General Public License Version 2
 * SPDX-License-Identifier: GPL-2.0-only */
package de.uka.ilkd.key.strategy.termProjection;

import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.strategy.feature.MutableState;

public class FocusFormulaProjection implements ProjectionToTerm {

    public static final ProjectionToTerm INSTANCE = new FocusFormulaProjection();

    private FocusFormulaProjection() {}

    public Term toTerm(RuleApp app, PosInOccurrence pos, Goal goal, MutableState mutableState) {
        assert pos != null : "Projection is only applicable to rules with find";

        return pos.sequentFormula().formula();
    }

}
