/* This file is part of KeY - https://key-project.org
 * KeY is licensed under the GNU General Public License Version 2
 * SPDX-License-Identifier: GPL-2.0-only */
package de.uka.ilkd.key.rule.metaconstruct;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import de.uka.ilkd.key.java.Expression;
import de.uka.ilkd.key.java.KeYJavaASTFactory;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.Statement;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.declaration.LocalVariableDeclaration;
import de.uka.ilkd.key.java.expression.operator.CopyAssignment;
import de.uka.ilkd.key.java.expression.operator.New;
import de.uka.ilkd.key.java.reference.ExecutionContext;
import de.uka.ilkd.key.java.reference.MethodOrConstructorReference;
import de.uka.ilkd.key.java.reference.MethodReference;
import de.uka.ilkd.key.java.reference.ReferencePrefix;
import de.uka.ilkd.key.java.reference.SuperConstructorReference;
import de.uka.ilkd.key.java.reference.SuperReference;
import de.uka.ilkd.key.java.reference.ThisConstructorReference;
import de.uka.ilkd.key.java.reference.ThisReference;
import de.uka.ilkd.key.logic.ProgramElementName;
import de.uka.ilkd.key.logic.VariableNamer;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.rule.inst.SVInstantiations;

import org.key_project.util.collection.ImmutableArray;

/**
 * TODO
 *
 * @author N/A
 */
public class EvaluateArgs extends ProgramTransformer {

    /**
     * creates a typeof ProgramTransformer
     *
     * @param pe the instance of expression contained by the meta construct
     */
    public EvaluateArgs(ProgramElement pe) {
        super("#evaluate-arguments", pe);
    }

    /**
     * TODO Comment.
     *
     * @param e TODO
     * @param l TODO
     * @param services TODO
     * @param ec TODO
     * @return TODO
     */
    public static ProgramVariable evaluate(Expression e, List<? super LocalVariableDeclaration> l,
            Services services, ExecutionContext ec) {

        final VariableNamer varNamer = services.getVariableNamer();
        final KeYJavaType t = e.getKeYJavaType(services, ec);
        final ProgramElementName name =
            VariableNamer.parseName(varNamer.getSuggestiveNameProposalForSchemaVariable(e));
        final ProgramVariable pv = KeYJavaASTFactory.localVariable(name, t);

        l.add(KeYJavaASTFactory.declare(pv, e, t));

        return pv;
    }

    @Override
    public ProgramElement[] transform(ProgramElement pe, Services services,
            SVInstantiations svInst) {

        final ExecutionContext ec = svInst.getExecutionContext();

        MethodOrConstructorReference mr = (MethodOrConstructorReference) //
        (pe instanceof CopyAssignment ? ((CopyAssignment) pe).getChildAt(1) : pe);

        List<Statement> evalstat = new LinkedList<>();

        final ReferencePrefix newCalled;
        final ReferencePrefix invocationTarget = mr.getReferencePrefix();

        if (invocationTarget instanceof Expression && !(invocationTarget instanceof ThisReference
                || invocationTarget instanceof SuperReference)) {
            newCalled = evaluate((Expression) invocationTarget, evalstat, services, ec);
        } else {
            newCalled = mr.getReferencePrefix();
        }

        ImmutableArray<? extends Expression> args = mr.getArguments();
        Expression[] newArgs = new Expression[args.size()];
        for (int i = 0; i < args.size(); i++) {
            newArgs[i] = evaluate(args.get(i), evalstat, services, ec);
        }

        Statement[] res = new Statement[1 + evalstat.size()];
        final Iterator<Statement> it = evalstat.iterator();
        for (int i = 0; i < evalstat.size(); i++) {
            res[i] = it.next();
        }

        final MethodOrConstructorReference resMR;
        if (mr instanceof MethodReference) {
            resMR = KeYJavaASTFactory.methodCall(newCalled, ((MethodReference) mr).getMethodName(),
                newArgs);
        } else if (mr instanceof New) {
            resMR = KeYJavaASTFactory.newOperator(mr.getReferencePrefix(),
                ((New) mr).getTypeReference(), newArgs);
        } else if (mr instanceof SuperConstructorReference) {
            resMR = KeYJavaASTFactory.superConstructor(mr.getReferencePrefix(), newArgs);
        } else if (mr instanceof ThisConstructorReference) {
            resMR = KeYJavaASTFactory.thisConstructor(newArgs);
        } else {
            assert false : "unexpected subclass of MethodOrConstructorReference";
            resMR = null;
        }

        if (pe instanceof CopyAssignment) {
            res[res.length - 1] = KeYJavaASTFactory.assign(((CopyAssignment) pe).getExpressionAt(0),
                (Expression) resMR);
        } else {
            res[res.length - 1] = resMR;
        }

        return new ProgramElement[] { KeYJavaASTFactory.block(res) };
    }
}
