/* This file is part of KeY - https://key-project.org
 * KeY is licensed under the GNU General Public License Version 2
 * SPDX-License-Identifier: GPL-2.0-only */
package de.uka.ilkd.key.java;

public class TypeNameTranslator {

    private TypeNameTranslator() {}


    /**
     * returns the basetype of <code>t</code>. example: <code>getBaseType("[[[I")</code> returns
     * "int".
     */
    public static String getBaseType(String t) {
        if (t == null || !t.startsWith("[")) {
            return t;
        }
        while (t.startsWith("[")) {
            t = t.substring(1);
        }
        if (t.startsWith("L")) {
            return t.substring(1);
        } else if (t.startsWith("B")) {
            return "byte";
        } else if (t.startsWith("C")) {
            return "char";
        } else if (t.startsWith("D")) {
            return "double";
        } else if (t.startsWith("F")) {
            return "float";
        } else if (t.startsWith("I")) {
            return "int";
        } else if (t.startsWith("J")) {
            return "long";
        } else if (t.startsWith("S")) {
            return "short";
        } else if (t.startsWith("Z")) {
            return "boolean";
        } else {
            return t;
        }
    }


    /**
     * returns the dimensions of an ArrayType. Returns 0 if <code>t</code> doesn't represent an
     * ArrayType.
     */
    public static int getDimensions(String t) {
        if (t == null || !t.startsWith("[")) {
            return 0;
        }
        int i = 0;
        while (t.startsWith("[")) {
            t = t.substring(1);
            i++;
        }
        return i;
    }

}
