/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.IntPredicate;
import net.sf.saxon.expr.sort.EmptyIntIterator;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.Twine16;
import net.sf.saxon.str.Twine24;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.str.UnicodeChar;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.UnicodeWriter;
import net.sf.saxon.z.IntIterator;

public class ZenoString
extends UnicodeString {
    private List<UnicodeString> segments = new ArrayList<UnicodeString>();
    private List<Long> offsets = new ArrayList<Long>();
    public static final ZenoString EMPTY = new ZenoString();

    private ZenoString() {
    }

    private ZenoString(UnicodeString content) {
        this.segments.add(content);
        this.offsets.add(0L);
    }

    public static ZenoString of(UnicodeString content) {
        if (content instanceof ZenoString) {
            return (ZenoString)content;
        }
        if (content.isEmpty()) {
            return new ZenoString();
        }
        return new ZenoString(content);
    }

    private int segmentForOffset(long offset) {
        if (this.segments.size() == 0) {
            throw new IndexOutOfBoundsException("ZenoString is empty");
        }
        int result = this.binarySearch(offset, 0, this.offsets.size() - 1);
        if (result < 0) {
            throw new IndexOutOfBoundsException("Index " + offset + " out of range 0-" + (this.length() - 1L));
        }
        return result;
    }

    private int binarySearch(long offset, int start, int end) {
        if (start == end) {
            long s2 = this.offsets.get(start);
            long e = s2 + this.segments.get(start).length();
            if (s2 <= offset && e > offset) {
                return start;
            }
            return -1;
        }
        int mid = start + (end - start + 1) / 2;
        if (this.offsets.get(mid) > offset) {
            return this.binarySearch(offset, start, mid - 1);
        }
        return this.binarySearch(offset, mid, end);
    }

    @Override
    public IntIterator codePoints() {
        if (this.isEmpty()) {
            return EmptyIntIterator.getInstance();
        }
        return new IntIterator(){
            final Iterator<UnicodeString> outerIterator;
            IntIterator innerIterator;
            {
                this.outerIterator = ZenoString.this.segments.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.innerIterator == null) {
                    return this.outerIterator.hasNext();
                }
                if (this.innerIterator.hasNext()) {
                    return true;
                }
                this.innerIterator = null;
                return this.outerIterator.hasNext();
            }

            @Override
            public int next() {
                if (this.innerIterator == null) {
                    if (this.outerIterator.hasNext()) {
                        this.innerIterator = this.outerIterator.next().codePoints();
                    } else {
                        throw new NoSuchElementException();
                    }
                }
                return this.innerIterator.next();
            }
        };
    }

    @Override
    public long length() {
        int i = this.segments.size() - 1;
        return i < 0 ? 0L : this.offsets.get(i) + this.segments.get(i).length();
    }

    @Override
    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    @Override
    public int getWidth() {
        int maxWidth = 7;
        for (UnicodeString entry : this.segments) {
            int width = entry.getWidth();
            if (width == 24) {
                return 24;
            }
            maxWidth = Math.max(maxWidth, width);
        }
        return maxWidth;
    }

    @Override
    public long indexOf(int codePoint, long from) {
        int first;
        if ((from = Math.max(from, 0L)) >= this.length()) {
            return -1L;
        }
        for (int i = first = this.segmentForOffset(from); i < this.segments.size(); ++i) {
            UnicodeString segment = this.segments.get(i);
            long offset = this.offsets.get(i);
            long pos = segment.indexOf(codePoint, i == first ? from - offset : 0L);
            if (pos < 0L) continue;
            return pos + offset;
        }
        return -1L;
    }

    @Override
    public long indexWhere(IntPredicate predicate, long from) {
        int first;
        for (int i = first = this.segmentForOffset(from); i < this.segments.size(); ++i) {
            UnicodeString segment = this.segments.get(i);
            long offset = this.offsets.get(i);
            long pos = segment.indexWhere(predicate, i == first ? from - offset : 0L);
            if (pos < 0L) continue;
            return pos + offset;
        }
        return -1L;
    }

    @Override
    public int codePointAt(long index) {
        int entry = this.segmentForOffset(index);
        UnicodeString segment = this.segments.get(entry);
        return segment.codePointAt(index - this.offsets.get(entry));
    }

    @Override
    public UnicodeString substring(long start, long end) {
        int last;
        this.checkSubstringBounds(start, end);
        if (start == end) {
            return EmptyUnicodeString.getInstance();
        }
        if (start + 1L == end) {
            return new UnicodeChar(this.codePointAt(start));
        }
        int first = this.segmentForOffset(start);
        if (first == (last = this.segmentForOffset(end - 1L))) {
            UnicodeString segment = this.segments.get(first);
            long offset = this.offsets.get(first);
            return segment.substring(start - offset, end - offset);
        }
        ZenoString z = ZenoString.of(this.segments.get(first).substring(start - this.offsets.get(first)));
        for (int i = first + 1; i < last; ++i) {
            z = z.concat(this.segments.get(i));
        }
        return z.concat(this.segments.get(last).prefix(end - this.offsets.get(last)));
    }

    @Override
    public ZenoString concat(UnicodeString other) {
        if (this.isEmpty()) {
            return other instanceof ZenoString ? (ZenoString)other : new ZenoString(other);
        }
        if (other.isEmpty()) {
            return this;
        }
        if (other instanceof ZenoString) {
            ZenoString z = new ZenoString();
            z.segments = new ArrayList<UnicodeString>(this.segments);
            z.segments.addAll(((ZenoString)other).segments);
            z.offsets = new ArrayList<Long>(this.offsets);
            long len = this.length();
            for (long offset : ((ZenoString)other).offsets) {
                z.offsets.add(offset + len);
            }
            return len < 32L || other.length() < 32L ? z.consolidate0() : z;
        }
        ZenoString z = new ZenoString();
        z.segments = new ArrayList<UnicodeString>(this.segments);
        z.offsets = new ArrayList<Long>(this.offsets);
        z.segments.add(other);
        z.offsets.add(this.length());
        return z.consolidate0();
    }

    @Override
    void copy8bit(byte[] target, int offset) {
        for (UnicodeString us : this.segments) {
            us.copy8bit(target, offset);
            offset += us.length32();
        }
    }

    @Override
    void copy16bit(char[] target, int offset) {
        for (UnicodeString us : this.segments) {
            us.copy16bit(target, offset);
            offset += us.length32();
        }
    }

    @Override
    void copy24bit(byte[] target, int offset) {
        for (UnicodeString us : this.segments) {
            us.copy24bit(target, offset);
            offset += us.length32() * 3;
        }
    }

    private ZenoString consolidate() {
        int i;
        long prevLength = this.segments.get(i + 1).length();
        for (i = this.segments.size() - 2; i >= 0; --i) {
            long nextLength;
            long thisLength = this.segments.get(i).length();
            long l = nextLength = i == 0 ? 0L : this.segments.get(i - 1).length();
            if (thisLength <= prevLength && thisLength <= nextLength || thisLength + prevLength <= 32L) {
                this.segments.set(i, ZenoString.concatSegments(this.segments.get(i), this.segments.get(i + 1)));
                this.segments.remove(i + 1);
                this.offsets.remove(i + 1);
                prevLength = this.segments.get(i).length();
                continue;
            }
            prevLength = thisLength;
        }
        return this;
    }

    public void writeSegments(UnicodeWriter writer) throws IOException {
        for (UnicodeString str : this.segments) {
            writer.write(str);
        }
    }

    public static UnicodeString concatSegments(UnicodeString left, UnicodeString right) {
        if (left.getWidth() <= 8 && right.getWidth() <= 8) {
            byte[] newByteArray = new byte[left.length32() + right.length32()];
            left.copy8bit(newByteArray, 0);
            right.copy8bit(newByteArray, left.length32());
            return new Twine8(newByteArray);
        }
        if (left.getWidth() <= 16 && right.getWidth() <= 16) {
            char[] newCharArray = new char[left.length32() + right.length32()];
            left.copy16bit(newCharArray, 0);
            right.copy16bit(newCharArray, left.length32());
            return new Twine16(newCharArray);
        }
        byte[] newByteArray = new byte[(left.length32() + right.length32()) * 3];
        left.copy24bit(newByteArray, 0);
        right.copy24bit(newByteArray, left.length32() * 3);
        return new Twine24(newByteArray);
    }

    private ZenoString consolidate0() {
        for (int i = this.segments.size() - 2; i >= 0; --i) {
            double nextLength = (double)this.segments.get(i + 1).length() * 1.1;
            if (!((double)this.segments.get(i).length() < nextLength)) continue;
            this.segments.set(i, ZenoString.concatSegments(this.segments.get(i), this.segments.get(i + 1)));
            this.segments.remove(i + 1);
            this.offsets.remove(i + 1);
        }
        return this;
    }

    private ZenoString consolidate1() {
        int halfway = this.segments.size() / 2;
        for (int i = 0; i < halfway - 1; ++i) {
            if (this.segments.get(i).length() + this.segments.get(i + 1).length() >= 32L << i) continue;
            UnicodeString merged = this.segments.get(i).concat(this.segments.get(i + 1));
            this.segments.remove(i + 1);
            this.offsets.remove(i + 1);
            this.segments.set(i, merged);
        }
        int distance = 0;
        for (int i = this.segments.size() - 1; i > halfway; --i) {
            if (this.segments.get(i).length() + this.segments.get(i - 1).length() >= 32L << distance++) continue;
            UnicodeString merged = this.segments.get(i - 1).concat(this.segments.get(i));
            this.segments.remove(i);
            this.offsets.remove(i);
            this.segments.set(i - 1, merged);
        }
        return this;
    }

    @Override
    public UnicodeString economize() {
        int segs = this.segments.size();
        if (segs == 0) {
            return EmptyUnicodeString.getInstance();
        }
        if (segs == 1) {
            return this.segments.get(0);
        }
        if (segs < 32 && this.length() < 256L && this.getWidth() <= 16) {
            return new BMPString(this.toString());
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (UnicodeString str : this.segments) {
            sb.append(str.toString());
        }
        return sb.toString();
    }

    public List<Long> debugSegmentLengths() {
        ArrayList<Long> result = new ArrayList<Long>(this.segments.size());
        for (UnicodeString str : this.segments) {
            result.add(str.length());
        }
        return result;
    }

    private void showSegmentLengths() {
        StringBuilder sb = new StringBuilder();
        for (UnicodeString str : this.segments) {
            sb.append(str.length() + ", ");
        }
        System.err.println(sb);
    }

    private void verifySegmentLengths() {
        long total = 0L;
        for (int i = 0; i < this.segments.size(); ++i) {
            if (this.offsets.get(i) != total) {
                this.showSegmentLengths();
                throw new IllegalStateException("Bad offset for segment " + i);
            }
            total += this.segments.get(i).length();
        }
    }
}

