/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.AstTreeStringPrinter;
import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.ElementNode;
import com.puppycrawl.tools.checkstyle.xpath.RootNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;

public final class XpathUtil {
    private static final BitSet TOKEN_TYPES_WITH_TEXT_ATTRIBUTE = TokenUtil.asBitSet(58, 139, 138, 141, 137, 142, 140, 205, 183);
    private static final Pattern NEWLINE_TO_TAG = Pattern.compile("\n");
    private static final Pattern CARRIAGE_RETURN_TO_TAG = Pattern.compile("\r");
    private static final String DELIMITER = "---------" + System.lineSeparator();

    private XpathUtil() {
    }

    public static List<AbstractNode> createChildren(AbstractNode root, AbstractNode parent, DetailAST firstChild) {
        int depth = parent.getDepth() + 1;
        ArrayList<AbstractNode> result = new ArrayList<AbstractNode>();
        for (DetailAST currentChild = firstChild; currentChild != null; currentChild = currentChild.getNextSibling()) {
            int index = result.size();
            ElementNode child = new ElementNode(root, parent, currentChild, depth, index);
            result.add(child);
        }
        return result;
    }

    public static boolean supportsTextAttribute(DetailAST ast) {
        return TOKEN_TYPES_WITH_TEXT_ATTRIBUTE.get(ast.getType());
    }

    public static String getTextAttributeValue(DetailAST ast) {
        String text = ast.getText();
        if (ast.getType() == 139) {
            text = text.substring(1, text.length() - 1);
        }
        text = CARRIAGE_RETURN_TO_TAG.matcher(text).replaceAll("\\\\r");
        return NEWLINE_TO_TAG.matcher(text).replaceAll("\\\\n");
    }

    public static String printXpathBranch(String xpath, File file) throws CheckstyleException, IOException {
        try {
            RootNode rootNode = new RootNode(JavaParser.parseFile(file, JavaParser.Options.WITH_COMMENTS));
            List<NodeInfo> matchingItems = XpathUtil.getXpathItems(xpath, rootNode);
            return matchingItems.stream().map(item -> ((ElementNode)item).getUnderlyingNode()).map(AstTreeStringPrinter::printBranch).collect(Collectors.joining(DELIMITER));
        }
        catch (XPathException ex) {
            String errMsg = String.format(Locale.ROOT, "Error during evaluation for xpath: %s, file: %s", xpath, file.getCanonicalPath());
            throw new CheckstyleException(errMsg, ex);
        }
    }

    public static List<NodeInfo> getXpathItems(String xpath, AbstractNode rootNode) throws XPathException {
        XPathEvaluator xpathEvaluator = new XPathEvaluator(Configuration.newConfiguration());
        XPathExpression xpathExpression = xpathEvaluator.createExpression(xpath);
        XPathDynamicContext xpathDynamicContext = xpathExpression.createDynamicContext(rootNode);
        List<Item> items = xpathExpression.evaluate(xpathDynamicContext);
        return items.stream().map(NodeInfo.class::cast).collect(Collectors.toUnmodifiableList());
    }
}

