/*
 * Decompiled with CFR 0.152.
 */
package system;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;

public class Main {
    public static void main(String[] args) {
        String input = args[0];
        String output = args[1];
        boolean std = args.length >= 3;
        List<String> lines = Main.read(input);
        int bitInt = std ? 10 : Main.readPositiveInteger("BIT_INT: ");
        int bitHeap = std ? 3 : Main.readPositiveInteger("BIT_HEAP: ");
        int bitField = std ? 6 : Main.readPositiveInteger("BIT_FIELD: ");
        int bitObject = std ? 8 : Main.readPositiveInteger("BIT_OBJECT: ");
        LinkedList<String> newLines = new LinkedList<String>();
        for (String line : lines) {
            line = Main.replace(line, "#BIT_INT", Integer.toString(bitInt));
            line = Main.replace(line, "#BIT_HEAP", Integer.toString(bitHeap));
            line = Main.replace(line, "#BIT_FIELD", Integer.toString(bitField));
            line = Main.replace(line, "#BIT_OBJECT", Integer.toString(bitObject));
            line = Main.replaceOp(line, "<= ", "bvsle ");
            line = Main.replaceOp(line, ">= ", "bvsge ");
            line = Main.replaceOp(line, "\\+ ", "bvadd ");
            line = Main.replaceOp(line, "\\* ", "bvmul ");
            line = Main.replaceOp(line, "- ", "bvsub ");
            line = Main.replaceOp(line, "\\(> ", "(bvsgt ");
            line = Main.replaceOp(line, "\\(< ", "(bvslt ");
            line = Main.replaceConstants(line, bitInt);
            newLines.add(line);
        }
        Main.write(newLines, output);
    }

    private static String replaceOp(String line, String dest, String val) {
        return line.replaceAll(dest, val);
    }

    public static String replaceConstants(String line, int bitInt) {
        String[] words = line.split(" ");
        StringBuffer newWords = new StringBuffer();
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            Integer constant = Main.toInteger(word);
            if (constant != null) {
                String binary = Integer.toBinaryString(constant);
                if (binary.length() > bitInt) {
                    throw new RuntimeException("bit vector too small!");
                }
                int i = binary.length();
                while (i < bitInt) {
                    binary = "0" + binary;
                    ++i;
                }
                word = "#b" + binary;
            }
            newWords.append(String.valueOf(word) + " ");
            ++n2;
        }
        newWords.replace(newWords.length() - 1, newWords.length(), "");
        return newWords.toString();
    }

    public static Integer toInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String replace(String line, String dest, String val) {
        return line.replaceAll(dest, "(_ BitVec " + val + ")");
    }

    public static void write(List<String> lines, String output) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(output)));
            for (String line : lines) {
                writer.write(line);
                writer.write("\n");
            }
            writer.flush();
            writer.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> read(String input) {
        try {
            LinkedList<String> lines = new LinkedList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(new File(input)));
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
            return lines;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String readLine() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        try {
            line = br.readLine();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return line;
    }

    public static int readPositiveInteger(String title) {
        while (true) {
            try {
                int val;
                do {
                    System.out.print(title);
                } while ((val = Main.readInteger()) <= 0);
                return val;
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public static int readInteger() {
        return Integer.parseInt(Main.readLine());
    }
}

