# ZenOS
![2](https://github.com/user-attachments/assets/47cff0b6-14a5-44d6-9dda-248524830bcb)

- [ENG_README](https://github.com/Junsious/zen-kernel-OS/blob/main/README.md)

## Если у вас есть идеи, то не стесняйтесь и пишите их, создавайте ветки, проситесь в контрибьютеры, мы будем только рады увидеть новых людей в этом проекте 

## Описание

  
- `ZenOS` — это учебный проект, направленный на создание операционной системы с нуля. Проект включает в себя ядро, написанное на C и Rust, с базовой функциональностью вывода текста на экран и поддержки командного ввода. Этот проект предназначен для обучения основам разработки операционных систем, работы с кросс-компиляторами и понимания низкоуровневого программирования.

## Сборка и запуск

### Требования

- **Кросс-компилятор**: `i386-elf-gcc` и `i386-elf-as`
- **Утилита для создания ISO-образов**: `grub-mkrescue`
- **Эмулятор**: `QEMU`

### Сборка

1. **Клонируйте репозиторий**:

    ```bash
    git clone https://github.com/yourusername/zen-kernel-OS.git
    cd zen-kernel-OS
    ```

2. **Соберите проект**:

    ```bash
    make
    ```

3. **Запустите ISO-образ с помощью QEMU**:

    ```bash
    qemu-system-i386 -cdrom ZenOS.iso / qemu-system-i386 -cdrom ZenOS.bin -curses 
    ```

### Структура проекта

- **`kernel.c`** — Исходный код ядра на C.
- **`boot.asm`** — Ассемблерный код загрузчика.
- **`linker.ld`** — Скрипт линковщика, используемый для сборки ядра.
- **`grub.cfg`** — Конфигурационный файл GRUB для загрузки ядра.
- **`Makefile`** — Файл для автоматизации процесса сборки.
- **`keyboard_driver.c`** — Драйвер для вашей клавиатуры на С с поддержкой спец.символов.

## Разработка и Вклад

Если вы хотите внести свой вклад в проект, следуйте этим шагам:

1. **Создайте ветку**:

    ```bash
    git checkout -b feature-branch
    ```

2. **Внесите изменения** и протестируйте их.

3. **Сделайте коммит**:

    ```bash
    git commit -am 'Добавил новую функцию'
    ```

4. **Отправьте изменения**:

    ```bash
    git push origin feature-branch
    ```

5. **Создайте Pull Request** на GitHub, описав внесенные изменения и их цели.

## Лицензия

Этот проект лицензирован под лицензией GNU General Public License v3.0 (GPL-3.0). См. [LICENSE](LICENSE) для получения дополнительной информации.

## Контакты
Если у вас есть вопросы или предложения, вы можете связаться с разработчиком проекта через GitHub или по электронной почте: alexandrd542@gmail.com

## Авторы

Кодер - Junsious ([GitHub](https://github.com/junsious))

Дизайнер - Konrad ([GitHub](https://github.com/WilliamKonRaDDD))
---
