// Declare multiple shared resource buses
// that are concat on the device side
// primarily for separate clock domains
// could be used to prioritize arb if wanted to custom write handling of different domains different

#include "compiler.h"
#include "uintN_t.h"
#include "shared_resource_bus.h"

/*define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME          bus_name
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_TYPE_NAME     bus_type_t  
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_WR_REQ_TYPE   write_req_t 
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_WR_DATA_TYPE  write_data_t
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_WR_RESP_TYPE  write_resp_t
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_RD_REQ_TYPE   read_req_t
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_RD_DATA_TYPE  read_data_t
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_DEV_PORTS     1
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_DEV_CLK_MHZ   83.33
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_TOTAL_HOST_PORTS 2
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_NAME     cpu
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_PORTS    1
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_CLK_MHZ  83.33
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_NAME     i2s
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_PORTS    1
#define MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_CLK_MHZ  22.579*/

// Decl instance of shared buses, one per host clock domain
#ifdef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_NAME
#define SHARED_RESOURCE_BUS_NAME          PPCAT(PPCAT(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME,_),MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_NAME)
#define SHARED_RESOURCE_BUS_TYPE_NAME     MULTI_HOST_CLK_SHARED_RESOURCE_BUS_TYPE_NAME  
#define SHARED_RESOURCE_BUS_WR_REQ_TYPE   MULTI_HOST_CLK_SHARED_RESOURCE_BUS_WR_REQ_TYPE 
#define SHARED_RESOURCE_BUS_WR_DATA_TYPE  MULTI_HOST_CLK_SHARED_RESOURCE_BUS_WR_DATA_TYPE
#define SHARED_RESOURCE_BUS_WR_RESP_TYPE  MULTI_HOST_CLK_SHARED_RESOURCE_BUS_WR_RESP_TYPE
#define SHARED_RESOURCE_BUS_RD_REQ_TYPE   MULTI_HOST_CLK_SHARED_RESOURCE_BUS_RD_REQ_TYPE
#define SHARED_RESOURCE_BUS_RD_DATA_TYPE  MULTI_HOST_CLK_SHARED_RESOURCE_BUS_RD_DATA_TYPE   
#define SHARED_RESOURCE_BUS_HOST_PORTS    MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_PORTS
#define SHARED_RESOURCE_BUS_HOST_CLK_MHZ  MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_CLK_MHZ
#define SHARED_RESOURCE_BUS_DEV_PORTS     MULTI_HOST_CLK_SHARED_RESOURCE_BUS_DEV_PORTS
#define SHARED_RESOURCE_BUS_DEV_CLK_MHZ   MULTI_HOST_CLK_SHARED_RESOURCE_BUS_DEV_CLK_MHZ
#include "shared_resource_bus_decl.h"
#endif
#ifdef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_NAME
#define SHARED_RESOURCE_BUS_NAME          PPCAT(PPCAT(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME,_),MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_NAME)
#define SHARED_RESOURCE_BUS_TYPE_NAME     MULTI_HOST_CLK_SHARED_RESOURCE_BUS_TYPE_NAME  
#define SHARED_RESOURCE_BUS_WR_REQ_TYPE   MULTI_HOST_CLK_SHARED_RESOURCE_BUS_WR_REQ_TYPE 
#define SHARED_RESOURCE_BUS_WR_DATA_TYPE  MULTI_HOST_CLK_SHARED_RESOURCE_BUS_WR_DATA_TYPE
#define SHARED_RESOURCE_BUS_WR_RESP_TYPE  MULTI_HOST_CLK_SHARED_RESOURCE_BUS_WR_RESP_TYPE
#define SHARED_RESOURCE_BUS_RD_REQ_TYPE   MULTI_HOST_CLK_SHARED_RESOURCE_BUS_RD_REQ_TYPE
#define SHARED_RESOURCE_BUS_RD_DATA_TYPE  MULTI_HOST_CLK_SHARED_RESOURCE_BUS_RD_DATA_TYPE   
#define SHARED_RESOURCE_BUS_HOST_PORTS    MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_PORTS
#define SHARED_RESOURCE_BUS_HOST_CLK_MHZ  MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_CLK_MHZ
#define SHARED_RESOURCE_BUS_DEV_PORTS     MULTI_HOST_CLK_SHARED_RESOURCE_BUS_DEV_PORTS
#define SHARED_RESOURCE_BUS_DEV_CLK_MHZ   MULTI_HOST_CLK_SHARED_RESOURCE_BUS_DEV_CLK_MHZ
#include "shared_resource_bus_decl.h"
#endif
#ifdef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST2_NAME
#error "Increase multi_host_clk_shared_resource_bus_decl.h for more host domains!"
#endif

// Like SHARED_BUS_DECL
// declare a pair of global wires sized to match the total num host port,
// to be used on the dev side something like SHARED_BUS_ARB_PIPELINED macro for TOTAL_HOST_PORTS instead of just single host domain ports
PPCAT(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_TYPE_NAME, _host_to_dev_t) PPCAT(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME, _host_to_dev_wires_on_dev_clk)[MULTI_HOST_CLK_SHARED_RESOURCE_BUS_TOTAL_HOST_PORTS];
PPCAT(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_TYPE_NAME, _dev_to_host_t) PPCAT(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME, _dev_to_host_wires_on_dev_clk)[MULTI_HOST_CLK_SHARED_RESOURCE_BUS_TOTAL_HOST_PORTS];
// Connect dev side wires from the multi host clock SRB instances above
// into single pair to from array of wires in dev clock domain
MAIN_MHZ(PPCAT(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME,_dev_side_multi_host_domain_wiring), MULTI_HOST_CLK_SHARED_RESOURCE_BUS_DEV_CLK_MHZ)
PRAGMA_MESSAGE(FUNC_WIRES PPCAT(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME,_dev_side_multi_host_domain_wiring))
void PPCAT(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME,_dev_side_multi_host_domain_wiring)()
{
  // TODO macro this more...
  uint32_t mult_hosts_i = 0;
  uint32_t per_host_i;
  #ifdef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_NAME
  per_host_i = 0;
  while(per_host_i < MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_PORTS){
    PPCAT(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME, _host_to_dev_wires_on_dev_clk)[mult_hosts_i] 
      = multi_host_to_dev_clk(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME, MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_NAME)[per_host_i];
    dev_clk_to_multi_host(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME, MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_NAME)[per_host_i]
      = PPCAT(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME, _dev_to_host_wires_on_dev_clk)[mult_hosts_i];
    per_host_i += 1;
    mult_hosts_i += 1;
  }
  #endif
  #ifdef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_NAME
  per_host_i = 0;
  while(per_host_i < MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_PORTS){
    PPCAT(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME, _host_to_dev_wires_on_dev_clk)[mult_hosts_i] 
      = multi_host_to_dev_clk(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME, MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_NAME)[per_host_i];
    dev_clk_to_multi_host(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME, MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_NAME)[per_host_i]
      = PPCAT(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME, _dev_to_host_wires_on_dev_clk)[mult_hosts_i];
    per_host_i += 1;
    mult_hosts_i += 1;
  }
  #endif
  #ifdef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST2_NAME
  #error "Increase multi_host_clk_shared_resource_bus_decl.h for more host domains!"
  #endif
}

// Declare arbitration functions sized to MULTI_HOST_CLK_SHARED_RESOURCE_BUS_TOTAL_HOST_PORTS
SHARED_BUS_ARB_DECL(MULTI_HOST_CLK_SHARED_RESOURCE_BUS_TYPE_NAME, MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME, MULTI_HOST_CLK_SHARED_RESOURCE_BUS_TOTAL_HOST_PORTS, MULTI_HOST_CLK_SHARED_RESOURCE_BUS_DEV_PORTS) 

#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_NAME
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_TYPE_NAME 
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_WR_REQ_TYPE
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_WR_DATA_TYPE
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_WR_RESP_TYPE
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_RD_REQ_TYPE
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_RD_DATA_TYPE
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_DEV_PORTS
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_DEV_CLK_MHZ
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_TOTAL_HOST_PORTS
#ifdef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_NAME
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_NAME
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_PORTS
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST0_CLK_MHZ
#endif
#ifdef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_NAME
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_NAME
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_PORTS
#undef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST1_CLK_MHZ
#endif
#ifdef MULTI_HOST_CLK_SHARED_RESOURCE_BUS_HOST2_NAME
#error "Increase multi_host_clk_shared_resource_bus_decl.h for more host domains!"
#endif
