#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <math.h>

// How to send inputs over eth

// Build like:
// g++ pixels_to_eth.c -I ~/pipelinec_output -o pixels_to_eth

#include "mnist-neural-network-plain-c-master/mnist_file.c"
#include "mnist-neural-network-plain-c-master/neural_network.c"

// 'Software' side of ethernet
#include "../eth/eth_sw.c"

#include "pixels_update.h"
#include "type_bytes_t.h/pixels_update_t_bytes_t.h/pixels_update_t_bytes.h" // Autogenerated
void write_update(pixels_update_t* input)
{
 // Copy into buffer
 uint8_t buffer[pixels_update_t_SIZE];
 pixels_update_t_to_bytes(input, buffer);
 // Send buffer
 eth_write(buffer, pixels_update_t_SIZE);  
}

int main(int argc, char *argv[])
{
    // Init trained network
    neural_network_t network;
    float weight[MNIST_LABELS*MNIST_IMAGE_SIZE] = 
        #include "trained/weights.c"
    ;
    float bias[MNIST_LABELS] = 
        #include "trained/biases.c"
    ;
    float activations[MNIST_LABELS];
    int i, j;
    for (i = 0; i < MNIST_LABELS; i++) {
        network.b[i] = bias[i];

        for (j = 0; j < MNIST_IMAGE_SIZE; j++) {
            network.W[i][j] = weight[i*MNIST_IMAGE_SIZE + j];
        }
    }

    // Open stdin for reading pixels from video_to_pixels.py
    FILE* stdin_file = freopen(NULL, "rb", stdin);
    
    // Init msgs to/from FPGA
    init_eth();
    
    printf("Reading pixels, sending pixels...\n");
    pixels_update_t update;
    while(1)
    {
        // Read pixels update from python
        if( fread(&update, sizeof(pixels_update_t), 1, stdin_file) < 1 )
        {
            printf("No more updates...\n");
            break;
        }
        // Write pixels to FPGA
        write_update(&update);

        // Keep own copy of pixels and run against software network on camera image too
        mnist_image_t test_image;
        int addr = update.addr;
        int last_pixel = 0;
        for(i=0;i<N_PIXELS_PER_UPDATE;i++)
        {
            test_image.pixels[(addr*N_PIXELS_PER_UPDATE)+i] = update.pixels[i];
            last_pixel = ((addr*N_PIXELS_PER_UPDATE)+i) == (MNIST_IMAGE_SIZE-1);
        }
        if(last_pixel)
        {
            neural_network_hypothesis(&test_image, &network, activations);
            int predict = 0;
            float max_activation = activations[0];
            for (j = 0; j < MNIST_LABELS; j++) {
                if (max_activation < activations[j]) {
                    max_activation = activations[j];
                    predict = j;
                }
            }
            printf("Software prediction: %d\n", predict);
        }
    }
    fclose(stdin_file);

    // Close eth to/from FPGA
	close_eth();

    return 0;
}
