#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <math.h>

// How to receive outputs over eth

// Build like:
// g++ eth_to_prediction.c -I ~/pipelinec_output -o eth_to_pred

// 'Software' side of ethernet
#include "../eth/eth_sw.c"

#include "pred_resp.h"
#include "type_bytes_t.h/pred_resp_t_bytes_t.h/pred_resp_t_bytes.h" // Autogenerated
void read_prediction(pred_resp_t* output)
{
  // Read buffer
  uint8_t buffer[pred_resp_t_SIZE];
  size_t rd_size = pred_resp_t_SIZE;
  eth_read(buffer, &rd_size);
  if(rd_size != pred_resp_t_SIZE)
  {
    printf("Did not receive enough bytes! Expected %d, got %ld\n",pred_resp_t_SIZE,rd_size);
  }
  // Copy from buffer
  bytes_to_pred_resp_t(buffer,output);
}

int main(int argc, char *argv[])
{
    // Init msgs to/from FPGA
    init_eth();
    
    printf("Reading predictions...\n");
    while(1)
    {
        pred_resp_t resp;
        read_prediction(&resp);
        float fps = (1000.0/(float)resp.nanosec_since)*1.0e6;
        printf("FPGA Prediction: %d (%f inferences per second)\n", resp.pred, fps); 
    }

    // Close eth to/from FPGA
	  close_eth();

    return 0;
}
