#include "uintN_t.h"

#pragma MAIN_MHZ aes_ten_rounds 850.0

typedef struct state_t {
    uint8_t words[4][4];
} state_t;

uint8_t mulX(uint8_t x) {
    uint1_t tmp[8];
    uint1_t a = uint8_0_0(x);
    uint1_t b = uint8_1_1(x);
    uint1_t c = uint8_2_2(x);
    uint1_t d = uint8_3_3(x);
    uint1_t e = uint8_4_4(x);
    uint1_t f = uint8_5_5(x);
    uint1_t g = uint8_6_6(x);
    uint1_t h = uint8_7_7(x);

    tmp[0] = h;
    tmp[1] = h ^ a;
    tmp[2] = b;
    tmp[3] = h ^ c;
    tmp[4] = h ^ d;
    tmp[5] = e;
    tmp[6] = f;
    tmp[7] = g;

    return uint1_array8_le(tmp);
}

uint8_t sbox(uint8_t x) {
    uint8_t rom[256] = {
      0x63, 0x7c, 0x77, 0x7b, 0xf2, 0x6b, 0x6f, 0xc5, 0x30, 0x01, 0x67, 0x2b, 0xfe, 0xd7, 0xab, 0x76,
      0xca, 0x82, 0xc9, 0x7d, 0xfa, 0x59, 0x47, 0xf0, 0xad, 0xd4, 0xa2, 0xaf, 0x9c, 0xa4, 0x72, 0xc0,
      0xb7, 0xfd, 0x93, 0x26, 0x36, 0x3f, 0xf7, 0xcc, 0x34, 0xa5, 0xe5, 0xf1, 0x71, 0xd8, 0x31, 0x15,
      0x04, 0xc7, 0x23, 0xc3, 0x18, 0x96, 0x05, 0x9a, 0x07, 0x12, 0x80, 0xe2, 0xeb, 0x27, 0xb2, 0x75,
      0x09, 0x83, 0x2c, 0x1a, 0x1b, 0x6e, 0x5a, 0xa0, 0x52, 0x3b, 0xd6, 0xb3, 0x29, 0xe3, 0x2f, 0x84,
      0x53, 0xd1, 0x00, 0xed, 0x20, 0xfc, 0xb1, 0x5b, 0x6a, 0xcb, 0xbe, 0x39, 0x4a, 0x4c, 0x58, 0xcf,
      0xd0, 0xef, 0xaa, 0xfb, 0x43, 0x4d, 0x33, 0x85, 0x45, 0xf9, 0x02, 0x7f, 0x50, 0x3c, 0x9f, 0xa8,
      0x51, 0xa3, 0x40, 0x8f, 0x92, 0x9d, 0x38, 0xf5, 0xbc, 0xb6, 0xda, 0x21, 0x10, 0xff, 0xf3, 0xd2,
      0xcd, 0x0c, 0x13, 0xec, 0x5f, 0x97, 0x44, 0x17, 0xc4, 0xa7, 0x7e, 0x3d, 0x64, 0x5d, 0x19, 0x73,
      0x60, 0x81, 0x4f, 0xdc, 0x22, 0x2a, 0x90, 0x88, 0x46, 0xee, 0xb8, 0x14, 0xde, 0x5e, 0x0b, 0xdb,
      0xe0, 0x32, 0x3a, 0x0a, 0x49, 0x06, 0x24, 0x5c, 0xc2, 0xd3, 0xac, 0x62, 0x91, 0x95, 0xe4, 0x79,
      0xe7, 0xc8, 0x37, 0x6d, 0x8d, 0xd5, 0x4e, 0xa9, 0x6c, 0x56, 0xf4, 0xea, 0x65, 0x7a, 0xae, 0x08,
      0xba, 0x78, 0x25, 0x2e, 0x1c, 0xa6, 0xb4, 0xc6, 0xe8, 0xdd, 0x74, 0x1f, 0x4b, 0xbd, 0x8b, 0x8a,
      0x70, 0x3e, 0xb5, 0x66, 0x48, 0x03, 0xf6, 0x0e, 0x61, 0x35, 0x57, 0xb9, 0x86, 0xc1, 0x1d, 0x9e,
      0xe1, 0xf8, 0x98, 0x11, 0x69, 0xd9, 0x8e, 0x94, 0x9b, 0x1e, 0x87, 0xe9, 0xce, 0x55, 0x28, 0xdf,
      0x8c, 0xa1, 0x89, 0x0d, 0xbf, 0xe6, 0x42, 0x68, 0x41, 0x99, 0x2d, 0x0f, 0xb0, 0x54, 0xbb, 0x16
    };
    return rom[x];
}

state_t sub_bytes(state_t state) {
    state_t res;
    
    uint32_t i;
    for (i = 0; i < 4; i += 1) {
        res.words[i][0] = sbox(state.words[i][0]);
        res.words[i][1] = sbox(state.words[i][1]);
        res.words[i][2] = sbox(state.words[i][2]);
        res.words[i][3] = sbox(state.words[i][3]);
    }
    return res;
}

state_t shift_rows(state_t state) {
    state_t res;

    uint32_t i;
    for (i = 0; i < 4; i += 1) {
        res.words[i][0] = state.words[i][(0 + i) % 4];
        res.words[i][1] = state.words[i][(1 + i) % 4];
        res.words[i][2] = state.words[i][(2 + i) % 4];
        res.words[i][3] = state.words[i][(3 + i) % 4];
    }
    return res;
}

state_t mix_cols(state_t state) {
    uint8_t innerTmp[4][4];
    uint8_t outerTmp[4];
    state_t res;

    uint32_t j;
    for (j = 0; j < 4; j += 1) {
        innerTmp[0][j] = state.words[0][j] ^ state.words[1][j];
        innerTmp[1][j] = state.words[1][j] ^ state.words[2][j];
        innerTmp[2][j] = state.words[2][j] ^ state.words[3][j];
        innerTmp[3][j] = state.words[3][j] ^ state.words[0][j];

        outerTmp[j] = innerTmp[0][j] ^ innerTmp[2][j];

        res.words[0][j] = state.words[0][j] ^ outerTmp[j] ^ mulX(innerTmp[0][j]);
        res.words[1][j] = state.words[1][j] ^ outerTmp[j] ^ mulX(innerTmp[1][j]);
        res.words[2][j] = state.words[2][j] ^ outerTmp[j] ^ mulX(innerTmp[2][j]);
        res.words[3][j] = state.words[3][j] ^ outerTmp[j] ^ mulX(innerTmp[3][j]);
    }
    return res;
}

state_t add_key(state_t state, uint128_t key) {
    state_t res;
    
    uint32_t i;
    for (i = 0; i < 4; i += 1) {
        res.words[0][i] = state.words[0][i] ^ (uint8_t) (key >> (i * 32 + 0));
        res.words[1][i] = state.words[1][i] ^ (uint8_t) (key >> (i * 32 + 8));
        res.words[2][i] = state.words[2][i] ^ (uint8_t) (key >> (i * 32 + 16));
        res.words[3][i] = state.words[3][i] ^ (uint8_t) (key >> (i * 32 + 24));
    }
    return res;
}

state_t aesenc(state_t state, uint128_t key) {
    state_t tmp;
    tmp = sub_bytes(state);
    tmp = shift_rows(tmp);
    tmp = mix_cols(tmp);
    tmp = add_key(tmp, key);
    return tmp;
}

state_t aesenclast(state_t state, uint128_t key) {
    state_t tmp;
    tmp = sub_bytes(state);
    tmp = shift_rows(tmp);
    tmp = add_key(tmp, key);
    return tmp;
}

// AES minus the initial add_key and key expansion.
// For benchmarking purposes only.
state_t aes_ten_rounds(state_t state, uint128_t keys[10]) {
    state_t tmp = state;
    uint32_t i;
    for (i = 0; i < 9; i += 1) {
        tmp = aesenc(tmp, keys[i]);
    }
    tmp = aesenclast(tmp, keys[9]);
    return tmp;
}
