#!/usr/bin/env python3
## -*- coding: utf-8 -*-

from __future__          import print_function
from triton              import *
from unicorn             import *
from unicorn.arm_const   import *

import pprint
import random
import sys

ADDR  = 0x100000
STACK = 0x200000
HEAP  = 0x300000
SIZE  = 5 * 1024 * 1024

CODE  = [
    # MISC ------------------------------------------------------------------- #
    (b"\x41\x01\xb0\xe1", "asrs r0, r1, #2"),

    (b"\xde\x0f\x10\xe3", "tst r0, #888"),
    (b"\xde\x0f\x00\xe2", "and r0, #888"),

    (b"\xde\x0f\x20\xe2", "eor r0, #888"),

    (b"\xde\x0f\x10\xe3", "tst r0, #888"),
    (b"\xde\x0f\x10\xe2", "ands r0, #888"),
    (b"\xde\x0f\x30\xe2", "eors r0, #888"),
    (b"\xde\x0f\x90\xe3", "orrs r0, #888"),
    (b"\xde\x0f\xf0\xe3", "mvns r0, #888"),

    (b"\x00\x00\x10\xe0", "ands r0, r0, r0"),
    (b"\x00\x00\x10\xe0", "ands r0, r0"),
    (b"\xde\x0f\x80\xe3", "orr r0, #888"),
    (b"\x30\x0f\xbf\xe6", "rev r0, r0"),
    (b"\x00\xf0\x20\xe3", "nop"),
    (b"\xb0\x0f\xbf\xe6", "rev16 r0, r0"),

    (b"\x00\x00\xa0\xe1", "asr r0, #0"),
    (b"\xc0\x0f\xa0\xe1", "asr r0, #31"),
    (b"\xc1\x0f\xa0\xe1", "asr r0, r1, #31"),       # NOTE: The constant #31 is interpreted as a shift.
    (b"\x51\x02\xa0\xe1", "asr r0, r1, r2"),
    (b"\x51\x03\xa0\xe1", "mov r0, r1, asr r3"),    # NOTE: It an alias for 'asr r0, r1, r3'.
    (b"\x00\x00\xb0\xe1", "asrs r0, #0"),           # NOTE: It an alias for 'movs r0, r0'.
    (b"\xc0\x0f\xb0\xe1", "asrs r0, #31"),
    (b"\xc1\x0f\xb0\xe1", "asrs r0, r1, #31"),      # NOTE: The 2nd operand is interpreted as a register-shifted register (namely, 'r1, #31')
    (b"\xc1\x1f\xb0\xe1", "asrs r1, r1, #31"),      # NOTE: Same as previous. However, in THUMB the 2nd operand is interpreted as a registera and the 3rd as an immediate (namely, 'r1' and '#31', respectively)
    (b"\x51\x02\xb0\xe1", "asrs r0, r1, r2"),
    (b"\x51\x03\xb0\xe1", "movs r0, r1, asr r3"),

    (b"\x00\x00\xa0\xe1", "lsl r0, #0"),
    (b"\x80\x0f\xa0\xe1", "lsl r0, #31"),
    (b"\x81\x0f\xa0\xe1", "lsl r0, r1, #31"),
    (b"\x11\x02\xa0\xe1", "lsl r0, r1, r2"),
    (b"\x11\x03\xa0\xe1", "mov r0, r1, lsl r3"),
    (b"\x00\x00\xb0\xe1", "lsls r0, #0"),
    (b"\x80\x0f\xb0\xe1", "lsls r0, #31"),
    (b"\x81\x0f\xb0\xe1", "lsls r0, r1, #31"),
    (b"\x11\x02\xb0\xe1", "lsls r0, r1, r2"),
    (b"\x11\x03\xb0\xe1", "movs r0, r1, lsl r3"),

    (b"\x00\x00\xa0\xe1", "lsr r0, #0"),
    (b"\xa0\x0f\xa0\xe1", "lsr r0, #31"),
    (b"\xa1\x0f\xa0\xe1", "lsr r0, r1, #31"),
    (b"\x31\x02\xa0\xe1", "lsr r0, r1, r2"),
    (b"\x31\x03\xa0\xe1", "mov r0, r1, lsr r3"),
    (b"\x00\x00\xb0\xe1", "lsrs r0, #0"),
    (b"\xa0\x0f\xb0\xe1", "lsrs r0, #31"),
    (b"\xa1\x0f\xb0\xe1", "lsrs r0, r1, #31"),
    (b"\x31\x02\xb0\xe1", "lsrs r0, r1, r2"),
    (b"\x31\x03\xb0\xe1", "movs r0, r1, lsr r3"),

    (b"\x00\x00\xa0\xe1", "ror r0, #0"),
    (b"\xe0\x0f\xa0\xe1", "ror r0, #31"),
    (b"\xe1\x0f\xa0\xe1", "ror r0, r1, #31"),
    (b"\x71\x02\xa0\xe1", "ror r0, r1, r2"),
    (b"\x71\x03\xa0\xe1", "mov r0, r1, ror r3"),
    (b"\x00\x00\xb0\xe1", "rors r0, #0"),
    (b"\xe0\x0f\xb0\xe1", "rors r0, #31"),
    (b"\xe1\x0f\xb0\xe1", "rors r0, r1, #31"),
    (b"\x71\x02\xb0\xe1", "rors r0, r1, r2"),
    (b"\x71\x03\xb0\xe1", "movs r0, r1, ror r3"),

    (b"\x61\x00\xa0\xe1", "rrx r0, r1"),
    (b"\x61\x00\xa0\xe1", "mov r0, r1, rrx"),
    (b"\x61\x00\xb0\xe1", "rrxs r0, r1"),
    (b"\x61\x00\xb0\xe1", "movs r0, r1, rrx"),

    (b"\x00\xc0\x8f\xe2", "add ip, pc, #0, 12"),
    (b"\x00\xc0\x8f\xe2", "add ip, pc, #0"),
    (b"\x10\xca\x8c\xe2", "add ip, ip, #16, #20"),
    (b"\x01\xc8\x8c\xe2", "add ip, ip, #0x10000"),
    (b"\x10\xc0\x8c\xe2", "add ip, ip, #16"),
    (b"\x10\xc0\x8c\xe2", "add ip, ip, #16, #0"),

    (b"\x10\x0a\xa0\xe2", "adc r0, r0, #16, #20"),
    (b"\x10\x0a\x80\xe2", "add r0, r0, #16, #20"),
    (b"\x10\x0a\x00\xe2", "and r0, r0, #16, #20"),
    (b"\x10\x0a\xc0\xe3", "bic r0, r0, #16, #20"),
    (b"\x10\x0a\x20\xe2", "eor r0, r0, #16, #20"),
    (b"\x10\x0a\x80\xe3", "orr r0, r0, #16, #20"),
    (b"\x10\x0a\x60\xe2", "rsb r0, r0, #16, #20"),
    (b"\x10\x0a\xe0\xe2", "rsc r0, r0, #16, #20"),
    (b"\x10\x0a\xc0\xe2", "sbc r0, r0, #16, #20"),
    (b"\x10\x0a\x40\xe2", "sub r0, r0, #16, #20"),

    (b"\x16\x40\xdf\xe7", "bfi r4, r6, #0, #32"),
    (b"\x16\x40\xde\xe7", "bfi r4, r6, #0, #31"),
    (b"\x96\x4f\xdf\xe7", "bfi r4, r6, #31, #1"),
    (b"\x16\x40\xc0\xe7", "bfi r4, r6, #0, #1"),

    (b"\x1f\x40\xdf\xe7", "bfc r4, #0, #32"),
    (b"\x1f\x40\xde\xe7", "bfc r4, #0, #31"),
    (b"\x9f\x4f\xdf\xe7", "bfc r4, #31, #1"),
    (b"\x1f\x40\xc0\xe7", "bfc r4, #0, #1"),

    # ADC -------------------------------------------------------------------- #
    (b"\x02\x00\xa1\xe2", "adc r0, r1, #2"),
    (b"\x02\x00\xa1\x02", "adceq r0, r1, #2"),
    (b"\x02\x00\xa1\x12", "adcne r0, r1, #2"),
    (b"\x02\x00\xa1\x22", "adccs r0, r1, #2"),
    (b"\x02\x00\xa1\x32", "adccc r0, r1, #2"),
    (b"\x02\x00\xa1\x42", "adcmi r0, r1, #2"),
    (b"\x02\x00\xa1\x52", "adcpl r0, r1, #2"),
    (b"\x02\x00\xa1\x62", "adcvs r0, r1, #2"),
    (b"\x02\x00\xa1\x72", "adcvc r0, r1, #2"),
    (b"\x02\x00\xa1\x82", "adchi r0, r1, #2"),
    (b"\x02\x00\xa1\x92", "adcls r0, r1, #2"),
    (b"\x02\x00\xa1\xa2", "adcge r0, r1, #2"),
    (b"\x02\x00\xa1\xb2", "adclt r0, r1, #2"),
    (b"\x02\x00\xa1\xc2", "adcgt r0, r1, #2"),
    (b"\x02\x00\xa1\xd2", "adcle r0, r1, #2"),
    (b"\x02\x00\xa1\xe2", "adcal r0, r1, #2"),

    (b"\x03\x00\xa1\xe0", "adc r0, r1, r3"),
    (b"\x03\x00\xa1\x00", "adceq r0, r1, r3"),
    (b"\x03\x00\xa1\x10", "adcne r0, r1, r3"),
    (b"\x03\x00\xa1\x20", "adccs r0, r1, r3"),
    (b"\x03\x00\xa1\x30", "adccc r0, r1, r3"),
    (b"\x03\x00\xa1\x40", "adcmi r0, r1, r3"),
    (b"\x03\x00\xa1\x50", "adcpl r0, r1, r3"),
    (b"\x03\x00\xa1\x60", "adcvs r0, r1, r3"),
    (b"\x03\x00\xa1\x70", "adcvc r0, r1, r3"),
    (b"\x03\x00\xa1\x80", "adchi r0, r1, r3"),
    (b"\x03\x00\xa1\x90", "adcls r0, r1, r3"),
    (b"\x03\x00\xa1\xa0", "adcge r0, r1, r3"),
    (b"\x03\x00\xa1\xb0", "adclt r0, r1, r3"),
    (b"\x03\x00\xa1\xc0", "adcgt r0, r1, r3"),
    (b"\x03\x00\xa1\xd0", "adcle r0, r1, r3"),
    (b"\x03\x00\xa1\xe0", "adcal r0, r1, r3"),

    # ADC - ASR Shifter
    (b"\x42\x02\xa1\x00", "adceq r0, r1, r2, asr #4"),
    (b"\x42\x02\xa1\x10", "adcne r0, r1, r2, asr #4"),
    (b"\x42\x02\xa1\x20", "adccs r0, r1, r2, asr #4"),
    (b"\x42\x02\xa1\x30", "adccc r0, r1, r2, asr #4"),
    (b"\x42\x02\xa1\x40", "adcmi r0, r1, r2, asr #4"),
    (b"\x42\x02\xa1\x50", "adcpl r0, r1, r2, asr #4"),
    (b"\x42\x02\xa1\x60", "adcvs r0, r1, r2, asr #4"),
    (b"\x42\x02\xa1\x70", "adcvc r0, r1, r2, asr #4"),
    (b"\x42\x02\xa1\x80", "adchi r0, r1, r2, asr #4"),
    (b"\x42\x02\xa1\x90", "adcls r0, r1, r2, asr #4"),
    (b"\x42\x02\xa1\xa0", "adcge r0, r1, r2, asr #4"),
    (b"\x42\x02\xa1\xb0", "adclt r0, r1, r2, asr #4"),
    (b"\x42\x02\xa1\xc0", "adcgt r0, r1, r2, asr #4"),
    (b"\x42\x02\xa1\xd0", "adcle r0, r1, r2, asr #4"),
    (b"\x42\x02\xa1\xe0", "adcal r0, r1, r2, asr #4"),

    (b"\x52\x03\xa1\x00", "adceq r0, r1, r2, asr r3"),
    (b"\x52\x03\xa1\x10", "adcne r0, r1, r2, asr r3"),
    (b"\x52\x03\xa1\x20", "adccs r0, r1, r2, asr r3"),
    (b"\x52\x03\xa1\x30", "adccc r0, r1, r2, asr r3"),
    (b"\x52\x03\xa1\x40", "adcmi r0, r1, r2, asr r3"),
    (b"\x52\x03\xa1\x50", "adcpl r0, r1, r2, asr r3"),
    (b"\x52\x03\xa1\x60", "adcvs r0, r1, r2, asr r3"),
    (b"\x52\x03\xa1\x70", "adcvc r0, r1, r2, asr r3"),
    (b"\x52\x03\xa1\x80", "adchi r0, r1, r2, asr r3"),
    (b"\x52\x03\xa1\x90", "adcls r0, r1, r2, asr r3"),
    (b"\x52\x03\xa1\xa0", "adcge r0, r1, r2, asr r3"),
    (b"\x52\x03\xa1\xb0", "adclt r0, r1, r2, asr r3"),
    (b"\x52\x03\xa1\xc0", "adcgt r0, r1, r2, asr r3"),
    (b"\x52\x03\xa1\xd0", "adcle r0, r1, r2, asr r3"),
    (b"\x52\x03\xa1\xe0", "adcal r0, r1, r2, asr r3"),

    # ADC - LSL Shifter
    (b"\x02\x02\xa1\x00", "adceq r0, r1, r2, lsl #4"),
    (b"\x02\x02\xa1\x10", "adcne r0, r1, r2, lsl #4"),
    (b"\x02\x02\xa1\x20", "adccs r0, r1, r2, lsl #4"),
    (b"\x02\x02\xa1\x30", "adccc r0, r1, r2, lsl #4"),
    (b"\x02\x02\xa1\x40", "adcmi r0, r1, r2, lsl #4"),
    (b"\x02\x02\xa1\x50", "adcpl r0, r1, r2, lsl #4"),
    (b"\x02\x02\xa1\x60", "adcvs r0, r1, r2, lsl #4"),
    (b"\x02\x02\xa1\x70", "adcvc r0, r1, r2, lsl #4"),
    (b"\x02\x02\xa1\x80", "adchi r0, r1, r2, lsl #4"),
    (b"\x02\x02\xa1\x90", "adcls r0, r1, r2, lsl #4"),
    (b"\x02\x02\xa1\xa0", "adcge r0, r1, r2, lsl #4"),
    (b"\x02\x02\xa1\xb0", "adclt r0, r1, r2, lsl #4"),
    (b"\x02\x02\xa1\xc0", "adcgt r0, r1, r2, lsl #4"),
    (b"\x02\x02\xa1\xd0", "adcle r0, r1, r2, lsl #4"),
    (b"\x02\x02\xa1\xe0", "adcal r0, r1, r2, lsl #4"),

    (b"\x12\x03\xa1\x00", "adceq r0, r1, r2, lsl r3"),
    (b"\x12\x03\xa1\x10", "adcne r0, r1, r2, lsl r3"),
    (b"\x12\x03\xa1\x20", "adccs r0, r1, r2, lsl r3"),
    (b"\x12\x03\xa1\x30", "adccc r0, r1, r2, lsl r3"),
    (b"\x12\x03\xa1\x40", "adcmi r0, r1, r2, lsl r3"),
    (b"\x12\x03\xa1\x50", "adcpl r0, r1, r2, lsl r3"),
    (b"\x12\x03\xa1\x60", "adcvs r0, r1, r2, lsl r3"),
    (b"\x12\x03\xa1\x70", "adcvc r0, r1, r2, lsl r3"),
    (b"\x12\x03\xa1\x80", "adchi r0, r1, r2, lsl r3"),
    (b"\x12\x03\xa1\x90", "adcls r0, r1, r2, lsl r3"),
    (b"\x12\x03\xa1\xa0", "adcge r0, r1, r2, lsl r3"),
    (b"\x12\x03\xa1\xb0", "adclt r0, r1, r2, lsl r3"),
    (b"\x12\x03\xa1\xc0", "adcgt r0, r1, r2, lsl r3"),
    (b"\x12\x03\xa1\xd0", "adcle r0, r1, r2, lsl r3"),
    (b"\x12\x03\xa1\xe0", "adcal r0, r1, r2, lsl r3"),

    # ADC - LSR Shifter
    (b"\x22\x02\xa1\x00", "adceq r0, r1, r2, lsr #4"),
    (b"\x22\x02\xa1\x10", "adcne r0, r1, r2, lsr #4"),
    (b"\x22\x02\xa1\x20", "adccs r0, r1, r2, lsr #4"),
    (b"\x22\x02\xa1\x30", "adccc r0, r1, r2, lsr #4"),
    (b"\x22\x02\xa1\x40", "adcmi r0, r1, r2, lsr #4"),
    (b"\x22\x02\xa1\x50", "adcpl r0, r1, r2, lsr #4"),
    (b"\x22\x02\xa1\x60", "adcvs r0, r1, r2, lsr #4"),
    (b"\x22\x02\xa1\x70", "adcvc r0, r1, r2, lsr #4"),
    (b"\x22\x02\xa1\x80", "adchi r0, r1, r2, lsr #4"),
    (b"\x22\x02\xa1\x90", "adcls r0, r1, r2, lsr #4"),
    (b"\x22\x02\xa1\xa0", "adcge r0, r1, r2, lsr #4"),
    (b"\x22\x02\xa1\xb0", "adclt r0, r1, r2, lsr #4"),
    (b"\x22\x02\xa1\xc0", "adcgt r0, r1, r2, lsr #4"),
    (b"\x22\x02\xa1\xd0", "adcle r0, r1, r2, lsr #4"),
    (b"\x22\x02\xa1\xe0", "adcal r0, r1, r2, lsr #4"),

    (b"\x32\x03\xa1\x00", "adceq r0, r1, r2, lsr r3"),
    (b"\x32\x03\xa1\x10", "adcne r0, r1, r2, lsr r3"),
    (b"\x32\x03\xa1\x20", "adccs r0, r1, r2, lsr r3"),
    (b"\x32\x03\xa1\x30", "adccc r0, r1, r2, lsr r3"),
    (b"\x32\x03\xa1\x40", "adcmi r0, r1, r2, lsr r3"),
    (b"\x32\x03\xa1\x50", "adcpl r0, r1, r2, lsr r3"),
    (b"\x32\x03\xa1\x60", "adcvs r0, r1, r2, lsr r3"),
    (b"\x32\x03\xa1\x70", "adcvc r0, r1, r2, lsr r3"),
    (b"\x32\x03\xa1\x80", "adchi r0, r1, r2, lsr r3"),
    (b"\x32\x03\xa1\x90", "adcls r0, r1, r2, lsr r3"),
    (b"\x32\x03\xa1\xa0", "adcge r0, r1, r2, lsr r3"),
    (b"\x32\x03\xa1\xb0", "adclt r0, r1, r2, lsr r3"),
    (b"\x32\x03\xa1\xc0", "adcgt r0, r1, r2, lsr r3"),
    (b"\x32\x03\xa1\xd0", "adcle r0, r1, r2, lsr r3"),
    (b"\x32\x03\xa1\xe0", "adcal r0, r1, r2, lsr r3"),

    # ADC - ROR Shifter
    (b"\x62\x02\xa1\x00", "adceq r0, r1, r2, ror #4"),
    (b"\x62\x02\xa1\x10", "adcne r0, r1, r2, ror #4"),
    (b"\x62\x02\xa1\x20", "adccs r0, r1, r2, ror #4"),
    (b"\x62\x02\xa1\x30", "adccc r0, r1, r2, ror #4"),
    (b"\x62\x02\xa1\x40", "adcmi r0, r1, r2, ror #4"),
    (b"\x62\x02\xa1\x50", "adcpl r0, r1, r2, ror #4"),
    (b"\x62\x02\xa1\x60", "adcvs r0, r1, r2, ror #4"),
    (b"\x62\x02\xa1\x70", "adcvc r0, r1, r2, ror #4"),
    (b"\x62\x02\xa1\x80", "adchi r0, r1, r2, ror #4"),
    (b"\x62\x02\xa1\x90", "adcls r0, r1, r2, ror #4"),
    (b"\x62\x02\xa1\xa0", "adcge r0, r1, r2, ror #4"),
    (b"\x62\x02\xa1\xb0", "adclt r0, r1, r2, ror #4"),
    (b"\x62\x02\xa1\xc0", "adcgt r0, r1, r2, ror #4"),
    (b"\x62\x02\xa1\xd0", "adcle r0, r1, r2, ror #4"),
    (b"\x62\x02\xa1\xe0", "adcal r0, r1, r2, ror #4"),

    (b"\x72\x03\xa1\x00", "adceq r0, r1, r2, ror r3"),
    (b"\x72\x03\xa1\x10", "adcne r0, r1, r2, ror r3"),
    (b"\x72\x03\xa1\x20", "adccs r0, r1, r2, ror r3"),
    (b"\x72\x03\xa1\x30", "adccc r0, r1, r2, ror r3"),
    (b"\x72\x03\xa1\x40", "adcmi r0, r1, r2, ror r3"),
    (b"\x72\x03\xa1\x50", "adcpl r0, r1, r2, ror r3"),
    (b"\x72\x03\xa1\x60", "adcvs r0, r1, r2, ror r3"),
    (b"\x72\x03\xa1\x70", "adcvc r0, r1, r2, ror r3"),
    (b"\x72\x03\xa1\x80", "adchi r0, r1, r2, ror r3"),
    (b"\x72\x03\xa1\x90", "adcls r0, r1, r2, ror r3"),
    (b"\x72\x03\xa1\xa0", "adcge r0, r1, r2, ror r3"),
    (b"\x72\x03\xa1\xb0", "adclt r0, r1, r2, ror r3"),
    (b"\x72\x03\xa1\xc0", "adcgt r0, r1, r2, ror r3"),
    (b"\x72\x03\xa1\xd0", "adcle r0, r1, r2, ror r3"),
    (b"\x72\x03\xa1\xe0", "adcal r0, r1, r2, ror r3"),

    # ADC - RRX Shifter
    (b"\x62\x00\xa1\x00", "adceq r0, r1, r2, rrx"),
    (b"\x62\x00\xa1\x10", "adcne r0, r1, r2, rrx"),
    (b"\x62\x00\xa1\x20", "adccs r0, r1, r2, rrx"),
    (b"\x62\x00\xa1\x30", "adccc r0, r1, r2, rrx"),
    (b"\x62\x00\xa1\x40", "adcmi r0, r1, r2, rrx"),
    (b"\x62\x00\xa1\x50", "adcpl r0, r1, r2, rrx"),
    (b"\x62\x00\xa1\x60", "adcvs r0, r1, r2, rrx"),
    (b"\x62\x00\xa1\x70", "adcvc r0, r1, r2, rrx"),
    (b"\x62\x00\xa1\x80", "adchi r0, r1, r2, rrx"),
    (b"\x62\x00\xa1\x90", "adcls r0, r1, r2, rrx"),
    (b"\x62\x00\xa1\xa0", "adcge r0, r1, r2, rrx"),
    (b"\x62\x00\xa1\xb0", "adclt r0, r1, r2, rrx"),
    (b"\x62\x00\xa1\xc0", "adcgt r0, r1, r2, rrx"),
    (b"\x62\x00\xa1\xd0", "adcle r0, r1, r2, rrx"),
    (b"\x62\x00\xa1\xe0", "adcal r0, r1, r2, rrx"),

    # ADCS ------------------------------------------------------------------- #
    (b"\x02\x00\xb1\xe2", "adcs r0, r1, #2"),
    (b"\x02\x00\xb1\x02", "adcseq r0, r1, #2"),
    (b"\x02\x00\xb1\x12", "adcsne r0, r1, #2"),
    (b"\x02\x00\xb1\x22", "adcscs r0, r1, #2"),
    (b"\x02\x00\xb1\x32", "adcscc r0, r1, #2"),
    (b"\x02\x00\xb1\x42", "adcsmi r0, r1, #2"),
    (b"\x02\x00\xb1\x52", "adcspl r0, r1, #2"),
    (b"\x02\x00\xb1\x62", "adcsvs r0, r1, #2"),
    (b"\x02\x00\xb1\x72", "adcsvc r0, r1, #2"),
    (b"\x02\x00\xb1\x82", "adcshi r0, r1, #2"),
    (b"\x02\x00\xb1\x92", "adcsls r0, r1, #2"),
    (b"\x02\x00\xb1\xa2", "adcsge r0, r1, #2"),
    (b"\x02\x00\xb1\xb2", "adcslt r0, r1, #2"),
    (b"\x02\x00\xb1\xc2", "adcsgt r0, r1, #2"),
    (b"\x02\x00\xb1\xd2", "adcsle r0, r1, #2"),
    (b"\x02\x00\xb1\xe2", "adcsal r0, r1, #2"),

    (b"\x03\x00\xb1\xe0", "adcs r0, r1, r3"),
    (b"\x03\x00\xb1\x00", "adcseq r0, r1, r3"),
    (b"\x03\x00\xb1\x10", "adcsne r0, r1, r3"),
    (b"\x03\x00\xb1\x20", "adcscs r0, r1, r3"),
    (b"\x03\x00\xb1\x30", "adcscc r0, r1, r3"),
    (b"\x03\x00\xb1\x40", "adcsmi r0, r1, r3"),
    (b"\x03\x00\xb1\x50", "adcspl r0, r1, r3"),
    (b"\x03\x00\xb1\x60", "adcsvs r0, r1, r3"),
    (b"\x03\x00\xb1\x70", "adcsvc r0, r1, r3"),
    (b"\x03\x00\xb1\x80", "adcshi r0, r1, r3"),
    (b"\x03\x00\xb1\x90", "adcsls r0, r1, r3"),
    (b"\x03\x00\xb1\xa0", "adcsge r0, r1, r3"),
    (b"\x03\x00\xb1\xb0", "adcslt r0, r1, r3"),
    (b"\x03\x00\xb1\xc0", "adcsgt r0, r1, r3"),
    (b"\x03\x00\xb1\xd0", "adcsle r0, r1, r3"),
    (b"\x03\x00\xb1\xe0", "adcsal r0, r1, r3"),

    # ADCS - ASR Shifter
    (b"\x42\x02\xb1\x00", "adcseq r0, r1, r2, asr #4"),
    (b"\x42\x02\xb1\x10", "adcsne r0, r1, r2, asr #4"),
    (b"\x42\x02\xb1\x20", "adcscs r0, r1, r2, asr #4"),
    (b"\x42\x02\xb1\x30", "adcscc r0, r1, r2, asr #4"),
    (b"\x42\x02\xb1\x40", "adcsmi r0, r1, r2, asr #4"),
    (b"\x42\x02\xb1\x50", "adcspl r0, r1, r2, asr #4"),
    (b"\x42\x02\xb1\x60", "adcsvs r0, r1, r2, asr #4"),
    (b"\x42\x02\xb1\x70", "adcsvc r0, r1, r2, asr #4"),
    (b"\x42\x02\xb1\x80", "adcshi r0, r1, r2, asr #4"),
    (b"\x42\x02\xb1\x90", "adcsls r0, r1, r2, asr #4"),
    (b"\x42\x02\xb1\xa0", "adcsge r0, r1, r2, asr #4"),
    (b"\x42\x02\xb1\xb0", "adcslt r0, r1, r2, asr #4"),
    (b"\x42\x02\xb1\xc0", "adcsgt r0, r1, r2, asr #4"),
    (b"\x42\x02\xb1\xd0", "adcsle r0, r1, r2, asr #4"),
    (b"\x42\x02\xb1\xe0", "adcsal r0, r1, r2, asr #4"),

    (b"\x52\x03\xb1\x00", "adcseq r0, r1, r2, asr r3"),
    (b"\x52\x03\xb1\x10", "adcsne r0, r1, r2, asr r3"),
    (b"\x52\x03\xb1\x20", "adcscs r0, r1, r2, asr r3"),
    (b"\x52\x03\xb1\x30", "adcscc r0, r1, r2, asr r3"),
    (b"\x52\x03\xb1\x40", "adcsmi r0, r1, r2, asr r3"),
    (b"\x52\x03\xb1\x50", "adcspl r0, r1, r2, asr r3"),
    (b"\x52\x03\xb1\x60", "adcsvs r0, r1, r2, asr r3"),
    (b"\x52\x03\xb1\x70", "adcsvc r0, r1, r2, asr r3"),
    (b"\x52\x03\xb1\x80", "adcshi r0, r1, r2, asr r3"),
    (b"\x52\x03\xb1\x90", "adcsls r0, r1, r2, asr r3"),
    (b"\x52\x03\xb1\xa0", "adcsge r0, r1, r2, asr r3"),
    (b"\x52\x03\xb1\xb0", "adcslt r0, r1, r2, asr r3"),
    (b"\x52\x03\xb1\xc0", "adcsgt r0, r1, r2, asr r3"),
    (b"\x52\x03\xb1\xd0", "adcsle r0, r1, r2, asr r3"),
    (b"\x52\x03\xb1\xe0", "adcsal r0, r1, r2, asr r3"),

    # ADCS - LSL Shifter
    (b"\x02\x02\xb1\x00", "adcseq r0, r1, r2, lsl #4"),
    (b"\x02\x02\xb1\x10", "adcsne r0, r1, r2, lsl #4"),
    (b"\x02\x02\xb1\x20", "adcscs r0, r1, r2, lsl #4"),
    (b"\x02\x02\xb1\x30", "adcscc r0, r1, r2, lsl #4"),
    (b"\x02\x02\xb1\x40", "adcsmi r0, r1, r2, lsl #4"),
    (b"\x02\x02\xb1\x50", "adcspl r0, r1, r2, lsl #4"),
    (b"\x02\x02\xb1\x60", "adcsvs r0, r1, r2, lsl #4"),
    (b"\x02\x02\xb1\x70", "adcsvc r0, r1, r2, lsl #4"),
    (b"\x02\x02\xb1\x80", "adcshi r0, r1, r2, lsl #4"),
    (b"\x02\x02\xb1\x90", "adcsls r0, r1, r2, lsl #4"),
    (b"\x02\x02\xb1\xa0", "adcsge r0, r1, r2, lsl #4"),
    (b"\x02\x02\xb1\xb0", "adcslt r0, r1, r2, lsl #4"),
    (b"\x02\x02\xb1\xc0", "adcsgt r0, r1, r2, lsl #4"),
    (b"\x02\x02\xb1\xd0", "adcsle r0, r1, r2, lsl #4"),
    (b"\x02\x02\xb1\xe0", "adcsal r0, r1, r2, lsl #4"),

    (b"\x12\x03\xb1\x00", "adcseq r0, r1, r2, lsl r3"),
    (b"\x12\x03\xb1\x10", "adcsne r0, r1, r2, lsl r3"),
    (b"\x12\x03\xb1\x20", "adcscs r0, r1, r2, lsl r3"),
    (b"\x12\x03\xb1\x30", "adcscc r0, r1, r2, lsl r3"),
    (b"\x12\x03\xb1\x40", "adcsmi r0, r1, r2, lsl r3"),
    (b"\x12\x03\xb1\x50", "adcspl r0, r1, r2, lsl r3"),
    (b"\x12\x03\xb1\x60", "adcsvs r0, r1, r2, lsl r3"),
    (b"\x12\x03\xb1\x70", "adcsvc r0, r1, r2, lsl r3"),
    (b"\x12\x03\xb1\x80", "adcshi r0, r1, r2, lsl r3"),
    (b"\x12\x03\xb1\x90", "adcsls r0, r1, r2, lsl r3"),
    (b"\x12\x03\xb1\xa0", "adcsge r0, r1, r2, lsl r3"),
    (b"\x12\x03\xb1\xb0", "adcslt r0, r1, r2, lsl r3"),
    (b"\x12\x03\xb1\xc0", "adcsgt r0, r1, r2, lsl r3"),
    (b"\x12\x03\xb1\xd0", "adcsle r0, r1, r2, lsl r3"),
    (b"\x12\x03\xb1\xe0", "adcsal r0, r1, r2, lsl r3"),

    # ADCS - LSR Shifter
    (b"\x22\x02\xb1\x00", "adcseq r0, r1, r2, lsr #4"),
    (b"\x22\x02\xb1\x10", "adcsne r0, r1, r2, lsr #4"),
    (b"\x22\x02\xb1\x20", "adcscs r0, r1, r2, lsr #4"),
    (b"\x22\x02\xb1\x30", "adcscc r0, r1, r2, lsr #4"),
    (b"\x22\x02\xb1\x40", "adcsmi r0, r1, r2, lsr #4"),
    (b"\x22\x02\xb1\x50", "adcspl r0, r1, r2, lsr #4"),
    (b"\x22\x02\xb1\x60", "adcsvs r0, r1, r2, lsr #4"),
    (b"\x22\x02\xb1\x70", "adcsvc r0, r1, r2, lsr #4"),
    (b"\x22\x02\xb1\x80", "adcshi r0, r1, r2, lsr #4"),
    (b"\x22\x02\xb1\x90", "adcsls r0, r1, r2, lsr #4"),
    (b"\x22\x02\xb1\xa0", "adcsge r0, r1, r2, lsr #4"),
    (b"\x22\x02\xb1\xb0", "adcslt r0, r1, r2, lsr #4"),
    (b"\x22\x02\xb1\xc0", "adcsgt r0, r1, r2, lsr #4"),
    (b"\x22\x02\xb1\xd0", "adcsle r0, r1, r2, lsr #4"),
    (b"\x22\x02\xb1\xe0", "adcsal r0, r1, r2, lsr #4"),

    (b"\x32\x03\xb1\x00", "adcseq r0, r1, r2, lsr r3"),
    (b"\x32\x03\xb1\x10", "adcsne r0, r1, r2, lsr r3"),
    (b"\x32\x03\xb1\x20", "adcscs r0, r1, r2, lsr r3"),
    (b"\x32\x03\xb1\x30", "adcscc r0, r1, r2, lsr r3"),
    (b"\x32\x03\xb1\x40", "adcsmi r0, r1, r2, lsr r3"),
    (b"\x32\x03\xb1\x50", "adcspl r0, r1, r2, lsr r3"),
    (b"\x32\x03\xb1\x60", "adcsvs r0, r1, r2, lsr r3"),
    (b"\x32\x03\xb1\x70", "adcsvc r0, r1, r2, lsr r3"),
    (b"\x32\x03\xb1\x80", "adcshi r0, r1, r2, lsr r3"),
    (b"\x32\x03\xb1\x90", "adcsls r0, r1, r2, lsr r3"),
    (b"\x32\x03\xb1\xa0", "adcsge r0, r1, r2, lsr r3"),
    (b"\x32\x03\xb1\xb0", "adcslt r0, r1, r2, lsr r3"),
    (b"\x32\x03\xb1\xc0", "adcsgt r0, r1, r2, lsr r3"),
    (b"\x32\x03\xb1\xd0", "adcsle r0, r1, r2, lsr r3"),
    (b"\x32\x03\xb1\xe0", "adcsal r0, r1, r2, lsr r3"),

    # ADCS - ROR Shifter
    (b"\x62\x02\xb1\x00", "adcseq r0, r1, r2, ror #4"),
    (b"\x62\x02\xb1\x10", "adcsne r0, r1, r2, ror #4"),
    (b"\x62\x02\xb1\x20", "adcscs r0, r1, r2, ror #4"),
    (b"\x62\x02\xb1\x30", "adcscc r0, r1, r2, ror #4"),
    (b"\x62\x02\xb1\x40", "adcsmi r0, r1, r2, ror #4"),
    (b"\x62\x02\xb1\x50", "adcspl r0, r1, r2, ror #4"),
    (b"\x62\x02\xb1\x60", "adcsvs r0, r1, r2, ror #4"),
    (b"\x62\x02\xb1\x70", "adcsvc r0, r1, r2, ror #4"),
    (b"\x62\x02\xb1\x80", "adcshi r0, r1, r2, ror #4"),
    (b"\x62\x02\xb1\x90", "adcsls r0, r1, r2, ror #4"),
    (b"\x62\x02\xb1\xa0", "adcsge r0, r1, r2, ror #4"),
    (b"\x62\x02\xb1\xb0", "adcslt r0, r1, r2, ror #4"),
    (b"\x62\x02\xb1\xc0", "adcsgt r0, r1, r2, ror #4"),
    (b"\x62\x02\xb1\xd0", "adcsle r0, r1, r2, ror #4"),
    (b"\x62\x02\xb1\xe0", "adcsal r0, r1, r2, ror #4"),

    (b"\x72\x03\xb1\x00", "adcseq r0, r1, r2, ror r3"),
    (b"\x72\x03\xb1\x10", "adcsne r0, r1, r2, ror r3"),
    (b"\x72\x03\xb1\x20", "adcscs r0, r1, r2, ror r3"),
    (b"\x72\x03\xb1\x30", "adcscc r0, r1, r2, ror r3"),
    (b"\x72\x03\xb1\x40", "adcsmi r0, r1, r2, ror r3"),
    (b"\x72\x03\xb1\x50", "adcspl r0, r1, r2, ror r3"),
    (b"\x72\x03\xb1\x60", "adcsvs r0, r1, r2, ror r3"),
    (b"\x72\x03\xb1\x70", "adcsvc r0, r1, r2, ror r3"),
    (b"\x72\x03\xb1\x80", "adcshi r0, r1, r2, ror r3"),
    (b"\x72\x03\xb1\x90", "adcsls r0, r1, r2, ror r3"),
    (b"\x72\x03\xb1\xa0", "adcsge r0, r1, r2, ror r3"),
    (b"\x72\x03\xb1\xb0", "adcslt r0, r1, r2, ror r3"),
    (b"\x72\x03\xb1\xc0", "adcsgt r0, r1, r2, ror r3"),
    (b"\x72\x03\xb1\xd0", "adcsle r0, r1, r2, ror r3"),
    (b"\x72\x03\xb1\xe0", "adcsal r0, r1, r2, ror r3"),

    # ADCS - RRX Shifter
    (b"\x62\x00\xb1\x00", "adcseq r0, r1, r2, rrx"),
    (b"\x62\x00\xb1\x10", "adcsne r0, r1, r2, rrx"),
    (b"\x62\x00\xb1\x20", "adcscs r0, r1, r2, rrx"),
    (b"\x62\x00\xb1\x30", "adcscc r0, r1, r2, rrx"),
    (b"\x62\x00\xb1\x40", "adcsmi r0, r1, r2, rrx"),
    (b"\x62\x00\xb1\x50", "adcspl r0, r1, r2, rrx"),
    (b"\x62\x00\xb1\x60", "adcsvs r0, r1, r2, rrx"),
    (b"\x62\x00\xb1\x70", "adcsvc r0, r1, r2, rrx"),
    (b"\x62\x00\xb1\x80", "adcshi r0, r1, r2, rrx"),
    (b"\x62\x00\xb1\x90", "adcsls r0, r1, r2, rrx"),
    (b"\x62\x00\xb1\xa0", "adcsge r0, r1, r2, rrx"),
    (b"\x62\x00\xb1\xb0", "adcslt r0, r1, r2, rrx"),
    (b"\x62\x00\xb1\xc0", "adcsgt r0, r1, r2, rrx"),
    (b"\x62\x00\xb1\xd0", "adcsle r0, r1, r2, rrx"),
    (b"\x62\x00\xb1\xe0", "adcsal r0, r1, r2, rrx"),

    # ADC(S) - Misc
    (b"\x01\x00\xa2\xe0", "adc r0, r2, r1"),
    (b"\x01\x00\xa1\xe0", "adc r0, r1, r1"),
    (b"\x01\x10\xa1\xe0", "adc r1, r1, r1"),
    (b"\x11\x01\xa2\xe0", "adc r0, r2, r1, lsl r1"),
    (b"\x11\x01\xa1\xe0", "adc r0, r1, r1, lsl r1"),
    (b"\x11\x11\xa1\xe0", "adc r1, r1, r1, lsl r1"),
    (b"\xc1\x1f\xa1\xe0", "adc r1, r1, r1, asr #31"),
    (b"\x81\x1f\xa1\xe0", "adc r1, r1, r1, lsl #31"),
    (b"\xa1\x1f\xa1\xe0", "adc r1, r1, r1, lsr #31"),
    (b"\xe1\x1f\xa1\xe0", "adc r1, r1, r1, ror #31"),

    # ADC(S) with PC as operand ---------------------------------------------- #
    (b"\x0f\x00\xa1\xe0", "adc r0, r1, pc"),
    (b"\x02\x00\xaf\xe0", "adc r0, pc, r2"),

    (b"\x4f\x01\xa1\xe0", "adc r0, r1, pc, asr #2"),
    (b"\x42\x01\xaf\xe0", "adc r0, pc, r2, asr #2"),
    (b"\x0f\x01\xa1\xe0", "adc r0, r1, pc, lsl #2"),
    (b"\x02\x01\xaf\xe0", "adc r0, pc, r2, lsl #2"),
    (b"\x2f\x01\xa1\xe0", "adc r0, r1, pc, lsr #2"),
    (b"\x22\x01\xaf\xe0", "adc r0, pc, r2, lsr #2"),
    (b"\x6f\x01\xa1\xe0", "adc r0, r1, pc, ror #2"),
    (b"\x62\x01\xaf\xe0", "adc r0, pc, r2, ror #2"),
    (b"\x6f\x00\xa1\xe0", "adc r0, r1, pc, rrx"),
    (b"\x62\x00\xaf\xe0", "adc r0, pc, r2, rrx"),
    (b"\x5f\x03\xa1\xe0", "adc r0, r1, pc, asr r3"),
    (b"\x1f\x03\xa1\xe0", "adc r0, r1, pc, lsl r3"),
    (b"\x3f\x03\xa1\xe0", "adc r0, r1, pc, lsr r3"),
    (b"\x7f\x03\xa1\xe0", "adc r0, r1, pc, ror r3"),

    (b"\x4f\x01\xb1\xe0", "adcs r0, r1, pc, asr #2"),
    (b"\x42\x01\xbf\xe0", "adcs r0, pc, r2, asr #2"),
    (b"\x0f\x01\xb1\xe0", "adcs r0, r1, pc, lsl #2"),
    (b"\x02\x01\xbf\xe0", "adcs r0, pc, r2, lsl #2"),
    (b"\x2f\x01\xb1\xe0", "adcs r0, r1, pc, lsr #2"),
    (b"\x22\x01\xbf\xe0", "adcs r0, pc, r2, lsr #2"),
    (b"\x6f\x01\xb1\xe0", "adcs r0, r1, pc, ror #2"),
    (b"\x62\x01\xbf\xe0", "adcs r0, pc, r2, ror #2"),
    (b"\x6f\x00\xb1\xe0", "adcs r0, r1, pc, rrx"),
    (b"\x62\x00\xbf\xe0", "adcs r0, pc, r2, rrx"),
    (b"\x5f\x03\xb1\xe0", "adcs r0, r1, pc, asr r3"),
    (b"\x1f\x03\xb1\xe0", "adcs r0, r1, pc, lsl r3"),
    (b"\x3f\x03\xb1\xe0", "adcs r0, r1, pc, lsr r3"),
    (b"\x7f\x03\xb1\xe0", "adcs r0, r1, pc, ror r3"),

    # ADC(S) with SP as operand ---------------------------------------------- #
    (b"\x02\x00\xbd\xe2", "adcs r0, sp, #2"),
    (b"\x02\x00\xbd\x02", "adcseq r0, sp, #2"),
    (b"\x02\x00\xbd\x12", "adcsne r0, sp, #2"),
    (b"\x02\x00\xbd\x22", "adcscs r0, sp, #2"),
    (b"\x02\x00\xbd\x32", "adcscc r0, sp, #2"),
    (b"\x02\x00\xbd\x42", "adcsmi r0, sp, #2"),
    (b"\x02\x00\xbd\x52", "adcspl r0, sp, #2"),
    (b"\x02\x00\xbd\x62", "adcsvs r0, sp, #2"),
    (b"\x02\x00\xbd\x72", "adcsvc r0, sp, #2"),
    (b"\x02\x00\xbd\x82", "adcshi r0, sp, #2"),
    (b"\x02\x00\xbd\x92", "adcsls r0, sp, #2"),
    (b"\x02\x00\xbd\xa2", "adcsge r0, sp, #2"),
    (b"\x02\x00\xbd\xb2", "adcslt r0, sp, #2"),
    (b"\x02\x00\xbd\xc2", "adcsgt r0, sp, #2"),
    (b"\x02\x00\xbd\xd2", "adcsle r0, sp, #2"),
    (b"\x02\x00\xbd\xe2", "adcsal r0, sp, #2"),

    (b"\x03\x00\xbd\xe0", "adcs r0, sp, r3"),
    (b"\x03\x00\xbd\x00", "adcseq r0, sp, r3"),
    (b"\x03\x00\xbd\x10", "adcsne r0, sp, r3"),
    (b"\x03\x00\xbd\x20", "adcscs r0, sp, r3"),
    (b"\x03\x00\xbd\x30", "adcscc r0, sp, r3"),
    (b"\x03\x00\xbd\x40", "adcsmi r0, sp, r3"),
    (b"\x03\x00\xbd\x50", "adcspl r0, sp, r3"),
    (b"\x03\x00\xbd\x60", "adcsvs r0, sp, r3"),
    (b"\x03\x00\xbd\x70", "adcsvc r0, sp, r3"),
    (b"\x03\x00\xbd\x80", "adcshi r0, sp, r3"),
    (b"\x03\x00\xbd\x90", "adcsls r0, sp, r3"),
    (b"\x03\x00\xbd\xa0", "adcsge r0, sp, r3"),
    (b"\x03\x00\xbd\xb0", "adcslt r0, sp, r3"),
    (b"\x03\x00\xbd\xc0", "adcsgt r0, sp, r3"),
    (b"\x03\x00\xbd\xd0", "adcsle r0, sp, r3"),
    (b"\x03\x00\xbd\xe0", "adcsal r0, sp, r3"),

    (b"\x02\xd0\xbd\xe2", "adcs sp, sp, #2"),
    (b"\x02\xd0\xbd\x02", "adcseq sp, sp, #2"),
    (b"\x02\xd0\xbd\x12", "adcsne sp, sp, #2"),
    (b"\x02\xd0\xbd\x22", "adcscs sp, sp, #2"),
    (b"\x02\xd0\xbd\x32", "adcscc sp, sp, #2"),
    (b"\x02\xd0\xbd\x42", "adcsmi sp, sp, #2"),
    (b"\x02\xd0\xbd\x52", "adcspl sp, sp, #2"),
    (b"\x02\xd0\xbd\x62", "adcsvs sp, sp, #2"),
    (b"\x02\xd0\xbd\x72", "adcsvc sp, sp, #2"),
    (b"\x02\xd0\xbd\x82", "adcshi sp, sp, #2"),
    (b"\x02\xd0\xbd\x92", "adcsls sp, sp, #2"),
    (b"\x02\xd0\xbd\xa2", "adcsge sp, sp, #2"),
    (b"\x02\xd0\xbd\xb2", "adcslt sp, sp, #2"),
    (b"\x02\xd0\xbd\xc2", "adcsgt sp, sp, #2"),
    (b"\x02\xd0\xbd\xd2", "adcsle sp, sp, #2"),
    (b"\x02\xd0\xbd\xe2", "adcsal sp, sp, #2"),

    (b"\x03\xd0\xbd\xe0", "adcs sp, sp, r3"),
    (b"\x03\xd0\xbd\x00", "adcseq sp, sp, r3"),
    (b"\x03\xd0\xbd\x10", "adcsne sp, sp, r3"),
    (b"\x03\xd0\xbd\x20", "adcscs sp, sp, r3"),
    (b"\x03\xd0\xbd\x30", "adcscc sp, sp, r3"),
    (b"\x03\xd0\xbd\x40", "adcsmi sp, sp, r3"),
    (b"\x03\xd0\xbd\x50", "adcspl sp, sp, r3"),
    (b"\x03\xd0\xbd\x60", "adcsvs sp, sp, r3"),
    (b"\x03\xd0\xbd\x70", "adcsvc sp, sp, r3"),
    (b"\x03\xd0\xbd\x80", "adcshi sp, sp, r3"),
    (b"\x03\xd0\xbd\x90", "adcsls sp, sp, r3"),
    (b"\x03\xd0\xbd\xa0", "adcsge sp, sp, r3"),
    (b"\x03\xd0\xbd\xb0", "adcslt sp, sp, r3"),
    (b"\x03\xd0\xbd\xc0", "adcsgt sp, sp, r3"),
    (b"\x03\xd0\xbd\xd0", "adcsle sp, sp, r3"),
    (b"\x03\xd0\xbd\xe0", "adcsal sp, sp, r3"),

    (b"\x1d\xdd\xad\xe0", "adc sp, sp, sp, lsl sp"),
    (b"\x1d\xdd\xbd\xe0", "adcs sp, sp, sp, lsl sp"),
    (b"\x3d\xdd\xad\xe0", "adc sp, sp, sp, lsr sp"),
    (b"\x3d\xdd\xbd\xe0", "adcs sp, sp, sp, lsr sp"),
    (b"\x5d\xdd\xad\xe0", "adc sp, sp, sp, asr sp"),
    (b"\x5d\xdd\xbd\xe0", "adcs sp, sp, sp, asr sp"),
    (b"\x5d\xdd\xad\xe0", "adc sp, sp, sp, asr sp"),
    (b"\x5d\xdd\xbd\xe0", "adcs sp, sp, sp, asr sp"),
    (b"\x7d\xdd\xad\xe0", "adc sp, sp, sp, ror sp"),
    (b"\x7d\xdd\xbd\xe0", "adcs sp, sp, sp, ror sp"),
    (b"\x7d\xdd\xad\xe0", "adc sp, sp, sp, ror sp"),
    (b"\x7d\xdd\xbd\xe0", "adcs sp, sp, sp, ror sp"),

    # ADD -------------------------------------------------------------------- #
    (b"\x02\x00\x81\xe2", "add r0, r1, #2"),
    (b"\x02\x00\x81\x02", "addeq r0, r1, #2"),
    (b"\x02\x00\x81\x12", "addne r0, r1, #2"),
    (b"\x02\x00\x81\x22", "addcs r0, r1, #2"),
    (b"\x02\x00\x81\x32", "addcc r0, r1, #2"),
    (b"\x02\x00\x81\x42", "addmi r0, r1, #2"),
    (b"\x02\x00\x81\x52", "addpl r0, r1, #2"),
    (b"\x02\x00\x81\x62", "addvs r0, r1, #2"),
    (b"\x02\x00\x81\x72", "addvc r0, r1, #2"),
    (b"\x02\x00\x81\x82", "addhi r0, r1, #2"),
    (b"\x02\x00\x81\x92", "addls r0, r1, #2"),
    (b"\x02\x00\x81\xa2", "addge r0, r1, #2"),
    (b"\x02\x00\x81\xb2", "addlt r0, r1, #2"),
    (b"\x02\x00\x81\xc2", "addgt r0, r1, #2"),
    (b"\x02\x00\x81\xd2", "addle r0, r1, #2"),
    (b"\x02\x00\x81\xe2", "addal r0, r1, #2"),

    (b"\x03\x00\x81\xe0", "add r0, r1, r3"),
    (b"\x03\x00\x81\x00", "addeq r0, r1, r3"),
    (b"\x03\x00\x81\x10", "addne r0, r1, r3"),
    (b"\x03\x00\x81\x20", "addcs r0, r1, r3"),
    (b"\x03\x00\x81\x30", "addcc r0, r1, r3"),
    (b"\x03\x00\x81\x40", "addmi r0, r1, r3"),
    (b"\x03\x00\x81\x50", "addpl r0, r1, r3"),
    (b"\x03\x00\x81\x60", "addvs r0, r1, r3"),
    (b"\x03\x00\x81\x70", "addvc r0, r1, r3"),
    (b"\x03\x00\x81\x80", "addhi r0, r1, r3"),
    (b"\x03\x00\x81\x90", "addls r0, r1, r3"),
    (b"\x03\x00\x81\xa0", "addge r0, r1, r3"),
    (b"\x03\x00\x81\xb0", "addlt r0, r1, r3"),
    (b"\x03\x00\x81\xc0", "addgt r0, r1, r3"),
    (b"\x03\x00\x81\xd0", "addle r0, r1, r3"),
    (b"\x03\x00\x81\xe0", "addal r0, r1, r3"),

    # ADD - ASR Shifter
    (b"\x42\x02\x81\x00", "addeq r0, r1, r2, asr #4"),
    (b"\x42\x02\x81\x10", "addne r0, r1, r2, asr #4"),
    (b"\x42\x02\x81\x20", "addcs r0, r1, r2, asr #4"),
    (b"\x42\x02\x81\x30", "addcc r0, r1, r2, asr #4"),
    (b"\x42\x02\x81\x40", "addmi r0, r1, r2, asr #4"),
    (b"\x42\x02\x81\x50", "addpl r0, r1, r2, asr #4"),
    (b"\x42\x02\x81\x60", "addvs r0, r1, r2, asr #4"),
    (b"\x42\x02\x81\x70", "addvc r0, r1, r2, asr #4"),
    (b"\x42\x02\x81\x80", "addhi r0, r1, r2, asr #4"),
    (b"\x42\x02\x81\x90", "addls r0, r1, r2, asr #4"),
    (b"\x42\x02\x81\xa0", "addge r0, r1, r2, asr #4"),
    (b"\x42\x02\x81\xb0", "addlt r0, r1, r2, asr #4"),
    (b"\x42\x02\x81\xc0", "addgt r0, r1, r2, asr #4"),
    (b"\x42\x02\x81\xd0", "addle r0, r1, r2, asr #4"),
    (b"\x42\x02\x81\xe0", "addal r0, r1, r2, asr #4"),

    (b"\x52\x03\x81\x00", "addeq r0, r1, r2, asr r3"),
    (b"\x52\x03\x81\x10", "addne r0, r1, r2, asr r3"),
    (b"\x52\x03\x81\x20", "addcs r0, r1, r2, asr r3"),
    (b"\x52\x03\x81\x30", "addcc r0, r1, r2, asr r3"),
    (b"\x52\x03\x81\x40", "addmi r0, r1, r2, asr r3"),
    (b"\x52\x03\x81\x50", "addpl r0, r1, r2, asr r3"),
    (b"\x52\x03\x81\x60", "addvs r0, r1, r2, asr r3"),
    (b"\x52\x03\x81\x70", "addvc r0, r1, r2, asr r3"),
    (b"\x52\x03\x81\x80", "addhi r0, r1, r2, asr r3"),
    (b"\x52\x03\x81\x90", "addls r0, r1, r2, asr r3"),
    (b"\x52\x03\x81\xa0", "addge r0, r1, r2, asr r3"),
    (b"\x52\x03\x81\xb0", "addlt r0, r1, r2, asr r3"),
    (b"\x52\x03\x81\xc0", "addgt r0, r1, r2, asr r3"),
    (b"\x52\x03\x81\xd0", "addle r0, r1, r2, asr r3"),
    (b"\x52\x03\x81\xe0", "addal r0, r1, r2, asr r3"),

    # ADD - LSL Shifter
    (b"\x02\x02\x81\x00", "addeq r0, r1, r2, lsl #4"),
    (b"\x02\x02\x81\x10", "addne r0, r1, r2, lsl #4"),
    (b"\x02\x02\x81\x20", "addcs r0, r1, r2, lsl #4"),
    (b"\x02\x02\x81\x30", "addcc r0, r1, r2, lsl #4"),
    (b"\x02\x02\x81\x40", "addmi r0, r1, r2, lsl #4"),
    (b"\x02\x02\x81\x50", "addpl r0, r1, r2, lsl #4"),
    (b"\x02\x02\x81\x60", "addvs r0, r1, r2, lsl #4"),
    (b"\x02\x02\x81\x70", "addvc r0, r1, r2, lsl #4"),
    (b"\x02\x02\x81\x80", "addhi r0, r1, r2, lsl #4"),
    (b"\x02\x02\x81\x90", "addls r0, r1, r2, lsl #4"),
    (b"\x02\x02\x81\xa0", "addge r0, r1, r2, lsl #4"),
    (b"\x02\x02\x81\xb0", "addlt r0, r1, r2, lsl #4"),
    (b"\x02\x02\x81\xc0", "addgt r0, r1, r2, lsl #4"),
    (b"\x02\x02\x81\xd0", "addle r0, r1, r2, lsl #4"),
    (b"\x02\x02\x81\xe0", "addal r0, r1, r2, lsl #4"),

    (b"\x12\x03\x81\x00", "addeq r0, r1, r2, lsl r3"),
    (b"\x12\x03\x81\x10", "addne r0, r1, r2, lsl r3"),
    (b"\x12\x03\x81\x20", "addcs r0, r1, r2, lsl r3"),
    (b"\x12\x03\x81\x30", "addcc r0, r1, r2, lsl r3"),
    (b"\x12\x03\x81\x40", "addmi r0, r1, r2, lsl r3"),
    (b"\x12\x03\x81\x50", "addpl r0, r1, r2, lsl r3"),
    (b"\x12\x03\x81\x60", "addvs r0, r1, r2, lsl r3"),
    (b"\x12\x03\x81\x70", "addvc r0, r1, r2, lsl r3"),
    (b"\x12\x03\x81\x80", "addhi r0, r1, r2, lsl r3"),
    (b"\x12\x03\x81\x90", "addls r0, r1, r2, lsl r3"),
    (b"\x12\x03\x81\xa0", "addge r0, r1, r2, lsl r3"),
    (b"\x12\x03\x81\xb0", "addlt r0, r1, r2, lsl r3"),
    (b"\x12\x03\x81\xc0", "addgt r0, r1, r2, lsl r3"),
    (b"\x12\x03\x81\xd0", "addle r0, r1, r2, lsl r3"),
    (b"\x12\x03\x81\xe0", "addal r0, r1, r2, lsl r3"),

    # ADD - LSR Shifter
    (b"\x22\x02\x81\x00", "addeq r0, r1, r2, lsr #4"),
    (b"\x22\x02\x81\x10", "addne r0, r1, r2, lsr #4"),
    (b"\x22\x02\x81\x20", "addcs r0, r1, r2, lsr #4"),
    (b"\x22\x02\x81\x30", "addcc r0, r1, r2, lsr #4"),
    (b"\x22\x02\x81\x40", "addmi r0, r1, r2, lsr #4"),
    (b"\x22\x02\x81\x50", "addpl r0, r1, r2, lsr #4"),
    (b"\x22\x02\x81\x60", "addvs r0, r1, r2, lsr #4"),
    (b"\x22\x02\x81\x70", "addvc r0, r1, r2, lsr #4"),
    (b"\x22\x02\x81\x80", "addhi r0, r1, r2, lsr #4"),
    (b"\x22\x02\x81\x90", "addls r0, r1, r2, lsr #4"),
    (b"\x22\x02\x81\xa0", "addge r0, r1, r2, lsr #4"),
    (b"\x22\x02\x81\xb0", "addlt r0, r1, r2, lsr #4"),
    (b"\x22\x02\x81\xc0", "addgt r0, r1, r2, lsr #4"),
    (b"\x22\x02\x81\xd0", "addle r0, r1, r2, lsr #4"),
    (b"\x22\x02\x81\xe0", "addal r0, r1, r2, lsr #4"),

    (b"\x32\x03\x81\x00", "addeq r0, r1, r2, lsr r3"),
    (b"\x32\x03\x81\x10", "addne r0, r1, r2, lsr r3"),
    (b"\x32\x03\x81\x20", "addcs r0, r1, r2, lsr r3"),
    (b"\x32\x03\x81\x30", "addcc r0, r1, r2, lsr r3"),
    (b"\x32\x03\x81\x40", "addmi r0, r1, r2, lsr r3"),
    (b"\x32\x03\x81\x50", "addpl r0, r1, r2, lsr r3"),
    (b"\x32\x03\x81\x60", "addvs r0, r1, r2, lsr r3"),
    (b"\x32\x03\x81\x70", "addvc r0, r1, r2, lsr r3"),
    (b"\x32\x03\x81\x80", "addhi r0, r1, r2, lsr r3"),
    (b"\x32\x03\x81\x90", "addls r0, r1, r2, lsr r3"),
    (b"\x32\x03\x81\xa0", "addge r0, r1, r2, lsr r3"),
    (b"\x32\x03\x81\xb0", "addlt r0, r1, r2, lsr r3"),
    (b"\x32\x03\x81\xc0", "addgt r0, r1, r2, lsr r3"),
    (b"\x32\x03\x81\xd0", "addle r0, r1, r2, lsr r3"),
    (b"\x32\x03\x81\xe0", "addal r0, r1, r2, lsr r3"),

    # ADD - ROR Shifter
    (b"\x62\x02\x81\x00", "addeq r0, r1, r2, ror #4"),
    (b"\x62\x02\x81\x10", "addne r0, r1, r2, ror #4"),
    (b"\x62\x02\x81\x20", "addcs r0, r1, r2, ror #4"),
    (b"\x62\x02\x81\x30", "addcc r0, r1, r2, ror #4"),
    (b"\x62\x02\x81\x40", "addmi r0, r1, r2, ror #4"),
    (b"\x62\x02\x81\x50", "addpl r0, r1, r2, ror #4"),
    (b"\x62\x02\x81\x60", "addvs r0, r1, r2, ror #4"),
    (b"\x62\x02\x81\x70", "addvc r0, r1, r2, ror #4"),
    (b"\x62\x02\x81\x80", "addhi r0, r1, r2, ror #4"),
    (b"\x62\x02\x81\x90", "addls r0, r1, r2, ror #4"),
    (b"\x62\x02\x81\xa0", "addge r0, r1, r2, ror #4"),
    (b"\x62\x02\x81\xb0", "addlt r0, r1, r2, ror #4"),
    (b"\x62\x02\x81\xc0", "addgt r0, r1, r2, ror #4"),
    (b"\x62\x02\x81\xd0", "addle r0, r1, r2, ror #4"),
    (b"\x62\x02\x81\xe0", "addal r0, r1, r2, ror #4"),

    (b"\x72\x03\x81\x00", "addeq r0, r1, r2, ror r3"),
    (b"\x72\x03\x81\x10", "addne r0, r1, r2, ror r3"),
    (b"\x72\x03\x81\x20", "addcs r0, r1, r2, ror r3"),
    (b"\x72\x03\x81\x30", "addcc r0, r1, r2, ror r3"),
    (b"\x72\x03\x81\x40", "addmi r0, r1, r2, ror r3"),
    (b"\x72\x03\x81\x50", "addpl r0, r1, r2, ror r3"),
    (b"\x72\x03\x81\x60", "addvs r0, r1, r2, ror r3"),
    (b"\x72\x03\x81\x70", "addvc r0, r1, r2, ror r3"),
    (b"\x72\x03\x81\x80", "addhi r0, r1, r2, ror r3"),
    (b"\x72\x03\x81\x90", "addls r0, r1, r2, ror r3"),
    (b"\x72\x03\x81\xa0", "addge r0, r1, r2, ror r3"),
    (b"\x72\x03\x81\xb0", "addlt r0, r1, r2, ror r3"),
    (b"\x72\x03\x81\xc0", "addgt r0, r1, r2, ror r3"),
    (b"\x72\x03\x81\xd0", "addle r0, r1, r2, ror r3"),
    (b"\x72\x03\x81\xe0", "addal r0, r1, r2, ror r3"),

    # ADD - RRX Shifter
    (b"\x62\x00\x81\x00", "addeq r0, r1, r2, rrx"),
    (b"\x62\x00\x81\x10", "addne r0, r1, r2, rrx"),
    (b"\x62\x00\x81\x20", "addcs r0, r1, r2, rrx"),
    (b"\x62\x00\x81\x30", "addcc r0, r1, r2, rrx"),
    (b"\x62\x00\x81\x40", "addmi r0, r1, r2, rrx"),
    (b"\x62\x00\x81\x50", "addpl r0, r1, r2, rrx"),
    (b"\x62\x00\x81\x60", "addvs r0, r1, r2, rrx"),
    (b"\x62\x00\x81\x70", "addvc r0, r1, r2, rrx"),
    (b"\x62\x00\x81\x80", "addhi r0, r1, r2, rrx"),
    (b"\x62\x00\x81\x90", "addls r0, r1, r2, rrx"),
    (b"\x62\x00\x81\xa0", "addge r0, r1, r2, rrx"),
    (b"\x62\x00\x81\xb0", "addlt r0, r1, r2, rrx"),
    (b"\x62\x00\x81\xc0", "addgt r0, r1, r2, rrx"),
    (b"\x62\x00\x81\xd0", "addle r0, r1, r2, rrx"),
    (b"\x62\x00\x81\xe0", "addal r0, r1, r2, rrx"),

    # ADDS ------------------------------------------------------------------- #
    (b"\x02\x00\x91\xe2", "adds r0, r1, #2"),
    (b"\x02\x00\x91\x02", "addseq r0, r1, #2"),
    (b"\x02\x00\x91\x12", "addsne r0, r1, #2"),
    (b"\x02\x00\x91\x22", "addscs r0, r1, #2"),
    (b"\x02\x00\x91\x32", "addscc r0, r1, #2"),
    (b"\x02\x00\x91\x42", "addsmi r0, r1, #2"),
    (b"\x02\x00\x91\x52", "addspl r0, r1, #2"),
    (b"\x02\x00\x91\x62", "addsvs r0, r1, #2"),
    (b"\x02\x00\x91\x72", "addsvc r0, r1, #2"),
    (b"\x02\x00\x91\x82", "addshi r0, r1, #2"),
    (b"\x02\x00\x91\x92", "addsls r0, r1, #2"),
    (b"\x02\x00\x91\xa2", "addsge r0, r1, #2"),
    (b"\x02\x00\x91\xb2", "addslt r0, r1, #2"),
    (b"\x02\x00\x91\xc2", "addsgt r0, r1, #2"),
    (b"\x02\x00\x91\xd2", "addsle r0, r1, #2"),
    (b"\x02\x00\x91\xe2", "addsal r0, r1, #2"),

    (b"\x03\x00\x91\xe0", "adds r0, r1, r3"),
    (b"\x03\x00\x91\x00", "addseq r0, r1, r3"),
    (b"\x03\x00\x91\x10", "addsne r0, r1, r3"),
    (b"\x03\x00\x91\x20", "addscs r0, r1, r3"),
    (b"\x03\x00\x91\x30", "addscc r0, r1, r3"),
    (b"\x03\x00\x91\x40", "addsmi r0, r1, r3"),
    (b"\x03\x00\x91\x50", "addspl r0, r1, r3"),
    (b"\x03\x00\x91\x60", "addsvs r0, r1, r3"),
    (b"\x03\x00\x91\x70", "addsvc r0, r1, r3"),
    (b"\x03\x00\x91\x80", "addshi r0, r1, r3"),
    (b"\x03\x00\x91\x90", "addsls r0, r1, r3"),
    (b"\x03\x00\x91\xa0", "addsge r0, r1, r3"),
    (b"\x03\x00\x91\xb0", "addslt r0, r1, r3"),
    (b"\x03\x00\x91\xc0", "addsgt r0, r1, r3"),
    (b"\x03\x00\x91\xd0", "addsle r0, r1, r3"),
    (b"\x03\x00\x91\xe0", "addsal r0, r1, r3"),

    # ADDS - ASR Shifter
    (b"\x42\x02\x91\x00", "addseq r0, r1, r2, asr #4"),
    (b"\x42\x02\x91\x10", "addsne r0, r1, r2, asr #4"),
    (b"\x42\x02\x91\x20", "addscs r0, r1, r2, asr #4"),
    (b"\x42\x02\x91\x30", "addscc r0, r1, r2, asr #4"),
    (b"\x42\x02\x91\x40", "addsmi r0, r1, r2, asr #4"),
    (b"\x42\x02\x91\x50", "addspl r0, r1, r2, asr #4"),
    (b"\x42\x02\x91\x60", "addsvs r0, r1, r2, asr #4"),
    (b"\x42\x02\x91\x70", "addsvc r0, r1, r2, asr #4"),
    (b"\x42\x02\x91\x80", "addshi r0, r1, r2, asr #4"),
    (b"\x42\x02\x91\x90", "addsls r0, r1, r2, asr #4"),
    (b"\x42\x02\x91\xa0", "addsge r0, r1, r2, asr #4"),
    (b"\x42\x02\x91\xb0", "addslt r0, r1, r2, asr #4"),
    (b"\x42\x02\x91\xc0", "addsgt r0, r1, r2, asr #4"),
    (b"\x42\x02\x91\xd0", "addsle r0, r1, r2, asr #4"),
    (b"\x42\x02\x91\xe0", "addsal r0, r1, r2, asr #4"),

    (b"\x52\x03\x91\x00", "addseq r0, r1, r2, asr r3"),
    (b"\x52\x03\x91\x10", "addsne r0, r1, r2, asr r3"),
    (b"\x52\x03\x91\x20", "addscs r0, r1, r2, asr r3"),
    (b"\x52\x03\x91\x30", "addscc r0, r1, r2, asr r3"),
    (b"\x52\x03\x91\x40", "addsmi r0, r1, r2, asr r3"),
    (b"\x52\x03\x91\x50", "addspl r0, r1, r2, asr r3"),
    (b"\x52\x03\x91\x60", "addsvs r0, r1, r2, asr r3"),
    (b"\x52\x03\x91\x70", "addsvc r0, r1, r2, asr r3"),
    (b"\x52\x03\x91\x80", "addshi r0, r1, r2, asr r3"),
    (b"\x52\x03\x91\x90", "addsls r0, r1, r2, asr r3"),
    (b"\x52\x03\x91\xa0", "addsge r0, r1, r2, asr r3"),
    (b"\x52\x03\x91\xb0", "addslt r0, r1, r2, asr r3"),
    (b"\x52\x03\x91\xc0", "addsgt r0, r1, r2, asr r3"),
    (b"\x52\x03\x91\xd0", "addsle r0, r1, r2, asr r3"),
    (b"\x52\x03\x91\xe0", "addsal r0, r1, r2, asr r3"),

    # ADDS - LSL Shifter
    (b"\x02\x02\x91\x00", "addseq r0, r1, r2, lsl #4"),
    (b"\x02\x02\x91\x10", "addsne r0, r1, r2, lsl #4"),
    (b"\x02\x02\x91\x20", "addscs r0, r1, r2, lsl #4"),
    (b"\x02\x02\x91\x30", "addscc r0, r1, r2, lsl #4"),
    (b"\x02\x02\x91\x40", "addsmi r0, r1, r2, lsl #4"),
    (b"\x02\x02\x91\x50", "addspl r0, r1, r2, lsl #4"),
    (b"\x02\x02\x91\x60", "addsvs r0, r1, r2, lsl #4"),
    (b"\x02\x02\x91\x70", "addsvc r0, r1, r2, lsl #4"),
    (b"\x02\x02\x91\x80", "addshi r0, r1, r2, lsl #4"),
    (b"\x02\x02\x91\x90", "addsls r0, r1, r2, lsl #4"),
    (b"\x02\x02\x91\xa0", "addsge r0, r1, r2, lsl #4"),
    (b"\x02\x02\x91\xb0", "addslt r0, r1, r2, lsl #4"),
    (b"\x02\x02\x91\xc0", "addsgt r0, r1, r2, lsl #4"),
    (b"\x02\x02\x91\xd0", "addsle r0, r1, r2, lsl #4"),
    (b"\x02\x02\x91\xe0", "addsal r0, r1, r2, lsl #4"),

    (b"\x12\x03\x91\x00", "addseq r0, r1, r2, lsl r3"),
    (b"\x12\x03\x91\x10", "addsne r0, r1, r2, lsl r3"),
    (b"\x12\x03\x91\x20", "addscs r0, r1, r2, lsl r3"),
    (b"\x12\x03\x91\x30", "addscc r0, r1, r2, lsl r3"),
    (b"\x12\x03\x91\x40", "addsmi r0, r1, r2, lsl r3"),
    (b"\x12\x03\x91\x50", "addspl r0, r1, r2, lsl r3"),
    (b"\x12\x03\x91\x60", "addsvs r0, r1, r2, lsl r3"),
    (b"\x12\x03\x91\x70", "addsvc r0, r1, r2, lsl r3"),
    (b"\x12\x03\x91\x80", "addshi r0, r1, r2, lsl r3"),
    (b"\x12\x03\x91\x90", "addsls r0, r1, r2, lsl r3"),
    (b"\x12\x03\x91\xa0", "addsge r0, r1, r2, lsl r3"),
    (b"\x12\x03\x91\xb0", "addslt r0, r1, r2, lsl r3"),
    (b"\x12\x03\x91\xc0", "addsgt r0, r1, r2, lsl r3"),
    (b"\x12\x03\x91\xd0", "addsle r0, r1, r2, lsl r3"),
    (b"\x12\x03\x91\xe0", "addsal r0, r1, r2, lsl r3"),

    # ADDS - LSR Shifter
    (b"\x22\x02\x91\x00", "addseq r0, r1, r2, lsr #4"),
    (b"\x22\x02\x91\x10", "addsne r0, r1, r2, lsr #4"),
    (b"\x22\x02\x91\x20", "addscs r0, r1, r2, lsr #4"),
    (b"\x22\x02\x91\x30", "addscc r0, r1, r2, lsr #4"),
    (b"\x22\x02\x91\x40", "addsmi r0, r1, r2, lsr #4"),
    (b"\x22\x02\x91\x50", "addspl r0, r1, r2, lsr #4"),
    (b"\x22\x02\x91\x60", "addsvs r0, r1, r2, lsr #4"),
    (b"\x22\x02\x91\x70", "addsvc r0, r1, r2, lsr #4"),
    (b"\x22\x02\x91\x80", "addshi r0, r1, r2, lsr #4"),
    (b"\x22\x02\x91\x90", "addsls r0, r1, r2, lsr #4"),
    (b"\x22\x02\x91\xa0", "addsge r0, r1, r2, lsr #4"),
    (b"\x22\x02\x91\xb0", "addslt r0, r1, r2, lsr #4"),
    (b"\x22\x02\x91\xc0", "addsgt r0, r1, r2, lsr #4"),
    (b"\x22\x02\x91\xd0", "addsle r0, r1, r2, lsr #4"),
    (b"\x22\x02\x91\xe0", "addsal r0, r1, r2, lsr #4"),

    (b"\x32\x03\x91\x00", "addseq r0, r1, r2, lsr r3"),
    (b"\x32\x03\x91\x10", "addsne r0, r1, r2, lsr r3"),
    (b"\x32\x03\x91\x20", "addscs r0, r1, r2, lsr r3"),
    (b"\x32\x03\x91\x30", "addscc r0, r1, r2, lsr r3"),
    (b"\x32\x03\x91\x40", "addsmi r0, r1, r2, lsr r3"),
    (b"\x32\x03\x91\x50", "addspl r0, r1, r2, lsr r3"),
    (b"\x32\x03\x91\x60", "addsvs r0, r1, r2, lsr r3"),
    (b"\x32\x03\x91\x70", "addsvc r0, r1, r2, lsr r3"),
    (b"\x32\x03\x91\x80", "addshi r0, r1, r2, lsr r3"),
    (b"\x32\x03\x91\x90", "addsls r0, r1, r2, lsr r3"),
    (b"\x32\x03\x91\xa0", "addsge r0, r1, r2, lsr r3"),
    (b"\x32\x03\x91\xb0", "addslt r0, r1, r2, lsr r3"),
    (b"\x32\x03\x91\xc0", "addsgt r0, r1, r2, lsr r3"),
    (b"\x32\x03\x91\xd0", "addsle r0, r1, r2, lsr r3"),
    (b"\x32\x03\x91\xe0", "addsal r0, r1, r2, lsr r3"),

    # ADDS - ROR Shifter
    (b"\x62\x02\x91\x00", "addseq r0, r1, r2, ror #4"),
    (b"\x62\x02\x91\x10", "addsne r0, r1, r2, ror #4"),
    (b"\x62\x02\x91\x20", "addscs r0, r1, r2, ror #4"),
    (b"\x62\x02\x91\x30", "addscc r0, r1, r2, ror #4"),
    (b"\x62\x02\x91\x40", "addsmi r0, r1, r2, ror #4"),
    (b"\x62\x02\x91\x50", "addspl r0, r1, r2, ror #4"),
    (b"\x62\x02\x91\x60", "addsvs r0, r1, r2, ror #4"),
    (b"\x62\x02\x91\x70", "addsvc r0, r1, r2, ror #4"),
    (b"\x62\x02\x91\x80", "addshi r0, r1, r2, ror #4"),
    (b"\x62\x02\x91\x90", "addsls r0, r1, r2, ror #4"),
    (b"\x62\x02\x91\xa0", "addsge r0, r1, r2, ror #4"),
    (b"\x62\x02\x91\xb0", "addslt r0, r1, r2, ror #4"),
    (b"\x62\x02\x91\xc0", "addsgt r0, r1, r2, ror #4"),
    (b"\x62\x02\x91\xd0", "addsle r0, r1, r2, ror #4"),
    (b"\x62\x02\x91\xe0", "addsal r0, r1, r2, ror #4"),

    (b"\x72\x03\x91\x00", "addseq r0, r1, r2, ror r3"),
    (b"\x72\x03\x91\x10", "addsne r0, r1, r2, ror r3"),
    (b"\x72\x03\x91\x20", "addscs r0, r1, r2, ror r3"),
    (b"\x72\x03\x91\x30", "addscc r0, r1, r2, ror r3"),
    (b"\x72\x03\x91\x40", "addsmi r0, r1, r2, ror r3"),
    (b"\x72\x03\x91\x50", "addspl r0, r1, r2, ror r3"),
    (b"\x72\x03\x91\x60", "addsvs r0, r1, r2, ror r3"),
    (b"\x72\x03\x91\x70", "addsvc r0, r1, r2, ror r3"),
    (b"\x72\x03\x91\x80", "addshi r0, r1, r2, ror r3"),
    (b"\x72\x03\x91\x90", "addsls r0, r1, r2, ror r3"),
    (b"\x72\x03\x91\xa0", "addsge r0, r1, r2, ror r3"),
    (b"\x72\x03\x91\xb0", "addslt r0, r1, r2, ror r3"),
    (b"\x72\x03\x91\xc0", "addsgt r0, r1, r2, ror r3"),
    (b"\x72\x03\x91\xd0", "addsle r0, r1, r2, ror r3"),
    (b"\x72\x03\x91\xe0", "addsal r0, r1, r2, ror r3"),

    # ADDS - RRX Shifter
    (b"\x62\x00\x91\x00", "addseq r0, r1, r2, rrx"),
    (b"\x62\x00\x91\x10", "addsne r0, r1, r2, rrx"),
    (b"\x62\x00\x91\x20", "addscs r0, r1, r2, rrx"),
    (b"\x62\x00\x91\x30", "addscc r0, r1, r2, rrx"),
    (b"\x62\x00\x91\x40", "addsmi r0, r1, r2, rrx"),
    (b"\x62\x00\x91\x50", "addspl r0, r1, r2, rrx"),
    (b"\x62\x00\x91\x60", "addsvs r0, r1, r2, rrx"),
    (b"\x62\x00\x91\x70", "addsvc r0, r1, r2, rrx"),
    (b"\x62\x00\x91\x80", "addshi r0, r1, r2, rrx"),
    (b"\x62\x00\x91\x90", "addsls r0, r1, r2, rrx"),
    (b"\x62\x00\x91\xa0", "addsge r0, r1, r2, rrx"),
    (b"\x62\x00\x91\xb0", "addslt r0, r1, r2, rrx"),
    (b"\x62\x00\x91\xc0", "addsgt r0, r1, r2, rrx"),
    (b"\x62\x00\x91\xd0", "addsle r0, r1, r2, rrx"),
    (b"\x62\x00\x91\xe0", "addsal r0, r1, r2, rrx"),

    # ADD(S) misc
    (b"\x01\x00\x82\xe0", "add r0, r2, r1"),
    (b"\x01\x00\x81\xe0", "add r0, r1, r1"),
    (b"\x01\x10\x81\xe0", "add r1, r1, r1"),
    (b"\x11\x01\x82\xe0", "add r0, r2, r1, lsl r1"),
    (b"\x11\x01\x81\xe0", "add r0, r1, r1, lsl r1"),
    (b"\x11\x11\x81\xe0", "add r1, r1, r1, lsl r1"),
    (b"\xc1\x1f\x81\xe0", "add r1, r1, r1, asr #31"),
    (b"\x81\x1f\x81\xe0", "add r1, r1, r1, lsl #31"),
    (b"\xa1\x1f\x81\xe0", "add r1, r1, r1, lsr #31"),
    (b"\xe1\x1f\x81\xe0", "add r1, r1, r1, ror #31"),

    # ADD(S) with PC as operand ---------------------------------------------- #
    (b"\x0f\x00\x81\xe0", "add r0, r1, pc"),
    (b"\x02\x00\x8f\xe0", "add r0, pc, r2"),

    (b"\x4f\x01\x81\xe0", "add r0, r1, pc, asr #2"),
    (b"\x42\x01\x8f\xe0", "add r0, pc, r2, asr #2"),
    (b"\x0f\x01\x81\xe0", "add r0, r1, pc, lsl #2"),
    (b"\x02\x01\x8f\xe0", "add r0, pc, r2, lsl #2"),
    (b"\x2f\x01\x81\xe0", "add r0, r1, pc, lsr #2"),
    (b"\x22\x01\x8f\xe0", "add r0, pc, r2, lsr #2"),
    (b"\x6f\x01\x81\xe0", "add r0, r1, pc, ror #2"),
    (b"\x62\x01\x8f\xe0", "add r0, pc, r2, ror #2"),
    (b"\x6f\x00\x81\xe0", "add r0, r1, pc, rrx"),
    (b"\x62\x00\x8f\xe0", "add r0, pc, r2, rrx"),
    (b"\x5f\x03\x81\xe0", "add r0, r1, pc, asr r3"),
    (b"\x52\x03\x8f\xe0", "add r0, pc, r2, asr r3"),
    (b"\x1f\x03\x81\xe0", "add r0, r1, pc, lsl r3"),
    (b"\x12\x03\x8f\xe0", "add r0, pc, r2, lsl r3"),
    (b"\x3f\x03\x81\xe0", "add r0, r1, pc, lsr r3"),
    (b"\x32\x03\x8f\xe0", "add r0, pc, r2, lsr r3"),
    (b"\x7f\x03\x81\xe0", "add r0, r1, pc, ror r3"),
    (b"\x72\x03\x8f\xe0", "add r0, pc, r2, ror r3"),

    (b"\x4f\x01\x91\xe0", "adds r0, r1, pc, asr #2"),
    (b"\x42\x01\x9f\xe0", "adds r0, pc, r2, asr #2"),
    (b"\x0f\x01\x91\xe0", "adds r0, r1, pc, lsl #2"),
    (b"\x02\x01\x9f\xe0", "adds r0, pc, r2, lsl #2"),
    (b"\x2f\x01\x91\xe0", "adds r0, r1, pc, lsr #2"),
    (b"\x22\x01\x9f\xe0", "adds r0, pc, r2, lsr #2"),
    (b"\x6f\x01\x91\xe0", "adds r0, r1, pc, ror #2"),
    (b"\x62\x01\x9f\xe0", "adds r0, pc, r2, ror #2"),
    (b"\x6f\x00\x91\xe0", "adds r0, r1, pc, rrx"),
    (b"\x62\x00\x9f\xe0", "adds r0, pc, r2, rrx"),
    (b"\x5f\x03\x91\xe0", "adds r0, r1, pc, asr r3"),
    (b"\x52\x03\x9f\xe0", "adds r0, pc, r2, asr r3"),
    (b"\x1f\x03\x91\xe0", "adds r0, r1, pc, lsl r3"),
    (b"\x12\x03\x9f\xe0", "adds r0, pc, r2, lsl r3"),
    (b"\x3f\x03\x91\xe0", "adds r0, r1, pc, lsr r3"),
    (b"\x32\x03\x9f\xe0", "adds r0, pc, r2, lsr r3"),
    (b"\x7f\x03\x91\xe0", "adds r0, r1, pc, ror r3"),
    (b"\x72\x03\x9f\xe0", "adds r0, pc, r2, ror r3"),

    # ADD(S) with SP as operand ---------------------------------------------- #
    (b"\x02\x00\x9d\xe2", "adds r0, sp, #2"),
    (b"\x02\x00\x9d\x02", "addseq r0, sp, #2"),
    (b"\x02\x00\x9d\x12", "addsne r0, sp, #2"),
    (b"\x02\x00\x9d\x22", "addscs r0, sp, #2"),
    (b"\x02\x00\x9d\x32", "addscc r0, sp, #2"),
    (b"\x02\x00\x9d\x42", "addsmi r0, sp, #2"),
    (b"\x02\x00\x9d\x52", "addspl r0, sp, #2"),
    (b"\x02\x00\x9d\x62", "addsvs r0, sp, #2"),
    (b"\x02\x00\x9d\x72", "addsvc r0, sp, #2"),
    (b"\x02\x00\x9d\x82", "addshi r0, sp, #2"),
    (b"\x02\x00\x9d\x92", "addsls r0, sp, #2"),
    (b"\x02\x00\x9d\xa2", "addsge r0, sp, #2"),
    (b"\x02\x00\x9d\xb2", "addslt r0, sp, #2"),
    (b"\x02\x00\x9d\xc2", "addsgt r0, sp, #2"),
    (b"\x02\x00\x9d\xd2", "addsle r0, sp, #2"),
    (b"\x02\x00\x9d\xe2", "addsal r0, sp, #2"),

    (b"\x03\x00\x9d\xe0", "adds r0, sp, r3"),
    (b"\x03\x00\x9d\x00", "addseq r0, sp, r3"),
    (b"\x03\x00\x9d\x10", "addsne r0, sp, r3"),
    (b"\x03\x00\x9d\x20", "addscs r0, sp, r3"),
    (b"\x03\x00\x9d\x30", "addscc r0, sp, r3"),
    (b"\x03\x00\x9d\x40", "addsmi r0, sp, r3"),
    (b"\x03\x00\x9d\x50", "addspl r0, sp, r3"),
    (b"\x03\x00\x9d\x60", "addsvs r0, sp, r3"),
    (b"\x03\x00\x9d\x70", "addsvc r0, sp, r3"),
    (b"\x03\x00\x9d\x80", "addshi r0, sp, r3"),
    (b"\x03\x00\x9d\x90", "addsls r0, sp, r3"),
    (b"\x03\x00\x9d\xa0", "addsge r0, sp, r3"),
    (b"\x03\x00\x9d\xb0", "addslt r0, sp, r3"),
    (b"\x03\x00\x9d\xc0", "addsgt r0, sp, r3"),
    (b"\x03\x00\x9d\xd0", "addsle r0, sp, r3"),
    (b"\x03\x00\x9d\xe0", "addsal r0, sp, r3"),

    (b"\x02\xd0\x9d\xe2", "adds sp, sp, #2"),
    (b"\x02\xd0\x9d\x02", "addseq sp, sp, #2"),
    (b"\x02\xd0\x9d\x12", "addsne sp, sp, #2"),
    (b"\x02\xd0\x9d\x22", "addscs sp, sp, #2"),
    (b"\x02\xd0\x9d\x32", "addscc sp, sp, #2"),
    (b"\x02\xd0\x9d\x42", "addsmi sp, sp, #2"),
    (b"\x02\xd0\x9d\x52", "addspl sp, sp, #2"),
    (b"\x02\xd0\x9d\x62", "addsvs sp, sp, #2"),
    (b"\x02\xd0\x9d\x72", "addsvc sp, sp, #2"),
    (b"\x02\xd0\x9d\x82", "addshi sp, sp, #2"),
    (b"\x02\xd0\x9d\x92", "addsls sp, sp, #2"),
    (b"\x02\xd0\x9d\xa2", "addsge sp, sp, #2"),
    (b"\x02\xd0\x9d\xb2", "addslt sp, sp, #2"),
    (b"\x02\xd0\x9d\xc2", "addsgt sp, sp, #2"),
    (b"\x02\xd0\x9d\xd2", "addsle sp, sp, #2"),
    (b"\x02\xd0\x9d\xe2", "addsal sp, sp, #2"),

    (b"\x03\xd0\x9d\xe0", "adds sp, sp, r3"),
    (b"\x03\xd0\x9d\x00", "addseq sp, sp, r3"),
    (b"\x03\xd0\x9d\x10", "addsne sp, sp, r3"),
    (b"\x03\xd0\x9d\x20", "addscs sp, sp, r3"),
    (b"\x03\xd0\x9d\x30", "addscc sp, sp, r3"),
    (b"\x03\xd0\x9d\x40", "addsmi sp, sp, r3"),
    (b"\x03\xd0\x9d\x50", "addspl sp, sp, r3"),
    (b"\x03\xd0\x9d\x60", "addsvs sp, sp, r3"),
    (b"\x03\xd0\x9d\x70", "addsvc sp, sp, r3"),
    (b"\x03\xd0\x9d\x80", "addshi sp, sp, r3"),
    (b"\x03\xd0\x9d\x90", "addsls sp, sp, r3"),
    (b"\x03\xd0\x9d\xa0", "addsge sp, sp, r3"),
    (b"\x03\xd0\x9d\xb0", "addslt sp, sp, r3"),
    (b"\x03\xd0\x9d\xc0", "addsgt sp, sp, r3"),
    (b"\x03\xd0\x9d\xd0", "addsle sp, sp, r3"),
    (b"\x03\xd0\x9d\xe0", "addsal sp, sp, r3"),

    (b"\x1d\xdd\x8d\xe0", "add sp, sp, sp, lsl sp"),
    (b"\x1d\xdd\x9d\xe0", "adds sp, sp, sp, lsl sp"),
    (b"\x3d\xdd\x8d\xe0", "add sp, sp, sp, lsr sp"),
    (b"\x3d\xdd\x9d\xe0", "adds sp, sp, sp, lsr sp"),
    (b"\x5d\xdd\x8d\xe0", "add sp, sp, sp, asr sp"),
    (b"\x5d\xdd\x9d\xe0", "adds sp, sp, sp, asr sp"),
    (b"\x5d\xdd\x8d\xe0", "add sp, sp, sp, asr sp"),
    (b"\x5d\xdd\x9d\xe0", "adds sp, sp, sp, asr sp"),
    (b"\x7d\xdd\x8d\xe0", "add sp, sp, sp, ror sp"),
    (b"\x7d\xdd\x9d\xe0", "adds sp, sp, sp, ror sp"),
    (b"\x7d\xdd\x8d\xe0", "add sp, sp, sp, ror sp"),
    (b"\x7d\xdd\x9d\xe0", "adds sp, sp, sp, ror sp"),

    # AND -------------------------------------------------------------------- #
    (b"\x02\x00\x01\xe2", "and r0, r1, #2"),
    (b"\x02\x00\x01\x02", "andeq r0, r1, #2"),
    (b"\x02\x00\x01\x12", "andne r0, r1, #2"),
    (b"\x02\x00\x01\x22", "andcs r0, r1, #2"),
    (b"\x02\x00\x01\x32", "andcc r0, r1, #2"),
    (b"\x02\x00\x01\x42", "andmi r0, r1, #2"),
    (b"\x02\x00\x01\x52", "andpl r0, r1, #2"),
    (b"\x02\x00\x01\x62", "andvs r0, r1, #2"),
    (b"\x02\x00\x01\x72", "andvc r0, r1, #2"),
    (b"\x02\x00\x01\x82", "andhi r0, r1, #2"),
    (b"\x02\x00\x01\x92", "andls r0, r1, #2"),
    (b"\x02\x00\x01\xa2", "andge r0, r1, #2"),
    (b"\x02\x00\x01\xb2", "andlt r0, r1, #2"),
    (b"\x02\x00\x01\xc2", "andgt r0, r1, #2"),
    (b"\x02\x00\x01\xd2", "andle r0, r1, #2"),
    (b"\x02\x00\x01\xe2", "andal r0, r1, #2"),

    (b"\x03\x00\x01\xe0", "and r0, r1, r3"),
    (b"\x03\x00\x01\x00", "andeq r0, r1, r3"),
    (b"\x03\x00\x01\x10", "andne r0, r1, r3"),
    (b"\x03\x00\x01\x20", "andcs r0, r1, r3"),
    (b"\x03\x00\x01\x30", "andcc r0, r1, r3"),
    (b"\x03\x00\x01\x40", "andmi r0, r1, r3"),
    (b"\x03\x00\x01\x50", "andpl r0, r1, r3"),
    (b"\x03\x00\x01\x60", "andvs r0, r1, r3"),
    (b"\x03\x00\x01\x70", "andvc r0, r1, r3"),
    (b"\x03\x00\x01\x80", "andhi r0, r1, r3"),
    (b"\x03\x00\x01\x90", "andls r0, r1, r3"),
    (b"\x03\x00\x01\xa0", "andge r0, r1, r3"),
    (b"\x03\x00\x01\xb0", "andlt r0, r1, r3"),
    (b"\x03\x00\x01\xc0", "andgt r0, r1, r3"),
    (b"\x03\x00\x01\xd0", "andle r0, r1, r3"),

    # ANDS ------------------------------------------------------------------- #
    (b"\x02\x00\x11\xe2", "ands r0, r1, #2"),
    (b"\x02\x00\x11\x02", "andseq r0, r1, #2"),
    (b"\x02\x00\x11\x12", "andsne r0, r1, #2"),
    (b"\x02\x00\x11\x22", "andscs r0, r1, #2"),
    (b"\x02\x00\x11\x32", "andscc r0, r1, #2"),
    (b"\x02\x00\x11\x42", "andsmi r0, r1, #2"),
    (b"\x02\x00\x11\x52", "andspl r0, r1, #2"),
    (b"\x02\x00\x11\x62", "andsvs r0, r1, #2"),
    (b"\x02\x00\x11\x72", "andsvc r0, r1, #2"),
    (b"\x02\x00\x11\x82", "andshi r0, r1, #2"),
    (b"\x02\x00\x11\x92", "andsls r0, r1, #2"),
    (b"\x02\x00\x11\xa2", "andsge r0, r1, #2"),
    (b"\x02\x00\x11\xb2", "andslt r0, r1, #2"),
    (b"\x02\x00\x11\xc2", "andsgt r0, r1, #2"),
    (b"\x02\x00\x11\xd2", "andsle r0, r1, #2"),
    (b"\x02\x00\x11\xe2", "andsal r0, r1, #2"),

    (b"\x03\x00\x11\xe0", "ands r0, r1, r3"),
    (b"\x03\x00\x11\x00", "andseq r0, r1, r3"),
    (b"\x03\x00\x11\x10", "andsne r0, r1, r3"),
    (b"\x03\x00\x11\x20", "andscs r0, r1, r3"),
    (b"\x03\x00\x11\x30", "andscc r0, r1, r3"),
    (b"\x03\x00\x11\x40", "andsmi r0, r1, r3"),
    (b"\x03\x00\x11\x50", "andspl r0, r1, r3"),
    (b"\x03\x00\x11\x60", "andsvs r0, r1, r3"),
    (b"\x03\x00\x11\x70", "andsvc r0, r1, r3"),
    (b"\x03\x00\x11\x80", "andshi r0, r1, r3"),
    (b"\x03\x00\x11\x90", "andsls r0, r1, r3"),
    (b"\x03\x00\x11\xa0", "andsge r0, r1, r3"),
    (b"\x03\x00\x11\xb0", "andslt r0, r1, r3"),
    (b"\x03\x00\x11\xc0", "andsgt r0, r1, r3"),
    (b"\x03\x00\x11\xd0", "andsle r0, r1, r3"),
    (b"\x03\x00\x11\xe0", "andsal r0, r1, r3"),

    (b"\x41\x02\x10\x00", "andseq r0, r1, asr #4"),
    (b"\x41\x02\x10\x10", "andsne r0, r1, asr #4"),
    (b"\x41\x02\x10\x20", "andscs r0, r1, asr #4"),
    (b"\x41\x02\x10\x30", "andscc r0, r1, asr #4"),
    (b"\x41\x02\x10\x40", "andsmi r0, r1, asr #4"),
    (b"\x41\x02\x10\x50", "andspl r0, r1, asr #4"),
    (b"\x41\x02\x10\x60", "andsvs r0, r1, asr #4"),
    (b"\x41\x02\x10\x70", "andsvc r0, r1, asr #4"),
    (b"\x41\x02\x10\x80", "andshi r0, r1, asr #4"),
    (b"\x41\x02\x10\x90", "andsls r0, r1, asr #4"),
    (b"\x41\x02\x10\xa0", "andsge r0, r1, asr #4"),
    (b"\x41\x02\x10\xb0", "andslt r0, r1, asr #4"),
    (b"\x41\x02\x10\xc0", "andsgt r0, r1, asr #4"),
    (b"\x41\x02\x10\xd0", "andsle r0, r1, asr #4"),
    (b"\x41\x02\x10\xe0", "andsal r0, r1, asr #4"),

    (b"\x51\x03\x10\x00", "andseq r0, r1, asr r3"),
    (b"\x51\x03\x10\x10", "andsne r0, r1, asr r3"),
    (b"\x51\x03\x10\x20", "andscs r0, r1, asr r3"),
    (b"\x51\x03\x10\x30", "andscc r0, r1, asr r3"),
    (b"\x51\x03\x10\x40", "andsmi r0, r1, asr r3"),
    (b"\x51\x03\x10\x50", "andspl r0, r1, asr r3"),
    (b"\x51\x03\x10\x60", "andsvs r0, r1, asr r3"),
    (b"\x51\x03\x10\x70", "andsvc r0, r1, asr r3"),
    (b"\x51\x03\x10\x80", "andshi r0, r1, asr r3"),
    (b"\x51\x03\x10\x90", "andsls r0, r1, asr r3"),
    (b"\x51\x03\x10\xa0", "andsge r0, r1, asr r3"),
    (b"\x51\x03\x10\xb0", "andslt r0, r1, asr r3"),
    (b"\x51\x03\x10\xc0", "andsgt r0, r1, asr r3"),
    (b"\x51\x03\x10\xd0", "andsle r0, r1, asr r3"),
    (b"\x51\x03\x10\xe0", "andsal r0, r1, asr r3"),

    (b"\x01\x02\x10\x00", "andseq r0, r1, lsl #4"),
    (b"\x01\x02\x10\x10", "andsne r0, r1, lsl #4"),
    (b"\x01\x02\x10\x20", "andscs r0, r1, lsl #4"),
    (b"\x01\x02\x10\x30", "andscc r0, r1, lsl #4"),
    (b"\x01\x02\x10\x40", "andsmi r0, r1, lsl #4"),
    (b"\x01\x02\x10\x50", "andspl r0, r1, lsl #4"),
    (b"\x01\x02\x10\x60", "andsvs r0, r1, lsl #4"),
    (b"\x01\x02\x10\x70", "andsvc r0, r1, lsl #4"),
    (b"\x01\x02\x10\x80", "andshi r0, r1, lsl #4"),
    (b"\x01\x02\x10\x90", "andsls r0, r1, lsl #4"),
    (b"\x01\x02\x10\xa0", "andsge r0, r1, lsl #4"),
    (b"\x01\x02\x10\xb0", "andslt r0, r1, lsl #4"),
    (b"\x01\x02\x10\xc0", "andsgt r0, r1, lsl #4"),
    (b"\x01\x02\x10\xd0", "andsle r0, r1, lsl #4"),
    (b"\x01\x02\x10\xe0", "andsal r0, r1, lsl #4"),

    (b"\x11\x03\x10\x00", "andseq r0, r1, lsl r3"),
    (b"\x11\x03\x10\x10", "andsne r0, r1, lsl r3"),
    (b"\x11\x03\x10\x20", "andscs r0, r1, lsl r3"),
    (b"\x11\x03\x10\x30", "andscc r0, r1, lsl r3"),
    (b"\x11\x03\x10\x40", "andsmi r0, r1, lsl r3"),
    (b"\x11\x03\x10\x50", "andspl r0, r1, lsl r3"),
    (b"\x11\x03\x10\x60", "andsvs r0, r1, lsl r3"),
    (b"\x11\x03\x10\x70", "andsvc r0, r1, lsl r3"),
    (b"\x11\x03\x10\x80", "andshi r0, r1, lsl r3"),
    (b"\x11\x03\x10\x90", "andsls r0, r1, lsl r3"),
    (b"\x11\x03\x10\xa0", "andsge r0, r1, lsl r3"),
    (b"\x11\x03\x10\xb0", "andslt r0, r1, lsl r3"),
    (b"\x11\x03\x10\xc0", "andsgt r0, r1, lsl r3"),
    (b"\x11\x03\x10\xd0", "andsle r0, r1, lsl r3"),
    (b"\x11\x03\x10\xe0", "andsal r0, r1, lsl r3"),

    (b"\x21\x02\x10\x00", "andseq r0, r1, lsr #4"),
    (b"\x21\x02\x10\x10", "andsne r0, r1, lsr #4"),
    (b"\x21\x02\x10\x20", "andscs r0, r1, lsr #4"),
    (b"\x21\x02\x10\x30", "andscc r0, r1, lsr #4"),
    (b"\x21\x02\x10\x40", "andsmi r0, r1, lsr #4"),
    (b"\x21\x02\x10\x50", "andspl r0, r1, lsr #4"),
    (b"\x21\x02\x10\x60", "andsvs r0, r1, lsr #4"),
    (b"\x21\x02\x10\x70", "andsvc r0, r1, lsr #4"),
    (b"\x21\x02\x10\x80", "andshi r0, r1, lsr #4"),
    (b"\x21\x02\x10\x90", "andsls r0, r1, lsr #4"),
    (b"\x21\x02\x10\xa0", "andsge r0, r1, lsr #4"),
    (b"\x21\x02\x10\xb0", "andslt r0, r1, lsr #4"),
    (b"\x21\x02\x10\xc0", "andsgt r0, r1, lsr #4"),
    (b"\x21\x02\x10\xd0", "andsle r0, r1, lsr #4"),
    (b"\x21\x02\x10\xe0", "andsal r0, r1, lsr #4"),

    (b"\x31\x03\x10\x00", "andseq r0, r1, lsr r3"),
    (b"\x31\x03\x10\x10", "andsne r0, r1, lsr r3"),
    (b"\x31\x03\x10\x20", "andscs r0, r1, lsr r3"),
    (b"\x31\x03\x10\x30", "andscc r0, r1, lsr r3"),
    (b"\x31\x03\x10\x40", "andsmi r0, r1, lsr r3"),
    (b"\x31\x03\x10\x50", "andspl r0, r1, lsr r3"),
    (b"\x31\x03\x10\x60", "andsvs r0, r1, lsr r3"),
    (b"\x31\x03\x10\x70", "andsvc r0, r1, lsr r3"),
    (b"\x31\x03\x10\x80", "andshi r0, r1, lsr r3"),
    (b"\x31\x03\x10\x90", "andsls r0, r1, lsr r3"),
    (b"\x31\x03\x10\xa0", "andsge r0, r1, lsr r3"),
    (b"\x31\x03\x10\xb0", "andslt r0, r1, lsr r3"),
    (b"\x31\x03\x10\xc0", "andsgt r0, r1, lsr r3"),
    (b"\x31\x03\x10\xd0", "andsle r0, r1, lsr r3"),
    (b"\x31\x03\x10\xe0", "andsal r0, r1, lsr r3"),

    (b"\x61\x02\x10\x00", "andseq r0, r1, ror #4"),
    (b"\x61\x02\x10\x10", "andsne r0, r1, ror #4"),
    (b"\x61\x02\x10\x20", "andscs r0, r1, ror #4"),
    (b"\x61\x02\x10\x30", "andscc r0, r1, ror #4"),
    (b"\x61\x02\x10\x40", "andsmi r0, r1, ror #4"),
    (b"\x61\x02\x10\x50", "andspl r0, r1, ror #4"),
    (b"\x61\x02\x10\x60", "andsvs r0, r1, ror #4"),
    (b"\x61\x02\x10\x70", "andsvc r0, r1, ror #4"),
    (b"\x61\x02\x10\x80", "andshi r0, r1, ror #4"),
    (b"\x61\x02\x10\x90", "andsls r0, r1, ror #4"),
    (b"\x61\x02\x10\xa0", "andsge r0, r1, ror #4"),
    (b"\x61\x02\x10\xb0", "andslt r0, r1, ror #4"),
    (b"\x61\x02\x10\xc0", "andsgt r0, r1, ror #4"),
    (b"\x61\x02\x10\xd0", "andsle r0, r1, ror #4"),
    (b"\x61\x02\x10\xe0", "andsal r0, r1, ror #4"),

    (b"\x71\x03\x10\x00", "andseq r0, r1, ror r3"),
    (b"\x71\x03\x10\x10", "andsne r0, r1, ror r3"),
    (b"\x71\x03\x10\x20", "andscs r0, r1, ror r3"),
    (b"\x71\x03\x10\x30", "andscc r0, r1, ror r3"),
    (b"\x71\x03\x10\x40", "andsmi r0, r1, ror r3"),
    (b"\x71\x03\x10\x50", "andspl r0, r1, ror r3"),
    (b"\x71\x03\x10\x60", "andsvs r0, r1, ror r3"),
    (b"\x71\x03\x10\x70", "andsvc r0, r1, ror r3"),
    (b"\x71\x03\x10\x80", "andshi r0, r1, ror r3"),
    (b"\x71\x03\x10\x90", "andsls r0, r1, ror r3"),
    (b"\x71\x03\x10\xa0", "andsge r0, r1, ror r3"),
    (b"\x71\x03\x10\xb0", "andslt r0, r1, ror r3"),
    (b"\x71\x03\x10\xc0", "andsgt r0, r1, ror r3"),
    (b"\x71\x03\x10\xd0", "andsle r0, r1, ror r3"),
    (b"\x71\x03\x10\xe0", "andsal r0, r1, ror r3"),

    (b"\x61\x00\x10\x00", "andseq r0, r1, rrx"),
    (b"\x61\x00\x10\x10", "andsne r0, r1, rrx"),
    (b"\x61\x00\x10\x20", "andscs r0, r1, rrx"),
    (b"\x61\x00\x10\x30", "andscc r0, r1, rrx"),
    (b"\x61\x00\x10\x40", "andsmi r0, r1, rrx"),
    (b"\x61\x00\x10\x50", "andspl r0, r1, rrx"),
    (b"\x61\x00\x10\x60", "andsvs r0, r1, rrx"),
    (b"\x61\x00\x10\x70", "andsvc r0, r1, rrx"),
    (b"\x61\x00\x10\x80", "andshi r0, r1, rrx"),
    (b"\x61\x00\x10\x90", "andsls r0, r1, rrx"),
    (b"\x61\x00\x10\xa0", "andsge r0, r1, rrx"),
    (b"\x61\x00\x10\xb0", "andslt r0, r1, rrx"),
    (b"\x61\x00\x10\xc0", "andsgt r0, r1, rrx"),
    (b"\x61\x00\x10\xd0", "andsle r0, r1, rrx"),
    (b"\x61\x00\x10\xe0", "andsal r0, r1, rrx"),

    # ASR -------------------------------------------------------------------- #
    (b"\x41\x01\xa0\xe1", "asr r0, r1, #2"),
    (b"\x41\x01\xa0\x01", "asreq r0, r1, #2"),
    (b"\x41\x01\xa0\x11", "asrne r0, r1, #2"),
    (b"\x41\x01\xa0\x21", "asrcs r0, r1, #2"),
    (b"\x41\x01\xa0\x31", "asrcc r0, r1, #2"),
    (b"\x41\x01\xa0\x41", "asrmi r0, r1, #2"),
    (b"\x41\x01\xa0\x51", "asrpl r0, r1, #2"),
    (b"\x41\x01\xa0\x61", "asrvs r0, r1, #2"),
    (b"\x41\x01\xa0\x71", "asrvc r0, r1, #2"),
    (b"\x41\x01\xa0\x81", "asrhi r0, r1, #2"),
    (b"\x41\x01\xa0\x91", "asrls r0, r1, #2"),
    (b"\x41\x01\xa0\xa1", "asrge r0, r1, #2"),
    (b"\x41\x01\xa0\xb1", "asrlt r0, r1, #2"),
    (b"\x41\x01\xa0\xc1", "asrgt r0, r1, #2"),
    (b"\x41\x01\xa0\xd1", "asrle r0, r1, #2"),
    (b"\x41\x01\xa0\xe1", "asral r0, r1, #2"),

    (b"\x51\x03\xa0\xe1", "asr r0, r1, r3"),
    (b"\x51\x03\xa0\x01", "asreq r0, r1, r3"),
    (b"\x51\x03\xa0\x11", "asrne r0, r1, r3"),
    (b"\x51\x03\xa0\x21", "asrcs r0, r1, r3"),
    (b"\x51\x03\xa0\x31", "asrcc r0, r1, r3"),
    (b"\x51\x03\xa0\x41", "asrmi r0, r1, r3"),
    (b"\x51\x03\xa0\x51", "asrpl r0, r1, r3"),
    (b"\x51\x03\xa0\x61", "asrvs r0, r1, r3"),
    (b"\x51\x03\xa0\x71", "asrvc r0, r1, r3"),
    (b"\x51\x03\xa0\x81", "asrhi r0, r1, r3"),
    (b"\x51\x03\xa0\x91", "asrls r0, r1, r3"),
    (b"\x51\x03\xa0\xa1", "asrge r0, r1, r3"),
    (b"\x51\x03\xa0\xb1", "asrlt r0, r1, r3"),
    (b"\x51\x03\xa0\xc1", "asrgt r0, r1, r3"),
    (b"\x51\x03\xa0\xd1", "asrle r0, r1, r3"),

    # ASR(S) ----------------------------------------------------------------- #
    (b"\x41\x01\xb0\xe1", "asrs r0, r1, #2"),
    (b"\x41\x01\xb0\x01", "asrseq r0, r1, #2"),
    (b"\x41\x01\xb0\x11", "asrsne r0, r1, #2"),
    (b"\x41\x01\xb0\x21", "asrscs r0, r1, #2"),
    (b"\x41\x01\xb0\x31", "asrscc r0, r1, #2"),
    (b"\x41\x01\xb0\x41", "asrsmi r0, r1, #2"),
    (b"\x41\x01\xb0\x51", "asrspl r0, r1, #2"),
    (b"\x41\x01\xb0\x61", "asrsvs r0, r1, #2"),
    (b"\x41\x01\xb0\x71", "asrsvc r0, r1, #2"),
    (b"\x41\x01\xb0\x81", "asrshi r0, r1, #2"),
    (b"\x41\x01\xb0\x91", "asrsls r0, r1, #2"),
    (b"\x41\x01\xb0\xa1", "asrsge r0, r1, #2"),
    (b"\x41\x01\xb0\xb1", "asrslt r0, r1, #2"),
    (b"\x41\x01\xb0\xc1", "asrsgt r0, r1, #2"),
    (b"\x41\x01\xb0\xd1", "asrsle r0, r1, #2"),
    (b"\x41\x01\xb0\xe1", "asrsal r0, r1, #2"),

    (b"\x51\x03\xb0\xe1", "asrs r0, r1, r3"),
    (b"\x51\x03\xb0\x01", "asrseq r0, r1, r3"),
    (b"\x51\x03\xb0\x11", "asrsne r0, r1, r3"),
    (b"\x51\x03\xb0\x21", "asrscs r0, r1, r3"),
    (b"\x51\x03\xb0\x31", "asrscc r0, r1, r3"),
    (b"\x51\x03\xb0\x41", "asrsmi r0, r1, r3"),
    (b"\x51\x03\xb0\x51", "asrspl r0, r1, r3"),
    (b"\x51\x03\xb0\x61", "asrsvs r0, r1, r3"),
    (b"\x51\x03\xb0\x71", "asrsvc r0, r1, r3"),
    (b"\x51\x03\xb0\x81", "asrshi r0, r1, r3"),
    (b"\x51\x03\xb0\x91", "asrsls r0, r1, r3"),
    (b"\x51\x03\xb0\xa1", "asrsge r0, r1, r3"),
    (b"\x51\x03\xb0\xb1", "asrslt r0, r1, r3"),
    (b"\x51\x03\xb0\xc1", "asrsgt r0, r1, r3"),
    (b"\x51\x03\xb0\xd1", "asrsle r0, r1, r3"),
    (b"\x51\x03\xb0\xe1", "asrsal r0, r1, r3"),

    # BFC -------------------------------------------------------------------- #
    (b"\x9f\x06\xd3\x07", "bfceq r0, #13, #7"),
    (b"\x9f\x06\xd3\x17", "bfcne r0, #13, #7"),
    (b"\x9f\x06\xd3\x27", "bfccs r0, #13, #7"),
    (b"\x9f\x06\xd3\x37", "bfccc r0, #13, #7"),
    (b"\x9f\x06\xd3\x47", "bfcmi r0, #13, #7"),
    (b"\x9f\x06\xd3\x57", "bfcpl r0, #13, #7"),
    (b"\x9f\x06\xd3\x67", "bfcvs r0, #13, #7"),
    (b"\x9f\x06\xd3\x77", "bfcvc r0, #13, #7"),
    (b"\x9f\x06\xd3\x87", "bfchi r0, #13, #7"),
    (b"\x9f\x06\xd3\x97", "bfcls r0, #13, #7"),
    (b"\x9f\x06\xd3\xa7", "bfcge r0, #13, #7"),
    (b"\x9f\x06\xd3\xb7", "bfclt r0, #13, #7"),
    (b"\x9f\x06\xd3\xc7", "bfcgt r0, #13, #7"),
    (b"\x9f\x06\xd3\xd7", "bfcle r0, #13, #7"),
    (b"\x9f\x06\xd3\xe7", "bfcal r0, #13, #7"),
    (b"\x9f\x02\xd7\x07", "bfceq r0, #5, #19"),
    (b"\x9f\x02\xd7\x17", "bfcne r0, #5, #19"),
    (b"\x9f\x02\xd7\x27", "bfccs r0, #5, #19"),
    (b"\x9f\x02\xd7\x37", "bfccc r0, #5, #19"),
    (b"\x9f\x02\xd7\x47", "bfcmi r0, #5, #19"),
    (b"\x9f\x02\xd7\x57", "bfcpl r0, #5, #19"),
    (b"\x9f\x02\xd7\x67", "bfcvs r0, #5, #19"),
    (b"\x9f\x02\xd7\x77", "bfcvc r0, #5, #19"),
    (b"\x9f\x02\xd7\x87", "bfchi r0, #5, #19"),
    (b"\x9f\x02\xd7\x97", "bfcls r0, #5, #19"),
    (b"\x9f\x02\xd7\xa7", "bfcge r0, #5, #19"),
    (b"\x9f\x02\xd7\xb7", "bfclt r0, #5, #19"),
    (b"\x9f\x02\xd7\xc7", "bfcgt r0, #5, #19"),
    (b"\x9f\x02\xd7\xd7", "bfcle r0, #5, #19"),
    (b"\x9f\x02\xd7\xe7", "bfcal r0, #5, #19"),

    # BFI -------------------------------------------------------------------- #
    (b"\x91\x06\xd3\x07", "bfieq r0, r1, #13, #7"),
    (b"\x91\x06\xd3\x17", "bfine r0, r1, #13, #7"),
    (b"\x91\x06\xd3\x27", "bfics r0, r1, #13, #7"),
    (b"\x91\x06\xd3\x37", "bficc r0, r1, #13, #7"),
    (b"\x91\x06\xd3\x47", "bfimi r0, r1, #13, #7"),
    (b"\x91\x06\xd3\x57", "bfipl r0, r1, #13, #7"),
    (b"\x91\x06\xd3\x67", "bfivs r0, r1, #13, #7"),
    (b"\x91\x06\xd3\x77", "bfivc r0, r1, #13, #7"),
    (b"\x91\x06\xd3\x87", "bfihi r0, r1, #13, #7"),
    (b"\x91\x06\xd3\x97", "bfils r0, r1, #13, #7"),
    (b"\x91\x06\xd3\xa7", "bfige r0, r1, #13, #7"),
    (b"\x91\x06\xd3\xb7", "bfilt r0, r1, #13, #7"),
    (b"\x91\x06\xd3\xc7", "bfigt r0, r1, #13, #7"),
    (b"\x91\x06\xd3\xd7", "bfile r0, r1, #13, #7"),
    (b"\x91\x06\xd3\xe7", "bfial r0, r1, #13, #7"),
    (b"\x91\x02\xd7\x07", "bfieq r0, r1, #5, #19"),
    (b"\x91\x02\xd7\x17", "bfine r0, r1, #5, #19"),
    (b"\x91\x02\xd7\x27", "bfics r0, r1, #5, #19"),
    (b"\x91\x02\xd7\x37", "bficc r0, r1, #5, #19"),
    (b"\x91\x02\xd7\x47", "bfimi r0, r1, #5, #19"),
    (b"\x91\x02\xd7\x57", "bfipl r0, r1, #5, #19"),
    (b"\x91\x02\xd7\x67", "bfivs r0, r1, #5, #19"),
    (b"\x91\x02\xd7\x77", "bfivc r0, r1, #5, #19"),
    (b"\x91\x02\xd7\x87", "bfihi r0, r1, #5, #19"),
    (b"\x91\x02\xd7\x97", "bfils r0, r1, #5, #19"),
    (b"\x91\x02\xd7\xa7", "bfige r0, r1, #5, #19"),
    (b"\x91\x02\xd7\xb7", "bfilt r0, r1, #5, #19"),
    (b"\x91\x02\xd7\xc7", "bfigt r0, r1, #5, #19"),
    (b"\x91\x02\xd7\xd7", "bfile r0, r1, #5, #19"),
    (b"\x91\x02\xd7\xe7", "bfial r0, r1, #5, #19"),

    # BIC -------------------------------------------------------------------- #
    (b"\x02\x00\xc1\xe3", "bic r0, r1, #2"),
    (b"\x02\x00\xc1\x03", "biceq r0, r1, #2"),
    (b"\x02\x00\xc1\x13", "bicne r0, r1, #2"),
    (b"\x02\x00\xc1\x23", "biccs r0, r1, #2"),
    (b"\x02\x00\xc1\x33", "biccc r0, r1, #2"),
    (b"\x02\x00\xc1\x43", "bicmi r0, r1, #2"),
    (b"\x02\x00\xc1\x53", "bicpl r0, r1, #2"),
    (b"\x02\x00\xc1\x63", "bicvs r0, r1, #2"),
    (b"\x02\x00\xc1\x73", "bicvc r0, r1, #2"),
    (b"\x02\x00\xc1\x83", "bichi r0, r1, #2"),
    (b"\x02\x00\xc1\x93", "bicls r0, r1, #2"),
    (b"\x02\x00\xc1\xa3", "bicge r0, r1, #2"),
    (b"\x02\x00\xc1\xb3", "biclt r0, r1, #2"),
    (b"\x02\x00\xc1\xc3", "bicgt r0, r1, #2"),
    (b"\x02\x00\xc1\xd3", "bicle r0, r1, #2"),
    (b"\x02\x00\xc1\xe3", "bical r0, r1, #2"),

    (b"\x03\x00\xc1\xe1", "bic r0, r1, r3"),
    (b"\x03\x00\xc1\x01", "biceq r0, r1, r3"),
    (b"\x03\x00\xc1\x11", "bicne r0, r1, r3"),
    (b"\x03\x00\xc1\x21", "biccs r0, r1, r3"),
    (b"\x03\x00\xc1\x31", "biccc r0, r1, r3"),
    (b"\x03\x00\xc1\x41", "bicmi r0, r1, r3"),
    (b"\x03\x00\xc1\x51", "bicpl r0, r1, r3"),
    (b"\x03\x00\xc1\x61", "bicvs r0, r1, r3"),
    (b"\x03\x00\xc1\x71", "bicvc r0, r1, r3"),
    (b"\x03\x00\xc1\x81", "bichi r0, r1, r3"),
    (b"\x03\x00\xc1\x91", "bicls r0, r1, r3"),
    (b"\x03\x00\xc1\xa1", "bicge r0, r1, r3"),
    (b"\x03\x00\xc1\xb1", "biclt r0, r1, r3"),
    (b"\x03\x00\xc1\xc1", "bicgt r0, r1, r3"),
    (b"\x03\x00\xc1\xd1", "bicle r0, r1, r3"),
    (b"\x03\x00\xc1\xe1", "bical r0, r1, r3"),

    (b"\x02\x00\xd1\xe3", "bics r0, r1, #2"),
    (b"\x02\x00\xd1\x03", "bicseq r0, r1, #2"),
    (b"\x02\x00\xd1\x13", "bicsne r0, r1, #2"),
    (b"\x02\x00\xd1\x23", "bicscs r0, r1, #2"),
    (b"\x02\x00\xd1\x33", "bicscc r0, r1, #2"),
    (b"\x02\x00\xd1\x43", "bicsmi r0, r1, #2"),
    (b"\x02\x00\xd1\x53", "bicspl r0, r1, #2"),
    (b"\x02\x00\xd1\x63", "bicsvs r0, r1, #2"),
    (b"\x02\x00\xd1\x73", "bicsvc r0, r1, #2"),
    (b"\x02\x00\xd1\x83", "bicshi r0, r1, #2"),
    (b"\x02\x00\xd1\x93", "bicsls r0, r1, #2"),
    (b"\x02\x00\xd1\xa3", "bicsge r0, r1, #2"),
    (b"\x02\x00\xd1\xb3", "bicslt r0, r1, #2"),
    (b"\x02\x00\xd1\xc3", "bicsgt r0, r1, #2"),
    (b"\x02\x00\xd1\xd3", "bicsle r0, r1, #2"),
    (b"\x02\x00\xd1\xe3", "bicsal r0, r1, #2"),

    (b"\x03\x00\xd1\xe1", "bics r0, r1, r3"),
    (b"\x03\x00\xd1\x01", "bicseq r0, r1, r3"),
    (b"\x03\x00\xd1\x11", "bicsne r0, r1, r3"),
    (b"\x03\x00\xd1\x21", "bicscs r0, r1, r3"),
    (b"\x03\x00\xd1\x31", "bicscc r0, r1, r3"),
    (b"\x03\x00\xd1\x41", "bicsmi r0, r1, r3"),
    (b"\x03\x00\xd1\x51", "bicspl r0, r1, r3"),
    (b"\x03\x00\xd1\x61", "bicsvs r0, r1, r3"),
    (b"\x03\x00\xd1\x71", "bicsvc r0, r1, r3"),
    (b"\x03\x00\xd1\x81", "bicshi r0, r1, r3"),
    (b"\x03\x00\xd1\x91", "bicsls r0, r1, r3"),
    (b"\x03\x00\xd1\xa1", "bicsge r0, r1, r3"),
    (b"\x03\x00\xd1\xb1", "bicslt r0, r1, r3"),
    (b"\x03\x00\xd1\xc1", "bicsgt r0, r1, r3"),
    (b"\x03\x00\xd1\xd1", "bicsle r0, r1, r3"),
    (b"\x03\x00\xd1\xe1", "bicsal r0, r1, r3"),

    (b"\x41\x02\xd0\x01", "bicseq r0, r1, asr #4"),
    (b"\x41\x02\xd0\x11", "bicsne r0, r1, asr #4"),
    (b"\x41\x02\xd0\x21", "bicscs r0, r1, asr #4"),
    (b"\x41\x02\xd0\x31", "bicscc r0, r1, asr #4"),
    (b"\x41\x02\xd0\x41", "bicsmi r0, r1, asr #4"),
    (b"\x41\x02\xd0\x51", "bicspl r0, r1, asr #4"),
    (b"\x41\x02\xd0\x61", "bicsvs r0, r1, asr #4"),
    (b"\x41\x02\xd0\x71", "bicsvc r0, r1, asr #4"),
    (b"\x41\x02\xd0\x81", "bicshi r0, r1, asr #4"),
    (b"\x41\x02\xd0\x91", "bicsls r0, r1, asr #4"),
    (b"\x41\x02\xd0\xa1", "bicsge r0, r1, asr #4"),
    (b"\x41\x02\xd0\xb1", "bicslt r0, r1, asr #4"),
    (b"\x41\x02\xd0\xc1", "bicsgt r0, r1, asr #4"),
    (b"\x41\x02\xd0\xd1", "bicsle r0, r1, asr #4"),
    (b"\x41\x02\xd0\xe1", "bicsal r0, r1, asr #4"),

    (b"\x51\x03\xd0\x01", "bicseq r0, r1, asr r3"),
    (b"\x51\x03\xd0\x11", "bicsne r0, r1, asr r3"),
    (b"\x51\x03\xd0\x21", "bicscs r0, r1, asr r3"),
    (b"\x51\x03\xd0\x31", "bicscc r0, r1, asr r3"),
    (b"\x51\x03\xd0\x41", "bicsmi r0, r1, asr r3"),
    (b"\x51\x03\xd0\x51", "bicspl r0, r1, asr r3"),
    (b"\x51\x03\xd0\x61", "bicsvs r0, r1, asr r3"),
    (b"\x51\x03\xd0\x71", "bicsvc r0, r1, asr r3"),
    (b"\x51\x03\xd0\x81", "bicshi r0, r1, asr r3"),
    (b"\x51\x03\xd0\x91", "bicsls r0, r1, asr r3"),
    (b"\x51\x03\xd0\xa1", "bicsge r0, r1, asr r3"),
    (b"\x51\x03\xd0\xb1", "bicslt r0, r1, asr r3"),
    (b"\x51\x03\xd0\xc1", "bicsgt r0, r1, asr r3"),
    (b"\x51\x03\xd0\xd1", "bicsle r0, r1, asr r3"),
    (b"\x51\x03\xd0\xe1", "bicsal r0, r1, asr r3"),

    (b"\x01\x02\xd0\x01", "bicseq r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x11", "bicsne r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x21", "bicscs r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x31", "bicscc r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x41", "bicsmi r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x51", "bicspl r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x61", "bicsvs r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x71", "bicsvc r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x81", "bicshi r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x91", "bicsls r0, r1, lsl #4"),
    (b"\x01\x02\xd0\xa1", "bicsge r0, r1, lsl #4"),
    (b"\x01\x02\xd0\xb1", "bicslt r0, r1, lsl #4"),
    (b"\x01\x02\xd0\xc1", "bicsgt r0, r1, lsl #4"),
    (b"\x01\x02\xd0\xd1", "bicsle r0, r1, lsl #4"),
    (b"\x01\x02\xd0\xe1", "bicsal r0, r1, lsl #4"),

    (b"\x11\x03\xd0\x01", "bicseq r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x11", "bicsne r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x21", "bicscs r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x31", "bicscc r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x41", "bicsmi r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x51", "bicspl r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x61", "bicsvs r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x71", "bicsvc r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x81", "bicshi r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x91", "bicsls r0, r1, lsl r3"),
    (b"\x11\x03\xd0\xa1", "bicsge r0, r1, lsl r3"),
    (b"\x11\x03\xd0\xb1", "bicslt r0, r1, lsl r3"),
    (b"\x11\x03\xd0\xc1", "bicsgt r0, r1, lsl r3"),
    (b"\x11\x03\xd0\xd1", "bicsle r0, r1, lsl r3"),
    (b"\x11\x03\xd0\xe1", "bicsal r0, r1, lsl r3"),

    (b"\x21\x02\xd0\x01", "bicseq r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x11", "bicsne r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x21", "bicscs r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x31", "bicscc r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x41", "bicsmi r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x51", "bicspl r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x61", "bicsvs r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x71", "bicsvc r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x81", "bicshi r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x91", "bicsls r0, r1, lsr #4"),
    (b"\x21\x02\xd0\xa1", "bicsge r0, r1, lsr #4"),
    (b"\x21\x02\xd0\xb1", "bicslt r0, r1, lsr #4"),
    (b"\x21\x02\xd0\xc1", "bicsgt r0, r1, lsr #4"),
    (b"\x21\x02\xd0\xd1", "bicsle r0, r1, lsr #4"),
    (b"\x21\x02\xd0\xe1", "bicsal r0, r1, lsr #4"),

    (b"\x31\x03\xd0\x01", "bicseq r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x11", "bicsne r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x21", "bicscs r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x31", "bicscc r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x41", "bicsmi r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x51", "bicspl r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x61", "bicsvs r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x71", "bicsvc r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x81", "bicshi r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x91", "bicsls r0, r1, lsr r3"),
    (b"\x31\x03\xd0\xa1", "bicsge r0, r1, lsr r3"),
    (b"\x31\x03\xd0\xb1", "bicslt r0, r1, lsr r3"),
    (b"\x31\x03\xd0\xc1", "bicsgt r0, r1, lsr r3"),
    (b"\x31\x03\xd0\xd1", "bicsle r0, r1, lsr r3"),
    (b"\x31\x03\xd0\xe1", "bicsal r0, r1, lsr r3"),

    (b"\x61\x02\xd0\x01", "bicseq r0, r1, ror #4"),
    (b"\x61\x02\xd0\x11", "bicsne r0, r1, ror #4"),
    (b"\x61\x02\xd0\x21", "bicscs r0, r1, ror #4"),
    (b"\x61\x02\xd0\x31", "bicscc r0, r1, ror #4"),
    (b"\x61\x02\xd0\x41", "bicsmi r0, r1, ror #4"),
    (b"\x61\x02\xd0\x51", "bicspl r0, r1, ror #4"),
    (b"\x61\x02\xd0\x61", "bicsvs r0, r1, ror #4"),
    (b"\x61\x02\xd0\x71", "bicsvc r0, r1, ror #4"),
    (b"\x61\x02\xd0\x81", "bicshi r0, r1, ror #4"),
    (b"\x61\x02\xd0\x91", "bicsls r0, r1, ror #4"),
    (b"\x61\x02\xd0\xa1", "bicsge r0, r1, ror #4"),
    (b"\x61\x02\xd0\xb1", "bicslt r0, r1, ror #4"),
    (b"\x61\x02\xd0\xc1", "bicsgt r0, r1, ror #4"),
    (b"\x61\x02\xd0\xd1", "bicsle r0, r1, ror #4"),
    (b"\x61\x02\xd0\xe1", "bicsal r0, r1, ror #4"),

    (b"\x71\x03\xd0\x01", "bicseq r0, r1, ror r3"),
    (b"\x71\x03\xd0\x11", "bicsne r0, r1, ror r3"),
    (b"\x71\x03\xd0\x21", "bicscs r0, r1, ror r3"),
    (b"\x71\x03\xd0\x31", "bicscc r0, r1, ror r3"),
    (b"\x71\x03\xd0\x41", "bicsmi r0, r1, ror r3"),
    (b"\x71\x03\xd0\x51", "bicspl r0, r1, ror r3"),
    (b"\x71\x03\xd0\x61", "bicsvs r0, r1, ror r3"),
    (b"\x71\x03\xd0\x71", "bicsvc r0, r1, ror r3"),
    (b"\x71\x03\xd0\x81", "bicshi r0, r1, ror r3"),
    (b"\x71\x03\xd0\x91", "bicsls r0, r1, ror r3"),
    (b"\x71\x03\xd0\xa1", "bicsge r0, r1, ror r3"),
    (b"\x71\x03\xd0\xb1", "bicslt r0, r1, ror r3"),
    (b"\x71\x03\xd0\xc1", "bicsgt r0, r1, ror r3"),
    (b"\x71\x03\xd0\xd1", "bicsle r0, r1, ror r3"),
    (b"\x71\x03\xd0\xe1", "bicsal r0, r1, ror r3"),

    (b"\x61\x00\xd0\x01", "bicseq r0, r1, rrx"),
    (b"\x61\x00\xd0\x11", "bicsne r0, r1, rrx"),
    (b"\x61\x00\xd0\x21", "bicscs r0, r1, rrx"),
    (b"\x61\x00\xd0\x31", "bicscc r0, r1, rrx"),
    (b"\x61\x00\xd0\x41", "bicsmi r0, r1, rrx"),
    (b"\x61\x00\xd0\x51", "bicspl r0, r1, rrx"),
    (b"\x61\x00\xd0\x61", "bicsvs r0, r1, rrx"),
    (b"\x61\x00\xd0\x71", "bicsvc r0, r1, rrx"),
    (b"\x61\x00\xd0\x81", "bicshi r0, r1, rrx"),
    (b"\x61\x00\xd0\x91", "bicsls r0, r1, rrx"),
    (b"\x61\x00\xd0\xa1", "bicsge r0, r1, rrx"),
    (b"\x61\x00\xd0\xb1", "bicslt r0, r1, rrx"),
    (b"\x61\x00\xd0\xc1", "bicsgt r0, r1, rrx"),
    (b"\x61\x00\xd0\xd1", "bicsle r0, r1, rrx"),
    (b"\x61\x00\xd0\xe1", "bicsal r0, r1, rrx"),

    # CLZ -------------------------------------------------------------------- #
    (b"\x11\x0f\x6f\x01", "clzeq r0, r1"),
    (b"\x11\x0f\x6f\x11", "clzne r0, r1"),
    (b"\x11\x0f\x6f\x21", "clzcs r0, r1"),
    (b"\x11\x0f\x6f\x31", "clzcc r0, r1"),
    (b"\x11\x0f\x6f\x41", "clzmi r0, r1"),
    (b"\x11\x0f\x6f\x51", "clzpl r0, r1"),
    (b"\x11\x0f\x6f\x61", "clzvs r0, r1"),
    (b"\x11\x0f\x6f\x71", "clzvc r0, r1"),
    (b"\x11\x0f\x6f\x81", "clzhi r0, r1"),
    (b"\x11\x0f\x6f\x91", "clzls r0, r1"),
    (b"\x11\x0f\x6f\xa1", "clzge r0, r1"),
    (b"\x11\x0f\x6f\xb1", "clzlt r0, r1"),
    (b"\x11\x0f\x6f\xc1", "clzgt r0, r1"),
    (b"\x11\x0f\x6f\xd1", "clzle r0, r1"),
    (b"\x11\x0f\x6f\xe1", "clzal r0, r1"),

    # CMN -------------------------------------------------------------------- #
    (b"\x01\x00\x70\x01", "cmneq r0, r1"),
    (b"\x01\x00\x70\x11", "cmnne r0, r1"),
    (b"\x01\x00\x70\x21", "cmncs r0, r1"),
    (b"\x01\x00\x70\x31", "cmncc r0, r1"),
    (b"\x01\x00\x70\x41", "cmnmi r0, r1"),
    (b"\x01\x00\x70\x51", "cmnpl r0, r1"),
    (b"\x01\x00\x70\x61", "cmnvs r0, r1"),
    (b"\x01\x00\x70\x71", "cmnvc r0, r1"),
    (b"\x01\x00\x70\x81", "cmnhi r0, r1"),
    (b"\x01\x00\x70\x91", "cmnls r0, r1"),
    (b"\x01\x00\x70\xa1", "cmnge r0, r1"),
    (b"\x01\x00\x70\xb1", "cmnlt r0, r1"),
    (b"\x01\x00\x70\xc1", "cmngt r0, r1"),
    (b"\x01\x00\x70\xd1", "cmnle r0, r1"),
    (b"\x01\x00\x70\xe1", "cmnal r0, r1"),
    (b"\x04\x00\x70\x03", "cmneq r0, #4"),
    (b"\x04\x00\x70\x13", "cmnne r0, #4"),
    (b"\x04\x00\x70\x23", "cmncs r0, #4"),
    (b"\x04\x00\x70\x33", "cmncc r0, #4"),
    (b"\x04\x00\x70\x43", "cmnmi r0, #4"),
    (b"\x04\x00\x70\x53", "cmnpl r0, #4"),
    (b"\x04\x00\x70\x63", "cmnvs r0, #4"),
    (b"\x04\x00\x70\x73", "cmnvc r0, #4"),
    (b"\x04\x00\x70\x83", "cmnhi r0, #4"),
    (b"\x04\x00\x70\x93", "cmnls r0, #4"),
    (b"\x04\x00\x70\xa3", "cmnge r0, #4"),
    (b"\x04\x00\x70\xb3", "cmnlt r0, #4"),
    (b"\x04\x00\x70\xc3", "cmngt r0, #4"),
    (b"\x04\x00\x70\xd3", "cmnle r0, #4"),
    (b"\x04\x00\x70\xe3", "cmnal r0, #4"),
    (b"\x41\x02\x70\x01", "cmneq r0, r1, asr #4"),
    (b"\x41\x02\x70\x11", "cmnne r0, r1, asr #4"),
    (b"\x41\x02\x70\x21", "cmncs r0, r1, asr #4"),
    (b"\x41\x02\x70\x31", "cmncc r0, r1, asr #4"),
    (b"\x41\x02\x70\x41", "cmnmi r0, r1, asr #4"),
    (b"\x41\x02\x70\x51", "cmnpl r0, r1, asr #4"),
    (b"\x41\x02\x70\x61", "cmnvs r0, r1, asr #4"),
    (b"\x41\x02\x70\x71", "cmnvc r0, r1, asr #4"),
    (b"\x41\x02\x70\x81", "cmnhi r0, r1, asr #4"),
    (b"\x41\x02\x70\x91", "cmnls r0, r1, asr #4"),
    (b"\x41\x02\x70\xa1", "cmnge r0, r1, asr #4"),
    (b"\x41\x02\x70\xb1", "cmnlt r0, r1, asr #4"),
    (b"\x41\x02\x70\xc1", "cmngt r0, r1, asr #4"),
    (b"\x41\x02\x70\xd1", "cmnle r0, r1, asr #4"),
    (b"\x41\x02\x70\xe1", "cmnal r0, r1, asr #4"),
    (b"\x51\x03\x70\x01", "cmneq r0, r1, asr r3"),
    (b"\x51\x03\x70\x11", "cmnne r0, r1, asr r3"),
    (b"\x51\x03\x70\x21", "cmncs r0, r1, asr r3"),
    (b"\x51\x03\x70\x31", "cmncc r0, r1, asr r3"),
    (b"\x51\x03\x70\x41", "cmnmi r0, r1, asr r3"),
    (b"\x51\x03\x70\x51", "cmnpl r0, r1, asr r3"),
    (b"\x51\x03\x70\x61", "cmnvs r0, r1, asr r3"),
    (b"\x51\x03\x70\x71", "cmnvc r0, r1, asr r3"),
    (b"\x51\x03\x70\x81", "cmnhi r0, r1, asr r3"),
    (b"\x51\x03\x70\x91", "cmnls r0, r1, asr r3"),
    (b"\x51\x03\x70\xa1", "cmnge r0, r1, asr r3"),
    (b"\x51\x03\x70\xb1", "cmnlt r0, r1, asr r3"),
    (b"\x51\x03\x70\xc1", "cmngt r0, r1, asr r3"),
    (b"\x51\x03\x70\xd1", "cmnle r0, r1, asr r3"),
    (b"\x51\x03\x70\xe1", "cmnal r0, r1, asr r3"),
    (b"\x01\x02\x70\x01", "cmneq r0, r1, lsl #4"),
    (b"\x01\x02\x70\x11", "cmnne r0, r1, lsl #4"),
    (b"\x01\x02\x70\x21", "cmncs r0, r1, lsl #4"),
    (b"\x01\x02\x70\x31", "cmncc r0, r1, lsl #4"),
    (b"\x01\x02\x70\x41", "cmnmi r0, r1, lsl #4"),
    (b"\x01\x02\x70\x51", "cmnpl r0, r1, lsl #4"),
    (b"\x01\x02\x70\x61", "cmnvs r0, r1, lsl #4"),
    (b"\x01\x02\x70\x71", "cmnvc r0, r1, lsl #4"),
    (b"\x01\x02\x70\x81", "cmnhi r0, r1, lsl #4"),
    (b"\x01\x02\x70\x91", "cmnls r0, r1, lsl #4"),
    (b"\x01\x02\x70\xa1", "cmnge r0, r1, lsl #4"),
    (b"\x01\x02\x70\xb1", "cmnlt r0, r1, lsl #4"),
    (b"\x01\x02\x70\xc1", "cmngt r0, r1, lsl #4"),
    (b"\x01\x02\x70\xd1", "cmnle r0, r1, lsl #4"),
    (b"\x01\x02\x70\xe1", "cmnal r0, r1, lsl #4"),
    (b"\x11\x03\x70\x01", "cmneq r0, r1, lsl r3"),
    (b"\x11\x03\x70\x11", "cmnne r0, r1, lsl r3"),
    (b"\x11\x03\x70\x21", "cmncs r0, r1, lsl r3"),
    (b"\x11\x03\x70\x31", "cmncc r0, r1, lsl r3"),
    (b"\x11\x03\x70\x41", "cmnmi r0, r1, lsl r3"),
    (b"\x11\x03\x70\x51", "cmnpl r0, r1, lsl r3"),
    (b"\x11\x03\x70\x61", "cmnvs r0, r1, lsl r3"),
    (b"\x11\x03\x70\x71", "cmnvc r0, r1, lsl r3"),
    (b"\x11\x03\x70\x81", "cmnhi r0, r1, lsl r3"),
    (b"\x11\x03\x70\x91", "cmnls r0, r1, lsl r3"),
    (b"\x11\x03\x70\xa1", "cmnge r0, r1, lsl r3"),
    (b"\x11\x03\x70\xb1", "cmnlt r0, r1, lsl r3"),
    (b"\x11\x03\x70\xc1", "cmngt r0, r1, lsl r3"),
    (b"\x11\x03\x70\xd1", "cmnle r0, r1, lsl r3"),
    (b"\x11\x03\x70\xe1", "cmnal r0, r1, lsl r3"),
    (b"\x21\x02\x70\x01", "cmneq r0, r1, lsr #4"),
    (b"\x21\x02\x70\x11", "cmnne r0, r1, lsr #4"),
    (b"\x21\x02\x70\x21", "cmncs r0, r1, lsr #4"),
    (b"\x21\x02\x70\x31", "cmncc r0, r1, lsr #4"),
    (b"\x21\x02\x70\x41", "cmnmi r0, r1, lsr #4"),
    (b"\x21\x02\x70\x51", "cmnpl r0, r1, lsr #4"),
    (b"\x21\x02\x70\x61", "cmnvs r0, r1, lsr #4"),
    (b"\x21\x02\x70\x71", "cmnvc r0, r1, lsr #4"),
    (b"\x21\x02\x70\x81", "cmnhi r0, r1, lsr #4"),
    (b"\x21\x02\x70\x91", "cmnls r0, r1, lsr #4"),
    (b"\x21\x02\x70\xa1", "cmnge r0, r1, lsr #4"),
    (b"\x21\x02\x70\xb1", "cmnlt r0, r1, lsr #4"),
    (b"\x21\x02\x70\xc1", "cmngt r0, r1, lsr #4"),
    (b"\x21\x02\x70\xd1", "cmnle r0, r1, lsr #4"),
    (b"\x21\x02\x70\xe1", "cmnal r0, r1, lsr #4"),
    (b"\x31\x03\x70\x01", "cmneq r0, r1, lsr r3"),
    (b"\x31\x03\x70\x11", "cmnne r0, r1, lsr r3"),
    (b"\x31\x03\x70\x21", "cmncs r0, r1, lsr r3"),
    (b"\x31\x03\x70\x31", "cmncc r0, r1, lsr r3"),
    (b"\x31\x03\x70\x41", "cmnmi r0, r1, lsr r3"),
    (b"\x31\x03\x70\x51", "cmnpl r0, r1, lsr r3"),
    (b"\x31\x03\x70\x61", "cmnvs r0, r1, lsr r3"),
    (b"\x31\x03\x70\x71", "cmnvc r0, r1, lsr r3"),
    (b"\x31\x03\x70\x81", "cmnhi r0, r1, lsr r3"),
    (b"\x31\x03\x70\x91", "cmnls r0, r1, lsr r3"),
    (b"\x31\x03\x70\xa1", "cmnge r0, r1, lsr r3"),
    (b"\x31\x03\x70\xb1", "cmnlt r0, r1, lsr r3"),
    (b"\x31\x03\x70\xc1", "cmngt r0, r1, lsr r3"),
    (b"\x31\x03\x70\xd1", "cmnle r0, r1, lsr r3"),
    (b"\x31\x03\x70\xe1", "cmnal r0, r1, lsr r3"),
    (b"\x61\x02\x70\x01", "cmneq r0, r1, ror #4"),
    (b"\x61\x02\x70\x11", "cmnne r0, r1, ror #4"),
    (b"\x61\x02\x70\x21", "cmncs r0, r1, ror #4"),
    (b"\x61\x02\x70\x31", "cmncc r0, r1, ror #4"),
    (b"\x61\x02\x70\x41", "cmnmi r0, r1, ror #4"),
    (b"\x61\x02\x70\x51", "cmnpl r0, r1, ror #4"),
    (b"\x61\x02\x70\x61", "cmnvs r0, r1, ror #4"),
    (b"\x61\x02\x70\x71", "cmnvc r0, r1, ror #4"),
    (b"\x61\x02\x70\x81", "cmnhi r0, r1, ror #4"),
    (b"\x61\x02\x70\x91", "cmnls r0, r1, ror #4"),
    (b"\x61\x02\x70\xa1", "cmnge r0, r1, ror #4"),
    (b"\x61\x02\x70\xb1", "cmnlt r0, r1, ror #4"),
    (b"\x61\x02\x70\xc1", "cmngt r0, r1, ror #4"),
    (b"\x61\x02\x70\xd1", "cmnle r0, r1, ror #4"),
    (b"\x61\x02\x70\xe1", "cmnal r0, r1, ror #4"),
    (b"\x71\x03\x70\x01", "cmneq r0, r1, ror r3"),
    (b"\x71\x03\x70\x11", "cmnne r0, r1, ror r3"),
    (b"\x71\x03\x70\x21", "cmncs r0, r1, ror r3"),
    (b"\x71\x03\x70\x31", "cmncc r0, r1, ror r3"),
    (b"\x71\x03\x70\x41", "cmnmi r0, r1, ror r3"),
    (b"\x71\x03\x70\x51", "cmnpl r0, r1, ror r3"),
    (b"\x71\x03\x70\x61", "cmnvs r0, r1, ror r3"),
    (b"\x71\x03\x70\x71", "cmnvc r0, r1, ror r3"),
    (b"\x71\x03\x70\x81", "cmnhi r0, r1, ror r3"),
    (b"\x71\x03\x70\x91", "cmnls r0, r1, ror r3"),
    (b"\x71\x03\x70\xa1", "cmnge r0, r1, ror r3"),
    (b"\x71\x03\x70\xb1", "cmnlt r0, r1, ror r3"),
    (b"\x71\x03\x70\xc1", "cmngt r0, r1, ror r3"),
    (b"\x71\x03\x70\xd1", "cmnle r0, r1, ror r3"),
    (b"\x71\x03\x70\xe1", "cmnal r0, r1, ror r3"),
    (b"\x61\x00\x70\x01", "cmneq r0, r1, rrx"),
    (b"\x61\x00\x70\x11", "cmnne r0, r1, rrx"),
    (b"\x61\x00\x70\x21", "cmncs r0, r1, rrx"),
    (b"\x61\x00\x70\x31", "cmncc r0, r1, rrx"),
    (b"\x61\x00\x70\x41", "cmnmi r0, r1, rrx"),
    (b"\x61\x00\x70\x51", "cmnpl r0, r1, rrx"),
    (b"\x61\x00\x70\x61", "cmnvs r0, r1, rrx"),
    (b"\x61\x00\x70\x71", "cmnvc r0, r1, rrx"),
    (b"\x61\x00\x70\x81", "cmnhi r0, r1, rrx"),
    (b"\x61\x00\x70\x91", "cmnls r0, r1, rrx"),
    (b"\x61\x00\x70\xa1", "cmnge r0, r1, rrx"),
    (b"\x61\x00\x70\xb1", "cmnlt r0, r1, rrx"),
    (b"\x61\x00\x70\xc1", "cmngt r0, r1, rrx"),
    (b"\x61\x00\x70\xd1", "cmnle r0, r1, rrx"),
    (b"\x61\x00\x70\xe1", "cmnal r0, r1, rrx"),

    # CMP -------------------------------------------------------------------- #
    (b"\x01\x00\x50\x01", "cmpeq r0, r1"),
    (b"\x01\x00\x50\x11", "cmpne r0, r1"),
    (b"\x01\x00\x50\x21", "cmpcs r0, r1"),
    (b"\x01\x00\x50\x31", "cmpcc r0, r1"),
    (b"\x01\x00\x50\x41", "cmpmi r0, r1"),
    (b"\x01\x00\x50\x51", "cmppl r0, r1"),
    (b"\x01\x00\x50\x61", "cmpvs r0, r1"),
    (b"\x01\x00\x50\x71", "cmpvc r0, r1"),
    (b"\x01\x00\x50\x81", "cmphi r0, r1"),
    (b"\x01\x00\x50\x91", "cmpls r0, r1"),
    (b"\x01\x00\x50\xa1", "cmpge r0, r1"),
    (b"\x01\x00\x50\xb1", "cmplt r0, r1"),
    (b"\x01\x00\x50\xc1", "cmpgt r0, r1"),
    (b"\x01\x00\x50\xd1", "cmple r0, r1"),
    (b"\x01\x00\x50\xe1", "cmpal r0, r1"),

    (b"\x04\x00\x50\x03", "cmpeq r0, #4"),
    (b"\x04\x00\x50\x13", "cmpne r0, #4"),
    (b"\x04\x00\x50\x23", "cmpcs r0, #4"),
    (b"\x04\x00\x50\x33", "cmpcc r0, #4"),
    (b"\x04\x00\x50\x43", "cmpmi r0, #4"),
    (b"\x04\x00\x50\x53", "cmppl r0, #4"),
    (b"\x04\x00\x50\x63", "cmpvs r0, #4"),
    (b"\x04\x00\x50\x73", "cmpvc r0, #4"),
    (b"\x04\x00\x50\x83", "cmphi r0, #4"),
    (b"\x04\x00\x50\x93", "cmpls r0, #4"),
    (b"\x04\x00\x50\xa3", "cmpge r0, #4"),
    (b"\x04\x00\x50\xb3", "cmplt r0, #4"),
    (b"\x04\x00\x50\xc3", "cmpgt r0, #4"),
    (b"\x04\x00\x50\xd3", "cmple r0, #4"),
    (b"\x04\x00\x50\xe3", "cmpal r0, #4"),

    (b"\x41\x02\x50\x01", "cmpeq r0, r1, asr #4"),
    (b"\x41\x02\x50\x11", "cmpne r0, r1, asr #4"),
    (b"\x41\x02\x50\x21", "cmpcs r0, r1, asr #4"),
    (b"\x41\x02\x50\x31", "cmpcc r0, r1, asr #4"),
    (b"\x41\x02\x50\x41", "cmpmi r0, r1, asr #4"),
    (b"\x41\x02\x50\x51", "cmppl r0, r1, asr #4"),
    (b"\x41\x02\x50\x61", "cmpvs r0, r1, asr #4"),
    (b"\x41\x02\x50\x71", "cmpvc r0, r1, asr #4"),
    (b"\x41\x02\x50\x81", "cmphi r0, r1, asr #4"),
    (b"\x41\x02\x50\x91", "cmpls r0, r1, asr #4"),
    (b"\x41\x02\x50\xa1", "cmpge r0, r1, asr #4"),
    (b"\x41\x02\x50\xb1", "cmplt r0, r1, asr #4"),
    (b"\x41\x02\x50\xc1", "cmpgt r0, r1, asr #4"),
    (b"\x41\x02\x50\xd1", "cmple r0, r1, asr #4"),
    (b"\x41\x02\x50\xe1", "cmpal r0, r1, asr #4"),

    (b"\x51\x03\x50\x01", "cmpeq r0, r1, asr r3"),
    (b"\x51\x03\x50\x11", "cmpne r0, r1, asr r3"),
    (b"\x51\x03\x50\x21", "cmpcs r0, r1, asr r3"),
    (b"\x51\x03\x50\x31", "cmpcc r0, r1, asr r3"),
    (b"\x51\x03\x50\x41", "cmpmi r0, r1, asr r3"),
    (b"\x51\x03\x50\x51", "cmppl r0, r1, asr r3"),
    (b"\x51\x03\x50\x61", "cmpvs r0, r1, asr r3"),
    (b"\x51\x03\x50\x71", "cmpvc r0, r1, asr r3"),
    (b"\x51\x03\x50\x81", "cmphi r0, r1, asr r3"),
    (b"\x51\x03\x50\x91", "cmpls r0, r1, asr r3"),
    (b"\x51\x03\x50\xa1", "cmpge r0, r1, asr r3"),
    (b"\x51\x03\x50\xb1", "cmplt r0, r1, asr r3"),
    (b"\x51\x03\x50\xc1", "cmpgt r0, r1, asr r3"),
    (b"\x51\x03\x50\xd1", "cmple r0, r1, asr r3"),
    (b"\x51\x03\x50\xe1", "cmpal r0, r1, asr r3"),

    (b"\x01\x02\x50\x01", "cmpeq r0, r1, lsl #4"),
    (b"\x01\x02\x50\x11", "cmpne r0, r1, lsl #4"),
    (b"\x01\x02\x50\x21", "cmpcs r0, r1, lsl #4"),
    (b"\x01\x02\x50\x31", "cmpcc r0, r1, lsl #4"),
    (b"\x01\x02\x50\x41", "cmpmi r0, r1, lsl #4"),
    (b"\x01\x02\x50\x51", "cmppl r0, r1, lsl #4"),
    (b"\x01\x02\x50\x61", "cmpvs r0, r1, lsl #4"),
    (b"\x01\x02\x50\x71", "cmpvc r0, r1, lsl #4"),
    (b"\x01\x02\x50\x81", "cmphi r0, r1, lsl #4"),
    (b"\x01\x02\x50\x91", "cmpls r0, r1, lsl #4"),
    (b"\x01\x02\x50\xa1", "cmpge r0, r1, lsl #4"),
    (b"\x01\x02\x50\xb1", "cmplt r0, r1, lsl #4"),
    (b"\x01\x02\x50\xc1", "cmpgt r0, r1, lsl #4"),
    (b"\x01\x02\x50\xd1", "cmple r0, r1, lsl #4"),
    (b"\x01\x02\x50\xe1", "cmpal r0, r1, lsl #4"),

    (b"\x11\x03\x50\x01", "cmpeq r0, r1, lsl r3"),
    (b"\x11\x03\x50\x11", "cmpne r0, r1, lsl r3"),
    (b"\x11\x03\x50\x21", "cmpcs r0, r1, lsl r3"),
    (b"\x11\x03\x50\x31", "cmpcc r0, r1, lsl r3"),
    (b"\x11\x03\x50\x41", "cmpmi r0, r1, lsl r3"),
    (b"\x11\x03\x50\x51", "cmppl r0, r1, lsl r3"),
    (b"\x11\x03\x50\x61", "cmpvs r0, r1, lsl r3"),
    (b"\x11\x03\x50\x71", "cmpvc r0, r1, lsl r3"),
    (b"\x11\x03\x50\x81", "cmphi r0, r1, lsl r3"),
    (b"\x11\x03\x50\x91", "cmpls r0, r1, lsl r3"),
    (b"\x11\x03\x50\xa1", "cmpge r0, r1, lsl r3"),
    (b"\x11\x03\x50\xb1", "cmplt r0, r1, lsl r3"),
    (b"\x11\x03\x50\xc1", "cmpgt r0, r1, lsl r3"),
    (b"\x11\x03\x50\xd1", "cmple r0, r1, lsl r3"),
    (b"\x11\x03\x50\xe1", "cmpal r0, r1, lsl r3"),

    (b"\x21\x02\x50\x01", "cmpeq r0, r1, lsr #4"),
    (b"\x21\x02\x50\x11", "cmpne r0, r1, lsr #4"),
    (b"\x21\x02\x50\x21", "cmpcs r0, r1, lsr #4"),
    (b"\x21\x02\x50\x31", "cmpcc r0, r1, lsr #4"),
    (b"\x21\x02\x50\x41", "cmpmi r0, r1, lsr #4"),
    (b"\x21\x02\x50\x51", "cmppl r0, r1, lsr #4"),
    (b"\x21\x02\x50\x61", "cmpvs r0, r1, lsr #4"),
    (b"\x21\x02\x50\x71", "cmpvc r0, r1, lsr #4"),
    (b"\x21\x02\x50\x81", "cmphi r0, r1, lsr #4"),
    (b"\x21\x02\x50\x91", "cmpls r0, r1, lsr #4"),
    (b"\x21\x02\x50\xa1", "cmpge r0, r1, lsr #4"),
    (b"\x21\x02\x50\xb1", "cmplt r0, r1, lsr #4"),
    (b"\x21\x02\x50\xc1", "cmpgt r0, r1, lsr #4"),
    (b"\x21\x02\x50\xd1", "cmple r0, r1, lsr #4"),
    (b"\x21\x02\x50\xe1", "cmpal r0, r1, lsr #4"),

    (b"\x31\x03\x50\x01", "cmpeq r0, r1, lsr r3"),
    (b"\x31\x03\x50\x11", "cmpne r0, r1, lsr r3"),
    (b"\x31\x03\x50\x21", "cmpcs r0, r1, lsr r3"),
    (b"\x31\x03\x50\x31", "cmpcc r0, r1, lsr r3"),
    (b"\x31\x03\x50\x41", "cmpmi r0, r1, lsr r3"),
    (b"\x31\x03\x50\x51", "cmppl r0, r1, lsr r3"),
    (b"\x31\x03\x50\x61", "cmpvs r0, r1, lsr r3"),
    (b"\x31\x03\x50\x71", "cmpvc r0, r1, lsr r3"),
    (b"\x31\x03\x50\x81", "cmphi r0, r1, lsr r3"),
    (b"\x31\x03\x50\x91", "cmpls r0, r1, lsr r3"),
    (b"\x31\x03\x50\xa1", "cmpge r0, r1, lsr r3"),
    (b"\x31\x03\x50\xb1", "cmplt r0, r1, lsr r3"),
    (b"\x31\x03\x50\xc1", "cmpgt r0, r1, lsr r3"),
    (b"\x31\x03\x50\xd1", "cmple r0, r1, lsr r3"),
    (b"\x31\x03\x50\xe1", "cmpal r0, r1, lsr r3"),

    (b"\x61\x02\x50\x01", "cmpeq r0, r1, ror #4"),
    (b"\x61\x02\x50\x11", "cmpne r0, r1, ror #4"),
    (b"\x61\x02\x50\x21", "cmpcs r0, r1, ror #4"),
    (b"\x61\x02\x50\x31", "cmpcc r0, r1, ror #4"),
    (b"\x61\x02\x50\x41", "cmpmi r0, r1, ror #4"),
    (b"\x61\x02\x50\x51", "cmppl r0, r1, ror #4"),
    (b"\x61\x02\x50\x61", "cmpvs r0, r1, ror #4"),
    (b"\x61\x02\x50\x71", "cmpvc r0, r1, ror #4"),
    (b"\x61\x02\x50\x81", "cmphi r0, r1, ror #4"),
    (b"\x61\x02\x50\x91", "cmpls r0, r1, ror #4"),
    (b"\x61\x02\x50\xa1", "cmpge r0, r1, ror #4"),
    (b"\x61\x02\x50\xb1", "cmplt r0, r1, ror #4"),
    (b"\x61\x02\x50\xc1", "cmpgt r0, r1, ror #4"),
    (b"\x61\x02\x50\xd1", "cmple r0, r1, ror #4"),
    (b"\x61\x02\x50\xe1", "cmpal r0, r1, ror #4"),

    (b"\x71\x03\x50\x01", "cmpeq r0, r1, ror r3"),
    (b"\x71\x03\x50\x11", "cmpne r0, r1, ror r3"),
    (b"\x71\x03\x50\x21", "cmpcs r0, r1, ror r3"),
    (b"\x71\x03\x50\x31", "cmpcc r0, r1, ror r3"),
    (b"\x71\x03\x50\x41", "cmpmi r0, r1, ror r3"),
    (b"\x71\x03\x50\x51", "cmppl r0, r1, ror r3"),
    (b"\x71\x03\x50\x61", "cmpvs r0, r1, ror r3"),
    (b"\x71\x03\x50\x71", "cmpvc r0, r1, ror r3"),
    (b"\x71\x03\x50\x81", "cmphi r0, r1, ror r3"),
    (b"\x71\x03\x50\x91", "cmpls r0, r1, ror r3"),
    (b"\x71\x03\x50\xa1", "cmpge r0, r1, ror r3"),
    (b"\x71\x03\x50\xb1", "cmplt r0, r1, ror r3"),
    (b"\x71\x03\x50\xc1", "cmpgt r0, r1, ror r3"),
    (b"\x71\x03\x50\xd1", "cmple r0, r1, ror r3"),
    (b"\x71\x03\x50\xe1", "cmpal r0, r1, ror r3"),

    (b"\x61\x00\x50\x01", "cmpeq r0, r1, rrx"),
    (b"\x61\x00\x50\x11", "cmpne r0, r1, rrx"),
    (b"\x61\x00\x50\x21", "cmpcs r0, r1, rrx"),
    (b"\x61\x00\x50\x31", "cmpcc r0, r1, rrx"),
    (b"\x61\x00\x50\x41", "cmpmi r0, r1, rrx"),
    (b"\x61\x00\x50\x51", "cmppl r0, r1, rrx"),
    (b"\x61\x00\x50\x61", "cmpvs r0, r1, rrx"),
    (b"\x61\x00\x50\x71", "cmpvc r0, r1, rrx"),
    (b"\x61\x00\x50\x81", "cmphi r0, r1, rrx"),
    (b"\x61\x00\x50\x91", "cmpls r0, r1, rrx"),
    (b"\x61\x00\x50\xa1", "cmpge r0, r1, rrx"),
    (b"\x61\x00\x50\xb1", "cmplt r0, r1, rrx"),
    (b"\x61\x00\x50\xc1", "cmpgt r0, r1, rrx"),
    (b"\x61\x00\x50\xd1", "cmple r0, r1, rrx"),
    (b"\x61\x00\x50\xe1", "cmpal r0, r1, rrx"),

    # EOR -------------------------------------------------------------------- #
    (b"\x02\x00\x21\xe2", "eor r0, r1, #2"),
    (b"\x02\x00\x21\x02", "eoreq r0, r1, #2"),
    (b"\x02\x00\x21\x12", "eorne r0, r1, #2"),
    (b"\x02\x00\x21\x22", "eorcs r0, r1, #2"),
    (b"\x02\x00\x21\x32", "eorcc r0, r1, #2"),
    (b"\x02\x00\x21\x42", "eormi r0, r1, #2"),
    (b"\x02\x00\x21\x52", "eorpl r0, r1, #2"),
    (b"\x02\x00\x21\x62", "eorvs r0, r1, #2"),
    (b"\x02\x00\x21\x72", "eorvc r0, r1, #2"),
    (b"\x02\x00\x21\x82", "eorhi r0, r1, #2"),
    (b"\x02\x00\x21\x92", "eorls r0, r1, #2"),
    (b"\x02\x00\x21\xa2", "eorge r0, r1, #2"),
    (b"\x02\x00\x21\xb2", "eorlt r0, r1, #2"),
    (b"\x02\x00\x21\xc2", "eorgt r0, r1, #2"),
    (b"\x02\x00\x21\xd2", "eorle r0, r1, #2"),
    (b"\x02\x00\x21\xe2", "eoral r0, r1, #2"),

    (b"\x03\x00\x21\xe0", "eor r0, r1, r3"),
    (b"\x03\x00\x21\x00", "eoreq r0, r1, r3"),
    (b"\x03\x00\x21\x10", "eorne r0, r1, r3"),
    (b"\x03\x00\x21\x20", "eorcs r0, r1, r3"),
    (b"\x03\x00\x21\x30", "eorcc r0, r1, r3"),
    (b"\x03\x00\x21\x40", "eormi r0, r1, r3"),
    (b"\x03\x00\x21\x50", "eorpl r0, r1, r3"),
    (b"\x03\x00\x21\x60", "eorvs r0, r1, r3"),
    (b"\x03\x00\x21\x70", "eorvc r0, r1, r3"),
    (b"\x03\x00\x21\x80", "eorhi r0, r1, r3"),
    (b"\x03\x00\x21\x90", "eorls r0, r1, r3"),
    (b"\x03\x00\x21\xa0", "eorge r0, r1, r3"),
    (b"\x03\x00\x21\xb0", "eorlt r0, r1, r3"),
    (b"\x03\x00\x21\xc0", "eorgt r0, r1, r3"),
    (b"\x03\x00\x21\xd0", "eorle r0, r1, r3"),
    (b"\x03\x00\x21\xe0", "eoral r0, r1, r3"),

    # EOR(s) ----------------------------------------------------------------- #
    (b"\x02\x00\x31\xe2", "eors r0, r1, #2"),
    (b"\x02\x00\x31\x02", "eorseq r0, r1, #2"),
    (b"\x02\x00\x31\x12", "eorsne r0, r1, #2"),
    (b"\x02\x00\x31\x22", "eorscs r0, r1, #2"),
    (b"\x02\x00\x31\x32", "eorscc r0, r1, #2"),
    (b"\x02\x00\x31\x42", "eorsmi r0, r1, #2"),
    (b"\x02\x00\x31\x52", "eorspl r0, r1, #2"),
    (b"\x02\x00\x31\x62", "eorsvs r0, r1, #2"),
    (b"\x02\x00\x31\x72", "eorsvc r0, r1, #2"),
    (b"\x02\x00\x31\x82", "eorshi r0, r1, #2"),
    (b"\x02\x00\x31\x92", "eorsls r0, r1, #2"),
    (b"\x02\x00\x31\xa2", "eorsge r0, r1, #2"),
    (b"\x02\x00\x31\xb2", "eorslt r0, r1, #2"),
    (b"\x02\x00\x31\xc2", "eorsgt r0, r1, #2"),
    (b"\x02\x00\x31\xd2", "eorsle r0, r1, #2"),
    (b"\x02\x00\x31\xe2", "eorsal r0, r1, #2"),

    (b"\x03\x00\x31\xe0", "eors r0, r1, r3"),
    (b"\x03\x00\x31\x00", "eorseq r0, r1, r3"),
    (b"\x03\x00\x31\x10", "eorsne r0, r1, r3"),
    (b"\x03\x00\x31\x20", "eorscs r0, r1, r3"),
    (b"\x03\x00\x31\x30", "eorscc r0, r1, r3"),
    (b"\x03\x00\x31\x40", "eorsmi r0, r1, r3"),
    (b"\x03\x00\x31\x50", "eorspl r0, r1, r3"),
    (b"\x03\x00\x31\x60", "eorsvs r0, r1, r3"),
    (b"\x03\x00\x31\x70", "eorsvc r0, r1, r3"),
    (b"\x03\x00\x31\x80", "eorshi r0, r1, r3"),
    (b"\x03\x00\x31\x90", "eorsls r0, r1, r3"),
    (b"\x03\x00\x31\xa0", "eorsge r0, r1, r3"),
    (b"\x03\x00\x31\xb0", "eorslt r0, r1, r3"),
    (b"\x03\x00\x31\xc0", "eorsgt r0, r1, r3"),
    (b"\x03\x00\x31\xd0", "eorsle r0, r1, r3"),
    (b"\x03\x00\x31\xe0", "eorsal r0, r1, r3"),

    (b"\x41\x02\x30\x00", "eorseq r0, r1, asr #4"),
    (b"\x41\x02\x30\x10", "eorsne r0, r1, asr #4"),
    (b"\x41\x02\x30\x20", "eorscs r0, r1, asr #4"),
    (b"\x41\x02\x30\x30", "eorscc r0, r1, asr #4"),
    (b"\x41\x02\x30\x40", "eorsmi r0, r1, asr #4"),
    (b"\x41\x02\x30\x50", "eorspl r0, r1, asr #4"),
    (b"\x41\x02\x30\x60", "eorsvs r0, r1, asr #4"),
    (b"\x41\x02\x30\x70", "eorsvc r0, r1, asr #4"),
    (b"\x41\x02\x30\x80", "eorshi r0, r1, asr #4"),
    (b"\x41\x02\x30\x90", "eorsls r0, r1, asr #4"),
    (b"\x41\x02\x30\xa0", "eorsge r0, r1, asr #4"),
    (b"\x41\x02\x30\xb0", "eorslt r0, r1, asr #4"),
    (b"\x41\x02\x30\xc0", "eorsgt r0, r1, asr #4"),
    (b"\x41\x02\x30\xd0", "eorsle r0, r1, asr #4"),
    (b"\x41\x02\x30\xe0", "eorsal r0, r1, asr #4"),

    (b"\x51\x03\x30\x00", "eorseq r0, r1, asr r3"),
    (b"\x51\x03\x30\x10", "eorsne r0, r1, asr r3"),
    (b"\x51\x03\x30\x20", "eorscs r0, r1, asr r3"),
    (b"\x51\x03\x30\x30", "eorscc r0, r1, asr r3"),
    (b"\x51\x03\x30\x40", "eorsmi r0, r1, asr r3"),
    (b"\x51\x03\x30\x50", "eorspl r0, r1, asr r3"),
    (b"\x51\x03\x30\x60", "eorsvs r0, r1, asr r3"),
    (b"\x51\x03\x30\x70", "eorsvc r0, r1, asr r3"),
    (b"\x51\x03\x30\x80", "eorshi r0, r1, asr r3"),
    (b"\x51\x03\x30\x90", "eorsls r0, r1, asr r3"),
    (b"\x51\x03\x30\xa0", "eorsge r0, r1, asr r3"),
    (b"\x51\x03\x30\xb0", "eorslt r0, r1, asr r3"),
    (b"\x51\x03\x30\xc0", "eorsgt r0, r1, asr r3"),
    (b"\x51\x03\x30\xd0", "eorsle r0, r1, asr r3"),
    (b"\x51\x03\x30\xe0", "eorsal r0, r1, asr r3"),

    (b"\x01\x02\x30\x00", "eorseq r0, r1, lsl #4"),
    (b"\x01\x02\x30\x10", "eorsne r0, r1, lsl #4"),
    (b"\x01\x02\x30\x20", "eorscs r0, r1, lsl #4"),
    (b"\x01\x02\x30\x30", "eorscc r0, r1, lsl #4"),
    (b"\x01\x02\x30\x40", "eorsmi r0, r1, lsl #4"),
    (b"\x01\x02\x30\x50", "eorspl r0, r1, lsl #4"),
    (b"\x01\x02\x30\x60", "eorsvs r0, r1, lsl #4"),
    (b"\x01\x02\x30\x70", "eorsvc r0, r1, lsl #4"),
    (b"\x01\x02\x30\x80", "eorshi r0, r1, lsl #4"),
    (b"\x01\x02\x30\x90", "eorsls r0, r1, lsl #4"),
    (b"\x01\x02\x30\xa0", "eorsge r0, r1, lsl #4"),
    (b"\x01\x02\x30\xb0", "eorslt r0, r1, lsl #4"),
    (b"\x01\x02\x30\xc0", "eorsgt r0, r1, lsl #4"),
    (b"\x01\x02\x30\xd0", "eorsle r0, r1, lsl #4"),
    (b"\x01\x02\x30\xe0", "eorsal r0, r1, lsl #4"),

    (b"\x11\x03\x30\x00", "eorseq r0, r1, lsl r3"),
    (b"\x11\x03\x30\x10", "eorsne r0, r1, lsl r3"),
    (b"\x11\x03\x30\x20", "eorscs r0, r1, lsl r3"),
    (b"\x11\x03\x30\x30", "eorscc r0, r1, lsl r3"),
    (b"\x11\x03\x30\x40", "eorsmi r0, r1, lsl r3"),
    (b"\x11\x03\x30\x50", "eorspl r0, r1, lsl r3"),
    (b"\x11\x03\x30\x60", "eorsvs r0, r1, lsl r3"),
    (b"\x11\x03\x30\x70", "eorsvc r0, r1, lsl r3"),
    (b"\x11\x03\x30\x80", "eorshi r0, r1, lsl r3"),
    (b"\x11\x03\x30\x90", "eorsls r0, r1, lsl r3"),
    (b"\x11\x03\x30\xa0", "eorsge r0, r1, lsl r3"),
    (b"\x11\x03\x30\xb0", "eorslt r0, r1, lsl r3"),
    (b"\x11\x03\x30\xc0", "eorsgt r0, r1, lsl r3"),
    (b"\x11\x03\x30\xd0", "eorsle r0, r1, lsl r3"),
    (b"\x11\x03\x30\xe0", "eorsal r0, r1, lsl r3"),

    (b"\x21\x02\x30\x00", "eorseq r0, r1, lsr #4"),
    (b"\x21\x02\x30\x10", "eorsne r0, r1, lsr #4"),
    (b"\x21\x02\x30\x20", "eorscs r0, r1, lsr #4"),
    (b"\x21\x02\x30\x30", "eorscc r0, r1, lsr #4"),
    (b"\x21\x02\x30\x40", "eorsmi r0, r1, lsr #4"),
    (b"\x21\x02\x30\x50", "eorspl r0, r1, lsr #4"),
    (b"\x21\x02\x30\x60", "eorsvs r0, r1, lsr #4"),
    (b"\x21\x02\x30\x70", "eorsvc r0, r1, lsr #4"),
    (b"\x21\x02\x30\x80", "eorshi r0, r1, lsr #4"),
    (b"\x21\x02\x30\x90", "eorsls r0, r1, lsr #4"),
    (b"\x21\x02\x30\xa0", "eorsge r0, r1, lsr #4"),
    (b"\x21\x02\x30\xb0", "eorslt r0, r1, lsr #4"),
    (b"\x21\x02\x30\xc0", "eorsgt r0, r1, lsr #4"),
    (b"\x21\x02\x30\xd0", "eorsle r0, r1, lsr #4"),
    (b"\x21\x02\x30\xe0", "eorsal r0, r1, lsr #4"),

    (b"\x31\x03\x30\x00", "eorseq r0, r1, lsr r3"),
    (b"\x31\x03\x30\x10", "eorsne r0, r1, lsr r3"),
    (b"\x31\x03\x30\x20", "eorscs r0, r1, lsr r3"),
    (b"\x31\x03\x30\x30", "eorscc r0, r1, lsr r3"),
    (b"\x31\x03\x30\x40", "eorsmi r0, r1, lsr r3"),
    (b"\x31\x03\x30\x50", "eorspl r0, r1, lsr r3"),
    (b"\x31\x03\x30\x60", "eorsvs r0, r1, lsr r3"),
    (b"\x31\x03\x30\x70", "eorsvc r0, r1, lsr r3"),
    (b"\x31\x03\x30\x80", "eorshi r0, r1, lsr r3"),
    (b"\x31\x03\x30\x90", "eorsls r0, r1, lsr r3"),
    (b"\x31\x03\x30\xa0", "eorsge r0, r1, lsr r3"),
    (b"\x31\x03\x30\xb0", "eorslt r0, r1, lsr r3"),
    (b"\x31\x03\x30\xc0", "eorsgt r0, r1, lsr r3"),
    (b"\x31\x03\x30\xd0", "eorsle r0, r1, lsr r3"),
    (b"\x31\x03\x30\xe0", "eorsal r0, r1, lsr r3"),

    (b"\x61\x02\x30\x00", "eorseq r0, r1, ror #4"),
    (b"\x61\x02\x30\x10", "eorsne r0, r1, ror #4"),
    (b"\x61\x02\x30\x20", "eorscs r0, r1, ror #4"),
    (b"\x61\x02\x30\x30", "eorscc r0, r1, ror #4"),
    (b"\x61\x02\x30\x40", "eorsmi r0, r1, ror #4"),
    (b"\x61\x02\x30\x50", "eorspl r0, r1, ror #4"),
    (b"\x61\x02\x30\x60", "eorsvs r0, r1, ror #4"),
    (b"\x61\x02\x30\x70", "eorsvc r0, r1, ror #4"),
    (b"\x61\x02\x30\x80", "eorshi r0, r1, ror #4"),
    (b"\x61\x02\x30\x90", "eorsls r0, r1, ror #4"),
    (b"\x61\x02\x30\xa0", "eorsge r0, r1, ror #4"),
    (b"\x61\x02\x30\xb0", "eorslt r0, r1, ror #4"),
    (b"\x61\x02\x30\xc0", "eorsgt r0, r1, ror #4"),
    (b"\x61\x02\x30\xd0", "eorsle r0, r1, ror #4"),
    (b"\x61\x02\x30\xe0", "eorsal r0, r1, ror #4"),

    (b"\x71\x03\x30\x00", "eorseq r0, r1, ror r3"),
    (b"\x71\x03\x30\x10", "eorsne r0, r1, ror r3"),
    (b"\x71\x03\x30\x20", "eorscs r0, r1, ror r3"),
    (b"\x71\x03\x30\x30", "eorscc r0, r1, ror r3"),
    (b"\x71\x03\x30\x40", "eorsmi r0, r1, ror r3"),
    (b"\x71\x03\x30\x50", "eorspl r0, r1, ror r3"),
    (b"\x71\x03\x30\x60", "eorsvs r0, r1, ror r3"),
    (b"\x71\x03\x30\x70", "eorsvc r0, r1, ror r3"),
    (b"\x71\x03\x30\x80", "eorshi r0, r1, ror r3"),
    (b"\x71\x03\x30\x90", "eorsls r0, r1, ror r3"),
    (b"\x71\x03\x30\xa0", "eorsge r0, r1, ror r3"),
    (b"\x71\x03\x30\xb0", "eorslt r0, r1, ror r3"),
    (b"\x71\x03\x30\xc0", "eorsgt r0, r1, ror r3"),
    (b"\x71\x03\x30\xd0", "eorsle r0, r1, ror r3"),
    (b"\x71\x03\x30\xe0", "eorsal r0, r1, ror r3"),

    (b"\x61\x00\x30\x00", "eorseq r0, r1, rrx"),
    (b"\x61\x00\x30\x10", "eorsne r0, r1, rrx"),
    (b"\x61\x00\x30\x20", "eorscs r0, r1, rrx"),
    (b"\x61\x00\x30\x30", "eorscc r0, r1, rrx"),
    (b"\x61\x00\x30\x40", "eorsmi r0, r1, rrx"),
    (b"\x61\x00\x30\x50", "eorspl r0, r1, rrx"),
    (b"\x61\x00\x30\x60", "eorsvs r0, r1, rrx"),
    (b"\x61\x00\x30\x70", "eorsvc r0, r1, rrx"),
    (b"\x61\x00\x30\x80", "eorshi r0, r1, rrx"),
    (b"\x61\x00\x30\x90", "eorsls r0, r1, rrx"),
    (b"\x61\x00\x30\xa0", "eorsge r0, r1, rrx"),
    (b"\x61\x00\x30\xb0", "eorslt r0, r1, rrx"),
    (b"\x61\x00\x30\xc0", "eorsgt r0, r1, rrx"),
    (b"\x61\x00\x30\xd0", "eorsle r0, r1, rrx"),
    (b"\x61\x00\x30\xe0", "eorsal r0, r1, rrx"),

    # LSL -------------------------------------------------------------------- #
    (b"\x01\x01\xa0\xe1", "lsl r0, r1, #2"),
    (b"\x01\x01\xa0\x01", "lsleq r0, r1, #2"),
    (b"\x01\x01\xa0\x11", "lslne r0, r1, #2"),
    (b"\x01\x01\xa0\x21", "lslcs r0, r1, #2"),
    (b"\x01\x01\xa0\x31", "lslcc r0, r1, #2"),
    (b"\x01\x01\xa0\x41", "lslmi r0, r1, #2"),
    (b"\x01\x01\xa0\x51", "lslpl r0, r1, #2"),
    (b"\x01\x01\xa0\x61", "lslvs r0, r1, #2"),
    (b"\x01\x01\xa0\x71", "lslvc r0, r1, #2"),
    (b"\x01\x01\xa0\x81", "lslhi r0, r1, #2"),
    (b"\x01\x01\xa0\x91", "lslls r0, r1, #2"),
    (b"\x01\x01\xa0\xa1", "lslge r0, r1, #2"),
    (b"\x01\x01\xa0\xb1", "lsllt r0, r1, #2"),
    (b"\x01\x01\xa0\xc1", "lslgt r0, r1, #2"),
    (b"\x01\x01\xa0\xd1", "lslle r0, r1, #2"),
    (b"\x01\x01\xa0\xe1", "lslal r0, r1, #2"),

    (b"\x11\x03\xa0\xe1", "lsl r0, r1, r3"),
    (b"\x11\x03\xa0\x01", "lsleq r0, r1, r3"),
    (b"\x11\x03\xa0\x11", "lslne r0, r1, r3"),
    (b"\x11\x03\xa0\x21", "lslcs r0, r1, r3"),
    (b"\x11\x03\xa0\x31", "lslcc r0, r1, r3"),
    (b"\x11\x03\xa0\x41", "lslmi r0, r1, r3"),
    (b"\x11\x03\xa0\x51", "lslpl r0, r1, r3"),
    (b"\x11\x03\xa0\x61", "lslvs r0, r1, r3"),
    (b"\x11\x03\xa0\x71", "lslvc r0, r1, r3"),
    (b"\x11\x03\xa0\x81", "lslhi r0, r1, r3"),
    (b"\x11\x03\xa0\x91", "lslls r0, r1, r3"),
    (b"\x11\x03\xa0\xa1", "lslge r0, r1, r3"),
    (b"\x11\x03\xa0\xb1", "lsllt r0, r1, r3"),
    (b"\x11\x03\xa0\xc1", "lslgt r0, r1, r3"),
    (b"\x11\x03\xa0\xd1", "lslle r0, r1, r3"),

    (b"\x01\x01\xb0\xe1", "lsls r0, r1, #2"),
    (b"\x01\x01\xb0\x01", "lslseq r0, r1, #2"),
    (b"\x01\x01\xb0\x11", "lslsne r0, r1, #2"),
    (b"\x01\x01\xb0\x21", "lslscs r0, r1, #2"),
    (b"\x01\x01\xb0\x31", "lslscc r0, r1, #2"),
    (b"\x01\x01\xb0\x41", "lslsmi r0, r1, #2"),
    (b"\x01\x01\xb0\x51", "lslspl r0, r1, #2"),
    (b"\x01\x01\xb0\x61", "lslsvs r0, r1, #2"),
    (b"\x01\x01\xb0\x71", "lslsvc r0, r1, #2"),
    (b"\x01\x01\xb0\x81", "lslshi r0, r1, #2"),
    (b"\x01\x01\xb0\x91", "lslsls r0, r1, #2"),
    (b"\x01\x01\xb0\xa1", "lslsge r0, r1, #2"),
    (b"\x01\x01\xb0\xb1", "lslslt r0, r1, #2"),
    (b"\x01\x01\xb0\xc1", "lslsgt r0, r1, #2"),
    (b"\x01\x01\xb0\xd1", "lslsle r0, r1, #2"),
    (b"\x01\x01\xb0\xe1", "lslsal r0, r1, #2"),

    (b"\x11\x03\xb0\xe1", "lsls r0, r1, r3"),
    (b"\x11\x03\xb0\x01", "lslseq r0, r1, r3"),
    (b"\x11\x03\xb0\x11", "lslsne r0, r1, r3"),
    (b"\x11\x03\xb0\x21", "lslscs r0, r1, r3"),
    (b"\x11\x03\xb0\x31", "lslscc r0, r1, r3"),
    (b"\x11\x03\xb0\x41", "lslsmi r0, r1, r3"),
    (b"\x11\x03\xb0\x51", "lslspl r0, r1, r3"),
    (b"\x11\x03\xb0\x61", "lslsvs r0, r1, r3"),
    (b"\x11\x03\xb0\x71", "lslsvc r0, r1, r3"),
    (b"\x11\x03\xb0\x81", "lslshi r0, r1, r3"),
    (b"\x11\x03\xb0\x91", "lslsls r0, r1, r3"),
    (b"\x11\x03\xb0\xa1", "lslsge r0, r1, r3"),
    (b"\x11\x03\xb0\xb1", "lslslt r0, r1, r3"),
    (b"\x11\x03\xb0\xc1", "lslsgt r0, r1, r3"),
    (b"\x11\x03\xb0\xd1", "lslsle r0, r1, r3"),
    (b"\x11\x03\xb0\xe1", "lslsal r0, r1, r3"),

    # LSR -------------------------------------------------------------------- #
    (b"\x21\x01\xa0\xe1", "lsr r0, r1, #2"),
    (b"\x21\x01\xa0\x01", "lsreq r0, r1, #2"),
    (b"\x21\x01\xa0\x11", "lsrne r0, r1, #2"),
    (b"\x21\x01\xa0\x21", "lsrcs r0, r1, #2"),
    (b"\x21\x01\xa0\x31", "lsrcc r0, r1, #2"),
    (b"\x21\x01\xa0\x41", "lsrmi r0, r1, #2"),
    (b"\x21\x01\xa0\x51", "lsrpl r0, r1, #2"),
    (b"\x21\x01\xa0\x61", "lsrvs r0, r1, #2"),
    (b"\x21\x01\xa0\x71", "lsrvc r0, r1, #2"),
    (b"\x21\x01\xa0\x81", "lsrhi r0, r1, #2"),
    (b"\x21\x01\xa0\x91", "lsrls r0, r1, #2"),
    (b"\x21\x01\xa0\xa1", "lsrge r0, r1, #2"),
    (b"\x21\x01\xa0\xb1", "lsrlt r0, r1, #2"),
    (b"\x21\x01\xa0\xc1", "lsrgt r0, r1, #2"),
    (b"\x21\x01\xa0\xd1", "lsrle r0, r1, #2"),
    (b"\x21\x01\xa0\xe1", "lsral r0, r1, #2"),

    (b"\x31\x03\xa0\xe1", "lsr r0, r1, r3"),
    (b"\x31\x03\xa0\x01", "lsreq r0, r1, r3"),
    (b"\x31\x03\xa0\x11", "lsrne r0, r1, r3"),
    (b"\x31\x03\xa0\x21", "lsrcs r0, r1, r3"),
    (b"\x31\x03\xa0\x31", "lsrcc r0, r1, r3"),
    (b"\x31\x03\xa0\x41", "lsrmi r0, r1, r3"),
    (b"\x31\x03\xa0\x51", "lsrpl r0, r1, r3"),
    (b"\x31\x03\xa0\x61", "lsrvs r0, r1, r3"),
    (b"\x31\x03\xa0\x71", "lsrvc r0, r1, r3"),
    (b"\x31\x03\xa0\x81", "lsrhi r0, r1, r3"),
    (b"\x31\x03\xa0\x91", "lsrls r0, r1, r3"),
    (b"\x31\x03\xa0\xa1", "lsrge r0, r1, r3"),
    (b"\x31\x03\xa0\xb1", "lsrlt r0, r1, r3"),
    (b"\x31\x03\xa0\xc1", "lsrgt r0, r1, r3"),
    (b"\x31\x03\xa0\xd1", "lsrle r0, r1, r3"),

    (b"\x21\x01\xb0\xe1", "lsrs r0, r1, #2"),
    (b"\x21\x01\xb0\x01", "lsrseq r0, r1, #2"),
    (b"\x21\x01\xb0\x11", "lsrsne r0, r1, #2"),
    (b"\x21\x01\xb0\x21", "lsrscs r0, r1, #2"),
    (b"\x21\x01\xb0\x31", "lsrscc r0, r1, #2"),
    (b"\x21\x01\xb0\x41", "lsrsmi r0, r1, #2"),
    (b"\x21\x01\xb0\x51", "lsrspl r0, r1, #2"),
    (b"\x21\x01\xb0\x61", "lsrsvs r0, r1, #2"),
    (b"\x21\x01\xb0\x71", "lsrsvc r0, r1, #2"),
    (b"\x21\x01\xb0\x81", "lsrshi r0, r1, #2"),
    (b"\x21\x01\xb0\x91", "lsrsls r0, r1, #2"),
    (b"\x21\x01\xb0\xa1", "lsrsge r0, r1, #2"),
    (b"\x21\x01\xb0\xb1", "lsrslt r0, r1, #2"),
    (b"\x21\x01\xb0\xc1", "lsrsgt r0, r1, #2"),
    (b"\x21\x01\xb0\xd1", "lsrsle r0, r1, #2"),
    (b"\x21\x01\xb0\xe1", "lsrsal r0, r1, #2"),

    (b"\x31\x03\xb0\xe1", "lsrs r0, r1, r3"),
    (b"\x31\x03\xb0\x01", "lsrseq r0, r1, r3"),
    (b"\x31\x03\xb0\x11", "lsrsne r0, r1, r3"),
    (b"\x31\x03\xb0\x21", "lsrscs r0, r1, r3"),
    (b"\x31\x03\xb0\x31", "lsrscc r0, r1, r3"),
    (b"\x31\x03\xb0\x41", "lsrsmi r0, r1, r3"),
    (b"\x31\x03\xb0\x51", "lsrspl r0, r1, r3"),
    (b"\x31\x03\xb0\x61", "lsrsvs r0, r1, r3"),
    (b"\x31\x03\xb0\x71", "lsrsvc r0, r1, r3"),
    (b"\x31\x03\xb0\x81", "lsrshi r0, r1, r3"),
    (b"\x31\x03\xb0\x91", "lsrsls r0, r1, r3"),
    (b"\x31\x03\xb0\xa1", "lsrsge r0, r1, r3"),
    (b"\x31\x03\xb0\xb1", "lsrslt r0, r1, r3"),
    (b"\x31\x03\xb0\xc1", "lsrsgt r0, r1, r3"),
    (b"\x31\x03\xb0\xd1", "lsrsle r0, r1, r3"),
    (b"\x31\x03\xb0\xe1", "lsrsal r0, r1, r3"),

    # MLA -------------------------------------------------------------------- #
    (b"\x91\x43\x20\xe0", "mla r0, r1, r3, r4"),
    (b"\x91\x43\x20\x00", "mlaeq r0, r1, r3, r4"),
    (b"\x91\x43\x20\x10", "mlane r0, r1, r3, r4"),
    (b"\x91\x43\x20\x20", "mlacs r0, r1, r3, r4"),
    (b"\x91\x43\x20\x30", "mlacc r0, r1, r3, r4"),
    (b"\x91\x43\x20\x40", "mlami r0, r1, r3, r4"),
    (b"\x91\x43\x20\x50", "mlapl r0, r1, r3, r4"),
    (b"\x91\x43\x20\x60", "mlavs r0, r1, r3, r4"),
    (b"\x91\x43\x20\x70", "mlavc r0, r1, r3, r4"),
    (b"\x91\x43\x20\x80", "mlahi r0, r1, r3, r4"),
    (b"\x91\x43\x20\x90", "mlals r0, r1, r3, r4"),
    (b"\x91\x43\x20\xa0", "mlage r0, r1, r3, r4"),
    (b"\x91\x43\x20\xb0", "mlalt r0, r1, r3, r4"),
    (b"\x91\x43\x20\xc0", "mlagt r0, r1, r3, r4"),
    (b"\x91\x43\x20\xd0", "mlale r0, r1, r3, r4"),
    (b"\x91\x43\x20\xe0", "mlaal r0, r1, r3, r4"),

    (b"\x91\x43\x30\xe0", "mlas r0, r1, r3, r4"),
    (b"\x91\x43\x30\x00", "mlaseq r0, r1, r3, r4"),
    (b"\x91\x43\x30\x10", "mlasne r0, r1, r3, r4"),
    (b"\x91\x43\x30\x20", "mlascs r0, r1, r3, r4"),
    (b"\x91\x43\x30\x30", "mlascc r0, r1, r3, r4"),
    (b"\x91\x43\x30\x40", "mlasmi r0, r1, r3, r4"),
    (b"\x91\x43\x30\x50", "mlaspl r0, r1, r3, r4"),
    (b"\x91\x43\x30\x60", "mlasvs r0, r1, r3, r4"),
    (b"\x91\x43\x30\x70", "mlasvc r0, r1, r3, r4"),
    (b"\x91\x43\x30\x80", "mlashi r0, r1, r3, r4"),
    (b"\x91\x43\x30\x90", "mlasls r0, r1, r3, r4"),
    (b"\x91\x43\x30\xa0", "mlasge r0, r1, r3, r4"),
    (b"\x91\x43\x30\xb0", "mlaslt r0, r1, r3, r4"),
    (b"\x91\x43\x30\xc0", "mlasgt r0, r1, r3, r4"),
    (b"\x91\x43\x30\xd0", "mlasle r0, r1, r3, r4"),
    (b"\x91\x43\x30\xe0", "mlasal r0, r1, r3, r4"),

    # MLS -------------------------------------------------------------------- #
    (b"\x91\x43\x60\xe0", "mls r0, r1, r3, r4"),
    (b"\x91\x43\x60\x00", "mlseq r0, r1, r3, r4"),
    (b"\x91\x43\x60\x10", "mlsne r0, r1, r3, r4"),
    (b"\x91\x43\x60\x20", "mlscs r0, r1, r3, r4"),
    (b"\x91\x43\x60\x30", "mlscc r0, r1, r3, r4"),
    (b"\x91\x43\x60\x40", "mlsmi r0, r1, r3, r4"),
    (b"\x91\x43\x60\x50", "mlspl r0, r1, r3, r4"),
    (b"\x91\x43\x60\x60", "mlsvs r0, r1, r3, r4"),
    (b"\x91\x43\x60\x70", "mlsvc r0, r1, r3, r4"),
    (b"\x91\x43\x60\x80", "mlshi r0, r1, r3, r4"),
    (b"\x91\x43\x60\x90", "mlsls r0, r1, r3, r4"),
    (b"\x91\x43\x60\xa0", "mlsge r0, r1, r3, r4"),
    (b"\x91\x43\x60\xb0", "mlslt r0, r1, r3, r4"),
    (b"\x91\x43\x60\xc0", "mlsgt r0, r1, r3, r4"),
    (b"\x91\x43\x60\xd0", "mlsle r0, r1, r3, r4"),
    (b"\x91\x43\x60\xe0", "mlsal r0, r1, r3, r4"),

    # NOTE: MOV (shifted register) is a pseudo-instruction for ASR, LSL, LSR,
    # ROR, and RRX.
    # MOV -------------------------------------------------------------------- #
    (b"\x02\x00\xa0\xe3", "mov r0, #2"),
    (b"\x02\x00\xa0\x03", "moveq r0, #2"),
    (b"\x02\x00\xa0\x13", "movne r0, #2"),
    (b"\x02\x00\xa0\x23", "movcs r0, #2"),
    (b"\x02\x00\xa0\x33", "movcc r0, #2"),
    (b"\x02\x00\xa0\x43", "movmi r0, #2"),
    (b"\x02\x00\xa0\x53", "movpl r0, #2"),
    (b"\x02\x00\xa0\x63", "movvs r0, #2"),
    (b"\x02\x00\xa0\x73", "movvc r0, #2"),
    (b"\x02\x00\xa0\x83", "movhi r0, #2"),
    (b"\x02\x00\xa0\x93", "movls r0, #2"),
    (b"\x02\x00\xa0\xa3", "movge r0, #2"),
    (b"\x02\x00\xa0\xb3", "movlt r0, #2"),
    (b"\x02\x00\xa0\xc3", "movgt r0, #2"),
    (b"\x02\x00\xa0\xd3", "movle r0, #2"),
    (b"\x02\x00\xa0\xe3", "moval r0, #2"),

    (b"\x03\x00\xa0\xe1", "mov r0, r3"),
    (b"\x03\x00\xa0\x01", "moveq r0, r3"),
    (b"\x03\x00\xa0\x11", "movne r0, r3"),
    (b"\x03\x00\xa0\x21", "movcs r0, r3"),
    (b"\x03\x00\xa0\x31", "movcc r0, r3"),
    (b"\x03\x00\xa0\x41", "movmi r0, r3"),
    (b"\x03\x00\xa0\x51", "movpl r0, r3"),
    (b"\x03\x00\xa0\x61", "movvs r0, r3"),
    (b"\x03\x00\xa0\x71", "movvc r0, r3"),
    (b"\x03\x00\xa0\x81", "movhi r0, r3"),
    (b"\x03\x00\xa0\x91", "movls r0, r3"),
    (b"\x03\x00\xa0\xa1", "movge r0, r3"),
    (b"\x03\x00\xa0\xb1", "movlt r0, r3"),
    (b"\x03\x00\xa0\xc1", "movgt r0, r3"),
    (b"\x03\x00\xa0\xd1", "movle r0, r3"),
    (b"\x03\x00\xa0\xe1", "moval r0, r3"),

    (b"\x02\x00\xb0\xe3", "movs r0, #2"),
    (b"\x02\x00\xb0\x03", "movseq r0, #2"),
    (b"\x02\x00\xb0\x13", "movsne r0, #2"),
    (b"\x02\x00\xb0\x23", "movscs r0, #2"),
    (b"\x02\x00\xb0\x33", "movscc r0, #2"),
    (b"\x02\x00\xb0\x43", "movsmi r0, #2"),
    (b"\x02\x00\xb0\x53", "movspl r0, #2"),
    (b"\x02\x00\xb0\x63", "movsvs r0, #2"),
    (b"\x02\x00\xb0\x73", "movsvc r0, #2"),
    (b"\x02\x00\xb0\x83", "movshi r0, #2"),
    (b"\x02\x00\xb0\x93", "movsls r0, #2"),
    (b"\x02\x00\xb0\xa3", "movsge r0, #2"),
    (b"\x02\x00\xb0\xb3", "movslt r0, #2"),
    (b"\x02\x00\xb0\xc3", "movsgt r0, #2"),
    (b"\x02\x00\xb0\xd3", "movsle r0, #2"),
    (b"\x02\x00\xb0\xe3", "movsal r0, #2"),

    (b"\x03\x00\xb0\xe1", "movs r0, r3"),
    (b"\x03\x00\xb0\x01", "movseq r0, r3"),
    (b"\x03\x00\xb0\x11", "movsne r0, r3"),
    (b"\x03\x00\xb0\x21", "movscs r0, r3"),
    (b"\x03\x00\xb0\x31", "movscc r0, r3"),
    (b"\x03\x00\xb0\x41", "movsmi r0, r3"),
    (b"\x03\x00\xb0\x51", "movspl r0, r3"),
    (b"\x03\x00\xb0\x61", "movsvs r0, r3"),
    (b"\x03\x00\xb0\x71", "movsvc r0, r3"),
    (b"\x03\x00\xb0\x81", "movshi r0, r3"),
    (b"\x03\x00\xb0\x91", "movsls r0, r3"),
    (b"\x03\x00\xb0\xa1", "movsge r0, r3"),
    (b"\x03\x00\xb0\xb1", "movslt r0, r3"),
    (b"\x03\x00\xb0\xc1", "movsgt r0, r3"),
    (b"\x03\x00\xb0\xd1", "movsle r0, r3"),
    (b"\x03\x00\xb0\xe1", "movsal r0, r3"),

    # MOV(S) with SP as operand ---------------------------------------------- #
    (b"\x02\xd0\xa0\xe3", "mov sp, #2"),
    (b"\x02\xd0\xa0\x03", "moveq sp, #2"),
    (b"\x02\xd0\xa0\x13", "movne sp, #2"),
    (b"\x02\xd0\xa0\x23", "movcs sp, #2"),
    (b"\x02\xd0\xa0\x33", "movcc sp, #2"),
    (b"\x02\xd0\xa0\x43", "movmi sp, #2"),
    (b"\x02\xd0\xa0\x53", "movpl sp, #2"),
    (b"\x02\xd0\xa0\x63", "movvs sp, #2"),
    (b"\x02\xd0\xa0\x73", "movvc sp, #2"),
    (b"\x02\xd0\xa0\x83", "movhi sp, #2"),
    (b"\x02\xd0\xa0\x93", "movls sp, #2"),
    (b"\x02\xd0\xa0\xa3", "movge sp, #2"),
    (b"\x02\xd0\xa0\xb3", "movlt sp, #2"),
    (b"\x02\xd0\xa0\xc3", "movgt sp, #2"),
    (b"\x02\xd0\xa0\xd3", "movle sp, #2"),
    (b"\x02\xd0\xa0\xe3", "moval sp, #2"),

    (b"\x03\xd0\xa0\xe1", "mov sp, r3"),
    (b"\x03\xd0\xa0\x01", "moveq sp, r3"),
    (b"\x03\xd0\xa0\x11", "movne sp, r3"),
    (b"\x03\xd0\xa0\x21", "movcs sp, r3"),
    (b"\x03\xd0\xa0\x31", "movcc sp, r3"),
    (b"\x03\xd0\xa0\x41", "movmi sp, r3"),
    (b"\x03\xd0\xa0\x51", "movpl sp, r3"),
    (b"\x03\xd0\xa0\x61", "movvs sp, r3"),
    (b"\x03\xd0\xa0\x71", "movvc sp, r3"),
    (b"\x03\xd0\xa0\x81", "movhi sp, r3"),
    (b"\x03\xd0\xa0\x91", "movls sp, r3"),
    (b"\x03\xd0\xa0\xa1", "movge sp, r3"),
    (b"\x03\xd0\xa0\xb1", "movlt sp, r3"),
    (b"\x03\xd0\xa0\xc1", "movgt sp, r3"),
    (b"\x03\xd0\xa0\xd1", "movle sp, r3"),
    (b"\x03\xd0\xa0\xe1", "moval sp, r3"),

    (b"\x02\xd0\xb0\xe3", "movs sp, #2"),
    (b"\x02\xd0\xb0\x03", "movseq sp, #2"),
    (b"\x02\xd0\xb0\x13", "movsne sp, #2"),
    (b"\x02\xd0\xb0\x23", "movscs sp, #2"),
    (b"\x02\xd0\xb0\x33", "movscc sp, #2"),
    (b"\x02\xd0\xb0\x43", "movsmi sp, #2"),
    (b"\x02\xd0\xb0\x53", "movspl sp, #2"),
    (b"\x02\xd0\xb0\x63", "movsvs sp, #2"),
    (b"\x02\xd0\xb0\x73", "movsvc sp, #2"),
    (b"\x02\xd0\xb0\x83", "movshi sp, #2"),
    (b"\x02\xd0\xb0\x93", "movsls sp, #2"),
    (b"\x02\xd0\xb0\xa3", "movsge sp, #2"),
    (b"\x02\xd0\xb0\xb3", "movslt sp, #2"),
    (b"\x02\xd0\xb0\xc3", "movsgt sp, #2"),
    (b"\x02\xd0\xb0\xd3", "movsle sp, #2"),
    (b"\x02\xd0\xb0\xe3", "movsal sp, #2"),

    (b"\x03\xd0\xb0\xe1", "movs sp, r3"),
    (b"\x03\xd0\xb0\x01", "movseq sp, r3"),
    (b"\x03\xd0\xb0\x11", "movsne sp, r3"),
    (b"\x03\xd0\xb0\x21", "movscs sp, r3"),
    (b"\x03\xd0\xb0\x31", "movscc sp, r3"),
    (b"\x03\xd0\xb0\x41", "movsmi sp, r3"),
    (b"\x03\xd0\xb0\x51", "movspl sp, r3"),
    (b"\x03\xd0\xb0\x61", "movsvs sp, r3"),
    (b"\x03\xd0\xb0\x71", "movsvc sp, r3"),
    (b"\x03\xd0\xb0\x81", "movshi sp, r3"),
    (b"\x03\xd0\xb0\x91", "movsls sp, r3"),
    (b"\x03\xd0\xb0\xa1", "movsge sp, r3"),
    (b"\x03\xd0\xb0\xb1", "movslt sp, r3"),
    (b"\x03\xd0\xb0\xc1", "movsgt sp, r3"),
    (b"\x03\xd0\xb0\xd1", "movsle sp, r3"),
    (b"\x03\xd0\xb0\xe1", "movsal sp, r3"),

    # MOVT -------------------------------------------------------------------- #
    (b"\x38\x01\x42\x03", "movteq r0, #0x2138"),
    (b"\x38\x01\x42\x13", "movtne r0, #0x2138"),
    (b"\x38\x01\x42\x23", "movtcs r0, #0x2138"),
    (b"\x38\x01\x42\x33", "movtcc r0, #0x2138"),
    (b"\x38\x01\x42\x43", "movtmi r0, #0x2138"),
    (b"\x38\x01\x42\x53", "movtpl r0, #0x2138"),
    (b"\x38\x01\x42\x63", "movtvs r0, #0x2138"),
    (b"\x38\x01\x42\x73", "movtvc r0, #0x2138"),
    (b"\x38\x01\x42\x83", "movthi r0, #0x2138"),
    (b"\x38\x01\x42\x93", "movtls r0, #0x2138"),
    (b"\x38\x01\x42\xa3", "movtge r0, #0x2138"),
    (b"\x38\x01\x42\xb3", "movtlt r0, #0x2138"),
    (b"\x38\x01\x42\xc3", "movtgt r0, #0x2138"),
    (b"\x38\x01\x42\xd3", "movtle r0, #0x2138"),
    (b"\x38\x01\x42\xe3", "movtal r0, #0x2138"),
    (b"\x38\x10\x40\x03", "movteq r1, #0x338"),
    (b"\x38\x10\x40\x13", "movtne r1, #0x338"),
    (b"\x38\x10\x40\x23", "movtcs r1, #0x338"),
    (b"\x38\x10\x40\x33", "movtcc r1, #0x338"),
    (b"\x38\x10\x40\x43", "movtmi r1, #0x338"),
    (b"\x38\x10\x40\x53", "movtpl r1, #0x338"),
    (b"\x38\x10\x40\x63", "movtvs r1, #0x338"),
    (b"\x38\x10\x40\x73", "movtvc r1, #0x338"),
    (b"\x38\x10\x40\x83", "movthi r1, #0x338"),
    (b"\x38\x10\x40\x93", "movtls r1, #0x338"),
    (b"\x38\x10\x40\xa3", "movtge r1, #0x338"),
    (b"\x38\x10\x40\xb3", "movtlt r1, #0x338"),
    (b"\x38\x10\x40\xc3", "movtgt r1, #0x338"),
    (b"\x38\x10\x40\xd3", "movtle r1, #0x338"),
    (b"\x38\x10\x40\xe3", "movtal r1, #0x338"),
    (b"\x38\x10\x40\x03", "movteq r1, #0x3"),
    (b"\x38\x10\x40\x13", "movtne r1, #0x3"),
    (b"\x38\x10\x40\x23", "movtcs r1, #0x3"),
    (b"\x38\x10\x40\x33", "movtcc r1, #0x3"),
    (b"\x38\x10\x40\x43", "movtmi r1, #0x3"),
    (b"\x38\x10\x40\x53", "movtpl r1, #0x3"),
    (b"\x38\x10\x40\x63", "movtvs r1, #0x3"),
    (b"\x38\x10\x40\x73", "movtvc r1, #0x3"),
    (b"\x38\x10\x40\x83", "movthi r1, #0x3"),
    (b"\x38\x10\x40\x93", "movtls r1, #0x3"),
    (b"\x38\x10\x40\xa3", "movtge r1, #0x3"),
    (b"\x38\x10\x40\xb3", "movtlt r1, #0x3"),
    (b"\x38\x10\x40\xc3", "movtgt r1, #0x3"),
    (b"\x38\x10\x40\xd3", "movtle r1, #0x3"),
    (b"\x38\x10\x40\xe3", "movtal r1, #0x3"),

    # MUL -------------------------------------------------------------------- #
    (b"\x91\x03\x00\xe0", "mul r0, r1, r3"),
    (b"\x91\x03\x00\x00", "muleq r0, r1, r3"),
    (b"\x91\x03\x00\x10", "mulne r0, r1, r3"),
    (b"\x91\x03\x00\x20", "mulcs r0, r1, r3"),
    (b"\x91\x03\x00\x30", "mulcc r0, r1, r3"),
    (b"\x91\x03\x00\x40", "mulmi r0, r1, r3"),
    (b"\x91\x03\x00\x50", "mulpl r0, r1, r3"),
    (b"\x91\x03\x00\x60", "mulvs r0, r1, r3"),
    (b"\x91\x03\x00\x70", "mulvc r0, r1, r3"),
    (b"\x91\x03\x00\x80", "mulhi r0, r1, r3"),
    (b"\x91\x03\x00\x90", "mulls r0, r1, r3"),
    (b"\x91\x03\x00\xa0", "mulge r0, r1, r3"),
    (b"\x91\x03\x00\xb0", "mullt r0, r1, r3"),
    (b"\x91\x03\x00\xc0", "mulgt r0, r1, r3"),
    (b"\x91\x03\x00\xd0", "mulle r0, r1, r3"),
    (b"\x91\x03\x00\xe0", "mulal r0, r1, r3"),

    (b"\x91\x03\x10\xe0", "muls r0, r1, r3"),
    (b"\x91\x03\x10\x00", "mulseq r0, r1, r3"),
    (b"\x91\x03\x10\x10", "mulsne r0, r1, r3"),
    (b"\x91\x03\x10\x20", "mulscs r0, r1, r3"),
    (b"\x91\x03\x10\x30", "mulscc r0, r1, r3"),
    (b"\x91\x03\x10\x40", "mulsmi r0, r1, r3"),
    (b"\x91\x03\x10\x50", "mulspl r0, r1, r3"),
    (b"\x91\x03\x10\x60", "mulsvs r0, r1, r3"),
    (b"\x91\x03\x10\x70", "mulsvc r0, r1, r3"),
    (b"\x91\x03\x10\x80", "mulshi r0, r1, r3"),
    (b"\x91\x03\x10\x90", "mulsls r0, r1, r3"),
    (b"\x91\x03\x10\xa0", "mulsge r0, r1, r3"),
    (b"\x91\x03\x10\xb0", "mulslt r0, r1, r3"),
    (b"\x91\x03\x10\xc0", "mulsgt r0, r1, r3"),
    (b"\x91\x03\x10\xd0", "mulsle r0, r1, r3"),
    (b"\x91\x03\x10\xe0", "mulsal r0, r1, r3"),

    # MVN -------------------------------------------------------------------- #
    (b"\x02\x00\xe0\xe3", "mvn r0, #2"),
    (b"\x02\x00\xe0\x03", "mvneq r0, #2"),
    (b"\x02\x00\xe0\x13", "mvnne r0, #2"),
    (b"\x02\x00\xe0\x23", "mvncs r0, #2"),
    (b"\x02\x00\xe0\x33", "mvncc r0, #2"),
    (b"\x02\x00\xe0\x43", "mvnmi r0, #2"),
    (b"\x02\x00\xe0\x53", "mvnpl r0, #2"),
    (b"\x02\x00\xe0\x63", "mvnvs r0, #2"),
    (b"\x02\x00\xe0\x73", "mvnvc r0, #2"),
    (b"\x02\x00\xe0\x83", "mvnhi r0, #2"),
    (b"\x02\x00\xe0\x93", "mvnls r0, #2"),
    (b"\x02\x00\xe0\xa3", "mvnge r0, #2"),
    (b"\x02\x00\xe0\xb3", "mvnlt r0, #2"),
    (b"\x02\x00\xe0\xc3", "mvngt r0, #2"),
    (b"\x02\x00\xe0\xd3", "mvnle r0, #2"),
    (b"\x02\x00\xe0\xe3", "mvnal r0, #2"),

    (b"\x03\x00\xe0\xe1", "mvn r0, r3"),
    (b"\x03\x00\xe0\x01", "mvneq r0, r3"),
    (b"\x03\x00\xe0\x11", "mvnne r0, r3"),
    (b"\x03\x00\xe0\x21", "mvncs r0, r3"),
    (b"\x03\x00\xe0\x31", "mvncc r0, r3"),
    (b"\x03\x00\xe0\x41", "mvnmi r0, r3"),
    (b"\x03\x00\xe0\x51", "mvnpl r0, r3"),
    (b"\x03\x00\xe0\x61", "mvnvs r0, r3"),
    (b"\x03\x00\xe0\x71", "mvnvc r0, r3"),
    (b"\x03\x00\xe0\x81", "mvnhi r0, r3"),
    (b"\x03\x00\xe0\x91", "mvnls r0, r3"),
    (b"\x03\x00\xe0\xa1", "mvnge r0, r3"),
    (b"\x03\x00\xe0\xb1", "mvnlt r0, r3"),
    (b"\x03\x00\xe0\xc1", "mvngt r0, r3"),
    (b"\x03\x00\xe0\xd1", "mvnle r0, r3"),
    (b"\x03\x00\xe0\xe1", "mvnal r0, r3"),

    # MVNS ------------------------------------------------------------------- #
    (b"\x02\x00\xf0\xe3", "mvns r0, #2"),
    (b"\x02\x00\xf0\x03", "mvnseq r0, #2"),
    (b"\x02\x00\xf0\x13", "mvnsne r0, #2"),
    (b"\x02\x00\xf0\x23", "mvnscs r0, #2"),
    (b"\x02\x00\xf0\x33", "mvnscc r0, #2"),
    (b"\x02\x00\xf0\x43", "mvnsmi r0, #2"),
    (b"\x02\x00\xf0\x53", "mvnspl r0, #2"),
    (b"\x02\x00\xf0\x63", "mvnsvs r0, #2"),
    (b"\x02\x00\xf0\x73", "mvnsvc r0, #2"),
    (b"\x02\x00\xf0\x83", "mvnshi r0, #2"),
    (b"\x02\x00\xf0\x93", "mvnsls r0, #2"),
    (b"\x02\x00\xf0\xa3", "mvnsge r0, #2"),
    (b"\x02\x00\xf0\xb3", "mvnslt r0, #2"),
    (b"\x02\x00\xf0\xc3", "mvnsgt r0, #2"),
    (b"\x02\x00\xf0\xd3", "mvnsle r0, #2"),
    (b"\x02\x00\xf0\xe3", "mvnsal r0, #2"),

    (b"\x03\x00\xf0\xe1", "mvns r0, r3"),
    (b"\x03\x00\xf0\x01", "mvnseq r0, r3"),
    (b"\x03\x00\xf0\x11", "mvnsne r0, r3"),
    (b"\x03\x00\xf0\x21", "mvnscs r0, r3"),
    (b"\x03\x00\xf0\x31", "mvnscc r0, r3"),
    (b"\x03\x00\xf0\x41", "mvnsmi r0, r3"),
    (b"\x03\x00\xf0\x51", "mvnspl r0, r3"),
    (b"\x03\x00\xf0\x61", "mvnsvs r0, r3"),
    (b"\x03\x00\xf0\x71", "mvnsvc r0, r3"),
    (b"\x03\x00\xf0\x81", "mvnshi r0, r3"),
    (b"\x03\x00\xf0\x91", "mvnsls r0, r3"),
    (b"\x03\x00\xf0\xa1", "mvnsge r0, r3"),
    (b"\x03\x00\xf0\xb1", "mvnslt r0, r3"),
    (b"\x03\x00\xf0\xc1", "mvnsgt r0, r3"),
    (b"\x03\x00\xf0\xd1", "mvnsle r0, r3"),
    (b"\x03\x00\xf0\xe1", "mvnsal r0, r3"),

    (b"\x02\x00\xe0\xe3", "mvn r0, #2"),
    (b"\x02\x00\xe0\x03", "mvneq r0, #2"),
    (b"\x02\x00\xe0\x13", "mvnne r0, #2"),
    (b"\x02\x00\xe0\x23", "mvncs r0, #2"),
    (b"\x02\x00\xe0\x33", "mvncc r0, #2"),
    (b"\x02\x00\xe0\x43", "mvnmi r0, #2"),
    (b"\x02\x00\xe0\x53", "mvnpl r0, #2"),
    (b"\x02\x00\xe0\x63", "mvnvs r0, #2"),
    (b"\x02\x00\xe0\x73", "mvnvc r0, #2"),
    (b"\x02\x00\xe0\x83", "mvnhi r0, #2"),
    (b"\x02\x00\xe0\x93", "mvnls r0, #2"),
    (b"\x02\x00\xe0\xa3", "mvnge r0, #2"),
    (b"\x02\x00\xe0\xb3", "mvnlt r0, #2"),
    (b"\x02\x00\xe0\xc3", "mvngt r0, #2"),
    (b"\x02\x00\xe0\xd3", "mvnle r0, #2"),
    (b"\x02\x00\xe0\xe3", "mvnal r0, #2"),

    (b"\x01\x00\xe0\xe1", "mvn r0, r1"),
    (b"\x01\x00\xe0\x01", "mvneq r0, r1"),
    (b"\x01\x00\xe0\x11", "mvnne r0, r1"),
    (b"\x01\x00\xe0\x21", "mvncs r0, r1"),
    (b"\x01\x00\xe0\x31", "mvncc r0, r1"),
    (b"\x01\x00\xe0\x41", "mvnmi r0, r1"),
    (b"\x01\x00\xe0\x51", "mvnpl r0, r1"),
    (b"\x01\x00\xe0\x61", "mvnvs r0, r1"),
    (b"\x01\x00\xe0\x71", "mvnvc r0, r1"),
    (b"\x01\x00\xe0\x81", "mvnhi r0, r1"),
    (b"\x01\x00\xe0\x91", "mvnls r0, r1"),
    (b"\x01\x00\xe0\xa1", "mvnge r0, r1"),
    (b"\x01\x00\xe0\xb1", "mvnlt r0, r1"),
    (b"\x01\x00\xe0\xc1", "mvngt r0, r1"),
    (b"\x01\x00\xe0\xd1", "mvnle r0, r1"),
    (b"\x01\x00\xe0\xe1", "mvnal r0, r1"),

    (b"\x02\x00\xf0\xe3", "mvns r0, #2"),
    (b"\x02\x00\xf0\x03", "mvnseq r0, #2"),
    (b"\x02\x00\xf0\x13", "mvnsne r0, #2"),
    (b"\x02\x00\xf0\x23", "mvnscs r0, #2"),
    (b"\x02\x00\xf0\x33", "mvnscc r0, #2"),
    (b"\x02\x00\xf0\x43", "mvnsmi r0, #2"),
    (b"\x02\x00\xf0\x53", "mvnspl r0, #2"),
    (b"\x02\x00\xf0\x63", "mvnsvs r0, #2"),
    (b"\x02\x00\xf0\x73", "mvnsvc r0, #2"),
    (b"\x02\x00\xf0\x83", "mvnshi r0, #2"),
    (b"\x02\x00\xf0\x93", "mvnsls r0, #2"),
    (b"\x02\x00\xf0\xa3", "mvnsge r0, #2"),
    (b"\x02\x00\xf0\xb3", "mvnslt r0, #2"),
    (b"\x02\x00\xf0\xc3", "mvnsgt r0, #2"),
    (b"\x02\x00\xf0\xd3", "mvnsle r0, #2"),
    (b"\x02\x00\xf0\xe3", "mvnsal r0, #2"),

    (b"\x01\x00\xf0\xe1", "mvns r0, r1"),
    (b"\x01\x00\xf0\x01", "mvnseq r0, r1"),
    (b"\x01\x00\xf0\x11", "mvnsne r0, r1"),
    (b"\x01\x00\xf0\x21", "mvnscs r0, r1"),
    (b"\x01\x00\xf0\x31", "mvnscc r0, r1"),
    (b"\x01\x00\xf0\x41", "mvnsmi r0, r1"),
    (b"\x01\x00\xf0\x51", "mvnspl r0, r1"),
    (b"\x01\x00\xf0\x61", "mvnsvs r0, r1"),
    (b"\x01\x00\xf0\x71", "mvnsvc r0, r1"),
    (b"\x01\x00\xf0\x81", "mvnshi r0, r1"),
    (b"\x01\x00\xf0\x91", "mvnsls r0, r1"),
    (b"\x01\x00\xf0\xa1", "mvnsge r0, r1"),
    (b"\x01\x00\xf0\xb1", "mvnslt r0, r1"),
    (b"\x01\x00\xf0\xc1", "mvnsgt r0, r1"),
    (b"\x01\x00\xf0\xd1", "mvnsle r0, r1"),
    (b"\x01\x00\xf0\xe1", "mvnsal r0, r1"),

    (b"\x41\x02\xf0\x01", "mvnseq r0, r1, asr #4"),
    (b"\x41\x02\xf0\x11", "mvnsne r0, r1, asr #4"),
    (b"\x41\x02\xf0\x21", "mvnscs r0, r1, asr #4"),
    (b"\x41\x02\xf0\x31", "mvnscc r0, r1, asr #4"),
    (b"\x41\x02\xf0\x41", "mvnsmi r0, r1, asr #4"),
    (b"\x41\x02\xf0\x51", "mvnspl r0, r1, asr #4"),
    (b"\x41\x02\xf0\x61", "mvnsvs r0, r1, asr #4"),
    (b"\x41\x02\xf0\x71", "mvnsvc r0, r1, asr #4"),
    (b"\x41\x02\xf0\x81", "mvnshi r0, r1, asr #4"),
    (b"\x41\x02\xf0\x91", "mvnsls r0, r1, asr #4"),
    (b"\x41\x02\xf0\xa1", "mvnsge r0, r1, asr #4"),
    (b"\x41\x02\xf0\xb1", "mvnslt r0, r1, asr #4"),
    (b"\x41\x02\xf0\xc1", "mvnsgt r0, r1, asr #4"),
    (b"\x41\x02\xf0\xd1", "mvnsle r0, r1, asr #4"),
    (b"\x41\x02\xf0\xe1", "mvnsal r0, r1, asr #4"),

    (b"\x51\x03\xf0\x01", "mvnseq r0, r1, asr r3"),
    (b"\x51\x03\xf0\x11", "mvnsne r0, r1, asr r3"),
    (b"\x51\x03\xf0\x21", "mvnscs r0, r1, asr r3"),
    (b"\x51\x03\xf0\x31", "mvnscc r0, r1, asr r3"),
    (b"\x51\x03\xf0\x41", "mvnsmi r0, r1, asr r3"),
    (b"\x51\x03\xf0\x51", "mvnspl r0, r1, asr r3"),
    (b"\x51\x03\xf0\x61", "mvnsvs r0, r1, asr r3"),
    (b"\x51\x03\xf0\x71", "mvnsvc r0, r1, asr r3"),
    (b"\x51\x03\xf0\x81", "mvnshi r0, r1, asr r3"),
    (b"\x51\x03\xf0\x91", "mvnsls r0, r1, asr r3"),
    (b"\x51\x03\xf0\xa1", "mvnsge r0, r1, asr r3"),
    (b"\x51\x03\xf0\xb1", "mvnslt r0, r1, asr r3"),
    (b"\x51\x03\xf0\xc1", "mvnsgt r0, r1, asr r3"),
    (b"\x51\x03\xf0\xd1", "mvnsle r0, r1, asr r3"),
    (b"\x51\x03\xf0\xe1", "mvnsal r0, r1, asr r3"),

    (b"\x01\x02\xf0\x01", "mvnseq r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x11", "mvnsne r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x21", "mvnscs r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x31", "mvnscc r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x41", "mvnsmi r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x51", "mvnspl r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x61", "mvnsvs r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x71", "mvnsvc r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x81", "mvnshi r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x91", "mvnsls r0, r1, lsl #4"),
    (b"\x01\x02\xf0\xa1", "mvnsge r0, r1, lsl #4"),
    (b"\x01\x02\xf0\xb1", "mvnslt r0, r1, lsl #4"),
    (b"\x01\x02\xf0\xc1", "mvnsgt r0, r1, lsl #4"),
    (b"\x01\x02\xf0\xd1", "mvnsle r0, r1, lsl #4"),
    (b"\x01\x02\xf0\xe1", "mvnsal r0, r1, lsl #4"),

    (b"\x11\x03\xf0\x01", "mvnseq r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x11", "mvnsne r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x21", "mvnscs r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x31", "mvnscc r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x41", "mvnsmi r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x51", "mvnspl r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x61", "mvnsvs r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x71", "mvnsvc r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x81", "mvnshi r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x91", "mvnsls r0, r1, lsl r3"),
    (b"\x11\x03\xf0\xa1", "mvnsge r0, r1, lsl r3"),
    (b"\x11\x03\xf0\xb1", "mvnslt r0, r1, lsl r3"),
    (b"\x11\x03\xf0\xc1", "mvnsgt r0, r1, lsl r3"),
    (b"\x11\x03\xf0\xd1", "mvnsle r0, r1, lsl r3"),
    (b"\x11\x03\xf0\xe1", "mvnsal r0, r1, lsl r3"),

    (b"\x21\x02\xf0\x01", "mvnseq r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x11", "mvnsne r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x21", "mvnscs r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x31", "mvnscc r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x41", "mvnsmi r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x51", "mvnspl r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x61", "mvnsvs r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x71", "mvnsvc r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x81", "mvnshi r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x91", "mvnsls r0, r1, lsr #4"),
    (b"\x21\x02\xf0\xa1", "mvnsge r0, r1, lsr #4"),
    (b"\x21\x02\xf0\xb1", "mvnslt r0, r1, lsr #4"),
    (b"\x21\x02\xf0\xc1", "mvnsgt r0, r1, lsr #4"),
    (b"\x21\x02\xf0\xd1", "mvnsle r0, r1, lsr #4"),
    (b"\x21\x02\xf0\xe1", "mvnsal r0, r1, lsr #4"),

    (b"\x31\x03\xf0\x01", "mvnseq r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x11", "mvnsne r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x21", "mvnscs r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x31", "mvnscc r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x41", "mvnsmi r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x51", "mvnspl r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x61", "mvnsvs r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x71", "mvnsvc r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x81", "mvnshi r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x91", "mvnsls r0, r1, lsr r3"),
    (b"\x31\x03\xf0\xa1", "mvnsge r0, r1, lsr r3"),
    (b"\x31\x03\xf0\xb1", "mvnslt r0, r1, lsr r3"),
    (b"\x31\x03\xf0\xc1", "mvnsgt r0, r1, lsr r3"),
    (b"\x31\x03\xf0\xd1", "mvnsle r0, r1, lsr r3"),
    (b"\x31\x03\xf0\xe1", "mvnsal r0, r1, lsr r3"),

    (b"\x61\x02\xf0\x01", "mvnseq r0, r1, ror #4"),
    (b"\x61\x02\xf0\x11", "mvnsne r0, r1, ror #4"),
    (b"\x61\x02\xf0\x21", "mvnscs r0, r1, ror #4"),
    (b"\x61\x02\xf0\x31", "mvnscc r0, r1, ror #4"),
    (b"\x61\x02\xf0\x41", "mvnsmi r0, r1, ror #4"),
    (b"\x61\x02\xf0\x51", "mvnspl r0, r1, ror #4"),
    (b"\x61\x02\xf0\x61", "mvnsvs r0, r1, ror #4"),
    (b"\x61\x02\xf0\x71", "mvnsvc r0, r1, ror #4"),
    (b"\x61\x02\xf0\x81", "mvnshi r0, r1, ror #4"),
    (b"\x61\x02\xf0\x91", "mvnsls r0, r1, ror #4"),
    (b"\x61\x02\xf0\xa1", "mvnsge r0, r1, ror #4"),
    (b"\x61\x02\xf0\xb1", "mvnslt r0, r1, ror #4"),
    (b"\x61\x02\xf0\xc1", "mvnsgt r0, r1, ror #4"),
    (b"\x61\x02\xf0\xd1", "mvnsle r0, r1, ror #4"),
    (b"\x61\x02\xf0\xe1", "mvnsal r0, r1, ror #4"),

    (b"\x71\x03\xf0\x01", "mvnseq r0, r1, ror r3"),
    (b"\x71\x03\xf0\x11", "mvnsne r0, r1, ror r3"),
    (b"\x71\x03\xf0\x21", "mvnscs r0, r1, ror r3"),
    (b"\x71\x03\xf0\x31", "mvnscc r0, r1, ror r3"),
    (b"\x71\x03\xf0\x41", "mvnsmi r0, r1, ror r3"),
    (b"\x71\x03\xf0\x51", "mvnspl r0, r1, ror r3"),
    (b"\x71\x03\xf0\x61", "mvnsvs r0, r1, ror r3"),
    (b"\x71\x03\xf0\x71", "mvnsvc r0, r1, ror r3"),
    (b"\x71\x03\xf0\x81", "mvnshi r0, r1, ror r3"),
    (b"\x71\x03\xf0\x91", "mvnsls r0, r1, ror r3"),
    (b"\x71\x03\xf0\xa1", "mvnsge r0, r1, ror r3"),
    (b"\x71\x03\xf0\xb1", "mvnslt r0, r1, ror r3"),
    (b"\x71\x03\xf0\xc1", "mvnsgt r0, r1, ror r3"),
    (b"\x71\x03\xf0\xd1", "mvnsle r0, r1, ror r3"),
    (b"\x71\x03\xf0\xe1", "mvnsal r0, r1, ror r3"),

    (b"\x61\x00\xf0\x01", "mvnseq r0, r1, rrx"),
    (b"\x61\x00\xf0\x11", "mvnsne r0, r1, rrx"),
    (b"\x61\x00\xf0\x21", "mvnscs r0, r1, rrx"),
    (b"\x61\x00\xf0\x31", "mvnscc r0, r1, rrx"),
    (b"\x61\x00\xf0\x41", "mvnsmi r0, r1, rrx"),
    (b"\x61\x00\xf0\x51", "mvnspl r0, r1, rrx"),
    (b"\x61\x00\xf0\x61", "mvnsvs r0, r1, rrx"),
    (b"\x61\x00\xf0\x71", "mvnsvc r0, r1, rrx"),
    (b"\x61\x00\xf0\x81", "mvnshi r0, r1, rrx"),
    (b"\x61\x00\xf0\x91", "mvnsls r0, r1, rrx"),
    (b"\x61\x00\xf0\xa1", "mvnsge r0, r1, rrx"),
    (b"\x61\x00\xf0\xb1", "mvnslt r0, r1, rrx"),
    (b"\x61\x00\xf0\xc1", "mvnsgt r0, r1, rrx"),
    (b"\x61\x00\xf0\xd1", "mvnsle r0, r1, rrx"),
    (b"\x61\x00\xf0\xe1", "mvnsal r0, r1, rrx"),

    # ORR -------------------------------------------------------------------- #
    (b"\x02\x00\x81\xe3", "orr r0, r1, #2"),
    (b"\x02\x00\x81\x03", "orreq r0, r1, #2"),
    (b"\x02\x00\x81\x13", "orrne r0, r1, #2"),
    (b"\x02\x00\x81\x23", "orrcs r0, r1, #2"),
    (b"\x02\x00\x81\x33", "orrcc r0, r1, #2"),
    (b"\x02\x00\x81\x43", "orrmi r0, r1, #2"),
    (b"\x02\x00\x81\x53", "orrpl r0, r1, #2"),
    (b"\x02\x00\x81\x63", "orrvs r0, r1, #2"),
    (b"\x02\x00\x81\x73", "orrvc r0, r1, #2"),
    (b"\x02\x00\x81\x83", "orrhi r0, r1, #2"),
    (b"\x02\x00\x81\x93", "orrls r0, r1, #2"),
    (b"\x02\x00\x81\xa3", "orrge r0, r1, #2"),
    (b"\x02\x00\x81\xb3", "orrlt r0, r1, #2"),
    (b"\x02\x00\x81\xc3", "orrgt r0, r1, #2"),
    (b"\x02\x00\x81\xd3", "orrle r0, r1, #2"),
    (b"\x02\x00\x81\xe3", "orral r0, r1, #2"),

    (b"\x03\x00\x81\xe1", "orr r0, r1, r3"),
    (b"\x03\x00\x81\x01", "orreq r0, r1, r3"),
    (b"\x03\x00\x81\x11", "orrne r0, r1, r3"),
    (b"\x03\x00\x81\x21", "orrcs r0, r1, r3"),
    (b"\x03\x00\x81\x31", "orrcc r0, r1, r3"),
    (b"\x03\x00\x81\x41", "orrmi r0, r1, r3"),
    (b"\x03\x00\x81\x51", "orrpl r0, r1, r3"),
    (b"\x03\x00\x81\x61", "orrvs r0, r1, r3"),
    (b"\x03\x00\x81\x71", "orrvc r0, r1, r3"),
    (b"\x03\x00\x81\x81", "orrhi r0, r1, r3"),
    (b"\x03\x00\x81\x91", "orrls r0, r1, r3"),
    (b"\x03\x00\x81\xa1", "orrge r0, r1, r3"),
    (b"\x03\x00\x81\xb1", "orrlt r0, r1, r3"),
    (b"\x03\x00\x81\xc1", "orrgt r0, r1, r3"),
    (b"\x03\x00\x81\xd1", "orrle r0, r1, r3"),
    (b"\x03\x00\x81\xe1", "orral r0, r1, r3"),

    (b"\x02\x00\x91\xe3", "orrs r0, r1, #2"),
    (b"\x02\x00\x91\x03", "orrseq r0, r1, #2"),
    (b"\x02\x00\x91\x13", "orrsne r0, r1, #2"),
    (b"\x02\x00\x91\x23", "orrscs r0, r1, #2"),
    (b"\x02\x00\x91\x33", "orrscc r0, r1, #2"),
    (b"\x02\x00\x91\x43", "orrsmi r0, r1, #2"),
    (b"\x02\x00\x91\x53", "orrspl r0, r1, #2"),
    (b"\x02\x00\x91\x63", "orrsvs r0, r1, #2"),
    (b"\x02\x00\x91\x73", "orrsvc r0, r1, #2"),
    (b"\x02\x00\x91\x83", "orrshi r0, r1, #2"),
    (b"\x02\x00\x91\x93", "orrsls r0, r1, #2"),
    (b"\x02\x00\x91\xa3", "orrsge r0, r1, #2"),
    (b"\x02\x00\x91\xb3", "orrslt r0, r1, #2"),
    (b"\x02\x00\x91\xc3", "orrsgt r0, r1, #2"),
    (b"\x02\x00\x91\xd3", "orrsle r0, r1, #2"),
    (b"\x02\x00\x91\xe3", "orrsal r0, r1, #2"),

    (b"\x03\x00\x91\xe1", "orrs r0, r1, r3"),
    (b"\x03\x00\x91\x01", "orrseq r0, r1, r3"),
    (b"\x03\x00\x91\x11", "orrsne r0, r1, r3"),
    (b"\x03\x00\x91\x21", "orrscs r0, r1, r3"),
    (b"\x03\x00\x91\x31", "orrscc r0, r1, r3"),
    (b"\x03\x00\x91\x41", "orrsmi r0, r1, r3"),
    (b"\x03\x00\x91\x51", "orrspl r0, r1, r3"),
    (b"\x03\x00\x91\x61", "orrsvs r0, r1, r3"),
    (b"\x03\x00\x91\x71", "orrsvc r0, r1, r3"),
    (b"\x03\x00\x91\x81", "orrshi r0, r1, r3"),
    (b"\x03\x00\x91\x91", "orrsls r0, r1, r3"),
    (b"\x03\x00\x91\xa1", "orrsge r0, r1, r3"),
    (b"\x03\x00\x91\xb1", "orrslt r0, r1, r3"),
    (b"\x03\x00\x91\xc1", "orrsgt r0, r1, r3"),
    (b"\x03\x00\x91\xd1", "orrsle r0, r1, r3"),
    (b"\x03\x00\x91\xe1", "orrsal r0, r1, r3"),

    (b"\x41\x02\x90\x01", "orrseq r0, r1, asr #4"),
    (b"\x41\x02\x90\x11", "orrsne r0, r1, asr #4"),
    (b"\x41\x02\x90\x21", "orrscs r0, r1, asr #4"),
    (b"\x41\x02\x90\x31", "orrscc r0, r1, asr #4"),
    (b"\x41\x02\x90\x41", "orrsmi r0, r1, asr #4"),
    (b"\x41\x02\x90\x51", "orrspl r0, r1, asr #4"),
    (b"\x41\x02\x90\x61", "orrsvs r0, r1, asr #4"),
    (b"\x41\x02\x90\x71", "orrsvc r0, r1, asr #4"),
    (b"\x41\x02\x90\x81", "orrshi r0, r1, asr #4"),
    (b"\x41\x02\x90\x91", "orrsls r0, r1, asr #4"),
    (b"\x41\x02\x90\xa1", "orrsge r0, r1, asr #4"),
    (b"\x41\x02\x90\xb1", "orrslt r0, r1, asr #4"),
    (b"\x41\x02\x90\xc1", "orrsgt r0, r1, asr #4"),
    (b"\x41\x02\x90\xd1", "orrsle r0, r1, asr #4"),
    (b"\x41\x02\x90\xe1", "orrsal r0, r1, asr #4"),

    (b"\x51\x03\x90\x01", "orrseq r0, r1, asr r3"),
    (b"\x51\x03\x90\x11", "orrsne r0, r1, asr r3"),
    (b"\x51\x03\x90\x21", "orrscs r0, r1, asr r3"),
    (b"\x51\x03\x90\x31", "orrscc r0, r1, asr r3"),
    (b"\x51\x03\x90\x41", "orrsmi r0, r1, asr r3"),
    (b"\x51\x03\x90\x51", "orrspl r0, r1, asr r3"),
    (b"\x51\x03\x90\x61", "orrsvs r0, r1, asr r3"),
    (b"\x51\x03\x90\x71", "orrsvc r0, r1, asr r3"),
    (b"\x51\x03\x90\x81", "orrshi r0, r1, asr r3"),
    (b"\x51\x03\x90\x91", "orrsls r0, r1, asr r3"),
    (b"\x51\x03\x90\xa1", "orrsge r0, r1, asr r3"),
    (b"\x51\x03\x90\xb1", "orrslt r0, r1, asr r3"),
    (b"\x51\x03\x90\xc1", "orrsgt r0, r1, asr r3"),
    (b"\x51\x03\x90\xd1", "orrsle r0, r1, asr r3"),
    (b"\x51\x03\x90\xe1", "orrsal r0, r1, asr r3"),

    (b"\x01\x02\x90\x01", "orrseq r0, r1, lsl #4"),
    (b"\x01\x02\x90\x11", "orrsne r0, r1, lsl #4"),
    (b"\x01\x02\x90\x21", "orrscs r0, r1, lsl #4"),
    (b"\x01\x02\x90\x31", "orrscc r0, r1, lsl #4"),
    (b"\x01\x02\x90\x41", "orrsmi r0, r1, lsl #4"),
    (b"\x01\x02\x90\x51", "orrspl r0, r1, lsl #4"),
    (b"\x01\x02\x90\x61", "orrsvs r0, r1, lsl #4"),
    (b"\x01\x02\x90\x71", "orrsvc r0, r1, lsl #4"),
    (b"\x01\x02\x90\x81", "orrshi r0, r1, lsl #4"),
    (b"\x01\x02\x90\x91", "orrsls r0, r1, lsl #4"),
    (b"\x01\x02\x90\xa1", "orrsge r0, r1, lsl #4"),
    (b"\x01\x02\x90\xb1", "orrslt r0, r1, lsl #4"),
    (b"\x01\x02\x90\xc1", "orrsgt r0, r1, lsl #4"),
    (b"\x01\x02\x90\xd1", "orrsle r0, r1, lsl #4"),
    (b"\x01\x02\x90\xe1", "orrsal r0, r1, lsl #4"),

    (b"\x11\x03\x90\x01", "orrseq r0, r1, lsl r3"),
    (b"\x11\x03\x90\x11", "orrsne r0, r1, lsl r3"),
    (b"\x11\x03\x90\x21", "orrscs r0, r1, lsl r3"),
    (b"\x11\x03\x90\x31", "orrscc r0, r1, lsl r3"),
    (b"\x11\x03\x90\x41", "orrsmi r0, r1, lsl r3"),
    (b"\x11\x03\x90\x51", "orrspl r0, r1, lsl r3"),
    (b"\x11\x03\x90\x61", "orrsvs r0, r1, lsl r3"),
    (b"\x11\x03\x90\x71", "orrsvc r0, r1, lsl r3"),
    (b"\x11\x03\x90\x81", "orrshi r0, r1, lsl r3"),
    (b"\x11\x03\x90\x91", "orrsls r0, r1, lsl r3"),
    (b"\x11\x03\x90\xa1", "orrsge r0, r1, lsl r3"),
    (b"\x11\x03\x90\xb1", "orrslt r0, r1, lsl r3"),
    (b"\x11\x03\x90\xc1", "orrsgt r0, r1, lsl r3"),
    (b"\x11\x03\x90\xd1", "orrsle r0, r1, lsl r3"),
    (b"\x11\x03\x90\xe1", "orrsal r0, r1, lsl r3"),

    (b"\x21\x02\x90\x01", "orrseq r0, r1, lsr #4"),
    (b"\x21\x02\x90\x11", "orrsne r0, r1, lsr #4"),
    (b"\x21\x02\x90\x21", "orrscs r0, r1, lsr #4"),
    (b"\x21\x02\x90\x31", "orrscc r0, r1, lsr #4"),
    (b"\x21\x02\x90\x41", "orrsmi r0, r1, lsr #4"),
    (b"\x21\x02\x90\x51", "orrspl r0, r1, lsr #4"),
    (b"\x21\x02\x90\x61", "orrsvs r0, r1, lsr #4"),
    (b"\x21\x02\x90\x71", "orrsvc r0, r1, lsr #4"),
    (b"\x21\x02\x90\x81", "orrshi r0, r1, lsr #4"),
    (b"\x21\x02\x90\x91", "orrsls r0, r1, lsr #4"),
    (b"\x21\x02\x90\xa1", "orrsge r0, r1, lsr #4"),
    (b"\x21\x02\x90\xb1", "orrslt r0, r1, lsr #4"),
    (b"\x21\x02\x90\xc1", "orrsgt r0, r1, lsr #4"),
    (b"\x21\x02\x90\xd1", "orrsle r0, r1, lsr #4"),
    (b"\x21\x02\x90\xe1", "orrsal r0, r1, lsr #4"),

    (b"\x31\x03\x90\x01", "orrseq r0, r1, lsr r3"),
    (b"\x31\x03\x90\x11", "orrsne r0, r1, lsr r3"),
    (b"\x31\x03\x90\x21", "orrscs r0, r1, lsr r3"),
    (b"\x31\x03\x90\x31", "orrscc r0, r1, lsr r3"),
    (b"\x31\x03\x90\x41", "orrsmi r0, r1, lsr r3"),
    (b"\x31\x03\x90\x51", "orrspl r0, r1, lsr r3"),
    (b"\x31\x03\x90\x61", "orrsvs r0, r1, lsr r3"),
    (b"\x31\x03\x90\x71", "orrsvc r0, r1, lsr r3"),
    (b"\x31\x03\x90\x81", "orrshi r0, r1, lsr r3"),
    (b"\x31\x03\x90\x91", "orrsls r0, r1, lsr r3"),
    (b"\x31\x03\x90\xa1", "orrsge r0, r1, lsr r3"),
    (b"\x31\x03\x90\xb1", "orrslt r0, r1, lsr r3"),
    (b"\x31\x03\x90\xc1", "orrsgt r0, r1, lsr r3"),
    (b"\x31\x03\x90\xd1", "orrsle r0, r1, lsr r3"),
    (b"\x31\x03\x90\xe1", "orrsal r0, r1, lsr r3"),

    (b"\x61\x02\x90\x01", "orrseq r0, r1, ror #4"),
    (b"\x61\x02\x90\x11", "orrsne r0, r1, ror #4"),
    (b"\x61\x02\x90\x21", "orrscs r0, r1, ror #4"),
    (b"\x61\x02\x90\x31", "orrscc r0, r1, ror #4"),
    (b"\x61\x02\x90\x41", "orrsmi r0, r1, ror #4"),
    (b"\x61\x02\x90\x51", "orrspl r0, r1, ror #4"),
    (b"\x61\x02\x90\x61", "orrsvs r0, r1, ror #4"),
    (b"\x61\x02\x90\x71", "orrsvc r0, r1, ror #4"),
    (b"\x61\x02\x90\x81", "orrshi r0, r1, ror #4"),
    (b"\x61\x02\x90\x91", "orrsls r0, r1, ror #4"),
    (b"\x61\x02\x90\xa1", "orrsge r0, r1, ror #4"),
    (b"\x61\x02\x90\xb1", "orrslt r0, r1, ror #4"),
    (b"\x61\x02\x90\xc1", "orrsgt r0, r1, ror #4"),
    (b"\x61\x02\x90\xd1", "orrsle r0, r1, ror #4"),
    (b"\x61\x02\x90\xe1", "orrsal r0, r1, ror #4"),

    (b"\x71\x03\x90\x01", "orrseq r0, r1, ror r3"),
    (b"\x71\x03\x90\x11", "orrsne r0, r1, ror r3"),
    (b"\x71\x03\x90\x21", "orrscs r0, r1, ror r3"),
    (b"\x71\x03\x90\x31", "orrscc r0, r1, ror r3"),
    (b"\x71\x03\x90\x41", "orrsmi r0, r1, ror r3"),
    (b"\x71\x03\x90\x51", "orrspl r0, r1, ror r3"),
    (b"\x71\x03\x90\x61", "orrsvs r0, r1, ror r3"),
    (b"\x71\x03\x90\x71", "orrsvc r0, r1, ror r3"),
    (b"\x71\x03\x90\x81", "orrshi r0, r1, ror r3"),
    (b"\x71\x03\x90\x91", "orrsls r0, r1, ror r3"),
    (b"\x71\x03\x90\xa1", "orrsge r0, r1, ror r3"),
    (b"\x71\x03\x90\xb1", "orrslt r0, r1, ror r3"),
    (b"\x71\x03\x90\xc1", "orrsgt r0, r1, ror r3"),
    (b"\x71\x03\x90\xd1", "orrsle r0, r1, ror r3"),
    (b"\x71\x03\x90\xe1", "orrsal r0, r1, ror r3"),

    (b"\x61\x00\x90\x01", "orrseq r0, r1, rrx"),
    (b"\x61\x00\x90\x11", "orrsne r0, r1, rrx"),
    (b"\x61\x00\x90\x21", "orrscs r0, r1, rrx"),
    (b"\x61\x00\x90\x31", "orrscc r0, r1, rrx"),
    (b"\x61\x00\x90\x41", "orrsmi r0, r1, rrx"),
    (b"\x61\x00\x90\x51", "orrspl r0, r1, rrx"),
    (b"\x61\x00\x90\x61", "orrsvs r0, r1, rrx"),
    (b"\x61\x00\x90\x71", "orrsvc r0, r1, rrx"),
    (b"\x61\x00\x90\x81", "orrshi r0, r1, rrx"),
    (b"\x61\x00\x90\x91", "orrsls r0, r1, rrx"),
    (b"\x61\x00\x90\xa1", "orrsge r0, r1, rrx"),
    (b"\x61\x00\x90\xb1", "orrslt r0, r1, rrx"),
    (b"\x61\x00\x90\xc1", "orrsgt r0, r1, rrx"),
    (b"\x61\x00\x90\xd1", "orrsle r0, r1, rrx"),
    (b"\x61\x00\x90\xe1", "orrsal r0, r1, rrx"),

    # RBIT ------------------------------------------------------------------- #
    (b"\x31\x0f\xff\xe6", "rbit r0, r1"),
    (b"\x31\x0f\xff\x06", "rbiteq r0, r1"),
    (b"\x31\x0f\xff\x16", "rbitne r0, r1"),
    (b"\x31\x0f\xff\x26", "rbitcs r0, r1"),
    (b"\x31\x0f\xff\x36", "rbitcc r0, r1"),
    (b"\x31\x0f\xff\x46", "rbitmi r0, r1"),
    (b"\x31\x0f\xff\x56", "rbitpl r0, r1"),
    (b"\x31\x0f\xff\x66", "rbitvs r0, r1"),
    (b"\x31\x0f\xff\x76", "rbitvc r0, r1"),
    (b"\x31\x0f\xff\x86", "rbithi r0, r1"),
    (b"\x31\x0f\xff\x96", "rbitls r0, r1"),
    (b"\x31\x0f\xff\xa6", "rbitge r0, r1"),
    (b"\x31\x0f\xff\xb6", "rbitlt r0, r1"),
    (b"\x31\x0f\xff\xc6", "rbitgt r0, r1"),
    (b"\x31\x0f\xff\xd6", "rbitle r0, r1"),
    (b"\x31\x0f\xff\xe6", "rbital r0, r1"),
    (b"\x31\x0f\xff\xe6", "rbit r0, r1"),
    (b"\x31\x0f\xff\x06", "rbiteq r0, r1"),
    (b"\x31\x0f\xff\x16", "rbitne r0, r1"),
    (b"\x31\x0f\xff\x26", "rbitcs r0, r1"),
    (b"\x31\x0f\xff\x36", "rbitcc r0, r1"),
    (b"\x31\x0f\xff\x46", "rbitmi r0, r1"),
    (b"\x31\x0f\xff\x56", "rbitpl r0, r1"),
    (b"\x31\x0f\xff\x66", "rbitvs r0, r1"),
    (b"\x31\x0f\xff\x76", "rbitvc r0, r1"),
    (b"\x31\x0f\xff\x86", "rbithi r0, r1"),
    (b"\x31\x0f\xff\x96", "rbitls r0, r1"),
    (b"\x31\x0f\xff\xa6", "rbitge r0, r1"),
    (b"\x31\x0f\xff\xb6", "rbitlt r0, r1"),
    (b"\x31\x0f\xff\xc6", "rbitgt r0, r1"),
    (b"\x31\x0f\xff\xd6", "rbitle r0, r1"),

    # REV -------------------------------------------------------------------- #
    (b"\x31\x0f\xbf\xe6", "rev r0, r1"),
    (b"\x31\x0f\xbf\x06", "reveq r0, r1"),
    (b"\x31\x0f\xbf\x16", "revne r0, r1"),
    (b"\x31\x0f\xbf\x26", "revcs r0, r1"),
    (b"\x31\x0f\xbf\x36", "revcc r0, r1"),
    (b"\x31\x0f\xbf\x46", "revmi r0, r1"),
    (b"\x31\x0f\xbf\x56", "revpl r0, r1"),
    (b"\x31\x0f\xbf\x66", "revvs r0, r1"),
    (b"\x31\x0f\xbf\x76", "revvc r0, r1"),
    (b"\x31\x0f\xbf\x86", "revhi r0, r1"),
    (b"\x31\x0f\xbf\x96", "revls r0, r1"),
    (b"\x31\x0f\xbf\xa6", "revge r0, r1"),
    (b"\x31\x0f\xbf\xb6", "revlt r0, r1"),
    (b"\x31\x0f\xbf\xc6", "revgt r0, r1"),
    (b"\x31\x0f\xbf\xd6", "revle r0, r1"),
    (b"\x31\x0f\xbf\xe6", "reval r0, r1"),

    (b"\x31\x0f\xbf\xe6", "rev r0, r1"),
    (b"\x31\x0f\xbf\x06", "reveq r0, r1"),
    (b"\x31\x0f\xbf\x16", "revne r0, r1"),
    (b"\x31\x0f\xbf\x26", "revcs r0, r1"),
    (b"\x31\x0f\xbf\x36", "revcc r0, r1"),
    (b"\x31\x0f\xbf\x46", "revmi r0, r1"),
    (b"\x31\x0f\xbf\x56", "revpl r0, r1"),
    (b"\x31\x0f\xbf\x66", "revvs r0, r1"),
    (b"\x31\x0f\xbf\x76", "revvc r0, r1"),
    (b"\x31\x0f\xbf\x86", "revhi r0, r1"),
    (b"\x31\x0f\xbf\x96", "revls r0, r1"),
    (b"\x31\x0f\xbf\xa6", "revge r0, r1"),
    (b"\x31\x0f\xbf\xb6", "revlt r0, r1"),
    (b"\x31\x0f\xbf\xc6", "revgt r0, r1"),
    (b"\x31\x0f\xbf\xd6", "revle r0, r1"),


    # REV16 ------------------------------------------------------------------ #
    (b"\xb1\x0f\xbf\xe6", "rev16 r0, r1"),
    (b"\xb1\x0f\xbf\x06", "rev16eq r0, r1"),
    (b"\xb1\x0f\xbf\x16", "rev16ne r0, r1"),
    (b"\xb1\x0f\xbf\x26", "rev16cs r0, r1"),
    (b"\xb1\x0f\xbf\x36", "rev16cc r0, r1"),
    (b"\xb1\x0f\xbf\x46", "rev16mi r0, r1"),
    (b"\xb1\x0f\xbf\x56", "rev16pl r0, r1"),
    (b"\xb1\x0f\xbf\x66", "rev16vs r0, r1"),
    (b"\xb1\x0f\xbf\x76", "rev16vc r0, r1"),
    (b"\xb1\x0f\xbf\x86", "rev16hi r0, r1"),
    (b"\xb1\x0f\xbf\x96", "rev16ls r0, r1"),
    (b"\xb1\x0f\xbf\xa6", "rev16ge r0, r1"),
    (b"\xb1\x0f\xbf\xb6", "rev16lt r0, r1"),
    (b"\xb1\x0f\xbf\xc6", "rev16gt r0, r1"),
    (b"\xb1\x0f\xbf\xd6", "rev16le r0, r1"),
    (b"\xb1\x0f\xbf\xe6", "rev16al r0, r1"),
    (b"\xb1\x0f\xbf\xe6", "rev16 r0, r1"),
    (b"\xb1\x0f\xbf\x06", "rev16eq r0, r1"),
    (b"\xb1\x0f\xbf\x16", "rev16ne r0, r1"),
    (b"\xb1\x0f\xbf\x26", "rev16cs r0, r1"),
    (b"\xb1\x0f\xbf\x36", "rev16cc r0, r1"),
    (b"\xb1\x0f\xbf\x46", "rev16mi r0, r1"),
    (b"\xb1\x0f\xbf\x56", "rev16pl r0, r1"),
    (b"\xb1\x0f\xbf\x66", "rev16vs r0, r1"),
    (b"\xb1\x0f\xbf\x76", "rev16vc r0, r1"),
    (b"\xb1\x0f\xbf\x86", "rev16hi r0, r1"),
    (b"\xb1\x0f\xbf\x96", "rev16ls r0, r1"),
    (b"\xb1\x0f\xbf\xa6", "rev16ge r0, r1"),
    (b"\xb1\x0f\xbf\xb6", "rev16lt r0, r1"),
    (b"\xb1\x0f\xbf\xc6", "rev16gt r0, r1"),
    (b"\xb1\x0f\xbf\xd6", "rev16le r0, r1"),

    # ROR -------------------------------------------------------------------- #
    (b"\x61\x01\xa0\xe1", "ror r0, r1, #2"),
    (b"\x61\x01\xa0\x01", "roreq r0, r1, #2"),
    (b"\x61\x01\xa0\x11", "rorne r0, r1, #2"),
    (b"\x61\x01\xa0\x21", "rorcs r0, r1, #2"),
    (b"\x61\x01\xa0\x31", "rorcc r0, r1, #2"),
    (b"\x61\x01\xa0\x41", "rormi r0, r1, #2"),
    (b"\x61\x01\xa0\x51", "rorpl r0, r1, #2"),
    (b"\x61\x01\xa0\x61", "rorvs r0, r1, #2"),
    (b"\x61\x01\xa0\x71", "rorvc r0, r1, #2"),
    (b"\x61\x01\xa0\x81", "rorhi r0, r1, #2"),
    (b"\x61\x01\xa0\x91", "rorls r0, r1, #2"),
    (b"\x61\x01\xa0\xa1", "rorge r0, r1, #2"),
    (b"\x61\x01\xa0\xb1", "rorlt r0, r1, #2"),
    (b"\x61\x01\xa0\xc1", "rorgt r0, r1, #2"),
    (b"\x61\x01\xa0\xd1", "rorle r0, r1, #2"),
    (b"\x61\x01\xa0\xe1", "roral r0, r1, #2"),

    (b"\x71\x03\xa0\xe1", "ror r0, r1, r3"),
    (b"\x71\x03\xa0\x01", "roreq r0, r1, r3"),
    (b"\x71\x03\xa0\x11", "rorne r0, r1, r3"),
    (b"\x71\x03\xa0\x21", "rorcs r0, r1, r3"),
    (b"\x71\x03\xa0\x31", "rorcc r0, r1, r3"),
    (b"\x71\x03\xa0\x41", "rormi r0, r1, r3"),
    (b"\x71\x03\xa0\x51", "rorpl r0, r1, r3"),
    (b"\x71\x03\xa0\x61", "rorvs r0, r1, r3"),
    (b"\x71\x03\xa0\x71", "rorvc r0, r1, r3"),
    (b"\x71\x03\xa0\x81", "rorhi r0, r1, r3"),
    (b"\x71\x03\xa0\x91", "rorls r0, r1, r3"),
    (b"\x71\x03\xa0\xa1", "rorge r0, r1, r3"),
    (b"\x71\x03\xa0\xb1", "rorlt r0, r1, r3"),
    (b"\x71\x03\xa0\xc1", "rorgt r0, r1, r3"),
    (b"\x71\x03\xa0\xd1", "rorle r0, r1, r3"),
    (b"\x71\x03\xa0\xe1", "roral r0, r1, r3"),

    (b"\x61\x01\xb0\xe1", "rors r0, r1, #2"),
    (b"\x61\x01\xb0\x01", "rorseq r0, r1, #2"),
    (b"\x61\x01\xb0\x11", "rorsne r0, r1, #2"),
    (b"\x61\x01\xb0\x21", "rorscs r0, r1, #2"),
    (b"\x61\x01\xb0\x31", "rorscc r0, r1, #2"),
    (b"\x61\x01\xb0\x41", "rorsmi r0, r1, #2"),
    (b"\x61\x01\xb0\x51", "rorspl r0, r1, #2"),
    (b"\x61\x01\xb0\x61", "rorsvs r0, r1, #2"),
    (b"\x61\x01\xb0\x71", "rorsvc r0, r1, #2"),
    (b"\x61\x01\xb0\x81", "rorshi r0, r1, #2"),
    (b"\x61\x01\xb0\x91", "rorsls r0, r1, #2"),
    (b"\x61\x01\xb0\xa1", "rorsge r0, r1, #2"),
    (b"\x61\x01\xb0\xb1", "rorslt r0, r1, #2"),
    (b"\x61\x01\xb0\xc1", "rorsgt r0, r1, #2"),
    (b"\x61\x01\xb0\xd1", "rorsle r0, r1, #2"),
    (b"\x61\x01\xb0\xe1", "rorsal r0, r1, #2"),

    (b"\x71\x03\xb0\xe1", "rors r0, r1, r3"),
    (b"\x71\x03\xb0\x01", "rorseq r0, r1, r3"),
    (b"\x71\x03\xb0\x11", "rorsne r0, r1, r3"),
    (b"\x71\x03\xb0\x21", "rorscs r0, r1, r3"),
    (b"\x71\x03\xb0\x31", "rorscc r0, r1, r3"),
    (b"\x71\x03\xb0\x41", "rorsmi r0, r1, r3"),
    (b"\x71\x03\xb0\x51", "rorspl r0, r1, r3"),
    (b"\x71\x03\xb0\x61", "rorsvs r0, r1, r3"),
    (b"\x71\x03\xb0\x71", "rorsvc r0, r1, r3"),
    (b"\x71\x03\xb0\x81", "rorshi r0, r1, r3"),
    (b"\x71\x03\xb0\x91", "rorsls r0, r1, r3"),
    (b"\x71\x03\xb0\xa1", "rorsge r0, r1, r3"),
    (b"\x71\x03\xb0\xb1", "rorslt r0, r1, r3"),
    (b"\x71\x03\xb0\xc1", "rorsgt r0, r1, r3"),
    (b"\x71\x03\xb0\xd1", "rorsle r0, r1, r3"),
    (b"\x71\x03\xb0\xe1", "rorsal r0, r1, r3"),

    # RSB -------------------------------------------------------------------- #
    (b"\x02\x00\x61\xe2", "rsb r0, r1, #2"),
    (b"\x02\x00\x61\x02", "rsbeq r0, r1, #2"),
    (b"\x02\x00\x61\x12", "rsbne r0, r1, #2"),
    (b"\x02\x00\x61\x22", "rsbcs r0, r1, #2"),
    (b"\x02\x00\x61\x32", "rsbcc r0, r1, #2"),
    (b"\x02\x00\x61\x42", "rsbmi r0, r1, #2"),
    (b"\x02\x00\x61\x52", "rsbpl r0, r1, #2"),
    (b"\x02\x00\x61\x62", "rsbvs r0, r1, #2"),
    (b"\x02\x00\x61\x72", "rsbvc r0, r1, #2"),
    (b"\x02\x00\x61\x82", "rsbhi r0, r1, #2"),
    (b"\x02\x00\x61\x92", "rsbls r0, r1, #2"),
    (b"\x02\x00\x61\xa2", "rsbge r0, r1, #2"),
    (b"\x02\x00\x61\xb2", "rsblt r0, r1, #2"),
    (b"\x02\x00\x61\xc2", "rsbgt r0, r1, #2"),
    (b"\x02\x00\x61\xd2", "rsble r0, r1, #2"),
    (b"\x02\x00\x61\xe2", "rsbal r0, r1, #2"),

    (b"\x03\x00\x61\xe0", "rsb r0, r1, r3"),
    (b"\x03\x00\x61\x00", "rsbeq r0, r1, r3"),
    (b"\x03\x00\x61\x10", "rsbne r0, r1, r3"),
    (b"\x03\x00\x61\x20", "rsbcs r0, r1, r3"),
    (b"\x03\x00\x61\x30", "rsbcc r0, r1, r3"),
    (b"\x03\x00\x61\x40", "rsbmi r0, r1, r3"),
    (b"\x03\x00\x61\x50", "rsbpl r0, r1, r3"),
    (b"\x03\x00\x61\x60", "rsbvs r0, r1, r3"),
    (b"\x03\x00\x61\x70", "rsbvc r0, r1, r3"),
    (b"\x03\x00\x61\x80", "rsbhi r0, r1, r3"),
    (b"\x03\x00\x61\x90", "rsbls r0, r1, r3"),
    (b"\x03\x00\x61\xa0", "rsbge r0, r1, r3"),
    (b"\x03\x00\x61\xb0", "rsblt r0, r1, r3"),
    (b"\x03\x00\x61\xc0", "rsbgt r0, r1, r3"),
    (b"\x03\x00\x61\xd0", "rsble r0, r1, r3"),
    (b"\x03\x00\x61\xe0", "rsbal r0, r1, r3"),

    (b"\x02\x00\x71\xe2", "rsbs r0, r1, #2"),
    (b"\x02\x00\x71\x02", "rsbseq r0, r1, #2"),
    (b"\x02\x00\x71\x12", "rsbsne r0, r1, #2"),
    (b"\x02\x00\x71\x22", "rsbscs r0, r1, #2"),
    (b"\x02\x00\x71\x32", "rsbscc r0, r1, #2"),
    (b"\x02\x00\x71\x42", "rsbsmi r0, r1, #2"),
    (b"\x02\x00\x71\x52", "rsbspl r0, r1, #2"),
    (b"\x02\x00\x71\x62", "rsbsvs r0, r1, #2"),
    (b"\x02\x00\x71\x72", "rsbsvc r0, r1, #2"),
    (b"\x02\x00\x71\x82", "rsbshi r0, r1, #2"),
    (b"\x02\x00\x71\x92", "rsbsls r0, r1, #2"),
    (b"\x02\x00\x71\xa2", "rsbsge r0, r1, #2"),
    (b"\x02\x00\x71\xb2", "rsbslt r0, r1, #2"),
    (b"\x02\x00\x71\xc2", "rsbsgt r0, r1, #2"),
    (b"\x02\x00\x71\xd2", "rsbsle r0, r1, #2"),
    (b"\x02\x00\x71\xe2", "rsbsal r0, r1, #2"),

    (b"\x03\x00\x71\xe0", "rsbs r0, r1, r3"),
    (b"\x03\x00\x71\x00", "rsbseq r0, r1, r3"),
    (b"\x03\x00\x71\x10", "rsbsne r0, r1, r3"),
    (b"\x03\x00\x71\x20", "rsbscs r0, r1, r3"),
    (b"\x03\x00\x71\x30", "rsbscc r0, r1, r3"),
    (b"\x03\x00\x71\x40", "rsbsmi r0, r1, r3"),
    (b"\x03\x00\x71\x50", "rsbspl r0, r1, r3"),
    (b"\x03\x00\x71\x60", "rsbsvs r0, r1, r3"),
    (b"\x03\x00\x71\x70", "rsbsvc r0, r1, r3"),
    (b"\x03\x00\x71\x80", "rsbshi r0, r1, r3"),
    (b"\x03\x00\x71\x90", "rsbsls r0, r1, r3"),
    (b"\x03\x00\x71\xa0", "rsbsge r0, r1, r3"),
    (b"\x03\x00\x71\xb0", "rsbslt r0, r1, r3"),
    (b"\x03\x00\x71\xc0", "rsbsgt r0, r1, r3"),
    (b"\x03\x00\x71\xd0", "rsbsle r0, r1, r3"),
    (b"\x03\x00\x71\xe0", "rsbsal r0, r1, r3"),

    (b"\x41\x02\x70\x00", "rsbseq r0, r1, asr #4"),
    (b"\x41\x02\x70\x10", "rsbsne r0, r1, asr #4"),
    (b"\x41\x02\x70\x20", "rsbscs r0, r1, asr #4"),
    (b"\x41\x02\x70\x30", "rsbscc r0, r1, asr #4"),
    (b"\x41\x02\x70\x40", "rsbsmi r0, r1, asr #4"),
    (b"\x41\x02\x70\x50", "rsbspl r0, r1, asr #4"),
    (b"\x41\x02\x70\x60", "rsbsvs r0, r1, asr #4"),
    (b"\x41\x02\x70\x70", "rsbsvc r0, r1, asr #4"),
    (b"\x41\x02\x70\x80", "rsbshi r0, r1, asr #4"),
    (b"\x41\x02\x70\x90", "rsbsls r0, r1, asr #4"),
    (b"\x41\x02\x70\xa0", "rsbsge r0, r1, asr #4"),
    (b"\x41\x02\x70\xb0", "rsbslt r0, r1, asr #4"),
    (b"\x41\x02\x70\xc0", "rsbsgt r0, r1, asr #4"),
    (b"\x41\x02\x70\xd0", "rsbsle r0, r1, asr #4"),
    (b"\x41\x02\x70\xe0", "rsbsal r0, r1, asr #4"),

    (b"\x51\x03\x70\x00", "rsbseq r0, r1, asr r3"),
    (b"\x51\x03\x70\x10", "rsbsne r0, r1, asr r3"),
    (b"\x51\x03\x70\x20", "rsbscs r0, r1, asr r3"),
    (b"\x51\x03\x70\x30", "rsbscc r0, r1, asr r3"),
    (b"\x51\x03\x70\x40", "rsbsmi r0, r1, asr r3"),
    (b"\x51\x03\x70\x50", "rsbspl r0, r1, asr r3"),
    (b"\x51\x03\x70\x60", "rsbsvs r0, r1, asr r3"),
    (b"\x51\x03\x70\x70", "rsbsvc r0, r1, asr r3"),
    (b"\x51\x03\x70\x80", "rsbshi r0, r1, asr r3"),
    (b"\x51\x03\x70\x90", "rsbsls r0, r1, asr r3"),
    (b"\x51\x03\x70\xa0", "rsbsge r0, r1, asr r3"),
    (b"\x51\x03\x70\xb0", "rsbslt r0, r1, asr r3"),
    (b"\x51\x03\x70\xc0", "rsbsgt r0, r1, asr r3"),
    (b"\x51\x03\x70\xd0", "rsbsle r0, r1, asr r3"),
    (b"\x51\x03\x70\xe0", "rsbsal r0, r1, asr r3"),

    (b"\x01\x02\x70\x00", "rsbseq r0, r1, lsl #4"),
    (b"\x01\x02\x70\x10", "rsbsne r0, r1, lsl #4"),
    (b"\x01\x02\x70\x20", "rsbscs r0, r1, lsl #4"),
    (b"\x01\x02\x70\x30", "rsbscc r0, r1, lsl #4"),
    (b"\x01\x02\x70\x40", "rsbsmi r0, r1, lsl #4"),
    (b"\x01\x02\x70\x50", "rsbspl r0, r1, lsl #4"),
    (b"\x01\x02\x70\x60", "rsbsvs r0, r1, lsl #4"),
    (b"\x01\x02\x70\x70", "rsbsvc r0, r1, lsl #4"),
    (b"\x01\x02\x70\x80", "rsbshi r0, r1, lsl #4"),
    (b"\x01\x02\x70\x90", "rsbsls r0, r1, lsl #4"),
    (b"\x01\x02\x70\xa0", "rsbsge r0, r1, lsl #4"),
    (b"\x01\x02\x70\xb0", "rsbslt r0, r1, lsl #4"),
    (b"\x01\x02\x70\xc0", "rsbsgt r0, r1, lsl #4"),
    (b"\x01\x02\x70\xd0", "rsbsle r0, r1, lsl #4"),
    (b"\x01\x02\x70\xe0", "rsbsal r0, r1, lsl #4"),

    (b"\x11\x03\x70\x00", "rsbseq r0, r1, lsl r3"),
    (b"\x11\x03\x70\x10", "rsbsne r0, r1, lsl r3"),
    (b"\x11\x03\x70\x20", "rsbscs r0, r1, lsl r3"),
    (b"\x11\x03\x70\x30", "rsbscc r0, r1, lsl r3"),
    (b"\x11\x03\x70\x40", "rsbsmi r0, r1, lsl r3"),
    (b"\x11\x03\x70\x50", "rsbspl r0, r1, lsl r3"),
    (b"\x11\x03\x70\x60", "rsbsvs r0, r1, lsl r3"),
    (b"\x11\x03\x70\x70", "rsbsvc r0, r1, lsl r3"),
    (b"\x11\x03\x70\x80", "rsbshi r0, r1, lsl r3"),
    (b"\x11\x03\x70\x90", "rsbsls r0, r1, lsl r3"),
    (b"\x11\x03\x70\xa0", "rsbsge r0, r1, lsl r3"),
    (b"\x11\x03\x70\xb0", "rsbslt r0, r1, lsl r3"),
    (b"\x11\x03\x70\xc0", "rsbsgt r0, r1, lsl r3"),
    (b"\x11\x03\x70\xd0", "rsbsle r0, r1, lsl r3"),
    (b"\x11\x03\x70\xe0", "rsbsal r0, r1, lsl r3"),

    (b"\x21\x02\x70\x00", "rsbseq r0, r1, lsr #4"),
    (b"\x21\x02\x70\x10", "rsbsne r0, r1, lsr #4"),
    (b"\x21\x02\x70\x20", "rsbscs r0, r1, lsr #4"),
    (b"\x21\x02\x70\x30", "rsbscc r0, r1, lsr #4"),
    (b"\x21\x02\x70\x40", "rsbsmi r0, r1, lsr #4"),
    (b"\x21\x02\x70\x50", "rsbspl r0, r1, lsr #4"),
    (b"\x21\x02\x70\x60", "rsbsvs r0, r1, lsr #4"),
    (b"\x21\x02\x70\x70", "rsbsvc r0, r1, lsr #4"),
    (b"\x21\x02\x70\x80", "rsbshi r0, r1, lsr #4"),
    (b"\x21\x02\x70\x90", "rsbsls r0, r1, lsr #4"),
    (b"\x21\x02\x70\xa0", "rsbsge r0, r1, lsr #4"),
    (b"\x21\x02\x70\xb0", "rsbslt r0, r1, lsr #4"),
    (b"\x21\x02\x70\xc0", "rsbsgt r0, r1, lsr #4"),
    (b"\x21\x02\x70\xd0", "rsbsle r0, r1, lsr #4"),
    (b"\x21\x02\x70\xe0", "rsbsal r0, r1, lsr #4"),

    (b"\x31\x03\x70\x00", "rsbseq r0, r1, lsr r3"),
    (b"\x31\x03\x70\x10", "rsbsne r0, r1, lsr r3"),
    (b"\x31\x03\x70\x20", "rsbscs r0, r1, lsr r3"),
    (b"\x31\x03\x70\x30", "rsbscc r0, r1, lsr r3"),
    (b"\x31\x03\x70\x40", "rsbsmi r0, r1, lsr r3"),
    (b"\x31\x03\x70\x50", "rsbspl r0, r1, lsr r3"),
    (b"\x31\x03\x70\x60", "rsbsvs r0, r1, lsr r3"),
    (b"\x31\x03\x70\x70", "rsbsvc r0, r1, lsr r3"),
    (b"\x31\x03\x70\x80", "rsbshi r0, r1, lsr r3"),
    (b"\x31\x03\x70\x90", "rsbsls r0, r1, lsr r3"),
    (b"\x31\x03\x70\xa0", "rsbsge r0, r1, lsr r3"),
    (b"\x31\x03\x70\xb0", "rsbslt r0, r1, lsr r3"),
    (b"\x31\x03\x70\xc0", "rsbsgt r0, r1, lsr r3"),
    (b"\x31\x03\x70\xd0", "rsbsle r0, r1, lsr r3"),
    (b"\x31\x03\x70\xe0", "rsbsal r0, r1, lsr r3"),

    (b"\x61\x02\x70\x00", "rsbseq r0, r1, ror #4"),
    (b"\x61\x02\x70\x10", "rsbsne r0, r1, ror #4"),
    (b"\x61\x02\x70\x20", "rsbscs r0, r1, ror #4"),
    (b"\x61\x02\x70\x30", "rsbscc r0, r1, ror #4"),
    (b"\x61\x02\x70\x40", "rsbsmi r0, r1, ror #4"),
    (b"\x61\x02\x70\x50", "rsbspl r0, r1, ror #4"),
    (b"\x61\x02\x70\x60", "rsbsvs r0, r1, ror #4"),
    (b"\x61\x02\x70\x70", "rsbsvc r0, r1, ror #4"),
    (b"\x61\x02\x70\x80", "rsbshi r0, r1, ror #4"),
    (b"\x61\x02\x70\x90", "rsbsls r0, r1, ror #4"),
    (b"\x61\x02\x70\xa0", "rsbsge r0, r1, ror #4"),
    (b"\x61\x02\x70\xb0", "rsbslt r0, r1, ror #4"),
    (b"\x61\x02\x70\xc0", "rsbsgt r0, r1, ror #4"),
    (b"\x61\x02\x70\xd0", "rsbsle r0, r1, ror #4"),
    (b"\x61\x02\x70\xe0", "rsbsal r0, r1, ror #4"),

    (b"\x71\x03\x70\x00", "rsbseq r0, r1, ror r3"),
    (b"\x71\x03\x70\x10", "rsbsne r0, r1, ror r3"),
    (b"\x71\x03\x70\x20", "rsbscs r0, r1, ror r3"),
    (b"\x71\x03\x70\x30", "rsbscc r0, r1, ror r3"),
    (b"\x71\x03\x70\x40", "rsbsmi r0, r1, ror r3"),
    (b"\x71\x03\x70\x50", "rsbspl r0, r1, ror r3"),
    (b"\x71\x03\x70\x60", "rsbsvs r0, r1, ror r3"),
    (b"\x71\x03\x70\x70", "rsbsvc r0, r1, ror r3"),
    (b"\x71\x03\x70\x80", "rsbshi r0, r1, ror r3"),
    (b"\x71\x03\x70\x90", "rsbsls r0, r1, ror r3"),
    (b"\x71\x03\x70\xa0", "rsbsge r0, r1, ror r3"),
    (b"\x71\x03\x70\xb0", "rsbslt r0, r1, ror r3"),
    (b"\x71\x03\x70\xc0", "rsbsgt r0, r1, ror r3"),
    (b"\x71\x03\x70\xd0", "rsbsle r0, r1, ror r3"),
    (b"\x71\x03\x70\xe0", "rsbsal r0, r1, ror r3"),

    (b"\x61\x00\x70\x00", "rsbseq r0, r1, rrx"),
    (b"\x61\x00\x70\x10", "rsbsne r0, r1, rrx"),
    (b"\x61\x00\x70\x20", "rsbscs r0, r1, rrx"),
    (b"\x61\x00\x70\x30", "rsbscc r0, r1, rrx"),
    (b"\x61\x00\x70\x40", "rsbsmi r0, r1, rrx"),
    (b"\x61\x00\x70\x50", "rsbspl r0, r1, rrx"),
    (b"\x61\x00\x70\x60", "rsbsvs r0, r1, rrx"),
    (b"\x61\x00\x70\x70", "rsbsvc r0, r1, rrx"),
    (b"\x61\x00\x70\x80", "rsbshi r0, r1, rrx"),
    (b"\x61\x00\x70\x90", "rsbsls r0, r1, rrx"),
    (b"\x61\x00\x70\xa0", "rsbsge r0, r1, rrx"),
    (b"\x61\x00\x70\xb0", "rsbslt r0, r1, rrx"),
    (b"\x61\x00\x70\xc0", "rsbsgt r0, r1, rrx"),
    (b"\x61\x00\x70\xd0", "rsbsle r0, r1, rrx"),
    (b"\x61\x00\x70\xe0", "rsbsal r0, r1, rrx"),

    # RSC -------------------------------------------------------------------- #
    (b"\x02\x00\xe1\xe2", "rsc r0, r1, #2"),
    (b"\x02\x00\xe1\x02", "rsceq r0, r1, #2"),
    (b"\x02\x00\xe1\x12", "rscne r0, r1, #2"),
    (b"\x02\x00\xe1\x22", "rsccs r0, r1, #2"),
    (b"\x02\x00\xe1\x32", "rsccc r0, r1, #2"),
    (b"\x02\x00\xe1\x42", "rscmi r0, r1, #2"),
    (b"\x02\x00\xe1\x52", "rscpl r0, r1, #2"),
    (b"\x02\x00\xe1\x62", "rscvs r0, r1, #2"),
    (b"\x02\x00\xe1\x72", "rscvc r0, r1, #2"),
    (b"\x02\x00\xe1\x82", "rschi r0, r1, #2"),
    (b"\x02\x00\xe1\x92", "rscls r0, r1, #2"),
    (b"\x02\x00\xe1\xa2", "rscge r0, r1, #2"),
    (b"\x02\x00\xe1\xb2", "rsclt r0, r1, #2"),
    (b"\x02\x00\xe1\xc2", "rscgt r0, r1, #2"),
    (b"\x02\x00\xe1\xd2", "rscle r0, r1, #2"),
    (b"\x02\x00\xe1\xe2", "rscal r0, r1, #2"),

    (b"\x03\x00\xe1\xe0", "rsc r0, r1, r3"),
    (b"\x03\x00\xe1\x00", "rsceq r0, r1, r3"),
    (b"\x03\x00\xe1\x10", "rscne r0, r1, r3"),
    (b"\x03\x00\xe1\x20", "rsccs r0, r1, r3"),
    (b"\x03\x00\xe1\x30", "rsccc r0, r1, r3"),
    (b"\x03\x00\xe1\x40", "rscmi r0, r1, r3"),
    (b"\x03\x00\xe1\x50", "rscpl r0, r1, r3"),
    (b"\x03\x00\xe1\x60", "rscvs r0, r1, r3"),
    (b"\x03\x00\xe1\x70", "rscvc r0, r1, r3"),
    (b"\x03\x00\xe1\x80", "rschi r0, r1, r3"),
    (b"\x03\x00\xe1\x90", "rscls r0, r1, r3"),
    (b"\x03\x00\xe1\xa0", "rscge r0, r1, r3"),
    (b"\x03\x00\xe1\xb0", "rsclt r0, r1, r3"),
    (b"\x03\x00\xe1\xc0", "rscgt r0, r1, r3"),
    (b"\x03\x00\xe1\xd0", "rscle r0, r1, r3"),
    (b"\x03\x00\xe1\xe0", "rscal r0, r1, r3"),

    # RSCS ------------------------------------------------------------------- #
    (b"\x02\x00\xf1\xe2", "rscs r0, r1, #2"),
    (b"\x02\x00\xf1\x02", "rscseq r0, r1, #2"),
    (b"\x02\x00\xf1\x12", "rscsne r0, r1, #2"),
    (b"\x02\x00\xf1\x22", "rscscs r0, r1, #2"),
    (b"\x02\x00\xf1\x32", "rscscc r0, r1, #2"),
    (b"\x02\x00\xf1\x42", "rscsmi r0, r1, #2"),
    (b"\x02\x00\xf1\x52", "rscspl r0, r1, #2"),
    (b"\x02\x00\xf1\x62", "rscsvs r0, r1, #2"),
    (b"\x02\x00\xf1\x72", "rscsvc r0, r1, #2"),
    (b"\x02\x00\xf1\x82", "rscshi r0, r1, #2"),
    (b"\x02\x00\xf1\x92", "rscsls r0, r1, #2"),
    (b"\x02\x00\xf1\xa2", "rscsge r0, r1, #2"),
    (b"\x02\x00\xf1\xb2", "rscslt r0, r1, #2"),
    (b"\x02\x00\xf1\xc2", "rscsgt r0, r1, #2"),
    (b"\x02\x00\xf1\xd2", "rscsle r0, r1, #2"),
    (b"\x02\x00\xf1\xe2", "rscsal r0, r1, #2"),

    (b"\x03\x00\xf1\xe0", "rscs r0, r1, r3"),
    (b"\x03\x00\xf1\x00", "rscseq r0, r1, r3"),
    (b"\x03\x00\xf1\x10", "rscsne r0, r1, r3"),
    (b"\x03\x00\xf1\x20", "rscscs r0, r1, r3"),
    (b"\x03\x00\xf1\x30", "rscscc r0, r1, r3"),
    (b"\x03\x00\xf1\x40", "rscsmi r0, r1, r3"),
    (b"\x03\x00\xf1\x50", "rscspl r0, r1, r3"),
    (b"\x03\x00\xf1\x60", "rscsvs r0, r1, r3"),
    (b"\x03\x00\xf1\x70", "rscsvc r0, r1, r3"),
    (b"\x03\x00\xf1\x80", "rscshi r0, r1, r3"),
    (b"\x03\x00\xf1\x90", "rscsls r0, r1, r3"),
    (b"\x03\x00\xf1\xa0", "rscsge r0, r1, r3"),
    (b"\x03\x00\xf1\xb0", "rscslt r0, r1, r3"),
    (b"\x03\x00\xf1\xc0", "rscsgt r0, r1, r3"),
    (b"\x03\x00\xf1\xd0", "rscsle r0, r1, r3"),
    (b"\x03\x00\xf1\xe0", "rscsal r0, r1, r3"),

    (b"\x02\x00\xf1\xe2", "rscs r0, r1, #2"),
    (b"\x02\x00\xf1\x02", "rscseq r0, r1, #2"),
    (b"\x02\x00\xf1\x12", "rscsne r0, r1, #2"),
    (b"\x02\x00\xf1\x22", "rscscs r0, r1, #2"),
    (b"\x02\x00\xf1\x32", "rscscc r0, r1, #2"),
    (b"\x02\x00\xf1\x42", "rscsmi r0, r1, #2"),
    (b"\x02\x00\xf1\x52", "rscspl r0, r1, #2"),
    (b"\x02\x00\xf1\x62", "rscsvs r0, r1, #2"),
    (b"\x02\x00\xf1\x72", "rscsvc r0, r1, #2"),
    (b"\x02\x00\xf1\x82", "rscshi r0, r1, #2"),
    (b"\x02\x00\xf1\x92", "rscsls r0, r1, #2"),
    (b"\x02\x00\xf1\xa2", "rscsge r0, r1, #2"),
    (b"\x02\x00\xf1\xb2", "rscslt r0, r1, #2"),
    (b"\x02\x00\xf1\xc2", "rscsgt r0, r1, #2"),
    (b"\x02\x00\xf1\xd2", "rscsle r0, r1, #2"),
    (b"\x02\x00\xf1\xe2", "rscsal r0, r1, #2"),

    (b"\x03\x00\xf1\xe0", "rscs r0, r1, r3"),
    (b"\x03\x00\xf1\x00", "rscseq r0, r1, r3"),
    (b"\x03\x00\xf1\x10", "rscsne r0, r1, r3"),
    (b"\x03\x00\xf1\x20", "rscscs r0, r1, r3"),
    (b"\x03\x00\xf1\x30", "rscscc r0, r1, r3"),
    (b"\x03\x00\xf1\x40", "rscsmi r0, r1, r3"),
    (b"\x03\x00\xf1\x50", "rscspl r0, r1, r3"),
    (b"\x03\x00\xf1\x60", "rscsvs r0, r1, r3"),
    (b"\x03\x00\xf1\x70", "rscsvc r0, r1, r3"),
    (b"\x03\x00\xf1\x80", "rscshi r0, r1, r3"),
    (b"\x03\x00\xf1\x90", "rscsls r0, r1, r3"),
    (b"\x03\x00\xf1\xa0", "rscsge r0, r1, r3"),
    (b"\x03\x00\xf1\xb0", "rscslt r0, r1, r3"),
    (b"\x03\x00\xf1\xc0", "rscsgt r0, r1, r3"),
    (b"\x03\x00\xf1\xd0", "rscsle r0, r1, r3"),
    (b"\x03\x00\xf1\xe0", "rscsal r0, r1, r3"),

    (b"\x41\x02\xf0\x00", "rscseq r0, r1, asr #4"),
    (b"\x41\x02\xf0\x10", "rscsne r0, r1, asr #4"),
    (b"\x41\x02\xf0\x20", "rscscs r0, r1, asr #4"),
    (b"\x41\x02\xf0\x30", "rscscc r0, r1, asr #4"),
    (b"\x41\x02\xf0\x40", "rscsmi r0, r1, asr #4"),
    (b"\x41\x02\xf0\x50", "rscspl r0, r1, asr #4"),
    (b"\x41\x02\xf0\x60", "rscsvs r0, r1, asr #4"),
    (b"\x41\x02\xf0\x70", "rscsvc r0, r1, asr #4"),
    (b"\x41\x02\xf0\x80", "rscshi r0, r1, asr #4"),
    (b"\x41\x02\xf0\x90", "rscsls r0, r1, asr #4"),
    (b"\x41\x02\xf0\xa0", "rscsge r0, r1, asr #4"),
    (b"\x41\x02\xf0\xb0", "rscslt r0, r1, asr #4"),
    (b"\x41\x02\xf0\xc0", "rscsgt r0, r1, asr #4"),
    (b"\x41\x02\xf0\xd0", "rscsle r0, r1, asr #4"),
    (b"\x41\x02\xf0\xe0", "rscsal r0, r1, asr #4"),

    (b"\x51\x03\xf0\x00", "rscseq r0, r1, asr r3"),
    (b"\x51\x03\xf0\x10", "rscsne r0, r1, asr r3"),
    (b"\x51\x03\xf0\x20", "rscscs r0, r1, asr r3"),
    (b"\x51\x03\xf0\x30", "rscscc r0, r1, asr r3"),
    (b"\x51\x03\xf0\x40", "rscsmi r0, r1, asr r3"),
    (b"\x51\x03\xf0\x50", "rscspl r0, r1, asr r3"),
    (b"\x51\x03\xf0\x60", "rscsvs r0, r1, asr r3"),
    (b"\x51\x03\xf0\x70", "rscsvc r0, r1, asr r3"),
    (b"\x51\x03\xf0\x80", "rscshi r0, r1, asr r3"),
    (b"\x51\x03\xf0\x90", "rscsls r0, r1, asr r3"),
    (b"\x51\x03\xf0\xa0", "rscsge r0, r1, asr r3"),
    (b"\x51\x03\xf0\xb0", "rscslt r0, r1, asr r3"),
    (b"\x51\x03\xf0\xc0", "rscsgt r0, r1, asr r3"),
    (b"\x51\x03\xf0\xd0", "rscsle r0, r1, asr r3"),
    (b"\x51\x03\xf0\xe0", "rscsal r0, r1, asr r3"),

    (b"\x01\x02\xf0\x00", "rscseq r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x10", "rscsne r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x20", "rscscs r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x30", "rscscc r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x40", "rscsmi r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x50", "rscspl r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x60", "rscsvs r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x70", "rscsvc r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x80", "rscshi r0, r1, lsl #4"),
    (b"\x01\x02\xf0\x90", "rscsls r0, r1, lsl #4"),
    (b"\x01\x02\xf0\xa0", "rscsge r0, r1, lsl #4"),
    (b"\x01\x02\xf0\xb0", "rscslt r0, r1, lsl #4"),
    (b"\x01\x02\xf0\xc0", "rscsgt r0, r1, lsl #4"),
    (b"\x01\x02\xf0\xd0", "rscsle r0, r1, lsl #4"),
    (b"\x01\x02\xf0\xe0", "rscsal r0, r1, lsl #4"),

    (b"\x11\x03\xf0\x00", "rscseq r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x10", "rscsne r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x20", "rscscs r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x30", "rscscc r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x40", "rscsmi r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x50", "rscspl r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x60", "rscsvs r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x70", "rscsvc r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x80", "rscshi r0, r1, lsl r3"),
    (b"\x11\x03\xf0\x90", "rscsls r0, r1, lsl r3"),
    (b"\x11\x03\xf0\xa0", "rscsge r0, r1, lsl r3"),
    (b"\x11\x03\xf0\xb0", "rscslt r0, r1, lsl r3"),
    (b"\x11\x03\xf0\xc0", "rscsgt r0, r1, lsl r3"),
    (b"\x11\x03\xf0\xd0", "rscsle r0, r1, lsl r3"),
    (b"\x11\x03\xf0\xe0", "rscsal r0, r1, lsl r3"),

    (b"\x21\x02\xf0\x00", "rscseq r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x10", "rscsne r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x20", "rscscs r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x30", "rscscc r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x40", "rscsmi r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x50", "rscspl r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x60", "rscsvs r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x70", "rscsvc r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x80", "rscshi r0, r1, lsr #4"),
    (b"\x21\x02\xf0\x90", "rscsls r0, r1, lsr #4"),
    (b"\x21\x02\xf0\xa0", "rscsge r0, r1, lsr #4"),
    (b"\x21\x02\xf0\xb0", "rscslt r0, r1, lsr #4"),
    (b"\x21\x02\xf0\xc0", "rscsgt r0, r1, lsr #4"),
    (b"\x21\x02\xf0\xd0", "rscsle r0, r1, lsr #4"),
    (b"\x21\x02\xf0\xe0", "rscsal r0, r1, lsr #4"),

    (b"\x31\x03\xf0\x00", "rscseq r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x10", "rscsne r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x20", "rscscs r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x30", "rscscc r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x40", "rscsmi r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x50", "rscspl r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x60", "rscsvs r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x70", "rscsvc r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x80", "rscshi r0, r1, lsr r3"),
    (b"\x31\x03\xf0\x90", "rscsls r0, r1, lsr r3"),
    (b"\x31\x03\xf0\xa0", "rscsge r0, r1, lsr r3"),
    (b"\x31\x03\xf0\xb0", "rscslt r0, r1, lsr r3"),
    (b"\x31\x03\xf0\xc0", "rscsgt r0, r1, lsr r3"),
    (b"\x31\x03\xf0\xd0", "rscsle r0, r1, lsr r3"),
    (b"\x31\x03\xf0\xe0", "rscsal r0, r1, lsr r3"),

    (b"\x61\x02\xf0\x00", "rscseq r0, r1, ror #4"),
    (b"\x61\x02\xf0\x10", "rscsne r0, r1, ror #4"),
    (b"\x61\x02\xf0\x20", "rscscs r0, r1, ror #4"),
    (b"\x61\x02\xf0\x30", "rscscc r0, r1, ror #4"),
    (b"\x61\x02\xf0\x40", "rscsmi r0, r1, ror #4"),
    (b"\x61\x02\xf0\x50", "rscspl r0, r1, ror #4"),
    (b"\x61\x02\xf0\x60", "rscsvs r0, r1, ror #4"),
    (b"\x61\x02\xf0\x70", "rscsvc r0, r1, ror #4"),
    (b"\x61\x02\xf0\x80", "rscshi r0, r1, ror #4"),
    (b"\x61\x02\xf0\x90", "rscsls r0, r1, ror #4"),
    (b"\x61\x02\xf0\xa0", "rscsge r0, r1, ror #4"),
    (b"\x61\x02\xf0\xb0", "rscslt r0, r1, ror #4"),
    (b"\x61\x02\xf0\xc0", "rscsgt r0, r1, ror #4"),
    (b"\x61\x02\xf0\xd0", "rscsle r0, r1, ror #4"),
    (b"\x61\x02\xf0\xe0", "rscsal r0, r1, ror #4"),

    (b"\x71\x03\xf0\x00", "rscseq r0, r1, ror r3"),
    (b"\x71\x03\xf0\x10", "rscsne r0, r1, ror r3"),
    (b"\x71\x03\xf0\x20", "rscscs r0, r1, ror r3"),
    (b"\x71\x03\xf0\x30", "rscscc r0, r1, ror r3"),
    (b"\x71\x03\xf0\x40", "rscsmi r0, r1, ror r3"),
    (b"\x71\x03\xf0\x50", "rscspl r0, r1, ror r3"),
    (b"\x71\x03\xf0\x60", "rscsvs r0, r1, ror r3"),
    (b"\x71\x03\xf0\x70", "rscsvc r0, r1, ror r3"),
    (b"\x71\x03\xf0\x80", "rscshi r0, r1, ror r3"),
    (b"\x71\x03\xf0\x90", "rscsls r0, r1, ror r3"),
    (b"\x71\x03\xf0\xa0", "rscsge r0, r1, ror r3"),
    (b"\x71\x03\xf0\xb0", "rscslt r0, r1, ror r3"),
    (b"\x71\x03\xf0\xc0", "rscsgt r0, r1, ror r3"),
    (b"\x71\x03\xf0\xd0", "rscsle r0, r1, ror r3"),
    (b"\x71\x03\xf0\xe0", "rscsal r0, r1, ror r3"),

    (b"\x61\x00\xf0\x00", "rscseq r0, r1, rrx"),
    (b"\x61\x00\xf0\x10", "rscsne r0, r1, rrx"),
    (b"\x61\x00\xf0\x20", "rscscs r0, r1, rrx"),
    (b"\x61\x00\xf0\x30", "rscscc r0, r1, rrx"),
    (b"\x61\x00\xf0\x40", "rscsmi r0, r1, rrx"),
    (b"\x61\x00\xf0\x50", "rscspl r0, r1, rrx"),
    (b"\x61\x00\xf0\x60", "rscsvs r0, r1, rrx"),
    (b"\x61\x00\xf0\x70", "rscsvc r0, r1, rrx"),
    (b"\x61\x00\xf0\x80", "rscshi r0, r1, rrx"),
    (b"\x61\x00\xf0\x90", "rscsls r0, r1, rrx"),
    (b"\x61\x00\xf0\xa0", "rscsge r0, r1, rrx"),
    (b"\x61\x00\xf0\xb0", "rscslt r0, r1, rrx"),
    (b"\x61\x00\xf0\xc0", "rscsgt r0, r1, rrx"),
    (b"\x61\x00\xf0\xd0", "rscsle r0, r1, rrx"),
    (b"\x61\x00\xf0\xe0", "rscsal r0, r1, rrx"),

    # SBC -------------------------------------------------------------------- #
    (b"\x02\x00\xc1\xe2", "sbc r0, r1, #2"),
    (b"\x02\x00\xc1\x02", "sbceq r0, r1, #2"),
    (b"\x02\x00\xc1\x12", "sbcne r0, r1, #2"),
    (b"\x02\x00\xc1\x22", "sbccs r0, r1, #2"),
    (b"\x02\x00\xc1\x32", "sbccc r0, r1, #2"),
    (b"\x02\x00\xc1\x42", "sbcmi r0, r1, #2"),
    (b"\x02\x00\xc1\x52", "sbcpl r0, r1, #2"),
    (b"\x02\x00\xc1\x62", "sbcvs r0, r1, #2"),
    (b"\x02\x00\xc1\x72", "sbcvc r0, r1, #2"),
    (b"\x02\x00\xc1\x82", "sbchi r0, r1, #2"),
    (b"\x02\x00\xc1\x92", "sbcls r0, r1, #2"),
    (b"\x02\x00\xc1\xa2", "sbcge r0, r1, #2"),
    (b"\x02\x00\xc1\xb2", "sbclt r0, r1, #2"),
    (b"\x02\x00\xc1\xc2", "sbcgt r0, r1, #2"),
    (b"\x02\x00\xc1\xd2", "sbcle r0, r1, #2"),
    (b"\x02\x00\xc1\xe2", "sbcal r0, r1, #2"),

    (b"\x03\x00\xc1\xe0", "sbc r0, r1, r3"),
    (b"\x03\x00\xc1\x00", "sbceq r0, r1, r3"),
    (b"\x03\x00\xc1\x10", "sbcne r0, r1, r3"),
    (b"\x03\x00\xc1\x20", "sbccs r0, r1, r3"),
    (b"\x03\x00\xc1\x30", "sbccc r0, r1, r3"),
    (b"\x03\x00\xc1\x40", "sbcmi r0, r1, r3"),
    (b"\x03\x00\xc1\x50", "sbcpl r0, r1, r3"),
    (b"\x03\x00\xc1\x60", "sbcvs r0, r1, r3"),
    (b"\x03\x00\xc1\x70", "sbcvc r0, r1, r3"),
    (b"\x03\x00\xc1\x80", "sbchi r0, r1, r3"),
    (b"\x03\x00\xc1\x90", "sbcls r0, r1, r3"),
    (b"\x03\x00\xc1\xa0", "sbcge r0, r1, r3"),
    (b"\x03\x00\xc1\xb0", "sbclt r0, r1, r3"),
    (b"\x03\x00\xc1\xc0", "sbcgt r0, r1, r3"),
    (b"\x03\x00\xc1\xd0", "sbcle r0, r1, r3"),
    (b"\x03\x00\xc1\xe0", "sbcal r0, r1, r3"),

    # SBCS ------------------------------------------------------------------- #
    (b"\x02\x00\xd1\xe2", "sbcs r0, r1, #2"),
    (b"\x02\x00\xd1\x02", "sbcseq r0, r1, #2"),
    (b"\x02\x00\xd1\x12", "sbcsne r0, r1, #2"),
    (b"\x02\x00\xd1\x22", "sbcscs r0, r1, #2"),
    (b"\x02\x00\xd1\x32", "sbcscc r0, r1, #2"),
    (b"\x02\x00\xd1\x42", "sbcsmi r0, r1, #2"),
    (b"\x02\x00\xd1\x52", "sbcspl r0, r1, #2"),
    (b"\x02\x00\xd1\x62", "sbcsvs r0, r1, #2"),
    (b"\x02\x00\xd1\x72", "sbcsvc r0, r1, #2"),
    (b"\x02\x00\xd1\x82", "sbcshi r0, r1, #2"),
    (b"\x02\x00\xd1\x92", "sbcsls r0, r1, #2"),
    (b"\x02\x00\xd1\xa2", "sbcsge r0, r1, #2"),
    (b"\x02\x00\xd1\xb2", "sbcslt r0, r1, #2"),
    (b"\x02\x00\xd1\xc2", "sbcsgt r0, r1, #2"),
    (b"\x02\x00\xd1\xd2", "sbcsle r0, r1, #2"),
    (b"\x02\x00\xd1\xe2", "sbcsal r0, r1, #2"),

    (b"\x03\x00\xd1\xe0", "sbcs r0, r1, r3"),
    (b"\x03\x00\xd1\x00", "sbcseq r0, r1, r3"),
    (b"\x03\x00\xd1\x10", "sbcsne r0, r1, r3"),
    (b"\x03\x00\xd1\x20", "sbcscs r0, r1, r3"),
    (b"\x03\x00\xd1\x30", "sbcscc r0, r1, r3"),
    (b"\x03\x00\xd1\x40", "sbcsmi r0, r1, r3"),
    (b"\x03\x00\xd1\x50", "sbcspl r0, r1, r3"),
    (b"\x03\x00\xd1\x60", "sbcsvs r0, r1, r3"),
    (b"\x03\x00\xd1\x70", "sbcsvc r0, r1, r3"),
    (b"\x03\x00\xd1\x80", "sbcshi r0, r1, r3"),
    (b"\x03\x00\xd1\x90", "sbcsls r0, r1, r3"),
    (b"\x03\x00\xd1\xa0", "sbcsge r0, r1, r3"),
    (b"\x03\x00\xd1\xb0", "sbcslt r0, r1, r3"),
    (b"\x03\x00\xd1\xc0", "sbcsgt r0, r1, r3"),
    (b"\x03\x00\xd1\xd0", "sbcsle r0, r1, r3"),
    (b"\x03\x00\xd1\xe0", "sbcsal r0, r1, r3"),

    (b"\x41\x02\xd0\x00", "sbcseq r0, r1, asr #4"),
    (b"\x41\x02\xd0\x10", "sbcsne r0, r1, asr #4"),
    (b"\x41\x02\xd0\x20", "sbcscs r0, r1, asr #4"),
    (b"\x41\x02\xd0\x30", "sbcscc r0, r1, asr #4"),
    (b"\x41\x02\xd0\x40", "sbcsmi r0, r1, asr #4"),
    (b"\x41\x02\xd0\x50", "sbcspl r0, r1, asr #4"),
    (b"\x41\x02\xd0\x60", "sbcsvs r0, r1, asr #4"),
    (b"\x41\x02\xd0\x70", "sbcsvc r0, r1, asr #4"),
    (b"\x41\x02\xd0\x80", "sbcshi r0, r1, asr #4"),
    (b"\x41\x02\xd0\x90", "sbcsls r0, r1, asr #4"),
    (b"\x41\x02\xd0\xa0", "sbcsge r0, r1, asr #4"),
    (b"\x41\x02\xd0\xb0", "sbcslt r0, r1, asr #4"),
    (b"\x41\x02\xd0\xc0", "sbcsgt r0, r1, asr #4"),
    (b"\x41\x02\xd0\xd0", "sbcsle r0, r1, asr #4"),
    (b"\x41\x02\xd0\xe0", "sbcsal r0, r1, asr #4"),

    (b"\x51\x03\xd0\x00", "sbcseq r0, r1, asr r3"),
    (b"\x51\x03\xd0\x10", "sbcsne r0, r1, asr r3"),
    (b"\x51\x03\xd0\x20", "sbcscs r0, r1, asr r3"),
    (b"\x51\x03\xd0\x30", "sbcscc r0, r1, asr r3"),
    (b"\x51\x03\xd0\x40", "sbcsmi r0, r1, asr r3"),
    (b"\x51\x03\xd0\x50", "sbcspl r0, r1, asr r3"),
    (b"\x51\x03\xd0\x60", "sbcsvs r0, r1, asr r3"),
    (b"\x51\x03\xd0\x70", "sbcsvc r0, r1, asr r3"),
    (b"\x51\x03\xd0\x80", "sbcshi r0, r1, asr r3"),
    (b"\x51\x03\xd0\x90", "sbcsls r0, r1, asr r3"),
    (b"\x51\x03\xd0\xa0", "sbcsge r0, r1, asr r3"),
    (b"\x51\x03\xd0\xb0", "sbcslt r0, r1, asr r3"),
    (b"\x51\x03\xd0\xc0", "sbcsgt r0, r1, asr r3"),
    (b"\x51\x03\xd0\xd0", "sbcsle r0, r1, asr r3"),
    (b"\x51\x03\xd0\xe0", "sbcsal r0, r1, asr r3"),

    (b"\x01\x02\xd0\x00", "sbcseq r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x10", "sbcsne r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x20", "sbcscs r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x30", "sbcscc r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x40", "sbcsmi r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x50", "sbcspl r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x60", "sbcsvs r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x70", "sbcsvc r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x80", "sbcshi r0, r1, lsl #4"),
    (b"\x01\x02\xd0\x90", "sbcsls r0, r1, lsl #4"),
    (b"\x01\x02\xd0\xa0", "sbcsge r0, r1, lsl #4"),
    (b"\x01\x02\xd0\xb0", "sbcslt r0, r1, lsl #4"),
    (b"\x01\x02\xd0\xc0", "sbcsgt r0, r1, lsl #4"),
    (b"\x01\x02\xd0\xd0", "sbcsle r0, r1, lsl #4"),
    (b"\x01\x02\xd0\xe0", "sbcsal r0, r1, lsl #4"),

    (b"\x11\x03\xd0\x00", "sbcseq r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x10", "sbcsne r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x20", "sbcscs r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x30", "sbcscc r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x40", "sbcsmi r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x50", "sbcspl r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x60", "sbcsvs r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x70", "sbcsvc r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x80", "sbcshi r0, r1, lsl r3"),
    (b"\x11\x03\xd0\x90", "sbcsls r0, r1, lsl r3"),
    (b"\x11\x03\xd0\xa0", "sbcsge r0, r1, lsl r3"),
    (b"\x11\x03\xd0\xb0", "sbcslt r0, r1, lsl r3"),
    (b"\x11\x03\xd0\xc0", "sbcsgt r0, r1, lsl r3"),
    (b"\x11\x03\xd0\xd0", "sbcsle r0, r1, lsl r3"),
    (b"\x11\x03\xd0\xe0", "sbcsal r0, r1, lsl r3"),

    (b"\x21\x02\xd0\x00", "sbcseq r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x10", "sbcsne r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x20", "sbcscs r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x30", "sbcscc r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x40", "sbcsmi r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x50", "sbcspl r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x60", "sbcsvs r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x70", "sbcsvc r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x80", "sbcshi r0, r1, lsr #4"),
    (b"\x21\x02\xd0\x90", "sbcsls r0, r1, lsr #4"),
    (b"\x21\x02\xd0\xa0", "sbcsge r0, r1, lsr #4"),
    (b"\x21\x02\xd0\xb0", "sbcslt r0, r1, lsr #4"),
    (b"\x21\x02\xd0\xc0", "sbcsgt r0, r1, lsr #4"),
    (b"\x21\x02\xd0\xd0", "sbcsle r0, r1, lsr #4"),
    (b"\x21\x02\xd0\xe0", "sbcsal r0, r1, lsr #4"),

    (b"\x31\x03\xd0\x00", "sbcseq r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x10", "sbcsne r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x20", "sbcscs r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x30", "sbcscc r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x40", "sbcsmi r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x50", "sbcspl r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x60", "sbcsvs r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x70", "sbcsvc r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x80", "sbcshi r0, r1, lsr r3"),
    (b"\x31\x03\xd0\x90", "sbcsls r0, r1, lsr r3"),
    (b"\x31\x03\xd0\xa0", "sbcsge r0, r1, lsr r3"),
    (b"\x31\x03\xd0\xb0", "sbcslt r0, r1, lsr r3"),
    (b"\x31\x03\xd0\xc0", "sbcsgt r0, r1, lsr r3"),
    (b"\x31\x03\xd0\xd0", "sbcsle r0, r1, lsr r3"),
    (b"\x31\x03\xd0\xe0", "sbcsal r0, r1, lsr r3"),

    (b"\x61\x02\xd0\x00", "sbcseq r0, r1, ror #4"),
    (b"\x61\x02\xd0\x10", "sbcsne r0, r1, ror #4"),
    (b"\x61\x02\xd0\x20", "sbcscs r0, r1, ror #4"),
    (b"\x61\x02\xd0\x30", "sbcscc r0, r1, ror #4"),
    (b"\x61\x02\xd0\x40", "sbcsmi r0, r1, ror #4"),
    (b"\x61\x02\xd0\x50", "sbcspl r0, r1, ror #4"),
    (b"\x61\x02\xd0\x60", "sbcsvs r0, r1, ror #4"),
    (b"\x61\x02\xd0\x70", "sbcsvc r0, r1, ror #4"),
    (b"\x61\x02\xd0\x80", "sbcshi r0, r1, ror #4"),
    (b"\x61\x02\xd0\x90", "sbcsls r0, r1, ror #4"),
    (b"\x61\x02\xd0\xa0", "sbcsge r0, r1, ror #4"),
    (b"\x61\x02\xd0\xb0", "sbcslt r0, r1, ror #4"),
    (b"\x61\x02\xd0\xc0", "sbcsgt r0, r1, ror #4"),
    (b"\x61\x02\xd0\xd0", "sbcsle r0, r1, ror #4"),
    (b"\x61\x02\xd0\xe0", "sbcsal r0, r1, ror #4"),

    (b"\x71\x03\xd0\x00", "sbcseq r0, r1, ror r3"),
    (b"\x71\x03\xd0\x10", "sbcsne r0, r1, ror r3"),
    (b"\x71\x03\xd0\x20", "sbcscs r0, r1, ror r3"),
    (b"\x71\x03\xd0\x30", "sbcscc r0, r1, ror r3"),
    (b"\x71\x03\xd0\x40", "sbcsmi r0, r1, ror r3"),
    (b"\x71\x03\xd0\x50", "sbcspl r0, r1, ror r3"),
    (b"\x71\x03\xd0\x60", "sbcsvs r0, r1, ror r3"),
    (b"\x71\x03\xd0\x70", "sbcsvc r0, r1, ror r3"),
    (b"\x71\x03\xd0\x80", "sbcshi r0, r1, ror r3"),
    (b"\x71\x03\xd0\x90", "sbcsls r0, r1, ror r3"),
    (b"\x71\x03\xd0\xa0", "sbcsge r0, r1, ror r3"),
    (b"\x71\x03\xd0\xb0", "sbcslt r0, r1, ror r3"),
    (b"\x71\x03\xd0\xc0", "sbcsgt r0, r1, ror r3"),
    (b"\x71\x03\xd0\xd0", "sbcsle r0, r1, ror r3"),
    (b"\x71\x03\xd0\xe0", "sbcsal r0, r1, ror r3"),

    (b"\x61\x00\xd0\x00", "sbcseq r0, r1, rrx"),
    (b"\x61\x00\xd0\x10", "sbcsne r0, r1, rrx"),
    (b"\x61\x00\xd0\x20", "sbcscs r0, r1, rrx"),
    (b"\x61\x00\xd0\x30", "sbcscc r0, r1, rrx"),
    (b"\x61\x00\xd0\x40", "sbcsmi r0, r1, rrx"),
    (b"\x61\x00\xd0\x50", "sbcspl r0, r1, rrx"),
    (b"\x61\x00\xd0\x60", "sbcsvs r0, r1, rrx"),
    (b"\x61\x00\xd0\x70", "sbcsvc r0, r1, rrx"),
    (b"\x61\x00\xd0\x80", "sbcshi r0, r1, rrx"),
    (b"\x61\x00\xd0\x90", "sbcsls r0, r1, rrx"),
    (b"\x61\x00\xd0\xa0", "sbcsge r0, r1, rrx"),
    (b"\x61\x00\xd0\xb0", "sbcslt r0, r1, rrx"),
    (b"\x61\x00\xd0\xc0", "sbcsgt r0, r1, rrx"),
    (b"\x61\x00\xd0\xd0", "sbcsle r0, r1, rrx"),
    (b"\x61\x00\xd0\xe0", "sbcsal r0, r1, rrx"),

    (b"\xd1\x06\xa6\x07", "sbfxeq r0, r1, #13, #7"),
    (b"\xd1\x06\xa6\x17", "sbfxne r0, r1, #13, #7"),
    (b"\xd1\x06\xa6\x27", "sbfxcs r0, r1, #13, #7"),
    (b"\xd1\x06\xa6\x37", "sbfxcc r0, r1, #13, #7"),
    (b"\xd1\x06\xa6\x47", "sbfxmi r0, r1, #13, #7"),
    (b"\xd1\x06\xa6\x57", "sbfxpl r0, r1, #13, #7"),
    (b"\xd1\x06\xa6\x67", "sbfxvs r0, r1, #13, #7"),
    (b"\xd1\x06\xa6\x77", "sbfxvc r0, r1, #13, #7"),
    (b"\xd1\x06\xa6\x87", "sbfxhi r0, r1, #13, #7"),
    (b"\xd1\x06\xa6\x97", "sbfxls r0, r1, #13, #7"),
    (b"\xd1\x06\xa6\xa7", "sbfxge r0, r1, #13, #7"),
    (b"\xd1\x06\xa6\xb7", "sbfxlt r0, r1, #13, #7"),
    (b"\xd1\x06\xa6\xc7", "sbfxgt r0, r1, #13, #7"),
    (b"\xd1\x06\xa6\xd7", "sbfxle r0, r1, #13, #7"),
    (b"\xd1\x06\xa6\xe7", "sbfxal r0, r1, #13, #7"),
    (b"\xd1\x02\xb2\x07", "sbfxeq r0, r1, #5, #19"),
    (b"\xd1\x02\xb2\x17", "sbfxne r0, r1, #5, #19"),
    (b"\xd1\x02\xb2\x27", "sbfxcs r0, r1, #5, #19"),
    (b"\xd1\x02\xb2\x37", "sbfxcc r0, r1, #5, #19"),
    (b"\xd1\x02\xb2\x47", "sbfxmi r0, r1, #5, #19"),
    (b"\xd1\x02\xb2\x57", "sbfxpl r0, r1, #5, #19"),
    (b"\xd1\x02\xb2\x67", "sbfxvs r0, r1, #5, #19"),
    (b"\xd1\x02\xb2\x77", "sbfxvc r0, r1, #5, #19"),
    (b"\xd1\x02\xb2\x87", "sbfxhi r0, r1, #5, #19"),
    (b"\xd1\x02\xb2\x97", "sbfxls r0, r1, #5, #19"),
    (b"\xd1\x02\xb2\xa7", "sbfxge r0, r1, #5, #19"),
    (b"\xd1\x02\xb2\xb7", "sbfxlt r0, r1, #5, #19"),
    (b"\xd1\x02\xb2\xc7", "sbfxgt r0, r1, #5, #19"),
    (b"\xd1\x02\xb2\xd7", "sbfxle r0, r1, #5, #19"),
    (b"\xd1\x02\xb2\xe7", "sbfxal r0, r1, #5, #19"),

    # SMULL ------------------------------------------------------------------ #
    (b"\x92\x03\xc1\xe0", "smull r0, r1, r2, r3"),
    (b"\x92\x03\xc1\x00", "smulleq r0, r1, r2, r3"),
    (b"\x92\x03\xc1\x10", "smullne r0, r1, r2, r3"),
    (b"\x92\x03\xc1\x20", "smullcs r0, r1, r2, r3"),
    (b"\x92\x03\xc1\x30", "smullcc r0, r1, r2, r3"),
    (b"\x92\x03\xc1\x40", "smullmi r0, r1, r2, r3"),
    (b"\x92\x03\xc1\x50", "smullpl r0, r1, r2, r3"),
    (b"\x92\x03\xc1\x60", "smullvs r0, r1, r2, r3"),
    (b"\x92\x03\xc1\x70", "smullvc r0, r1, r2, r3"),
    (b"\x92\x03\xc1\x80", "smullhi r0, r1, r2, r3"),
    (b"\x92\x03\xc1\x90", "smullls r0, r1, r2, r3"),
    (b"\x92\x03\xc1\xa0", "smullge r0, r1, r2, r3"),
    (b"\x92\x03\xc1\xb0", "smulllt r0, r1, r2, r3"),
    (b"\x92\x03\xc1\xc0", "smullgt r0, r1, r2, r3"),
    (b"\x92\x03\xc1\xd0", "smullle r0, r1, r2, r3"),

    # SMULLS ----------------------------------------------------------------- #
    (b"\x92\x03\xd1\xe0", "smulls r0, r1, r2, r3"),
    (b"\x92\x03\xd1\x00", "smullseq r0, r1, r2, r3"),
    (b"\x92\x03\xd1\x10", "smullsne r0, r1, r2, r3"),
    (b"\x92\x03\xd1\x20", "smullscs r0, r1, r2, r3"),
    (b"\x92\x03\xd1\x30", "smullscc r0, r1, r2, r3"),
    (b"\x92\x03\xd1\x40", "smullsmi r0, r1, r2, r3"),
    (b"\x92\x03\xd1\x50", "smullspl r0, r1, r2, r3"),
    (b"\x92\x03\xd1\x60", "smullsvs r0, r1, r2, r3"),
    (b"\x92\x03\xd1\x70", "smullsvc r0, r1, r2, r3"),
    (b"\x92\x03\xd1\x80", "smullshi r0, r1, r2, r3"),
    (b"\x92\x03\xd1\x90", "smullsls r0, r1, r2, r3"),
    (b"\x92\x03\xd1\xa0", "smullsge r0, r1, r2, r3"),
    (b"\x92\x03\xd1\xb0", "smullslt r0, r1, r2, r3"),
    (b"\x92\x03\xd1\xc0", "smullsgt r0, r1, r2, r3"),
    (b"\x92\x03\xd1\xd0", "smullsle r0, r1, r2, r3"),

    # SUB -------------------------------------------------------------------- #
    (b"\x02\x00\x41\xe2", "sub r0, r1, #2"),
    (b"\x02\x00\x41\x02", "subeq r0, r1, #2"),
    (b"\x02\x00\x41\x12", "subne r0, r1, #2"),
    (b"\x02\x00\x41\x22", "subcs r0, r1, #2"),
    (b"\x02\x00\x41\x32", "subcc r0, r1, #2"),
    (b"\x02\x00\x41\x42", "submi r0, r1, #2"),
    (b"\x02\x00\x41\x52", "subpl r0, r1, #2"),
    (b"\x02\x00\x41\x62", "subvs r0, r1, #2"),
    (b"\x02\x00\x41\x72", "subvc r0, r1, #2"),
    (b"\x02\x00\x41\x82", "subhi r0, r1, #2"),
    (b"\x02\x00\x41\x92", "subls r0, r1, #2"),
    (b"\x02\x00\x41\xa2", "subge r0, r1, #2"),
    (b"\x02\x00\x41\xb2", "sublt r0, r1, #2"),
    (b"\x02\x00\x41\xc2", "subgt r0, r1, #2"),
    (b"\x02\x00\x41\xd2", "suble r0, r1, #2"),
    (b"\x02\x00\x41\xe2", "subal r0, r1, #2"),

    (b"\x03\x00\x41\xe0", "sub r0, r1, r3"),
    (b"\x03\x00\x41\x00", "subeq r0, r1, r3"),
    (b"\x03\x00\x41\x10", "subne r0, r1, r3"),
    (b"\x03\x00\x41\x20", "subcs r0, r1, r3"),
    (b"\x03\x00\x41\x30", "subcc r0, r1, r3"),
    (b"\x03\x00\x41\x40", "submi r0, r1, r3"),
    (b"\x03\x00\x41\x50", "subpl r0, r1, r3"),
    (b"\x03\x00\x41\x60", "subvs r0, r1, r3"),
    (b"\x03\x00\x41\x70", "subvc r0, r1, r3"),
    (b"\x03\x00\x41\x80", "subhi r0, r1, r3"),
    (b"\x03\x00\x41\x90", "subls r0, r1, r3"),
    (b"\x03\x00\x41\xa0", "subge r0, r1, r3"),
    (b"\x03\x00\x41\xb0", "sublt r0, r1, r3"),
    (b"\x03\x00\x41\xc0", "subgt r0, r1, r3"),
    (b"\x03\x00\x41\xd0", "suble r0, r1, r3"),
    (b"\x03\x00\x41\xe0", "subal r0, r1, r3"),

    (b"\x42\x02\x41\x00", "subeq r0, r1, r2, asr #4"),
    (b"\x42\x02\x41\x10", "subne r0, r1, r2, asr #4"),
    (b"\x42\x02\x41\x20", "subcs r0, r1, r2, asr #4"),
    (b"\x42\x02\x41\x30", "subcc r0, r1, r2, asr #4"),
    (b"\x42\x02\x41\x40", "submi r0, r1, r2, asr #4"),
    (b"\x42\x02\x41\x50", "subpl r0, r1, r2, asr #4"),
    (b"\x42\x02\x41\x60", "subvs r0, r1, r2, asr #4"),
    (b"\x42\x02\x41\x70", "subvc r0, r1, r2, asr #4"),
    (b"\x42\x02\x41\x80", "subhi r0, r1, r2, asr #4"),
    (b"\x42\x02\x41\x90", "subls r0, r1, r2, asr #4"),
    (b"\x42\x02\x41\xa0", "subge r0, r1, r2, asr #4"),
    (b"\x42\x02\x41\xb0", "sublt r0, r1, r2, asr #4"),
    (b"\x42\x02\x41\xc0", "subgt r0, r1, r2, asr #4"),
    (b"\x42\x02\x41\xd0", "suble r0, r1, r2, asr #4"),
    (b"\x42\x02\x41\xe0", "subal r0, r1, r2, asr #4"),

    (b"\x52\x03\x41\x00", "subeq r0, r1, r2, asr r3"),
    (b"\x52\x03\x41\x10", "subne r0, r1, r2, asr r3"),
    (b"\x52\x03\x41\x20", "subcs r0, r1, r2, asr r3"),
    (b"\x52\x03\x41\x30", "subcc r0, r1, r2, asr r3"),
    (b"\x52\x03\x41\x40", "submi r0, r1, r2, asr r3"),
    (b"\x52\x03\x41\x50", "subpl r0, r1, r2, asr r3"),
    (b"\x52\x03\x41\x60", "subvs r0, r1, r2, asr r3"),
    (b"\x52\x03\x41\x70", "subvc r0, r1, r2, asr r3"),
    (b"\x52\x03\x41\x80", "subhi r0, r1, r2, asr r3"),
    (b"\x52\x03\x41\x90", "subls r0, r1, r2, asr r3"),
    (b"\x52\x03\x41\xa0", "subge r0, r1, r2, asr r3"),
    (b"\x52\x03\x41\xb0", "sublt r0, r1, r2, asr r3"),
    (b"\x52\x03\x41\xc0", "subgt r0, r1, r2, asr r3"),
    (b"\x52\x03\x41\xd0", "suble r0, r1, r2, asr r3"),
    (b"\x52\x03\x41\xe0", "subal r0, r1, r2, asr r3"),

    (b"\x02\x02\x41\x00", "subeq r0, r1, r2, lsl #4"),
    (b"\x02\x02\x41\x10", "subne r0, r1, r2, lsl #4"),
    (b"\x02\x02\x41\x20", "subcs r0, r1, r2, lsl #4"),
    (b"\x02\x02\x41\x30", "subcc r0, r1, r2, lsl #4"),
    (b"\x02\x02\x41\x40", "submi r0, r1, r2, lsl #4"),
    (b"\x02\x02\x41\x50", "subpl r0, r1, r2, lsl #4"),
    (b"\x02\x02\x41\x60", "subvs r0, r1, r2, lsl #4"),
    (b"\x02\x02\x41\x70", "subvc r0, r1, r2, lsl #4"),
    (b"\x02\x02\x41\x80", "subhi r0, r1, r2, lsl #4"),
    (b"\x02\x02\x41\x90", "subls r0, r1, r2, lsl #4"),
    (b"\x02\x02\x41\xa0", "subge r0, r1, r2, lsl #4"),
    (b"\x02\x02\x41\xb0", "sublt r0, r1, r2, lsl #4"),
    (b"\x02\x02\x41\xc0", "subgt r0, r1, r2, lsl #4"),
    (b"\x02\x02\x41\xd0", "suble r0, r1, r2, lsl #4"),
    (b"\x02\x02\x41\xe0", "subal r0, r1, r2, lsl #4"),

    (b"\x12\x03\x41\x00", "subeq r0, r1, r2, lsl r3"),
    (b"\x12\x03\x41\x10", "subne r0, r1, r2, lsl r3"),
    (b"\x12\x03\x41\x20", "subcs r0, r1, r2, lsl r3"),
    (b"\x12\x03\x41\x30", "subcc r0, r1, r2, lsl r3"),
    (b"\x12\x03\x41\x40", "submi r0, r1, r2, lsl r3"),
    (b"\x12\x03\x41\x50", "subpl r0, r1, r2, lsl r3"),
    (b"\x12\x03\x41\x60", "subvs r0, r1, r2, lsl r3"),
    (b"\x12\x03\x41\x70", "subvc r0, r1, r2, lsl r3"),
    (b"\x12\x03\x41\x80", "subhi r0, r1, r2, lsl r3"),
    (b"\x12\x03\x41\x90", "subls r0, r1, r2, lsl r3"),
    (b"\x12\x03\x41\xa0", "subge r0, r1, r2, lsl r3"),
    (b"\x12\x03\x41\xb0", "sublt r0, r1, r2, lsl r3"),
    (b"\x12\x03\x41\xc0", "subgt r0, r1, r2, lsl r3"),
    (b"\x12\x03\x41\xd0", "suble r0, r1, r2, lsl r3"),
    (b"\x12\x03\x41\xe0", "subal r0, r1, r2, lsl r3"),

    (b"\x22\x02\x41\x00", "subeq r0, r1, r2, lsr #4"),
    (b"\x22\x02\x41\x10", "subne r0, r1, r2, lsr #4"),
    (b"\x22\x02\x41\x20", "subcs r0, r1, r2, lsr #4"),
    (b"\x22\x02\x41\x30", "subcc r0, r1, r2, lsr #4"),
    (b"\x22\x02\x41\x40", "submi r0, r1, r2, lsr #4"),
    (b"\x22\x02\x41\x50", "subpl r0, r1, r2, lsr #4"),
    (b"\x22\x02\x41\x60", "subvs r0, r1, r2, lsr #4"),
    (b"\x22\x02\x41\x70", "subvc r0, r1, r2, lsr #4"),
    (b"\x22\x02\x41\x80", "subhi r0, r1, r2, lsr #4"),
    (b"\x22\x02\x41\x90", "subls r0, r1, r2, lsr #4"),
    (b"\x22\x02\x41\xa0", "subge r0, r1, r2, lsr #4"),
    (b"\x22\x02\x41\xb0", "sublt r0, r1, r2, lsr #4"),
    (b"\x22\x02\x41\xc0", "subgt r0, r1, r2, lsr #4"),
    (b"\x22\x02\x41\xd0", "suble r0, r1, r2, lsr #4"),
    (b"\x22\x02\x41\xe0", "subal r0, r1, r2, lsr #4"),

    (b"\x32\x03\x41\x00", "subeq r0, r1, r2, lsr r3"),
    (b"\x32\x03\x41\x10", "subne r0, r1, r2, lsr r3"),
    (b"\x32\x03\x41\x20", "subcs r0, r1, r2, lsr r3"),
    (b"\x32\x03\x41\x30", "subcc r0, r1, r2, lsr r3"),
    (b"\x32\x03\x41\x40", "submi r0, r1, r2, lsr r3"),
    (b"\x32\x03\x41\x50", "subpl r0, r1, r2, lsr r3"),
    (b"\x32\x03\x41\x60", "subvs r0, r1, r2, lsr r3"),
    (b"\x32\x03\x41\x70", "subvc r0, r1, r2, lsr r3"),
    (b"\x32\x03\x41\x80", "subhi r0, r1, r2, lsr r3"),
    (b"\x32\x03\x41\x90", "subls r0, r1, r2, lsr r3"),
    (b"\x32\x03\x41\xa0", "subge r0, r1, r2, lsr r3"),
    (b"\x32\x03\x41\xb0", "sublt r0, r1, r2, lsr r3"),
    (b"\x32\x03\x41\xc0", "subgt r0, r1, r2, lsr r3"),
    (b"\x32\x03\x41\xd0", "suble r0, r1, r2, lsr r3"),
    (b"\x32\x03\x41\xe0", "subal r0, r1, r2, lsr r3"),

    (b"\x62\x02\x41\x00", "subeq r0, r1, r2, ror #4"),
    (b"\x62\x02\x41\x10", "subne r0, r1, r2, ror #4"),
    (b"\x62\x02\x41\x20", "subcs r0, r1, r2, ror #4"),
    (b"\x62\x02\x41\x30", "subcc r0, r1, r2, ror #4"),
    (b"\x62\x02\x41\x40", "submi r0, r1, r2, ror #4"),
    (b"\x62\x02\x41\x50", "subpl r0, r1, r2, ror #4"),
    (b"\x62\x02\x41\x60", "subvs r0, r1, r2, ror #4"),
    (b"\x62\x02\x41\x70", "subvc r0, r1, r2, ror #4"),
    (b"\x62\x02\x41\x80", "subhi r0, r1, r2, ror #4"),
    (b"\x62\x02\x41\x90", "subls r0, r1, r2, ror #4"),
    (b"\x62\x02\x41\xa0", "subge r0, r1, r2, ror #4"),
    (b"\x62\x02\x41\xb0", "sublt r0, r1, r2, ror #4"),
    (b"\x62\x02\x41\xc0", "subgt r0, r1, r2, ror #4"),
    (b"\x62\x02\x41\xd0", "suble r0, r1, r2, ror #4"),
    (b"\x62\x02\x41\xe0", "subal r0, r1, r2, ror #4"),

    (b"\x72\x03\x41\x00", "subeq r0, r1, r2, ror r3"),
    (b"\x72\x03\x41\x10", "subne r0, r1, r2, ror r3"),
    (b"\x72\x03\x41\x20", "subcs r0, r1, r2, ror r3"),
    (b"\x72\x03\x41\x30", "subcc r0, r1, r2, ror r3"),
    (b"\x72\x03\x41\x40", "submi r0, r1, r2, ror r3"),
    (b"\x72\x03\x41\x50", "subpl r0, r1, r2, ror r3"),
    (b"\x72\x03\x41\x60", "subvs r0, r1, r2, ror r3"),
    (b"\x72\x03\x41\x70", "subvc r0, r1, r2, ror r3"),
    (b"\x72\x03\x41\x80", "subhi r0, r1, r2, ror r3"),
    (b"\x72\x03\x41\x90", "subls r0, r1, r2, ror r3"),
    (b"\x72\x03\x41\xa0", "subge r0, r1, r2, ror r3"),
    (b"\x72\x03\x41\xb0", "sublt r0, r1, r2, ror r3"),
    (b"\x72\x03\x41\xc0", "subgt r0, r1, r2, ror r3"),
    (b"\x72\x03\x41\xd0", "suble r0, r1, r2, ror r3"),
    (b"\x72\x03\x41\xe0", "subal r0, r1, r2, ror r3"),

    (b"\x62\x00\x41\x00", "subeq r0, r1, r2, rrx"),
    (b"\x62\x00\x41\x10", "subne r0, r1, r2, rrx"),
    (b"\x62\x00\x41\x20", "subcs r0, r1, r2, rrx"),
    (b"\x62\x00\x41\x30", "subcc r0, r1, r2, rrx"),
    (b"\x62\x00\x41\x40", "submi r0, r1, r2, rrx"),
    (b"\x62\x00\x41\x50", "subpl r0, r1, r2, rrx"),
    (b"\x62\x00\x41\x60", "subvs r0, r1, r2, rrx"),
    (b"\x62\x00\x41\x70", "subvc r0, r1, r2, rrx"),
    (b"\x62\x00\x41\x80", "subhi r0, r1, r2, rrx"),
    (b"\x62\x00\x41\x90", "subls r0, r1, r2, rrx"),
    (b"\x62\x00\x41\xa0", "subge r0, r1, r2, rrx"),
    (b"\x62\x00\x41\xb0", "sublt r0, r1, r2, rrx"),
    (b"\x62\x00\x41\xc0", "subgt r0, r1, r2, rrx"),
    (b"\x62\x00\x41\xd0", "suble r0, r1, r2, rrx"),
    (b"\x62\x00\x41\xe0", "subal r0, r1, r2, rrx"),

    # SUBS ------------------------------------------------------------------- #
    (b"\x02\x00\x51\xe2", "subs r0, r1, #2"),
    (b"\x02\x00\x51\x02", "subseq r0, r1, #2"),
    (b"\x02\x00\x51\x12", "subsne r0, r1, #2"),
    (b"\x02\x00\x51\x22", "subscs r0, r1, #2"),
    (b"\x02\x00\x51\x32", "subscc r0, r1, #2"),
    (b"\x02\x00\x51\x42", "subsmi r0, r1, #2"),
    (b"\x02\x00\x51\x52", "subspl r0, r1, #2"),
    (b"\x02\x00\x51\x62", "subsvs r0, r1, #2"),
    (b"\x02\x00\x51\x72", "subsvc r0, r1, #2"),
    (b"\x02\x00\x51\x82", "subshi r0, r1, #2"),
    (b"\x02\x00\x51\x92", "subsls r0, r1, #2"),
    (b"\x02\x00\x51\xa2", "subsge r0, r1, #2"),
    (b"\x02\x00\x51\xb2", "subslt r0, r1, #2"),
    (b"\x02\x00\x51\xc2", "subsgt r0, r1, #2"),
    (b"\x02\x00\x51\xd2", "subsle r0, r1, #2"),
    (b"\x02\x00\x51\xe2", "subsal r0, r1, #2"),

    (b"\x03\x00\x51\xe0", "subs r0, r1, r3"),
    (b"\x03\x00\x51\x00", "subseq r0, r1, r3"),
    (b"\x03\x00\x51\x10", "subsne r0, r1, r3"),
    (b"\x03\x00\x51\x20", "subscs r0, r1, r3"),
    (b"\x03\x00\x51\x30", "subscc r0, r1, r3"),
    (b"\x03\x00\x51\x40", "subsmi r0, r1, r3"),
    (b"\x03\x00\x51\x50", "subspl r0, r1, r3"),
    (b"\x03\x00\x51\x60", "subsvs r0, r1, r3"),
    (b"\x03\x00\x51\x70", "subsvc r0, r1, r3"),
    (b"\x03\x00\x51\x80", "subshi r0, r1, r3"),
    (b"\x03\x00\x51\x90", "subsls r0, r1, r3"),
    (b"\x03\x00\x51\xa0", "subsge r0, r1, r3"),
    (b"\x03\x00\x51\xb0", "subslt r0, r1, r3"),
    (b"\x03\x00\x51\xc0", "subsgt r0, r1, r3"),
    (b"\x03\x00\x51\xd0", "subsle r0, r1, r3"),
    (b"\x03\x00\x51\xe0", "subsal r0, r1, r3"),

    (b"\x42\x02\x51\x00", "subseq r0, r1, r2, asr #4"),
    (b"\x42\x02\x51\x10", "subsne r0, r1, r2, asr #4"),
    (b"\x42\x02\x51\x20", "subscs r0, r1, r2, asr #4"),
    (b"\x42\x02\x51\x30", "subscc r0, r1, r2, asr #4"),
    (b"\x42\x02\x51\x40", "subsmi r0, r1, r2, asr #4"),
    (b"\x42\x02\x51\x50", "subspl r0, r1, r2, asr #4"),
    (b"\x42\x02\x51\x60", "subsvs r0, r1, r2, asr #4"),
    (b"\x42\x02\x51\x70", "subsvc r0, r1, r2, asr #4"),
    (b"\x42\x02\x51\x80", "subshi r0, r1, r2, asr #4"),
    (b"\x42\x02\x51\x90", "subsls r0, r1, r2, asr #4"),
    (b"\x42\x02\x51\xa0", "subsge r0, r1, r2, asr #4"),
    (b"\x42\x02\x51\xb0", "subslt r0, r1, r2, asr #4"),
    (b"\x42\x02\x51\xc0", "subsgt r0, r1, r2, asr #4"),
    (b"\x42\x02\x51\xd0", "subsle r0, r1, r2, asr #4"),
    (b"\x42\x02\x51\xe0", "subsal r0, r1, r2, asr #4"),

    (b"\x52\x03\x51\x00", "subseq r0, r1, r2, asr r3"),
    (b"\x52\x03\x51\x10", "subsne r0, r1, r2, asr r3"),
    (b"\x52\x03\x51\x20", "subscs r0, r1, r2, asr r3"),
    (b"\x52\x03\x51\x30", "subscc r0, r1, r2, asr r3"),
    (b"\x52\x03\x51\x40", "subsmi r0, r1, r2, asr r3"),
    (b"\x52\x03\x51\x50", "subspl r0, r1, r2, asr r3"),
    (b"\x52\x03\x51\x60", "subsvs r0, r1, r2, asr r3"),
    (b"\x52\x03\x51\x70", "subsvc r0, r1, r2, asr r3"),
    (b"\x52\x03\x51\x80", "subshi r0, r1, r2, asr r3"),
    (b"\x52\x03\x51\x90", "subsls r0, r1, r2, asr r3"),
    (b"\x52\x03\x51\xa0", "subsge r0, r1, r2, asr r3"),
    (b"\x52\x03\x51\xb0", "subslt r0, r1, r2, asr r3"),
    (b"\x52\x03\x51\xc0", "subsgt r0, r1, r2, asr r3"),
    (b"\x52\x03\x51\xd0", "subsle r0, r1, r2, asr r3"),
    (b"\x52\x03\x51\xe0", "subsal r0, r1, r2, asr r3"),

    (b"\x02\x02\x51\x00", "subseq r0, r1, r2, lsl #4"),
    (b"\x02\x02\x51\x10", "subsne r0, r1, r2, lsl #4"),
    (b"\x02\x02\x51\x20", "subscs r0, r1, r2, lsl #4"),
    (b"\x02\x02\x51\x30", "subscc r0, r1, r2, lsl #4"),
    (b"\x02\x02\x51\x40", "subsmi r0, r1, r2, lsl #4"),
    (b"\x02\x02\x51\x50", "subspl r0, r1, r2, lsl #4"),
    (b"\x02\x02\x51\x60", "subsvs r0, r1, r2, lsl #4"),
    (b"\x02\x02\x51\x70", "subsvc r0, r1, r2, lsl #4"),
    (b"\x02\x02\x51\x80", "subshi r0, r1, r2, lsl #4"),
    (b"\x02\x02\x51\x90", "subsls r0, r1, r2, lsl #4"),
    (b"\x02\x02\x51\xa0", "subsge r0, r1, r2, lsl #4"),
    (b"\x02\x02\x51\xb0", "subslt r0, r1, r2, lsl #4"),
    (b"\x02\x02\x51\xc0", "subsgt r0, r1, r2, lsl #4"),
    (b"\x02\x02\x51\xd0", "subsle r0, r1, r2, lsl #4"),
    (b"\x02\x02\x51\xe0", "subsal r0, r1, r2, lsl #4"),

    (b"\x12\x03\x51\x00", "subseq r0, r1, r2, lsl r3"),
    (b"\x12\x03\x51\x10", "subsne r0, r1, r2, lsl r3"),
    (b"\x12\x03\x51\x20", "subscs r0, r1, r2, lsl r3"),
    (b"\x12\x03\x51\x30", "subscc r0, r1, r2, lsl r3"),
    (b"\x12\x03\x51\x40", "subsmi r0, r1, r2, lsl r3"),
    (b"\x12\x03\x51\x50", "subspl r0, r1, r2, lsl r3"),
    (b"\x12\x03\x51\x60", "subsvs r0, r1, r2, lsl r3"),
    (b"\x12\x03\x51\x70", "subsvc r0, r1, r2, lsl r3"),
    (b"\x12\x03\x51\x80", "subshi r0, r1, r2, lsl r3"),
    (b"\x12\x03\x51\x90", "subsls r0, r1, r2, lsl r3"),
    (b"\x12\x03\x51\xa0", "subsge r0, r1, r2, lsl r3"),
    (b"\x12\x03\x51\xb0", "subslt r0, r1, r2, lsl r3"),
    (b"\x12\x03\x51\xc0", "subsgt r0, r1, r2, lsl r3"),
    (b"\x12\x03\x51\xd0", "subsle r0, r1, r2, lsl r3"),
    (b"\x12\x03\x51\xe0", "subsal r0, r1, r2, lsl r3"),

    (b"\x22\x02\x51\x00", "subseq r0, r1, r2, lsr #4"),
    (b"\x22\x02\x51\x10", "subsne r0, r1, r2, lsr #4"),
    (b"\x22\x02\x51\x20", "subscs r0, r1, r2, lsr #4"),
    (b"\x22\x02\x51\x30", "subscc r0, r1, r2, lsr #4"),
    (b"\x22\x02\x51\x40", "subsmi r0, r1, r2, lsr #4"),
    (b"\x22\x02\x51\x50", "subspl r0, r1, r2, lsr #4"),
    (b"\x22\x02\x51\x60", "subsvs r0, r1, r2, lsr #4"),
    (b"\x22\x02\x51\x70", "subsvc r0, r1, r2, lsr #4"),
    (b"\x22\x02\x51\x80", "subshi r0, r1, r2, lsr #4"),
    (b"\x22\x02\x51\x90", "subsls r0, r1, r2, lsr #4"),
    (b"\x22\x02\x51\xa0", "subsge r0, r1, r2, lsr #4"),
    (b"\x22\x02\x51\xb0", "subslt r0, r1, r2, lsr #4"),
    (b"\x22\x02\x51\xc0", "subsgt r0, r1, r2, lsr #4"),
    (b"\x22\x02\x51\xd0", "subsle r0, r1, r2, lsr #4"),
    (b"\x22\x02\x51\xe0", "subsal r0, r1, r2, lsr #4"),

    (b"\x32\x03\x51\x00", "subseq r0, r1, r2, lsr r3"),
    (b"\x32\x03\x51\x10", "subsne r0, r1, r2, lsr r3"),
    (b"\x32\x03\x51\x20", "subscs r0, r1, r2, lsr r3"),
    (b"\x32\x03\x51\x30", "subscc r0, r1, r2, lsr r3"),
    (b"\x32\x03\x51\x40", "subsmi r0, r1, r2, lsr r3"),
    (b"\x32\x03\x51\x50", "subspl r0, r1, r2, lsr r3"),
    (b"\x32\x03\x51\x60", "subsvs r0, r1, r2, lsr r3"),
    (b"\x32\x03\x51\x70", "subsvc r0, r1, r2, lsr r3"),
    (b"\x32\x03\x51\x80", "subshi r0, r1, r2, lsr r3"),
    (b"\x32\x03\x51\x90", "subsls r0, r1, r2, lsr r3"),
    (b"\x32\x03\x51\xa0", "subsge r0, r1, r2, lsr r3"),
    (b"\x32\x03\x51\xb0", "subslt r0, r1, r2, lsr r3"),
    (b"\x32\x03\x51\xc0", "subsgt r0, r1, r2, lsr r3"),
    (b"\x32\x03\x51\xd0", "subsle r0, r1, r2, lsr r3"),
    (b"\x32\x03\x51\xe0", "subsal r0, r1, r2, lsr r3"),

    (b"\x62\x02\x51\x00", "subseq r0, r1, r2, ror #4"),
    (b"\x62\x02\x51\x10", "subsne r0, r1, r2, ror #4"),
    (b"\x62\x02\x51\x20", "subscs r0, r1, r2, ror #4"),
    (b"\x62\x02\x51\x30", "subscc r0, r1, r2, ror #4"),
    (b"\x62\x02\x51\x40", "subsmi r0, r1, r2, ror #4"),
    (b"\x62\x02\x51\x50", "subspl r0, r1, r2, ror #4"),
    (b"\x62\x02\x51\x60", "subsvs r0, r1, r2, ror #4"),
    (b"\x62\x02\x51\x70", "subsvc r0, r1, r2, ror #4"),
    (b"\x62\x02\x51\x80", "subshi r0, r1, r2, ror #4"),
    (b"\x62\x02\x51\x90", "subsls r0, r1, r2, ror #4"),
    (b"\x62\x02\x51\xa0", "subsge r0, r1, r2, ror #4"),
    (b"\x62\x02\x51\xb0", "subslt r0, r1, r2, ror #4"),
    (b"\x62\x02\x51\xc0", "subsgt r0, r1, r2, ror #4"),
    (b"\x62\x02\x51\xd0", "subsle r0, r1, r2, ror #4"),
    (b"\x62\x02\x51\xe0", "subsal r0, r1, r2, ror #4"),

    (b"\x72\x03\x51\x00", "subseq r0, r1, r2, ror r3"),
    (b"\x72\x03\x51\x10", "subsne r0, r1, r2, ror r3"),
    (b"\x72\x03\x51\x20", "subscs r0, r1, r2, ror r3"),
    (b"\x72\x03\x51\x30", "subscc r0, r1, r2, ror r3"),
    (b"\x72\x03\x51\x40", "subsmi r0, r1, r2, ror r3"),
    (b"\x72\x03\x51\x50", "subspl r0, r1, r2, ror r3"),
    (b"\x72\x03\x51\x60", "subsvs r0, r1, r2, ror r3"),
    (b"\x72\x03\x51\x70", "subsvc r0, r1, r2, ror r3"),
    (b"\x72\x03\x51\x80", "subshi r0, r1, r2, ror r3"),
    (b"\x72\x03\x51\x90", "subsls r0, r1, r2, ror r3"),
    (b"\x72\x03\x51\xa0", "subsge r0, r1, r2, ror r3"),
    (b"\x72\x03\x51\xb0", "subslt r0, r1, r2, ror r3"),
    (b"\x72\x03\x51\xc0", "subsgt r0, r1, r2, ror r3"),
    (b"\x72\x03\x51\xd0", "subsle r0, r1, r2, ror r3"),
    (b"\x72\x03\x51\xe0", "subsal r0, r1, r2, ror r3"),

    (b"\x62\x00\x51\x00", "subseq r0, r1, r2, rrx"),
    (b"\x62\x00\x51\x10", "subsne r0, r1, r2, rrx"),
    (b"\x62\x00\x51\x20", "subscs r0, r1, r2, rrx"),
    (b"\x62\x00\x51\x30", "subscc r0, r1, r2, rrx"),
    (b"\x62\x00\x51\x40", "subsmi r0, r1, r2, rrx"),
    (b"\x62\x00\x51\x50", "subspl r0, r1, r2, rrx"),
    (b"\x62\x00\x51\x60", "subsvs r0, r1, r2, rrx"),
    (b"\x62\x00\x51\x70", "subsvc r0, r1, r2, rrx"),
    (b"\x62\x00\x51\x80", "subshi r0, r1, r2, rrx"),
    (b"\x62\x00\x51\x90", "subsls r0, r1, r2, rrx"),
    (b"\x62\x00\x51\xa0", "subsge r0, r1, r2, rrx"),
    (b"\x62\x00\x51\xb0", "subslt r0, r1, r2, rrx"),
    (b"\x62\x00\x51\xc0", "subsgt r0, r1, r2, rrx"),
    (b"\x62\x00\x51\xd0", "subsle r0, r1, r2, rrx"),
    (b"\x62\x00\x51\xe0", "subsal r0, r1, r2, rrx"),

    # SUB(S) with PC as operand ---------------------------------------------- #
    (b"\x0f\x00\x41\xe0", "sub r0, r1, pc"),
    (b"\x02\x00\x4f\xe0", "sub r0, pc, r2"),

    (b"\x4f\x01\x41\xe0", "sub r0, r1, pc, asr #2"),
    (b"\x42\x01\x4f\xe0", "sub r0, pc, r2, asr #2"),
    (b"\x0f\x01\x41\xe0", "sub r0, r1, pc, lsl #2"),
    (b"\x02\x01\x4f\xe0", "sub r0, pc, r2, lsl #2"),
    (b"\x2f\x01\x41\xe0", "sub r0, r1, pc, lsr #2"),
    (b"\x22\x01\x4f\xe0", "sub r0, pc, r2, lsr #2"),
    (b"\x6f\x01\x41\xe0", "sub r0, r1, pc, ror #2"),
    (b"\x62\x01\x4f\xe0", "sub r0, pc, r2, ror #2"),
    (b"\x6f\x00\x41\xe0", "sub r0, r1, pc, rrx"),
    (b"\x62\x00\x4f\xe0", "sub r0, pc, r2, rrx"),
    (b"\x5f\x03\x41\xe0", "sub r0, r1, pc, asr r3"),
    (b"\x52\x03\x4f\xe0", "sub r0, pc, r2, asr r3"),
    (b"\x1f\x03\x41\xe0", "sub r0, r1, pc, lsl r3"),
    (b"\x12\x03\x4f\xe0", "sub r0, pc, r2, lsl r3"),
    (b"\x3f\x03\x41\xe0", "sub r0, r1, pc, lsr r3"),
    (b"\x32\x03\x4f\xe0", "sub r0, pc, r2, lsr r3"),
    (b"\x7f\x03\x41\xe0", "sub r0, r1, pc, ror r3"),
    (b"\x72\x03\x4f\xe0", "sub r0, pc, r2, ror r3"),

    (b"\x4f\x01\x51\xe0", "subs r0, r1, pc, asr #2"),
    (b"\x42\x01\x5f\xe0", "subs r0, pc, r2, asr #2"),
    (b"\x0f\x01\x51\xe0", "subs r0, r1, pc, lsl #2"),
    (b"\x02\x01\x5f\xe0", "subs r0, pc, r2, lsl #2"),
    (b"\x2f\x01\x51\xe0", "subs r0, r1, pc, lsr #2"),
    (b"\x22\x01\x5f\xe0", "subs r0, pc, r2, lsr #2"),
    (b"\x6f\x01\x51\xe0", "subs r0, r1, pc, ror #2"),
    (b"\x62\x01\x5f\xe0", "subs r0, pc, r2, ror #2"),
    (b"\x6f\x00\x51\xe0", "subs r0, r1, pc, rrx"),
    (b"\x62\x00\x5f\xe0", "subs r0, pc, r2, rrx"),
    (b"\x5f\x03\x51\xe0", "subs r0, r1, pc, asr r3"),
    (b"\x52\x03\x5f\xe0", "subs r0, pc, r2, asr r3"),
    (b"\x1f\x03\x51\xe0", "subs r0, r1, pc, lsl r3"),
    (b"\x12\x03\x5f\xe0", "subs r0, pc, r2, lsl r3"),
    (b"\x3f\x03\x51\xe0", "subs r0, r1, pc, lsr r3"),
    (b"\x32\x03\x5f\xe0", "subs r0, pc, r2, lsr r3"),
    (b"\x7f\x03\x51\xe0", "subs r0, r1, pc, ror r3"),
    (b"\x72\x03\x5f\xe0", "subs r0, pc, r2, ror r3"),

    # SUB(S) with SP as operand ---------------------------------------------- #
    (b"\x02\x00\x5d\xe2", "subs r0, sp, #2"),
    (b"\x02\x00\x5d\x02", "subseq r0, sp, #2"),
    (b"\x02\x00\x5d\x12", "subsne r0, sp, #2"),
    (b"\x02\x00\x5d\x22", "subscs r0, sp, #2"),
    (b"\x02\x00\x5d\x32", "subscc r0, sp, #2"),
    (b"\x02\x00\x5d\x42", "subsmi r0, sp, #2"),
    (b"\x02\x00\x5d\x52", "subspl r0, sp, #2"),
    (b"\x02\x00\x5d\x62", "subsvs r0, sp, #2"),
    (b"\x02\x00\x5d\x72", "subsvc r0, sp, #2"),
    (b"\x02\x00\x5d\x82", "subshi r0, sp, #2"),
    (b"\x02\x00\x5d\x92", "subsls r0, sp, #2"),
    (b"\x02\x00\x5d\xa2", "subsge r0, sp, #2"),
    (b"\x02\x00\x5d\xb2", "subslt r0, sp, #2"),
    (b"\x02\x00\x5d\xc2", "subsgt r0, sp, #2"),
    (b"\x02\x00\x5d\xd2", "subsle r0, sp, #2"),
    (b"\x02\x00\x5d\xe2", "subsal r0, sp, #2"),

    (b"\x03\x00\x5d\xe0", "subs r0, sp, r3"),
    (b"\x03\x00\x5d\x00", "subseq r0, sp, r3"),
    (b"\x03\x00\x5d\x10", "subsne r0, sp, r3"),
    (b"\x03\x00\x5d\x20", "subscs r0, sp, r3"),
    (b"\x03\x00\x5d\x30", "subscc r0, sp, r3"),
    (b"\x03\x00\x5d\x40", "subsmi r0, sp, r3"),
    (b"\x03\x00\x5d\x50", "subspl r0, sp, r3"),
    (b"\x03\x00\x5d\x60", "subsvs r0, sp, r3"),
    (b"\x03\x00\x5d\x70", "subsvc r0, sp, r3"),
    (b"\x03\x00\x5d\x80", "subshi r0, sp, r3"),
    (b"\x03\x00\x5d\x90", "subsls r0, sp, r3"),
    (b"\x03\x00\x5d\xa0", "subsge r0, sp, r3"),
    (b"\x03\x00\x5d\xb0", "subslt r0, sp, r3"),
    (b"\x03\x00\x5d\xc0", "subsgt r0, sp, r3"),
    (b"\x03\x00\x5d\xd0", "subsle r0, sp, r3"),
    (b"\x03\x00\x5d\xe0", "subsal r0, sp, r3"),

    (b"\x02\xd0\x5d\xe2", "subs sp, sp, #2"),
    (b"\x02\xd0\x5d\x02", "subseq sp, sp, #2"),
    (b"\x02\xd0\x5d\x12", "subsne sp, sp, #2"),
    (b"\x02\xd0\x5d\x22", "subscs sp, sp, #2"),
    (b"\x02\xd0\x5d\x32", "subscc sp, sp, #2"),
    (b"\x02\xd0\x5d\x42", "subsmi sp, sp, #2"),
    (b"\x02\xd0\x5d\x52", "subspl sp, sp, #2"),
    (b"\x02\xd0\x5d\x62", "subsvs sp, sp, #2"),
    (b"\x02\xd0\x5d\x72", "subsvc sp, sp, #2"),
    (b"\x02\xd0\x5d\x82", "subshi sp, sp, #2"),
    (b"\x02\xd0\x5d\x92", "subsls sp, sp, #2"),
    (b"\x02\xd0\x5d\xa2", "subsge sp, sp, #2"),
    (b"\x02\xd0\x5d\xb2", "subslt sp, sp, #2"),
    (b"\x02\xd0\x5d\xc2", "subsgt sp, sp, #2"),
    (b"\x02\xd0\x5d\xd2", "subsle sp, sp, #2"),
    (b"\x02\xd0\x5d\xe2", "subsal sp, sp, #2"),

    (b"\x03\xd0\x5d\xe0", "subs sp, sp, r3"),
    (b"\x03\xd0\x5d\x00", "subseq sp, sp, r3"),
    (b"\x03\xd0\x5d\x10", "subsne sp, sp, r3"),
    (b"\x03\xd0\x5d\x20", "subscs sp, sp, r3"),
    (b"\x03\xd0\x5d\x30", "subscc sp, sp, r3"),
    (b"\x03\xd0\x5d\x40", "subsmi sp, sp, r3"),
    (b"\x03\xd0\x5d\x50", "subspl sp, sp, r3"),
    (b"\x03\xd0\x5d\x60", "subsvs sp, sp, r3"),
    (b"\x03\xd0\x5d\x70", "subsvc sp, sp, r3"),
    (b"\x03\xd0\x5d\x80", "subshi sp, sp, r3"),
    (b"\x03\xd0\x5d\x90", "subsls sp, sp, r3"),
    (b"\x03\xd0\x5d\xa0", "subsge sp, sp, r3"),
    (b"\x03\xd0\x5d\xb0", "subslt sp, sp, r3"),
    (b"\x03\xd0\x5d\xc0", "subsgt sp, sp, r3"),
    (b"\x03\xd0\x5d\xd0", "subsle sp, sp, r3"),
    (b"\x03\xd0\x5d\xe0", "subsal sp, sp, r3"),

    (b"\x1d\xdd\x4d\xe0", "sub sp, sp, sp, lsl sp"),
    (b"\x1d\xdd\x5d\xe0", "subs sp, sp, sp, lsl sp"),
    (b"\x3d\xdd\x4d\xe0", "sub sp, sp, sp, lsr sp"),
    (b"\x3d\xdd\x5d\xe0", "subs sp, sp, sp, lsr sp"),
    (b"\x5d\xdd\x4d\xe0", "sub sp, sp, sp, asr sp"),
    (b"\x5d\xdd\x5d\xe0", "subs sp, sp, sp, asr sp"),
    (b"\x5d\xdd\x4d\xe0", "sub sp, sp, sp, asr sp"),
    (b"\x5d\xdd\x5d\xe0", "subs sp, sp, sp, asr sp"),
    (b"\x7d\xdd\x4d\xe0", "sub sp, sp, sp, ror sp"),
    (b"\x7d\xdd\x5d\xe0", "subs sp, sp, sp, ror sp"),
    (b"\x7d\xdd\x4d\xe0", "sub sp, sp, sp, ror sp"),
    (b"\x7d\xdd\x5d\xe0", "subs sp, sp, sp, ror sp"),

    # TST -------------------------------------------------------------------- #
    (b"\x01\x00\x10\x01", "tsteq r0, r1"),
    (b"\x01\x00\x10\x11", "tstne r0, r1"),
    (b"\x01\x00\x10\x21", "tstcs r0, r1"),
    (b"\x01\x00\x10\x31", "tstcc r0, r1"),
    (b"\x01\x00\x10\x41", "tstmi r0, r1"),
    (b"\x01\x00\x10\x51", "tstpl r0, r1"),
    (b"\x01\x00\x10\x61", "tstvs r0, r1"),
    (b"\x01\x00\x10\x71", "tstvc r0, r1"),
    (b"\x01\x00\x10\x81", "tsthi r0, r1"),
    (b"\x01\x00\x10\x91", "tstls r0, r1"),
    (b"\x01\x00\x10\xa1", "tstge r0, r1"),
    (b"\x01\x00\x10\xb1", "tstlt r0, r1"),
    (b"\x01\x00\x10\xc1", "tstgt r0, r1"),
    (b"\x01\x00\x10\xd1", "tstle r0, r1"),
    (b"\x01\x00\x10\xe1", "tstal r0, r1"),

    (b"\x04\x00\x10\x03", "tsteq r0, #4"),
    (b"\x04\x00\x10\x13", "tstne r0, #4"),
    (b"\x04\x00\x10\x23", "tstcs r0, #4"),
    (b"\x04\x00\x10\x33", "tstcc r0, #4"),
    (b"\x04\x00\x10\x43", "tstmi r0, #4"),
    (b"\x04\x00\x10\x53", "tstpl r0, #4"),
    (b"\x04\x00\x10\x63", "tstvs r0, #4"),
    (b"\x04\x00\x10\x73", "tstvc r0, #4"),
    (b"\x04\x00\x10\x83", "tsthi r0, #4"),
    (b"\x04\x00\x10\x93", "tstls r0, #4"),
    (b"\x04\x00\x10\xa3", "tstge r0, #4"),
    (b"\x04\x00\x10\xb3", "tstlt r0, #4"),
    (b"\x04\x00\x10\xc3", "tstgt r0, #4"),
    (b"\x04\x00\x10\xd3", "tstle r0, #4"),
    (b"\x04\x00\x10\xe3", "tstal r0, #4"),

    (b"\x41\x02\x10\x01", "tsteq r0, r1, asr #4"),
    (b"\x41\x02\x10\x11", "tstne r0, r1, asr #4"),
    (b"\x41\x02\x10\x21", "tstcs r0, r1, asr #4"),
    (b"\x41\x02\x10\x31", "tstcc r0, r1, asr #4"),
    (b"\x41\x02\x10\x41", "tstmi r0, r1, asr #4"),
    (b"\x41\x02\x10\x51", "tstpl r0, r1, asr #4"),
    (b"\x41\x02\x10\x61", "tstvs r0, r1, asr #4"),
    (b"\x41\x02\x10\x71", "tstvc r0, r1, asr #4"),
    (b"\x41\x02\x10\x81", "tsthi r0, r1, asr #4"),
    (b"\x41\x02\x10\x91", "tstls r0, r1, asr #4"),
    (b"\x41\x02\x10\xa1", "tstge r0, r1, asr #4"),
    (b"\x41\x02\x10\xb1", "tstlt r0, r1, asr #4"),
    (b"\x41\x02\x10\xc1", "tstgt r0, r1, asr #4"),
    (b"\x41\x02\x10\xd1", "tstle r0, r1, asr #4"),
    (b"\x41\x02\x10\xe1", "tstal r0, r1, asr #4"),

    (b"\x51\x03\x10\x01", "tsteq r0, r1, asr r3"),
    (b"\x51\x03\x10\x11", "tstne r0, r1, asr r3"),
    (b"\x51\x03\x10\x21", "tstcs r0, r1, asr r3"),
    (b"\x51\x03\x10\x31", "tstcc r0, r1, asr r3"),
    (b"\x51\x03\x10\x41", "tstmi r0, r1, asr r3"),
    (b"\x51\x03\x10\x51", "tstpl r0, r1, asr r3"),
    (b"\x51\x03\x10\x61", "tstvs r0, r1, asr r3"),
    (b"\x51\x03\x10\x71", "tstvc r0, r1, asr r3"),
    (b"\x51\x03\x10\x81", "tsthi r0, r1, asr r3"),
    (b"\x51\x03\x10\x91", "tstls r0, r1, asr r3"),
    (b"\x51\x03\x10\xa1", "tstge r0, r1, asr r3"),
    (b"\x51\x03\x10\xb1", "tstlt r0, r1, asr r3"),
    (b"\x51\x03\x10\xc1", "tstgt r0, r1, asr r3"),
    (b"\x51\x03\x10\xd1", "tstle r0, r1, asr r3"),
    (b"\x51\x03\x10\xe1", "tstal r0, r1, asr r3"),

    (b"\x01\x02\x10\x01", "tsteq r0, r1, lsl #4"),
    (b"\x01\x02\x10\x11", "tstne r0, r1, lsl #4"),
    (b"\x01\x02\x10\x21", "tstcs r0, r1, lsl #4"),
    (b"\x01\x02\x10\x31", "tstcc r0, r1, lsl #4"),
    (b"\x01\x02\x10\x41", "tstmi r0, r1, lsl #4"),
    (b"\x01\x02\x10\x51", "tstpl r0, r1, lsl #4"),
    (b"\x01\x02\x10\x61", "tstvs r0, r1, lsl #4"),
    (b"\x01\x02\x10\x71", "tstvc r0, r1, lsl #4"),
    (b"\x01\x02\x10\x81", "tsthi r0, r1, lsl #4"),
    (b"\x01\x02\x10\x91", "tstls r0, r1, lsl #4"),
    (b"\x01\x02\x10\xa1", "tstge r0, r1, lsl #4"),
    (b"\x01\x02\x10\xb1", "tstlt r0, r1, lsl #4"),
    (b"\x01\x02\x10\xc1", "tstgt r0, r1, lsl #4"),
    (b"\x01\x02\x10\xd1", "tstle r0, r1, lsl #4"),
    (b"\x01\x02\x10\xe1", "tstal r0, r1, lsl #4"),

    (b"\x11\x03\x10\x01", "tsteq r0, r1, lsl r3"),
    (b"\x11\x03\x10\x11", "tstne r0, r1, lsl r3"),
    (b"\x11\x03\x10\x21", "tstcs r0, r1, lsl r3"),
    (b"\x11\x03\x10\x31", "tstcc r0, r1, lsl r3"),
    (b"\x11\x03\x10\x41", "tstmi r0, r1, lsl r3"),
    (b"\x11\x03\x10\x51", "tstpl r0, r1, lsl r3"),
    (b"\x11\x03\x10\x61", "tstvs r0, r1, lsl r3"),
    (b"\x11\x03\x10\x71", "tstvc r0, r1, lsl r3"),
    (b"\x11\x03\x10\x81", "tsthi r0, r1, lsl r3"),
    (b"\x11\x03\x10\x91", "tstls r0, r1, lsl r3"),
    (b"\x11\x03\x10\xa1", "tstge r0, r1, lsl r3"),
    (b"\x11\x03\x10\xb1", "tstlt r0, r1, lsl r3"),
    (b"\x11\x03\x10\xc1", "tstgt r0, r1, lsl r3"),
    (b"\x11\x03\x10\xd1", "tstle r0, r1, lsl r3"),
    (b"\x11\x03\x10\xe1", "tstal r0, r1, lsl r3"),

    (b"\x21\x02\x10\x01", "tsteq r0, r1, lsr #4"),
    (b"\x21\x02\x10\x11", "tstne r0, r1, lsr #4"),
    (b"\x21\x02\x10\x21", "tstcs r0, r1, lsr #4"),
    (b"\x21\x02\x10\x31", "tstcc r0, r1, lsr #4"),
    (b"\x21\x02\x10\x41", "tstmi r0, r1, lsr #4"),
    (b"\x21\x02\x10\x51", "tstpl r0, r1, lsr #4"),
    (b"\x21\x02\x10\x61", "tstvs r0, r1, lsr #4"),
    (b"\x21\x02\x10\x71", "tstvc r0, r1, lsr #4"),
    (b"\x21\x02\x10\x81", "tsthi r0, r1, lsr #4"),
    (b"\x21\x02\x10\x91", "tstls r0, r1, lsr #4"),
    (b"\x21\x02\x10\xa1", "tstge r0, r1, lsr #4"),
    (b"\x21\x02\x10\xb1", "tstlt r0, r1, lsr #4"),
    (b"\x21\x02\x10\xc1", "tstgt r0, r1, lsr #4"),
    (b"\x21\x02\x10\xd1", "tstle r0, r1, lsr #4"),
    (b"\x21\x02\x10\xe1", "tstal r0, r1, lsr #4"),

    (b"\x31\x03\x10\x01", "tsteq r0, r1, lsr r3"),
    (b"\x31\x03\x10\x11", "tstne r0, r1, lsr r3"),
    (b"\x31\x03\x10\x21", "tstcs r0, r1, lsr r3"),
    (b"\x31\x03\x10\x31", "tstcc r0, r1, lsr r3"),
    (b"\x31\x03\x10\x41", "tstmi r0, r1, lsr r3"),
    (b"\x31\x03\x10\x51", "tstpl r0, r1, lsr r3"),
    (b"\x31\x03\x10\x61", "tstvs r0, r1, lsr r3"),
    (b"\x31\x03\x10\x71", "tstvc r0, r1, lsr r3"),
    (b"\x31\x03\x10\x81", "tsthi r0, r1, lsr r3"),
    (b"\x31\x03\x10\x91", "tstls r0, r1, lsr r3"),
    (b"\x31\x03\x10\xa1", "tstge r0, r1, lsr r3"),
    (b"\x31\x03\x10\xb1", "tstlt r0, r1, lsr r3"),
    (b"\x31\x03\x10\xc1", "tstgt r0, r1, lsr r3"),
    (b"\x31\x03\x10\xd1", "tstle r0, r1, lsr r3"),
    (b"\x31\x03\x10\xe1", "tstal r0, r1, lsr r3"),

    (b"\x61\x02\x10\x01", "tsteq r0, r1, ror #4"),
    (b"\x61\x02\x10\x11", "tstne r0, r1, ror #4"),
    (b"\x61\x02\x10\x21", "tstcs r0, r1, ror #4"),
    (b"\x61\x02\x10\x31", "tstcc r0, r1, ror #4"),
    (b"\x61\x02\x10\x41", "tstmi r0, r1, ror #4"),
    (b"\x61\x02\x10\x51", "tstpl r0, r1, ror #4"),
    (b"\x61\x02\x10\x61", "tstvs r0, r1, ror #4"),
    (b"\x61\x02\x10\x71", "tstvc r0, r1, ror #4"),
    (b"\x61\x02\x10\x81", "tsthi r0, r1, ror #4"),
    (b"\x61\x02\x10\x91", "tstls r0, r1, ror #4"),
    (b"\x61\x02\x10\xa1", "tstge r0, r1, ror #4"),
    (b"\x61\x02\x10\xb1", "tstlt r0, r1, ror #4"),
    (b"\x61\x02\x10\xc1", "tstgt r0, r1, ror #4"),
    (b"\x61\x02\x10\xd1", "tstle r0, r1, ror #4"),
    (b"\x61\x02\x10\xe1", "tstal r0, r1, ror #4"),

    (b"\x71\x03\x10\x01", "tsteq r0, r1, ror r3"),
    (b"\x71\x03\x10\x11", "tstne r0, r1, ror r3"),
    (b"\x71\x03\x10\x21", "tstcs r0, r1, ror r3"),
    (b"\x71\x03\x10\x31", "tstcc r0, r1, ror r3"),
    (b"\x71\x03\x10\x41", "tstmi r0, r1, ror r3"),
    (b"\x71\x03\x10\x51", "tstpl r0, r1, ror r3"),
    (b"\x71\x03\x10\x61", "tstvs r0, r1, ror r3"),
    (b"\x71\x03\x10\x71", "tstvc r0, r1, ror r3"),
    (b"\x71\x03\x10\x81", "tsthi r0, r1, ror r3"),
    (b"\x71\x03\x10\x91", "tstls r0, r1, ror r3"),
    (b"\x71\x03\x10\xa1", "tstge r0, r1, ror r3"),
    (b"\x71\x03\x10\xb1", "tstlt r0, r1, ror r3"),
    (b"\x71\x03\x10\xc1", "tstgt r0, r1, ror r3"),
    (b"\x71\x03\x10\xd1", "tstle r0, r1, ror r3"),
    (b"\x71\x03\x10\xe1", "tstal r0, r1, ror r3"),

    (b"\x61\x00\x10\x01", "tsteq r0, r1, rrx"),
    (b"\x61\x00\x10\x11", "tstne r0, r1, rrx"),
    (b"\x61\x00\x10\x21", "tstcs r0, r1, rrx"),
    (b"\x61\x00\x10\x31", "tstcc r0, r1, rrx"),
    (b"\x61\x00\x10\x41", "tstmi r0, r1, rrx"),
    (b"\x61\x00\x10\x51", "tstpl r0, r1, rrx"),
    (b"\x61\x00\x10\x61", "tstvs r0, r1, rrx"),
    (b"\x61\x00\x10\x71", "tstvc r0, r1, rrx"),
    (b"\x61\x00\x10\x81", "tsthi r0, r1, rrx"),
    (b"\x61\x00\x10\x91", "tstls r0, r1, rrx"),
    (b"\x61\x00\x10\xa1", "tstge r0, r1, rrx"),
    (b"\x61\x00\x10\xb1", "tstlt r0, r1, rrx"),
    (b"\x61\x00\x10\xc1", "tstgt r0, r1, rrx"),
    (b"\x61\x00\x10\xd1", "tstle r0, r1, rrx"),
    (b"\x61\x00\x10\xe1", "tstal r0, r1, rrx"),

    # TEQ -------------------------------------------------------------------- #
    (b"\x01\x00\x30\x01", "teqeq r0, r1"),
    (b"\x01\x00\x30\x11", "teqne r0, r1"),
    (b"\x01\x00\x30\x21", "teqcs r0, r1"),
    (b"\x01\x00\x30\x31", "teqcc r0, r1"),
    (b"\x01\x00\x30\x41", "teqmi r0, r1"),
    (b"\x01\x00\x30\x51", "teqpl r0, r1"),
    (b"\x01\x00\x30\x61", "teqvs r0, r1"),
    (b"\x01\x00\x30\x71", "teqvc r0, r1"),
    (b"\x01\x00\x30\x81", "teqhi r0, r1"),
    (b"\x01\x00\x30\x91", "teqls r0, r1"),
    (b"\x01\x00\x30\xa1", "teqge r0, r1"),
    (b"\x01\x00\x30\xb1", "teqlt r0, r1"),
    (b"\x01\x00\x30\xc1", "teqgt r0, r1"),
    (b"\x01\x00\x30\xd1", "teqle r0, r1"),
    (b"\x01\x00\x30\xe1", "teqal r0, r1"),
    (b"\x04\x00\x30\x03", "teqeq r0, #4"),
    (b"\x04\x00\x30\x13", "teqne r0, #4"),
    (b"\x04\x00\x30\x23", "teqcs r0, #4"),
    (b"\x04\x00\x30\x33", "teqcc r0, #4"),
    (b"\x04\x00\x30\x43", "teqmi r0, #4"),
    (b"\x04\x00\x30\x53", "teqpl r0, #4"),
    (b"\x04\x00\x30\x63", "teqvs r0, #4"),
    (b"\x04\x00\x30\x73", "teqvc r0, #4"),
    (b"\x04\x00\x30\x83", "teqhi r0, #4"),
    (b"\x04\x00\x30\x93", "teqls r0, #4"),
    (b"\x04\x00\x30\xa3", "teqge r0, #4"),
    (b"\x04\x00\x30\xb3", "teqlt r0, #4"),
    (b"\x04\x00\x30\xc3", "teqgt r0, #4"),
    (b"\x04\x00\x30\xd3", "teqle r0, #4"),
    (b"\x04\x00\x30\xe3", "teqal r0, #4"),
    (b"\x41\x02\x30\x01", "teqeq r0, r1, asr #4"),
    (b"\x41\x02\x30\x11", "teqne r0, r1, asr #4"),
    (b"\x41\x02\x30\x21", "teqcs r0, r1, asr #4"),
    (b"\x41\x02\x30\x31", "teqcc r0, r1, asr #4"),
    (b"\x41\x02\x30\x41", "teqmi r0, r1, asr #4"),
    (b"\x41\x02\x30\x51", "teqpl r0, r1, asr #4"),
    (b"\x41\x02\x30\x61", "teqvs r0, r1, asr #4"),
    (b"\x41\x02\x30\x71", "teqvc r0, r1, asr #4"),
    (b"\x41\x02\x30\x81", "teqhi r0, r1, asr #4"),
    (b"\x41\x02\x30\x91", "teqls r0, r1, asr #4"),
    (b"\x41\x02\x30\xa1", "teqge r0, r1, asr #4"),
    (b"\x41\x02\x30\xb1", "teqlt r0, r1, asr #4"),
    (b"\x41\x02\x30\xc1", "teqgt r0, r1, asr #4"),
    (b"\x41\x02\x30\xd1", "teqle r0, r1, asr #4"),
    (b"\x41\x02\x30\xe1", "teqal r0, r1, asr #4"),
    (b"\x51\x03\x30\x01", "teqeq r0, r1, asr r3"),
    (b"\x51\x03\x30\x11", "teqne r0, r1, asr r3"),
    (b"\x51\x03\x30\x21", "teqcs r0, r1, asr r3"),
    (b"\x51\x03\x30\x31", "teqcc r0, r1, asr r3"),
    (b"\x51\x03\x30\x41", "teqmi r0, r1, asr r3"),
    (b"\x51\x03\x30\x51", "teqpl r0, r1, asr r3"),
    (b"\x51\x03\x30\x61", "teqvs r0, r1, asr r3"),
    (b"\x51\x03\x30\x71", "teqvc r0, r1, asr r3"),
    (b"\x51\x03\x30\x81", "teqhi r0, r1, asr r3"),
    (b"\x51\x03\x30\x91", "teqls r0, r1, asr r3"),
    (b"\x51\x03\x30\xa1", "teqge r0, r1, asr r3"),
    (b"\x51\x03\x30\xb1", "teqlt r0, r1, asr r3"),
    (b"\x51\x03\x30\xc1", "teqgt r0, r1, asr r3"),
    (b"\x51\x03\x30\xd1", "teqle r0, r1, asr r3"),
    (b"\x51\x03\x30\xe1", "teqal r0, r1, asr r3"),
    (b"\x01\x02\x30\x01", "teqeq r0, r1, lsl #4"),
    (b"\x01\x02\x30\x11", "teqne r0, r1, lsl #4"),
    (b"\x01\x02\x30\x21", "teqcs r0, r1, lsl #4"),
    (b"\x01\x02\x30\x31", "teqcc r0, r1, lsl #4"),
    (b"\x01\x02\x30\x41", "teqmi r0, r1, lsl #4"),
    (b"\x01\x02\x30\x51", "teqpl r0, r1, lsl #4"),
    (b"\x01\x02\x30\x61", "teqvs r0, r1, lsl #4"),
    (b"\x01\x02\x30\x71", "teqvc r0, r1, lsl #4"),
    (b"\x01\x02\x30\x81", "teqhi r0, r1, lsl #4"),
    (b"\x01\x02\x30\x91", "teqls r0, r1, lsl #4"),
    (b"\x01\x02\x30\xa1", "teqge r0, r1, lsl #4"),
    (b"\x01\x02\x30\xb1", "teqlt r0, r1, lsl #4"),
    (b"\x01\x02\x30\xc1", "teqgt r0, r1, lsl #4"),
    (b"\x01\x02\x30\xd1", "teqle r0, r1, lsl #4"),
    (b"\x01\x02\x30\xe1", "teqal r0, r1, lsl #4"),
    (b"\x11\x03\x30\x01", "teqeq r0, r1, lsl r3"),
    (b"\x11\x03\x30\x11", "teqne r0, r1, lsl r3"),
    (b"\x11\x03\x30\x21", "teqcs r0, r1, lsl r3"),
    (b"\x11\x03\x30\x31", "teqcc r0, r1, lsl r3"),
    (b"\x11\x03\x30\x41", "teqmi r0, r1, lsl r3"),
    (b"\x11\x03\x30\x51", "teqpl r0, r1, lsl r3"),
    (b"\x11\x03\x30\x61", "teqvs r0, r1, lsl r3"),
    (b"\x11\x03\x30\x71", "teqvc r0, r1, lsl r3"),
    (b"\x11\x03\x30\x81", "teqhi r0, r1, lsl r3"),
    (b"\x11\x03\x30\x91", "teqls r0, r1, lsl r3"),
    (b"\x11\x03\x30\xa1", "teqge r0, r1, lsl r3"),
    (b"\x11\x03\x30\xb1", "teqlt r0, r1, lsl r3"),
    (b"\x11\x03\x30\xc1", "teqgt r0, r1, lsl r3"),
    (b"\x11\x03\x30\xd1", "teqle r0, r1, lsl r3"),
    (b"\x11\x03\x30\xe1", "teqal r0, r1, lsl r3"),
    (b"\x21\x02\x30\x01", "teqeq r0, r1, lsr #4"),
    (b"\x21\x02\x30\x11", "teqne r0, r1, lsr #4"),
    (b"\x21\x02\x30\x21", "teqcs r0, r1, lsr #4"),
    (b"\x21\x02\x30\x31", "teqcc r0, r1, lsr #4"),
    (b"\x21\x02\x30\x41", "teqmi r0, r1, lsr #4"),
    (b"\x21\x02\x30\x51", "teqpl r0, r1, lsr #4"),
    (b"\x21\x02\x30\x61", "teqvs r0, r1, lsr #4"),
    (b"\x21\x02\x30\x71", "teqvc r0, r1, lsr #4"),
    (b"\x21\x02\x30\x81", "teqhi r0, r1, lsr #4"),
    (b"\x21\x02\x30\x91", "teqls r0, r1, lsr #4"),
    (b"\x21\x02\x30\xa1", "teqge r0, r1, lsr #4"),
    (b"\x21\x02\x30\xb1", "teqlt r0, r1, lsr #4"),
    (b"\x21\x02\x30\xc1", "teqgt r0, r1, lsr #4"),
    (b"\x21\x02\x30\xd1", "teqle r0, r1, lsr #4"),
    (b"\x21\x02\x30\xe1", "teqal r0, r1, lsr #4"),
    (b"\x31\x03\x30\x01", "teqeq r0, r1, lsr r3"),
    (b"\x31\x03\x30\x11", "teqne r0, r1, lsr r3"),
    (b"\x31\x03\x30\x21", "teqcs r0, r1, lsr r3"),
    (b"\x31\x03\x30\x31", "teqcc r0, r1, lsr r3"),
    (b"\x31\x03\x30\x41", "teqmi r0, r1, lsr r3"),
    (b"\x31\x03\x30\x51", "teqpl r0, r1, lsr r3"),
    (b"\x31\x03\x30\x61", "teqvs r0, r1, lsr r3"),
    (b"\x31\x03\x30\x71", "teqvc r0, r1, lsr r3"),
    (b"\x31\x03\x30\x81", "teqhi r0, r1, lsr r3"),
    (b"\x31\x03\x30\x91", "teqls r0, r1, lsr r3"),
    (b"\x31\x03\x30\xa1", "teqge r0, r1, lsr r3"),
    (b"\x31\x03\x30\xb1", "teqlt r0, r1, lsr r3"),
    (b"\x31\x03\x30\xc1", "teqgt r0, r1, lsr r3"),
    (b"\x31\x03\x30\xd1", "teqle r0, r1, lsr r3"),
    (b"\x31\x03\x30\xe1", "teqal r0, r1, lsr r3"),
    (b"\x61\x02\x30\x01", "teqeq r0, r1, ror #4"),
    (b"\x61\x02\x30\x11", "teqne r0, r1, ror #4"),
    (b"\x61\x02\x30\x21", "teqcs r0, r1, ror #4"),
    (b"\x61\x02\x30\x31", "teqcc r0, r1, ror #4"),
    (b"\x61\x02\x30\x41", "teqmi r0, r1, ror #4"),
    (b"\x61\x02\x30\x51", "teqpl r0, r1, ror #4"),
    (b"\x61\x02\x30\x61", "teqvs r0, r1, ror #4"),
    (b"\x61\x02\x30\x71", "teqvc r0, r1, ror #4"),
    (b"\x61\x02\x30\x81", "teqhi r0, r1, ror #4"),
    (b"\x61\x02\x30\x91", "teqls r0, r1, ror #4"),
    (b"\x61\x02\x30\xa1", "teqge r0, r1, ror #4"),
    (b"\x61\x02\x30\xb1", "teqlt r0, r1, ror #4"),
    (b"\x61\x02\x30\xc1", "teqgt r0, r1, ror #4"),
    (b"\x61\x02\x30\xd1", "teqle r0, r1, ror #4"),
    (b"\x61\x02\x30\xe1", "teqal r0, r1, ror #4"),
    (b"\x71\x03\x30\x01", "teqeq r0, r1, ror r3"),
    (b"\x71\x03\x30\x11", "teqne r0, r1, ror r3"),
    (b"\x71\x03\x30\x21", "teqcs r0, r1, ror r3"),
    (b"\x71\x03\x30\x31", "teqcc r0, r1, ror r3"),
    (b"\x71\x03\x30\x41", "teqmi r0, r1, ror r3"),
    (b"\x71\x03\x30\x51", "teqpl r0, r1, ror r3"),
    (b"\x71\x03\x30\x61", "teqvs r0, r1, ror r3"),
    (b"\x71\x03\x30\x71", "teqvc r0, r1, ror r3"),
    (b"\x71\x03\x30\x81", "teqhi r0, r1, ror r3"),
    (b"\x71\x03\x30\x91", "teqls r0, r1, ror r3"),
    (b"\x71\x03\x30\xa1", "teqge r0, r1, ror r3"),
    (b"\x71\x03\x30\xb1", "teqlt r0, r1, ror r3"),
    (b"\x71\x03\x30\xc1", "teqgt r0, r1, ror r3"),
    (b"\x71\x03\x30\xd1", "teqle r0, r1, ror r3"),
    (b"\x71\x03\x30\xe1", "teqal r0, r1, ror r3"),
    (b"\x61\x00\x30\x01", "teqeq r0, r1, rrx"),
    (b"\x61\x00\x30\x11", "teqne r0, r1, rrx"),
    (b"\x61\x00\x30\x21", "teqcs r0, r1, rrx"),
    (b"\x61\x00\x30\x31", "teqcc r0, r1, rrx"),
    (b"\x61\x00\x30\x41", "teqmi r0, r1, rrx"),
    (b"\x61\x00\x30\x51", "teqpl r0, r1, rrx"),
    (b"\x61\x00\x30\x61", "teqvs r0, r1, rrx"),
    (b"\x61\x00\x30\x71", "teqvc r0, r1, rrx"),
    (b"\x61\x00\x30\x81", "teqhi r0, r1, rrx"),
    (b"\x61\x00\x30\x91", "teqls r0, r1, rrx"),
    (b"\x61\x00\x30\xa1", "teqge r0, r1, rrx"),
    (b"\x61\x00\x30\xb1", "teqlt r0, r1, rrx"),
    (b"\x61\x00\x30\xc1", "teqgt r0, r1, rrx"),
    (b"\x61\x00\x30\xd1", "teqle r0, r1, rrx"),
    (b"\x61\x00\x30\xe1", "teqal r0, r1, rrx"),

    # UXTH  -------------------------------------------------------------------- #
    (b"\x71\x00\xff\x06", "uxtheq r0, r1"),
    (b"\x71\x00\xff\x16", "uxthne r0, r1"),
    (b"\x71\x00\xff\x26", "uxthcs r0, r1"),
    (b"\x71\x00\xff\x36", "uxthcc r0, r1"),
    (b"\x71\x00\xff\x46", "uxthmi r0, r1"),
    (b"\x71\x00\xff\x56", "uxthpl r0, r1"),
    (b"\x71\x00\xff\x66", "uxthvs r0, r1"),
    (b"\x71\x00\xff\x76", "uxthvc r0, r1"),
    (b"\x71\x00\xff\x86", "uxthhi r0, r1"),
    (b"\x71\x00\xff\x96", "uxthls r0, r1"),
    (b"\x71\x00\xff\xa6", "uxthge r0, r1"),
    (b"\x71\x00\xff\xb6", "uxthlt r0, r1"),
    (b"\x71\x00\xff\xc6", "uxthgt r0, r1"),
    (b"\x71\x00\xff\xd6", "uxthle r0, r1"),
    (b"\x71\x00\xff\xe6", "uxthal r0, r1"),
    (b"\x71\x04\xff\x06", "uxtheq r0, r1, ror #8"),
    (b"\x71\x04\xff\x16", "uxthne r0, r1, ror #8"),
    (b"\x71\x04\xff\x26", "uxthcs r0, r1, ror #8"),
    (b"\x71\x04\xff\x36", "uxthcc r0, r1, ror #8"),
    (b"\x71\x04\xff\x46", "uxthmi r0, r1, ror #8"),
    (b"\x71\x04\xff\x56", "uxthpl r0, r1, ror #8"),
    (b"\x71\x04\xff\x66", "uxthvs r0, r1, ror #8"),
    (b"\x71\x04\xff\x76", "uxthvc r0, r1, ror #8"),
    (b"\x71\x04\xff\x86", "uxthhi r0, r1, ror #8"),
    (b"\x71\x04\xff\x96", "uxthls r0, r1, ror #8"),
    (b"\x71\x04\xff\xa6", "uxthge r0, r1, ror #8"),
    (b"\x71\x04\xff\xb6", "uxthlt r0, r1, ror #8"),
    (b"\x71\x04\xff\xc6", "uxthgt r0, r1, ror #8"),
    (b"\x71\x04\xff\xd6", "uxthle r0, r1, ror #8"),
    (b"\x71\x04\xff\xe6", "uxthal r0, r1, ror #8"),

    # UXTB  -------------------------------------------------------------------- #
    (b"\x71\x00\xef\x06", "uxtbeq r0, r1"),
    (b"\x71\x00\xef\x16", "uxtbne r0, r1"),
    (b"\x71\x00\xef\x26", "uxtbcs r0, r1"),
    (b"\x71\x00\xef\x36", "uxtbcc r0, r1"),
    (b"\x71\x00\xef\x46", "uxtbmi r0, r1"),
    (b"\x71\x00\xef\x56", "uxtbpl r0, r1"),
    (b"\x71\x00\xef\x66", "uxtbvs r0, r1"),
    (b"\x71\x00\xef\x76", "uxtbvc r0, r1"),
    (b"\x71\x00\xef\x86", "uxtbhi r0, r1"),
    (b"\x71\x00\xef\x96", "uxtbls r0, r1"),
    (b"\x71\x00\xef\xa6", "uxtbge r0, r1"),
    (b"\x71\x00\xef\xb6", "uxtblt r0, r1"),
    (b"\x71\x00\xef\xc6", "uxtbgt r0, r1"),
    (b"\x71\x00\xef\xd6", "uxtble r0, r1"),
    (b"\x71\x00\xef\xe6", "uxtbal r0, r1"),
    (b"\x71\x04\xef\x06", "uxtbeq r0, r1, ror #8"),
    (b"\x71\x04\xef\x16", "uxtbne r0, r1, ror #8"),
    (b"\x71\x04\xef\x26", "uxtbcs r0, r1, ror #8"),
    (b"\x71\x04\xef\x36", "uxtbcc r0, r1, ror #8"),
    (b"\x71\x04\xef\x46", "uxtbmi r0, r1, ror #8"),
    (b"\x71\x04\xef\x56", "uxtbpl r0, r1, ror #8"),
    (b"\x71\x04\xef\x66", "uxtbvs r0, r1, ror #8"),
    (b"\x71\x04\xef\x76", "uxtbvc r0, r1, ror #8"),
    (b"\x71\x04\xef\x86", "uxtbhi r0, r1, ror #8"),
    (b"\x71\x04\xef\x96", "uxtbls r0, r1, ror #8"),
    (b"\x71\x04\xef\xa6", "uxtbge r0, r1, ror #8"),
    (b"\x71\x04\xef\xb6", "uxtblt r0, r1, ror #8"),
    (b"\x71\x04\xef\xc6", "uxtbgt r0, r1, ror #8"),
    (b"\x71\x04\xef\xd6", "uxtble r0, r1, ror #8"),
    (b"\x71\x04\xef\xe6", "uxtbal r0, r1, ror #8"),

    # SXTH  -------------------------------------------------------------------- #
    (b"\x71\x00\xbf\x06", "sxtheq r0, r1"),
    (b"\x71\x00\xbf\x16", "sxthne r0, r1"),
    (b"\x71\x00\xbf\x26", "sxthcs r0, r1"),
    (b"\x71\x00\xbf\x36", "sxthcc r0, r1"),
    (b"\x71\x00\xbf\x46", "sxthmi r0, r1"),
    (b"\x71\x00\xbf\x56", "sxthpl r0, r1"),
    (b"\x71\x00\xbf\x66", "sxthvs r0, r1"),
    (b"\x71\x00\xbf\x76", "sxthvc r0, r1"),
    (b"\x71\x00\xbf\x86", "sxthhi r0, r1"),
    (b"\x71\x00\xbf\x96", "sxthls r0, r1"),
    (b"\x71\x00\xbf\xa6", "sxthge r0, r1"),
    (b"\x71\x00\xbf\xb6", "sxthlt r0, r1"),
    (b"\x71\x00\xbf\xc6", "sxthgt r0, r1"),
    (b"\x71\x00\xbf\xd6", "sxthle r0, r1"),
    (b"\x71\x00\xbf\xe6", "sxthal r0, r1"),
    (b"\x71\x04\xbf\x06", "sxtheq r0, r1, ror #8"),
    (b"\x71\x04\xbf\x16", "sxthne r0, r1, ror #8"),
    (b"\x71\x04\xbf\x26", "sxthcs r0, r1, ror #8"),
    (b"\x71\x04\xbf\x36", "sxthcc r0, r1, ror #8"),
    (b"\x71\x04\xbf\x46", "sxthmi r0, r1, ror #8"),
    (b"\x71\x04\xbf\x56", "sxthpl r0, r1, ror #8"),
    (b"\x71\x04\xbf\x66", "sxthvs r0, r1, ror #8"),
    (b"\x71\x04\xbf\x76", "sxthvc r0, r1, ror #8"),
    (b"\x71\x04\xbf\x86", "sxthhi r0, r1, ror #8"),
    (b"\x71\x04\xbf\x96", "sxthls r0, r1, ror #8"),
    (b"\x71\x04\xbf\xa6", "sxthge r0, r1, ror #8"),
    (b"\x71\x04\xbf\xb6", "sxthlt r0, r1, ror #8"),
    (b"\x71\x04\xbf\xc6", "sxthgt r0, r1, ror #8"),
    (b"\x71\x04\xbf\xd6", "sxthle r0, r1, ror #8"),
    (b"\x71\x04\xbf\xe6", "sxthal r0, r1, ror #8"),

    # SXTB  -------------------------------------------------------------------- #
    (b"\x71\x00\xaf\x06", "sxtbeq r0, r1"),
    (b"\x71\x00\xaf\x16", "sxtbne r0, r1"),
    (b"\x71\x00\xaf\x26", "sxtbcs r0, r1"),
    (b"\x71\x00\xaf\x36", "sxtbcc r0, r1"),
    (b"\x71\x00\xaf\x46", "sxtbmi r0, r1"),
    (b"\x71\x00\xaf\x56", "sxtbpl r0, r1"),
    (b"\x71\x00\xaf\x66", "sxtbvs r0, r1"),
    (b"\x71\x00\xaf\x76", "sxtbvc r0, r1"),
    (b"\x71\x00\xaf\x86", "sxtbhi r0, r1"),
    (b"\x71\x00\xaf\x96", "sxtbls r0, r1"),
    (b"\x71\x00\xaf\xa6", "sxtbge r0, r1"),
    (b"\x71\x00\xaf\xb6", "sxtblt r0, r1"),
    (b"\x71\x00\xaf\xc6", "sxtbgt r0, r1"),
    (b"\x71\x00\xaf\xd6", "sxtble r0, r1"),
    (b"\x71\x00\xaf\xe6", "sxtbal r0, r1"),
    (b"\x71\x04\xaf\x06", "sxtbeq r0, r1, ror #8"),
    (b"\x71\x04\xaf\x16", "sxtbne r0, r1, ror #8"),
    (b"\x71\x04\xaf\x26", "sxtbcs r0, r1, ror #8"),
    (b"\x71\x04\xaf\x36", "sxtbcc r0, r1, ror #8"),
    (b"\x71\x04\xaf\x46", "sxtbmi r0, r1, ror #8"),
    (b"\x71\x04\xaf\x56", "sxtbpl r0, r1, ror #8"),
    (b"\x71\x04\xaf\x66", "sxtbvs r0, r1, ror #8"),
    (b"\x71\x04\xaf\x76", "sxtbvc r0, r1, ror #8"),
    (b"\x71\x04\xaf\x86", "sxtbhi r0, r1, ror #8"),
    (b"\x71\x04\xaf\x96", "sxtbls r0, r1, ror #8"),
    (b"\x71\x04\xaf\xa6", "sxtbge r0, r1, ror #8"),
    (b"\x71\x04\xaf\xb6", "sxtblt r0, r1, ror #8"),
    (b"\x71\x04\xaf\xc6", "sxtbgt r0, r1, ror #8"),
    (b"\x71\x04\xaf\xd6", "sxtble r0, r1, ror #8"),
    (b"\x71\x04\xaf\xe6", "sxtbal r0, r1, ror #8"),

    (b"\x95\x06\x84\x00", "umulleq r0, r4, r5, r6"),
    (b"\x95\x06\x84\x10", "umullne r0, r4, r5, r6"),
    (b"\x95\x06\x84\x20", "umullcs r0, r4, r5, r6"),
    (b"\x95\x06\x84\x30", "umullcc r0, r4, r5, r6"),
    (b"\x95\x06\x84\x40", "umullmi r0, r4, r5, r6"),
    (b"\x95\x06\x84\x50", "umullpl r0, r4, r5, r6"),
    (b"\x95\x06\x84\x60", "umullvs r0, r4, r5, r6"),
    (b"\x95\x06\x84\x70", "umullvc r0, r4, r5, r6"),
    (b"\x95\x06\x84\x80", "umullhi r0, r4, r5, r6"),
    (b"\x95\x06\x84\x90", "umullls r0, r4, r5, r6"),
    (b"\x95\x06\x84\xa0", "umullge r0, r4, r5, r6"),
    (b"\x95\x06\x84\xb0", "umulllt r0, r4, r5, r6"),
    (b"\x95\x06\x84\xc0", "umullgt r0, r4, r5, r6"),
    (b"\x95\x06\x84\xd0", "umullle r0, r4, r5, r6"),
    (b"\x95\x06\x84\xe0", "umullal r0, r4, r5, r6"),
    (b"\x95\x06\x94\x00", "umullseq r0, r4, r5, r6"),
    (b"\x95\x06\x94\x10", "umullsne r0, r4, r5, r6"),
    (b"\x95\x06\x94\x20", "umullscs r0, r4, r5, r6"),
    (b"\x95\x06\x94\x30", "umullscc r0, r4, r5, r6"),
    (b"\x95\x06\x94\x40", "umullsmi r0, r4, r5, r6"),
    (b"\x95\x06\x94\x50", "umullspl r0, r4, r5, r6"),
    (b"\x95\x06\x94\x60", "umullsvs r0, r4, r5, r6"),
    (b"\x95\x06\x94\x70", "umullsvc r0, r4, r5, r6"),
    (b"\x95\x06\x94\x80", "umullshi r0, r4, r5, r6"),
    (b"\x95\x06\x94\x90", "umullsls r0, r4, r5, r6"),
    (b"\x95\x06\x94\xa0", "umullsge r0, r4, r5, r6"),
    (b"\x95\x06\x94\xb0", "umullslt r0, r4, r5, r6"),
    (b"\x95\x06\x94\xc0", "umullsgt r0, r4, r5, r6"),
    (b"\x95\x06\x94\xd0", "umullsle r0, r4, r5, r6"),
    (b"\x95\x06\x94\xe0", "umullsal r0, r4, r5, r6"),

    (b"\xd1\x06\xe6\x07", "ubfxeq r0, r1, #13, #7"),
    (b"\xd1\x06\xe6\x17", "ubfxne r0, r1, #13, #7"),
    (b"\xd1\x06\xe6\x27", "ubfxcs r0, r1, #13, #7"),
    (b"\xd1\x06\xe6\x37", "ubfxcc r0, r1, #13, #7"),
    (b"\xd1\x06\xe6\x47", "ubfxmi r0, r1, #13, #7"),
    (b"\xd1\x06\xe6\x57", "ubfxpl r0, r1, #13, #7"),
    (b"\xd1\x06\xe6\x67", "ubfxvs r0, r1, #13, #7"),
    (b"\xd1\x06\xe6\x77", "ubfxvc r0, r1, #13, #7"),
    (b"\xd1\x06\xe6\x87", "ubfxhi r0, r1, #13, #7"),
    (b"\xd1\x06\xe6\x97", "ubfxls r0, r1, #13, #7"),
    (b"\xd1\x06\xe6\xa7", "ubfxge r0, r1, #13, #7"),
    (b"\xd1\x06\xe6\xb7", "ubfxlt r0, r1, #13, #7"),
    (b"\xd1\x06\xe6\xc7", "ubfxgt r0, r1, #13, #7"),
    (b"\xd1\x06\xe6\xd7", "ubfxle r0, r1, #13, #7"),
    (b"\xd1\x06\xe6\xe7", "ubfxal r0, r1, #13, #7"),
    (b"\xd1\x02\xf2\x07", "ubfxeq r0, r1, #5, #19"),
    (b"\xd1\x02\xf2\x17", "ubfxne r0, r1, #5, #19"),
    (b"\xd1\x02\xf2\x27", "ubfxcs r0, r1, #5, #19"),
    (b"\xd1\x02\xf2\x37", "ubfxcc r0, r1, #5, #19"),
    (b"\xd1\x02\xf2\x47", "ubfxmi r0, r1, #5, #19"),
    (b"\xd1\x02\xf2\x57", "ubfxpl r0, r1, #5, #19"),
    (b"\xd1\x02\xf2\x67", "ubfxvs r0, r1, #5, #19"),
    (b"\xd1\x02\xf2\x77", "ubfxvc r0, r1, #5, #19"),
    (b"\xd1\x02\xf2\x87", "ubfxhi r0, r1, #5, #19"),
    (b"\xd1\x02\xf2\x97", "ubfxls r0, r1, #5, #19"),
    (b"\xd1\x02\xf2\xa7", "ubfxge r0, r1, #5, #19"),
    (b"\xd1\x02\xf2\xb7", "ubfxlt r0, r1, #5, #19"),
    (b"\xd1\x02\xf2\xc7", "ubfxgt r0, r1, #5, #19"),
    (b"\xd1\x02\xf2\xd7", "ubfxle r0, r1, #5, #19"),
    (b"\xd1\x02\xf2\xe7", "ubfxal r0, r1, #5, #19"),


    (b"\x11\xF2\x10\x07", "SDIVEQ R0, R1, R2"),
    (b"\x11\xF2\x11\x07", "SDIVEQ R1, R1, R2"),
    (b"\x11\xF2\x10\x17", "SDIVNE R0, R1, R2"),
    (b"\x11\xF2\x11\x17", "SDIVNE R1, R1, R2"),
    (b"\x11\xF2\x10\x27", "SDIVCS R0, R1, R2"),
    (b"\x11\xF2\x11\x27", "SDIVCS R1, R1, R2"),
    (b"\x11\xF2\x10\x37", "SDIVCC R0, R1, R2"),
    (b"\x11\xF2\x11\x37", "SDIVCC R1, R1, R2"),
    (b"\x11\xF2\x10\x47", "SDIVMI R0, R1, R2"),
    (b"\x11\xF2\x11\x47", "SDIVMI R1, R1, R2"),
    (b"\x11\xF2\x10\x57", "SDIVPL R0, R1, R2"),
    (b"\x11\xF2\x11\x57", "SDIVPL R1, R1, R2"),
    (b"\x11\xF2\x10\x67", "SDIVVS R0, R1, R2"),
    (b"\x11\xF2\x11\x67", "SDIVVS R1, R1, R2"),
    (b"\x11\xF2\x10\x77", "SDIVVC R0, R1, R2"),
    (b"\x11\xF2\x11\x77", "SDIVVC R1, R1, R2"),
    (b"\x11\xF2\x10\x87", "SDIVHI R0, R1, R2"),
    (b"\x11\xF2\x11\x87", "SDIVHI R1, R1, R2"),
    (b"\x11\xF2\x10\x97", "SDIVLS R0, R1, R2"),
    (b"\x11\xF2\x11\x97", "SDIVLS R1, R1, R2"),
    (b"\x11\xF2\x10\xA7", "SDIVGE R0, R1, R2"),
    (b"\x11\xF2\x11\xA7", "SDIVGE R1, R1, R2"),
    (b"\x11\xF2\x10\xB7", "SDIVLT R0, R1, R2"),
    (b"\x11\xF2\x11\xB7", "SDIVLT R1, R1, R2"),
    (b"\x11\xF2\x10\xC7", "SDIVGT R0, R1, R2"),
    (b"\x11\xF2\x11\xC7", "SDIVGT R1, R1, R2"),
    (b"\x11\xF2\x10\xD7", "SDIVLE R0, R1, R2"),
    (b"\x11\xF2\x11\xD7", "SDIVLE R1, R1, R2"),
    (b"\x11\xF2\x10\xE7", "SDIV   R0, R1, R2"),
    (b"\x11\xF2\x11\xE7", "SDIV   R1, R1, R2"),

    # SMLABB ----------------------------------------------------------------- #
    (b"\x81\x43\x00\xe1", "smlabb r0, r1, r3, r4"),
    (b"\x81\x43\x00\x01", "smlabbeq r0, r1, r3, r4"),
    (b"\x81\x43\x00\x11", "smlabbne r0, r1, r3, r4"),
    (b"\x81\x43\x00\x21", "smlabbcs r0, r1, r3, r4"),
    (b"\x81\x43\x00\x31", "smlabbcc r0, r1, r3, r4"),
    (b"\x81\x43\x00\x41", "smlabbmi r0, r1, r3, r4"),
    (b"\x81\x43\x00\x51", "smlabbpl r0, r1, r3, r4"),
    (b"\x81\x43\x00\x61", "smlabbvs r0, r1, r3, r4"),
    (b"\x81\x43\x00\x71", "smlabbvc r0, r1, r3, r4"),
    (b"\x81\x43\x00\x81", "smlabbhi r0, r1, r3, r4"),
    (b"\x81\x43\x00\x91", "smlabbls r0, r1, r3, r4"),
    (b"\x81\x43\x00\xa1", "smlabbge r0, r1, r3, r4"),
    (b"\x81\x43\x00\xb1", "smlabblt r0, r1, r3, r4"),
    (b"\x81\x43\x00\xc1", "smlabbgt r0, r1, r3, r4"),
    (b"\x81\x43\x00\xd1", "smlabble r0, r1, r3, r4"),
    (b"\x81\x43\x00\xe1", "smlabbal r0, r1, r3, r4"),

    # SMLABT ----------------------------------------------------------------- #
    (b"\xc1\x43\x00\xe1", "smlabt r0, r1, r3, r4"),
    (b"\xc1\x43\x00\x01", "smlabteq r0, r1, r3, r4"),
    (b"\xc1\x43\x00\x11", "smlabtne r0, r1, r3, r4"),
    (b"\xc1\x43\x00\x21", "smlabtcs r0, r1, r3, r4"),
    (b"\xc1\x43\x00\x31", "smlabtcc r0, r1, r3, r4"),
    (b"\xc1\x43\x00\x41", "smlabtmi r0, r1, r3, r4"),
    (b"\xc1\x43\x00\x51", "smlabtpl r0, r1, r3, r4"),
    (b"\xc1\x43\x00\x61", "smlabtvs r0, r1, r3, r4"),
    (b"\xc1\x43\x00\x71", "smlabtvc r0, r1, r3, r4"),
    (b"\xc1\x43\x00\x81", "smlabthi r0, r1, r3, r4"),
    (b"\xc1\x43\x00\x91", "smlabtls r0, r1, r3, r4"),
    (b"\xc1\x43\x00\xa1", "smlabtge r0, r1, r3, r4"),
    (b"\xc1\x43\x00\xb1", "smlabtlt r0, r1, r3, r4"),
    (b"\xc1\x43\x00\xc1", "smlabtgt r0, r1, r3, r4"),
    (b"\xc1\x43\x00\xd1", "smlabtle r0, r1, r3, r4"),
    (b"\xc1\x43\x00\xe1", "smlabtal r0, r1, r3, r4"),

    # SMLATB ----------------------------------------------------------------- #
    (b"\xa1\x43\x00\xe1", "smlatb r0, r1, r3, r4"),
    (b"\xa1\x43\x00\x01", "smlatbeq r0, r1, r3, r4"),
    (b"\xa1\x43\x00\x11", "smlatbne r0, r1, r3, r4"),
    (b"\xa1\x43\x00\x21", "smlatbcs r0, r1, r3, r4"),
    (b"\xa1\x43\x00\x31", "smlatbcc r0, r1, r3, r4"),
    (b"\xa1\x43\x00\x41", "smlatbmi r0, r1, r3, r4"),
    (b"\xa1\x43\x00\x51", "smlatbpl r0, r1, r3, r4"),
    (b"\xa1\x43\x00\x61", "smlatbvs r0, r1, r3, r4"),
    (b"\xa1\x43\x00\x71", "smlatbvc r0, r1, r3, r4"),
    (b"\xa1\x43\x00\x81", "smlatbhi r0, r1, r3, r4"),
    (b"\xa1\x43\x00\x91", "smlatbls r0, r1, r3, r4"),
    (b"\xa1\x43\x00\xa1", "smlatbge r0, r1, r3, r4"),
    (b"\xa1\x43\x00\xb1", "smlatblt r0, r1, r3, r4"),
    (b"\xa1\x43\x00\xc1", "smlatbgt r0, r1, r3, r4"),
    (b"\xa1\x43\x00\xd1", "smlatble r0, r1, r3, r4"),
    (b"\xa1\x43\x00\xe1", "smlatbal r0, r1, r3, r4"),

    # SMLATT ----------------------------------------------------------------- #
    (b"\xe1\x43\x00\xe1", "smlatt r0, r1, r3, r4"),
    (b"\xe1\x43\x00\x01", "smlatteq r0, r1, r3, r4"),
    (b"\xe1\x43\x00\x11", "smlattne r0, r1, r3, r4"),
    (b"\xe1\x43\x00\x21", "smlattcs r0, r1, r3, r4"),
    (b"\xe1\x43\x00\x31", "smlattcc r0, r1, r3, r4"),
    (b"\xe1\x43\x00\x41", "smlattmi r0, r1, r3, r4"),
    (b"\xe1\x43\x00\x51", "smlattpl r0, r1, r3, r4"),
    (b"\xe1\x43\x00\x61", "smlattvs r0, r1, r3, r4"),
    (b"\xe1\x43\x00\x71", "smlattvc r0, r1, r3, r4"),
    (b"\xe1\x43\x00\x81", "smlatthi r0, r1, r3, r4"),
    (b"\xe1\x43\x00\x91", "smlattls r0, r1, r3, r4"),
    (b"\xe1\x43\x00\xa1", "smlattge r0, r1, r3, r4"),
    (b"\xe1\x43\x00\xb1", "smlattlt r0, r1, r3, r4"),
    (b"\xe1\x43\x00\xc1", "smlattgt r0, r1, r3, r4"),
    (b"\xe1\x43\x00\xd1", "smlattle r0, r1, r3, r4"),
    (b"\xe1\x43\x00\xe1", "smlattal r0, r1, r3, r4"),

    (b"\x11\xF2\x30\x07", "UDIVEQ R0, R1, R2"),
    (b"\x11\xF2\x31\x07", "UDIVEQ R1, R1, R2"),
    (b"\x11\xF2\x30\x17", "UDIVNE R0, R1, R2"),
    (b"\x11\xF2\x31\x17", "UDIVNE R1, R1, R2"),
    (b"\x11\xF2\x30\x27", "UDIVCS R0, R1, R2"),
    (b"\x11\xF2\x31\x27", "UDIVCS R1, R1, R2"),
    (b"\x11\xF2\x30\x37", "UDIVCC R0, R1, R2"),
    (b"\x11\xF2\x31\x37", "UDIVCC R1, R1, R2"),
    (b"\x11\xF2\x30\x47", "UDIVMI R0, R1, R2"),
    (b"\x11\xF2\x31\x47", "UDIVMI R1, R1, R2"),
    (b"\x11\xF2\x30\x57", "UDIVPL R0, R1, R2"),
    (b"\x11\xF2\x31\x57", "UDIVPL R1, R1, R2"),
    (b"\x11\xF2\x30\x67", "UDIVVS R0, R1, R2"),
    (b"\x11\xF2\x31\x67", "UDIVVS R1, R1, R2"),
    (b"\x11\xF2\x30\x77", "UDIVVC R0, R1, R2"),
    (b"\x11\xF2\x31\x77", "UDIVVC R1, R1, R2"),
    (b"\x11\xF2\x30\x87", "UDIVHI R0, R1, R2"),
    (b"\x11\xF2\x31\x87", "UDIVHI R1, R1, R2"),
    (b"\x11\xF2\x30\x97", "UDIVLS R0, R1, R2"),
    (b"\x11\xF2\x31\x97", "UDIVLS R1, R1, R2"),
    (b"\x11\xF2\x30\xA7", "UDIVGE R0, R1, R2"),
    (b"\x11\xF2\x31\xA7", "UDIVGE R1, R1, R2"),
    (b"\x11\xF2\x30\xB7", "UDIVLT R0, R1, R2"),
    (b"\x11\xF2\x31\xB7", "UDIVLT R1, R1, R2"),
    (b"\x11\xF2\x30\xC7", "UDIVGT R0, R1, R2"),
    (b"\x11\xF2\x31\xC7", "UDIVGT R1, R1, R2"),
    (b"\x11\xF2\x30\xD7", "UDIVLE R0, R1, R2"),
    (b"\x11\xF2\x31\xD7", "UDIVLE R1, R1, R2"),
    (b"\x11\xF2\x30\xE7", "UDIV   R0, R1, R2"),
    (b"\x11\xF2\x31\xE7", "UDIV   R1, R1, R2"),

]


def emu_with_unicorn(opcode, istate):
    # Initialize emulator in arm32 mode.
    mu = Uc(UC_ARCH_ARM, UC_MODE_ARM)

    # Map memory for this emulation.
    mu.mem_map(ADDR, SIZE)

    # Write machine code to be emulated to memory.
    index = 0
    for op, _ in CODE:
        mu.mem_write(ADDR+index, op)
        index += len(op)

    # Retrieve APSR register value.
    apsr = mu.reg_read(UC_ARM_REG_APSR)
    nzcv = istate['n'] << 31 | istate['z'] << 30 | istate['c'] << 29 | istate['v'] << 28

    mu.mem_write(STACK,                bytes(istate['stack']))
    mu.mem_write(HEAP,                 bytes(istate['heap']))
    mu.reg_write(UC_ARM_REG_R0,        istate['r0'])
    mu.reg_write(UC_ARM_REG_R1,        istate['r1'])
    mu.reg_write(UC_ARM_REG_R2,        istate['r2'])
    mu.reg_write(UC_ARM_REG_R3,        istate['r3'])
    mu.reg_write(UC_ARM_REG_R4,        istate['r4'])
    mu.reg_write(UC_ARM_REG_R5,        istate['r5'])
    mu.reg_write(UC_ARM_REG_R6,        istate['r6'])
    mu.reg_write(UC_ARM_REG_R7,        istate['r7'])
    mu.reg_write(UC_ARM_REG_R8,        istate['r8'])
    mu.reg_write(UC_ARM_REG_R9,        istate['r9'])
    mu.reg_write(UC_ARM_REG_R10,       istate['r10'])
    mu.reg_write(UC_ARM_REG_R11,       istate['r11'])
    mu.reg_write(UC_ARM_REG_R12,       istate['r12'])
    mu.reg_write(UC_ARM_REG_SP,        istate['sp'])
    mu.reg_write(UC_ARM_REG_R14,       istate['r14'])
    mu.reg_write(UC_ARM_REG_PC,        istate['pc'])
    mu.reg_write(UC_ARM_REG_APSR,      apsr & 0x0fffffff | nzcv)

    # Emulate opcode.
    # NOTE: The +4 and count=1 is a trick so UC updates PC.
    mu.emu_start(istate['pc'], istate['pc'] + len(opcode) + 4, count=1)

    ostate = {
        "stack": bytearray(mu.mem_read(STACK, 0x100)),
        "heap":  bytearray(mu.mem_read(HEAP, 0x100)),
        "r0":    mu.reg_read(UC_ARM_REG_R0),
        "r1":    mu.reg_read(UC_ARM_REG_R1),
        "r2":    mu.reg_read(UC_ARM_REG_R2),
        "r3":    mu.reg_read(UC_ARM_REG_R3),
        "r4":    mu.reg_read(UC_ARM_REG_R4),
        "r5":    mu.reg_read(UC_ARM_REG_R5),
        "r6":    mu.reg_read(UC_ARM_REG_R6),
        "r7":    mu.reg_read(UC_ARM_REG_R7),
        "r8":    mu.reg_read(UC_ARM_REG_R8),
        "r9":    mu.reg_read(UC_ARM_REG_R9),
        "r10":   mu.reg_read(UC_ARM_REG_R10),
        "r11":   mu.reg_read(UC_ARM_REG_R11),
        "r12":   mu.reg_read(UC_ARM_REG_R12),
        "sp":    mu.reg_read(UC_ARM_REG_SP),
        "r14":   mu.reg_read(UC_ARM_REG_R14),
        "pc":    mu.reg_read(UC_ARM_REG_PC),
        "n":   ((mu.reg_read(UC_ARM_REG_APSR) >> 31) & 1),
        "z":   ((mu.reg_read(UC_ARM_REG_APSR) >> 30) & 1),
        "c":   ((mu.reg_read(UC_ARM_REG_APSR) >> 29) & 1),
        "v":   ((mu.reg_read(UC_ARM_REG_APSR) >> 28) & 1),
    }
    return ostate


def emu_with_triton(opcode, istate):
    ctx = TritonContext()
    ctx.setArchitecture(ARCH.ARM32)

    inst = Instruction(opcode)
    inst.setAddress(istate['pc'])

    ctx.setConcreteMemoryAreaValue(STACK,           bytes(istate['stack']))
    ctx.setConcreteMemoryAreaValue(HEAP,            bytes(istate['heap']))
    ctx.setConcreteRegisterValue(ctx.registers.r0,  istate['r0'])
    ctx.setConcreteRegisterValue(ctx.registers.r1,  istate['r1'])
    ctx.setConcreteRegisterValue(ctx.registers.r2,  istate['r2'])
    ctx.setConcreteRegisterValue(ctx.registers.r3,  istate['r3'])
    ctx.setConcreteRegisterValue(ctx.registers.r4,  istate['r4'])
    ctx.setConcreteRegisterValue(ctx.registers.r5,  istate['r5'])
    ctx.setConcreteRegisterValue(ctx.registers.r6,  istate['r6'])
    ctx.setConcreteRegisterValue(ctx.registers.r7,  istate['r7'])
    ctx.setConcreteRegisterValue(ctx.registers.r8,  istate['r8'])
    ctx.setConcreteRegisterValue(ctx.registers.r9,  istate['r9'])
    ctx.setConcreteRegisterValue(ctx.registers.r10, istate['r10'])
    ctx.setConcreteRegisterValue(ctx.registers.r11, istate['r11'])
    ctx.setConcreteRegisterValue(ctx.registers.r12, istate['r12'])
    ctx.setConcreteRegisterValue(ctx.registers.sp,  istate['sp'])
    ctx.setConcreteRegisterValue(ctx.registers.r14, istate['r14'])
    ctx.setConcreteRegisterValue(ctx.registers.pc,  istate['pc'])
    ctx.setConcreteRegisterValue(ctx.registers.n,   istate['n'])
    ctx.setConcreteRegisterValue(ctx.registers.z,   istate['z'])
    ctx.setConcreteRegisterValue(ctx.registers.c,   istate['c'])
    ctx.setConcreteRegisterValue(ctx.registers.v,   istate['v'])

    ctx.processing(inst)

    # print()
    # print(inst)
    # for x in inst.getSymbolicExpressions():
    #    print(x)
    # print()

    ostate = {
        "stack": bytearray(ctx.getConcreteMemoryAreaValue(STACK, 0x100)),
        "heap":  bytearray(ctx.getConcreteMemoryAreaValue(HEAP, 0x100)),
        "r0":    ctx.getSymbolicRegisterValue(ctx.registers.r0),
        "r1":    ctx.getSymbolicRegisterValue(ctx.registers.r1),
        "r2":    ctx.getSymbolicRegisterValue(ctx.registers.r2),
        "r3":    ctx.getSymbolicRegisterValue(ctx.registers.r3),
        "r4":    ctx.getSymbolicRegisterValue(ctx.registers.r4),
        "r5":    ctx.getSymbolicRegisterValue(ctx.registers.r5),
        "r6":    ctx.getSymbolicRegisterValue(ctx.registers.r6),
        "r7":    ctx.getSymbolicRegisterValue(ctx.registers.r7),
        "r8":    ctx.getSymbolicRegisterValue(ctx.registers.r8),
        "r9":    ctx.getSymbolicRegisterValue(ctx.registers.r9),
        "r10":   ctx.getSymbolicRegisterValue(ctx.registers.r10),
        "r11":   ctx.getSymbolicRegisterValue(ctx.registers.r11),
        "r12":   ctx.getSymbolicRegisterValue(ctx.registers.r12),
        "sp":    ctx.getSymbolicRegisterValue(ctx.registers.sp),
        "r14":   ctx.getSymbolicRegisterValue(ctx.registers.r14),
        "pc":    ctx.getSymbolicRegisterValue(ctx.registers.pc),
        "n":     ctx.getSymbolicRegisterValue(ctx.registers.n),
        "z":     ctx.getSymbolicRegisterValue(ctx.registers.z),
        "c":     ctx.getSymbolicRegisterValue(ctx.registers.c),
        "v":     ctx.getSymbolicRegisterValue(ctx.registers.v),
    }
    return ostate


def diff_state(state1, state2):
    for k, v in list(state1.items()):
        if (k == 'heap' or k == 'stack') and v != state2[k]:
            print('\t%s: (UC) != (TT)' %(k))
        elif not (k == 'heap' or k == 'stack') and v != state2[k]:
            print('\t%s: %#x (UC) != %#x (TT)' %(k, v, state2[k]))
    return


def print_state(istate, uc_ostate, tt_ostate):
    for k in sorted(istate.keys()):
        if k in ['stack', 'heap']:
            continue

        diff = "!=" if uc_ostate[k] != tt_ostate[k] else "=="

        print("{:>3s}: {:08x} | {:08x} {} {:08x}".format(k, istate[k], uc_ostate[k], diff, tt_ostate[k]))


if __name__ == '__main__':
    # Initial state.
    state = {
        "stack": bytearray([255 - i for i in range(256)]),
        "heap":  bytearray([i for i in range(256)]),
        "r0":    random.randint(0x0, 0xffffffff),
        "r1":    random.randint(0x0, 0xffffffff),
        "r2":    random.randint(0x0, 0xffffffff),
        "r3":    random.randint(0x0, 0xffffffff),
        "r4":    random.randint(0x0, 0xffffffff),
        "r5":    random.randint(0x0, 0xffffffff),
        "r6":    random.randint(0x0, 0xffffffff),
        "r7":    random.randint(0x0, 0xffffffff),
        "r8":    random.randint(0x0, 0xffffffff),
        "r9":    random.randint(0x0, 0xffffffff),
        "r10":   random.randint(0x0, 0xffffffff),
        "r11":   random.randint(0x0, 0xffffffff),
        "r12":   random.randint(0x0, 0xffffffff),
        "sp":    STACK,
        "r14":   random.randint(0x0, 0xffffffff),
        "pc":    ADDR,
        "n":     random.randint(0x0, 0x1),
        "z":     random.randint(0x0, 0x1),
        "c":     random.randint(0x0, 0x1),
        "v":     random.randint(0x0, 0x1),
    }

    # NOTE: This tests each instruction separately. Therefore, it keeps track of
    # PC and resets the initial state after testing each instruction.
    pc = ADDR
    for opcode, disassembly in CODE:
        try:
            state['pc'] = pc
            uc_state = emu_with_unicorn(opcode, state)
            tt_state = emu_with_triton(opcode, state)
            pc += len(opcode)
        except Exception as e:
            print('[KO] %s' %(disassembly))
            print('\t%s' %(e))
            sys.exit(-1)

        if uc_state != tt_state:
            print('[KO] %s' %(disassembly))
            diff_state(uc_state, tt_state)
            print_state(state, uc_state, tt_state)
            sys.exit(-1)

        print('[OK] %s' %(disassembly))

    sys.exit(0)
