//! \file
/*
**  Copyright (C) - Triton
**
**  This program is under the terms of the Apache License 2.0.
*/

#include <triton/pythonBindings.hpp>
#include <triton/pythonUtils.hpp>
#include <triton/pythonXFunctions.hpp>
#include <triton/aarch64Specifications.hpp>
#include <triton/arm32Specifications.hpp>
#include <triton/riscvSpecifications.hpp>
#include <triton/x86Specifications.hpp>



/*! \page py_OPCODE_page OPCODE
    \brief [**python api**] All information about the OPCODE Python namespace.

\tableofcontents

\section OPCODE_py_description Description
<hr>

According to the CPU architecture, the OPCODE namespace contains all kinds of opcodes.

\section OPCODE_py_api Python API - Items of the OPCODE namespace
<hr>

\subsection OPCODE_x86_py_api x86 and x86_64

- **OPCODE.X86.INVALID**<br>
- **OPCODE.X86.AAA**<br>
- **OPCODE.X86.AAD**<br>
- **OPCODE.X86.AAM**<br>
- **OPCODE.X86.AAS**<br>
- **OPCODE.X86.FABS**<br>
- **OPCODE.X86.ADC**<br>
- **OPCODE.X86.ADCX**<br>
- **OPCODE.X86.ADD**<br>
- **OPCODE.X86.ADDPD**<br>
- **OPCODE.X86.ADDPS**<br>
- **OPCODE.X86.ADDSD**<br>
- **OPCODE.X86.ADDSS**<br>
- **OPCODE.X86.ADDSUBPD**<br>
- **OPCODE.X86.ADDSUBPS**<br>
- **OPCODE.X86.FADD**<br>
- **OPCODE.X86.FIADD**<br>
- **OPCODE.X86.FADDP**<br>
- **OPCODE.X86.ADOX**<br>
- **OPCODE.X86.AESDECLAST**<br>
- **OPCODE.X86.AESDEC**<br>
- **OPCODE.X86.AESENCLAST**<br>
- **OPCODE.X86.AESENC**<br>
- **OPCODE.X86.AESIMC**<br>
- **OPCODE.X86.AESKEYGENASSIST**<br>
- **OPCODE.X86.AND**<br>
- **OPCODE.X86.ANDN**<br>
- **OPCODE.X86.ANDNPD**<br>
- **OPCODE.X86.ANDNPS**<br>
- **OPCODE.X86.ANDPD**<br>
- **OPCODE.X86.ANDPS**<br>
- **OPCODE.X86.ARPL**<br>
- **OPCODE.X86.BEXTR**<br>
- **OPCODE.X86.BLCFILL**<br>
- **OPCODE.X86.BLCI**<br>
- **OPCODE.X86.BLCIC**<br>
- **OPCODE.X86.BLCMSK**<br>
- **OPCODE.X86.BLCS**<br>
- **OPCODE.X86.BLENDPD**<br>
- **OPCODE.X86.BLENDPS**<br>
- **OPCODE.X86.BLENDVPD**<br>
- **OPCODE.X86.BLENDVPS**<br>
- **OPCODE.X86.BLSFILL**<br>
- **OPCODE.X86.BLSI**<br>
- **OPCODE.X86.BLSIC**<br>
- **OPCODE.X86.BLSMSK**<br>
- **OPCODE.X86.BLSR**<br>
- **OPCODE.X86.BOUND**<br>
- **OPCODE.X86.BSF**<br>
- **OPCODE.X86.BSR**<br>
- **OPCODE.X86.BSWAP**<br>
- **OPCODE.X86.BT**<br>
- **OPCODE.X86.BTC**<br>
- **OPCODE.X86.BTR**<br>
- **OPCODE.X86.BTS**<br>
- **OPCODE.X86.BZHI**<br>
- **OPCODE.X86.CALL**<br>
- **OPCODE.X86.CBW**<br>
- **OPCODE.X86.CDQ**<br>
- **OPCODE.X86.CDQE**<br>
- **OPCODE.X86.FCHS**<br>
- **OPCODE.X86.CLAC**<br>
- **OPCODE.X86.CLC**<br>
- **OPCODE.X86.CLD**<br>
- **OPCODE.X86.CLFLUSH**<br>
- **OPCODE.X86.CLGI**<br>
- **OPCODE.X86.CLI**<br>
- **OPCODE.X86.CLTS**<br>
- **OPCODE.X86.CMC**<br>
- **OPCODE.X86.CMOVA**<br>
- **OPCODE.X86.CMOVAE**<br>
- **OPCODE.X86.CMOVB**<br>
- **OPCODE.X86.CMOVBE**<br>
- **OPCODE.X86.FCMOVBE**<br>
- **OPCODE.X86.FCMOVB**<br>
- **OPCODE.X86.CMOVE**<br>
- **OPCODE.X86.FCMOVE**<br>
- **OPCODE.X86.CMOVG**<br>
- **OPCODE.X86.CMOVGE**<br>
- **OPCODE.X86.CMOVL**<br>
- **OPCODE.X86.CMOVLE**<br>
- **OPCODE.X86.FCMOVNBE**<br>
- **OPCODE.X86.FCMOVNB**<br>
- **OPCODE.X86.CMOVNE**<br>
- **OPCODE.X86.FCMOVNE**<br>
- **OPCODE.X86.CMOVNO**<br>
- **OPCODE.X86.CMOVNP**<br>
- **OPCODE.X86.FCMOVNU**<br>
- **OPCODE.X86.CMOVNS**<br>
- **OPCODE.X86.CMOVO**<br>
- **OPCODE.X86.CMOVP**<br>
- **OPCODE.X86.FCMOVU**<br>
- **OPCODE.X86.CMOVS**<br>
- **OPCODE.X86.CMP**<br>
- **OPCODE.X86.CMPPD**<br>
- **OPCODE.X86.CMPPS**<br>
- **OPCODE.X86.CMPSB**<br>
- **OPCODE.X86.CMPSD**<br>
- **OPCODE.X86.CMPSQ**<br>
- **OPCODE.X86.CMPSS**<br>
- **OPCODE.X86.CMPSW**<br>
- **OPCODE.X86.CMPXCHG16B**<br>
- **OPCODE.X86.CMPXCHG**<br>
- **OPCODE.X86.CMPXCHG8B**<br>
- **OPCODE.X86.COMISD**<br>
- **OPCODE.X86.COMISS**<br>
- **OPCODE.X86.FCOMP**<br>
- **OPCODE.X86.FCOMPI**<br>
- **OPCODE.X86.FCOMI**<br>
- **OPCODE.X86.FCOM**<br>
- **OPCODE.X86.FCOS**<br>
- **OPCODE.X86.CPUID**<br>
- **OPCODE.X86.CQO**<br>
- **OPCODE.X86.CRC32**<br>
- **OPCODE.X86.CVTDQ2PD**<br>
- **OPCODE.X86.CVTDQ2PS**<br>
- **OPCODE.X86.CVTPD2DQ**<br>
- **OPCODE.X86.CVTPD2PS**<br>
- **OPCODE.X86.CVTPS2DQ**<br>
- **OPCODE.X86.CVTPS2PD**<br>
- **OPCODE.X86.CVTSD2SI**<br>
- **OPCODE.X86.CVTSD2SS**<br>
- **OPCODE.X86.CVTSI2SD**<br>
- **OPCODE.X86.CVTSI2SS**<br>
- **OPCODE.X86.CVTSS2SD**<br>
- **OPCODE.X86.CVTSS2SI**<br>
- **OPCODE.X86.CVTTPD2DQ**<br>
- **OPCODE.X86.CVTTPS2DQ**<br>
- **OPCODE.X86.CVTTSD2SI**<br>
- **OPCODE.X86.CVTTSS2SI**<br>
- **OPCODE.X86.CWD**<br>
- **OPCODE.X86.CWDE**<br>
- **OPCODE.X86.DAA**<br>
- **OPCODE.X86.DAS**<br>
- **OPCODE.X86.DATA16**<br>
- **OPCODE.X86.DEC**<br>
- **OPCODE.X86.DIV**<br>
- **OPCODE.X86.DIVPD**<br>
- **OPCODE.X86.DIVPS**<br>
- **OPCODE.X86.FDIVR**<br>
- **OPCODE.X86.FIDIVR**<br>
- **OPCODE.X86.FDIVRP**<br>
- **OPCODE.X86.DIVSD**<br>
- **OPCODE.X86.DIVSS**<br>
- **OPCODE.X86.FDIV**<br>
- **OPCODE.X86.FIDIV**<br>
- **OPCODE.X86.FDIVP**<br>
- **OPCODE.X86.DPPD**<br>
- **OPCODE.X86.DPPS**<br>
- **OPCODE.X86.RET**<br>
- **OPCODE.X86.ENCLS**<br>
- **OPCODE.X86.ENCLU**<br>
- **OPCODE.X86.ENTER**<br>
- **OPCODE.X86.EXTRACTPS**<br>
- **OPCODE.X86.EXTRQ**<br>
- **OPCODE.X86.F2XM1**<br>
- **OPCODE.X86.LCALL**<br>
- **OPCODE.X86.LJMP**<br>
- **OPCODE.X86.FBLD**<br>
- **OPCODE.X86.FBSTP**<br>
- **OPCODE.X86.FCOMPP**<br>
- **OPCODE.X86.FDECSTP**<br>
- **OPCODE.X86.FEMMS**<br>
- **OPCODE.X86.FFREE**<br>
- **OPCODE.X86.FICOM**<br>
- **OPCODE.X86.FICOMP**<br>
- **OPCODE.X86.FINCSTP**<br>
- **OPCODE.X86.FLDCW**<br>
- **OPCODE.X86.FLDENV**<br>
- **OPCODE.X86.FLDL2E**<br>
- **OPCODE.X86.FLDL2T**<br>
- **OPCODE.X86.FLDLG2**<br>
- **OPCODE.X86.FLDLN2**<br>
- **OPCODE.X86.FLDPI**<br>
- **OPCODE.X86.FNCLEX**<br>
- **OPCODE.X86.FNINIT**<br>
- **OPCODE.X86.FNOP**<br>
- **OPCODE.X86.FNSTCW**<br>
- **OPCODE.X86.FNSTSW**<br>
- **OPCODE.X86.FPATAN**<br>
- **OPCODE.X86.FPREM**<br>
- **OPCODE.X86.FPREM1**<br>
- **OPCODE.X86.FPTAN**<br>
- **OPCODE.X86.FRNDINT**<br>
- **OPCODE.X86.FRSTOR**<br>
- **OPCODE.X86.FNSAVE**<br>
- **OPCODE.X86.FSCALE**<br>
- **OPCODE.X86.FSETPM**<br>
- **OPCODE.X86.FSINCOS**<br>
- **OPCODE.X86.FNSTENV**<br>
- **OPCODE.X86.FXAM**<br>
- **OPCODE.X86.FXRSTOR**<br>
- **OPCODE.X86.FXRSTOR64**<br>
- **OPCODE.X86.FXSAVE**<br>
- **OPCODE.X86.FXSAVE64**<br>
- **OPCODE.X86.FXTRACT**<br>
- **OPCODE.X86.FYL2X**<br>
- **OPCODE.X86.FYL2XP1**<br>
- **OPCODE.X86.MOVAPD**<br>
- **OPCODE.X86.MOVAPS**<br>
- **OPCODE.X86.ORPD**<br>
- **OPCODE.X86.ORPS**<br>
- **OPCODE.X86.VMOVAPD**<br>
- **OPCODE.X86.VMOVAPS**<br>
- **OPCODE.X86.XORPD**<br>
- **OPCODE.X86.XORPS**<br>
- **OPCODE.X86.GETSEC**<br>
- **OPCODE.X86.HADDPD**<br>
- **OPCODE.X86.HADDPS**<br>
- **OPCODE.X86.HLT**<br>
- **OPCODE.X86.HSUBPD**<br>
- **OPCODE.X86.HSUBPS**<br>
- **OPCODE.X86.IDIV**<br>
- **OPCODE.X86.FILD**<br>
- **OPCODE.X86.IMUL**<br>
- **OPCODE.X86.IN**<br>
- **OPCODE.X86.INC**<br>
- **OPCODE.X86.INSB**<br>
- **OPCODE.X86.INSERTPS**<br>
- **OPCODE.X86.INSERTQ**<br>
- **OPCODE.X86.INSD**<br>
- **OPCODE.X86.INSW**<br>
- **OPCODE.X86.INT**<br>
- **OPCODE.X86.INT1**<br>
- **OPCODE.X86.INT3**<br>
- **OPCODE.X86.INTO**<br>
- **OPCODE.X86.INVD**<br>
- **OPCODE.X86.INVEPT**<br>
- **OPCODE.X86.INVLPG**<br>
- **OPCODE.X86.INVLPGA**<br>
- **OPCODE.X86.INVPCID**<br>
- **OPCODE.X86.INVVPID**<br>
- **OPCODE.X86.IRET**<br>
- **OPCODE.X86.IRETD**<br>
- **OPCODE.X86.IRETQ**<br>
- **OPCODE.X86.FISTTP**<br>
- **OPCODE.X86.FIST**<br>
- **OPCODE.X86.FISTP**<br>
- **OPCODE.X86.UCOMISD**<br>
- **OPCODE.X86.UCOMISS**<br>
- **OPCODE.X86.VCMP**<br>
- **OPCODE.X86.VCOMISD**<br>
- **OPCODE.X86.VCOMISS**<br>
- **OPCODE.X86.VCVTSD2SS**<br>
- **OPCODE.X86.VCVTSI2SD**<br>
- **OPCODE.X86.VCVTSI2SS**<br>
- **OPCODE.X86.VCVTSS2SD**<br>
- **OPCODE.X86.VCVTTSD2SI**<br>
- **OPCODE.X86.VCVTTSD2USI**<br>
- **OPCODE.X86.VCVTTSS2SI**<br>
- **OPCODE.X86.VCVTTSS2USI**<br>
- **OPCODE.X86.VCVTUSI2SD**<br>
- **OPCODE.X86.VCVTUSI2SS**<br>
- **OPCODE.X86.VUCOMISD**<br>
- **OPCODE.X86.VUCOMISS**<br>
- **OPCODE.X86.JAE**<br>
- **OPCODE.X86.JA**<br>
- **OPCODE.X86.JBE**<br>
- **OPCODE.X86.JB**<br>
- **OPCODE.X86.JCXZ**<br>
- **OPCODE.X86.JECXZ**<br>
- **OPCODE.X86.JE**<br>
- **OPCODE.X86.JGE**<br>
- **OPCODE.X86.JG**<br>
- **OPCODE.X86.JLE**<br>
- **OPCODE.X86.JL**<br>
- **OPCODE.X86.JMP**<br>
- **OPCODE.X86.JNE**<br>
- **OPCODE.X86.JNO**<br>
- **OPCODE.X86.JNP**<br>
- **OPCODE.X86.JNS**<br>
- **OPCODE.X86.JO**<br>
- **OPCODE.X86.JP**<br>
- **OPCODE.X86.JRCXZ**<br>
- **OPCODE.X86.JS**<br>
- **OPCODE.X86.KANDB**<br>
- **OPCODE.X86.KANDD**<br>
- **OPCODE.X86.KANDNB**<br>
- **OPCODE.X86.KANDND**<br>
- **OPCODE.X86.KANDNQ**<br>
- **OPCODE.X86.KANDNW**<br>
- **OPCODE.X86.KANDQ**<br>
- **OPCODE.X86.KANDW**<br>
- **OPCODE.X86.KMOVB**<br>
- **OPCODE.X86.KMOVD**<br>
- **OPCODE.X86.KMOVQ**<br>
- **OPCODE.X86.KMOVW**<br>
- **OPCODE.X86.KNOTB**<br>
- **OPCODE.X86.KNOTD**<br>
- **OPCODE.X86.KNOTQ**<br>
- **OPCODE.X86.KNOTW**<br>
- **OPCODE.X86.KORB**<br>
- **OPCODE.X86.KORD**<br>
- **OPCODE.X86.KORQ**<br>
- **OPCODE.X86.KORTESTW**<br>
- **OPCODE.X86.KORW**<br>
- **OPCODE.X86.KSHIFTLW**<br>
- **OPCODE.X86.KSHIFTRW**<br>
- **OPCODE.X86.KUNPCKBW**<br>
- **OPCODE.X86.KXNORB**<br>
- **OPCODE.X86.KXNORD**<br>
- **OPCODE.X86.KXNORQ**<br>
- **OPCODE.X86.KXNORW**<br>
- **OPCODE.X86.KXORB**<br>
- **OPCODE.X86.KXORD**<br>
- **OPCODE.X86.KXORQ**<br>
- **OPCODE.X86.KXORW**<br>
- **OPCODE.X86.LAHF**<br>
- **OPCODE.X86.LAR**<br>
- **OPCODE.X86.LDDQU**<br>
- **OPCODE.X86.LDMXCSR**<br>
- **OPCODE.X86.LDS**<br>
- **OPCODE.X86.FLDZ**<br>
- **OPCODE.X86.FLD1**<br>
- **OPCODE.X86.FLD**<br>
- **OPCODE.X86.LEA**<br>
- **OPCODE.X86.LEAVE**<br>
- **OPCODE.X86.LES**<br>
- **OPCODE.X86.LFENCE**<br>
- **OPCODE.X86.LFS**<br>
- **OPCODE.X86.LGDT**<br>
- **OPCODE.X86.LGS**<br>
- **OPCODE.X86.LIDT**<br>
- **OPCODE.X86.LLDT**<br>
- **OPCODE.X86.LMSW**<br>
- **OPCODE.X86.OR**<br>
- **OPCODE.X86.SUB**<br>
- **OPCODE.X86.XOR**<br>
- **OPCODE.X86.LODSB**<br>
- **OPCODE.X86.LODSD**<br>
- **OPCODE.X86.LODSQ**<br>
- **OPCODE.X86.LODSW**<br>
- **OPCODE.X86.LOOP**<br>
- **OPCODE.X86.LOOPE**<br>
- **OPCODE.X86.LOOPNE**<br>
- **OPCODE.X86.RETF**<br>
- **OPCODE.X86.RETFQ**<br>
- **OPCODE.X86.LSL**<br>
- **OPCODE.X86.LSS**<br>
- **OPCODE.X86.LTR**<br>
- **OPCODE.X86.XADD**<br>
- **OPCODE.X86.LZCNT**<br>
- **OPCODE.X86.MASKMOVDQU**<br>
- **OPCODE.X86.MAXPD**<br>
- **OPCODE.X86.MAXPS**<br>
- **OPCODE.X86.MAXSD**<br>
- **OPCODE.X86.MAXSS**<br>
- **OPCODE.X86.MFENCE**<br>
- **OPCODE.X86.MINPD**<br>
- **OPCODE.X86.MINPS**<br>
- **OPCODE.X86.MINSD**<br>
- **OPCODE.X86.MINSS**<br>
- **OPCODE.X86.CVTPD2PI**<br>
- **OPCODE.X86.CVTPI2PD**<br>
- **OPCODE.X86.CVTPI2PS**<br>
- **OPCODE.X86.CVTPS2PI**<br>
- **OPCODE.X86.CVTTPD2PI**<br>
- **OPCODE.X86.CVTTPS2PI**<br>
- **OPCODE.X86.EMMS**<br>
- **OPCODE.X86.MASKMOVQ**<br>
- **OPCODE.X86.MOVD**<br>
- **OPCODE.X86.MOVDQ2Q**<br>
- **OPCODE.X86.MOVNTQ**<br>
- **OPCODE.X86.MOVQ2DQ**<br>
- **OPCODE.X86.MOVQ**<br>
- **OPCODE.X86.PABSB**<br>
- **OPCODE.X86.PABSD**<br>
- **OPCODE.X86.PABSW**<br>
- **OPCODE.X86.PACKSSDW**<br>
- **OPCODE.X86.PACKSSWB**<br>
- **OPCODE.X86.PACKUSWB**<br>
- **OPCODE.X86.PADDB**<br>
- **OPCODE.X86.PADDD**<br>
- **OPCODE.X86.PADDQ**<br>
- **OPCODE.X86.PADDSB**<br>
- **OPCODE.X86.PADDSW**<br>
- **OPCODE.X86.PADDUSB**<br>
- **OPCODE.X86.PADDUSW**<br>
- **OPCODE.X86.PADDW**<br>
- **OPCODE.X86.PALIGNR**<br>
- **OPCODE.X86.PANDN**<br>
- **OPCODE.X86.PAND**<br>
- **OPCODE.X86.PAVGB**<br>
- **OPCODE.X86.PAVGW**<br>
- **OPCODE.X86.PCMPEQB**<br>
- **OPCODE.X86.PCMPEQD**<br>
- **OPCODE.X86.PCMPEQW**<br>
- **OPCODE.X86.PCMPGTB**<br>
- **OPCODE.X86.PCMPGTD**<br>
- **OPCODE.X86.PCMPGTW**<br>
- **OPCODE.X86.PEXTRW**<br>
- **OPCODE.X86.PHADDSW**<br>
- **OPCODE.X86.PHADDW**<br>
- **OPCODE.X86.PHADDD**<br>
- **OPCODE.X86.PHSUBD**<br>
- **OPCODE.X86.PHSUBSW**<br>
- **OPCODE.X86.PHSUBW**<br>
- **OPCODE.X86.PINSRW**<br>
- **OPCODE.X86.PMADDUBSW**<br>
- **OPCODE.X86.PMADDWD**<br>
- **OPCODE.X86.PMAXSW**<br>
- **OPCODE.X86.PMAXUB**<br>
- **OPCODE.X86.PMINSW**<br>
- **OPCODE.X86.PMINUB**<br>
- **OPCODE.X86.PMOVMSKB**<br>
- **OPCODE.X86.PMULHRSW**<br>
- **OPCODE.X86.PMULHUW**<br>
- **OPCODE.X86.PMULHW**<br>
- **OPCODE.X86.PMULLW**<br>
- **OPCODE.X86.PMULUDQ**<br>
- **OPCODE.X86.POR**<br>
- **OPCODE.X86.PSADBW**<br>
- **OPCODE.X86.PSHUFB**<br>
- **OPCODE.X86.PSHUFW**<br>
- **OPCODE.X86.PSIGNB**<br>
- **OPCODE.X86.PSIGND**<br>
- **OPCODE.X86.PSIGNW**<br>
- **OPCODE.X86.PSLLD**<br>
- **OPCODE.X86.PSLLQ**<br>
- **OPCODE.X86.PSLLW**<br>
- **OPCODE.X86.PSRAD**<br>
- **OPCODE.X86.PSRAW**<br>
- **OPCODE.X86.PSRLD**<br>
- **OPCODE.X86.PSRLQ**<br>
- **OPCODE.X86.PSRLW**<br>
- **OPCODE.X86.PSUBB**<br>
- **OPCODE.X86.PSUBD**<br>
- **OPCODE.X86.PSUBQ**<br>
- **OPCODE.X86.PSUBSB**<br>
- **OPCODE.X86.PSUBSW**<br>
- **OPCODE.X86.PSUBUSB**<br>
- **OPCODE.X86.PSUBUSW**<br>
- **OPCODE.X86.PSUBW**<br>
- **OPCODE.X86.PUNPCKHBW**<br>
- **OPCODE.X86.PUNPCKHDQ**<br>
- **OPCODE.X86.PUNPCKHWD**<br>
- **OPCODE.X86.PUNPCKLBW**<br>
- **OPCODE.X86.PUNPCKLDQ**<br>
- **OPCODE.X86.PUNPCKLWD**<br>
- **OPCODE.X86.PXOR**<br>
- **OPCODE.X86.MONITOR**<br>
- **OPCODE.X86.MONTMUL**<br>
- **OPCODE.X86.MOV**<br>
- **OPCODE.X86.MOVABS**<br>
- **OPCODE.X86.MOVBE**<br>
- **OPCODE.X86.MOVDDUP**<br>
- **OPCODE.X86.MOVDQA**<br>
- **OPCODE.X86.MOVDQU**<br>
- **OPCODE.X86.MOVHLPS**<br>
- **OPCODE.X86.MOVHPD**<br>
- **OPCODE.X86.MOVHPS**<br>
- **OPCODE.X86.MOVLHPS**<br>
- **OPCODE.X86.MOVLPD**<br>
- **OPCODE.X86.MOVLPS**<br>
- **OPCODE.X86.MOVMSKPD**<br>
- **OPCODE.X86.MOVMSKPS**<br>
- **OPCODE.X86.MOVNTDQA**<br>
- **OPCODE.X86.MOVNTDQ**<br>
- **OPCODE.X86.MOVNTI**<br>
- **OPCODE.X86.MOVNTPD**<br>
- **OPCODE.X86.MOVNTPS**<br>
- **OPCODE.X86.MOVNTSD**<br>
- **OPCODE.X86.MOVNTSS**<br>
- **OPCODE.X86.MOVSB**<br>
- **OPCODE.X86.MOVSD**<br>
- **OPCODE.X86.MOVSHDUP**<br>
- **OPCODE.X86.MOVSLDUP**<br>
- **OPCODE.X86.MOVSQ**<br>
- **OPCODE.X86.MOVSS**<br>
- **OPCODE.X86.MOVSW**<br>
- **OPCODE.X86.MOVSX**<br>
- **OPCODE.X86.MOVSXD**<br>
- **OPCODE.X86.MOVUPD**<br>
- **OPCODE.X86.MOVUPS**<br>
- **OPCODE.X86.MOVZX**<br>
- **OPCODE.X86.MPSADBW**<br>
- **OPCODE.X86.MUL**<br>
- **OPCODE.X86.MULPD**<br>
- **OPCODE.X86.MULPS**<br>
- **OPCODE.X86.MULSD**<br>
- **OPCODE.X86.MULSS**<br>
- **OPCODE.X86.MULX**<br>
- **OPCODE.X86.FMUL**<br>
- **OPCODE.X86.FIMUL**<br>
- **OPCODE.X86.FMULP**<br>
- **OPCODE.X86.MWAIT**<br>
- **OPCODE.X86.NEG**<br>
- **OPCODE.X86.NOP**<br>
- **OPCODE.X86.NOT**<br>
- **OPCODE.X86.OUT**<br>
- **OPCODE.X86.OUTSB**<br>
- **OPCODE.X86.OUTSD**<br>
- **OPCODE.X86.OUTSW**<br>
- **OPCODE.X86.PACKUSDW**<br>
- **OPCODE.X86.PAUSE**<br>
- **OPCODE.X86.PAVGUSB**<br>
- **OPCODE.X86.PBLENDVB**<br>
- **OPCODE.X86.PBLENDW**<br>
- **OPCODE.X86.PCLMULQDQ**<br>
- **OPCODE.X86.PCMPEQQ**<br>
- **OPCODE.X86.PCMPESTRI**<br>
- **OPCODE.X86.PCMPESTRM**<br>
- **OPCODE.X86.PCMPGTQ**<br>
- **OPCODE.X86.PCMPISTRI**<br>
- **OPCODE.X86.PCMPISTRM**<br>
- **OPCODE.X86.PDEP**<br>
- **OPCODE.X86.PEXT**<br>
- **OPCODE.X86.PEXTRB**<br>
- **OPCODE.X86.PEXTRD**<br>
- **OPCODE.X86.PEXTRQ**<br>
- **OPCODE.X86.PF2ID**<br>
- **OPCODE.X86.PF2IW**<br>
- **OPCODE.X86.PFACC**<br>
- **OPCODE.X86.PFADD**<br>
- **OPCODE.X86.PFCMPEQ**<br>
- **OPCODE.X86.PFCMPGE**<br>
- **OPCODE.X86.PFCMPGT**<br>
- **OPCODE.X86.PFMAX**<br>
- **OPCODE.X86.PFMIN**<br>
- **OPCODE.X86.PFMUL**<br>
- **OPCODE.X86.PFNACC**<br>
- **OPCODE.X86.PFPNACC**<br>
- **OPCODE.X86.PFRCPIT1**<br>
- **OPCODE.X86.PFRCPIT2**<br>
- **OPCODE.X86.PFRCP**<br>
- **OPCODE.X86.PFRSQIT1**<br>
- **OPCODE.X86.PFRSQRT**<br>
- **OPCODE.X86.PFSUBR**<br>
- **OPCODE.X86.PFSUB**<br>
- **OPCODE.X86.PHMINPOSUW**<br>
- **OPCODE.X86.PI2FD**<br>
- **OPCODE.X86.PI2FW**<br>
- **OPCODE.X86.PINSRB**<br>
- **OPCODE.X86.PINSRD**<br>
- **OPCODE.X86.PINSRQ**<br>
- **OPCODE.X86.PMAXSB**<br>
- **OPCODE.X86.PMAXSD**<br>
- **OPCODE.X86.PMAXUD**<br>
- **OPCODE.X86.PMAXUW**<br>
- **OPCODE.X86.PMINSB**<br>
- **OPCODE.X86.PMINSD**<br>
- **OPCODE.X86.PMINUD**<br>
- **OPCODE.X86.PMINUW**<br>
- **OPCODE.X86.PMOVSXBD**<br>
- **OPCODE.X86.PMOVSXBQ**<br>
- **OPCODE.X86.PMOVSXBW**<br>
- **OPCODE.X86.PMOVSXDQ**<br>
- **OPCODE.X86.PMOVSXWD**<br>
- **OPCODE.X86.PMOVSXWQ**<br>
- **OPCODE.X86.PMOVZXBD**<br>
- **OPCODE.X86.PMOVZXBQ**<br>
- **OPCODE.X86.PMOVZXBW**<br>
- **OPCODE.X86.PMOVZXDQ**<br>
- **OPCODE.X86.PMOVZXWD**<br>
- **OPCODE.X86.PMOVZXWQ**<br>
- **OPCODE.X86.PMULDQ**<br>
- **OPCODE.X86.PMULHRW**<br>
- **OPCODE.X86.PMULLD**<br>
- **OPCODE.X86.POP**<br>
- **OPCODE.X86.POPAW**<br>
- **OPCODE.X86.POPAL**<br>
- **OPCODE.X86.POPCNT**<br>
- **OPCODE.X86.POPF**<br>
- **OPCODE.X86.POPFD**<br>
- **OPCODE.X86.POPFQ**<br>
- **OPCODE.X86.PREFETCH**<br>
- **OPCODE.X86.PREFETCHNTA**<br>
- **OPCODE.X86.PREFETCHT0**<br>
- **OPCODE.X86.PREFETCHT1**<br>
- **OPCODE.X86.PREFETCHT2**<br>
- **OPCODE.X86.PREFETCHW**<br>
- **OPCODE.X86.PSHUFD**<br>
- **OPCODE.X86.PSHUFHW**<br>
- **OPCODE.X86.PSHUFLW**<br>
- **OPCODE.X86.PSLLDQ**<br>
- **OPCODE.X86.PSRLDQ**<br>
- **OPCODE.X86.PSWAPD**<br>
- **OPCODE.X86.PTEST**<br>
- **OPCODE.X86.PUNPCKHQDQ**<br>
- **OPCODE.X86.PUNPCKLQDQ**<br>
- **OPCODE.X86.PUSH**<br>
- **OPCODE.X86.PUSHAW**<br>
- **OPCODE.X86.PUSHAL**<br>
- **OPCODE.X86.PUSHF**<br>
- **OPCODE.X86.PUSHFD**<br>
- **OPCODE.X86.PUSHFQ**<br>
- **OPCODE.X86.RCL**<br>
- **OPCODE.X86.RCPPS**<br>
- **OPCODE.X86.RCPSS**<br>
- **OPCODE.X86.RCR**<br>
- **OPCODE.X86.RDFSBASE**<br>
- **OPCODE.X86.RDGSBASE**<br>
- **OPCODE.X86.RDMSR**<br>
- **OPCODE.X86.RDPMC**<br>
- **OPCODE.X86.RDRAND**<br>
- **OPCODE.X86.RDSEED**<br>
- **OPCODE.X86.RDTSC**<br>
- **OPCODE.X86.RDTSCP**<br>
- **OPCODE.X86.ROL**<br>
- **OPCODE.X86.ROR**<br>
- **OPCODE.X86.RORX**<br>
- **OPCODE.X86.ROUNDPD**<br>
- **OPCODE.X86.ROUNDPS**<br>
- **OPCODE.X86.ROUNDSD**<br>
- **OPCODE.X86.ROUNDSS**<br>
- **OPCODE.X86.RSM**<br>
- **OPCODE.X86.RSQRTPS**<br>
- **OPCODE.X86.RSQRTSS**<br>
- **OPCODE.X86.SAHF**<br>
- **OPCODE.X86.SAL**<br>
- **OPCODE.X86.SALC**<br>
- **OPCODE.X86.SAR**<br>
- **OPCODE.X86.SARX**<br>
- **OPCODE.X86.SBB**<br>
- **OPCODE.X86.SCASB**<br>
- **OPCODE.X86.SCASD**<br>
- **OPCODE.X86.SCASQ**<br>
- **OPCODE.X86.SCASW**<br>
- **OPCODE.X86.SETAE**<br>
- **OPCODE.X86.SETA**<br>
- **OPCODE.X86.SETBE**<br>
- **OPCODE.X86.SETB**<br>
- **OPCODE.X86.SETE**<br>
- **OPCODE.X86.SETGE**<br>
- **OPCODE.X86.SETG**<br>
- **OPCODE.X86.SETLE**<br>
- **OPCODE.X86.SETL**<br>
- **OPCODE.X86.SETNE**<br>
- **OPCODE.X86.SETNO**<br>
- **OPCODE.X86.SETNP**<br>
- **OPCODE.X86.SETNS**<br>
- **OPCODE.X86.SETO**<br>
- **OPCODE.X86.SETP**<br>
- **OPCODE.X86.SETS**<br>
- **OPCODE.X86.SFENCE**<br>
- **OPCODE.X86.SGDT**<br>
- **OPCODE.X86.SHA1MSG1**<br>
- **OPCODE.X86.SHA1MSG2**<br>
- **OPCODE.X86.SHA1NEXTE**<br>
- **OPCODE.X86.SHA1RNDS4**<br>
- **OPCODE.X86.SHA256MSG1**<br>
- **OPCODE.X86.SHA256MSG2**<br>
- **OPCODE.X86.SHA256RNDS2**<br>
- **OPCODE.X86.SHL**<br>
- **OPCODE.X86.SHLD**<br>
- **OPCODE.X86.SHLX**<br>
- **OPCODE.X86.SHR**<br>
- **OPCODE.X86.SHRD**<br>
- **OPCODE.X86.SHRX**<br>
- **OPCODE.X86.SHUFPD**<br>
- **OPCODE.X86.SHUFPS**<br>
- **OPCODE.X86.SIDT**<br>
- **OPCODE.X86.FSIN**<br>
- **OPCODE.X86.SKINIT**<br>
- **OPCODE.X86.SLDT**<br>
- **OPCODE.X86.SMSW**<br>
- **OPCODE.X86.SQRTPD**<br>
- **OPCODE.X86.SQRTPS**<br>
- **OPCODE.X86.SQRTSD**<br>
- **OPCODE.X86.SQRTSS**<br>
- **OPCODE.X86.FSQRT**<br>
- **OPCODE.X86.STAC**<br>
- **OPCODE.X86.STC**<br>
- **OPCODE.X86.STD**<br>
- **OPCODE.X86.STGI**<br>
- **OPCODE.X86.STI**<br>
- **OPCODE.X86.STMXCSR**<br>
- **OPCODE.X86.STOSB**<br>
- **OPCODE.X86.STOSD**<br>
- **OPCODE.X86.STOSQ**<br>
- **OPCODE.X86.STOSW**<br>
- **OPCODE.X86.STR**<br>
- **OPCODE.X86.FST**<br>
- **OPCODE.X86.FSTP**<br>
- **OPCODE.X86.FSTPNCE**<br>
- **OPCODE.X86.SUBPD**<br>
- **OPCODE.X86.SUBPS**<br>
- **OPCODE.X86.FSUBR**<br>
- **OPCODE.X86.FISUBR**<br>
- **OPCODE.X86.FSUBRP**<br>
- **OPCODE.X86.SUBSD**<br>
- **OPCODE.X86.SUBSS**<br>
- **OPCODE.X86.FSUB**<br>
- **OPCODE.X86.FISUB**<br>
- **OPCODE.X86.FSUBP**<br>
- **OPCODE.X86.SWAPGS**<br>
- **OPCODE.X86.SYSCALL**<br>
- **OPCODE.X86.SYSENTER**<br>
- **OPCODE.X86.SYSEXIT**<br>
- **OPCODE.X86.SYSRET**<br>
- **OPCODE.X86.T1MSKC**<br>
- **OPCODE.X86.TEST**<br>
- **OPCODE.X86.UD2**<br>
- **OPCODE.X86.FTST**<br>
- **OPCODE.X86.TZCNT**<br>
- **OPCODE.X86.TZMSK**<br>
- **OPCODE.X86.FUCOMPI**<br>
- **OPCODE.X86.FUCOMI**<br>
- **OPCODE.X86.FUCOMPP**<br>
- **OPCODE.X86.FUCOMP**<br>
- **OPCODE.X86.FUCOM**<br>
- **OPCODE.X86.UD2B**<br>
- **OPCODE.X86.UNPCKHPD**<br>
- **OPCODE.X86.UNPCKHPS**<br>
- **OPCODE.X86.UNPCKLPD**<br>
- **OPCODE.X86.UNPCKLPS**<br>
- **OPCODE.X86.VADDPD**<br>
- **OPCODE.X86.VADDPS**<br>
- **OPCODE.X86.VADDSD**<br>
- **OPCODE.X86.VADDSS**<br>
- **OPCODE.X86.VADDSUBPD**<br>
- **OPCODE.X86.VADDSUBPS**<br>
- **OPCODE.X86.VAESDECLAST**<br>
- **OPCODE.X86.VAESDEC**<br>
- **OPCODE.X86.VAESENCLAST**<br>
- **OPCODE.X86.VAESENC**<br>
- **OPCODE.X86.VAESIMC**<br>
- **OPCODE.X86.VAESKEYGENASSIST**<br>
- **OPCODE.X86.VALIGND**<br>
- **OPCODE.X86.VALIGNQ**<br>
- **OPCODE.X86.VANDNPD**<br>
- **OPCODE.X86.VANDNPS**<br>
- **OPCODE.X86.VANDPD**<br>
- **OPCODE.X86.VANDPS**<br>
- **OPCODE.X86.VBLENDMPD**<br>
- **OPCODE.X86.VBLENDMPS**<br>
- **OPCODE.X86.VBLENDPD**<br>
- **OPCODE.X86.VBLENDPS**<br>
- **OPCODE.X86.VBLENDVPD**<br>
- **OPCODE.X86.VBLENDVPS**<br>
- **OPCODE.X86.VBROADCASTF128**<br>
- **OPCODE.X86.VBROADCASTI128**<br>
- **OPCODE.X86.VBROADCASTI32X4**<br>
- **OPCODE.X86.VBROADCASTI64X4**<br>
- **OPCODE.X86.VBROADCASTSD**<br>
- **OPCODE.X86.VBROADCASTSS**<br>
- **OPCODE.X86.VCMPPD**<br>
- **OPCODE.X86.VCMPPS**<br>
- **OPCODE.X86.VCMPSD**<br>
- **OPCODE.X86.VCMPSS**<br>
- **OPCODE.X86.VCVTDQ2PD**<br>
- **OPCODE.X86.VCVTDQ2PS**<br>
- **OPCODE.X86.VCVTPD2DQX**<br>
- **OPCODE.X86.VCVTPD2DQ**<br>
- **OPCODE.X86.VCVTPD2PSX**<br>
- **OPCODE.X86.VCVTPD2PS**<br>
- **OPCODE.X86.VCVTPD2UDQ**<br>
- **OPCODE.X86.VCVTPH2PS**<br>
- **OPCODE.X86.VCVTPS2DQ**<br>
- **OPCODE.X86.VCVTPS2PD**<br>
- **OPCODE.X86.VCVTPS2PH**<br>
- **OPCODE.X86.VCVTPS2UDQ**<br>
- **OPCODE.X86.VCVTSD2SI**<br>
- **OPCODE.X86.VCVTSD2USI**<br>
- **OPCODE.X86.VCVTSS2SI**<br>
- **OPCODE.X86.VCVTSS2USI**<br>
- **OPCODE.X86.VCVTTPD2DQX**<br>
- **OPCODE.X86.VCVTTPD2DQ**<br>
- **OPCODE.X86.VCVTTPD2UDQ**<br>
- **OPCODE.X86.VCVTTPS2DQ**<br>
- **OPCODE.X86.VCVTTPS2UDQ**<br>
- **OPCODE.X86.VCVTUDQ2PD**<br>
- **OPCODE.X86.VCVTUDQ2PS**<br>
- **OPCODE.X86.VDIVPD**<br>
- **OPCODE.X86.VDIVPS**<br>
- **OPCODE.X86.VDIVSD**<br>
- **OPCODE.X86.VDIVSS**<br>
- **OPCODE.X86.VDPPD**<br>
- **OPCODE.X86.VDPPS**<br>
- **OPCODE.X86.VERR**<br>
- **OPCODE.X86.VERW**<br>
- **OPCODE.X86.VEXTRACTF128**<br>
- **OPCODE.X86.VEXTRACTF32X4**<br>
- **OPCODE.X86.VEXTRACTF64X4**<br>
- **OPCODE.X86.VEXTRACTI128**<br>
- **OPCODE.X86.VEXTRACTI32X4**<br>
- **OPCODE.X86.VEXTRACTI64X4**<br>
- **OPCODE.X86.VEXTRACTPS**<br>
- **OPCODE.X86.VFMADD132PD**<br>
- **OPCODE.X86.VFMADD132PS**<br>
- **OPCODE.X86.VFMADD213PD**<br>
- **OPCODE.X86.VFMADD213PS**<br>
- **OPCODE.X86.VFMADDPD**<br>
- **OPCODE.X86.VFMADD231PD**<br>
- **OPCODE.X86.VFMADDPS**<br>
- **OPCODE.X86.VFMADD231PS**<br>
- **OPCODE.X86.VFMADDSD**<br>
- **OPCODE.X86.VFMADD213SD**<br>
- **OPCODE.X86.VFMADD132SD**<br>
- **OPCODE.X86.VFMADD231SD**<br>
- **OPCODE.X86.VFMADDSS**<br>
- **OPCODE.X86.VFMADD213SS**<br>
- **OPCODE.X86.VFMADD132SS**<br>
- **OPCODE.X86.VFMADD231SS**<br>
- **OPCODE.X86.VFMADDSUB132PD**<br>
- **OPCODE.X86.VFMADDSUB132PS**<br>
- **OPCODE.X86.VFMADDSUB213PD**<br>
- **OPCODE.X86.VFMADDSUB213PS**<br>
- **OPCODE.X86.VFMADDSUBPD**<br>
- **OPCODE.X86.VFMADDSUB231PD**<br>
- **OPCODE.X86.VFMADDSUBPS**<br>
- **OPCODE.X86.VFMADDSUB231PS**<br>
- **OPCODE.X86.VFMSUB132PD**<br>
- **OPCODE.X86.VFMSUB132PS**<br>
- **OPCODE.X86.VFMSUB213PD**<br>
- **OPCODE.X86.VFMSUB213PS**<br>
- **OPCODE.X86.VFMSUBADD132PD**<br>
- **OPCODE.X86.VFMSUBADD132PS**<br>
- **OPCODE.X86.VFMSUBADD213PD**<br>
- **OPCODE.X86.VFMSUBADD213PS**<br>
- **OPCODE.X86.VFMSUBADDPD**<br>
- **OPCODE.X86.VFMSUBADD231PD**<br>
- **OPCODE.X86.VFMSUBADDPS**<br>
- **OPCODE.X86.VFMSUBADD231PS**<br>
- **OPCODE.X86.VFMSUBPD**<br>
- **OPCODE.X86.VFMSUB231PD**<br>
- **OPCODE.X86.VFMSUBPS**<br>
- **OPCODE.X86.VFMSUB231PS**<br>
- **OPCODE.X86.VFMSUBSD**<br>
- **OPCODE.X86.VFMSUB213SD**<br>
- **OPCODE.X86.VFMSUB132SD**<br>
- **OPCODE.X86.VFMSUB231SD**<br>
- **OPCODE.X86.VFMSUBSS**<br>
- **OPCODE.X86.VFMSUB213SS**<br>
- **OPCODE.X86.VFMSUB132SS**<br>
- **OPCODE.X86.VFMSUB231SS**<br>
- **OPCODE.X86.VFNMADD132PD**<br>
- **OPCODE.X86.VFNMADD132PS**<br>
- **OPCODE.X86.VFNMADD213PD**<br>
- **OPCODE.X86.VFNMADD213PS**<br>
- **OPCODE.X86.VFNMADDPD**<br>
- **OPCODE.X86.VFNMADD231PD**<br>
- **OPCODE.X86.VFNMADDPS**<br>
- **OPCODE.X86.VFNMADD231PS**<br>
- **OPCODE.X86.VFNMADDSD**<br>
- **OPCODE.X86.VFNMADD213SD**<br>
- **OPCODE.X86.VFNMADD132SD**<br>
- **OPCODE.X86.VFNMADD231SD**<br>
- **OPCODE.X86.VFNMADDSS**<br>
- **OPCODE.X86.VFNMADD213SS**<br>
- **OPCODE.X86.VFNMADD132SS**<br>
- **OPCODE.X86.VFNMADD231SS**<br>
- **OPCODE.X86.VFNMSUB132PD**<br>
- **OPCODE.X86.VFNMSUB132PS**<br>
- **OPCODE.X86.VFNMSUB213PD**<br>
- **OPCODE.X86.VFNMSUB213PS**<br>
- **OPCODE.X86.VFNMSUBPD**<br>
- **OPCODE.X86.VFNMSUB231PD**<br>
- **OPCODE.X86.VFNMSUBPS**<br>
- **OPCODE.X86.VFNMSUB231PS**<br>
- **OPCODE.X86.VFNMSUBSD**<br>
- **OPCODE.X86.VFNMSUB213SD**<br>
- **OPCODE.X86.VFNMSUB132SD**<br>
- **OPCODE.X86.VFNMSUB231SD**<br>
- **OPCODE.X86.VFNMSUBSS**<br>
- **OPCODE.X86.VFNMSUB213SS**<br>
- **OPCODE.X86.VFNMSUB132SS**<br>
- **OPCODE.X86.VFNMSUB231SS**<br>
- **OPCODE.X86.VFRCZPD**<br>
- **OPCODE.X86.VFRCZPS**<br>
- **OPCODE.X86.VFRCZSD**<br>
- **OPCODE.X86.VFRCZSS**<br>
- **OPCODE.X86.VORPD**<br>
- **OPCODE.X86.VORPS**<br>
- **OPCODE.X86.VXORPD**<br>
- **OPCODE.X86.VXORPS**<br>
- **OPCODE.X86.VGATHERDPD**<br>
- **OPCODE.X86.VGATHERDPS**<br>
- **OPCODE.X86.VGATHERPF0DPD**<br>
- **OPCODE.X86.VGATHERPF0DPS**<br>
- **OPCODE.X86.VGATHERPF0QPD**<br>
- **OPCODE.X86.VGATHERPF0QPS**<br>
- **OPCODE.X86.VGATHERPF1DPD**<br>
- **OPCODE.X86.VGATHERPF1DPS**<br>
- **OPCODE.X86.VGATHERPF1QPD**<br>
- **OPCODE.X86.VGATHERPF1QPS**<br>
- **OPCODE.X86.VGATHERQPD**<br>
- **OPCODE.X86.VGATHERQPS**<br>
- **OPCODE.X86.VHADDPD**<br>
- **OPCODE.X86.VHADDPS**<br>
- **OPCODE.X86.VHSUBPD**<br>
- **OPCODE.X86.VHSUBPS**<br>
- **OPCODE.X86.VINSERTF128**<br>
- **OPCODE.X86.VINSERTF32X4**<br>
- **OPCODE.X86.VINSERTF64X4**<br>
- **OPCODE.X86.VINSERTI128**<br>
- **OPCODE.X86.VINSERTI32X4**<br>
- **OPCODE.X86.VINSERTI64X4**<br>
- **OPCODE.X86.VINSERTPS**<br>
- **OPCODE.X86.VLDDQU**<br>
- **OPCODE.X86.VLDMXCSR**<br>
- **OPCODE.X86.VMASKMOVDQU**<br>
- **OPCODE.X86.VMASKMOVPD**<br>
- **OPCODE.X86.VMASKMOVPS**<br>
- **OPCODE.X86.VMAXPD**<br>
- **OPCODE.X86.VMAXPS**<br>
- **OPCODE.X86.VMAXSD**<br>
- **OPCODE.X86.VMAXSS**<br>
- **OPCODE.X86.VMCALL**<br>
- **OPCODE.X86.VMCLEAR**<br>
- **OPCODE.X86.VMFUNC**<br>
- **OPCODE.X86.VMINPD**<br>
- **OPCODE.X86.VMINPS**<br>
- **OPCODE.X86.VMINSD**<br>
- **OPCODE.X86.VMINSS**<br>
- **OPCODE.X86.VMLAUNCH**<br>
- **OPCODE.X86.VMLOAD**<br>
- **OPCODE.X86.VMMCALL**<br>
- **OPCODE.X86.VMOVQ**<br>
- **OPCODE.X86.VMOVDDUP**<br>
- **OPCODE.X86.VMOVD**<br>
- **OPCODE.X86.VMOVDQA32**<br>
- **OPCODE.X86.VMOVDQA64**<br>
- **OPCODE.X86.VMOVDQA**<br>
- **OPCODE.X86.VMOVDQU16**<br>
- **OPCODE.X86.VMOVDQU32**<br>
- **OPCODE.X86.VMOVDQU64**<br>
- **OPCODE.X86.VMOVDQU8**<br>
- **OPCODE.X86.VMOVDQU**<br>
- **OPCODE.X86.VMOVHLPS**<br>
- **OPCODE.X86.VMOVHPD**<br>
- **OPCODE.X86.VMOVHPS**<br>
- **OPCODE.X86.VMOVLHPS**<br>
- **OPCODE.X86.VMOVLPD**<br>
- **OPCODE.X86.VMOVLPS**<br>
- **OPCODE.X86.VMOVMSKPD**<br>
- **OPCODE.X86.VMOVMSKPS**<br>
- **OPCODE.X86.VMOVNTDQA**<br>
- **OPCODE.X86.VMOVNTDQ**<br>
- **OPCODE.X86.VMOVNTPD**<br>
- **OPCODE.X86.VMOVNTPS**<br>
- **OPCODE.X86.VMOVSD**<br>
- **OPCODE.X86.VMOVSHDUP**<br>
- **OPCODE.X86.VMOVSLDUP**<br>
- **OPCODE.X86.VMOVSS**<br>
- **OPCODE.X86.VMOVUPD**<br>
- **OPCODE.X86.VMOVUPS**<br>
- **OPCODE.X86.VMPSADBW**<br>
- **OPCODE.X86.VMPTRLD**<br>
- **OPCODE.X86.VMPTRST**<br>
- **OPCODE.X86.VMREAD**<br>
- **OPCODE.X86.VMRESUME**<br>
- **OPCODE.X86.VMRUN**<br>
- **OPCODE.X86.VMSAVE**<br>
- **OPCODE.X86.VMULPD**<br>
- **OPCODE.X86.VMULPS**<br>
- **OPCODE.X86.VMULSD**<br>
- **OPCODE.X86.VMULSS**<br>
- **OPCODE.X86.VMWRITE**<br>
- **OPCODE.X86.VMXOFF**<br>
- **OPCODE.X86.VMXON**<br>
- **OPCODE.X86.VPABSB**<br>
- **OPCODE.X86.VPABSD**<br>
- **OPCODE.X86.VPABSQ**<br>
- **OPCODE.X86.VPABSW**<br>
- **OPCODE.X86.VPACKSSDW**<br>
- **OPCODE.X86.VPACKSSWB**<br>
- **OPCODE.X86.VPACKUSDW**<br>
- **OPCODE.X86.VPACKUSWB**<br>
- **OPCODE.X86.VPADDB**<br>
- **OPCODE.X86.VPADDD**<br>
- **OPCODE.X86.VPADDQ**<br>
- **OPCODE.X86.VPADDSB**<br>
- **OPCODE.X86.VPADDSW**<br>
- **OPCODE.X86.VPADDUSB**<br>
- **OPCODE.X86.VPADDUSW**<br>
- **OPCODE.X86.VPADDW**<br>
- **OPCODE.X86.VPALIGNR**<br>
- **OPCODE.X86.VPANDD**<br>
- **OPCODE.X86.VPANDND**<br>
- **OPCODE.X86.VPANDNQ**<br>
- **OPCODE.X86.VPANDN**<br>
- **OPCODE.X86.VPANDQ**<br>
- **OPCODE.X86.VPAND**<br>
- **OPCODE.X86.VPAVGB**<br>
- **OPCODE.X86.VPAVGW**<br>
- **OPCODE.X86.VPBLENDD**<br>
- **OPCODE.X86.VPBLENDMD**<br>
- **OPCODE.X86.VPBLENDMQ**<br>
- **OPCODE.X86.VPBLENDVB**<br>
- **OPCODE.X86.VPBLENDW**<br>
- **OPCODE.X86.VPBROADCASTB**<br>
- **OPCODE.X86.VPBROADCASTD**<br>
- **OPCODE.X86.VPBROADCASTMB2Q**<br>
- **OPCODE.X86.VPBROADCASTMW2D**<br>
- **OPCODE.X86.VPBROADCASTQ**<br>
- **OPCODE.X86.VPBROADCASTW**<br>
- **OPCODE.X86.VPCLMULQDQ**<br>
- **OPCODE.X86.VPCMOV**<br>
- **OPCODE.X86.VPCMP**<br>
- **OPCODE.X86.VPCMPD**<br>
- **OPCODE.X86.VPCMPEQB**<br>
- **OPCODE.X86.VPCMPEQD**<br>
- **OPCODE.X86.VPCMPEQQ**<br>
- **OPCODE.X86.VPCMPEQW**<br>
- **OPCODE.X86.VPCMPESTRI**<br>
- **OPCODE.X86.VPCMPESTRM**<br>
- **OPCODE.X86.VPCMPGTB**<br>
- **OPCODE.X86.VPCMPGTD**<br>
- **OPCODE.X86.VPCMPGTQ**<br>
- **OPCODE.X86.VPCMPGTW**<br>
- **OPCODE.X86.VPCMPISTRI**<br>
- **OPCODE.X86.VPCMPISTRM**<br>
- **OPCODE.X86.VPCMPQ**<br>
- **OPCODE.X86.VPCMPUD**<br>
- **OPCODE.X86.VPCMPUQ**<br>
- **OPCODE.X86.VPCOMB**<br>
- **OPCODE.X86.VPCOMD**<br>
- **OPCODE.X86.VPCOMQ**<br>
- **OPCODE.X86.VPCOMUB**<br>
- **OPCODE.X86.VPCOMUD**<br>
- **OPCODE.X86.VPCOMUQ**<br>
- **OPCODE.X86.VPCOMUW**<br>
- **OPCODE.X86.VPCOMW**<br>
- **OPCODE.X86.VPCONFLICTD**<br>
- **OPCODE.X86.VPCONFLICTQ**<br>
- **OPCODE.X86.VPERM2F128**<br>
- **OPCODE.X86.VPERM2I128**<br>
- **OPCODE.X86.VPERMD**<br>
- **OPCODE.X86.VPERMI2D**<br>
- **OPCODE.X86.VPERMI2PD**<br>
- **OPCODE.X86.VPERMI2PS**<br>
- **OPCODE.X86.VPERMI2Q**<br>
- **OPCODE.X86.VPERMIL2PD**<br>
- **OPCODE.X86.VPERMIL2PS**<br>
- **OPCODE.X86.VPERMILPD**<br>
- **OPCODE.X86.VPERMILPS**<br>
- **OPCODE.X86.VPERMPD**<br>
- **OPCODE.X86.VPERMPS**<br>
- **OPCODE.X86.VPERMQ**<br>
- **OPCODE.X86.VPERMT2D**<br>
- **OPCODE.X86.VPERMT2PD**<br>
- **OPCODE.X86.VPERMT2PS**<br>
- **OPCODE.X86.VPERMT2Q**<br>
- **OPCODE.X86.VPEXTRB**<br>
- **OPCODE.X86.VPEXTRD**<br>
- **OPCODE.X86.VPEXTRQ**<br>
- **OPCODE.X86.VPEXTRW**<br>
- **OPCODE.X86.VPGATHERDD**<br>
- **OPCODE.X86.VPGATHERDQ**<br>
- **OPCODE.X86.VPGATHERQD**<br>
- **OPCODE.X86.VPGATHERQQ**<br>
- **OPCODE.X86.VPHADDBD**<br>
- **OPCODE.X86.VPHADDBQ**<br>
- **OPCODE.X86.VPHADDBW**<br>
- **OPCODE.X86.VPHADDDQ**<br>
- **OPCODE.X86.VPHADDD**<br>
- **OPCODE.X86.VPHADDSW**<br>
- **OPCODE.X86.VPHADDUBD**<br>
- **OPCODE.X86.VPHADDUBQ**<br>
- **OPCODE.X86.VPHADDUBW**<br>
- **OPCODE.X86.VPHADDUDQ**<br>
- **OPCODE.X86.VPHADDUWD**<br>
- **OPCODE.X86.VPHADDUWQ**<br>
- **OPCODE.X86.VPHADDWD**<br>
- **OPCODE.X86.VPHADDWQ**<br>
- **OPCODE.X86.VPHADDW**<br>
- **OPCODE.X86.VPHMINPOSUW**<br>
- **OPCODE.X86.VPHSUBBW**<br>
- **OPCODE.X86.VPHSUBDQ**<br>
- **OPCODE.X86.VPHSUBD**<br>
- **OPCODE.X86.VPHSUBSW**<br>
- **OPCODE.X86.VPHSUBWD**<br>
- **OPCODE.X86.VPHSUBW**<br>
- **OPCODE.X86.VPINSRB**<br>
- **OPCODE.X86.VPINSRD**<br>
- **OPCODE.X86.VPINSRQ**<br>
- **OPCODE.X86.VPINSRW**<br>
- **OPCODE.X86.VPLZCNTD**<br>
- **OPCODE.X86.VPLZCNTQ**<br>
- **OPCODE.X86.VPMACSDD**<br>
- **OPCODE.X86.VPMACSDQH**<br>
- **OPCODE.X86.VPMACSDQL**<br>
- **OPCODE.X86.VPMACSSDD**<br>
- **OPCODE.X86.VPMACSSDQH**<br>
- **OPCODE.X86.VPMACSSDQL**<br>
- **OPCODE.X86.VPMACSSWD**<br>
- **OPCODE.X86.VPMACSSWW**<br>
- **OPCODE.X86.VPMACSWD**<br>
- **OPCODE.X86.VPMACSWW**<br>
- **OPCODE.X86.VPMADCSSWD**<br>
- **OPCODE.X86.VPMADCSWD**<br>
- **OPCODE.X86.VPMADDUBSW**<br>
- **OPCODE.X86.VPMADDWD**<br>
- **OPCODE.X86.VPMASKMOVD**<br>
- **OPCODE.X86.VPMASKMOVQ**<br>
- **OPCODE.X86.VPMAXSB**<br>
- **OPCODE.X86.VPMAXSD**<br>
- **OPCODE.X86.VPMAXSQ**<br>
- **OPCODE.X86.VPMAXSW**<br>
- **OPCODE.X86.VPMAXUB**<br>
- **OPCODE.X86.VPMAXUD**<br>
- **OPCODE.X86.VPMAXUQ**<br>
- **OPCODE.X86.VPMAXUW**<br>
- **OPCODE.X86.VPMINSB**<br>
- **OPCODE.X86.VPMINSD**<br>
- **OPCODE.X86.VPMINSQ**<br>
- **OPCODE.X86.VPMINSW**<br>
- **OPCODE.X86.VPMINUB**<br>
- **OPCODE.X86.VPMINUD**<br>
- **OPCODE.X86.VPMINUQ**<br>
- **OPCODE.X86.VPMINUW**<br>
- **OPCODE.X86.VPMOVDB**<br>
- **OPCODE.X86.VPMOVDW**<br>
- **OPCODE.X86.VPMOVMSKB**<br>
- **OPCODE.X86.VPMOVQB**<br>
- **OPCODE.X86.VPMOVQD**<br>
- **OPCODE.X86.VPMOVQW**<br>
- **OPCODE.X86.VPMOVSDB**<br>
- **OPCODE.X86.VPMOVSDW**<br>
- **OPCODE.X86.VPMOVSQB**<br>
- **OPCODE.X86.VPMOVSQD**<br>
- **OPCODE.X86.VPMOVSQW**<br>
- **OPCODE.X86.VPMOVSXBD**<br>
- **OPCODE.X86.VPMOVSXBQ**<br>
- **OPCODE.X86.VPMOVSXBW**<br>
- **OPCODE.X86.VPMOVSXDQ**<br>
- **OPCODE.X86.VPMOVSXWD**<br>
- **OPCODE.X86.VPMOVSXWQ**<br>
- **OPCODE.X86.VPMOVUSDB**<br>
- **OPCODE.X86.VPMOVUSDW**<br>
- **OPCODE.X86.VPMOVUSQB**<br>
- **OPCODE.X86.VPMOVUSQD**<br>
- **OPCODE.X86.VPMOVUSQW**<br>
- **OPCODE.X86.VPMOVZXBD**<br>
- **OPCODE.X86.VPMOVZXBQ**<br>
- **OPCODE.X86.VPMOVZXBW**<br>
- **OPCODE.X86.VPMOVZXDQ**<br>
- **OPCODE.X86.VPMOVZXWD**<br>
- **OPCODE.X86.VPMOVZXWQ**<br>
- **OPCODE.X86.VPMULDQ**<br>
- **OPCODE.X86.VPMULHRSW**<br>
- **OPCODE.X86.VPMULHUW**<br>
- **OPCODE.X86.VPMULHW**<br>
- **OPCODE.X86.VPMULLD**<br>
- **OPCODE.X86.VPMULLW**<br>
- **OPCODE.X86.VPMULUDQ**<br>
- **OPCODE.X86.VPORD**<br>
- **OPCODE.X86.VPORQ**<br>
- **OPCODE.X86.VPOR**<br>
- **OPCODE.X86.VPPERM**<br>
- **OPCODE.X86.VPROTB**<br>
- **OPCODE.X86.VPROTD**<br>
- **OPCODE.X86.VPROTQ**<br>
- **OPCODE.X86.VPROTW**<br>
- **OPCODE.X86.VPSADBW**<br>
- **OPCODE.X86.VPSCATTERDD**<br>
- **OPCODE.X86.VPSCATTERDQ**<br>
- **OPCODE.X86.VPSCATTERQD**<br>
- **OPCODE.X86.VPSCATTERQQ**<br>
- **OPCODE.X86.VPSHAB**<br>
- **OPCODE.X86.VPSHAD**<br>
- **OPCODE.X86.VPSHAQ**<br>
- **OPCODE.X86.VPSHAW**<br>
- **OPCODE.X86.VPSHLB**<br>
- **OPCODE.X86.VPSHLD**<br>
- **OPCODE.X86.VPSHLQ**<br>
- **OPCODE.X86.VPSHLW**<br>
- **OPCODE.X86.VPSHUFB**<br>
- **OPCODE.X86.VPSHUFD**<br>
- **OPCODE.X86.VPSHUFHW**<br>
- **OPCODE.X86.VPSHUFLW**<br>
- **OPCODE.X86.VPSIGNB**<br>
- **OPCODE.X86.VPSIGND**<br>
- **OPCODE.X86.VPSIGNW**<br>
- **OPCODE.X86.VPSLLDQ**<br>
- **OPCODE.X86.VPSLLD**<br>
- **OPCODE.X86.VPSLLQ**<br>
- **OPCODE.X86.VPSLLVD**<br>
- **OPCODE.X86.VPSLLVQ**<br>
- **OPCODE.X86.VPSLLW**<br>
- **OPCODE.X86.VPSRAD**<br>
- **OPCODE.X86.VPSRAQ**<br>
- **OPCODE.X86.VPSRAVD**<br>
- **OPCODE.X86.VPSRAVQ**<br>
- **OPCODE.X86.VPSRAW**<br>
- **OPCODE.X86.VPSRLDQ**<br>
- **OPCODE.X86.VPSRLD**<br>
- **OPCODE.X86.VPSRLQ**<br>
- **OPCODE.X86.VPSRLVD**<br>
- **OPCODE.X86.VPSRLVQ**<br>
- **OPCODE.X86.VPSRLW**<br>
- **OPCODE.X86.VPSUBB**<br>
- **OPCODE.X86.VPSUBD**<br>
- **OPCODE.X86.VPSUBQ**<br>
- **OPCODE.X86.VPSUBSB**<br>
- **OPCODE.X86.VPSUBSW**<br>
- **OPCODE.X86.VPSUBUSB**<br>
- **OPCODE.X86.VPSUBUSW**<br>
- **OPCODE.X86.VPSUBW**<br>
- **OPCODE.X86.VPTESTMD**<br>
- **OPCODE.X86.VPTESTMQ**<br>
- **OPCODE.X86.VPTESTNMD**<br>
- **OPCODE.X86.VPTESTNMQ**<br>
- **OPCODE.X86.VPTEST**<br>
- **OPCODE.X86.VPUNPCKHBW**<br>
- **OPCODE.X86.VPUNPCKHDQ**<br>
- **OPCODE.X86.VPUNPCKHQDQ**<br>
- **OPCODE.X86.VPUNPCKHWD**<br>
- **OPCODE.X86.VPUNPCKLBW**<br>
- **OPCODE.X86.VPUNPCKLDQ**<br>
- **OPCODE.X86.VPUNPCKLQDQ**<br>
- **OPCODE.X86.VPUNPCKLWD**<br>
- **OPCODE.X86.VPXORD**<br>
- **OPCODE.X86.VPXORQ**<br>
- **OPCODE.X86.VPXOR**<br>
- **OPCODE.X86.VRCP14PD**<br>
- **OPCODE.X86.VRCP14PS**<br>
- **OPCODE.X86.VRCP14SD**<br>
- **OPCODE.X86.VRCP14SS**<br>
- **OPCODE.X86.VRCP28PD**<br>
- **OPCODE.X86.VRCP28PS**<br>
- **OPCODE.X86.VRCP28SD**<br>
- **OPCODE.X86.VRCP28SS**<br>
- **OPCODE.X86.VRCPPS**<br>
- **OPCODE.X86.VRCPSS**<br>
- **OPCODE.X86.VRNDSCALEPD**<br>
- **OPCODE.X86.VRNDSCALEPS**<br>
- **OPCODE.X86.VRNDSCALESD**<br>
- **OPCODE.X86.VRNDSCALESS**<br>
- **OPCODE.X86.VROUNDPD**<br>
- **OPCODE.X86.VROUNDPS**<br>
- **OPCODE.X86.VROUNDSD**<br>
- **OPCODE.X86.VROUNDSS**<br>
- **OPCODE.X86.VRSQRT14PD**<br>
- **OPCODE.X86.VRSQRT14PS**<br>
- **OPCODE.X86.VRSQRT14SD**<br>
- **OPCODE.X86.VRSQRT14SS**<br>
- **OPCODE.X86.VRSQRT28PD**<br>
- **OPCODE.X86.VRSQRT28PS**<br>
- **OPCODE.X86.VRSQRT28SD**<br>
- **OPCODE.X86.VRSQRT28SS**<br>
- **OPCODE.X86.VRSQRTPS**<br>
- **OPCODE.X86.VRSQRTSS**<br>
- **OPCODE.X86.VSCATTERDPD**<br>
- **OPCODE.X86.VSCATTERDPS**<br>
- **OPCODE.X86.VSCATTERPF0DPD**<br>
- **OPCODE.X86.VSCATTERPF0DPS**<br>
- **OPCODE.X86.VSCATTERPF0QPD**<br>
- **OPCODE.X86.VSCATTERPF0QPS**<br>
- **OPCODE.X86.VSCATTERPF1DPD**<br>
- **OPCODE.X86.VSCATTERPF1DPS**<br>
- **OPCODE.X86.VSCATTERPF1QPD**<br>
- **OPCODE.X86.VSCATTERPF1QPS**<br>
- **OPCODE.X86.VSCATTERQPD**<br>
- **OPCODE.X86.VSCATTERQPS**<br>
- **OPCODE.X86.VSHUFPD**<br>
- **OPCODE.X86.VSHUFPS**<br>
- **OPCODE.X86.VSQRTPD**<br>
- **OPCODE.X86.VSQRTPS**<br>
- **OPCODE.X86.VSQRTSD**<br>
- **OPCODE.X86.VSQRTSS**<br>
- **OPCODE.X86.VSTMXCSR**<br>
- **OPCODE.X86.VSUBPD**<br>
- **OPCODE.X86.VSUBPS**<br>
- **OPCODE.X86.VSUBSD**<br>
- **OPCODE.X86.VSUBSS**<br>
- **OPCODE.X86.VTESTPD**<br>
- **OPCODE.X86.VTESTPS**<br>
- **OPCODE.X86.VUNPCKHPD**<br>
- **OPCODE.X86.VUNPCKHPS**<br>
- **OPCODE.X86.VUNPCKLPD**<br>
- **OPCODE.X86.VUNPCKLPS**<br>
- **OPCODE.X86.VZEROALL**<br>
- **OPCODE.X86.VZEROUPPER**<br>
- **OPCODE.X86.WAIT**<br>
- **OPCODE.X86.WBINVD**<br>
- **OPCODE.X86.WRFSBASE**<br>
- **OPCODE.X86.WRGSBASE**<br>
- **OPCODE.X86.WRMSR**<br>
- **OPCODE.X86.XABORT**<br>
- **OPCODE.X86.XACQUIRE**<br>
- **OPCODE.X86.XBEGIN**<br>
- **OPCODE.X86.XCHG**<br>
- **OPCODE.X86.FXCH**<br>
- **OPCODE.X86.XCRYPTCBC**<br>
- **OPCODE.X86.XCRYPTCFB**<br>
- **OPCODE.X86.XCRYPTCTR**<br>
- **OPCODE.X86.XCRYPTECB**<br>
- **OPCODE.X86.XCRYPTOFB**<br>
- **OPCODE.X86.XEND**<br>
- **OPCODE.X86.XGETBV**<br>
- **OPCODE.X86.XLATB**<br>
- **OPCODE.X86.XRELEASE**<br>
- **OPCODE.X86.XRSTOR**<br>
- **OPCODE.X86.XRSTOR64**<br>
- **OPCODE.X86.XSAVE**<br>
- **OPCODE.X86.XSAVE64**<br>
- **OPCODE.X86.XSAVEOPT**<br>
- **OPCODE.X86.XSAVEOPT64**<br>
- **OPCODE.X86.XSETBV**<br>
- **OPCODE.X86.XSHA1**<br>
- **OPCODE.X86.XSHA256**<br>
- **OPCODE.X86.XSTORE**<br>
- **OPCODE.X86.XTEST**<br>

\subsection OPCODE_arm32_py_api ARM32

- **OPCODE.ARM32.ADC**<br>
- **OPCODE.ARM32.ADD**<br>
- **OPCODE.ARM32.ADR**<br>
- **OPCODE.ARM32.AESD**<br>
- **OPCODE.ARM32.AESE**<br>
- **OPCODE.ARM32.AESIMC**<br>
- **OPCODE.ARM32.AESMC**<br>
- **OPCODE.ARM32.AND**<br>
- **OPCODE.ARM32.BFC**<br>
- **OPCODE.ARM32.BFI**<br>
- **OPCODE.ARM32.BIC**<br>
- **OPCODE.ARM32.BKPT**<br>
- **OPCODE.ARM32.BL**<br>
- **OPCODE.ARM32.BLX**<br>
- **OPCODE.ARM32.BX**<br>
- **OPCODE.ARM32.BXJ**<br>
- **OPCODE.ARM32.B**<br>
- **OPCODE.ARM32.CDP**<br>
- **OPCODE.ARM32.CDP2**<br>
- **OPCODE.ARM32.CLREX**<br>
- **OPCODE.ARM32.CLZ**<br>
- **OPCODE.ARM32.CMN**<br>
- **OPCODE.ARM32.CMP**<br>
- **OPCODE.ARM32.CPS**<br>
- **OPCODE.ARM32.CRC32B**<br>
- **OPCODE.ARM32.CRC32CB**<br>
- **OPCODE.ARM32.CRC32CH**<br>
- **OPCODE.ARM32.CRC32CW**<br>
- **OPCODE.ARM32.CRC32H**<br>
- **OPCODE.ARM32.CRC32W**<br>
- **OPCODE.ARM32.DBG**<br>
- **OPCODE.ARM32.DMB**<br>
- **OPCODE.ARM32.DSB**<br>
- **OPCODE.ARM32.EOR**<br>
- **OPCODE.ARM32.ERET**<br>
- **OPCODE.ARM32.VMOV**<br>
- **OPCODE.ARM32.FLDMDBX**<br>
- **OPCODE.ARM32.FLDMIAX**<br>
- **OPCODE.ARM32.VMRS**<br>
- **OPCODE.ARM32.FSTMDBX**<br>
- **OPCODE.ARM32.FSTMIAX**<br>
- **OPCODE.ARM32.HINT**<br>
- **OPCODE.ARM32.HLT**<br>
- **OPCODE.ARM32.HVC**<br>
- **OPCODE.ARM32.ISB**<br>
- **OPCODE.ARM32.LDA**<br>
- **OPCODE.ARM32.LDAB**<br>
- **OPCODE.ARM32.LDAEX**<br>
- **OPCODE.ARM32.LDAEXB**<br>
- **OPCODE.ARM32.LDAEXD**<br>
- **OPCODE.ARM32.LDAEXH**<br>
- **OPCODE.ARM32.LDAH**<br>
- **OPCODE.ARM32.LDC2L**<br>
- **OPCODE.ARM32.LDC2**<br>
- **OPCODE.ARM32.LDCL**<br>
- **OPCODE.ARM32.LDC**<br>
- **OPCODE.ARM32.LDMDA**<br>
- **OPCODE.ARM32.LDMDB**<br>
- **OPCODE.ARM32.LDM**<br>
- **OPCODE.ARM32.LDMIB**<br>
- **OPCODE.ARM32.LDRBT**<br>
- **OPCODE.ARM32.LDRB**<br>
- **OPCODE.ARM32.LDRD**<br>
- **OPCODE.ARM32.LDREX**<br>
- **OPCODE.ARM32.LDREXB**<br>
- **OPCODE.ARM32.LDREXD**<br>
- **OPCODE.ARM32.LDREXH**<br>
- **OPCODE.ARM32.LDRH**<br>
- **OPCODE.ARM32.LDRHT**<br>
- **OPCODE.ARM32.LDRSB**<br>
- **OPCODE.ARM32.LDRSBT**<br>
- **OPCODE.ARM32.LDRSH**<br>
- **OPCODE.ARM32.LDRSHT**<br>
- **OPCODE.ARM32.LDRT**<br>
- **OPCODE.ARM32.LDR**<br>
- **OPCODE.ARM32.MCR**<br>
- **OPCODE.ARM32.MCR2**<br>
- **OPCODE.ARM32.MCRR**<br>
- **OPCODE.ARM32.MCRR2**<br>
- **OPCODE.ARM32.MLA**<br>
- **OPCODE.ARM32.MLS**<br>
- **OPCODE.ARM32.MOV**<br>
- **OPCODE.ARM32.MOVT**<br>
- **OPCODE.ARM32.MOVW**<br>
- **OPCODE.ARM32.MRC**<br>
- **OPCODE.ARM32.MRC2**<br>
- **OPCODE.ARM32.MRRC**<br>
- **OPCODE.ARM32.MRRC2**<br>
- **OPCODE.ARM32.MRS**<br>
- **OPCODE.ARM32.MSR**<br>
- **OPCODE.ARM32.MUL**<br>
- **OPCODE.ARM32.MVN**<br>
- **OPCODE.ARM32.ORR**<br>
- **OPCODE.ARM32.PKHBT**<br>
- **OPCODE.ARM32.PKHTB**<br>
- **OPCODE.ARM32.PLDW**<br>
- **OPCODE.ARM32.PLD**<br>
- **OPCODE.ARM32.PLI**<br>
- **OPCODE.ARM32.QADD**<br>
- **OPCODE.ARM32.QADD16**<br>
- **OPCODE.ARM32.QADD8**<br>
- **OPCODE.ARM32.QASX**<br>
- **OPCODE.ARM32.QDADD**<br>
- **OPCODE.ARM32.QDSUB**<br>
- **OPCODE.ARM32.QSAX**<br>
- **OPCODE.ARM32.QSUB**<br>
- **OPCODE.ARM32.QSUB16**<br>
- **OPCODE.ARM32.QSUB8**<br>
- **OPCODE.ARM32.RBIT**<br>
- **OPCODE.ARM32.REV**<br>
- **OPCODE.ARM32.REV16**<br>
- **OPCODE.ARM32.REVSH**<br>
- **OPCODE.ARM32.RFEDA**<br>
- **OPCODE.ARM32.RFEDB**<br>
- **OPCODE.ARM32.RFEIA**<br>
- **OPCODE.ARM32.RFEIB**<br>
- **OPCODE.ARM32.RSB**<br>
- **OPCODE.ARM32.RSC**<br>
- **OPCODE.ARM32.SADD16**<br>
- **OPCODE.ARM32.SADD8**<br>
- **OPCODE.ARM32.SASX**<br>
- **OPCODE.ARM32.SBC**<br>
- **OPCODE.ARM32.SBFX**<br>
- **OPCODE.ARM32.SDIV**<br>
- **OPCODE.ARM32.SEL**<br>
- **OPCODE.ARM32.SETEND**<br>
- **OPCODE.ARM32.SHA1C**<br>
- **OPCODE.ARM32.SHA1H**<br>
- **OPCODE.ARM32.SHA1M**<br>
- **OPCODE.ARM32.SHA1P**<br>
- **OPCODE.ARM32.SHA1SU0**<br>
- **OPCODE.ARM32.SHA1SU1**<br>
- **OPCODE.ARM32.SHA256H**<br>
- **OPCODE.ARM32.SHA256H2**<br>
- **OPCODE.ARM32.SHA256SU0**<br>
- **OPCODE.ARM32.SHA256SU1**<br>
- **OPCODE.ARM32.SHADD16**<br>
- **OPCODE.ARM32.SHADD8**<br>
- **OPCODE.ARM32.SHASX**<br>
- **OPCODE.ARM32.SHSAX**<br>
- **OPCODE.ARM32.SHSUB16**<br>
- **OPCODE.ARM32.SHSUB8**<br>
- **OPCODE.ARM32.SMC**<br>
- **OPCODE.ARM32.SMLABB**<br>
- **OPCODE.ARM32.SMLABT**<br>
- **OPCODE.ARM32.SMLAD**<br>
- **OPCODE.ARM32.SMLADX**<br>
- **OPCODE.ARM32.SMLAL**<br>
- **OPCODE.ARM32.SMLALBB**<br>
- **OPCODE.ARM32.SMLALBT**<br>
- **OPCODE.ARM32.SMLALD**<br>
- **OPCODE.ARM32.SMLALDX**<br>
- **OPCODE.ARM32.SMLALTB**<br>
- **OPCODE.ARM32.SMLALTT**<br>
- **OPCODE.ARM32.SMLATB**<br>
- **OPCODE.ARM32.SMLATT**<br>
- **OPCODE.ARM32.SMLAWB**<br>
- **OPCODE.ARM32.SMLAWT**<br>
- **OPCODE.ARM32.SMLSD**<br>
- **OPCODE.ARM32.SMLSDX**<br>
- **OPCODE.ARM32.SMLSLD**<br>
- **OPCODE.ARM32.SMLSLDX**<br>
- **OPCODE.ARM32.SMMLA**<br>
- **OPCODE.ARM32.SMMLAR**<br>
- **OPCODE.ARM32.SMMLS**<br>
- **OPCODE.ARM32.SMMLSR**<br>
- **OPCODE.ARM32.SMMUL**<br>
- **OPCODE.ARM32.SMMULR**<br>
- **OPCODE.ARM32.SMUAD**<br>
- **OPCODE.ARM32.SMUADX**<br>
- **OPCODE.ARM32.SMULBB**<br>
- **OPCODE.ARM32.SMULBT**<br>
- **OPCODE.ARM32.SMULL**<br>
- **OPCODE.ARM32.SMULTB**<br>
- **OPCODE.ARM32.SMULTT**<br>
- **OPCODE.ARM32.SMULWB**<br>
- **OPCODE.ARM32.SMULWT**<br>
- **OPCODE.ARM32.SMUSD**<br>
- **OPCODE.ARM32.SMUSDX**<br>
- **OPCODE.ARM32.SRSDA**<br>
- **OPCODE.ARM32.SRSDB**<br>
- **OPCODE.ARM32.SRSIA**<br>
- **OPCODE.ARM32.SRSIB**<br>
- **OPCODE.ARM32.SSAT**<br>
- **OPCODE.ARM32.SSAT16**<br>
- **OPCODE.ARM32.SSAX**<br>
- **OPCODE.ARM32.SSUB16**<br>
- **OPCODE.ARM32.SSUB8**<br>
- **OPCODE.ARM32.STC2L**<br>
- **OPCODE.ARM32.STC2**<br>
- **OPCODE.ARM32.STCL**<br>
- **OPCODE.ARM32.STC**<br>
- **OPCODE.ARM32.STL**<br>
- **OPCODE.ARM32.STLB**<br>
- **OPCODE.ARM32.STLEX**<br>
- **OPCODE.ARM32.STLEXB**<br>
- **OPCODE.ARM32.STLEXD**<br>
- **OPCODE.ARM32.STLEXH**<br>
- **OPCODE.ARM32.STLH**<br>
- **OPCODE.ARM32.STMDA**<br>
- **OPCODE.ARM32.STMDB**<br>
- **OPCODE.ARM32.STM**<br>
- **OPCODE.ARM32.STMIB**<br>
- **OPCODE.ARM32.STRBT**<br>
- **OPCODE.ARM32.STRB**<br>
- **OPCODE.ARM32.STRD**<br>
- **OPCODE.ARM32.STREX**<br>
- **OPCODE.ARM32.STREXB**<br>
- **OPCODE.ARM32.STREXD**<br>
- **OPCODE.ARM32.STREXH**<br>
- **OPCODE.ARM32.STRH**<br>
- **OPCODE.ARM32.STRHT**<br>
- **OPCODE.ARM32.STRT**<br>
- **OPCODE.ARM32.STR**<br>
- **OPCODE.ARM32.SUB**<br>
- **OPCODE.ARM32.SVC**<br>
- **OPCODE.ARM32.SWP**<br>
- **OPCODE.ARM32.SWPB**<br>
- **OPCODE.ARM32.SXTAB**<br>
- **OPCODE.ARM32.SXTAB16**<br>
- **OPCODE.ARM32.SXTAH**<br>
- **OPCODE.ARM32.SXTB**<br>
- **OPCODE.ARM32.SXTB16**<br>
- **OPCODE.ARM32.SXTH**<br>
- **OPCODE.ARM32.TEQ**<br>
- **OPCODE.ARM32.TRAP**<br>
- **OPCODE.ARM32.TST**<br>
- **OPCODE.ARM32.UADD16**<br>
- **OPCODE.ARM32.UADD8**<br>
- **OPCODE.ARM32.UASX**<br>
- **OPCODE.ARM32.UBFX**<br>
- **OPCODE.ARM32.UDF**<br>
- **OPCODE.ARM32.UDIV**<br>
- **OPCODE.ARM32.UHADD16**<br>
- **OPCODE.ARM32.UHADD8**<br>
- **OPCODE.ARM32.UHASX**<br>
- **OPCODE.ARM32.UHSAX**<br>
- **OPCODE.ARM32.UHSUB16**<br>
- **OPCODE.ARM32.UHSUB8**<br>
- **OPCODE.ARM32.UMAAL**<br>
- **OPCODE.ARM32.UMLAL**<br>
- **OPCODE.ARM32.UMULL**<br>
- **OPCODE.ARM32.UQADD16**<br>
- **OPCODE.ARM32.UQADD8**<br>
- **OPCODE.ARM32.UQASX**<br>
- **OPCODE.ARM32.UQSAX**<br>
- **OPCODE.ARM32.UQSUB16**<br>
- **OPCODE.ARM32.UQSUB8**<br>
- **OPCODE.ARM32.USAD8**<br>
- **OPCODE.ARM32.USADA8**<br>
- **OPCODE.ARM32.USAT**<br>
- **OPCODE.ARM32.USAT16**<br>
- **OPCODE.ARM32.USAX**<br>
- **OPCODE.ARM32.USUB16**<br>
- **OPCODE.ARM32.USUB8**<br>
- **OPCODE.ARM32.UXTAB**<br>
- **OPCODE.ARM32.UXTAB16**<br>
- **OPCODE.ARM32.UXTAH**<br>
- **OPCODE.ARM32.UXTB**<br>
- **OPCODE.ARM32.UXTB16**<br>
- **OPCODE.ARM32.UXTH**<br>
- **OPCODE.ARM32.VABAL**<br>
- **OPCODE.ARM32.VABA**<br>
- **OPCODE.ARM32.VABDL**<br>
- **OPCODE.ARM32.VABD**<br>
- **OPCODE.ARM32.VABS**<br>
- **OPCODE.ARM32.VACGE**<br>
- **OPCODE.ARM32.VACGT**<br>
- **OPCODE.ARM32.VADD**<br>
- **OPCODE.ARM32.VADDHN**<br>
- **OPCODE.ARM32.VADDL**<br>
- **OPCODE.ARM32.VADDW**<br>
- **OPCODE.ARM32.VAND**<br>
- **OPCODE.ARM32.VBIC**<br>
- **OPCODE.ARM32.VBIF**<br>
- **OPCODE.ARM32.VBIT**<br>
- **OPCODE.ARM32.VBSL**<br>
- **OPCODE.ARM32.VCEQ**<br>
- **OPCODE.ARM32.VCGE**<br>
- **OPCODE.ARM32.VCGT**<br>
- **OPCODE.ARM32.VCLE**<br>
- **OPCODE.ARM32.VCLS**<br>
- **OPCODE.ARM32.VCLT**<br>
- **OPCODE.ARM32.VCLZ**<br>
- **OPCODE.ARM32.VCMP**<br>
- **OPCODE.ARM32.VCMPE**<br>
- **OPCODE.ARM32.VCNT**<br>
- **OPCODE.ARM32.VCVTA**<br>
- **OPCODE.ARM32.VCVTB**<br>
- **OPCODE.ARM32.VCVT**<br>
- **OPCODE.ARM32.VCVTM**<br>
- **OPCODE.ARM32.VCVTN**<br>
- **OPCODE.ARM32.VCVTP**<br>
- **OPCODE.ARM32.VCVTT**<br>
- **OPCODE.ARM32.VDIV**<br>
- **OPCODE.ARM32.VDUP**<br>
- **OPCODE.ARM32.VEOR**<br>
- **OPCODE.ARM32.VEXT**<br>
- **OPCODE.ARM32.VFMA**<br>
- **OPCODE.ARM32.VFMS**<br>
- **OPCODE.ARM32.VFNMA**<br>
- **OPCODE.ARM32.VFNMS**<br>
- **OPCODE.ARM32.VHADD**<br>
- **OPCODE.ARM32.VHSUB**<br>
- **OPCODE.ARM32.VLD1**<br>
- **OPCODE.ARM32.VLD2**<br>
- **OPCODE.ARM32.VLD3**<br>
- **OPCODE.ARM32.VLD4**<br>
- **OPCODE.ARM32.VLDMDB**<br>
- **OPCODE.ARM32.VLDMIA**<br>
- **OPCODE.ARM32.VLDR**<br>
- **OPCODE.ARM32.VMAXNM**<br>
- **OPCODE.ARM32.VMAX**<br>
- **OPCODE.ARM32.VMINNM**<br>
- **OPCODE.ARM32.VMIN**<br>
- **OPCODE.ARM32.VMLA**<br>
- **OPCODE.ARM32.VMLAL**<br>
- **OPCODE.ARM32.VMLS**<br>
- **OPCODE.ARM32.VMLSL**<br>
- **OPCODE.ARM32.VMOVL**<br>
- **OPCODE.ARM32.VMOVN**<br>
- **OPCODE.ARM32.VMSR**<br>
- **OPCODE.ARM32.VMUL**<br>
- **OPCODE.ARM32.VMULL**<br>
- **OPCODE.ARM32.VMVN**<br>
- **OPCODE.ARM32.VNEG**<br>
- **OPCODE.ARM32.VNMLA**<br>
- **OPCODE.ARM32.VNMLS**<br>
- **OPCODE.ARM32.VNMUL**<br>
- **OPCODE.ARM32.VORN**<br>
- **OPCODE.ARM32.VORR**<br>
- **OPCODE.ARM32.VPADAL**<br>
- **OPCODE.ARM32.VPADDL**<br>
- **OPCODE.ARM32.VPADD**<br>
- **OPCODE.ARM32.VPMAX**<br>
- **OPCODE.ARM32.VPMIN**<br>
- **OPCODE.ARM32.VQABS**<br>
- **OPCODE.ARM32.VQADD**<br>
- **OPCODE.ARM32.VQDMLAL**<br>
- **OPCODE.ARM32.VQDMLSL**<br>
- **OPCODE.ARM32.VQDMULH**<br>
- **OPCODE.ARM32.VQDMULL**<br>
- **OPCODE.ARM32.VQMOVUN**<br>
- **OPCODE.ARM32.VQMOVN**<br>
- **OPCODE.ARM32.VQNEG**<br>
- **OPCODE.ARM32.VQRDMULH**<br>
- **OPCODE.ARM32.VQRSHL**<br>
- **OPCODE.ARM32.VQRSHRN**<br>
- **OPCODE.ARM32.VQRSHRUN**<br>
- **OPCODE.ARM32.VQSHL**<br>
- **OPCODE.ARM32.VQSHLU**<br>
- **OPCODE.ARM32.VQSHRN**<br>
- **OPCODE.ARM32.VQSHRUN**<br>
- **OPCODE.ARM32.VQSUB**<br>
- **OPCODE.ARM32.VRADDHN**<br>
- **OPCODE.ARM32.VRECPE**<br>
- **OPCODE.ARM32.VRECPS**<br>
- **OPCODE.ARM32.VREV16**<br>
- **OPCODE.ARM32.VREV32**<br>
- **OPCODE.ARM32.VREV64**<br>
- **OPCODE.ARM32.VRHADD**<br>
- **OPCODE.ARM32.VRINTA**<br>
- **OPCODE.ARM32.VRINTM**<br>
- **OPCODE.ARM32.VRINTN**<br>
- **OPCODE.ARM32.VRINTP**<br>
- **OPCODE.ARM32.VRINTR**<br>
- **OPCODE.ARM32.VRINTX**<br>
- **OPCODE.ARM32.VRINTZ**<br>
- **OPCODE.ARM32.VRSHL**<br>
- **OPCODE.ARM32.VRSHRN**<br>
- **OPCODE.ARM32.VRSHR**<br>
- **OPCODE.ARM32.VRSQRTE**<br>
- **OPCODE.ARM32.VRSQRTS**<br>
- **OPCODE.ARM32.VRSRA**<br>
- **OPCODE.ARM32.VRSUBHN**<br>
- **OPCODE.ARM32.VSELEQ**<br>
- **OPCODE.ARM32.VSELGE**<br>
- **OPCODE.ARM32.VSELGT**<br>
- **OPCODE.ARM32.VSELVS**<br>
- **OPCODE.ARM32.VSHLL**<br>
- **OPCODE.ARM32.VSHL**<br>
- **OPCODE.ARM32.VSHRN**<br>
- **OPCODE.ARM32.VSHR**<br>
- **OPCODE.ARM32.VSLI**<br>
- **OPCODE.ARM32.VSQRT**<br>
- **OPCODE.ARM32.VSRA**<br>
- **OPCODE.ARM32.VSRI**<br>
- **OPCODE.ARM32.VST1**<br>
- **OPCODE.ARM32.VST2**<br>
- **OPCODE.ARM32.VST3**<br>
- **OPCODE.ARM32.VST4**<br>
- **OPCODE.ARM32.VSTMDB**<br>
- **OPCODE.ARM32.VSTMIA**<br>
- **OPCODE.ARM32.VSTR**<br>
- **OPCODE.ARM32.VSUB**<br>
- **OPCODE.ARM32.VSUBHN**<br>
- **OPCODE.ARM32.VSUBL**<br>
- **OPCODE.ARM32.VSUBW**<br>
- **OPCODE.ARM32.VSWP**<br>
- **OPCODE.ARM32.VTBL**<br>
- **OPCODE.ARM32.VTBX**<br>
- **OPCODE.ARM32.VCVTR**<br>
- **OPCODE.ARM32.VTRN**<br>
- **OPCODE.ARM32.VTST**<br>
- **OPCODE.ARM32.VUZP**<br>
- **OPCODE.ARM32.VZIP**<br>
- **OPCODE.ARM32.ADDW**<br>
- **OPCODE.ARM32.ASR**<br>
- **OPCODE.ARM32.DCPS1**<br>
- **OPCODE.ARM32.DCPS2**<br>
- **OPCODE.ARM32.DCPS3**<br>
- **OPCODE.ARM32.IT**<br>
- **OPCODE.ARM32.LSL**<br>
- **OPCODE.ARM32.LSR**<br>
- **OPCODE.ARM32.ORN**<br>
- **OPCODE.ARM32.ROR**<br>
- **OPCODE.ARM32.RRX**<br>
- **OPCODE.ARM32.SUBW**<br>
- **OPCODE.ARM32.TBB**<br>
- **OPCODE.ARM32.TBH**<br>
- **OPCODE.ARM32.CBNZ**<br>
- **OPCODE.ARM32.CBZ**<br>
- **OPCODE.ARM32.POP**<br>
- **OPCODE.ARM32.PUSH**<br>
- **OPCODE.ARM32.NOP**<br>
- **OPCODE.ARM32.YIELD**<br>
- **OPCODE.ARM32.WFE**<br>
- **OPCODE.ARM32.WFI**<br>
- **OPCODE.ARM32.SEV**<br>
- **OPCODE.ARM32.SEVL**<br>
- **OPCODE.ARM32.VPUSH**<br>
- **OPCODE.ARM32.VPOP**<br>

\subsection OPCODE_aarch64_py_api AArch64

- **OPCODE.AARCH64.ABS**<br>
- **OPCODE.AARCH64.ADC**<br>
- **OPCODE.AARCH64.ADDHN**<br>
- **OPCODE.AARCH64.ADDHN2**<br>
- **OPCODE.AARCH64.ADDP**<br>
- **OPCODE.AARCH64.ADD**<br>
- **OPCODE.AARCH64.ADDV**<br>
- **OPCODE.AARCH64.ADR**<br>
- **OPCODE.AARCH64.ADRP**<br>
- **OPCODE.AARCH64.AESD**<br>
- **OPCODE.AARCH64.AESE**<br>
- **OPCODE.AARCH64.AESIMC**<br>
- **OPCODE.AARCH64.AESMC**<br>
- **OPCODE.AARCH64.AND**<br>
- **OPCODE.AARCH64.ASR**<br>
- **OPCODE.AARCH64.B**<br>
- **OPCODE.AARCH64.BFM**<br>
- **OPCODE.AARCH64.BIC**<br>
- **OPCODE.AARCH64.BIF**<br>
- **OPCODE.AARCH64.BIT**<br>
- **OPCODE.AARCH64.BL**<br>
- **OPCODE.AARCH64.BLR**<br>
- **OPCODE.AARCH64.BR**<br>
- **OPCODE.AARCH64.BRK**<br>
- **OPCODE.AARCH64.BSL**<br>
- **OPCODE.AARCH64.CBNZ**<br>
- **OPCODE.AARCH64.CBZ**<br>
- **OPCODE.AARCH64.CCMN**<br>
- **OPCODE.AARCH64.CCMP**<br>
- **OPCODE.AARCH64.CLREX**<br>
- **OPCODE.AARCH64.CLS**<br>
- **OPCODE.AARCH64.CLZ**<br>
- **OPCODE.AARCH64.CMEQ**<br>
- **OPCODE.AARCH64.CMGE**<br>
- **OPCODE.AARCH64.CMGT**<br>
- **OPCODE.AARCH64.CMHI**<br>
- **OPCODE.AARCH64.CMHS**<br>
- **OPCODE.AARCH64.CMLE**<br>
- **OPCODE.AARCH64.CMLT**<br>
- **OPCODE.AARCH64.CMTST**<br>
- **OPCODE.AARCH64.CNT**<br>
- **OPCODE.AARCH64.MOV**<br>
- **OPCODE.AARCH64.CRC32B**<br>
- **OPCODE.AARCH64.CRC32CB**<br>
- **OPCODE.AARCH64.CRC32CH**<br>
- **OPCODE.AARCH64.CRC32CW**<br>
- **OPCODE.AARCH64.CRC32CX**<br>
- **OPCODE.AARCH64.CRC32H**<br>
- **OPCODE.AARCH64.CRC32W**<br>
- **OPCODE.AARCH64.CRC32X**<br>
- **OPCODE.AARCH64.CSEL**<br>
- **OPCODE.AARCH64.CSINC**<br>
- **OPCODE.AARCH64.CSINV**<br>
- **OPCODE.AARCH64.CSNEG**<br>
- **OPCODE.AARCH64.DCPS1**<br>
- **OPCODE.AARCH64.DCPS2**<br>
- **OPCODE.AARCH64.DCPS3**<br>
- **OPCODE.AARCH64.DMB**<br>
- **OPCODE.AARCH64.DRPS**<br>
- **OPCODE.AARCH64.DSB**<br>
- **OPCODE.AARCH64.DUP**<br>
- **OPCODE.AARCH64.EON**<br>
- **OPCODE.AARCH64.EOR**<br>
- **OPCODE.AARCH64.ERET**<br>
- **OPCODE.AARCH64.EXTR**<br>
- **OPCODE.AARCH64.EXT**<br>
- **OPCODE.AARCH64.FABD**<br>
- **OPCODE.AARCH64.FABS**<br>
- **OPCODE.AARCH64.FACGE**<br>
- **OPCODE.AARCH64.FACGT**<br>
- **OPCODE.AARCH64.FADD**<br>
- **OPCODE.AARCH64.FADDP**<br>
- **OPCODE.AARCH64.FCCMP**<br>
- **OPCODE.AARCH64.FCCMPE**<br>
- **OPCODE.AARCH64.FCMEQ**<br>
- **OPCODE.AARCH64.FCMGE**<br>
- **OPCODE.AARCH64.FCMGT**<br>
- **OPCODE.AARCH64.FCMLE**<br>
- **OPCODE.AARCH64.FCMLT**<br>
- **OPCODE.AARCH64.FCMP**<br>
- **OPCODE.AARCH64.FCMPE**<br>
- **OPCODE.AARCH64.FCSEL**<br>
- **OPCODE.AARCH64.FCVTAS**<br>
- **OPCODE.AARCH64.FCVTAU**<br>
- **OPCODE.AARCH64.FCVT**<br>
- **OPCODE.AARCH64.FCVTL**<br>
- **OPCODE.AARCH64.FCVTL2**<br>
- **OPCODE.AARCH64.FCVTMS**<br>
- **OPCODE.AARCH64.FCVTMU**<br>
- **OPCODE.AARCH64.FCVTNS**<br>
- **OPCODE.AARCH64.FCVTNU**<br>
- **OPCODE.AARCH64.FCVTN**<br>
- **OPCODE.AARCH64.FCVTN2**<br>
- **OPCODE.AARCH64.FCVTPS**<br>
- **OPCODE.AARCH64.FCVTPU**<br>
- **OPCODE.AARCH64.FCVTXN**<br>
- **OPCODE.AARCH64.FCVTXN2**<br>
- **OPCODE.AARCH64.FCVTZS**<br>
- **OPCODE.AARCH64.FCVTZU**<br>
- **OPCODE.AARCH64.FDIV**<br>
- **OPCODE.AARCH64.FMADD**<br>
- **OPCODE.AARCH64.FMAX**<br>
- **OPCODE.AARCH64.FMAXNM**<br>
- **OPCODE.AARCH64.FMAXNMP**<br>
- **OPCODE.AARCH64.FMAXNMV**<br>
- **OPCODE.AARCH64.FMAXP**<br>
- **OPCODE.AARCH64.FMAXV**<br>
- **OPCODE.AARCH64.FMIN**<br>
- **OPCODE.AARCH64.FMINNM**<br>
- **OPCODE.AARCH64.FMINNMP**<br>
- **OPCODE.AARCH64.FMINNMV**<br>
- **OPCODE.AARCH64.FMINP**<br>
- **OPCODE.AARCH64.FMINV**<br>
- **OPCODE.AARCH64.FMLA**<br>
- **OPCODE.AARCH64.FMLS**<br>
- **OPCODE.AARCH64.FMOV**<br>
- **OPCODE.AARCH64.FMSUB**<br>
- **OPCODE.AARCH64.FMUL**<br>
- **OPCODE.AARCH64.FMULX**<br>
- **OPCODE.AARCH64.FNEG**<br>
- **OPCODE.AARCH64.FNMADD**<br>
- **OPCODE.AARCH64.FNMSUB**<br>
- **OPCODE.AARCH64.FNMUL**<br>
- **OPCODE.AARCH64.FRECPE**<br>
- **OPCODE.AARCH64.FRECPS**<br>
- **OPCODE.AARCH64.FRECPX**<br>
- **OPCODE.AARCH64.FRINTA**<br>
- **OPCODE.AARCH64.FRINTI**<br>
- **OPCODE.AARCH64.FRINTM**<br>
- **OPCODE.AARCH64.FRINTN**<br>
- **OPCODE.AARCH64.FRINTP**<br>
- **OPCODE.AARCH64.FRINTX**<br>
- **OPCODE.AARCH64.FRINTZ**<br>
- **OPCODE.AARCH64.FRSQRTE**<br>
- **OPCODE.AARCH64.FRSQRTS**<br>
- **OPCODE.AARCH64.FSQRT**<br>
- **OPCODE.AARCH64.FSUB**<br>
- **OPCODE.AARCH64.HINT**<br>
- **OPCODE.AARCH64.HLT**<br>
- **OPCODE.AARCH64.HVC**<br>
- **OPCODE.AARCH64.INS**<br>
- **OPCODE.AARCH64.ISB**<br>
- **OPCODE.AARCH64.LD1**<br>
- **OPCODE.AARCH64.LD1R**<br>
- **OPCODE.AARCH64.LD2R**<br>
- **OPCODE.AARCH64.LD2**<br>
- **OPCODE.AARCH64.LD3R**<br>
- **OPCODE.AARCH64.LD3**<br>
- **OPCODE.AARCH64.LD4**<br>
- **OPCODE.AARCH64.LD4R**<br>
- **OPCODE.AARCH64.LDARB**<br>
- **OPCODE.AARCH64.LDARH**<br>
- **OPCODE.AARCH64.LDAR**<br>
- **OPCODE.AARCH64.LDAXP**<br>
- **OPCODE.AARCH64.LDAXRB**<br>
- **OPCODE.AARCH64.LDAXRH**<br>
- **OPCODE.AARCH64.LDAXR**<br>
- **OPCODE.AARCH64.LDNP**<br>
- **OPCODE.AARCH64.LDP**<br>
- **OPCODE.AARCH64.LDPSW**<br>
- **OPCODE.AARCH64.LDRB**<br>
- **OPCODE.AARCH64.LDR**<br>
- **OPCODE.AARCH64.LDRH**<br>
- **OPCODE.AARCH64.LDRSB**<br>
- **OPCODE.AARCH64.LDRSH**<br>
- **OPCODE.AARCH64.LDRSW**<br>
- **OPCODE.AARCH64.LDTRB**<br>
- **OPCODE.AARCH64.LDTRH**<br>
- **OPCODE.AARCH64.LDTRSB**<br>
- **OPCODE.AARCH64.LDTRSH**<br>
- **OPCODE.AARCH64.LDTRSW**<br>
- **OPCODE.AARCH64.LDTR**<br>
- **OPCODE.AARCH64.LDURB**<br>
- **OPCODE.AARCH64.LDUR**<br>
- **OPCODE.AARCH64.LDURH**<br>
- **OPCODE.AARCH64.LDURSB**<br>
- **OPCODE.AARCH64.LDURSH**<br>
- **OPCODE.AARCH64.LDURSW**<br>
- **OPCODE.AARCH64.LDXP**<br>
- **OPCODE.AARCH64.LDXRB**<br>
- **OPCODE.AARCH64.LDXRH**<br>
- **OPCODE.AARCH64.LDXR**<br>
- **OPCODE.AARCH64.LSL**<br>
- **OPCODE.AARCH64.LSR**<br>
- **OPCODE.AARCH64.MADD**<br>
- **OPCODE.AARCH64.MLA**<br>
- **OPCODE.AARCH64.MLS**<br>
- **OPCODE.AARCH64.MOVI**<br>
- **OPCODE.AARCH64.MOVK**<br>
- **OPCODE.AARCH64.MOVN**<br>
- **OPCODE.AARCH64.MOVZ**<br>
- **OPCODE.AARCH64.MRS**<br>
- **OPCODE.AARCH64.MSR**<br>
- **OPCODE.AARCH64.MSUB**<br>
- **OPCODE.AARCH64.MUL**<br>
- **OPCODE.AARCH64.MVNI**<br>
- **OPCODE.AARCH64.NEG**<br>
- **OPCODE.AARCH64.NOT**<br>
- **OPCODE.AARCH64.ORN**<br>
- **OPCODE.AARCH64.ORR**<br>
- **OPCODE.AARCH64.PMULL2**<br>
- **OPCODE.AARCH64.PMULL**<br>
- **OPCODE.AARCH64.PMUL**<br>
- **OPCODE.AARCH64.PRFM**<br>
- **OPCODE.AARCH64.PRFUM**<br>
- **OPCODE.AARCH64.RADDHN**<br>
- **OPCODE.AARCH64.RADDHN2**<br>
- **OPCODE.AARCH64.RBIT**<br>
- **OPCODE.AARCH64.RET**<br>
- **OPCODE.AARCH64.REV16**<br>
- **OPCODE.AARCH64.REV32**<br>
- **OPCODE.AARCH64.REV64**<br>
- **OPCODE.AARCH64.REV**<br>
- **OPCODE.AARCH64.ROR**<br>
- **OPCODE.AARCH64.RSHRN2**<br>
- **OPCODE.AARCH64.RSHRN**<br>
- **OPCODE.AARCH64.RSUBHN**<br>
- **OPCODE.AARCH64.RSUBHN2**<br>
- **OPCODE.AARCH64.SABAL2**<br>
- **OPCODE.AARCH64.SABAL**<br>
- **OPCODE.AARCH64.SABA**<br>
- **OPCODE.AARCH64.SABDL2**<br>
- **OPCODE.AARCH64.SABDL**<br>
- **OPCODE.AARCH64.SABD**<br>
- **OPCODE.AARCH64.SADALP**<br>
- **OPCODE.AARCH64.SADDLP**<br>
- **OPCODE.AARCH64.SADDLV**<br>
- **OPCODE.AARCH64.SADDL2**<br>
- **OPCODE.AARCH64.SADDL**<br>
- **OPCODE.AARCH64.SADDW2**<br>
- **OPCODE.AARCH64.SADDW**<br>
- **OPCODE.AARCH64.SBC**<br>
- **OPCODE.AARCH64.SBFM**<br>
- **OPCODE.AARCH64.SCVTF**<br>
- **OPCODE.AARCH64.SDIV**<br>
- **OPCODE.AARCH64.SHA1C**<br>
- **OPCODE.AARCH64.SHA1H**<br>
- **OPCODE.AARCH64.SHA1M**<br>
- **OPCODE.AARCH64.SHA1P**<br>
- **OPCODE.AARCH64.SHA1SU0**<br>
- **OPCODE.AARCH64.SHA1SU1**<br>
- **OPCODE.AARCH64.SHA256H2**<br>
- **OPCODE.AARCH64.SHA256H**<br>
- **OPCODE.AARCH64.SHA256SU0**<br>
- **OPCODE.AARCH64.SHA256SU1**<br>
- **OPCODE.AARCH64.SHADD**<br>
- **OPCODE.AARCH64.SHLL2**<br>
- **OPCODE.AARCH64.SHLL**<br>
- **OPCODE.AARCH64.SHL**<br>
- **OPCODE.AARCH64.SHRN2**<br>
- **OPCODE.AARCH64.SHRN**<br>
- **OPCODE.AARCH64.SHSUB**<br>
- **OPCODE.AARCH64.SLI**<br>
- **OPCODE.AARCH64.SMADDL**<br>
- **OPCODE.AARCH64.SMAXP**<br>
- **OPCODE.AARCH64.SMAXV**<br>
- **OPCODE.AARCH64.SMAX**<br>
- **OPCODE.AARCH64.SMC**<br>
- **OPCODE.AARCH64.SMINP**<br>
- **OPCODE.AARCH64.SMINV**<br>
- **OPCODE.AARCH64.SMIN**<br>
- **OPCODE.AARCH64.SMLAL2**<br>
- **OPCODE.AARCH64.SMLAL**<br>
- **OPCODE.AARCH64.SMLSL2**<br>
- **OPCODE.AARCH64.SMLSL**<br>
- **OPCODE.AARCH64.SMOV**<br>
- **OPCODE.AARCH64.SMSUBL**<br>
- **OPCODE.AARCH64.SMULH**<br>
- **OPCODE.AARCH64.SMULL2**<br>
- **OPCODE.AARCH64.SMULL**<br>
- **OPCODE.AARCH64.SQABS**<br>
- **OPCODE.AARCH64.SQADD**<br>
- **OPCODE.AARCH64.SQDMLAL**<br>
- **OPCODE.AARCH64.SQDMLAL2**<br>
- **OPCODE.AARCH64.SQDMLSL**<br>
- **OPCODE.AARCH64.SQDMLSL2**<br>
- **OPCODE.AARCH64.SQDMULH**<br>
- **OPCODE.AARCH64.SQDMULL**<br>
- **OPCODE.AARCH64.SQDMULL2**<br>
- **OPCODE.AARCH64.SQNEG**<br>
- **OPCODE.AARCH64.SQRDMULH**<br>
- **OPCODE.AARCH64.SQRSHL**<br>
- **OPCODE.AARCH64.SQRSHRN**<br>
- **OPCODE.AARCH64.SQRSHRN2**<br>
- **OPCODE.AARCH64.SQRSHRUN**<br>
- **OPCODE.AARCH64.SQRSHRUN2**<br>
- **OPCODE.AARCH64.SQSHLU**<br>
- **OPCODE.AARCH64.SQSHL**<br>
- **OPCODE.AARCH64.SQSHRN**<br>
- **OPCODE.AARCH64.SQSHRN2**<br>
- **OPCODE.AARCH64.SQSHRUN**<br>
- **OPCODE.AARCH64.SQSHRUN2**<br>
- **OPCODE.AARCH64.SQSUB**<br>
- **OPCODE.AARCH64.SQXTN2**<br>
- **OPCODE.AARCH64.SQXTN**<br>
- **OPCODE.AARCH64.SQXTUN2**<br>
- **OPCODE.AARCH64.SQXTUN**<br>
- **OPCODE.AARCH64.SRHADD**<br>
- **OPCODE.AARCH64.SRI**<br>
- **OPCODE.AARCH64.SRSHL**<br>
- **OPCODE.AARCH64.SRSHR**<br>
- **OPCODE.AARCH64.SRSRA**<br>
- **OPCODE.AARCH64.SSHLL2**<br>
- **OPCODE.AARCH64.SSHLL**<br>
- **OPCODE.AARCH64.SSHL**<br>
- **OPCODE.AARCH64.SSHR**<br>
- **OPCODE.AARCH64.SSRA**<br>
- **OPCODE.AARCH64.SSUBL2**<br>
- **OPCODE.AARCH64.SSUBL**<br>
- **OPCODE.AARCH64.SSUBW2**<br>
- **OPCODE.AARCH64.SSUBW**<br>
- **OPCODE.AARCH64.ST1**<br>
- **OPCODE.AARCH64.ST2**<br>
- **OPCODE.AARCH64.ST3**<br>
- **OPCODE.AARCH64.ST4**<br>
- **OPCODE.AARCH64.STLRB**<br>
- **OPCODE.AARCH64.STLRH**<br>
- **OPCODE.AARCH64.STLR**<br>
- **OPCODE.AARCH64.STLXP**<br>
- **OPCODE.AARCH64.STLXRB**<br>
- **OPCODE.AARCH64.STLXRH**<br>
- **OPCODE.AARCH64.STLXR**<br>
- **OPCODE.AARCH64.STNP**<br>
- **OPCODE.AARCH64.STP**<br>
- **OPCODE.AARCH64.STRB**<br>
- **OPCODE.AARCH64.STR**<br>
- **OPCODE.AARCH64.STRH**<br>
- **OPCODE.AARCH64.STTRB**<br>
- **OPCODE.AARCH64.STTRH**<br>
- **OPCODE.AARCH64.STTR**<br>
- **OPCODE.AARCH64.STURB**<br>
- **OPCODE.AARCH64.STUR**<br>
- **OPCODE.AARCH64.STURH**<br>
- **OPCODE.AARCH64.STXP**<br>
- **OPCODE.AARCH64.STXRB**<br>
- **OPCODE.AARCH64.STXRH**<br>
- **OPCODE.AARCH64.STXR**<br>
- **OPCODE.AARCH64.SUBHN**<br>
- **OPCODE.AARCH64.SUBHN2**<br>
- **OPCODE.AARCH64.SUB**<br>
- **OPCODE.AARCH64.SUQADD**<br>
- **OPCODE.AARCH64.SVC**<br>
- **OPCODE.AARCH64.SYSL**<br>
- **OPCODE.AARCH64.SYS**<br>
- **OPCODE.AARCH64.TBL**<br>
- **OPCODE.AARCH64.TBNZ**<br>
- **OPCODE.AARCH64.TBX**<br>
- **OPCODE.AARCH64.TBZ**<br>
- **OPCODE.AARCH64.TRN1**<br>
- **OPCODE.AARCH64.TRN2**<br>
- **OPCODE.AARCH64.UABAL2**<br>
- **OPCODE.AARCH64.UABAL**<br>
- **OPCODE.AARCH64.UABA**<br>
- **OPCODE.AARCH64.UABDL2**<br>
- **OPCODE.AARCH64.UABDL**<br>
- **OPCODE.AARCH64.UABD**<br>
- **OPCODE.AARCH64.UADALP**<br>
- **OPCODE.AARCH64.UADDLP**<br>
- **OPCODE.AARCH64.UADDLV**<br>
- **OPCODE.AARCH64.UADDL2**<br>
- **OPCODE.AARCH64.UADDL**<br>
- **OPCODE.AARCH64.UADDW2**<br>
- **OPCODE.AARCH64.UADDW**<br>
- **OPCODE.AARCH64.UBFM**<br>
- **OPCODE.AARCH64.UCVTF**<br>
- **OPCODE.AARCH64.UDIV**<br>
- **OPCODE.AARCH64.UHADD**<br>
- **OPCODE.AARCH64.UHSUB**<br>
- **OPCODE.AARCH64.UMADDL**<br>
- **OPCODE.AARCH64.UMAXP**<br>
- **OPCODE.AARCH64.UMAXV**<br>
- **OPCODE.AARCH64.UMAX**<br>
- **OPCODE.AARCH64.UMINP**<br>
- **OPCODE.AARCH64.UMINV**<br>
- **OPCODE.AARCH64.UMIN**<br>
- **OPCODE.AARCH64.UMLAL2**<br>
- **OPCODE.AARCH64.UMLAL**<br>
- **OPCODE.AARCH64.UMLSL2**<br>
- **OPCODE.AARCH64.UMLSL**<br>
- **OPCODE.AARCH64.UMOV**<br>
- **OPCODE.AARCH64.UMSUBL**<br>
- **OPCODE.AARCH64.UMULH**<br>
- **OPCODE.AARCH64.UMULL2**<br>
- **OPCODE.AARCH64.UMULL**<br>
- **OPCODE.AARCH64.UQADD**<br>
- **OPCODE.AARCH64.UQRSHL**<br>
- **OPCODE.AARCH64.UQRSHRN**<br>
- **OPCODE.AARCH64.UQRSHRN2**<br>
- **OPCODE.AARCH64.UQSHL**<br>
- **OPCODE.AARCH64.UQSHRN**<br>
- **OPCODE.AARCH64.UQSHRN2**<br>
- **OPCODE.AARCH64.UQSUB**<br>
- **OPCODE.AARCH64.UQXTN2**<br>
- **OPCODE.AARCH64.UQXTN**<br>
- **OPCODE.AARCH64.URECPE**<br>
- **OPCODE.AARCH64.URHADD**<br>
- **OPCODE.AARCH64.URSHL**<br>
- **OPCODE.AARCH64.URSHR**<br>
- **OPCODE.AARCH64.URSQRTE**<br>
- **OPCODE.AARCH64.URSRA**<br>
- **OPCODE.AARCH64.USHLL2**<br>
- **OPCODE.AARCH64.USHLL**<br>
- **OPCODE.AARCH64.USHL**<br>
- **OPCODE.AARCH64.USHR**<br>
- **OPCODE.AARCH64.USQADD**<br>
- **OPCODE.AARCH64.USRA**<br>
- **OPCODE.AARCH64.USUBL2**<br>
- **OPCODE.AARCH64.USUBL**<br>
- **OPCODE.AARCH64.USUBW2**<br>
- **OPCODE.AARCH64.USUBW**<br>
- **OPCODE.AARCH64.UZP1**<br>
- **OPCODE.AARCH64.UZP2**<br>
- **OPCODE.AARCH64.XTN2**<br>
- **OPCODE.AARCH64.XTN**<br>
- **OPCODE.AARCH64.ZIP1**<br>
- **OPCODE.AARCH64.ZIP2**<br>

\subsection OPCODE_riscv64_py_api RV64

- **OPCODE.RV64.ADD**<br>
- **OPCODE.RV64.ADDI**<br>
- **OPCODE.RV64.ADDIW**<br>
- **OPCODE.RV64.ADDW**<br>
- **OPCODE.RV64.AND**<br>
- **OPCODE.RV64.ANDI**<br>
- **OPCODE.RV64.AND**<br>
- **OPCODE.RV64.AUIPC**<br>
- **OPCODE.RV64.BEQ**<br>
- **OPCODE.RV64.BGE**<br>
- **OPCODE.RV64.BGEU**<br>
- **OPCODE.RV64.BLT**<br>
- **OPCODE.RV64.BLTU**<br>
- **OPCODE.RV64.BNE**<br>
- **OPCODE.RV64.C_ADD**<br>
- **OPCODE.RV64.C_ADDI**<br>
- **OPCODE.RV64.C_ADDI16SP**<br>
- **OPCODE.RV64.C_ADDI4SPN**<br>
- **OPCODE.RV64.C_ADDIW**<br>
- **OPCODE.RV64.C_ADDW**<br>
- **OPCODE.RV64.C_AND**<br>
- **OPCODE.RV64.C_ANDI**<br>
- **OPCODE.RV64.C_BEQZ**<br>
- **OPCODE.RV64.C_BNEZ**<br>
- **OPCODE.RV64.C_J**<br>
- **OPCODE.RV64.C_JALR**<br>
- **OPCODE.RV64.C_JR**<br>
- **OPCODE.RV64.C_LD**<br>
- **OPCODE.RV64.C_LDSP**<br>
- **OPCODE.RV64.C_LI**<br>
- **OPCODE.RV64.C_LUI**<br>
- **OPCODE.RV64.C_LW**<br>
- **OPCODE.RV64.C_LWSP**<br>
- **OPCODE.RV64.C_MV**<br>
- **OPCODE.RV64.C_NOP**<br>
- **OPCODE.RV64.C_OR**<br>
- **OPCODE.RV64.C_SD**<br>
- **OPCODE.RV64.C_SDSP**<br>
- **OPCODE.RV64.C_SLLI**<br>
- **OPCODE.RV64.C_SRAI**<br>
- **OPCODE.RV64.C_SRLI**<br>
- **OPCODE.RV64.C_SUB**<br>
- **OPCODE.RV64.C_SUBW**<br>
- **OPCODE.RV64.C_SW**<br>
- **OPCODE.RV64.C_SWSP**<br>
- **OPCODE.RV64.C_XOR**<br>
- **OPCODE.RV64.DIV**<br>
- **OPCODE.RV64.DIVU**<br>
- **OPCODE.RV64.DIVUW**<br>
- **OPCODE.RV64.DIVW**<br>
- **OPCODE.RV64.JAL**<br>
- **OPCODE.RV64.JALR**<br>
- **OPCODE.RV64.LB**<br>
- **OPCODE.RV64.LBU**<br>
- **OPCODE.RV64.LD**<br>
- **OPCODE.RV64.LH**<br>
- **OPCODE.RV64.LHU**<br>
- **OPCODE.RV64.LUI**<br>
- **OPCODE.RV64.LW**<br>
- **OPCODE.RV64.LWU**<br>
- **OPCODE.RV64.MUL**<br>
- **OPCODE.RV64.MULH**<br>
- **OPCODE.RV64.MULHSU**<br>
- **OPCODE.RV64.MULHU**<br>
- **OPCODE.RV64.MULW**<br>
- **OPCODE.RV64.OR**<br>
- **OPCODE.RV64.ORI**<br>
- **OPCODE.RV64.REM**<br>
- **OPCODE.RV64.REMU**<br>
- **OPCODE.RV64.REMUW**<br>
- **OPCODE.RV64.REMW**<br>
- **OPCODE.RV64.SB**<br>
- **OPCODE.RV64.SD**<br>
- **OPCODE.RV64.SH**<br>
- **OPCODE.RV64.SLL**<br>
- **OPCODE.RV64.SLLI**<br>
- **OPCODE.RV64.SLLIW**<br>
- **OPCODE.RV64.SLLW**<br>
- **OPCODE.RV64.SLT**<br>
- **OPCODE.RV64.SLTI**<br>
- **OPCODE.RV64.SLTIU**<br>
- **OPCODE.RV64.SLTU**<br>
- **OPCODE.RV64.SRA**<br>
- **OPCODE.RV64.SRAI**<br>
- **OPCODE.RV64.SRAIW**<br>
- **OPCODE.RV64.SRAW**<br>
- **OPCODE.RV64.SRL**<br>
- **OPCODE.RV64.SRLI**<br>
- **OPCODE.RV64.SRLIW**<br>
- **OPCODE.RV64.SRLW**<br>
- **OPCODE.RV64.SUB**<br>
- **OPCODE.RV64.SUBW**<br>
- **OPCODE.RV64.SW**<br>
- **OPCODE.RV64.XOR**<br>
- **OPCODE.RV64.XORI**<br>

\subsection OPCODE_riscv32_py_api RV32

- **OPCODE.RV32.ADD**<br>
- **OPCODE.RV32.ADDI**<br>
- **OPCODE.RV32.AND**<br>
- **OPCODE.RV32.ANDI**<br>
- **OPCODE.RV32.AND**<br>
- **OPCODE.RV32.AUIPC**<br>
- **OPCODE.RV32.BEQ**<br>
- **OPCODE.RV32.BGE**<br>
- **OPCODE.RV32.BGEU**<br>
- **OPCODE.RV32.BLT**<br>
- **OPCODE.RV32.BLTU**<br>
- **OPCODE.RV32.BNE**<br>
- **OPCODE.RV32.C_ADD**<br>
- **OPCODE.RV32.C_ADDI**<br>
- **OPCODE.RV32.C_ADDI16SP**<br>
- **OPCODE.RV32.C_ADDI4SPN**<br>
- **OPCODE.RV32.C_AND**<br>
- **OPCODE.RV32.C_ANDI**<br>
- **OPCODE.RV32.C_BEQZ**<br>
- **OPCODE.RV32.C_BNEZ**<br>
- **OPCODE.RV32.C_J**<br>
- **OPCODE.RV32.C_JAL**<br>
- **OPCODE.RV32.C_JALR**<br>
- **OPCODE.RV32.C_JR**<br>
- **OPCODE.RV32.C_LI**<br>
- **OPCODE.RV32.C_LUI**<br>
- **OPCODE.RV32.C_LW**<br>
- **OPCODE.RV32.C_LWSP**<br>
- **OPCODE.RV32.C_MV**<br>
- **OPCODE.RV32.C_NOP**<br>
- **OPCODE.RV32.C_OR**<br>
- **OPCODE.RV32.C_SLLI**<br>
- **OPCODE.RV32.C_SRAI**<br>
- **OPCODE.RV32.C_SRLI**<br>
- **OPCODE.RV32.C_SUB**<br>
- **OPCODE.RV32.C_SW**<br>
- **OPCODE.RV32.C_SWSP**<br>
- **OPCODE.RV32.C_XOR**<br>
- **OPCODE.RV32.DIV**<br>
- **OPCODE.RV32.DIVU**<br>
- **OPCODE.RV32.JAL**<br>
- **OPCODE.RV32.JALR**<br>
- **OPCODE.RV32.LB**<br>
- **OPCODE.RV32.LBU**<br>
- **OPCODE.RV32.LD**<br>
- **OPCODE.RV32.LH**<br>
- **OPCODE.RV32.LHU**<br>
- **OPCODE.RV32.LUI**<br>
- **OPCODE.RV32.LW**<br>
- **OPCODE.RV32.MUL**<br>
- **OPCODE.RV32.MULH**<br>
- **OPCODE.RV32.MULHS**<br>
- **OPCODE.RV32.MULHU**<br>
- **OPCODE.RV32.OR**<br>
- **OPCODE.RV32.ORI**<br>
- **OPCODE.RV32.REM**<br>
- **OPCODE.RV32.REMU**<br>
- **OPCODE.RV32.SB**<br>
- **OPCODE.RV32.SH**<br>
- **OPCODE.RV32.SLL**<br>
- **OPCODE.RV32.SLLI**<br>
- **OPCODE.RV32.SLT**<br>
- **OPCODE.RV32.SLTI**<br>
- **OPCODE.RV32.SLTIU**<br>
- **OPCODE.RV32.SLTU**<br>
- **OPCODE.RV32.SRA**<br>
- **OPCODE.RV32.SRAI**<br>
- **OPCODE.RV32.SRL**<br>
- **OPCODE.RV32.SRLI**<br>
- **OPCODE.RV32.SUB**<br>
- **OPCODE.RV32.SW**<br>
- **OPCODE.RV32.XOR**<br>
- **OPCODE.RV32.XORI**<br>

*/


namespace triton {
  namespace bindings {
    namespace python {

      void initOpcodesNamespace(PyObject* opcodesDict) {
        PyDict_Clear(opcodesDict);

        PyObject* x86OpcodesDict = xPyDict_New();

        xPyDict_SetItemString(x86OpcodesDict, "INVALID", PyLong_FromUint32(triton::arch::x86::ID_INS_INVALID));
        xPyDict_SetItemString(x86OpcodesDict, "AAA", PyLong_FromUint32(triton::arch::x86::ID_INS_AAA));
        xPyDict_SetItemString(x86OpcodesDict, "AAD", PyLong_FromUint32(triton::arch::x86::ID_INS_AAD));
        xPyDict_SetItemString(x86OpcodesDict, "AAM", PyLong_FromUint32(triton::arch::x86::ID_INS_AAM));
        xPyDict_SetItemString(x86OpcodesDict, "AAS", PyLong_FromUint32(triton::arch::x86::ID_INS_AAS));
        xPyDict_SetItemString(x86OpcodesDict, "FABS", PyLong_FromUint32(triton::arch::x86::ID_INS_FABS));
        xPyDict_SetItemString(x86OpcodesDict, "ADC", PyLong_FromUint32(triton::arch::x86::ID_INS_ADC));
        xPyDict_SetItemString(x86OpcodesDict, "ADCX", PyLong_FromUint32(triton::arch::x86::ID_INS_ADCX));
        xPyDict_SetItemString(x86OpcodesDict, "ADD", PyLong_FromUint32(triton::arch::x86::ID_INS_ADD));
        xPyDict_SetItemString(x86OpcodesDict, "ADDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_ADDPD));
        xPyDict_SetItemString(x86OpcodesDict, "ADDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_ADDPS));
        xPyDict_SetItemString(x86OpcodesDict, "ADDSD", PyLong_FromUint32(triton::arch::x86::ID_INS_ADDSD));
        xPyDict_SetItemString(x86OpcodesDict, "ADDSS", PyLong_FromUint32(triton::arch::x86::ID_INS_ADDSS));
        xPyDict_SetItemString(x86OpcodesDict, "ADDSUBPD", PyLong_FromUint32(triton::arch::x86::ID_INS_ADDSUBPD));
        xPyDict_SetItemString(x86OpcodesDict, "ADDSUBPS", PyLong_FromUint32(triton::arch::x86::ID_INS_ADDSUBPS));
        xPyDict_SetItemString(x86OpcodesDict, "FADD", PyLong_FromUint32(triton::arch::x86::ID_INS_FADD));
        xPyDict_SetItemString(x86OpcodesDict, "FIADD", PyLong_FromUint32(triton::arch::x86::ID_INS_FIADD));
        xPyDict_SetItemString(x86OpcodesDict, "FADDP", PyLong_FromUint32(triton::arch::x86::ID_INS_FADDP));
        xPyDict_SetItemString(x86OpcodesDict, "ADOX", PyLong_FromUint32(triton::arch::x86::ID_INS_ADOX));
        xPyDict_SetItemString(x86OpcodesDict, "AESDECLAST", PyLong_FromUint32(triton::arch::x86::ID_INS_AESDECLAST));
        xPyDict_SetItemString(x86OpcodesDict, "AESDEC", PyLong_FromUint32(triton::arch::x86::ID_INS_AESDEC));
        xPyDict_SetItemString(x86OpcodesDict, "AESENCLAST", PyLong_FromUint32(triton::arch::x86::ID_INS_AESENCLAST));
        xPyDict_SetItemString(x86OpcodesDict, "AESENC", PyLong_FromUint32(triton::arch::x86::ID_INS_AESENC));
        xPyDict_SetItemString(x86OpcodesDict, "AESIMC", PyLong_FromUint32(triton::arch::x86::ID_INS_AESIMC));
        xPyDict_SetItemString(x86OpcodesDict, "AESKEYGENASSIST", PyLong_FromUint32(triton::arch::x86::ID_INS_AESKEYGENASSIST));
        xPyDict_SetItemString(x86OpcodesDict, "AND", PyLong_FromUint32(triton::arch::x86::ID_INS_AND));
        xPyDict_SetItemString(x86OpcodesDict, "ANDN", PyLong_FromUint32(triton::arch::x86::ID_INS_ANDN));
        xPyDict_SetItemString(x86OpcodesDict, "ANDNPD", PyLong_FromUint32(triton::arch::x86::ID_INS_ANDNPD));
        xPyDict_SetItemString(x86OpcodesDict, "ANDNPS", PyLong_FromUint32(triton::arch::x86::ID_INS_ANDNPS));
        xPyDict_SetItemString(x86OpcodesDict, "ANDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_ANDPD));
        xPyDict_SetItemString(x86OpcodesDict, "ANDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_ANDPS));
        xPyDict_SetItemString(x86OpcodesDict, "ARPL", PyLong_FromUint32(triton::arch::x86::ID_INS_ARPL));
        xPyDict_SetItemString(x86OpcodesDict, "BEXTR", PyLong_FromUint32(triton::arch::x86::ID_INS_BEXTR));
        xPyDict_SetItemString(x86OpcodesDict, "BLCFILL", PyLong_FromUint32(triton::arch::x86::ID_INS_BLCFILL));
        xPyDict_SetItemString(x86OpcodesDict, "BLCI", PyLong_FromUint32(triton::arch::x86::ID_INS_BLCI));
        xPyDict_SetItemString(x86OpcodesDict, "BLCIC", PyLong_FromUint32(triton::arch::x86::ID_INS_BLCIC));
        xPyDict_SetItemString(x86OpcodesDict, "BLCMSK", PyLong_FromUint32(triton::arch::x86::ID_INS_BLCMSK));
        xPyDict_SetItemString(x86OpcodesDict, "BLCS", PyLong_FromUint32(triton::arch::x86::ID_INS_BLCS));
        xPyDict_SetItemString(x86OpcodesDict, "BLENDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_BLENDPD));
        xPyDict_SetItemString(x86OpcodesDict, "BLENDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_BLENDPS));
        xPyDict_SetItemString(x86OpcodesDict, "BLENDVPD", PyLong_FromUint32(triton::arch::x86::ID_INS_BLENDVPD));
        xPyDict_SetItemString(x86OpcodesDict, "BLENDVPS", PyLong_FromUint32(triton::arch::x86::ID_INS_BLENDVPS));
        xPyDict_SetItemString(x86OpcodesDict, "BLSFILL", PyLong_FromUint32(triton::arch::x86::ID_INS_BLSFILL));
        xPyDict_SetItemString(x86OpcodesDict, "BLSI", PyLong_FromUint32(triton::arch::x86::ID_INS_BLSI));
        xPyDict_SetItemString(x86OpcodesDict, "BLSIC", PyLong_FromUint32(triton::arch::x86::ID_INS_BLSIC));
        xPyDict_SetItemString(x86OpcodesDict, "BLSMSK", PyLong_FromUint32(triton::arch::x86::ID_INS_BLSMSK));
        xPyDict_SetItemString(x86OpcodesDict, "BLSR", PyLong_FromUint32(triton::arch::x86::ID_INS_BLSR));
        xPyDict_SetItemString(x86OpcodesDict, "BOUND", PyLong_FromUint32(triton::arch::x86::ID_INS_BOUND));
        xPyDict_SetItemString(x86OpcodesDict, "BSF", PyLong_FromUint32(triton::arch::x86::ID_INS_BSF));
        xPyDict_SetItemString(x86OpcodesDict, "BSR", PyLong_FromUint32(triton::arch::x86::ID_INS_BSR));
        xPyDict_SetItemString(x86OpcodesDict, "BSWAP", PyLong_FromUint32(triton::arch::x86::ID_INS_BSWAP));
        xPyDict_SetItemString(x86OpcodesDict, "BT", PyLong_FromUint32(triton::arch::x86::ID_INS_BT));
        xPyDict_SetItemString(x86OpcodesDict, "BTC", PyLong_FromUint32(triton::arch::x86::ID_INS_BTC));
        xPyDict_SetItemString(x86OpcodesDict, "BTR", PyLong_FromUint32(triton::arch::x86::ID_INS_BTR));
        xPyDict_SetItemString(x86OpcodesDict, "BTS", PyLong_FromUint32(triton::arch::x86::ID_INS_BTS));
        xPyDict_SetItemString(x86OpcodesDict, "BZHI", PyLong_FromUint32(triton::arch::x86::ID_INS_BZHI));
        xPyDict_SetItemString(x86OpcodesDict, "CALL", PyLong_FromUint32(triton::arch::x86::ID_INS_CALL));
        xPyDict_SetItemString(x86OpcodesDict, "CBW", PyLong_FromUint32(triton::arch::x86::ID_INS_CBW));
        xPyDict_SetItemString(x86OpcodesDict, "CDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_CDQ));
        xPyDict_SetItemString(x86OpcodesDict, "CDQE", PyLong_FromUint32(triton::arch::x86::ID_INS_CDQE));
        xPyDict_SetItemString(x86OpcodesDict, "FCHS", PyLong_FromUint32(triton::arch::x86::ID_INS_FCHS));
        xPyDict_SetItemString(x86OpcodesDict, "CLAC", PyLong_FromUint32(triton::arch::x86::ID_INS_CLAC));
        xPyDict_SetItemString(x86OpcodesDict, "CLC", PyLong_FromUint32(triton::arch::x86::ID_INS_CLC));
        xPyDict_SetItemString(x86OpcodesDict, "CLD", PyLong_FromUint32(triton::arch::x86::ID_INS_CLD));
        xPyDict_SetItemString(x86OpcodesDict, "CLFLUSH", PyLong_FromUint32(triton::arch::x86::ID_INS_CLFLUSH));
        xPyDict_SetItemString(x86OpcodesDict, "CLGI", PyLong_FromUint32(triton::arch::x86::ID_INS_CLGI));
        xPyDict_SetItemString(x86OpcodesDict, "CLI", PyLong_FromUint32(triton::arch::x86::ID_INS_CLI));
        xPyDict_SetItemString(x86OpcodesDict, "CLTS", PyLong_FromUint32(triton::arch::x86::ID_INS_CLTS));
        xPyDict_SetItemString(x86OpcodesDict, "CMC", PyLong_FromUint32(triton::arch::x86::ID_INS_CMC));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVA", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVA));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVAE", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVAE));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVB", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVB));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVBE", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVBE));
        xPyDict_SetItemString(x86OpcodesDict, "FCMOVBE", PyLong_FromUint32(triton::arch::x86::ID_INS_FCMOVBE));
        xPyDict_SetItemString(x86OpcodesDict, "FCMOVB", PyLong_FromUint32(triton::arch::x86::ID_INS_FCMOVB));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVE", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVE));
        xPyDict_SetItemString(x86OpcodesDict, "FCMOVE", PyLong_FromUint32(triton::arch::x86::ID_INS_FCMOVE));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVG", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVG));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVGE", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVGE));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVL", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVL));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVLE", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVLE));
        xPyDict_SetItemString(x86OpcodesDict, "FCMOVNBE", PyLong_FromUint32(triton::arch::x86::ID_INS_FCMOVNBE));
        xPyDict_SetItemString(x86OpcodesDict, "FCMOVNB", PyLong_FromUint32(triton::arch::x86::ID_INS_FCMOVNB));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVNE", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVNE));
        xPyDict_SetItemString(x86OpcodesDict, "FCMOVNE", PyLong_FromUint32(triton::arch::x86::ID_INS_FCMOVNE));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVNO", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVNO));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVNP", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVNP));
        xPyDict_SetItemString(x86OpcodesDict, "FCMOVNU", PyLong_FromUint32(triton::arch::x86::ID_INS_FCMOVNU));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVNS", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVNS));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVO", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVO));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVP", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVP));
        xPyDict_SetItemString(x86OpcodesDict, "FCMOVU", PyLong_FromUint32(triton::arch::x86::ID_INS_FCMOVU));
        xPyDict_SetItemString(x86OpcodesDict, "CMOVS", PyLong_FromUint32(triton::arch::x86::ID_INS_CMOVS));
        xPyDict_SetItemString(x86OpcodesDict, "CMP", PyLong_FromUint32(triton::arch::x86::ID_INS_CMP));
        xPyDict_SetItemString(x86OpcodesDict, "CMPPD", PyLong_FromUint32(triton::arch::x86::ID_INS_CMPPD));
        xPyDict_SetItemString(x86OpcodesDict, "CMPPS", PyLong_FromUint32(triton::arch::x86::ID_INS_CMPPS));
        xPyDict_SetItemString(x86OpcodesDict, "CMPSB", PyLong_FromUint32(triton::arch::x86::ID_INS_CMPSB));
        xPyDict_SetItemString(x86OpcodesDict, "CMPSD", PyLong_FromUint32(triton::arch::x86::ID_INS_CMPSD));
        xPyDict_SetItemString(x86OpcodesDict, "CMPSQ", PyLong_FromUint32(triton::arch::x86::ID_INS_CMPSQ));
        xPyDict_SetItemString(x86OpcodesDict, "CMPSS", PyLong_FromUint32(triton::arch::x86::ID_INS_CMPSS));
        xPyDict_SetItemString(x86OpcodesDict, "CMPSW", PyLong_FromUint32(triton::arch::x86::ID_INS_CMPSW));
        xPyDict_SetItemString(x86OpcodesDict, "CMPXCHG16B", PyLong_FromUint32(triton::arch::x86::ID_INS_CMPXCHG16B));
        xPyDict_SetItemString(x86OpcodesDict, "CMPXCHG", PyLong_FromUint32(triton::arch::x86::ID_INS_CMPXCHG));
        xPyDict_SetItemString(x86OpcodesDict, "CMPXCHG8B", PyLong_FromUint32(triton::arch::x86::ID_INS_CMPXCHG8B));
        xPyDict_SetItemString(x86OpcodesDict, "COMISD", PyLong_FromUint32(triton::arch::x86::ID_INS_COMISD));
        xPyDict_SetItemString(x86OpcodesDict, "COMISS", PyLong_FromUint32(triton::arch::x86::ID_INS_COMISS));
        xPyDict_SetItemString(x86OpcodesDict, "FCOMP", PyLong_FromUint32(triton::arch::x86::ID_INS_FCOMP));
        xPyDict_SetItemString(x86OpcodesDict, "FCOMPI", PyLong_FromUint32(triton::arch::x86::ID_INS_FCOMPI));
        xPyDict_SetItemString(x86OpcodesDict, "FCOMI", PyLong_FromUint32(triton::arch::x86::ID_INS_FCOMI));
        xPyDict_SetItemString(x86OpcodesDict, "FCOM", PyLong_FromUint32(triton::arch::x86::ID_INS_FCOM));
        xPyDict_SetItemString(x86OpcodesDict, "FCOS", PyLong_FromUint32(triton::arch::x86::ID_INS_FCOS));
        xPyDict_SetItemString(x86OpcodesDict, "CPUID", PyLong_FromUint32(triton::arch::x86::ID_INS_CPUID));
        xPyDict_SetItemString(x86OpcodesDict, "CQO", PyLong_FromUint32(triton::arch::x86::ID_INS_CQO));
        xPyDict_SetItemString(x86OpcodesDict, "CRC32", PyLong_FromUint32(triton::arch::x86::ID_INS_CRC32));
        xPyDict_SetItemString(x86OpcodesDict, "CVTDQ2PD", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTDQ2PD));
        xPyDict_SetItemString(x86OpcodesDict, "CVTDQ2PS", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTDQ2PS));
        xPyDict_SetItemString(x86OpcodesDict, "CVTPD2DQ", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTPD2DQ));
        xPyDict_SetItemString(x86OpcodesDict, "CVTPD2PS", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTPD2PS));
        xPyDict_SetItemString(x86OpcodesDict, "CVTPS2DQ", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTPS2DQ));
        xPyDict_SetItemString(x86OpcodesDict, "CVTPS2PD", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTPS2PD));
        xPyDict_SetItemString(x86OpcodesDict, "CVTSD2SI", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTSD2SI));
        xPyDict_SetItemString(x86OpcodesDict, "CVTSD2SS", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTSD2SS));
        xPyDict_SetItemString(x86OpcodesDict, "CVTSI2SD", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTSI2SD));
        xPyDict_SetItemString(x86OpcodesDict, "CVTSI2SS", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTSI2SS));
        xPyDict_SetItemString(x86OpcodesDict, "CVTSS2SD", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTSS2SD));
        xPyDict_SetItemString(x86OpcodesDict, "CVTSS2SI", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTSS2SI));
        xPyDict_SetItemString(x86OpcodesDict, "CVTTPD2DQ", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTTPD2DQ));
        xPyDict_SetItemString(x86OpcodesDict, "CVTTPS2DQ", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTTPS2DQ));
        xPyDict_SetItemString(x86OpcodesDict, "CVTTSD2SI", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTTSD2SI));
        xPyDict_SetItemString(x86OpcodesDict, "CVTTSS2SI", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTTSS2SI));
        xPyDict_SetItemString(x86OpcodesDict, "CWD", PyLong_FromUint32(triton::arch::x86::ID_INS_CWD));
        xPyDict_SetItemString(x86OpcodesDict, "CWDE", PyLong_FromUint32(triton::arch::x86::ID_INS_CWDE));
        xPyDict_SetItemString(x86OpcodesDict, "DAA", PyLong_FromUint32(triton::arch::x86::ID_INS_DAA));
        xPyDict_SetItemString(x86OpcodesDict, "DAS", PyLong_FromUint32(triton::arch::x86::ID_INS_DAS));
        xPyDict_SetItemString(x86OpcodesDict, "DATA16", PyLong_FromUint32(triton::arch::x86::ID_INS_DATA16));
        xPyDict_SetItemString(x86OpcodesDict, "DEC", PyLong_FromUint32(triton::arch::x86::ID_INS_DEC));
        xPyDict_SetItemString(x86OpcodesDict, "DIV", PyLong_FromUint32(triton::arch::x86::ID_INS_DIV));
        xPyDict_SetItemString(x86OpcodesDict, "DIVPD", PyLong_FromUint32(triton::arch::x86::ID_INS_DIVPD));
        xPyDict_SetItemString(x86OpcodesDict, "DIVPS", PyLong_FromUint32(triton::arch::x86::ID_INS_DIVPS));
        xPyDict_SetItemString(x86OpcodesDict, "FDIVR", PyLong_FromUint32(triton::arch::x86::ID_INS_FDIVR));
        xPyDict_SetItemString(x86OpcodesDict, "FIDIVR", PyLong_FromUint32(triton::arch::x86::ID_INS_FIDIVR));
        xPyDict_SetItemString(x86OpcodesDict, "FDIVRP", PyLong_FromUint32(triton::arch::x86::ID_INS_FDIVRP));
        xPyDict_SetItemString(x86OpcodesDict, "DIVSD", PyLong_FromUint32(triton::arch::x86::ID_INS_DIVSD));
        xPyDict_SetItemString(x86OpcodesDict, "DIVSS", PyLong_FromUint32(triton::arch::x86::ID_INS_DIVSS));
        xPyDict_SetItemString(x86OpcodesDict, "FDIV", PyLong_FromUint32(triton::arch::x86::ID_INS_FDIV));
        xPyDict_SetItemString(x86OpcodesDict, "FIDIV", PyLong_FromUint32(triton::arch::x86::ID_INS_FIDIV));
        xPyDict_SetItemString(x86OpcodesDict, "FDIVP", PyLong_FromUint32(triton::arch::x86::ID_INS_FDIVP));
        xPyDict_SetItemString(x86OpcodesDict, "DPPD", PyLong_FromUint32(triton::arch::x86::ID_INS_DPPD));
        xPyDict_SetItemString(x86OpcodesDict, "DPPS", PyLong_FromUint32(triton::arch::x86::ID_INS_DPPS));
        xPyDict_SetItemString(x86OpcodesDict, "RET", PyLong_FromUint32(triton::arch::x86::ID_INS_RET));
        xPyDict_SetItemString(x86OpcodesDict, "ENCLS", PyLong_FromUint32(triton::arch::x86::ID_INS_ENCLS));
        xPyDict_SetItemString(x86OpcodesDict, "ENCLU", PyLong_FromUint32(triton::arch::x86::ID_INS_ENCLU));
        xPyDict_SetItemString(x86OpcodesDict, "ENTER", PyLong_FromUint32(triton::arch::x86::ID_INS_ENTER));
        xPyDict_SetItemString(x86OpcodesDict, "EXTRACTPS", PyLong_FromUint32(triton::arch::x86::ID_INS_EXTRACTPS));
        xPyDict_SetItemString(x86OpcodesDict, "EXTRQ", PyLong_FromUint32(triton::arch::x86::ID_INS_EXTRQ));
        xPyDict_SetItemString(x86OpcodesDict, "F2XM1", PyLong_FromUint32(triton::arch::x86::ID_INS_F2XM1));
        xPyDict_SetItemString(x86OpcodesDict, "LCALL", PyLong_FromUint32(triton::arch::x86::ID_INS_LCALL));
        xPyDict_SetItemString(x86OpcodesDict, "LJMP", PyLong_FromUint32(triton::arch::x86::ID_INS_LJMP));
        xPyDict_SetItemString(x86OpcodesDict, "FBLD", PyLong_FromUint32(triton::arch::x86::ID_INS_FBLD));
        xPyDict_SetItemString(x86OpcodesDict, "FBSTP", PyLong_FromUint32(triton::arch::x86::ID_INS_FBSTP));
        xPyDict_SetItemString(x86OpcodesDict, "FCOMPP", PyLong_FromUint32(triton::arch::x86::ID_INS_FCOMPP));
        xPyDict_SetItemString(x86OpcodesDict, "FDECSTP", PyLong_FromUint32(triton::arch::x86::ID_INS_FDECSTP));
        xPyDict_SetItemString(x86OpcodesDict, "FEMMS", PyLong_FromUint32(triton::arch::x86::ID_INS_FEMMS));
        xPyDict_SetItemString(x86OpcodesDict, "FFREE", PyLong_FromUint32(triton::arch::x86::ID_INS_FFREE));
        xPyDict_SetItemString(x86OpcodesDict, "FICOM", PyLong_FromUint32(triton::arch::x86::ID_INS_FICOM));
        xPyDict_SetItemString(x86OpcodesDict, "FICOMP", PyLong_FromUint32(triton::arch::x86::ID_INS_FICOMP));
        xPyDict_SetItemString(x86OpcodesDict, "FINCSTP", PyLong_FromUint32(triton::arch::x86::ID_INS_FINCSTP));
        xPyDict_SetItemString(x86OpcodesDict, "FLDCW", PyLong_FromUint32(triton::arch::x86::ID_INS_FLDCW));
        xPyDict_SetItemString(x86OpcodesDict, "FLDENV", PyLong_FromUint32(triton::arch::x86::ID_INS_FLDENV));
        xPyDict_SetItemString(x86OpcodesDict, "FLDL2E", PyLong_FromUint32(triton::arch::x86::ID_INS_FLDL2E));
        xPyDict_SetItemString(x86OpcodesDict, "FLDL2T", PyLong_FromUint32(triton::arch::x86::ID_INS_FLDL2T));
        xPyDict_SetItemString(x86OpcodesDict, "FLDLG2", PyLong_FromUint32(triton::arch::x86::ID_INS_FLDLG2));
        xPyDict_SetItemString(x86OpcodesDict, "FLDLN2", PyLong_FromUint32(triton::arch::x86::ID_INS_FLDLN2));
        xPyDict_SetItemString(x86OpcodesDict, "FLDPI", PyLong_FromUint32(triton::arch::x86::ID_INS_FLDPI));
        xPyDict_SetItemString(x86OpcodesDict, "FNCLEX", PyLong_FromUint32(triton::arch::x86::ID_INS_FNCLEX));
        xPyDict_SetItemString(x86OpcodesDict, "FNINIT", PyLong_FromUint32(triton::arch::x86::ID_INS_FNINIT));
        xPyDict_SetItemString(x86OpcodesDict, "FNOP", PyLong_FromUint32(triton::arch::x86::ID_INS_FNOP));
        xPyDict_SetItemString(x86OpcodesDict, "FNSTCW", PyLong_FromUint32(triton::arch::x86::ID_INS_FNSTCW));
        xPyDict_SetItemString(x86OpcodesDict, "FNSTSW", PyLong_FromUint32(triton::arch::x86::ID_INS_FNSTSW));
        xPyDict_SetItemString(x86OpcodesDict, "FPATAN", PyLong_FromUint32(triton::arch::x86::ID_INS_FPATAN));
        xPyDict_SetItemString(x86OpcodesDict, "FPREM", PyLong_FromUint32(triton::arch::x86::ID_INS_FPREM));
        xPyDict_SetItemString(x86OpcodesDict, "FPREM1", PyLong_FromUint32(triton::arch::x86::ID_INS_FPREM1));
        xPyDict_SetItemString(x86OpcodesDict, "FPTAN", PyLong_FromUint32(triton::arch::x86::ID_INS_FPTAN));
        xPyDict_SetItemString(x86OpcodesDict, "FRNDINT", PyLong_FromUint32(triton::arch::x86::ID_INS_FRNDINT));
        xPyDict_SetItemString(x86OpcodesDict, "FRSTOR", PyLong_FromUint32(triton::arch::x86::ID_INS_FRSTOR));
        xPyDict_SetItemString(x86OpcodesDict, "FNSAVE", PyLong_FromUint32(triton::arch::x86::ID_INS_FNSAVE));
        xPyDict_SetItemString(x86OpcodesDict, "FSCALE", PyLong_FromUint32(triton::arch::x86::ID_INS_FSCALE));
        xPyDict_SetItemString(x86OpcodesDict, "FSETPM", PyLong_FromUint32(triton::arch::x86::ID_INS_FSETPM));
        xPyDict_SetItemString(x86OpcodesDict, "FSINCOS", PyLong_FromUint32(triton::arch::x86::ID_INS_FSINCOS));
        xPyDict_SetItemString(x86OpcodesDict, "FNSTENV", PyLong_FromUint32(triton::arch::x86::ID_INS_FNSTENV));
        xPyDict_SetItemString(x86OpcodesDict, "FXAM", PyLong_FromUint32(triton::arch::x86::ID_INS_FXAM));
        xPyDict_SetItemString(x86OpcodesDict, "FXRSTOR", PyLong_FromUint32(triton::arch::x86::ID_INS_FXRSTOR));
        xPyDict_SetItemString(x86OpcodesDict, "FXRSTOR64", PyLong_FromUint32(triton::arch::x86::ID_INS_FXRSTOR64));
        xPyDict_SetItemString(x86OpcodesDict, "FXSAVE", PyLong_FromUint32(triton::arch::x86::ID_INS_FXSAVE));
        xPyDict_SetItemString(x86OpcodesDict, "FXSAVE64", PyLong_FromUint32(triton::arch::x86::ID_INS_FXSAVE64));
        xPyDict_SetItemString(x86OpcodesDict, "FXTRACT", PyLong_FromUint32(triton::arch::x86::ID_INS_FXTRACT));
        xPyDict_SetItemString(x86OpcodesDict, "FYL2X", PyLong_FromUint32(triton::arch::x86::ID_INS_FYL2X));
        xPyDict_SetItemString(x86OpcodesDict, "FYL2XP1", PyLong_FromUint32(triton::arch::x86::ID_INS_FYL2XP1));
        xPyDict_SetItemString(x86OpcodesDict, "MOVAPD", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVAPD));
        xPyDict_SetItemString(x86OpcodesDict, "MOVAPS", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVAPS));
        xPyDict_SetItemString(x86OpcodesDict, "ORPD", PyLong_FromUint32(triton::arch::x86::ID_INS_ORPD));
        xPyDict_SetItemString(x86OpcodesDict, "ORPS", PyLong_FromUint32(triton::arch::x86::ID_INS_ORPS));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVAPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVAPD));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVAPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVAPS));
        xPyDict_SetItemString(x86OpcodesDict, "XORPD", PyLong_FromUint32(triton::arch::x86::ID_INS_XORPD));
        xPyDict_SetItemString(x86OpcodesDict, "XORPS", PyLong_FromUint32(triton::arch::x86::ID_INS_XORPS));
        xPyDict_SetItemString(x86OpcodesDict, "GETSEC", PyLong_FromUint32(triton::arch::x86::ID_INS_GETSEC));
        xPyDict_SetItemString(x86OpcodesDict, "HADDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_HADDPD));
        xPyDict_SetItemString(x86OpcodesDict, "HADDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_HADDPS));
        xPyDict_SetItemString(x86OpcodesDict, "HLT", PyLong_FromUint32(triton::arch::x86::ID_INS_HLT));
        xPyDict_SetItemString(x86OpcodesDict, "HSUBPD", PyLong_FromUint32(triton::arch::x86::ID_INS_HSUBPD));
        xPyDict_SetItemString(x86OpcodesDict, "HSUBPS", PyLong_FromUint32(triton::arch::x86::ID_INS_HSUBPS));
        xPyDict_SetItemString(x86OpcodesDict, "IDIV", PyLong_FromUint32(triton::arch::x86::ID_INS_IDIV));
        xPyDict_SetItemString(x86OpcodesDict, "FILD", PyLong_FromUint32(triton::arch::x86::ID_INS_FILD));
        xPyDict_SetItemString(x86OpcodesDict, "IMUL", PyLong_FromUint32(triton::arch::x86::ID_INS_IMUL));
        xPyDict_SetItemString(x86OpcodesDict, "IN", PyLong_FromUint32(triton::arch::x86::ID_INS_IN));
        xPyDict_SetItemString(x86OpcodesDict, "INC", PyLong_FromUint32(triton::arch::x86::ID_INS_INC));
        xPyDict_SetItemString(x86OpcodesDict, "INSB", PyLong_FromUint32(triton::arch::x86::ID_INS_INSB));
        xPyDict_SetItemString(x86OpcodesDict, "INSERTPS", PyLong_FromUint32(triton::arch::x86::ID_INS_INSERTPS));
        xPyDict_SetItemString(x86OpcodesDict, "INSERTQ", PyLong_FromUint32(triton::arch::x86::ID_INS_INSERTQ));
        xPyDict_SetItemString(x86OpcodesDict, "INSD", PyLong_FromUint32(triton::arch::x86::ID_INS_INSD));
        xPyDict_SetItemString(x86OpcodesDict, "INSW", PyLong_FromUint32(triton::arch::x86::ID_INS_INSW));
        xPyDict_SetItemString(x86OpcodesDict, "INT", PyLong_FromUint32(triton::arch::x86::ID_INS_INT));
        xPyDict_SetItemString(x86OpcodesDict, "INT1", PyLong_FromUint32(triton::arch::x86::ID_INS_INT1));
        xPyDict_SetItemString(x86OpcodesDict, "INT3", PyLong_FromUint32(triton::arch::x86::ID_INS_INT3));
        xPyDict_SetItemString(x86OpcodesDict, "INTO", PyLong_FromUint32(triton::arch::x86::ID_INS_INTO));
        xPyDict_SetItemString(x86OpcodesDict, "INVD", PyLong_FromUint32(triton::arch::x86::ID_INS_INVD));
        xPyDict_SetItemString(x86OpcodesDict, "INVEPT", PyLong_FromUint32(triton::arch::x86::ID_INS_INVEPT));
        xPyDict_SetItemString(x86OpcodesDict, "INVLPG", PyLong_FromUint32(triton::arch::x86::ID_INS_INVLPG));
        xPyDict_SetItemString(x86OpcodesDict, "INVLPGA", PyLong_FromUint32(triton::arch::x86::ID_INS_INVLPGA));
        xPyDict_SetItemString(x86OpcodesDict, "INVPCID", PyLong_FromUint32(triton::arch::x86::ID_INS_INVPCID));
        xPyDict_SetItemString(x86OpcodesDict, "INVVPID", PyLong_FromUint32(triton::arch::x86::ID_INS_INVVPID));
        xPyDict_SetItemString(x86OpcodesDict, "IRET", PyLong_FromUint32(triton::arch::x86::ID_INS_IRET));
        xPyDict_SetItemString(x86OpcodesDict, "IRETD", PyLong_FromUint32(triton::arch::x86::ID_INS_IRETD));
        xPyDict_SetItemString(x86OpcodesDict, "IRETQ", PyLong_FromUint32(triton::arch::x86::ID_INS_IRETQ));
        xPyDict_SetItemString(x86OpcodesDict, "FISTTP", PyLong_FromUint32(triton::arch::x86::ID_INS_FISTTP));
        xPyDict_SetItemString(x86OpcodesDict, "FIST", PyLong_FromUint32(triton::arch::x86::ID_INS_FIST));
        xPyDict_SetItemString(x86OpcodesDict, "FISTP", PyLong_FromUint32(triton::arch::x86::ID_INS_FISTP));
        xPyDict_SetItemString(x86OpcodesDict, "UCOMISD", PyLong_FromUint32(triton::arch::x86::ID_INS_UCOMISD));
        xPyDict_SetItemString(x86OpcodesDict, "UCOMISS", PyLong_FromUint32(triton::arch::x86::ID_INS_UCOMISS));
        xPyDict_SetItemString(x86OpcodesDict, "VCMP", PyLong_FromUint32(triton::arch::x86::ID_INS_VCMP));
        xPyDict_SetItemString(x86OpcodesDict, "VCOMISD", PyLong_FromUint32(triton::arch::x86::ID_INS_VCOMISD));
        xPyDict_SetItemString(x86OpcodesDict, "VCOMISS", PyLong_FromUint32(triton::arch::x86::ID_INS_VCOMISS));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTSD2SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTSD2SS));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTSI2SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTSI2SD));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTSI2SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTSI2SS));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTSS2SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTSS2SD));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTTSD2SI", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTTSD2SI));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTTSD2USI", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTTSD2USI));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTTSS2SI", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTTSS2SI));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTTSS2USI", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTTSS2USI));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTUSI2SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTUSI2SD));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTUSI2SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTUSI2SS));
        xPyDict_SetItemString(x86OpcodesDict, "VUCOMISD", PyLong_FromUint32(triton::arch::x86::ID_INS_VUCOMISD));
        xPyDict_SetItemString(x86OpcodesDict, "VUCOMISS", PyLong_FromUint32(triton::arch::x86::ID_INS_VUCOMISS));
        xPyDict_SetItemString(x86OpcodesDict, "JAE", PyLong_FromUint32(triton::arch::x86::ID_INS_JAE));
        xPyDict_SetItemString(x86OpcodesDict, "JA", PyLong_FromUint32(triton::arch::x86::ID_INS_JA));
        xPyDict_SetItemString(x86OpcodesDict, "JBE", PyLong_FromUint32(triton::arch::x86::ID_INS_JBE));
        xPyDict_SetItemString(x86OpcodesDict, "JB", PyLong_FromUint32(triton::arch::x86::ID_INS_JB));
        xPyDict_SetItemString(x86OpcodesDict, "JCXZ", PyLong_FromUint32(triton::arch::x86::ID_INS_JCXZ));
        xPyDict_SetItemString(x86OpcodesDict, "JECXZ", PyLong_FromUint32(triton::arch::x86::ID_INS_JECXZ));
        xPyDict_SetItemString(x86OpcodesDict, "JE", PyLong_FromUint32(triton::arch::x86::ID_INS_JE));
        xPyDict_SetItemString(x86OpcodesDict, "JGE", PyLong_FromUint32(triton::arch::x86::ID_INS_JGE));
        xPyDict_SetItemString(x86OpcodesDict, "JG", PyLong_FromUint32(triton::arch::x86::ID_INS_JG));
        xPyDict_SetItemString(x86OpcodesDict, "JLE", PyLong_FromUint32(triton::arch::x86::ID_INS_JLE));
        xPyDict_SetItemString(x86OpcodesDict, "JL", PyLong_FromUint32(triton::arch::x86::ID_INS_JL));
        xPyDict_SetItemString(x86OpcodesDict, "JMP", PyLong_FromUint32(triton::arch::x86::ID_INS_JMP));
        xPyDict_SetItemString(x86OpcodesDict, "JNE", PyLong_FromUint32(triton::arch::x86::ID_INS_JNE));
        xPyDict_SetItemString(x86OpcodesDict, "JNO", PyLong_FromUint32(triton::arch::x86::ID_INS_JNO));
        xPyDict_SetItemString(x86OpcodesDict, "JNP", PyLong_FromUint32(triton::arch::x86::ID_INS_JNP));
        xPyDict_SetItemString(x86OpcodesDict, "JNS", PyLong_FromUint32(triton::arch::x86::ID_INS_JNS));
        xPyDict_SetItemString(x86OpcodesDict, "JO", PyLong_FromUint32(triton::arch::x86::ID_INS_JO));
        xPyDict_SetItemString(x86OpcodesDict, "JP", PyLong_FromUint32(triton::arch::x86::ID_INS_JP));
        xPyDict_SetItemString(x86OpcodesDict, "JRCXZ", PyLong_FromUint32(triton::arch::x86::ID_INS_JRCXZ));
        xPyDict_SetItemString(x86OpcodesDict, "JS", PyLong_FromUint32(triton::arch::x86::ID_INS_JS));
        xPyDict_SetItemString(x86OpcodesDict, "KANDB", PyLong_FromUint32(triton::arch::x86::ID_INS_KANDB));
        xPyDict_SetItemString(x86OpcodesDict, "KANDD", PyLong_FromUint32(triton::arch::x86::ID_INS_KANDD));
        xPyDict_SetItemString(x86OpcodesDict, "KANDNB", PyLong_FromUint32(triton::arch::x86::ID_INS_KANDNB));
        xPyDict_SetItemString(x86OpcodesDict, "KANDND", PyLong_FromUint32(triton::arch::x86::ID_INS_KANDND));
        xPyDict_SetItemString(x86OpcodesDict, "KANDNQ", PyLong_FromUint32(triton::arch::x86::ID_INS_KANDNQ));
        xPyDict_SetItemString(x86OpcodesDict, "KANDNW", PyLong_FromUint32(triton::arch::x86::ID_INS_KANDNW));
        xPyDict_SetItemString(x86OpcodesDict, "KANDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_KANDQ));
        xPyDict_SetItemString(x86OpcodesDict, "KANDW", PyLong_FromUint32(triton::arch::x86::ID_INS_KANDW));
        xPyDict_SetItemString(x86OpcodesDict, "KMOVB", PyLong_FromUint32(triton::arch::x86::ID_INS_KMOVB));
        xPyDict_SetItemString(x86OpcodesDict, "KMOVD", PyLong_FromUint32(triton::arch::x86::ID_INS_KMOVD));
        xPyDict_SetItemString(x86OpcodesDict, "KMOVQ", PyLong_FromUint32(triton::arch::x86::ID_INS_KMOVQ));
        xPyDict_SetItemString(x86OpcodesDict, "KMOVW", PyLong_FromUint32(triton::arch::x86::ID_INS_KMOVW));
        xPyDict_SetItemString(x86OpcodesDict, "KNOTB", PyLong_FromUint32(triton::arch::x86::ID_INS_KNOTB));
        xPyDict_SetItemString(x86OpcodesDict, "KNOTD", PyLong_FromUint32(triton::arch::x86::ID_INS_KNOTD));
        xPyDict_SetItemString(x86OpcodesDict, "KNOTQ", PyLong_FromUint32(triton::arch::x86::ID_INS_KNOTQ));
        xPyDict_SetItemString(x86OpcodesDict, "KNOTW", PyLong_FromUint32(triton::arch::x86::ID_INS_KNOTW));
        xPyDict_SetItemString(x86OpcodesDict, "KORB", PyLong_FromUint32(triton::arch::x86::ID_INS_KORB));
        xPyDict_SetItemString(x86OpcodesDict, "KORD", PyLong_FromUint32(triton::arch::x86::ID_INS_KORD));
        xPyDict_SetItemString(x86OpcodesDict, "KORQ", PyLong_FromUint32(triton::arch::x86::ID_INS_KORQ));
        xPyDict_SetItemString(x86OpcodesDict, "KORTESTW", PyLong_FromUint32(triton::arch::x86::ID_INS_KORTESTW));
        xPyDict_SetItemString(x86OpcodesDict, "KORW", PyLong_FromUint32(triton::arch::x86::ID_INS_KORW));
        xPyDict_SetItemString(x86OpcodesDict, "KSHIFTLW", PyLong_FromUint32(triton::arch::x86::ID_INS_KSHIFTLW));
        xPyDict_SetItemString(x86OpcodesDict, "KSHIFTRW", PyLong_FromUint32(triton::arch::x86::ID_INS_KSHIFTRW));
        xPyDict_SetItemString(x86OpcodesDict, "KUNPCKBW", PyLong_FromUint32(triton::arch::x86::ID_INS_KUNPCKBW));
        xPyDict_SetItemString(x86OpcodesDict, "KXNORB", PyLong_FromUint32(triton::arch::x86::ID_INS_KXNORB));
        xPyDict_SetItemString(x86OpcodesDict, "KXNORD", PyLong_FromUint32(triton::arch::x86::ID_INS_KXNORD));
        xPyDict_SetItemString(x86OpcodesDict, "KXNORQ", PyLong_FromUint32(triton::arch::x86::ID_INS_KXNORQ));
        xPyDict_SetItemString(x86OpcodesDict, "KXNORW", PyLong_FromUint32(triton::arch::x86::ID_INS_KXNORW));
        xPyDict_SetItemString(x86OpcodesDict, "KXORB", PyLong_FromUint32(triton::arch::x86::ID_INS_KXORB));
        xPyDict_SetItemString(x86OpcodesDict, "KXORD", PyLong_FromUint32(triton::arch::x86::ID_INS_KXORD));
        xPyDict_SetItemString(x86OpcodesDict, "KXORQ", PyLong_FromUint32(triton::arch::x86::ID_INS_KXORQ));
        xPyDict_SetItemString(x86OpcodesDict, "KXORW", PyLong_FromUint32(triton::arch::x86::ID_INS_KXORW));
        xPyDict_SetItemString(x86OpcodesDict, "LAHF", PyLong_FromUint32(triton::arch::x86::ID_INS_LAHF));
        xPyDict_SetItemString(x86OpcodesDict, "LAR", PyLong_FromUint32(triton::arch::x86::ID_INS_LAR));
        xPyDict_SetItemString(x86OpcodesDict, "LDDQU", PyLong_FromUint32(triton::arch::x86::ID_INS_LDDQU));
        xPyDict_SetItemString(x86OpcodesDict, "LDMXCSR", PyLong_FromUint32(triton::arch::x86::ID_INS_LDMXCSR));
        xPyDict_SetItemString(x86OpcodesDict, "LDS", PyLong_FromUint32(triton::arch::x86::ID_INS_LDS));
        xPyDict_SetItemString(x86OpcodesDict, "FLDZ", PyLong_FromUint32(triton::arch::x86::ID_INS_FLDZ));
        xPyDict_SetItemString(x86OpcodesDict, "FLD1", PyLong_FromUint32(triton::arch::x86::ID_INS_FLD1));
        xPyDict_SetItemString(x86OpcodesDict, "FLD", PyLong_FromUint32(triton::arch::x86::ID_INS_FLD));
        xPyDict_SetItemString(x86OpcodesDict, "LEA", PyLong_FromUint32(triton::arch::x86::ID_INS_LEA));
        xPyDict_SetItemString(x86OpcodesDict, "LEAVE", PyLong_FromUint32(triton::arch::x86::ID_INS_LEAVE));
        xPyDict_SetItemString(x86OpcodesDict, "LES", PyLong_FromUint32(triton::arch::x86::ID_INS_LES));
        xPyDict_SetItemString(x86OpcodesDict, "LFENCE", PyLong_FromUint32(triton::arch::x86::ID_INS_LFENCE));
        xPyDict_SetItemString(x86OpcodesDict, "LFS", PyLong_FromUint32(triton::arch::x86::ID_INS_LFS));
        xPyDict_SetItemString(x86OpcodesDict, "LGDT", PyLong_FromUint32(triton::arch::x86::ID_INS_LGDT));
        xPyDict_SetItemString(x86OpcodesDict, "LGS", PyLong_FromUint32(triton::arch::x86::ID_INS_LGS));
        xPyDict_SetItemString(x86OpcodesDict, "LIDT", PyLong_FromUint32(triton::arch::x86::ID_INS_LIDT));
        xPyDict_SetItemString(x86OpcodesDict, "LLDT", PyLong_FromUint32(triton::arch::x86::ID_INS_LLDT));
        xPyDict_SetItemString(x86OpcodesDict, "LMSW", PyLong_FromUint32(triton::arch::x86::ID_INS_LMSW));
        xPyDict_SetItemString(x86OpcodesDict, "OR", PyLong_FromUint32(triton::arch::x86::ID_INS_OR));
        xPyDict_SetItemString(x86OpcodesDict, "SUB", PyLong_FromUint32(triton::arch::x86::ID_INS_SUB));
        xPyDict_SetItemString(x86OpcodesDict, "XOR", PyLong_FromUint32(triton::arch::x86::ID_INS_XOR));
        xPyDict_SetItemString(x86OpcodesDict, "LODSB", PyLong_FromUint32(triton::arch::x86::ID_INS_LODSB));
        xPyDict_SetItemString(x86OpcodesDict, "LODSD", PyLong_FromUint32(triton::arch::x86::ID_INS_LODSD));
        xPyDict_SetItemString(x86OpcodesDict, "LODSQ", PyLong_FromUint32(triton::arch::x86::ID_INS_LODSQ));
        xPyDict_SetItemString(x86OpcodesDict, "LODSW", PyLong_FromUint32(triton::arch::x86::ID_INS_LODSW));
        xPyDict_SetItemString(x86OpcodesDict, "LOOP", PyLong_FromUint32(triton::arch::x86::ID_INS_LOOP));
        xPyDict_SetItemString(x86OpcodesDict, "LOOPE", PyLong_FromUint32(triton::arch::x86::ID_INS_LOOPE));
        xPyDict_SetItemString(x86OpcodesDict, "LOOPNE", PyLong_FromUint32(triton::arch::x86::ID_INS_LOOPNE));
        xPyDict_SetItemString(x86OpcodesDict, "RETF", PyLong_FromUint32(triton::arch::x86::ID_INS_RETF));
        xPyDict_SetItemString(x86OpcodesDict, "RETFQ", PyLong_FromUint32(triton::arch::x86::ID_INS_RETFQ));
        xPyDict_SetItemString(x86OpcodesDict, "LSL", PyLong_FromUint32(triton::arch::x86::ID_INS_LSL));
        xPyDict_SetItemString(x86OpcodesDict, "LSS", PyLong_FromUint32(triton::arch::x86::ID_INS_LSS));
        xPyDict_SetItemString(x86OpcodesDict, "LTR", PyLong_FromUint32(triton::arch::x86::ID_INS_LTR));
        xPyDict_SetItemString(x86OpcodesDict, "XADD", PyLong_FromUint32(triton::arch::x86::ID_INS_XADD));
        xPyDict_SetItemString(x86OpcodesDict, "LZCNT", PyLong_FromUint32(triton::arch::x86::ID_INS_LZCNT));
        xPyDict_SetItemString(x86OpcodesDict, "MASKMOVDQU", PyLong_FromUint32(triton::arch::x86::ID_INS_MASKMOVDQU));
        xPyDict_SetItemString(x86OpcodesDict, "MAXPD", PyLong_FromUint32(triton::arch::x86::ID_INS_MAXPD));
        xPyDict_SetItemString(x86OpcodesDict, "MAXPS", PyLong_FromUint32(triton::arch::x86::ID_INS_MAXPS));
        xPyDict_SetItemString(x86OpcodesDict, "MAXSD", PyLong_FromUint32(triton::arch::x86::ID_INS_MAXSD));
        xPyDict_SetItemString(x86OpcodesDict, "MAXSS", PyLong_FromUint32(triton::arch::x86::ID_INS_MAXSS));
        xPyDict_SetItemString(x86OpcodesDict, "MFENCE", PyLong_FromUint32(triton::arch::x86::ID_INS_MFENCE));
        xPyDict_SetItemString(x86OpcodesDict, "MINPD", PyLong_FromUint32(triton::arch::x86::ID_INS_MINPD));
        xPyDict_SetItemString(x86OpcodesDict, "MINPS", PyLong_FromUint32(triton::arch::x86::ID_INS_MINPS));
        xPyDict_SetItemString(x86OpcodesDict, "MINSD", PyLong_FromUint32(triton::arch::x86::ID_INS_MINSD));
        xPyDict_SetItemString(x86OpcodesDict, "MINSS", PyLong_FromUint32(triton::arch::x86::ID_INS_MINSS));
        xPyDict_SetItemString(x86OpcodesDict, "CVTPD2PI", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTPD2PI));
        xPyDict_SetItemString(x86OpcodesDict, "CVTPI2PD", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTPI2PD));
        xPyDict_SetItemString(x86OpcodesDict, "CVTPI2PS", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTPI2PS));
        xPyDict_SetItemString(x86OpcodesDict, "CVTPS2PI", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTPS2PI));
        xPyDict_SetItemString(x86OpcodesDict, "CVTTPD2PI", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTTPD2PI));
        xPyDict_SetItemString(x86OpcodesDict, "CVTTPS2PI", PyLong_FromUint32(triton::arch::x86::ID_INS_CVTTPS2PI));
        xPyDict_SetItemString(x86OpcodesDict, "EMMS", PyLong_FromUint32(triton::arch::x86::ID_INS_EMMS));
        xPyDict_SetItemString(x86OpcodesDict, "MASKMOVQ", PyLong_FromUint32(triton::arch::x86::ID_INS_MASKMOVQ));
        xPyDict_SetItemString(x86OpcodesDict, "MOVD", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVD));
        xPyDict_SetItemString(x86OpcodesDict, "MOVDQ2Q", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVDQ2Q));
        xPyDict_SetItemString(x86OpcodesDict, "MOVNTQ", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVNTQ));
        xPyDict_SetItemString(x86OpcodesDict, "MOVQ2DQ", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVQ2DQ));
        xPyDict_SetItemString(x86OpcodesDict, "MOVQ", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVQ));
        xPyDict_SetItemString(x86OpcodesDict, "PABSB", PyLong_FromUint32(triton::arch::x86::ID_INS_PABSB));
        xPyDict_SetItemString(x86OpcodesDict, "PABSD", PyLong_FromUint32(triton::arch::x86::ID_INS_PABSD));
        xPyDict_SetItemString(x86OpcodesDict, "PABSW", PyLong_FromUint32(triton::arch::x86::ID_INS_PABSW));
        xPyDict_SetItemString(x86OpcodesDict, "PACKSSDW", PyLong_FromUint32(triton::arch::x86::ID_INS_PACKSSDW));
        xPyDict_SetItemString(x86OpcodesDict, "PACKSSWB", PyLong_FromUint32(triton::arch::x86::ID_INS_PACKSSWB));
        xPyDict_SetItemString(x86OpcodesDict, "PACKUSWB", PyLong_FromUint32(triton::arch::x86::ID_INS_PACKUSWB));
        xPyDict_SetItemString(x86OpcodesDict, "PADDB", PyLong_FromUint32(triton::arch::x86::ID_INS_PADDB));
        xPyDict_SetItemString(x86OpcodesDict, "PADDD", PyLong_FromUint32(triton::arch::x86::ID_INS_PADDD));
        xPyDict_SetItemString(x86OpcodesDict, "PADDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PADDQ));
        xPyDict_SetItemString(x86OpcodesDict, "PADDSB", PyLong_FromUint32(triton::arch::x86::ID_INS_PADDSB));
        xPyDict_SetItemString(x86OpcodesDict, "PADDSW", PyLong_FromUint32(triton::arch::x86::ID_INS_PADDSW));
        xPyDict_SetItemString(x86OpcodesDict, "PADDUSB", PyLong_FromUint32(triton::arch::x86::ID_INS_PADDUSB));
        xPyDict_SetItemString(x86OpcodesDict, "PADDUSW", PyLong_FromUint32(triton::arch::x86::ID_INS_PADDUSW));
        xPyDict_SetItemString(x86OpcodesDict, "PADDW", PyLong_FromUint32(triton::arch::x86::ID_INS_PADDW));
        xPyDict_SetItemString(x86OpcodesDict, "PALIGNR", PyLong_FromUint32(triton::arch::x86::ID_INS_PALIGNR));
        xPyDict_SetItemString(x86OpcodesDict, "PANDN", PyLong_FromUint32(triton::arch::x86::ID_INS_PANDN));
        xPyDict_SetItemString(x86OpcodesDict, "PAND", PyLong_FromUint32(triton::arch::x86::ID_INS_PAND));
        xPyDict_SetItemString(x86OpcodesDict, "PAVGB", PyLong_FromUint32(triton::arch::x86::ID_INS_PAVGB));
        xPyDict_SetItemString(x86OpcodesDict, "PAVGW", PyLong_FromUint32(triton::arch::x86::ID_INS_PAVGW));
        xPyDict_SetItemString(x86OpcodesDict, "PCMPEQB", PyLong_FromUint32(triton::arch::x86::ID_INS_PCMPEQB));
        xPyDict_SetItemString(x86OpcodesDict, "PCMPEQD", PyLong_FromUint32(triton::arch::x86::ID_INS_PCMPEQD));
        xPyDict_SetItemString(x86OpcodesDict, "PCMPEQW", PyLong_FromUint32(triton::arch::x86::ID_INS_PCMPEQW));
        xPyDict_SetItemString(x86OpcodesDict, "PCMPGTB", PyLong_FromUint32(triton::arch::x86::ID_INS_PCMPGTB));
        xPyDict_SetItemString(x86OpcodesDict, "PCMPGTD", PyLong_FromUint32(triton::arch::x86::ID_INS_PCMPGTD));
        xPyDict_SetItemString(x86OpcodesDict, "PCMPGTW", PyLong_FromUint32(triton::arch::x86::ID_INS_PCMPGTW));
        xPyDict_SetItemString(x86OpcodesDict, "PEXTRW", PyLong_FromUint32(triton::arch::x86::ID_INS_PEXTRW));
        xPyDict_SetItemString(x86OpcodesDict, "PHADDSW", PyLong_FromUint32(triton::arch::x86::ID_INS_PHADDSW));
        xPyDict_SetItemString(x86OpcodesDict, "PHADDW", PyLong_FromUint32(triton::arch::x86::ID_INS_PHADDW));
        xPyDict_SetItemString(x86OpcodesDict, "PHADDD", PyLong_FromUint32(triton::arch::x86::ID_INS_PHADDD));
        xPyDict_SetItemString(x86OpcodesDict, "PHSUBD", PyLong_FromUint32(triton::arch::x86::ID_INS_PHSUBD));
        xPyDict_SetItemString(x86OpcodesDict, "PHSUBSW", PyLong_FromUint32(triton::arch::x86::ID_INS_PHSUBSW));
        xPyDict_SetItemString(x86OpcodesDict, "PHSUBW", PyLong_FromUint32(triton::arch::x86::ID_INS_PHSUBW));
        xPyDict_SetItemString(x86OpcodesDict, "PINSRW", PyLong_FromUint32(triton::arch::x86::ID_INS_PINSRW));
        xPyDict_SetItemString(x86OpcodesDict, "PMADDUBSW", PyLong_FromUint32(triton::arch::x86::ID_INS_PMADDUBSW));
        xPyDict_SetItemString(x86OpcodesDict, "PMADDWD", PyLong_FromUint32(triton::arch::x86::ID_INS_PMADDWD));
        xPyDict_SetItemString(x86OpcodesDict, "PMAXSW", PyLong_FromUint32(triton::arch::x86::ID_INS_PMAXSW));
        xPyDict_SetItemString(x86OpcodesDict, "PMAXUB", PyLong_FromUint32(triton::arch::x86::ID_INS_PMAXUB));
        xPyDict_SetItemString(x86OpcodesDict, "PMINSW", PyLong_FromUint32(triton::arch::x86::ID_INS_PMINSW));
        xPyDict_SetItemString(x86OpcodesDict, "PMINUB", PyLong_FromUint32(triton::arch::x86::ID_INS_PMINUB));
        xPyDict_SetItemString(x86OpcodesDict, "PMOVMSKB", PyLong_FromUint32(triton::arch::x86::ID_INS_PMOVMSKB));
        xPyDict_SetItemString(x86OpcodesDict, "PMULHRSW", PyLong_FromUint32(triton::arch::x86::ID_INS_PMULHRSW));
        xPyDict_SetItemString(x86OpcodesDict, "PMULHUW", PyLong_FromUint32(triton::arch::x86::ID_INS_PMULHUW));
        xPyDict_SetItemString(x86OpcodesDict, "PMULHW", PyLong_FromUint32(triton::arch::x86::ID_INS_PMULHW));
        xPyDict_SetItemString(x86OpcodesDict, "PMULLW", PyLong_FromUint32(triton::arch::x86::ID_INS_PMULLW));
        xPyDict_SetItemString(x86OpcodesDict, "PMULUDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PMULUDQ));
        xPyDict_SetItemString(x86OpcodesDict, "POR", PyLong_FromUint32(triton::arch::x86::ID_INS_POR));
        xPyDict_SetItemString(x86OpcodesDict, "PSADBW", PyLong_FromUint32(triton::arch::x86::ID_INS_PSADBW));
        xPyDict_SetItemString(x86OpcodesDict, "PSHUFB", PyLong_FromUint32(triton::arch::x86::ID_INS_PSHUFB));
        xPyDict_SetItemString(x86OpcodesDict, "PSHUFW", PyLong_FromUint32(triton::arch::x86::ID_INS_PSHUFW));
        xPyDict_SetItemString(x86OpcodesDict, "PSIGNB", PyLong_FromUint32(triton::arch::x86::ID_INS_PSIGNB));
        xPyDict_SetItemString(x86OpcodesDict, "PSIGND", PyLong_FromUint32(triton::arch::x86::ID_INS_PSIGND));
        xPyDict_SetItemString(x86OpcodesDict, "PSIGNW", PyLong_FromUint32(triton::arch::x86::ID_INS_PSIGNW));
        xPyDict_SetItemString(x86OpcodesDict, "PSLLD", PyLong_FromUint32(triton::arch::x86::ID_INS_PSLLD));
        xPyDict_SetItemString(x86OpcodesDict, "PSLLQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PSLLQ));
        xPyDict_SetItemString(x86OpcodesDict, "PSLLW", PyLong_FromUint32(triton::arch::x86::ID_INS_PSLLW));
        xPyDict_SetItemString(x86OpcodesDict, "PSRAD", PyLong_FromUint32(triton::arch::x86::ID_INS_PSRAD));
        xPyDict_SetItemString(x86OpcodesDict, "PSRAW", PyLong_FromUint32(triton::arch::x86::ID_INS_PSRAW));
        xPyDict_SetItemString(x86OpcodesDict, "PSRLD", PyLong_FromUint32(triton::arch::x86::ID_INS_PSRLD));
        xPyDict_SetItemString(x86OpcodesDict, "PSRLQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PSRLQ));
        xPyDict_SetItemString(x86OpcodesDict, "PSRLW", PyLong_FromUint32(triton::arch::x86::ID_INS_PSRLW));
        xPyDict_SetItemString(x86OpcodesDict, "PSUBB", PyLong_FromUint32(triton::arch::x86::ID_INS_PSUBB));
        xPyDict_SetItemString(x86OpcodesDict, "PSUBD", PyLong_FromUint32(triton::arch::x86::ID_INS_PSUBD));
        xPyDict_SetItemString(x86OpcodesDict, "PSUBQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PSUBQ));
        xPyDict_SetItemString(x86OpcodesDict, "PSUBSB", PyLong_FromUint32(triton::arch::x86::ID_INS_PSUBSB));
        xPyDict_SetItemString(x86OpcodesDict, "PSUBSW", PyLong_FromUint32(triton::arch::x86::ID_INS_PSUBSW));
        xPyDict_SetItemString(x86OpcodesDict, "PSUBUSB", PyLong_FromUint32(triton::arch::x86::ID_INS_PSUBUSB));
        xPyDict_SetItemString(x86OpcodesDict, "PSUBUSW", PyLong_FromUint32(triton::arch::x86::ID_INS_PSUBUSW));
        xPyDict_SetItemString(x86OpcodesDict, "PSUBW", PyLong_FromUint32(triton::arch::x86::ID_INS_PSUBW));
        xPyDict_SetItemString(x86OpcodesDict, "PUNPCKHBW", PyLong_FromUint32(triton::arch::x86::ID_INS_PUNPCKHBW));
        xPyDict_SetItemString(x86OpcodesDict, "PUNPCKHDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PUNPCKHDQ));
        xPyDict_SetItemString(x86OpcodesDict, "PUNPCKHWD", PyLong_FromUint32(triton::arch::x86::ID_INS_PUNPCKHWD));
        xPyDict_SetItemString(x86OpcodesDict, "PUNPCKLBW", PyLong_FromUint32(triton::arch::x86::ID_INS_PUNPCKLBW));
        xPyDict_SetItemString(x86OpcodesDict, "PUNPCKLDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PUNPCKLDQ));
        xPyDict_SetItemString(x86OpcodesDict, "PUNPCKLWD", PyLong_FromUint32(triton::arch::x86::ID_INS_PUNPCKLWD));
        xPyDict_SetItemString(x86OpcodesDict, "PXOR", PyLong_FromUint32(triton::arch::x86::ID_INS_PXOR));
        xPyDict_SetItemString(x86OpcodesDict, "MONITOR", PyLong_FromUint32(triton::arch::x86::ID_INS_MONITOR));
        xPyDict_SetItemString(x86OpcodesDict, "MONTMUL", PyLong_FromUint32(triton::arch::x86::ID_INS_MONTMUL));
        xPyDict_SetItemString(x86OpcodesDict, "MOV", PyLong_FromUint32(triton::arch::x86::ID_INS_MOV));
        xPyDict_SetItemString(x86OpcodesDict, "MOVABS", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVABS));
        xPyDict_SetItemString(x86OpcodesDict, "MOVBE", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVBE));
        xPyDict_SetItemString(x86OpcodesDict, "MOVDDUP", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVDDUP));
        xPyDict_SetItemString(x86OpcodesDict, "MOVDQA", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVDQA));
        xPyDict_SetItemString(x86OpcodesDict, "MOVDQU", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVDQU));
        xPyDict_SetItemString(x86OpcodesDict, "MOVHLPS", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVHLPS));
        xPyDict_SetItemString(x86OpcodesDict, "MOVHPD", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVHPD));
        xPyDict_SetItemString(x86OpcodesDict, "MOVHPS", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVHPS));
        xPyDict_SetItemString(x86OpcodesDict, "MOVLHPS", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVLHPS));
        xPyDict_SetItemString(x86OpcodesDict, "MOVLPD", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVLPD));
        xPyDict_SetItemString(x86OpcodesDict, "MOVLPS", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVLPS));
        xPyDict_SetItemString(x86OpcodesDict, "MOVMSKPD", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVMSKPD));
        xPyDict_SetItemString(x86OpcodesDict, "MOVMSKPS", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVMSKPS));
        xPyDict_SetItemString(x86OpcodesDict, "MOVNTDQA", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVNTDQA));
        xPyDict_SetItemString(x86OpcodesDict, "MOVNTDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVNTDQ));
        xPyDict_SetItemString(x86OpcodesDict, "MOVNTI", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVNTI));
        xPyDict_SetItemString(x86OpcodesDict, "MOVNTPD", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVNTPD));
        xPyDict_SetItemString(x86OpcodesDict, "MOVNTPS", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVNTPS));
        xPyDict_SetItemString(x86OpcodesDict, "MOVNTSD", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVNTSD));
        xPyDict_SetItemString(x86OpcodesDict, "MOVNTSS", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVNTSS));
        xPyDict_SetItemString(x86OpcodesDict, "MOVSB", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVSB));
        xPyDict_SetItemString(x86OpcodesDict, "MOVSD", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVSD));
        xPyDict_SetItemString(x86OpcodesDict, "MOVSHDUP", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVSHDUP));
        xPyDict_SetItemString(x86OpcodesDict, "MOVSLDUP", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVSLDUP));
        xPyDict_SetItemString(x86OpcodesDict, "MOVSQ", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVSQ));
        xPyDict_SetItemString(x86OpcodesDict, "MOVSS", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVSS));
        xPyDict_SetItemString(x86OpcodesDict, "MOVSW", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVSW));
        xPyDict_SetItemString(x86OpcodesDict, "MOVSX", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVSX));
        xPyDict_SetItemString(x86OpcodesDict, "MOVSXD", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVSXD));
        xPyDict_SetItemString(x86OpcodesDict, "MOVUPD", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVUPD));
        xPyDict_SetItemString(x86OpcodesDict, "MOVUPS", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVUPS));
        xPyDict_SetItemString(x86OpcodesDict, "MOVZX", PyLong_FromUint32(triton::arch::x86::ID_INS_MOVZX));
        xPyDict_SetItemString(x86OpcodesDict, "MPSADBW", PyLong_FromUint32(triton::arch::x86::ID_INS_MPSADBW));
        xPyDict_SetItemString(x86OpcodesDict, "MUL", PyLong_FromUint32(triton::arch::x86::ID_INS_MUL));
        xPyDict_SetItemString(x86OpcodesDict, "MULPD", PyLong_FromUint32(triton::arch::x86::ID_INS_MULPD));
        xPyDict_SetItemString(x86OpcodesDict, "MULPS", PyLong_FromUint32(triton::arch::x86::ID_INS_MULPS));
        xPyDict_SetItemString(x86OpcodesDict, "MULSD", PyLong_FromUint32(triton::arch::x86::ID_INS_MULSD));
        xPyDict_SetItemString(x86OpcodesDict, "MULSS", PyLong_FromUint32(triton::arch::x86::ID_INS_MULSS));
        xPyDict_SetItemString(x86OpcodesDict, "MULX", PyLong_FromUint32(triton::arch::x86::ID_INS_MULX));
        xPyDict_SetItemString(x86OpcodesDict, "FMUL", PyLong_FromUint32(triton::arch::x86::ID_INS_FMUL));
        xPyDict_SetItemString(x86OpcodesDict, "FIMUL", PyLong_FromUint32(triton::arch::x86::ID_INS_FIMUL));
        xPyDict_SetItemString(x86OpcodesDict, "FMULP", PyLong_FromUint32(triton::arch::x86::ID_INS_FMULP));
        xPyDict_SetItemString(x86OpcodesDict, "MWAIT", PyLong_FromUint32(triton::arch::x86::ID_INS_MWAIT));
        xPyDict_SetItemString(x86OpcodesDict, "NEG", PyLong_FromUint32(triton::arch::x86::ID_INS_NEG));
        xPyDict_SetItemString(x86OpcodesDict, "NOP", PyLong_FromUint32(triton::arch::x86::ID_INS_NOP));
        xPyDict_SetItemString(x86OpcodesDict, "NOT", PyLong_FromUint32(triton::arch::x86::ID_INS_NOT));
        xPyDict_SetItemString(x86OpcodesDict, "OUT", PyLong_FromUint32(triton::arch::x86::ID_INS_OUT));
        xPyDict_SetItemString(x86OpcodesDict, "OUTSB", PyLong_FromUint32(triton::arch::x86::ID_INS_OUTSB));
        xPyDict_SetItemString(x86OpcodesDict, "OUTSD", PyLong_FromUint32(triton::arch::x86::ID_INS_OUTSD));
        xPyDict_SetItemString(x86OpcodesDict, "OUTSW", PyLong_FromUint32(triton::arch::x86::ID_INS_OUTSW));
        xPyDict_SetItemString(x86OpcodesDict, "PACKUSDW", PyLong_FromUint32(triton::arch::x86::ID_INS_PACKUSDW));
        xPyDict_SetItemString(x86OpcodesDict, "PAUSE", PyLong_FromUint32(triton::arch::x86::ID_INS_PAUSE));
        xPyDict_SetItemString(x86OpcodesDict, "PAVGUSB", PyLong_FromUint32(triton::arch::x86::ID_INS_PAVGUSB));
        xPyDict_SetItemString(x86OpcodesDict, "PBLENDVB", PyLong_FromUint32(triton::arch::x86::ID_INS_PBLENDVB));
        xPyDict_SetItemString(x86OpcodesDict, "PBLENDW", PyLong_FromUint32(triton::arch::x86::ID_INS_PBLENDW));
        xPyDict_SetItemString(x86OpcodesDict, "PCLMULQDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PCLMULQDQ));
        xPyDict_SetItemString(x86OpcodesDict, "PCMPEQQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PCMPEQQ));
        xPyDict_SetItemString(x86OpcodesDict, "PCMPESTRI", PyLong_FromUint32(triton::arch::x86::ID_INS_PCMPESTRI));
        xPyDict_SetItemString(x86OpcodesDict, "PCMPESTRM", PyLong_FromUint32(triton::arch::x86::ID_INS_PCMPESTRM));
        xPyDict_SetItemString(x86OpcodesDict, "PCMPGTQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PCMPGTQ));
        xPyDict_SetItemString(x86OpcodesDict, "PCMPISTRI", PyLong_FromUint32(triton::arch::x86::ID_INS_PCMPISTRI));
        xPyDict_SetItemString(x86OpcodesDict, "PCMPISTRM", PyLong_FromUint32(triton::arch::x86::ID_INS_PCMPISTRM));
        xPyDict_SetItemString(x86OpcodesDict, "PDEP", PyLong_FromUint32(triton::arch::x86::ID_INS_PDEP));
        xPyDict_SetItemString(x86OpcodesDict, "PEXT", PyLong_FromUint32(triton::arch::x86::ID_INS_PEXT));
        xPyDict_SetItemString(x86OpcodesDict, "PEXTRB", PyLong_FromUint32(triton::arch::x86::ID_INS_PEXTRB));
        xPyDict_SetItemString(x86OpcodesDict, "PEXTRD", PyLong_FromUint32(triton::arch::x86::ID_INS_PEXTRD));
        xPyDict_SetItemString(x86OpcodesDict, "PEXTRQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PEXTRQ));
        xPyDict_SetItemString(x86OpcodesDict, "PF2ID", PyLong_FromUint32(triton::arch::x86::ID_INS_PF2ID));
        xPyDict_SetItemString(x86OpcodesDict, "PF2IW", PyLong_FromUint32(triton::arch::x86::ID_INS_PF2IW));
        xPyDict_SetItemString(x86OpcodesDict, "PFACC", PyLong_FromUint32(triton::arch::x86::ID_INS_PFACC));
        xPyDict_SetItemString(x86OpcodesDict, "PFADD", PyLong_FromUint32(triton::arch::x86::ID_INS_PFADD));
        xPyDict_SetItemString(x86OpcodesDict, "PFCMPEQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PFCMPEQ));
        xPyDict_SetItemString(x86OpcodesDict, "PFCMPGE", PyLong_FromUint32(triton::arch::x86::ID_INS_PFCMPGE));
        xPyDict_SetItemString(x86OpcodesDict, "PFCMPGT", PyLong_FromUint32(triton::arch::x86::ID_INS_PFCMPGT));
        xPyDict_SetItemString(x86OpcodesDict, "PFMAX", PyLong_FromUint32(triton::arch::x86::ID_INS_PFMAX));
        xPyDict_SetItemString(x86OpcodesDict, "PFMIN", PyLong_FromUint32(triton::arch::x86::ID_INS_PFMIN));
        xPyDict_SetItemString(x86OpcodesDict, "PFMUL", PyLong_FromUint32(triton::arch::x86::ID_INS_PFMUL));
        xPyDict_SetItemString(x86OpcodesDict, "PFNACC", PyLong_FromUint32(triton::arch::x86::ID_INS_PFNACC));
        xPyDict_SetItemString(x86OpcodesDict, "PFPNACC", PyLong_FromUint32(triton::arch::x86::ID_INS_PFPNACC));
        xPyDict_SetItemString(x86OpcodesDict, "PFRCPIT1", PyLong_FromUint32(triton::arch::x86::ID_INS_PFRCPIT1));
        xPyDict_SetItemString(x86OpcodesDict, "PFRCPIT2", PyLong_FromUint32(triton::arch::x86::ID_INS_PFRCPIT2));
        xPyDict_SetItemString(x86OpcodesDict, "PFRCP", PyLong_FromUint32(triton::arch::x86::ID_INS_PFRCP));
        xPyDict_SetItemString(x86OpcodesDict, "PFRSQIT1", PyLong_FromUint32(triton::arch::x86::ID_INS_PFRSQIT1));
        xPyDict_SetItemString(x86OpcodesDict, "PFRSQRT", PyLong_FromUint32(triton::arch::x86::ID_INS_PFRSQRT));
        xPyDict_SetItemString(x86OpcodesDict, "PFSUBR", PyLong_FromUint32(triton::arch::x86::ID_INS_PFSUBR));
        xPyDict_SetItemString(x86OpcodesDict, "PFSUB", PyLong_FromUint32(triton::arch::x86::ID_INS_PFSUB));
        xPyDict_SetItemString(x86OpcodesDict, "PHMINPOSUW", PyLong_FromUint32(triton::arch::x86::ID_INS_PHMINPOSUW));
        xPyDict_SetItemString(x86OpcodesDict, "PI2FD", PyLong_FromUint32(triton::arch::x86::ID_INS_PI2FD));
        xPyDict_SetItemString(x86OpcodesDict, "PI2FW", PyLong_FromUint32(triton::arch::x86::ID_INS_PI2FW));
        xPyDict_SetItemString(x86OpcodesDict, "PINSRB", PyLong_FromUint32(triton::arch::x86::ID_INS_PINSRB));
        xPyDict_SetItemString(x86OpcodesDict, "PINSRD", PyLong_FromUint32(triton::arch::x86::ID_INS_PINSRD));
        xPyDict_SetItemString(x86OpcodesDict, "PINSRQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PINSRQ));
        xPyDict_SetItemString(x86OpcodesDict, "PMAXSB", PyLong_FromUint32(triton::arch::x86::ID_INS_PMAXSB));
        xPyDict_SetItemString(x86OpcodesDict, "PMAXSD", PyLong_FromUint32(triton::arch::x86::ID_INS_PMAXSD));
        xPyDict_SetItemString(x86OpcodesDict, "PMAXUD", PyLong_FromUint32(triton::arch::x86::ID_INS_PMAXUD));
        xPyDict_SetItemString(x86OpcodesDict, "PMAXUW", PyLong_FromUint32(triton::arch::x86::ID_INS_PMAXUW));
        xPyDict_SetItemString(x86OpcodesDict, "PMINSB", PyLong_FromUint32(triton::arch::x86::ID_INS_PMINSB));
        xPyDict_SetItemString(x86OpcodesDict, "PMINSD", PyLong_FromUint32(triton::arch::x86::ID_INS_PMINSD));
        xPyDict_SetItemString(x86OpcodesDict, "PMINUD", PyLong_FromUint32(triton::arch::x86::ID_INS_PMINUD));
        xPyDict_SetItemString(x86OpcodesDict, "PMINUW", PyLong_FromUint32(triton::arch::x86::ID_INS_PMINUW));
        xPyDict_SetItemString(x86OpcodesDict, "PMOVSXBD", PyLong_FromUint32(triton::arch::x86::ID_INS_PMOVSXBD));
        xPyDict_SetItemString(x86OpcodesDict, "PMOVSXBQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PMOVSXBQ));
        xPyDict_SetItemString(x86OpcodesDict, "PMOVSXBW", PyLong_FromUint32(triton::arch::x86::ID_INS_PMOVSXBW));
        xPyDict_SetItemString(x86OpcodesDict, "PMOVSXDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PMOVSXDQ));
        xPyDict_SetItemString(x86OpcodesDict, "PMOVSXWD", PyLong_FromUint32(triton::arch::x86::ID_INS_PMOVSXWD));
        xPyDict_SetItemString(x86OpcodesDict, "PMOVSXWQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PMOVSXWQ));
        xPyDict_SetItemString(x86OpcodesDict, "PMOVZXBD", PyLong_FromUint32(triton::arch::x86::ID_INS_PMOVZXBD));
        xPyDict_SetItemString(x86OpcodesDict, "PMOVZXBQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PMOVZXBQ));
        xPyDict_SetItemString(x86OpcodesDict, "PMOVZXBW", PyLong_FromUint32(triton::arch::x86::ID_INS_PMOVZXBW));
        xPyDict_SetItemString(x86OpcodesDict, "PMOVZXDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PMOVZXDQ));
        xPyDict_SetItemString(x86OpcodesDict, "PMOVZXWD", PyLong_FromUint32(triton::arch::x86::ID_INS_PMOVZXWD));
        xPyDict_SetItemString(x86OpcodesDict, "PMOVZXWQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PMOVZXWQ));
        xPyDict_SetItemString(x86OpcodesDict, "PMULDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PMULDQ));
        xPyDict_SetItemString(x86OpcodesDict, "PMULHRW", PyLong_FromUint32(triton::arch::x86::ID_INS_PMULHRW));
        xPyDict_SetItemString(x86OpcodesDict, "PMULLD", PyLong_FromUint32(triton::arch::x86::ID_INS_PMULLD));
        xPyDict_SetItemString(x86OpcodesDict, "POP", PyLong_FromUint32(triton::arch::x86::ID_INS_POP));
        xPyDict_SetItemString(x86OpcodesDict, "POPAW", PyLong_FromUint32(triton::arch::x86::ID_INS_POPAW));
        xPyDict_SetItemString(x86OpcodesDict, "POPAL", PyLong_FromUint32(triton::arch::x86::ID_INS_POPAL));
        xPyDict_SetItemString(x86OpcodesDict, "POPCNT", PyLong_FromUint32(triton::arch::x86::ID_INS_POPCNT));
        xPyDict_SetItemString(x86OpcodesDict, "POPF", PyLong_FromUint32(triton::arch::x86::ID_INS_POPF));
        xPyDict_SetItemString(x86OpcodesDict, "POPFD", PyLong_FromUint32(triton::arch::x86::ID_INS_POPFD));
        xPyDict_SetItemString(x86OpcodesDict, "POPFQ", PyLong_FromUint32(triton::arch::x86::ID_INS_POPFQ));
        xPyDict_SetItemString(x86OpcodesDict, "PREFETCH", PyLong_FromUint32(triton::arch::x86::ID_INS_PREFETCH));
        xPyDict_SetItemString(x86OpcodesDict, "PREFETCHNTA", PyLong_FromUint32(triton::arch::x86::ID_INS_PREFETCHNTA));
        xPyDict_SetItemString(x86OpcodesDict, "PREFETCHT0", PyLong_FromUint32(triton::arch::x86::ID_INS_PREFETCHT0));
        xPyDict_SetItemString(x86OpcodesDict, "PREFETCHT1", PyLong_FromUint32(triton::arch::x86::ID_INS_PREFETCHT1));
        xPyDict_SetItemString(x86OpcodesDict, "PREFETCHT2", PyLong_FromUint32(triton::arch::x86::ID_INS_PREFETCHT2));
        xPyDict_SetItemString(x86OpcodesDict, "PREFETCHW", PyLong_FromUint32(triton::arch::x86::ID_INS_PREFETCHW));
        xPyDict_SetItemString(x86OpcodesDict, "PSHUFD", PyLong_FromUint32(triton::arch::x86::ID_INS_PSHUFD));
        xPyDict_SetItemString(x86OpcodesDict, "PSHUFHW", PyLong_FromUint32(triton::arch::x86::ID_INS_PSHUFHW));
        xPyDict_SetItemString(x86OpcodesDict, "PSHUFLW", PyLong_FromUint32(triton::arch::x86::ID_INS_PSHUFLW));
        xPyDict_SetItemString(x86OpcodesDict, "PSLLDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PSLLDQ));
        xPyDict_SetItemString(x86OpcodesDict, "PSRLDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PSRLDQ));
        xPyDict_SetItemString(x86OpcodesDict, "PSWAPD", PyLong_FromUint32(triton::arch::x86::ID_INS_PSWAPD));
        xPyDict_SetItemString(x86OpcodesDict, "PTEST", PyLong_FromUint32(triton::arch::x86::ID_INS_PTEST));
        xPyDict_SetItemString(x86OpcodesDict, "PUNPCKHQDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PUNPCKHQDQ));
        xPyDict_SetItemString(x86OpcodesDict, "PUNPCKLQDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PUNPCKLQDQ));
        xPyDict_SetItemString(x86OpcodesDict, "PUSH", PyLong_FromUint32(triton::arch::x86::ID_INS_PUSH));
        xPyDict_SetItemString(x86OpcodesDict, "PUSHAW", PyLong_FromUint32(triton::arch::x86::ID_INS_PUSHAW));
        xPyDict_SetItemString(x86OpcodesDict, "PUSHAL", PyLong_FromUint32(triton::arch::x86::ID_INS_PUSHAL));
        xPyDict_SetItemString(x86OpcodesDict, "PUSHF", PyLong_FromUint32(triton::arch::x86::ID_INS_PUSHF));
        xPyDict_SetItemString(x86OpcodesDict, "PUSHFD", PyLong_FromUint32(triton::arch::x86::ID_INS_PUSHFD));
        xPyDict_SetItemString(x86OpcodesDict, "PUSHFQ", PyLong_FromUint32(triton::arch::x86::ID_INS_PUSHFQ));
        xPyDict_SetItemString(x86OpcodesDict, "RCL", PyLong_FromUint32(triton::arch::x86::ID_INS_RCL));
        xPyDict_SetItemString(x86OpcodesDict, "RCPPS", PyLong_FromUint32(triton::arch::x86::ID_INS_RCPPS));
        xPyDict_SetItemString(x86OpcodesDict, "RCPSS", PyLong_FromUint32(triton::arch::x86::ID_INS_RCPSS));
        xPyDict_SetItemString(x86OpcodesDict, "RCR", PyLong_FromUint32(triton::arch::x86::ID_INS_RCR));
        xPyDict_SetItemString(x86OpcodesDict, "RDFSBASE", PyLong_FromUint32(triton::arch::x86::ID_INS_RDFSBASE));
        xPyDict_SetItemString(x86OpcodesDict, "RDGSBASE", PyLong_FromUint32(triton::arch::x86::ID_INS_RDGSBASE));
        xPyDict_SetItemString(x86OpcodesDict, "RDMSR", PyLong_FromUint32(triton::arch::x86::ID_INS_RDMSR));
        xPyDict_SetItemString(x86OpcodesDict, "RDPMC", PyLong_FromUint32(triton::arch::x86::ID_INS_RDPMC));
        xPyDict_SetItemString(x86OpcodesDict, "RDRAND", PyLong_FromUint32(triton::arch::x86::ID_INS_RDRAND));
        xPyDict_SetItemString(x86OpcodesDict, "RDSEED", PyLong_FromUint32(triton::arch::x86::ID_INS_RDSEED));
        xPyDict_SetItemString(x86OpcodesDict, "RDTSC", PyLong_FromUint32(triton::arch::x86::ID_INS_RDTSC));
        xPyDict_SetItemString(x86OpcodesDict, "RDTSCP", PyLong_FromUint32(triton::arch::x86::ID_INS_RDTSCP));
        xPyDict_SetItemString(x86OpcodesDict, "ROL", PyLong_FromUint32(triton::arch::x86::ID_INS_ROL));
        xPyDict_SetItemString(x86OpcodesDict, "ROR", PyLong_FromUint32(triton::arch::x86::ID_INS_ROR));
        xPyDict_SetItemString(x86OpcodesDict, "RORX", PyLong_FromUint32(triton::arch::x86::ID_INS_RORX));
        xPyDict_SetItemString(x86OpcodesDict, "ROUNDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_ROUNDPD));
        xPyDict_SetItemString(x86OpcodesDict, "ROUNDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_ROUNDPS));
        xPyDict_SetItemString(x86OpcodesDict, "ROUNDSD", PyLong_FromUint32(triton::arch::x86::ID_INS_ROUNDSD));
        xPyDict_SetItemString(x86OpcodesDict, "ROUNDSS", PyLong_FromUint32(triton::arch::x86::ID_INS_ROUNDSS));
        xPyDict_SetItemString(x86OpcodesDict, "RSM", PyLong_FromUint32(triton::arch::x86::ID_INS_RSM));
        xPyDict_SetItemString(x86OpcodesDict, "RSQRTPS", PyLong_FromUint32(triton::arch::x86::ID_INS_RSQRTPS));
        xPyDict_SetItemString(x86OpcodesDict, "RSQRTSS", PyLong_FromUint32(triton::arch::x86::ID_INS_RSQRTSS));
        xPyDict_SetItemString(x86OpcodesDict, "SAHF", PyLong_FromUint32(triton::arch::x86::ID_INS_SAHF));
        xPyDict_SetItemString(x86OpcodesDict, "SAL", PyLong_FromUint32(triton::arch::x86::ID_INS_SAL));
        xPyDict_SetItemString(x86OpcodesDict, "SALC", PyLong_FromUint32(triton::arch::x86::ID_INS_SALC));
        xPyDict_SetItemString(x86OpcodesDict, "SAR", PyLong_FromUint32(triton::arch::x86::ID_INS_SAR));
        xPyDict_SetItemString(x86OpcodesDict, "SARX", PyLong_FromUint32(triton::arch::x86::ID_INS_SARX));
        xPyDict_SetItemString(x86OpcodesDict, "SBB", PyLong_FromUint32(triton::arch::x86::ID_INS_SBB));
        xPyDict_SetItemString(x86OpcodesDict, "SCASB", PyLong_FromUint32(triton::arch::x86::ID_INS_SCASB));
        xPyDict_SetItemString(x86OpcodesDict, "SCASD", PyLong_FromUint32(triton::arch::x86::ID_INS_SCASD));
        xPyDict_SetItemString(x86OpcodesDict, "SCASQ", PyLong_FromUint32(triton::arch::x86::ID_INS_SCASQ));
        xPyDict_SetItemString(x86OpcodesDict, "SCASW", PyLong_FromUint32(triton::arch::x86::ID_INS_SCASW));
        xPyDict_SetItemString(x86OpcodesDict, "SETAE", PyLong_FromUint32(triton::arch::x86::ID_INS_SETAE));
        xPyDict_SetItemString(x86OpcodesDict, "SETA", PyLong_FromUint32(triton::arch::x86::ID_INS_SETA));
        xPyDict_SetItemString(x86OpcodesDict, "SETBE", PyLong_FromUint32(triton::arch::x86::ID_INS_SETBE));
        xPyDict_SetItemString(x86OpcodesDict, "SETB", PyLong_FromUint32(triton::arch::x86::ID_INS_SETB));
        xPyDict_SetItemString(x86OpcodesDict, "SETE", PyLong_FromUint32(triton::arch::x86::ID_INS_SETE));
        xPyDict_SetItemString(x86OpcodesDict, "SETGE", PyLong_FromUint32(triton::arch::x86::ID_INS_SETGE));
        xPyDict_SetItemString(x86OpcodesDict, "SETG", PyLong_FromUint32(triton::arch::x86::ID_INS_SETG));
        xPyDict_SetItemString(x86OpcodesDict, "SETLE", PyLong_FromUint32(triton::arch::x86::ID_INS_SETLE));
        xPyDict_SetItemString(x86OpcodesDict, "SETL", PyLong_FromUint32(triton::arch::x86::ID_INS_SETL));
        xPyDict_SetItemString(x86OpcodesDict, "SETNE", PyLong_FromUint32(triton::arch::x86::ID_INS_SETNE));
        xPyDict_SetItemString(x86OpcodesDict, "SETNO", PyLong_FromUint32(triton::arch::x86::ID_INS_SETNO));
        xPyDict_SetItemString(x86OpcodesDict, "SETNP", PyLong_FromUint32(triton::arch::x86::ID_INS_SETNP));
        xPyDict_SetItemString(x86OpcodesDict, "SETNS", PyLong_FromUint32(triton::arch::x86::ID_INS_SETNS));
        xPyDict_SetItemString(x86OpcodesDict, "SETO", PyLong_FromUint32(triton::arch::x86::ID_INS_SETO));
        xPyDict_SetItemString(x86OpcodesDict, "SETP", PyLong_FromUint32(triton::arch::x86::ID_INS_SETP));
        xPyDict_SetItemString(x86OpcodesDict, "SETS", PyLong_FromUint32(triton::arch::x86::ID_INS_SETS));
        xPyDict_SetItemString(x86OpcodesDict, "SFENCE", PyLong_FromUint32(triton::arch::x86::ID_INS_SFENCE));
        xPyDict_SetItemString(x86OpcodesDict, "SGDT", PyLong_FromUint32(triton::arch::x86::ID_INS_SGDT));
        xPyDict_SetItemString(x86OpcodesDict, "SHA1MSG1", PyLong_FromUint32(triton::arch::x86::ID_INS_SHA1MSG1));
        xPyDict_SetItemString(x86OpcodesDict, "SHA1MSG2", PyLong_FromUint32(triton::arch::x86::ID_INS_SHA1MSG2));
        xPyDict_SetItemString(x86OpcodesDict, "SHA1NEXTE", PyLong_FromUint32(triton::arch::x86::ID_INS_SHA1NEXTE));
        xPyDict_SetItemString(x86OpcodesDict, "SHA1RNDS4", PyLong_FromUint32(triton::arch::x86::ID_INS_SHA1RNDS4));
        xPyDict_SetItemString(x86OpcodesDict, "SHA256MSG1", PyLong_FromUint32(triton::arch::x86::ID_INS_SHA256MSG1));
        xPyDict_SetItemString(x86OpcodesDict, "SHA256MSG2", PyLong_FromUint32(triton::arch::x86::ID_INS_SHA256MSG2));
        xPyDict_SetItemString(x86OpcodesDict, "SHA256RNDS2", PyLong_FromUint32(triton::arch::x86::ID_INS_SHA256RNDS2));
        xPyDict_SetItemString(x86OpcodesDict, "SHL", PyLong_FromUint32(triton::arch::x86::ID_INS_SHL));
        xPyDict_SetItemString(x86OpcodesDict, "SHLD", PyLong_FromUint32(triton::arch::x86::ID_INS_SHLD));
        xPyDict_SetItemString(x86OpcodesDict, "SHLX", PyLong_FromUint32(triton::arch::x86::ID_INS_SHLX));
        xPyDict_SetItemString(x86OpcodesDict, "SHR", PyLong_FromUint32(triton::arch::x86::ID_INS_SHR));
        xPyDict_SetItemString(x86OpcodesDict, "SHRD", PyLong_FromUint32(triton::arch::x86::ID_INS_SHRD));
        xPyDict_SetItemString(x86OpcodesDict, "SHRX", PyLong_FromUint32(triton::arch::x86::ID_INS_SHRX));
        xPyDict_SetItemString(x86OpcodesDict, "SHUFPD", PyLong_FromUint32(triton::arch::x86::ID_INS_SHUFPD));
        xPyDict_SetItemString(x86OpcodesDict, "SHUFPS", PyLong_FromUint32(triton::arch::x86::ID_INS_SHUFPS));
        xPyDict_SetItemString(x86OpcodesDict, "SIDT", PyLong_FromUint32(triton::arch::x86::ID_INS_SIDT));
        xPyDict_SetItemString(x86OpcodesDict, "FSIN", PyLong_FromUint32(triton::arch::x86::ID_INS_FSIN));
        xPyDict_SetItemString(x86OpcodesDict, "SKINIT", PyLong_FromUint32(triton::arch::x86::ID_INS_SKINIT));
        xPyDict_SetItemString(x86OpcodesDict, "SLDT", PyLong_FromUint32(triton::arch::x86::ID_INS_SLDT));
        xPyDict_SetItemString(x86OpcodesDict, "SMSW", PyLong_FromUint32(triton::arch::x86::ID_INS_SMSW));
        xPyDict_SetItemString(x86OpcodesDict, "SQRTPD", PyLong_FromUint32(triton::arch::x86::ID_INS_SQRTPD));
        xPyDict_SetItemString(x86OpcodesDict, "SQRTPS", PyLong_FromUint32(triton::arch::x86::ID_INS_SQRTPS));
        xPyDict_SetItemString(x86OpcodesDict, "SQRTSD", PyLong_FromUint32(triton::arch::x86::ID_INS_SQRTSD));
        xPyDict_SetItemString(x86OpcodesDict, "SQRTSS", PyLong_FromUint32(triton::arch::x86::ID_INS_SQRTSS));
        xPyDict_SetItemString(x86OpcodesDict, "FSQRT", PyLong_FromUint32(triton::arch::x86::ID_INS_FSQRT));
        xPyDict_SetItemString(x86OpcodesDict, "STAC", PyLong_FromUint32(triton::arch::x86::ID_INS_STAC));
        xPyDict_SetItemString(x86OpcodesDict, "STC", PyLong_FromUint32(triton::arch::x86::ID_INS_STC));
        xPyDict_SetItemString(x86OpcodesDict, "STD", PyLong_FromUint32(triton::arch::x86::ID_INS_STD));
        xPyDict_SetItemString(x86OpcodesDict, "STGI", PyLong_FromUint32(triton::arch::x86::ID_INS_STGI));
        xPyDict_SetItemString(x86OpcodesDict, "STI", PyLong_FromUint32(triton::arch::x86::ID_INS_STI));
        xPyDict_SetItemString(x86OpcodesDict, "STMXCSR", PyLong_FromUint32(triton::arch::x86::ID_INS_STMXCSR));
        xPyDict_SetItemString(x86OpcodesDict, "STOSB", PyLong_FromUint32(triton::arch::x86::ID_INS_STOSB));
        xPyDict_SetItemString(x86OpcodesDict, "STOSD", PyLong_FromUint32(triton::arch::x86::ID_INS_STOSD));
        xPyDict_SetItemString(x86OpcodesDict, "STOSQ", PyLong_FromUint32(triton::arch::x86::ID_INS_STOSQ));
        xPyDict_SetItemString(x86OpcodesDict, "STOSW", PyLong_FromUint32(triton::arch::x86::ID_INS_STOSW));
        xPyDict_SetItemString(x86OpcodesDict, "STR", PyLong_FromUint32(triton::arch::x86::ID_INS_STR));
        xPyDict_SetItemString(x86OpcodesDict, "FST", PyLong_FromUint32(triton::arch::x86::ID_INS_FST));
        xPyDict_SetItemString(x86OpcodesDict, "FSTP", PyLong_FromUint32(triton::arch::x86::ID_INS_FSTP));
        xPyDict_SetItemString(x86OpcodesDict, "FSTPNCE", PyLong_FromUint32(triton::arch::x86::ID_INS_FSTPNCE));
        xPyDict_SetItemString(x86OpcodesDict, "SUBPD", PyLong_FromUint32(triton::arch::x86::ID_INS_SUBPD));
        xPyDict_SetItemString(x86OpcodesDict, "SUBPS", PyLong_FromUint32(triton::arch::x86::ID_INS_SUBPS));
        xPyDict_SetItemString(x86OpcodesDict, "FSUBR", PyLong_FromUint32(triton::arch::x86::ID_INS_FSUBR));
        xPyDict_SetItemString(x86OpcodesDict, "FISUBR", PyLong_FromUint32(triton::arch::x86::ID_INS_FISUBR));
        xPyDict_SetItemString(x86OpcodesDict, "FSUBRP", PyLong_FromUint32(triton::arch::x86::ID_INS_FSUBRP));
        xPyDict_SetItemString(x86OpcodesDict, "SUBSD", PyLong_FromUint32(triton::arch::x86::ID_INS_SUBSD));
        xPyDict_SetItemString(x86OpcodesDict, "SUBSS", PyLong_FromUint32(triton::arch::x86::ID_INS_SUBSS));
        xPyDict_SetItemString(x86OpcodesDict, "FSUB", PyLong_FromUint32(triton::arch::x86::ID_INS_FSUB));
        xPyDict_SetItemString(x86OpcodesDict, "FISUB", PyLong_FromUint32(triton::arch::x86::ID_INS_FISUB));
        xPyDict_SetItemString(x86OpcodesDict, "FSUBP", PyLong_FromUint32(triton::arch::x86::ID_INS_FSUBP));
        xPyDict_SetItemString(x86OpcodesDict, "SWAPGS", PyLong_FromUint32(triton::arch::x86::ID_INS_SWAPGS));
        xPyDict_SetItemString(x86OpcodesDict, "SYSCALL", PyLong_FromUint32(triton::arch::x86::ID_INS_SYSCALL));
        xPyDict_SetItemString(x86OpcodesDict, "SYSENTER", PyLong_FromUint32(triton::arch::x86::ID_INS_SYSENTER));
        xPyDict_SetItemString(x86OpcodesDict, "SYSEXIT", PyLong_FromUint32(triton::arch::x86::ID_INS_SYSEXIT));
        xPyDict_SetItemString(x86OpcodesDict, "SYSRET", PyLong_FromUint32(triton::arch::x86::ID_INS_SYSRET));
        xPyDict_SetItemString(x86OpcodesDict, "T1MSKC", PyLong_FromUint32(triton::arch::x86::ID_INS_T1MSKC));
        xPyDict_SetItemString(x86OpcodesDict, "TEST", PyLong_FromUint32(triton::arch::x86::ID_INS_TEST));
        xPyDict_SetItemString(x86OpcodesDict, "UD2", PyLong_FromUint32(triton::arch::x86::ID_INS_UD2));
        xPyDict_SetItemString(x86OpcodesDict, "FTST", PyLong_FromUint32(triton::arch::x86::ID_INS_FTST));
        xPyDict_SetItemString(x86OpcodesDict, "TZCNT", PyLong_FromUint32(triton::arch::x86::ID_INS_TZCNT));
        xPyDict_SetItemString(x86OpcodesDict, "TZMSK", PyLong_FromUint32(triton::arch::x86::ID_INS_TZMSK));
        xPyDict_SetItemString(x86OpcodesDict, "FUCOMPI", PyLong_FromUint32(triton::arch::x86::ID_INS_FUCOMPI));
        xPyDict_SetItemString(x86OpcodesDict, "FUCOMI", PyLong_FromUint32(triton::arch::x86::ID_INS_FUCOMI));
        xPyDict_SetItemString(x86OpcodesDict, "FUCOMPP", PyLong_FromUint32(triton::arch::x86::ID_INS_FUCOMPP));
        xPyDict_SetItemString(x86OpcodesDict, "FUCOMP", PyLong_FromUint32(triton::arch::x86::ID_INS_FUCOMP));
        xPyDict_SetItemString(x86OpcodesDict, "FUCOM", PyLong_FromUint32(triton::arch::x86::ID_INS_FUCOM));
        xPyDict_SetItemString(x86OpcodesDict, "UD2B", PyLong_FromUint32(triton::arch::x86::ID_INS_UD2B));
        xPyDict_SetItemString(x86OpcodesDict, "UNPCKHPD", PyLong_FromUint32(triton::arch::x86::ID_INS_UNPCKHPD));
        xPyDict_SetItemString(x86OpcodesDict, "UNPCKHPS", PyLong_FromUint32(triton::arch::x86::ID_INS_UNPCKHPS));
        xPyDict_SetItemString(x86OpcodesDict, "UNPCKLPD", PyLong_FromUint32(triton::arch::x86::ID_INS_UNPCKLPD));
        xPyDict_SetItemString(x86OpcodesDict, "UNPCKLPS", PyLong_FromUint32(triton::arch::x86::ID_INS_UNPCKLPS));
        xPyDict_SetItemString(x86OpcodesDict, "VADDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VADDPD));
        xPyDict_SetItemString(x86OpcodesDict, "VADDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VADDPS));
        xPyDict_SetItemString(x86OpcodesDict, "VADDSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VADDSD));
        xPyDict_SetItemString(x86OpcodesDict, "VADDSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VADDSS));
        xPyDict_SetItemString(x86OpcodesDict, "VADDSUBPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VADDSUBPD));
        xPyDict_SetItemString(x86OpcodesDict, "VADDSUBPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VADDSUBPS));
        xPyDict_SetItemString(x86OpcodesDict, "VAESDECLAST", PyLong_FromUint32(triton::arch::x86::ID_INS_VAESDECLAST));
        xPyDict_SetItemString(x86OpcodesDict, "VAESDEC", PyLong_FromUint32(triton::arch::x86::ID_INS_VAESDEC));
        xPyDict_SetItemString(x86OpcodesDict, "VAESENCLAST", PyLong_FromUint32(triton::arch::x86::ID_INS_VAESENCLAST));
        xPyDict_SetItemString(x86OpcodesDict, "VAESENC", PyLong_FromUint32(triton::arch::x86::ID_INS_VAESENC));
        xPyDict_SetItemString(x86OpcodesDict, "VAESIMC", PyLong_FromUint32(triton::arch::x86::ID_INS_VAESIMC));
        xPyDict_SetItemString(x86OpcodesDict, "VAESKEYGENASSIST", PyLong_FromUint32(triton::arch::x86::ID_INS_VAESKEYGENASSIST));
        xPyDict_SetItemString(x86OpcodesDict, "VALIGND", PyLong_FromUint32(triton::arch::x86::ID_INS_VALIGND));
        xPyDict_SetItemString(x86OpcodesDict, "VALIGNQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VALIGNQ));
        xPyDict_SetItemString(x86OpcodesDict, "VANDNPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VANDNPD));
        xPyDict_SetItemString(x86OpcodesDict, "VANDNPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VANDNPS));
        xPyDict_SetItemString(x86OpcodesDict, "VANDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VANDPD));
        xPyDict_SetItemString(x86OpcodesDict, "VANDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VANDPS));
        xPyDict_SetItemString(x86OpcodesDict, "VBLENDMPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VBLENDMPD));
        xPyDict_SetItemString(x86OpcodesDict, "VBLENDMPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VBLENDMPS));
        xPyDict_SetItemString(x86OpcodesDict, "VBLENDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VBLENDPD));
        xPyDict_SetItemString(x86OpcodesDict, "VBLENDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VBLENDPS));
        xPyDict_SetItemString(x86OpcodesDict, "VBLENDVPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VBLENDVPD));
        xPyDict_SetItemString(x86OpcodesDict, "VBLENDVPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VBLENDVPS));
        xPyDict_SetItemString(x86OpcodesDict, "VBROADCASTF128", PyLong_FromUint32(triton::arch::x86::ID_INS_VBROADCASTF128));
        xPyDict_SetItemString(x86OpcodesDict, "VBROADCASTI128", PyLong_FromUint32(triton::arch::x86::ID_INS_VBROADCASTI128));
        xPyDict_SetItemString(x86OpcodesDict, "VBROADCASTI32X4", PyLong_FromUint32(triton::arch::x86::ID_INS_VBROADCASTI32X4));
        xPyDict_SetItemString(x86OpcodesDict, "VBROADCASTI64X4", PyLong_FromUint32(triton::arch::x86::ID_INS_VBROADCASTI64X4));
        xPyDict_SetItemString(x86OpcodesDict, "VBROADCASTSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VBROADCASTSD));
        xPyDict_SetItemString(x86OpcodesDict, "VBROADCASTSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VBROADCASTSS));
        xPyDict_SetItemString(x86OpcodesDict, "VCMPPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VCMPPD));
        xPyDict_SetItemString(x86OpcodesDict, "VCMPPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VCMPPS));
        xPyDict_SetItemString(x86OpcodesDict, "VCMPSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VCMPSD));
        xPyDict_SetItemString(x86OpcodesDict, "VCMPSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VCMPSS));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTDQ2PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTDQ2PD));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTDQ2PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTDQ2PS));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTPD2DQX", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTPD2DQX));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTPD2DQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTPD2DQ));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTPD2PSX", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTPD2PSX));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTPD2PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTPD2PS));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTPD2UDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTPD2UDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTPH2PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTPH2PS));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTPS2DQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTPS2DQ));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTPS2PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTPS2PD));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTPS2PH", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTPS2PH));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTPS2UDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTPS2UDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTSD2SI", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTSD2SI));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTSD2USI", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTSD2USI));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTSS2SI", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTSS2SI));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTSS2USI", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTSS2USI));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTTPD2DQX", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTTPD2DQX));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTTPD2DQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTTPD2DQ));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTTPD2UDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTTPD2UDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTTPS2DQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTTPS2DQ));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTTPS2UDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTTPS2UDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTUDQ2PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTUDQ2PD));
        xPyDict_SetItemString(x86OpcodesDict, "VCVTUDQ2PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VCVTUDQ2PS));
        xPyDict_SetItemString(x86OpcodesDict, "VDIVPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VDIVPD));
        xPyDict_SetItemString(x86OpcodesDict, "VDIVPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VDIVPS));
        xPyDict_SetItemString(x86OpcodesDict, "VDIVSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VDIVSD));
        xPyDict_SetItemString(x86OpcodesDict, "VDIVSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VDIVSS));
        xPyDict_SetItemString(x86OpcodesDict, "VDPPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VDPPD));
        xPyDict_SetItemString(x86OpcodesDict, "VDPPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VDPPS));
        xPyDict_SetItemString(x86OpcodesDict, "VERR", PyLong_FromUint32(triton::arch::x86::ID_INS_VERR));
        xPyDict_SetItemString(x86OpcodesDict, "VERW", PyLong_FromUint32(triton::arch::x86::ID_INS_VERW));
        xPyDict_SetItemString(x86OpcodesDict, "VEXTRACTF128", PyLong_FromUint32(triton::arch::x86::ID_INS_VEXTRACTF128));
        xPyDict_SetItemString(x86OpcodesDict, "VEXTRACTF32X4", PyLong_FromUint32(triton::arch::x86::ID_INS_VEXTRACTF32X4));
        xPyDict_SetItemString(x86OpcodesDict, "VEXTRACTF64X4", PyLong_FromUint32(triton::arch::x86::ID_INS_VEXTRACTF64X4));
        xPyDict_SetItemString(x86OpcodesDict, "VEXTRACTI128", PyLong_FromUint32(triton::arch::x86::ID_INS_VEXTRACTI128));
        xPyDict_SetItemString(x86OpcodesDict, "VEXTRACTI32X4", PyLong_FromUint32(triton::arch::x86::ID_INS_VEXTRACTI32X4));
        xPyDict_SetItemString(x86OpcodesDict, "VEXTRACTI64X4", PyLong_FromUint32(triton::arch::x86::ID_INS_VEXTRACTI64X4));
        xPyDict_SetItemString(x86OpcodesDict, "VEXTRACTPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VEXTRACTPS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADD132PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADD132PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADD132PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADD132PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADD213PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADD213PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADD213PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADD213PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADDPD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADD231PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADD231PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADDPS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADD231PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADD231PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADDSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADDSD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADD213SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADD213SD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADD132SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADD132SD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADD231SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADD231SD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADDSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADDSS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADD213SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADD213SS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADD132SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADD132SS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADD231SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADD231SS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADDSUB132PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADDSUB132PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADDSUB132PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADDSUB132PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADDSUB213PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADDSUB213PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADDSUB213PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADDSUB213PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADDSUBPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADDSUBPD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADDSUB231PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADDSUB231PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADDSUBPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADDSUBPS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMADDSUB231PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMADDSUB231PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUB132PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUB132PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUB132PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUB132PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUB213PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUB213PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUB213PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUB213PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUBADD132PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUBADD132PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUBADD132PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUBADD132PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUBADD213PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUBADD213PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUBADD213PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUBADD213PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUBADDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUBADDPD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUBADD231PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUBADD231PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUBADDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUBADDPS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUBADD231PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUBADD231PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUBPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUBPD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUB231PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUB231PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUBPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUBPS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUB231PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUB231PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUBSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUBSD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUB213SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUB213SD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUB132SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUB132SD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUB231SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUB231SD));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUBSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUBSS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUB213SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUB213SS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUB132SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUB132SS));
        xPyDict_SetItemString(x86OpcodesDict, "VFMSUB231SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFMSUB231SS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADD132PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADD132PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADD132PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADD132PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADD213PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADD213PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADD213PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADD213PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADDPD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADD231PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADD231PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADDPS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADD231PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADD231PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADDSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADDSD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADD213SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADD213SD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADD132SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADD132SD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADD231SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADD231SD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADDSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADDSS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADD213SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADD213SS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADD132SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADD132SS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMADD231SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMADD231SS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUB132PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUB132PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUB132PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUB132PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUB213PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUB213PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUB213PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUB213PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUBPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUBPD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUB231PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUB231PD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUBPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUBPS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUB231PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUB231PS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUBSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUBSD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUB213SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUB213SD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUB132SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUB132SD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUB231SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUB231SD));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUBSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUBSS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUB213SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUB213SS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUB132SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUB132SS));
        xPyDict_SetItemString(x86OpcodesDict, "VFNMSUB231SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFNMSUB231SS));
        xPyDict_SetItemString(x86OpcodesDict, "VFRCZPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFRCZPD));
        xPyDict_SetItemString(x86OpcodesDict, "VFRCZPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFRCZPS));
        xPyDict_SetItemString(x86OpcodesDict, "VFRCZSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VFRCZSD));
        xPyDict_SetItemString(x86OpcodesDict, "VFRCZSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VFRCZSS));
        xPyDict_SetItemString(x86OpcodesDict, "VORPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VORPD));
        xPyDict_SetItemString(x86OpcodesDict, "VORPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VORPS));
        xPyDict_SetItemString(x86OpcodesDict, "VXORPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VXORPD));
        xPyDict_SetItemString(x86OpcodesDict, "VXORPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VXORPS));
        xPyDict_SetItemString(x86OpcodesDict, "VGATHERDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VGATHERDPD));
        xPyDict_SetItemString(x86OpcodesDict, "VGATHERDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VGATHERDPS));
        xPyDict_SetItemString(x86OpcodesDict, "VGATHERPF0DPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VGATHERPF0DPD));
        xPyDict_SetItemString(x86OpcodesDict, "VGATHERPF0DPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VGATHERPF0DPS));
        xPyDict_SetItemString(x86OpcodesDict, "VGATHERPF0QPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VGATHERPF0QPD));
        xPyDict_SetItemString(x86OpcodesDict, "VGATHERPF0QPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VGATHERPF0QPS));
        xPyDict_SetItemString(x86OpcodesDict, "VGATHERPF1DPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VGATHERPF1DPD));
        xPyDict_SetItemString(x86OpcodesDict, "VGATHERPF1DPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VGATHERPF1DPS));
        xPyDict_SetItemString(x86OpcodesDict, "VGATHERPF1QPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VGATHERPF1QPD));
        xPyDict_SetItemString(x86OpcodesDict, "VGATHERPF1QPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VGATHERPF1QPS));
        xPyDict_SetItemString(x86OpcodesDict, "VGATHERQPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VGATHERQPD));
        xPyDict_SetItemString(x86OpcodesDict, "VGATHERQPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VGATHERQPS));
        xPyDict_SetItemString(x86OpcodesDict, "VHADDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VHADDPD));
        xPyDict_SetItemString(x86OpcodesDict, "VHADDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VHADDPS));
        xPyDict_SetItemString(x86OpcodesDict, "VHSUBPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VHSUBPD));
        xPyDict_SetItemString(x86OpcodesDict, "VHSUBPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VHSUBPS));
        xPyDict_SetItemString(x86OpcodesDict, "VINSERTF128", PyLong_FromUint32(triton::arch::x86::ID_INS_VINSERTF128));
        xPyDict_SetItemString(x86OpcodesDict, "VINSERTF32X4", PyLong_FromUint32(triton::arch::x86::ID_INS_VINSERTF32X4));
        xPyDict_SetItemString(x86OpcodesDict, "VINSERTF64X4", PyLong_FromUint32(triton::arch::x86::ID_INS_VINSERTF64X4));
        xPyDict_SetItemString(x86OpcodesDict, "VINSERTI128", PyLong_FromUint32(triton::arch::x86::ID_INS_VINSERTI128));
        xPyDict_SetItemString(x86OpcodesDict, "VINSERTI32X4", PyLong_FromUint32(triton::arch::x86::ID_INS_VINSERTI32X4));
        xPyDict_SetItemString(x86OpcodesDict, "VINSERTI64X4", PyLong_FromUint32(triton::arch::x86::ID_INS_VINSERTI64X4));
        xPyDict_SetItemString(x86OpcodesDict, "VINSERTPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VINSERTPS));
        xPyDict_SetItemString(x86OpcodesDict, "VLDDQU", PyLong_FromUint32(triton::arch::x86::ID_INS_VLDDQU));
        xPyDict_SetItemString(x86OpcodesDict, "VLDMXCSR", PyLong_FromUint32(triton::arch::x86::ID_INS_VLDMXCSR));
        xPyDict_SetItemString(x86OpcodesDict, "VMASKMOVDQU", PyLong_FromUint32(triton::arch::x86::ID_INS_VMASKMOVDQU));
        xPyDict_SetItemString(x86OpcodesDict, "VMASKMOVPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMASKMOVPD));
        xPyDict_SetItemString(x86OpcodesDict, "VMASKMOVPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMASKMOVPS));
        xPyDict_SetItemString(x86OpcodesDict, "VMAXPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMAXPD));
        xPyDict_SetItemString(x86OpcodesDict, "VMAXPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMAXPS));
        xPyDict_SetItemString(x86OpcodesDict, "VMAXSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMAXSD));
        xPyDict_SetItemString(x86OpcodesDict, "VMAXSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMAXSS));
        xPyDict_SetItemString(x86OpcodesDict, "VMCALL", PyLong_FromUint32(triton::arch::x86::ID_INS_VMCALL));
        xPyDict_SetItemString(x86OpcodesDict, "VMCLEAR", PyLong_FromUint32(triton::arch::x86::ID_INS_VMCLEAR));
        xPyDict_SetItemString(x86OpcodesDict, "VMFUNC", PyLong_FromUint32(triton::arch::x86::ID_INS_VMFUNC));
        xPyDict_SetItemString(x86OpcodesDict, "VMINPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMINPD));
        xPyDict_SetItemString(x86OpcodesDict, "VMINPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMINPS));
        xPyDict_SetItemString(x86OpcodesDict, "VMINSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMINSD));
        xPyDict_SetItemString(x86OpcodesDict, "VMINSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMINSS));
        xPyDict_SetItemString(x86OpcodesDict, "VMLAUNCH", PyLong_FromUint32(triton::arch::x86::ID_INS_VMLAUNCH));
        xPyDict_SetItemString(x86OpcodesDict, "VMLOAD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMLOAD));
        xPyDict_SetItemString(x86OpcodesDict, "VMMCALL", PyLong_FromUint32(triton::arch::x86::ID_INS_VMMCALL));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVQ));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVDDUP", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVDDUP));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVD));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVDQA32", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVDQA32));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVDQA64", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVDQA64));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVDQA", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVDQA));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVDQU16", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVDQU16));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVDQU32", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVDQU32));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVDQU64", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVDQU64));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVDQU8", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVDQU8));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVDQU", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVDQU));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVHLPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVHLPS));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVHPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVHPD));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVHPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVHPS));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVLHPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVLHPS));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVLPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVLPD));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVLPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVLPS));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVMSKPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVMSKPD));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVMSKPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVMSKPS));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVNTDQA", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVNTDQA));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVNTDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVNTDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVNTPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVNTPD));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVNTPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVNTPS));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVSD));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVSHDUP", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVSHDUP));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVSLDUP", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVSLDUP));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVSS));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVUPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVUPD));
        xPyDict_SetItemString(x86OpcodesDict, "VMOVUPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMOVUPS));
        xPyDict_SetItemString(x86OpcodesDict, "VMPSADBW", PyLong_FromUint32(triton::arch::x86::ID_INS_VMPSADBW));
        xPyDict_SetItemString(x86OpcodesDict, "VMPTRLD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMPTRLD));
        xPyDict_SetItemString(x86OpcodesDict, "VMPTRST", PyLong_FromUint32(triton::arch::x86::ID_INS_VMPTRST));
        xPyDict_SetItemString(x86OpcodesDict, "VMREAD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMREAD));
        xPyDict_SetItemString(x86OpcodesDict, "VMRESUME", PyLong_FromUint32(triton::arch::x86::ID_INS_VMRESUME));
        xPyDict_SetItemString(x86OpcodesDict, "VMRUN", PyLong_FromUint32(triton::arch::x86::ID_INS_VMRUN));
        xPyDict_SetItemString(x86OpcodesDict, "VMSAVE", PyLong_FromUint32(triton::arch::x86::ID_INS_VMSAVE));
        xPyDict_SetItemString(x86OpcodesDict, "VMULPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMULPD));
        xPyDict_SetItemString(x86OpcodesDict, "VMULPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMULPS));
        xPyDict_SetItemString(x86OpcodesDict, "VMULSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VMULSD));
        xPyDict_SetItemString(x86OpcodesDict, "VMULSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VMULSS));
        xPyDict_SetItemString(x86OpcodesDict, "VMWRITE", PyLong_FromUint32(triton::arch::x86::ID_INS_VMWRITE));
        xPyDict_SetItemString(x86OpcodesDict, "VMXOFF", PyLong_FromUint32(triton::arch::x86::ID_INS_VMXOFF));
        xPyDict_SetItemString(x86OpcodesDict, "VMXON", PyLong_FromUint32(triton::arch::x86::ID_INS_VMXON));
        xPyDict_SetItemString(x86OpcodesDict, "VPABSB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPABSB));
        xPyDict_SetItemString(x86OpcodesDict, "VPABSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPABSD));
        xPyDict_SetItemString(x86OpcodesDict, "VPABSQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPABSQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPABSW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPABSW));
        xPyDict_SetItemString(x86OpcodesDict, "VPACKSSDW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPACKSSDW));
        xPyDict_SetItemString(x86OpcodesDict, "VPACKSSWB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPACKSSWB));
        xPyDict_SetItemString(x86OpcodesDict, "VPACKUSDW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPACKUSDW));
        xPyDict_SetItemString(x86OpcodesDict, "VPACKUSWB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPACKUSWB));
        xPyDict_SetItemString(x86OpcodesDict, "VPADDB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPADDB));
        xPyDict_SetItemString(x86OpcodesDict, "VPADDD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPADDD));
        xPyDict_SetItemString(x86OpcodesDict, "VPADDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPADDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPADDSB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPADDSB));
        xPyDict_SetItemString(x86OpcodesDict, "VPADDSW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPADDSW));
        xPyDict_SetItemString(x86OpcodesDict, "VPADDUSB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPADDUSB));
        xPyDict_SetItemString(x86OpcodesDict, "VPADDUSW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPADDUSW));
        xPyDict_SetItemString(x86OpcodesDict, "VPADDW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPADDW));
        xPyDict_SetItemString(x86OpcodesDict, "VPALIGNR", PyLong_FromUint32(triton::arch::x86::ID_INS_VPALIGNR));
        xPyDict_SetItemString(x86OpcodesDict, "VPANDD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPANDD));
        xPyDict_SetItemString(x86OpcodesDict, "VPANDND", PyLong_FromUint32(triton::arch::x86::ID_INS_VPANDND));
        xPyDict_SetItemString(x86OpcodesDict, "VPANDNQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPANDNQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPANDN", PyLong_FromUint32(triton::arch::x86::ID_INS_VPANDN));
        xPyDict_SetItemString(x86OpcodesDict, "VPANDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPANDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPAND", PyLong_FromUint32(triton::arch::x86::ID_INS_VPAND));
        xPyDict_SetItemString(x86OpcodesDict, "VPAVGB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPAVGB));
        xPyDict_SetItemString(x86OpcodesDict, "VPAVGW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPAVGW));
        xPyDict_SetItemString(x86OpcodesDict, "VPBLENDD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPBLENDD));
        xPyDict_SetItemString(x86OpcodesDict, "VPBLENDMD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPBLENDMD));
        xPyDict_SetItemString(x86OpcodesDict, "VPBLENDMQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPBLENDMQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPBLENDVB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPBLENDVB));
        xPyDict_SetItemString(x86OpcodesDict, "VPBLENDW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPBLENDW));
        xPyDict_SetItemString(x86OpcodesDict, "VPBROADCASTB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPBROADCASTB));
        xPyDict_SetItemString(x86OpcodesDict, "VPBROADCASTD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPBROADCASTD));
        xPyDict_SetItemString(x86OpcodesDict, "VPBROADCASTMB2Q", PyLong_FromUint32(triton::arch::x86::ID_INS_VPBROADCASTMB2Q));
        xPyDict_SetItemString(x86OpcodesDict, "VPBROADCASTMW2D", PyLong_FromUint32(triton::arch::x86::ID_INS_VPBROADCASTMW2D));
        xPyDict_SetItemString(x86OpcodesDict, "VPBROADCASTQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPBROADCASTQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPBROADCASTW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPBROADCASTW));
        xPyDict_SetItemString(x86OpcodesDict, "VPCLMULQDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCLMULQDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMOV", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMOV));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMP", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMP));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPD));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPEQB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPEQB));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPEQD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPEQD));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPEQQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPEQQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPEQW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPEQW));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPESTRI", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPESTRI));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPESTRM", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPESTRM));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPGTB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPGTB));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPGTD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPGTD));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPGTQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPGTQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPGTW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPGTW));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPISTRI", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPISTRI));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPISTRM", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPISTRM));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPUD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPUD));
        xPyDict_SetItemString(x86OpcodesDict, "VPCMPUQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCMPUQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPCOMB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCOMB));
        xPyDict_SetItemString(x86OpcodesDict, "VPCOMD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCOMD));
        xPyDict_SetItemString(x86OpcodesDict, "VPCOMQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCOMQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPCOMUB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCOMUB));
        xPyDict_SetItemString(x86OpcodesDict, "VPCOMUD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCOMUD));
        xPyDict_SetItemString(x86OpcodesDict, "VPCOMUQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCOMUQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPCOMUW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCOMUW));
        xPyDict_SetItemString(x86OpcodesDict, "VPCOMW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCOMW));
        xPyDict_SetItemString(x86OpcodesDict, "VPCONFLICTD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCONFLICTD));
        xPyDict_SetItemString(x86OpcodesDict, "VPCONFLICTQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPCONFLICTQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPERM2F128", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERM2F128));
        xPyDict_SetItemString(x86OpcodesDict, "VPERM2I128", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERM2I128));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMD));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMI2D", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMI2D));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMI2PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMI2PD));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMI2PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMI2PS));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMI2Q", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMI2Q));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMIL2PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMIL2PD));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMIL2PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMIL2PS));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMILPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMILPD));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMILPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMILPS));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMPD));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMPS));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMT2D", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMT2D));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMT2PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMT2PD));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMT2PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMT2PS));
        xPyDict_SetItemString(x86OpcodesDict, "VPERMT2Q", PyLong_FromUint32(triton::arch::x86::ID_INS_VPERMT2Q));
        xPyDict_SetItemString(x86OpcodesDict, "VPEXTRB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPEXTRB));
        xPyDict_SetItemString(x86OpcodesDict, "VPEXTRD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPEXTRD));
        xPyDict_SetItemString(x86OpcodesDict, "VPEXTRQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPEXTRQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPEXTRW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPEXTRW));
        xPyDict_SetItemString(x86OpcodesDict, "VPGATHERDD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPGATHERDD));
        xPyDict_SetItemString(x86OpcodesDict, "VPGATHERDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPGATHERDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPGATHERQD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPGATHERQD));
        xPyDict_SetItemString(x86OpcodesDict, "VPGATHERQQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPGATHERQQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDBD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDBD));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDBQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDBQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDBW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDBW));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDD));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDSW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDSW));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDUBD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDUBD));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDUBQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDUBQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDUBW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDUBW));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDUDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDUDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDUWD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDUWD));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDUWQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDUWQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDWD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDWD));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDWQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDWQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPHADDW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHADDW));
        xPyDict_SetItemString(x86OpcodesDict, "VPHMINPOSUW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHMINPOSUW));
        xPyDict_SetItemString(x86OpcodesDict, "VPHSUBBW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHSUBBW));
        xPyDict_SetItemString(x86OpcodesDict, "VPHSUBDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHSUBDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPHSUBD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHSUBD));
        xPyDict_SetItemString(x86OpcodesDict, "VPHSUBSW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHSUBSW));
        xPyDict_SetItemString(x86OpcodesDict, "VPHSUBWD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHSUBWD));
        xPyDict_SetItemString(x86OpcodesDict, "VPHSUBW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPHSUBW));
        xPyDict_SetItemString(x86OpcodesDict, "VPINSRB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPINSRB));
        xPyDict_SetItemString(x86OpcodesDict, "VPINSRD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPINSRD));
        xPyDict_SetItemString(x86OpcodesDict, "VPINSRQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPINSRQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPINSRW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPINSRW));
        xPyDict_SetItemString(x86OpcodesDict, "VPLZCNTD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPLZCNTD));
        xPyDict_SetItemString(x86OpcodesDict, "VPLZCNTQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPLZCNTQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPMACSDD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMACSDD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMACSDQH", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMACSDQH));
        xPyDict_SetItemString(x86OpcodesDict, "VPMACSDQL", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMACSDQL));
        xPyDict_SetItemString(x86OpcodesDict, "VPMACSSDD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMACSSDD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMACSSDQH", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMACSSDQH));
        xPyDict_SetItemString(x86OpcodesDict, "VPMACSSDQL", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMACSSDQL));
        xPyDict_SetItemString(x86OpcodesDict, "VPMACSSWD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMACSSWD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMACSSWW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMACSSWW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMACSWD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMACSWD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMACSWW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMACSWW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMADCSSWD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMADCSSWD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMADCSWD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMADCSWD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMADDUBSW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMADDUBSW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMADDWD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMADDWD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMASKMOVD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMASKMOVD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMASKMOVQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMASKMOVQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPMAXSB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMAXSB));
        xPyDict_SetItemString(x86OpcodesDict, "VPMAXSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMAXSD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMAXSQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMAXSQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPMAXSW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMAXSW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMAXUB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMAXUB));
        xPyDict_SetItemString(x86OpcodesDict, "VPMAXUD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMAXUD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMAXUQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMAXUQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPMAXUW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMAXUW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMINSB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMINSB));
        xPyDict_SetItemString(x86OpcodesDict, "VPMINSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMINSD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMINSQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMINSQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPMINSW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMINSW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMINUB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMINUB));
        xPyDict_SetItemString(x86OpcodesDict, "VPMINUD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMINUD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMINUQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMINUQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPMINUW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMINUW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVDB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVDB));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVDW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVDW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVMSKB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVMSKB));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVQB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVQB));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVQD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVQD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVQW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVQW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVSDB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVSDB));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVSDW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVSDW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVSQB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVSQB));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVSQD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVSQD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVSQW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVSQW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVSXBD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVSXBD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVSXBQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVSXBQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVSXBW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVSXBW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVSXDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVSXDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVSXWD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVSXWD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVSXWQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVSXWQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVUSDB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVUSDB));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVUSDW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVUSDW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVUSQB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVUSQB));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVUSQD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVUSQD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVUSQW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVUSQW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVZXBD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVZXBD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVZXBQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVZXBQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVZXBW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVZXBW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVZXDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVZXDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVZXWD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVZXWD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMOVZXWQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMOVZXWQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPMULDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMULDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPMULHRSW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMULHRSW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMULHUW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMULHUW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMULHW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMULHW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMULLD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMULLD));
        xPyDict_SetItemString(x86OpcodesDict, "VPMULLW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMULLW));
        xPyDict_SetItemString(x86OpcodesDict, "VPMULUDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPMULUDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPORD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPORD));
        xPyDict_SetItemString(x86OpcodesDict, "VPORQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPORQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPOR", PyLong_FromUint32(triton::arch::x86::ID_INS_VPOR));
        xPyDict_SetItemString(x86OpcodesDict, "VPPERM", PyLong_FromUint32(triton::arch::x86::ID_INS_VPPERM));
        xPyDict_SetItemString(x86OpcodesDict, "VPROTB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPROTB));
        xPyDict_SetItemString(x86OpcodesDict, "VPROTD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPROTD));
        xPyDict_SetItemString(x86OpcodesDict, "VPROTQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPROTQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPROTW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPROTW));
        xPyDict_SetItemString(x86OpcodesDict, "VPSADBW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSADBW));
        xPyDict_SetItemString(x86OpcodesDict, "VPSCATTERDD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSCATTERDD));
        xPyDict_SetItemString(x86OpcodesDict, "VPSCATTERDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSCATTERDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPSCATTERQD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSCATTERQD));
        xPyDict_SetItemString(x86OpcodesDict, "VPSCATTERQQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSCATTERQQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPSHAB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSHAB));
        xPyDict_SetItemString(x86OpcodesDict, "VPSHAD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSHAD));
        xPyDict_SetItemString(x86OpcodesDict, "VPSHAQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSHAQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPSHAW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSHAW));
        xPyDict_SetItemString(x86OpcodesDict, "VPSHLB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSHLB));
        xPyDict_SetItemString(x86OpcodesDict, "VPSHLD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSHLD));
        xPyDict_SetItemString(x86OpcodesDict, "VPSHLQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSHLQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPSHLW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSHLW));
        xPyDict_SetItemString(x86OpcodesDict, "VPSHUFB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSHUFB));
        xPyDict_SetItemString(x86OpcodesDict, "VPSHUFD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSHUFD));
        xPyDict_SetItemString(x86OpcodesDict, "VPSHUFHW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSHUFHW));
        xPyDict_SetItemString(x86OpcodesDict, "VPSHUFLW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSHUFLW));
        xPyDict_SetItemString(x86OpcodesDict, "VPSIGNB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSIGNB));
        xPyDict_SetItemString(x86OpcodesDict, "VPSIGND", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSIGND));
        xPyDict_SetItemString(x86OpcodesDict, "VPSIGNW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSIGNW));
        xPyDict_SetItemString(x86OpcodesDict, "VPSLLDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSLLDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPSLLD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSLLD));
        xPyDict_SetItemString(x86OpcodesDict, "VPSLLQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSLLQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPSLLVD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSLLVD));
        xPyDict_SetItemString(x86OpcodesDict, "VPSLLVQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSLLVQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPSLLW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSLLW));
        xPyDict_SetItemString(x86OpcodesDict, "VPSRAD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSRAD));
        xPyDict_SetItemString(x86OpcodesDict, "VPSRAQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSRAQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPSRAVD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSRAVD));
        xPyDict_SetItemString(x86OpcodesDict, "VPSRAVQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSRAVQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPSRAW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSRAW));
        xPyDict_SetItemString(x86OpcodesDict, "VPSRLDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSRLDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPSRLD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSRLD));
        xPyDict_SetItemString(x86OpcodesDict, "VPSRLQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSRLQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPSRLVD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSRLVD));
        xPyDict_SetItemString(x86OpcodesDict, "VPSRLVQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSRLVQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPSRLW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSRLW));
        xPyDict_SetItemString(x86OpcodesDict, "VPSUBB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSUBB));
        xPyDict_SetItemString(x86OpcodesDict, "VPSUBD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSUBD));
        xPyDict_SetItemString(x86OpcodesDict, "VPSUBQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSUBQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPSUBSB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSUBSB));
        xPyDict_SetItemString(x86OpcodesDict, "VPSUBSW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSUBSW));
        xPyDict_SetItemString(x86OpcodesDict, "VPSUBUSB", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSUBUSB));
        xPyDict_SetItemString(x86OpcodesDict, "VPSUBUSW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSUBUSW));
        xPyDict_SetItemString(x86OpcodesDict, "VPSUBW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPSUBW));
        xPyDict_SetItemString(x86OpcodesDict, "VPTESTMD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPTESTMD));
        xPyDict_SetItemString(x86OpcodesDict, "VPTESTMQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPTESTMQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPTESTNMD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPTESTNMD));
        xPyDict_SetItemString(x86OpcodesDict, "VPTESTNMQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPTESTNMQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPTEST", PyLong_FromUint32(triton::arch::x86::ID_INS_VPTEST));
        xPyDict_SetItemString(x86OpcodesDict, "VPUNPCKHBW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPUNPCKHBW));
        xPyDict_SetItemString(x86OpcodesDict, "VPUNPCKHDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPUNPCKHDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPUNPCKHQDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPUNPCKHQDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPUNPCKHWD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPUNPCKHWD));
        xPyDict_SetItemString(x86OpcodesDict, "VPUNPCKLBW", PyLong_FromUint32(triton::arch::x86::ID_INS_VPUNPCKLBW));
        xPyDict_SetItemString(x86OpcodesDict, "VPUNPCKLDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPUNPCKLDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPUNPCKLQDQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPUNPCKLQDQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPUNPCKLWD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPUNPCKLWD));
        xPyDict_SetItemString(x86OpcodesDict, "VPXORD", PyLong_FromUint32(triton::arch::x86::ID_INS_VPXORD));
        xPyDict_SetItemString(x86OpcodesDict, "VPXORQ", PyLong_FromUint32(triton::arch::x86::ID_INS_VPXORQ));
        xPyDict_SetItemString(x86OpcodesDict, "VPXOR", PyLong_FromUint32(triton::arch::x86::ID_INS_VPXOR));
        xPyDict_SetItemString(x86OpcodesDict, "VRCP14PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VRCP14PD));
        xPyDict_SetItemString(x86OpcodesDict, "VRCP14PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VRCP14PS));
        xPyDict_SetItemString(x86OpcodesDict, "VRCP14SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VRCP14SD));
        xPyDict_SetItemString(x86OpcodesDict, "VRCP14SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VRCP14SS));
        xPyDict_SetItemString(x86OpcodesDict, "VRCP28PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VRCP28PD));
        xPyDict_SetItemString(x86OpcodesDict, "VRCP28PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VRCP28PS));
        xPyDict_SetItemString(x86OpcodesDict, "VRCP28SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VRCP28SD));
        xPyDict_SetItemString(x86OpcodesDict, "VRCP28SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VRCP28SS));
        xPyDict_SetItemString(x86OpcodesDict, "VRCPPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VRCPPS));
        xPyDict_SetItemString(x86OpcodesDict, "VRCPSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VRCPSS));
        xPyDict_SetItemString(x86OpcodesDict, "VRNDSCALEPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VRNDSCALEPD));
        xPyDict_SetItemString(x86OpcodesDict, "VRNDSCALEPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VRNDSCALEPS));
        xPyDict_SetItemString(x86OpcodesDict, "VRNDSCALESD", PyLong_FromUint32(triton::arch::x86::ID_INS_VRNDSCALESD));
        xPyDict_SetItemString(x86OpcodesDict, "VRNDSCALESS", PyLong_FromUint32(triton::arch::x86::ID_INS_VRNDSCALESS));
        xPyDict_SetItemString(x86OpcodesDict, "VROUNDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VROUNDPD));
        xPyDict_SetItemString(x86OpcodesDict, "VROUNDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VROUNDPS));
        xPyDict_SetItemString(x86OpcodesDict, "VROUNDSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VROUNDSD));
        xPyDict_SetItemString(x86OpcodesDict, "VROUNDSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VROUNDSS));
        xPyDict_SetItemString(x86OpcodesDict, "VRSQRT14PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VRSQRT14PD));
        xPyDict_SetItemString(x86OpcodesDict, "VRSQRT14PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VRSQRT14PS));
        xPyDict_SetItemString(x86OpcodesDict, "VRSQRT14SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VRSQRT14SD));
        xPyDict_SetItemString(x86OpcodesDict, "VRSQRT14SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VRSQRT14SS));
        xPyDict_SetItemString(x86OpcodesDict, "VRSQRT28PD", PyLong_FromUint32(triton::arch::x86::ID_INS_VRSQRT28PD));
        xPyDict_SetItemString(x86OpcodesDict, "VRSQRT28PS", PyLong_FromUint32(triton::arch::x86::ID_INS_VRSQRT28PS));
        xPyDict_SetItemString(x86OpcodesDict, "VRSQRT28SD", PyLong_FromUint32(triton::arch::x86::ID_INS_VRSQRT28SD));
        xPyDict_SetItemString(x86OpcodesDict, "VRSQRT28SS", PyLong_FromUint32(triton::arch::x86::ID_INS_VRSQRT28SS));
        xPyDict_SetItemString(x86OpcodesDict, "VRSQRTPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VRSQRTPS));
        xPyDict_SetItemString(x86OpcodesDict, "VRSQRTSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VRSQRTSS));
        xPyDict_SetItemString(x86OpcodesDict, "VSCATTERDPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VSCATTERDPD));
        xPyDict_SetItemString(x86OpcodesDict, "VSCATTERDPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VSCATTERDPS));
        xPyDict_SetItemString(x86OpcodesDict, "VSCATTERPF0DPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VSCATTERPF0DPD));
        xPyDict_SetItemString(x86OpcodesDict, "VSCATTERPF0DPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VSCATTERPF0DPS));
        xPyDict_SetItemString(x86OpcodesDict, "VSCATTERPF0QPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VSCATTERPF0QPD));
        xPyDict_SetItemString(x86OpcodesDict, "VSCATTERPF0QPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VSCATTERPF0QPS));
        xPyDict_SetItemString(x86OpcodesDict, "VSCATTERPF1DPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VSCATTERPF1DPD));
        xPyDict_SetItemString(x86OpcodesDict, "VSCATTERPF1DPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VSCATTERPF1DPS));
        xPyDict_SetItemString(x86OpcodesDict, "VSCATTERPF1QPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VSCATTERPF1QPD));
        xPyDict_SetItemString(x86OpcodesDict, "VSCATTERPF1QPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VSCATTERPF1QPS));
        xPyDict_SetItemString(x86OpcodesDict, "VSCATTERQPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VSCATTERQPD));
        xPyDict_SetItemString(x86OpcodesDict, "VSCATTERQPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VSCATTERQPS));
        xPyDict_SetItemString(x86OpcodesDict, "VSHUFPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VSHUFPD));
        xPyDict_SetItemString(x86OpcodesDict, "VSHUFPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VSHUFPS));
        xPyDict_SetItemString(x86OpcodesDict, "VSQRTPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VSQRTPD));
        xPyDict_SetItemString(x86OpcodesDict, "VSQRTPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VSQRTPS));
        xPyDict_SetItemString(x86OpcodesDict, "VSQRTSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VSQRTSD));
        xPyDict_SetItemString(x86OpcodesDict, "VSQRTSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VSQRTSS));
        xPyDict_SetItemString(x86OpcodesDict, "VSTMXCSR", PyLong_FromUint32(triton::arch::x86::ID_INS_VSTMXCSR));
        xPyDict_SetItemString(x86OpcodesDict, "VSUBPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VSUBPD));
        xPyDict_SetItemString(x86OpcodesDict, "VSUBPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VSUBPS));
        xPyDict_SetItemString(x86OpcodesDict, "VSUBSD", PyLong_FromUint32(triton::arch::x86::ID_INS_VSUBSD));
        xPyDict_SetItemString(x86OpcodesDict, "VSUBSS", PyLong_FromUint32(triton::arch::x86::ID_INS_VSUBSS));
        xPyDict_SetItemString(x86OpcodesDict, "VTESTPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VTESTPD));
        xPyDict_SetItemString(x86OpcodesDict, "VTESTPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VTESTPS));
        xPyDict_SetItemString(x86OpcodesDict, "VUNPCKHPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VUNPCKHPD));
        xPyDict_SetItemString(x86OpcodesDict, "VUNPCKHPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VUNPCKHPS));
        xPyDict_SetItemString(x86OpcodesDict, "VUNPCKLPD", PyLong_FromUint32(triton::arch::x86::ID_INS_VUNPCKLPD));
        xPyDict_SetItemString(x86OpcodesDict, "VUNPCKLPS", PyLong_FromUint32(triton::arch::x86::ID_INS_VUNPCKLPS));
        xPyDict_SetItemString(x86OpcodesDict, "VZEROALL", PyLong_FromUint32(triton::arch::x86::ID_INS_VZEROALL));
        xPyDict_SetItemString(x86OpcodesDict, "VZEROUPPER", PyLong_FromUint32(triton::arch::x86::ID_INS_VZEROUPPER));
        xPyDict_SetItemString(x86OpcodesDict, "WAIT", PyLong_FromUint32(triton::arch::x86::ID_INS_WAIT));
        xPyDict_SetItemString(x86OpcodesDict, "WBINVD", PyLong_FromUint32(triton::arch::x86::ID_INS_WBINVD));
        xPyDict_SetItemString(x86OpcodesDict, "WRFSBASE", PyLong_FromUint32(triton::arch::x86::ID_INS_WRFSBASE));
        xPyDict_SetItemString(x86OpcodesDict, "WRGSBASE", PyLong_FromUint32(triton::arch::x86::ID_INS_WRGSBASE));
        xPyDict_SetItemString(x86OpcodesDict, "WRMSR", PyLong_FromUint32(triton::arch::x86::ID_INS_WRMSR));
        xPyDict_SetItemString(x86OpcodesDict, "XABORT", PyLong_FromUint32(triton::arch::x86::ID_INS_XABORT));
        xPyDict_SetItemString(x86OpcodesDict, "XACQUIRE", PyLong_FromUint32(triton::arch::x86::ID_INS_XACQUIRE));
        xPyDict_SetItemString(x86OpcodesDict, "XBEGIN", PyLong_FromUint32(triton::arch::x86::ID_INS_XBEGIN));
        xPyDict_SetItemString(x86OpcodesDict, "XCHG", PyLong_FromUint32(triton::arch::x86::ID_INS_XCHG));
        xPyDict_SetItemString(x86OpcodesDict, "FXCH", PyLong_FromUint32(triton::arch::x86::ID_INS_FXCH));
        xPyDict_SetItemString(x86OpcodesDict, "XCRYPTCBC", PyLong_FromUint32(triton::arch::x86::ID_INS_XCRYPTCBC));
        xPyDict_SetItemString(x86OpcodesDict, "XCRYPTCFB", PyLong_FromUint32(triton::arch::x86::ID_INS_XCRYPTCFB));
        xPyDict_SetItemString(x86OpcodesDict, "XCRYPTCTR", PyLong_FromUint32(triton::arch::x86::ID_INS_XCRYPTCTR));
        xPyDict_SetItemString(x86OpcodesDict, "XCRYPTECB", PyLong_FromUint32(triton::arch::x86::ID_INS_XCRYPTECB));
        xPyDict_SetItemString(x86OpcodesDict, "XCRYPTOFB", PyLong_FromUint32(triton::arch::x86::ID_INS_XCRYPTOFB));
        xPyDict_SetItemString(x86OpcodesDict, "XEND", PyLong_FromUint32(triton::arch::x86::ID_INS_XEND));
        xPyDict_SetItemString(x86OpcodesDict, "XGETBV", PyLong_FromUint32(triton::arch::x86::ID_INS_XGETBV));
        xPyDict_SetItemString(x86OpcodesDict, "XLATB", PyLong_FromUint32(triton::arch::x86::ID_INS_XLATB));
        xPyDict_SetItemString(x86OpcodesDict, "XRELEASE", PyLong_FromUint32(triton::arch::x86::ID_INS_XRELEASE));
        xPyDict_SetItemString(x86OpcodesDict, "XRSTOR", PyLong_FromUint32(triton::arch::x86::ID_INS_XRSTOR));
        xPyDict_SetItemString(x86OpcodesDict, "XRSTOR64", PyLong_FromUint32(triton::arch::x86::ID_INS_XRSTOR64));
        xPyDict_SetItemString(x86OpcodesDict, "XSAVE", PyLong_FromUint32(triton::arch::x86::ID_INS_XSAVE));
        xPyDict_SetItemString(x86OpcodesDict, "XSAVE64", PyLong_FromUint32(triton::arch::x86::ID_INS_XSAVE64));
        xPyDict_SetItemString(x86OpcodesDict, "XSAVEOPT", PyLong_FromUint32(triton::arch::x86::ID_INS_XSAVEOPT));
        xPyDict_SetItemString(x86OpcodesDict, "XSAVEOPT64", PyLong_FromUint32(triton::arch::x86::ID_INS_XSAVEOPT64));
        xPyDict_SetItemString(x86OpcodesDict, "XSETBV", PyLong_FromUint32(triton::arch::x86::ID_INS_XSETBV));
        xPyDict_SetItemString(x86OpcodesDict, "XSHA1", PyLong_FromUint32(triton::arch::x86::ID_INS_XSHA1));
        xPyDict_SetItemString(x86OpcodesDict, "XSHA256", PyLong_FromUint32(triton::arch::x86::ID_INS_XSHA256));
        xPyDict_SetItemString(x86OpcodesDict, "XSTORE", PyLong_FromUint32(triton::arch::x86::ID_INS_XSTORE));
        xPyDict_SetItemString(x86OpcodesDict, "XTEST", PyLong_FromUint32(triton::arch::x86::ID_INS_XTEST));

        PyObject* x86OpcodesDictClass = xPyClass_New(nullptr, x86OpcodesDict, xPyString_FromString("X86"));
        xPyDict_SetItemString(opcodesDict, "X86", x86OpcodesDictClass);

        PyObject* Aarch64OpcodesDict = xPyDict_New();

        xPyDict_SetItemString(Aarch64OpcodesDict, "ABS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ABS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ADC", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ADC));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ADDHN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ADDHN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ADDHN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ADDHN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ADDP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ADDP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ADD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ADD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ADDV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ADDV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ADR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ADR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ADRP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ADRP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "AESD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_AESD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "AESE", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_AESE));
        xPyDict_SetItemString(Aarch64OpcodesDict, "AESIMC", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_AESIMC));
        xPyDict_SetItemString(Aarch64OpcodesDict, "AESMC", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_AESMC));
        xPyDict_SetItemString(Aarch64OpcodesDict, "AND", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_AND));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ASR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ASR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "B", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_B));
        xPyDict_SetItemString(Aarch64OpcodesDict, "BFM", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_BFM));
        xPyDict_SetItemString(Aarch64OpcodesDict, "BIC", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_BIC));
        xPyDict_SetItemString(Aarch64OpcodesDict, "BIF", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_BIF));
        xPyDict_SetItemString(Aarch64OpcodesDict, "BIT", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_BIT));
        xPyDict_SetItemString(Aarch64OpcodesDict, "BL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_BL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "BLR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_BLR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "BR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_BR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "BRK", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_BRK));
        xPyDict_SetItemString(Aarch64OpcodesDict, "BSL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_BSL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CBNZ", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CBNZ));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CBZ", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CBZ));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CCMN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CCMN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CCMP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CCMP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CLREX", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CLREX));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CLS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CLS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CLZ", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CLZ));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CMEQ", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CMEQ));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CMGE", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CMGE));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CMGT", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CMGT));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CMHI", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CMHI));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CMHS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CMHS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CMLE", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CMLE));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CMLT", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CMLT));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CMTST", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CMTST));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CNT", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CNT));
        xPyDict_SetItemString(Aarch64OpcodesDict, "MOV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_MOV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CRC32B", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CRC32B));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CRC32CB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CRC32CB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CRC32CH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CRC32CH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CRC32CW", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CRC32CW));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CRC32CX", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CRC32CX));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CRC32H", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CRC32H));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CRC32W", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CRC32W));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CRC32X", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CRC32X));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CSEL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CSEL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CSINC", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CSINC));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CSINV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CSINV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "CSNEG", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_CSNEG));
        xPyDict_SetItemString(Aarch64OpcodesDict, "DCPS1", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_DCPS1));
        xPyDict_SetItemString(Aarch64OpcodesDict, "DCPS2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_DCPS2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "DCPS3", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_DCPS3));
        xPyDict_SetItemString(Aarch64OpcodesDict, "DMB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_DMB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "DRPS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_DRPS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "DSB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_DSB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "DUP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_DUP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "EON", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_EON));
        xPyDict_SetItemString(Aarch64OpcodesDict, "EOR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_EOR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ERET", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ERET));
        xPyDict_SetItemString(Aarch64OpcodesDict, "EXTR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_EXTR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "EXT", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_EXT));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FABD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FABD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FABS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FABS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FACGE", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FACGE));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FACGT", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FACGT));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FADD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FADD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FADDP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FADDP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCCMP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCCMP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCCMPE", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCCMPE));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCMEQ", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCMEQ));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCMGE", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCMGE));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCMGT", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCMGT));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCMLE", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCMLE));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCMLT", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCMLT));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCMP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCMP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCMPE", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCMPE));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCSEL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCSEL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTAS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTAS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTAU", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTAU));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVT", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVT));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTMS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTMS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTMU", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTMU));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTNS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTNS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTNU", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTNU));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTPS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTPS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTPU", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTPU));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTXN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTXN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTXN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTXN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTZS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTZS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FCVTZU", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FCVTZU));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FDIV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FDIV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMADD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMADD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMAX", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMAX));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMAXNM", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMAXNM));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMAXNMP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMAXNMP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMAXNMV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMAXNMV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMAXP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMAXP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMAXV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMAXV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMIN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMIN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMINNM", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMINNM));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMINNMP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMINNMP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMINNMV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMINNMV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMINP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMINP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMINV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMINV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMLA", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMLA));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMLS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMLS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMOV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMOV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMSUB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMSUB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMUL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMUL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FMULX", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FMULX));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FNEG", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FNEG));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FNMADD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FNMADD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FNMSUB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FNMSUB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FNMUL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FNMUL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FRECPE", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FRECPE));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FRECPS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FRECPS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FRECPX", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FRECPX));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FRINTA", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FRINTA));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FRINTI", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FRINTI));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FRINTM", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FRINTM));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FRINTN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FRINTN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FRINTP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FRINTP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FRINTX", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FRINTX));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FRINTZ", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FRINTZ));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FRSQRTE", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FRSQRTE));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FRSQRTS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FRSQRTS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FSQRT", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FSQRT));
        xPyDict_SetItemString(Aarch64OpcodesDict, "FSUB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_FSUB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "HINT", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_HINT));
        xPyDict_SetItemString(Aarch64OpcodesDict, "HLT", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_HLT));
        xPyDict_SetItemString(Aarch64OpcodesDict, "HVC", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_HVC));
        xPyDict_SetItemString(Aarch64OpcodesDict, "INS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_INS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ISB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ISB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LD1", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LD1));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LD1R", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LD1R));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LD2R", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LD2R));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LD2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LD2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LD3R", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LD3R));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LD3", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LD3));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LD4", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LD4));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LD4R", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LD4R));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDARB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDARB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDARH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDARH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDAR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDAR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDAXP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDAXP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDAXRB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDAXRB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDAXRH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDAXRH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDAXR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDAXR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDNP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDNP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDPSW", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDPSW));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDRB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDRB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDRH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDRH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDRSB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDRSB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDRSH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDRSH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDRSW", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDRSW));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDTRB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDTRB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDTRH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDTRH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDTRSB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDTRSB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDTRSH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDTRSH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDTRSW", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDTRSW));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDTR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDTR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDURB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDURB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDUR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDUR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDURH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDURH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDURSB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDURSB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDURSH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDURSH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDURSW", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDURSW));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDXP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDXP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDXRB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDXRB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDXRH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDXRH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LDXR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LDXR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LSL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LSL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "LSR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_LSR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "MADD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_MADD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "MLA", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_MLA));
        xPyDict_SetItemString(Aarch64OpcodesDict, "MLS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_MLS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "MOVI", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_MOVI));
        xPyDict_SetItemString(Aarch64OpcodesDict, "MOVK", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_MOVK));
        xPyDict_SetItemString(Aarch64OpcodesDict, "MOVN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_MOVN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "MOVZ", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_MOVZ));
        xPyDict_SetItemString(Aarch64OpcodesDict, "MRS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_MRS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "MSR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_MSR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "MSUB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_MSUB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "MUL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_MUL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "MVNI", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_MVNI));
        xPyDict_SetItemString(Aarch64OpcodesDict, "NEG", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_NEG));
        xPyDict_SetItemString(Aarch64OpcodesDict, "NOT", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_NOT));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ORN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ORN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ORR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ORR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "PMULL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_PMULL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "PMULL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_PMULL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "PMUL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_PMUL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "PRFM", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_PRFM));
        xPyDict_SetItemString(Aarch64OpcodesDict, "PRFUM", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_PRFUM));
        xPyDict_SetItemString(Aarch64OpcodesDict, "RADDHN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_RADDHN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "RADDHN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_RADDHN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "RBIT", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_RBIT));
        xPyDict_SetItemString(Aarch64OpcodesDict, "RET", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_RET));
        xPyDict_SetItemString(Aarch64OpcodesDict, "REV16", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_REV16));
        xPyDict_SetItemString(Aarch64OpcodesDict, "REV32", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_REV32));
        xPyDict_SetItemString(Aarch64OpcodesDict, "REV64", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_REV64));
        xPyDict_SetItemString(Aarch64OpcodesDict, "REV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_REV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ROR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ROR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "RSHRN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_RSHRN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "RSHRN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_RSHRN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "RSUBHN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_RSUBHN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "RSUBHN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_RSUBHN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SABAL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SABAL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SABAL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SABAL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SABA", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SABA));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SABDL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SABDL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SABDL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SABDL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SABD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SABD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SADALP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SADALP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SADDLP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SADDLP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SADDLV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SADDLV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SADDL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SADDL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SADDL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SADDL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SADDW2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SADDW2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SADDW", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SADDW));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SBC", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SBC));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SBFM", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SBFM));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SCVTF", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SCVTF));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SDIV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SDIV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHA1C", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHA1C));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHA1H", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHA1H));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHA1M", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHA1M));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHA1P", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHA1P));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHA1SU0", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHA1SU0));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHA1SU1", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHA1SU1));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHA256H2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHA256H2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHA256H", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHA256H));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHA256SU0", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHA256SU0));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHA256SU1", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHA256SU1));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHADD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHADD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHLL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHLL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHLL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHLL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHRN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHRN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHRN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHRN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SHSUB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SHSUB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SLI", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SLI));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMADDL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMADDL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMAXP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMAXP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMAXV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMAXV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMAX", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMAX));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMC", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMC));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMINP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMINP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMINV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMINV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMIN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMIN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMLAL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMLAL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMLAL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMLAL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMLSL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMLSL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMLSL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMLSL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMOV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMOV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMSUBL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMSUBL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMULH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMULH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMULL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMULL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SMULL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SMULL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQABS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQABS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQADD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQADD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQDMLAL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQDMLAL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQDMLAL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQDMLAL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQDMLSL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQDMLSL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQDMLSL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQDMLSL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQDMULH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQDMULH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQDMULL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQDMULL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQDMULL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQDMULL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQNEG", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQNEG));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQRDMULH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQRDMULH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQRSHL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQRSHL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQRSHRN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQRSHRN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQRSHRN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQRSHRN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQRSHRUN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQRSHRUN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQRSHRUN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQRSHRUN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQSHLU", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQSHLU));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQSHL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQSHL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQSHRN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQSHRN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQSHRN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQSHRN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQSHRUN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQSHRUN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQSHRUN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQSHRUN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQSUB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQSUB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQXTN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQXTN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQXTN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQXTN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQXTUN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQXTUN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SQXTUN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SQXTUN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SRHADD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SRHADD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SRI", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SRI));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SRSHL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SRSHL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SRSHR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SRSHR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SRSRA", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SRSRA));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SSHLL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SSHLL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SSHLL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SSHLL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SSHL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SSHL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SSHR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SSHR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SSRA", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SSRA));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SSUBL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SSUBL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SSUBL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SSUBL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SSUBW2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SSUBW2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SSUBW", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SSUBW));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ST1", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ST1));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ST2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ST2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ST3", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ST3));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ST4", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ST4));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STLRB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STLRB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STLRH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STLRH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STLR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STLR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STLXP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STLXP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STLXRB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STLXRB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STLXRH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STLXRH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STLXR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STLXR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STNP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STNP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STRB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STRB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STRH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STRH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STTRB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STTRB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STTRH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STTRH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STTR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STTR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STURB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STURB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STUR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STUR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STURH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STURH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STXP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STXP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STXRB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STXRB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STXRH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STXRH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "STXR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_STXR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SUBHN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SUBHN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SUBHN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SUBHN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SUB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SUB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SUQADD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SUQADD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SVC", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SVC));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SYSL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SYSL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "SYS", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_SYS));
        xPyDict_SetItemString(Aarch64OpcodesDict, "TBL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_TBL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "TBNZ", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_TBNZ));
        xPyDict_SetItemString(Aarch64OpcodesDict, "TBX", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_TBX));
        xPyDict_SetItemString(Aarch64OpcodesDict, "TBZ", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_TBZ));
        xPyDict_SetItemString(Aarch64OpcodesDict, "TRN1", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_TRN1));
        xPyDict_SetItemString(Aarch64OpcodesDict, "TRN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_TRN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UABAL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UABAL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UABAL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UABAL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UABA", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UABA));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UABDL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UABDL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UABDL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UABDL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UABD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UABD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UADALP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UADALP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UADDLP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UADDLP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UADDLV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UADDLV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UADDL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UADDL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UADDL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UADDL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UADDW2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UADDW2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UADDW", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UADDW));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UBFM", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UBFM));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UCVTF", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UCVTF));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UDIV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UDIV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UHADD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UHADD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UHSUB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UHSUB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMADDL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMADDL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMAXP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMAXP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMAXV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMAXV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMAX", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMAX));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMINP", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMINP));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMINV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMINV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMIN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMIN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMLAL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMLAL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMLAL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMLAL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMLSL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMLSL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMLSL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMLSL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMOV", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMOV));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMSUBL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMSUBL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMULH", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMULH));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMULL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMULL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UMULL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UMULL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UQADD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UQADD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UQRSHL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UQRSHL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UQRSHRN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UQRSHRN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UQRSHRN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UQRSHRN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UQSHL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UQSHL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UQSHRN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UQSHRN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UQSHRN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UQSHRN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UQSUB", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UQSUB));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UQXTN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UQXTN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UQXTN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UQXTN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "URECPE", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_URECPE));
        xPyDict_SetItemString(Aarch64OpcodesDict, "URHADD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_URHADD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "URSHL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_URSHL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "URSHR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_URSHR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "URSQRTE", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_URSQRTE));
        xPyDict_SetItemString(Aarch64OpcodesDict, "URSRA", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_URSRA));
        xPyDict_SetItemString(Aarch64OpcodesDict, "USHLL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_USHLL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "USHLL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_USHLL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "USHL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_USHL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "USHR", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_USHR));
        xPyDict_SetItemString(Aarch64OpcodesDict, "USQADD", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_USQADD));
        xPyDict_SetItemString(Aarch64OpcodesDict, "USRA", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_USRA));
        xPyDict_SetItemString(Aarch64OpcodesDict, "USUBL2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_USUBL2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "USUBL", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_USUBL));
        xPyDict_SetItemString(Aarch64OpcodesDict, "USUBW2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_USUBW2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "USUBW", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_USUBW));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UZP1", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UZP1));
        xPyDict_SetItemString(Aarch64OpcodesDict, "UZP2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_UZP2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "XTN2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_XTN2));
        xPyDict_SetItemString(Aarch64OpcodesDict, "XTN", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_XTN));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ZIP1", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ZIP1));
        xPyDict_SetItemString(Aarch64OpcodesDict, "ZIP2", PyLong_FromUint32(triton::arch::arm::aarch64::ID_INS_ZIP2));

        PyObject* Aarch64OpcodesDictClass = xPyClass_New(nullptr, Aarch64OpcodesDict, xPyString_FromString("AARCH64"));
        xPyDict_SetItemString(opcodesDict, "AARCH64", Aarch64OpcodesDictClass);

        PyObject* arm32OpcodesDict = xPyDict_New();

        xPyDict_SetItemString(arm32OpcodesDict, "ADC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_ADC));
        xPyDict_SetItemString(arm32OpcodesDict, "ADC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_ADC));
        xPyDict_SetItemString(arm32OpcodesDict, "ADD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_ADD));
        xPyDict_SetItemString(arm32OpcodesDict, "ADR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_ADR));
        xPyDict_SetItemString(arm32OpcodesDict, "AESD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_AESD));
        xPyDict_SetItemString(arm32OpcodesDict, "AESE", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_AESE));
        xPyDict_SetItemString(arm32OpcodesDict, "AESIMC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_AESIMC));
        xPyDict_SetItemString(arm32OpcodesDict, "AESMC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_AESMC));
        xPyDict_SetItemString(arm32OpcodesDict, "AND", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_AND));
        xPyDict_SetItemString(arm32OpcodesDict, "BFC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_BFC));
        xPyDict_SetItemString(arm32OpcodesDict, "BFI", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_BFI));
        xPyDict_SetItemString(arm32OpcodesDict, "BIC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_BIC));
        xPyDict_SetItemString(arm32OpcodesDict, "BKPT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_BKPT));
        xPyDict_SetItemString(arm32OpcodesDict, "BL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_BL));
        xPyDict_SetItemString(arm32OpcodesDict, "BLX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_BLX));
        xPyDict_SetItemString(arm32OpcodesDict, "BX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_BX));
        xPyDict_SetItemString(arm32OpcodesDict, "BXJ", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_BXJ));
        xPyDict_SetItemString(arm32OpcodesDict, "B", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_B));
        xPyDict_SetItemString(arm32OpcodesDict, "CDP", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CDP));
        xPyDict_SetItemString(arm32OpcodesDict, "CDP2", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CDP2));
        xPyDict_SetItemString(arm32OpcodesDict, "CLREX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CLREX));
        xPyDict_SetItemString(arm32OpcodesDict, "CLZ", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CLZ));
        xPyDict_SetItemString(arm32OpcodesDict, "CMN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CMN));
        xPyDict_SetItemString(arm32OpcodesDict, "CMP", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CMP));
        xPyDict_SetItemString(arm32OpcodesDict, "CPS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CPS));
        xPyDict_SetItemString(arm32OpcodesDict, "CRC32B", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CRC32B));
        xPyDict_SetItemString(arm32OpcodesDict, "CRC32CB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CRC32CB));
        xPyDict_SetItemString(arm32OpcodesDict, "CRC32CH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CRC32CH));
        xPyDict_SetItemString(arm32OpcodesDict, "CRC32CW", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CRC32CW));
        xPyDict_SetItemString(arm32OpcodesDict, "CRC32H", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CRC32H));
        xPyDict_SetItemString(arm32OpcodesDict, "CRC32W", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CRC32W));
        xPyDict_SetItemString(arm32OpcodesDict, "DBG", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_DBG));
        xPyDict_SetItemString(arm32OpcodesDict, "DMB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_DMB));
        xPyDict_SetItemString(arm32OpcodesDict, "DSB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_DSB));
        xPyDict_SetItemString(arm32OpcodesDict, "EOR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_EOR));
        xPyDict_SetItemString(arm32OpcodesDict, "ERET", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_ERET));
        xPyDict_SetItemString(arm32OpcodesDict, "VMOV", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMOV));
        xPyDict_SetItemString(arm32OpcodesDict, "FLDMDBX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_FLDMDBX));
        xPyDict_SetItemString(arm32OpcodesDict, "FLDMIAX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_FLDMIAX));
        xPyDict_SetItemString(arm32OpcodesDict, "VMRS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMRS));
        xPyDict_SetItemString(arm32OpcodesDict, "FSTMDBX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_FSTMDBX));
        xPyDict_SetItemString(arm32OpcodesDict, "FSTMIAX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_FSTMIAX));
        xPyDict_SetItemString(arm32OpcodesDict, "HINT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_HINT));
        xPyDict_SetItemString(arm32OpcodesDict, "HLT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_HLT));
        xPyDict_SetItemString(arm32OpcodesDict, "HVC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_HVC));
        xPyDict_SetItemString(arm32OpcodesDict, "ISB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_ISB));
        xPyDict_SetItemString(arm32OpcodesDict, "LDA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDA));
        xPyDict_SetItemString(arm32OpcodesDict, "LDAB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDAB));
        xPyDict_SetItemString(arm32OpcodesDict, "LDAEX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDAEX));
        xPyDict_SetItemString(arm32OpcodesDict, "LDAEXB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDAEXB));
        xPyDict_SetItemString(arm32OpcodesDict, "LDAEXD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDAEXD));
        xPyDict_SetItemString(arm32OpcodesDict, "LDAEXH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDAEXH));
        xPyDict_SetItemString(arm32OpcodesDict, "LDAH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDAH));
        xPyDict_SetItemString(arm32OpcodesDict, "LDC2L", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDC2L));
        xPyDict_SetItemString(arm32OpcodesDict, "LDC2", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDC2));
        xPyDict_SetItemString(arm32OpcodesDict, "LDCL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDCL));
        xPyDict_SetItemString(arm32OpcodesDict, "LDC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDC));
        xPyDict_SetItemString(arm32OpcodesDict, "LDMDA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDMDA));
        xPyDict_SetItemString(arm32OpcodesDict, "LDMDB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDMDB));
        xPyDict_SetItemString(arm32OpcodesDict, "LDM", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDM));
        xPyDict_SetItemString(arm32OpcodesDict, "LDMIB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDMIB));
        xPyDict_SetItemString(arm32OpcodesDict, "LDRBT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDRBT));
        xPyDict_SetItemString(arm32OpcodesDict, "LDRB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDRB));
        xPyDict_SetItemString(arm32OpcodesDict, "LDRD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDRD));
        xPyDict_SetItemString(arm32OpcodesDict, "LDREX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDREX));
        xPyDict_SetItemString(arm32OpcodesDict, "LDREXB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDREXB));
        xPyDict_SetItemString(arm32OpcodesDict, "LDREXD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDREXD));
        xPyDict_SetItemString(arm32OpcodesDict, "LDREXH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDREXH));
        xPyDict_SetItemString(arm32OpcodesDict, "LDRH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDRH));
        xPyDict_SetItemString(arm32OpcodesDict, "LDRHT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDRHT));
        xPyDict_SetItemString(arm32OpcodesDict, "LDRSB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDRSB));
        xPyDict_SetItemString(arm32OpcodesDict, "LDRSBT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDRSBT));
        xPyDict_SetItemString(arm32OpcodesDict, "LDRSH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDRSH));
        xPyDict_SetItemString(arm32OpcodesDict, "LDRSHT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDRSHT));
        xPyDict_SetItemString(arm32OpcodesDict, "LDRT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDRT));
        xPyDict_SetItemString(arm32OpcodesDict, "LDR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LDR));
        xPyDict_SetItemString(arm32OpcodesDict, "MCR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MCR));
        xPyDict_SetItemString(arm32OpcodesDict, "MCR2", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MCR2));
        xPyDict_SetItemString(arm32OpcodesDict, "MCRR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MCRR));
        xPyDict_SetItemString(arm32OpcodesDict, "MCRR2", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MCRR2));
        xPyDict_SetItemString(arm32OpcodesDict, "MLA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MLA));
        xPyDict_SetItemString(arm32OpcodesDict, "MLS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MLS));
        xPyDict_SetItemString(arm32OpcodesDict, "MOV", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MOV));
        xPyDict_SetItemString(arm32OpcodesDict, "MOVT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MOVT));
        xPyDict_SetItemString(arm32OpcodesDict, "MOVW", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MOVW));
        xPyDict_SetItemString(arm32OpcodesDict, "MRC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MRC));
        xPyDict_SetItemString(arm32OpcodesDict, "MRC2", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MRC2));
        xPyDict_SetItemString(arm32OpcodesDict, "MRRC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MRRC));
        xPyDict_SetItemString(arm32OpcodesDict, "MRRC2", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MRRC2));
        xPyDict_SetItemString(arm32OpcodesDict, "MRS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MRS));
        xPyDict_SetItemString(arm32OpcodesDict, "MSR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MSR));
        xPyDict_SetItemString(arm32OpcodesDict, "MUL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MUL));
        xPyDict_SetItemString(arm32OpcodesDict, "MVN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_MVN));
        xPyDict_SetItemString(arm32OpcodesDict, "ORR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_ORR));
        xPyDict_SetItemString(arm32OpcodesDict, "PKHBT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_PKHBT));
        xPyDict_SetItemString(arm32OpcodesDict, "PKHTB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_PKHTB));
        xPyDict_SetItemString(arm32OpcodesDict, "PLDW", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_PLDW));
        xPyDict_SetItemString(arm32OpcodesDict, "PLD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_PLD));
        xPyDict_SetItemString(arm32OpcodesDict, "PLI", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_PLI));
        xPyDict_SetItemString(arm32OpcodesDict, "QADD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_QADD));
        xPyDict_SetItemString(arm32OpcodesDict, "QADD16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_QADD16));
        xPyDict_SetItemString(arm32OpcodesDict, "QADD8", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_QADD8));
        xPyDict_SetItemString(arm32OpcodesDict, "QASX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_QASX));
        xPyDict_SetItemString(arm32OpcodesDict, "QDADD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_QDADD));
        xPyDict_SetItemString(arm32OpcodesDict, "QDSUB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_QDSUB));
        xPyDict_SetItemString(arm32OpcodesDict, "QSAX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_QSAX));
        xPyDict_SetItemString(arm32OpcodesDict, "QSUB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_QSUB));
        xPyDict_SetItemString(arm32OpcodesDict, "QSUB16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_QSUB16));
        xPyDict_SetItemString(arm32OpcodesDict, "QSUB8", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_QSUB8));
        xPyDict_SetItemString(arm32OpcodesDict, "RBIT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_RBIT));
        xPyDict_SetItemString(arm32OpcodesDict, "REV", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_REV));
        xPyDict_SetItemString(arm32OpcodesDict, "REV16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_REV16));
        xPyDict_SetItemString(arm32OpcodesDict, "REVSH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_REVSH));
        xPyDict_SetItemString(arm32OpcodesDict, "RFEDA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_RFEDA));
        xPyDict_SetItemString(arm32OpcodesDict, "RFEDB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_RFEDB));
        xPyDict_SetItemString(arm32OpcodesDict, "RFEIA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_RFEIA));
        xPyDict_SetItemString(arm32OpcodesDict, "RFEIB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_RFEIB));
        xPyDict_SetItemString(arm32OpcodesDict, "RSB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_RSB));
        xPyDict_SetItemString(arm32OpcodesDict, "RSC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_RSC));
        xPyDict_SetItemString(arm32OpcodesDict, "SADD16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SADD16));
        xPyDict_SetItemString(arm32OpcodesDict, "SADD8", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SADD8));
        xPyDict_SetItemString(arm32OpcodesDict, "SASX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SASX));
        xPyDict_SetItemString(arm32OpcodesDict, "SBC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SBC));
        xPyDict_SetItemString(arm32OpcodesDict, "SBFX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SBFX));
        xPyDict_SetItemString(arm32OpcodesDict, "SDIV", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SDIV));
        xPyDict_SetItemString(arm32OpcodesDict, "SEL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SEL));
        xPyDict_SetItemString(arm32OpcodesDict, "SETEND", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SETEND));
        xPyDict_SetItemString(arm32OpcodesDict, "SHA1C", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHA1C));
        xPyDict_SetItemString(arm32OpcodesDict, "SHA1H", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHA1H));
        xPyDict_SetItemString(arm32OpcodesDict, "SHA1M", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHA1M));
        xPyDict_SetItemString(arm32OpcodesDict, "SHA1P", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHA1P));
        xPyDict_SetItemString(arm32OpcodesDict, "SHA1SU0", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHA1SU0));
        xPyDict_SetItemString(arm32OpcodesDict, "SHA1SU1", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHA1SU1));
        xPyDict_SetItemString(arm32OpcodesDict, "SHA256H", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHA256H));
        xPyDict_SetItemString(arm32OpcodesDict, "SHA256H2", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHA256H2));
        xPyDict_SetItemString(arm32OpcodesDict, "SHA256SU0", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHA256SU0));
        xPyDict_SetItemString(arm32OpcodesDict, "SHA256SU1", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHA256SU1));
        xPyDict_SetItemString(arm32OpcodesDict, "SHADD16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHADD16));
        xPyDict_SetItemString(arm32OpcodesDict, "SHADD8", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHADD8));
        xPyDict_SetItemString(arm32OpcodesDict, "SHASX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHASX));
        xPyDict_SetItemString(arm32OpcodesDict, "SHSAX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHSAX));
        xPyDict_SetItemString(arm32OpcodesDict, "SHSUB16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHSUB16));
        xPyDict_SetItemString(arm32OpcodesDict, "SHSUB8", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SHSUB8));
        xPyDict_SetItemString(arm32OpcodesDict, "SMC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMC));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLABB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLABB));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLABT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLABT));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLAD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLAD));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLADX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLADX));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLAL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLAL));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLALBB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLALBB));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLALBT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLALBT));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLALD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLALD));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLALDX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLALDX));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLALTB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLALTB));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLALTT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLALTT));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLATB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLATB));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLATT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLATT));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLAWB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLAWB));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLAWT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLAWT));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLSD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLSD));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLSDX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLSDX));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLSLD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLSLD));
        xPyDict_SetItemString(arm32OpcodesDict, "SMLSLDX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMLSLDX));
        xPyDict_SetItemString(arm32OpcodesDict, "SMMLA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMMLA));
        xPyDict_SetItemString(arm32OpcodesDict, "SMMLAR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMMLAR));
        xPyDict_SetItemString(arm32OpcodesDict, "SMMLS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMMLS));
        xPyDict_SetItemString(arm32OpcodesDict, "SMMLSR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMMLSR));
        xPyDict_SetItemString(arm32OpcodesDict, "SMMUL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMMUL));
        xPyDict_SetItemString(arm32OpcodesDict, "SMMULR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMMULR));
        xPyDict_SetItemString(arm32OpcodesDict, "SMUAD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMUAD));
        xPyDict_SetItemString(arm32OpcodesDict, "SMUADX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMUADX));
        xPyDict_SetItemString(arm32OpcodesDict, "SMULBB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMULBB));
        xPyDict_SetItemString(arm32OpcodesDict, "SMULBT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMULBT));
        xPyDict_SetItemString(arm32OpcodesDict, "SMULL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMULL));
        xPyDict_SetItemString(arm32OpcodesDict, "SMULTB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMULTB));
        xPyDict_SetItemString(arm32OpcodesDict, "SMULTT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMULTT));
        xPyDict_SetItemString(arm32OpcodesDict, "SMULWB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMULWB));
        xPyDict_SetItemString(arm32OpcodesDict, "SMULWT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMULWT));
        xPyDict_SetItemString(arm32OpcodesDict, "SMUSD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMUSD));
        xPyDict_SetItemString(arm32OpcodesDict, "SMUSDX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SMUSDX));
        xPyDict_SetItemString(arm32OpcodesDict, "SRSDA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SRSDA));
        xPyDict_SetItemString(arm32OpcodesDict, "SRSDB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SRSDB));
        xPyDict_SetItemString(arm32OpcodesDict, "SRSIA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SRSIA));
        xPyDict_SetItemString(arm32OpcodesDict, "SRSIB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SRSIB));
        xPyDict_SetItemString(arm32OpcodesDict, "SSAT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SSAT));
        xPyDict_SetItemString(arm32OpcodesDict, "SSAT16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SSAT16));
        xPyDict_SetItemString(arm32OpcodesDict, "SSAX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SSAX));
        xPyDict_SetItemString(arm32OpcodesDict, "SSUB16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SSUB16));
        xPyDict_SetItemString(arm32OpcodesDict, "SSUB8", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SSUB8));
        xPyDict_SetItemString(arm32OpcodesDict, "STC2L", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STC2L));
        xPyDict_SetItemString(arm32OpcodesDict, "STC2", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STC2));
        xPyDict_SetItemString(arm32OpcodesDict, "STCL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STCL));
        xPyDict_SetItemString(arm32OpcodesDict, "STC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STC));
        xPyDict_SetItemString(arm32OpcodesDict, "STL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STL));
        xPyDict_SetItemString(arm32OpcodesDict, "STLB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STLB));
        xPyDict_SetItemString(arm32OpcodesDict, "STLEX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STLEX));
        xPyDict_SetItemString(arm32OpcodesDict, "STLEXB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STLEXB));
        xPyDict_SetItemString(arm32OpcodesDict, "STLEXD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STLEXD));
        xPyDict_SetItemString(arm32OpcodesDict, "STLEXH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STLEXH));
        xPyDict_SetItemString(arm32OpcodesDict, "STLH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STLH));
        xPyDict_SetItemString(arm32OpcodesDict, "STMDA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STMDA));
        xPyDict_SetItemString(arm32OpcodesDict, "STMDB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STMDB));
        xPyDict_SetItemString(arm32OpcodesDict, "STM", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STM));
        xPyDict_SetItemString(arm32OpcodesDict, "STMIB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STMIB));
        xPyDict_SetItemString(arm32OpcodesDict, "STRBT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STRBT));
        xPyDict_SetItemString(arm32OpcodesDict, "STRB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STRB));
        xPyDict_SetItemString(arm32OpcodesDict, "STRD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STRD));
        xPyDict_SetItemString(arm32OpcodesDict, "STREX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STREX));
        xPyDict_SetItemString(arm32OpcodesDict, "STREXB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STREXB));
        xPyDict_SetItemString(arm32OpcodesDict, "STREXD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STREXD));
        xPyDict_SetItemString(arm32OpcodesDict, "STREXH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STREXH));
        xPyDict_SetItemString(arm32OpcodesDict, "STRH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STRH));
        xPyDict_SetItemString(arm32OpcodesDict, "STRHT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STRHT));
        xPyDict_SetItemString(arm32OpcodesDict, "STRT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STRT));
        xPyDict_SetItemString(arm32OpcodesDict, "STR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_STR));
        xPyDict_SetItemString(arm32OpcodesDict, "SUB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SUB));
        xPyDict_SetItemString(arm32OpcodesDict, "SVC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SVC));
        xPyDict_SetItemString(arm32OpcodesDict, "SWP", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SWP));
        xPyDict_SetItemString(arm32OpcodesDict, "SWPB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SWPB));
        xPyDict_SetItemString(arm32OpcodesDict, "SXTAB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SXTAB));
        xPyDict_SetItemString(arm32OpcodesDict, "SXTAB16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SXTAB16));
        xPyDict_SetItemString(arm32OpcodesDict, "SXTAH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SXTAH));
        xPyDict_SetItemString(arm32OpcodesDict, "SXTB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SXTB));
        xPyDict_SetItemString(arm32OpcodesDict, "SXTB16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SXTB16));
        xPyDict_SetItemString(arm32OpcodesDict, "SXTH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SXTH));
        xPyDict_SetItemString(arm32OpcodesDict, "TEQ", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_TEQ));
        xPyDict_SetItemString(arm32OpcodesDict, "TRAP", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_TRAP));
        xPyDict_SetItemString(arm32OpcodesDict, "TST", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_TST));
        xPyDict_SetItemString(arm32OpcodesDict, "UADD16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UADD16));
        xPyDict_SetItemString(arm32OpcodesDict, "UADD8", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UADD8));
        xPyDict_SetItemString(arm32OpcodesDict, "UASX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UASX));
        xPyDict_SetItemString(arm32OpcodesDict, "UBFX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UBFX));
        xPyDict_SetItemString(arm32OpcodesDict, "UDF", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UDF));
        xPyDict_SetItemString(arm32OpcodesDict, "UDIV", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UDIV));
        xPyDict_SetItemString(arm32OpcodesDict, "UHADD16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UHADD16));
        xPyDict_SetItemString(arm32OpcodesDict, "UHADD8", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UHADD8));
        xPyDict_SetItemString(arm32OpcodesDict, "UHASX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UHASX));
        xPyDict_SetItemString(arm32OpcodesDict, "UHSAX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UHSAX));
        xPyDict_SetItemString(arm32OpcodesDict, "UHSUB16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UHSUB16));
        xPyDict_SetItemString(arm32OpcodesDict, "UHSUB8", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UHSUB8));
        xPyDict_SetItemString(arm32OpcodesDict, "UMAAL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UMAAL));
        xPyDict_SetItemString(arm32OpcodesDict, "UMLAL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UMLAL));
        xPyDict_SetItemString(arm32OpcodesDict, "UMULL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UMULL));
        xPyDict_SetItemString(arm32OpcodesDict, "UQADD16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UQADD16));
        xPyDict_SetItemString(arm32OpcodesDict, "UQADD8", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UQADD8));
        xPyDict_SetItemString(arm32OpcodesDict, "UQASX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UQASX));
        xPyDict_SetItemString(arm32OpcodesDict, "UQSAX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UQSAX));
        xPyDict_SetItemString(arm32OpcodesDict, "UQSUB16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UQSUB16));
        xPyDict_SetItemString(arm32OpcodesDict, "UQSUB8", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UQSUB8));
        xPyDict_SetItemString(arm32OpcodesDict, "USAD8", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_USAD8));
        xPyDict_SetItemString(arm32OpcodesDict, "USADA8", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_USADA8));
        xPyDict_SetItemString(arm32OpcodesDict, "USAT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_USAT));
        xPyDict_SetItemString(arm32OpcodesDict, "USAT16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_USAT16));
        xPyDict_SetItemString(arm32OpcodesDict, "USAX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_USAX));
        xPyDict_SetItemString(arm32OpcodesDict, "USUB16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_USUB16));
        xPyDict_SetItemString(arm32OpcodesDict, "USUB8", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_USUB8));
        xPyDict_SetItemString(arm32OpcodesDict, "UXTAB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UXTAB));
        xPyDict_SetItemString(arm32OpcodesDict, "UXTAB16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UXTAB16));
        xPyDict_SetItemString(arm32OpcodesDict, "UXTAH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UXTAH));
        xPyDict_SetItemString(arm32OpcodesDict, "UXTB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UXTB));
        xPyDict_SetItemString(arm32OpcodesDict, "UXTB16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UXTB16));
        xPyDict_SetItemString(arm32OpcodesDict, "UXTH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_UXTH));
        xPyDict_SetItemString(arm32OpcodesDict, "VABAL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VABAL));
        xPyDict_SetItemString(arm32OpcodesDict, "VABA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VABA));
        xPyDict_SetItemString(arm32OpcodesDict, "VABDL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VABDL));
        xPyDict_SetItemString(arm32OpcodesDict, "VABD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VABD));
        xPyDict_SetItemString(arm32OpcodesDict, "VABS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VABS));
        xPyDict_SetItemString(arm32OpcodesDict, "VACGE", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VACGE));
        xPyDict_SetItemString(arm32OpcodesDict, "VACGT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VACGT));
        xPyDict_SetItemString(arm32OpcodesDict, "VADD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VADD));
        xPyDict_SetItemString(arm32OpcodesDict, "VADDHN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VADDHN));
        xPyDict_SetItemString(arm32OpcodesDict, "VADDL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VADDL));
        xPyDict_SetItemString(arm32OpcodesDict, "VADDW", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VADDW));
        xPyDict_SetItemString(arm32OpcodesDict, "VAND", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VAND));
        xPyDict_SetItemString(arm32OpcodesDict, "VBIC", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VBIC));
        xPyDict_SetItemString(arm32OpcodesDict, "VBIF", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VBIF));
        xPyDict_SetItemString(arm32OpcodesDict, "VBIT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VBIT));
        xPyDict_SetItemString(arm32OpcodesDict, "VBSL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VBSL));
        xPyDict_SetItemString(arm32OpcodesDict, "VCEQ", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCEQ));
        xPyDict_SetItemString(arm32OpcodesDict, "VCGE", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCGE));
        xPyDict_SetItemString(arm32OpcodesDict, "VCGT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCGT));
        xPyDict_SetItemString(arm32OpcodesDict, "VCLE", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCLE));
        xPyDict_SetItemString(arm32OpcodesDict, "VCLS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCLS));
        xPyDict_SetItemString(arm32OpcodesDict, "VCLT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCLT));
        xPyDict_SetItemString(arm32OpcodesDict, "VCLZ", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCLZ));
        xPyDict_SetItemString(arm32OpcodesDict, "VCMP", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCMP));
        xPyDict_SetItemString(arm32OpcodesDict, "VCMPE", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCMPE));
        xPyDict_SetItemString(arm32OpcodesDict, "VCNT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCNT));
        xPyDict_SetItemString(arm32OpcodesDict, "VCVTA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCVTA));
        xPyDict_SetItemString(arm32OpcodesDict, "VCVTB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCVTB));
        xPyDict_SetItemString(arm32OpcodesDict, "VCVT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCVT));
        xPyDict_SetItemString(arm32OpcodesDict, "VCVTM", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCVTM));
        xPyDict_SetItemString(arm32OpcodesDict, "VCVTN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCVTN));
        xPyDict_SetItemString(arm32OpcodesDict, "VCVTP", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCVTP));
        xPyDict_SetItemString(arm32OpcodesDict, "VCVTT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCVTT));
        xPyDict_SetItemString(arm32OpcodesDict, "VDIV", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VDIV));
        xPyDict_SetItemString(arm32OpcodesDict, "VDUP", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VDUP));
        xPyDict_SetItemString(arm32OpcodesDict, "VEOR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VEOR));
        xPyDict_SetItemString(arm32OpcodesDict, "VEXT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VEXT));
        xPyDict_SetItemString(arm32OpcodesDict, "VFMA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VFMA));
        xPyDict_SetItemString(arm32OpcodesDict, "VFMS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VFMS));
        xPyDict_SetItemString(arm32OpcodesDict, "VFNMA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VFNMA));
        xPyDict_SetItemString(arm32OpcodesDict, "VFNMS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VFNMS));
        xPyDict_SetItemString(arm32OpcodesDict, "VHADD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VHADD));
        xPyDict_SetItemString(arm32OpcodesDict, "VHSUB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VHSUB));
        xPyDict_SetItemString(arm32OpcodesDict, "VLD1", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VLD1));
        xPyDict_SetItemString(arm32OpcodesDict, "VLD2", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VLD2));
        xPyDict_SetItemString(arm32OpcodesDict, "VLD3", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VLD3));
        xPyDict_SetItemString(arm32OpcodesDict, "VLD4", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VLD4));
        xPyDict_SetItemString(arm32OpcodesDict, "VLDMDB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VLDMDB));
        xPyDict_SetItemString(arm32OpcodesDict, "VLDMIA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VLDMIA));
        xPyDict_SetItemString(arm32OpcodesDict, "VLDR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VLDR));
        xPyDict_SetItemString(arm32OpcodesDict, "VMAXNM", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMAXNM));
        xPyDict_SetItemString(arm32OpcodesDict, "VMAX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMAX));
        xPyDict_SetItemString(arm32OpcodesDict, "VMINNM", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMINNM));
        xPyDict_SetItemString(arm32OpcodesDict, "VMIN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMIN));
        xPyDict_SetItemString(arm32OpcodesDict, "VMLA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMLA));
        xPyDict_SetItemString(arm32OpcodesDict, "VMLAL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMLAL));
        xPyDict_SetItemString(arm32OpcodesDict, "VMLS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMLS));
        xPyDict_SetItemString(arm32OpcodesDict, "VMLSL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMLSL));
        xPyDict_SetItemString(arm32OpcodesDict, "VMOVL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMOVL));
        xPyDict_SetItemString(arm32OpcodesDict, "VMOVN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMOVN));
        xPyDict_SetItemString(arm32OpcodesDict, "VMSR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMSR));
        xPyDict_SetItemString(arm32OpcodesDict, "VMUL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMUL));
        xPyDict_SetItemString(arm32OpcodesDict, "VMULL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMULL));
        xPyDict_SetItemString(arm32OpcodesDict, "VMVN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VMVN));
        xPyDict_SetItemString(arm32OpcodesDict, "VNEG", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VNEG));
        xPyDict_SetItemString(arm32OpcodesDict, "VNMLA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VNMLA));
        xPyDict_SetItemString(arm32OpcodesDict, "VNMLS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VNMLS));
        xPyDict_SetItemString(arm32OpcodesDict, "VNMUL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VNMUL));
        xPyDict_SetItemString(arm32OpcodesDict, "VORN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VORN));
        xPyDict_SetItemString(arm32OpcodesDict, "VORR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VORR));
        xPyDict_SetItemString(arm32OpcodesDict, "VPADAL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VPADAL));
        xPyDict_SetItemString(arm32OpcodesDict, "VPADDL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VPADDL));
        xPyDict_SetItemString(arm32OpcodesDict, "VPADD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VPADD));
        xPyDict_SetItemString(arm32OpcodesDict, "VPMAX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VPMAX));
        xPyDict_SetItemString(arm32OpcodesDict, "VPMIN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VPMIN));
        xPyDict_SetItemString(arm32OpcodesDict, "VQABS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQABS));
        xPyDict_SetItemString(arm32OpcodesDict, "VQADD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQADD));
        xPyDict_SetItemString(arm32OpcodesDict, "VQDMLAL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQDMLAL));
        xPyDict_SetItemString(arm32OpcodesDict, "VQDMLSL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQDMLSL));
        xPyDict_SetItemString(arm32OpcodesDict, "VQDMULH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQDMULH));
        xPyDict_SetItemString(arm32OpcodesDict, "VQDMULL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQDMULL));
        xPyDict_SetItemString(arm32OpcodesDict, "VQMOVUN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQMOVUN));
        xPyDict_SetItemString(arm32OpcodesDict, "VQMOVN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQMOVN));
        xPyDict_SetItemString(arm32OpcodesDict, "VQNEG", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQNEG));
        xPyDict_SetItemString(arm32OpcodesDict, "VQRDMULH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQRDMULH));
        xPyDict_SetItemString(arm32OpcodesDict, "VQRSHL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQRSHL));
        xPyDict_SetItemString(arm32OpcodesDict, "VQRSHRN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQRSHRN));
        xPyDict_SetItemString(arm32OpcodesDict, "VQRSHRUN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQRSHRUN));
        xPyDict_SetItemString(arm32OpcodesDict, "VQSHL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQSHL));
        xPyDict_SetItemString(arm32OpcodesDict, "VQSHLU", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQSHLU));
        xPyDict_SetItemString(arm32OpcodesDict, "VQSHRN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQSHRN));
        xPyDict_SetItemString(arm32OpcodesDict, "VQSHRUN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQSHRUN));
        xPyDict_SetItemString(arm32OpcodesDict, "VQSUB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VQSUB));
        xPyDict_SetItemString(arm32OpcodesDict, "VRADDHN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRADDHN));
        xPyDict_SetItemString(arm32OpcodesDict, "VRECPE", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRECPE));
        xPyDict_SetItemString(arm32OpcodesDict, "VRECPS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRECPS));
        xPyDict_SetItemString(arm32OpcodesDict, "VREV16", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VREV16));
        xPyDict_SetItemString(arm32OpcodesDict, "VREV32", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VREV32));
        xPyDict_SetItemString(arm32OpcodesDict, "VREV64", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VREV64));
        xPyDict_SetItemString(arm32OpcodesDict, "VRHADD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRHADD));
        xPyDict_SetItemString(arm32OpcodesDict, "VRINTA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRINTA));
        xPyDict_SetItemString(arm32OpcodesDict, "VRINTM", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRINTM));
        xPyDict_SetItemString(arm32OpcodesDict, "VRINTN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRINTN));
        xPyDict_SetItemString(arm32OpcodesDict, "VRINTP", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRINTP));
        xPyDict_SetItemString(arm32OpcodesDict, "VRINTR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRINTR));
        xPyDict_SetItemString(arm32OpcodesDict, "VRINTX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRINTX));
        xPyDict_SetItemString(arm32OpcodesDict, "VRINTZ", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRINTZ));
        xPyDict_SetItemString(arm32OpcodesDict, "VRSHL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRSHL));
        xPyDict_SetItemString(arm32OpcodesDict, "VRSHRN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRSHRN));
        xPyDict_SetItemString(arm32OpcodesDict, "VRSHR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRSHR));
        xPyDict_SetItemString(arm32OpcodesDict, "VRSQRTE", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRSQRTE));
        xPyDict_SetItemString(arm32OpcodesDict, "VRSQRTS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRSQRTS));
        xPyDict_SetItemString(arm32OpcodesDict, "VRSRA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRSRA));
        xPyDict_SetItemString(arm32OpcodesDict, "VRSUBHN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VRSUBHN));
        xPyDict_SetItemString(arm32OpcodesDict, "VSELEQ", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSELEQ));
        xPyDict_SetItemString(arm32OpcodesDict, "VSELGE", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSELGE));
        xPyDict_SetItemString(arm32OpcodesDict, "VSELGT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSELGT));
        xPyDict_SetItemString(arm32OpcodesDict, "VSELVS", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSELVS));
        xPyDict_SetItemString(arm32OpcodesDict, "VSHLL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSHLL));
        xPyDict_SetItemString(arm32OpcodesDict, "VSHL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSHL));
        xPyDict_SetItemString(arm32OpcodesDict, "VSHRN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSHRN));
        xPyDict_SetItemString(arm32OpcodesDict, "VSHR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSHR));
        xPyDict_SetItemString(arm32OpcodesDict, "VSLI", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSLI));
        xPyDict_SetItemString(arm32OpcodesDict, "VSQRT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSQRT));
        xPyDict_SetItemString(arm32OpcodesDict, "VSRA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSRA));
        xPyDict_SetItemString(arm32OpcodesDict, "VSRI", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSRI));
        xPyDict_SetItemString(arm32OpcodesDict, "VST1", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VST1));
        xPyDict_SetItemString(arm32OpcodesDict, "VST2", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VST2));
        xPyDict_SetItemString(arm32OpcodesDict, "VST3", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VST3));
        xPyDict_SetItemString(arm32OpcodesDict, "VST4", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VST4));
        xPyDict_SetItemString(arm32OpcodesDict, "VSTMDB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSTMDB));
        xPyDict_SetItemString(arm32OpcodesDict, "VSTMIA", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSTMIA));
        xPyDict_SetItemString(arm32OpcodesDict, "VSTR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSTR));
        xPyDict_SetItemString(arm32OpcodesDict, "VSUB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSUB));
        xPyDict_SetItemString(arm32OpcodesDict, "VSUBHN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSUBHN));
        xPyDict_SetItemString(arm32OpcodesDict, "VSUBL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSUBL));
        xPyDict_SetItemString(arm32OpcodesDict, "VSUBW", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSUBW));
        xPyDict_SetItemString(arm32OpcodesDict, "VSWP", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VSWP));
        xPyDict_SetItemString(arm32OpcodesDict, "VTBL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VTBL));
        xPyDict_SetItemString(arm32OpcodesDict, "VTBX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VTBX));
        xPyDict_SetItemString(arm32OpcodesDict, "VCVTR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VCVTR));
        xPyDict_SetItemString(arm32OpcodesDict, "VTRN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VTRN));
        xPyDict_SetItemString(arm32OpcodesDict, "VTST", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VTST));
        xPyDict_SetItemString(arm32OpcodesDict, "VUZP", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VUZP));
        xPyDict_SetItemString(arm32OpcodesDict, "VZIP", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VZIP));
        xPyDict_SetItemString(arm32OpcodesDict, "ADDW", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_ADDW));
        xPyDict_SetItemString(arm32OpcodesDict, "ASR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_ASR));
        xPyDict_SetItemString(arm32OpcodesDict, "DCPS1", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_DCPS1));
        xPyDict_SetItemString(arm32OpcodesDict, "DCPS2", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_DCPS2));
        xPyDict_SetItemString(arm32OpcodesDict, "DCPS3", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_DCPS3));
        xPyDict_SetItemString(arm32OpcodesDict, "IT", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_IT));
        xPyDict_SetItemString(arm32OpcodesDict, "LSL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LSL));
        xPyDict_SetItemString(arm32OpcodesDict, "LSR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_LSR));
        xPyDict_SetItemString(arm32OpcodesDict, "ORN", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_ORN));
        xPyDict_SetItemString(arm32OpcodesDict, "ROR", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_ROR));
        xPyDict_SetItemString(arm32OpcodesDict, "RRX", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_RRX));
        xPyDict_SetItemString(arm32OpcodesDict, "SUBW", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SUBW));
        xPyDict_SetItemString(arm32OpcodesDict, "TBB", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_TBB));
        xPyDict_SetItemString(arm32OpcodesDict, "TBH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_TBH));
        xPyDict_SetItemString(arm32OpcodesDict, "CBNZ", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CBNZ));
        xPyDict_SetItemString(arm32OpcodesDict, "CBZ", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_CBZ));
        xPyDict_SetItemString(arm32OpcodesDict, "POP", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_POP));
        xPyDict_SetItemString(arm32OpcodesDict, "PUSH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_PUSH));
        xPyDict_SetItemString(arm32OpcodesDict, "NOP", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_NOP));
        xPyDict_SetItemString(arm32OpcodesDict, "YIELD", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_YIELD));
        xPyDict_SetItemString(arm32OpcodesDict, "WFE", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_WFE));
        xPyDict_SetItemString(arm32OpcodesDict, "WFI", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_WFI));
        xPyDict_SetItemString(arm32OpcodesDict, "SEV", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SEV));
        xPyDict_SetItemString(arm32OpcodesDict, "SEVL", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_SEVL));
        xPyDict_SetItemString(arm32OpcodesDict, "VPUSH", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VPUSH));
        xPyDict_SetItemString(arm32OpcodesDict, "VPOP", PyLong_FromUint32(triton::arch::arm::arm32::ID_INS_VPOP));

        PyObject* arm32OpcodesDictClass = xPyClass_New(nullptr, arm32OpcodesDict, xPyString_FromString("ARM32"));
        xPyDict_SetItemString(opcodesDict, "ARM32", arm32OpcodesDictClass);


        PyObject* riscv64OpcodesDict = xPyDict_New();

        xPyDict_SetItemString(riscv64OpcodesDict, "ADD",    PyLong_FromUint32(triton::arch::riscv::ID_INS_ADD));
        xPyDict_SetItemString(riscv64OpcodesDict, "ADDI",   PyLong_FromUint32(triton::arch::riscv::ID_INS_ADDI));
        xPyDict_SetItemString(riscv64OpcodesDict, "ADDIW",  PyLong_FromUint32(triton::arch::riscv::ID_INS_ADDIW));
        xPyDict_SetItemString(riscv64OpcodesDict, "ADDW",   PyLong_FromUint32(triton::arch::riscv::ID_INS_ADDW));
        xPyDict_SetItemString(riscv64OpcodesDict, "AND",    PyLong_FromUint32(triton::arch::riscv::ID_INS_AND));
        xPyDict_SetItemString(riscv64OpcodesDict, "ANDI",   PyLong_FromUint32(triton::arch::riscv::ID_INS_ANDI));
        xPyDict_SetItemString(riscv64OpcodesDict, "AND",    PyLong_FromUint32(triton::arch::riscv::ID_INS_AND));
        xPyDict_SetItemString(riscv64OpcodesDict, "AUIPC",  PyLong_FromUint32(triton::arch::riscv::ID_INS_AUIPC));
        xPyDict_SetItemString(riscv64OpcodesDict, "BEQ",    PyLong_FromUint32(triton::arch::riscv::ID_INS_BEQ));
        xPyDict_SetItemString(riscv64OpcodesDict, "BGE",    PyLong_FromUint32(triton::arch::riscv::ID_INS_BGE));
        xPyDict_SetItemString(riscv64OpcodesDict, "BGEU",   PyLong_FromUint32(triton::arch::riscv::ID_INS_BGEU));
        xPyDict_SetItemString(riscv64OpcodesDict, "BLT",    PyLong_FromUint32(triton::arch::riscv::ID_INS_BLT));
        xPyDict_SetItemString(riscv64OpcodesDict, "BLTU",   PyLong_FromUint32(triton::arch::riscv::ID_INS_BLTU));
        xPyDict_SetItemString(riscv64OpcodesDict, "BNE",    PyLong_FromUint32(triton::arch::riscv::ID_INS_BNE));
        xPyDict_SetItemString(riscv64OpcodesDict, "DIV",    PyLong_FromUint32(triton::arch::riscv::ID_INS_DIV));
        xPyDict_SetItemString(riscv64OpcodesDict, "DIVU",   PyLong_FromUint32(triton::arch::riscv::ID_INS_DIVU));
        xPyDict_SetItemString(riscv64OpcodesDict, "DIVUW",  PyLong_FromUint32(triton::arch::riscv::ID_INS_DIVUW));
        xPyDict_SetItemString(riscv64OpcodesDict, "DIVW",   PyLong_FromUint32(triton::arch::riscv::ID_INS_DIVW));
        xPyDict_SetItemString(riscv64OpcodesDict, "JAL",    PyLong_FromUint32(triton::arch::riscv::ID_INS_JAL));
        xPyDict_SetItemString(riscv64OpcodesDict, "JALR",   PyLong_FromUint32(triton::arch::riscv::ID_INS_JALR));
        xPyDict_SetItemString(riscv64OpcodesDict, "LB",     PyLong_FromUint32(triton::arch::riscv::ID_INS_LB));
        xPyDict_SetItemString(riscv64OpcodesDict, "LBU",    PyLong_FromUint32(triton::arch::riscv::ID_INS_LBU));
        xPyDict_SetItemString(riscv64OpcodesDict, "LD",     PyLong_FromUint32(triton::arch::riscv::ID_INS_LD));
        xPyDict_SetItemString(riscv64OpcodesDict, "LH",     PyLong_FromUint32(triton::arch::riscv::ID_INS_LH));
        xPyDict_SetItemString(riscv64OpcodesDict, "LHU",    PyLong_FromUint32(triton::arch::riscv::ID_INS_LHU));
        xPyDict_SetItemString(riscv64OpcodesDict, "LUI",    PyLong_FromUint32(triton::arch::riscv::ID_INS_LUI));
        xPyDict_SetItemString(riscv64OpcodesDict, "LW",     PyLong_FromUint32(triton::arch::riscv::ID_INS_LW));
        xPyDict_SetItemString(riscv64OpcodesDict, "LWU",    PyLong_FromUint32(triton::arch::riscv::ID_INS_LWU));
        xPyDict_SetItemString(riscv64OpcodesDict, "MUL",    PyLong_FromUint32(triton::arch::riscv::ID_INS_MUL));
        xPyDict_SetItemString(riscv64OpcodesDict, "MULH ",  PyLong_FromUint32(triton::arch::riscv::ID_INS_MULH));
        xPyDict_SetItemString(riscv64OpcodesDict, "MULHSU", PyLong_FromUint32(triton::arch::riscv::ID_INS_MULHSU));
        xPyDict_SetItemString(riscv64OpcodesDict, "MULHU",  PyLong_FromUint32(triton::arch::riscv::ID_INS_MULHU));
        xPyDict_SetItemString(riscv64OpcodesDict, "MULW",   PyLong_FromUint32(triton::arch::riscv::ID_INS_MULW));
        xPyDict_SetItemString(riscv64OpcodesDict, "OR",     PyLong_FromUint32(triton::arch::riscv::ID_INS_OR));
        xPyDict_SetItemString(riscv64OpcodesDict, "ORI",    PyLong_FromUint32(triton::arch::riscv::ID_INS_ORI));
        xPyDict_SetItemString(riscv64OpcodesDict, "REM",    PyLong_FromUint32(triton::arch::riscv::ID_INS_REM));
        xPyDict_SetItemString(riscv64OpcodesDict, "REMU",   PyLong_FromUint32(triton::arch::riscv::ID_INS_REMU));
        xPyDict_SetItemString(riscv64OpcodesDict, "REMUW",  PyLong_FromUint32(triton::arch::riscv::ID_INS_REMUW));
        xPyDict_SetItemString(riscv64OpcodesDict, "REMW",   PyLong_FromUint32(triton::arch::riscv::ID_INS_REMW));
        xPyDict_SetItemString(riscv64OpcodesDict, "SB",     PyLong_FromUint32(triton::arch::riscv::ID_INS_SB));
        xPyDict_SetItemString(riscv64OpcodesDict, "SD",     PyLong_FromUint32(triton::arch::riscv::ID_INS_SD));
        xPyDict_SetItemString(riscv64OpcodesDict, "SH",     PyLong_FromUint32(triton::arch::riscv::ID_INS_SH));
        xPyDict_SetItemString(riscv64OpcodesDict, "SLL",    PyLong_FromUint32(triton::arch::riscv::ID_INS_SLL));
        xPyDict_SetItemString(riscv64OpcodesDict, "SLLI",   PyLong_FromUint32(triton::arch::riscv::ID_INS_SLLI));
        xPyDict_SetItemString(riscv64OpcodesDict, "SLLIW",  PyLong_FromUint32(triton::arch::riscv::ID_INS_SLLIW));
        xPyDict_SetItemString(riscv64OpcodesDict, "SLLW",   PyLong_FromUint32(triton::arch::riscv::ID_INS_SLLW));
        xPyDict_SetItemString(riscv64OpcodesDict, "SLT",    PyLong_FromUint32(triton::arch::riscv::ID_INS_SLT));
        xPyDict_SetItemString(riscv64OpcodesDict, "SLTI",   PyLong_FromUint32(triton::arch::riscv::ID_INS_SLTI));
        xPyDict_SetItemString(riscv64OpcodesDict, "SLTIU",  PyLong_FromUint32(triton::arch::riscv::ID_INS_SLTIU));
        xPyDict_SetItemString(riscv64OpcodesDict, "SLTU",   PyLong_FromUint32(triton::arch::riscv::ID_INS_SLTU));
        xPyDict_SetItemString(riscv64OpcodesDict, "SRA",    PyLong_FromUint32(triton::arch::riscv::ID_INS_SRA));
        xPyDict_SetItemString(riscv64OpcodesDict, "SRAI",   PyLong_FromUint32(triton::arch::riscv::ID_INS_SRAI));
        xPyDict_SetItemString(riscv64OpcodesDict, "SRAIW",  PyLong_FromUint32(triton::arch::riscv::ID_INS_SRAIW));
        xPyDict_SetItemString(riscv64OpcodesDict, "SRAW",   PyLong_FromUint32(triton::arch::riscv::ID_INS_SRAW));
        xPyDict_SetItemString(riscv64OpcodesDict, "SRL",    PyLong_FromUint32(triton::arch::riscv::ID_INS_SRL));
        xPyDict_SetItemString(riscv64OpcodesDict, "SRLI",   PyLong_FromUint32(triton::arch::riscv::ID_INS_SRLI));
        xPyDict_SetItemString(riscv64OpcodesDict, "SRLIW",  PyLong_FromUint32(triton::arch::riscv::ID_INS_SRLIW));
        xPyDict_SetItemString(riscv64OpcodesDict, "SRLW",   PyLong_FromUint32(triton::arch::riscv::ID_INS_SRLW));
        xPyDict_SetItemString(riscv64OpcodesDict, "SUB",    PyLong_FromUint32(triton::arch::riscv::ID_INS_SUB));
        xPyDict_SetItemString(riscv64OpcodesDict, "SUBW",   PyLong_FromUint32(triton::arch::riscv::ID_INS_SUBW));
        xPyDict_SetItemString(riscv64OpcodesDict, "SW",     PyLong_FromUint32(triton::arch::riscv::ID_INS_SW));
        xPyDict_SetItemString(riscv64OpcodesDict, "XOR",    PyLong_FromUint32(triton::arch::riscv::ID_INS_XOR));
        xPyDict_SetItemString(riscv64OpcodesDict, "XORI",   PyLong_FromUint32(triton::arch::riscv::ID_INS_XORI));

        xPyDict_SetItemString(riscv64OpcodesDict, "C_ADD",      PyLong_FromUint32(triton::arch::riscv::ID_INS_C_ADD));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_ADDI",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_ADDI));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_ADDI16SP", PyLong_FromUint32(triton::arch::riscv::ID_INS_C_ADDI16SP));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_ADDI4SPN", PyLong_FromUint32(triton::arch::riscv::ID_INS_C_ADDI4SPN));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_ADDIW",    PyLong_FromUint32(triton::arch::riscv::ID_INS_C_ADDIW));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_ADDW",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_ADDW));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_AND",      PyLong_FromUint32(triton::arch::riscv::ID_INS_C_AND));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_ANDI",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_ANDI));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_BEQZ",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_BEQZ));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_BNEZ",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_BNEZ));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_J",        PyLong_FromUint32(triton::arch::riscv::ID_INS_C_J));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_JALR",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_JALR));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_JR",       PyLong_FromUint32(triton::arch::riscv::ID_INS_C_JR));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_LD",       PyLong_FromUint32(triton::arch::riscv::ID_INS_C_LD));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_LDSP",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_LDSP));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_LI",       PyLong_FromUint32(triton::arch::riscv::ID_INS_C_LI));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_LUI",      PyLong_FromUint32(triton::arch::riscv::ID_INS_C_LUI));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_LW",       PyLong_FromUint32(triton::arch::riscv::ID_INS_C_LW));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_LWSP",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_LWSP));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_MV",       PyLong_FromUint32(triton::arch::riscv::ID_INS_C_MV));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_NOP ",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_NOP));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_OR",       PyLong_FromUint32(triton::arch::riscv::ID_INS_C_OR));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_SD",       PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SD));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_SDSP",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SDSP));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_SLLI",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SLLI));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_SRAI",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SRAI));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_SRLI",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SRLI));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_SUB",      PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SUB));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_SUBW",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SUBW));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_SW",       PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SW));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_SWSP",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SWSP));
        xPyDict_SetItemString(riscv64OpcodesDict, "C_XOR",      PyLong_FromUint32(triton::arch::riscv::ID_INS_C_XOR));

        PyObject* riscv64OpcodesDictClass = xPyClass_New(nullptr, riscv64OpcodesDict, xPyString_FromString("RV64"));
        xPyDict_SetItemString(opcodesDict, "RV64", riscv64OpcodesDictClass);


        PyObject* riscv32OpcodesDict = xPyDict_New();

        xPyDict_SetItemString(riscv32OpcodesDict, "ADD",    PyLong_FromUint32(triton::arch::riscv::ID_INS_ADD));
        xPyDict_SetItemString(riscv32OpcodesDict, "ADDI",   PyLong_FromUint32(triton::arch::riscv::ID_INS_ADDI));
        xPyDict_SetItemString(riscv32OpcodesDict, "AND",    PyLong_FromUint32(triton::arch::riscv::ID_INS_AND));
        xPyDict_SetItemString(riscv32OpcodesDict, "ANDI",   PyLong_FromUint32(triton::arch::riscv::ID_INS_ANDI));
        xPyDict_SetItemString(riscv32OpcodesDict, "AND",    PyLong_FromUint32(triton::arch::riscv::ID_INS_AND));
        xPyDict_SetItemString(riscv32OpcodesDict, "AUIPC",  PyLong_FromUint32(triton::arch::riscv::ID_INS_AUIPC));
        xPyDict_SetItemString(riscv32OpcodesDict, "BEQ",    PyLong_FromUint32(triton::arch::riscv::ID_INS_BEQ));
        xPyDict_SetItemString(riscv32OpcodesDict, "BGE",    PyLong_FromUint32(triton::arch::riscv::ID_INS_BGE));
        xPyDict_SetItemString(riscv32OpcodesDict, "BGEU",   PyLong_FromUint32(triton::arch::riscv::ID_INS_BGEU));
        xPyDict_SetItemString(riscv32OpcodesDict, "BLT",    PyLong_FromUint32(triton::arch::riscv::ID_INS_BLT));
        xPyDict_SetItemString(riscv32OpcodesDict, "BLTU",   PyLong_FromUint32(triton::arch::riscv::ID_INS_BLTU));
        xPyDict_SetItemString(riscv32OpcodesDict, "BNE",    PyLong_FromUint32(triton::arch::riscv::ID_INS_BNE));
        xPyDict_SetItemString(riscv32OpcodesDict, "DIV",    PyLong_FromUint32(triton::arch::riscv::ID_INS_DIV));
        xPyDict_SetItemString(riscv32OpcodesDict, "DIVU",   PyLong_FromUint32(triton::arch::riscv::ID_INS_DIVU));
        xPyDict_SetItemString(riscv32OpcodesDict, "JAL",    PyLong_FromUint32(triton::arch::riscv::ID_INS_JAL));
        xPyDict_SetItemString(riscv32OpcodesDict, "JALR",   PyLong_FromUint32(triton::arch::riscv::ID_INS_JALR));
        xPyDict_SetItemString(riscv32OpcodesDict, "LB",     PyLong_FromUint32(triton::arch::riscv::ID_INS_LB));
        xPyDict_SetItemString(riscv32OpcodesDict, "LBU",    PyLong_FromUint32(triton::arch::riscv::ID_INS_LBU));
        xPyDict_SetItemString(riscv32OpcodesDict, "LD",     PyLong_FromUint32(triton::arch::riscv::ID_INS_LD));
        xPyDict_SetItemString(riscv32OpcodesDict, "LH",     PyLong_FromUint32(triton::arch::riscv::ID_INS_LH));
        xPyDict_SetItemString(riscv32OpcodesDict, "LHU",    PyLong_FromUint32(triton::arch::riscv::ID_INS_LHU));
        xPyDict_SetItemString(riscv32OpcodesDict, "LUI",    PyLong_FromUint32(triton::arch::riscv::ID_INS_LUI));
        xPyDict_SetItemString(riscv32OpcodesDict, "LW",     PyLong_FromUint32(triton::arch::riscv::ID_INS_LW));
        xPyDict_SetItemString(riscv32OpcodesDict, "MUL",    PyLong_FromUint32(triton::arch::riscv::ID_INS_MUL));
        xPyDict_SetItemString(riscv32OpcodesDict, "MULH ",  PyLong_FromUint32(triton::arch::riscv::ID_INS_MULH));
        xPyDict_SetItemString(riscv32OpcodesDict, "MULHSU", PyLong_FromUint32(triton::arch::riscv::ID_INS_MULHSU));
        xPyDict_SetItemString(riscv32OpcodesDict, "MULHU",  PyLong_FromUint32(triton::arch::riscv::ID_INS_MULHU));
        xPyDict_SetItemString(riscv32OpcodesDict, "OR",     PyLong_FromUint32(triton::arch::riscv::ID_INS_OR));
        xPyDict_SetItemString(riscv32OpcodesDict, "ORI",    PyLong_FromUint32(triton::arch::riscv::ID_INS_ORI));
        xPyDict_SetItemString(riscv32OpcodesDict, "REM",    PyLong_FromUint32(triton::arch::riscv::ID_INS_REM));
        xPyDict_SetItemString(riscv32OpcodesDict, "REMU",   PyLong_FromUint32(triton::arch::riscv::ID_INS_REMU));
        xPyDict_SetItemString(riscv32OpcodesDict, "SB",     PyLong_FromUint32(triton::arch::riscv::ID_INS_SB));
        xPyDict_SetItemString(riscv32OpcodesDict, "SH",     PyLong_FromUint32(triton::arch::riscv::ID_INS_SH));
        xPyDict_SetItemString(riscv32OpcodesDict, "SLL",    PyLong_FromUint32(triton::arch::riscv::ID_INS_SLL));
        xPyDict_SetItemString(riscv32OpcodesDict, "SLLI",   PyLong_FromUint32(triton::arch::riscv::ID_INS_SLLI));
        xPyDict_SetItemString(riscv32OpcodesDict, "SLT",    PyLong_FromUint32(triton::arch::riscv::ID_INS_SLT));
        xPyDict_SetItemString(riscv32OpcodesDict, "SLTI",   PyLong_FromUint32(triton::arch::riscv::ID_INS_SLTI));
        xPyDict_SetItemString(riscv32OpcodesDict, "SLTIU",  PyLong_FromUint32(triton::arch::riscv::ID_INS_SLTIU));
        xPyDict_SetItemString(riscv32OpcodesDict, "SLTU",   PyLong_FromUint32(triton::arch::riscv::ID_INS_SLTU));
        xPyDict_SetItemString(riscv32OpcodesDict, "SRA",    PyLong_FromUint32(triton::arch::riscv::ID_INS_SRA));
        xPyDict_SetItemString(riscv32OpcodesDict, "SRAI",   PyLong_FromUint32(triton::arch::riscv::ID_INS_SRAI));
        xPyDict_SetItemString(riscv32OpcodesDict, "SRL",    PyLong_FromUint32(triton::arch::riscv::ID_INS_SRL));
        xPyDict_SetItemString(riscv32OpcodesDict, "SRLI",   PyLong_FromUint32(triton::arch::riscv::ID_INS_SRLI));
        xPyDict_SetItemString(riscv32OpcodesDict, "SUB",    PyLong_FromUint32(triton::arch::riscv::ID_INS_SUB));
        xPyDict_SetItemString(riscv32OpcodesDict, "SW",     PyLong_FromUint32(triton::arch::riscv::ID_INS_SW));
        xPyDict_SetItemString(riscv32OpcodesDict, "XOR",    PyLong_FromUint32(triton::arch::riscv::ID_INS_XOR));
        xPyDict_SetItemString(riscv32OpcodesDict, "XORI",   PyLong_FromUint32(triton::arch::riscv::ID_INS_XORI));

        xPyDict_SetItemString(riscv32OpcodesDict, "C_ADD",      PyLong_FromUint32(triton::arch::riscv::ID_INS_C_ADD));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_ADDI",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_ADDI));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_ADDI16SP", PyLong_FromUint32(triton::arch::riscv::ID_INS_C_ADDI16SP));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_ADDI4SPN", PyLong_FromUint32(triton::arch::riscv::ID_INS_C_ADDI4SPN));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_AND",      PyLong_FromUint32(triton::arch::riscv::ID_INS_C_AND));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_ANDI",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_ANDI));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_BEQZ",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_BEQZ));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_BNEZ",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_BNEZ));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_J",        PyLong_FromUint32(triton::arch::riscv::ID_INS_C_J));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_JAL",      PyLong_FromUint32(triton::arch::riscv::ID_INS_C_JAL));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_JALR",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_JALR));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_JR",       PyLong_FromUint32(triton::arch::riscv::ID_INS_C_JR));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_LI",       PyLong_FromUint32(triton::arch::riscv::ID_INS_C_LI));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_LUI",      PyLong_FromUint32(triton::arch::riscv::ID_INS_C_LUI));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_LW",       PyLong_FromUint32(triton::arch::riscv::ID_INS_C_LW));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_LWSP",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_LWSP));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_MV",       PyLong_FromUint32(triton::arch::riscv::ID_INS_C_MV));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_NOP ",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_NOP));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_OR",       PyLong_FromUint32(triton::arch::riscv::ID_INS_C_OR));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_SLLI",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SLLI));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_SRAI",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SRAI));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_SRLI",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SRLI));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_SUB",      PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SUB));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_SW",       PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SW));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_SWSP",     PyLong_FromUint32(triton::arch::riscv::ID_INS_C_SWSP));
        xPyDict_SetItemString(riscv32OpcodesDict, "C_XOR",      PyLong_FromUint32(triton::arch::riscv::ID_INS_C_XOR));

        PyObject* riscv32OpcodesDictClass = xPyClass_New(nullptr, riscv32OpcodesDict, xPyString_FromString("RV32"));
        xPyDict_SetItemString(opcodesDict, "RV32", riscv32OpcodesDictClass);
      }

    }; /* python namespace */
  }; /* bindings namespace */
}; /* triton namespace */
