# CSES Solutions

Over 280 accepted solutions to the [CSES Problem Set](https://cses.fi/problemset/), written in C++ by Jonathan Uy [(nulltype)](https://cses.fi/user/22919). As of December 23th, the following number of solutions have been completed:

| Problem Type          | Number Solved |
|-----------------------|:-------------:|
| Introductory Problems |     19/19     |
| Sorting and Searching |     35/35     |
| Dynamic Programming   |     19/19     |
| Graph Algorithms      |     36/36     |
| Range Queries         |     19/19     |
| Tree Algorithms       |     16/16     |
| Mathematics           |     31/31     |
| String Algorithms     |     17/17     |
| Geometry              |      7/7      |
| Advanced Techniques   |     24/24     |
| Additional Problems   |     65/77     |
| **Total**             |  **288/300**  |

# Table of Contents

## Introductory Problems
1. [Weird Algorithm](/Introductory%20Problems/Weird%20Algorithm.cpp)
1. [Missing Number](/Introductory%20Problems/Missing%20Number.cpp)
1. [Repetitions](/Introductory%20Problems/Repetitions.cpp)
1. [Increasing Array](/Introductory%20Problems/Increasing%20Array.cpp)
1. [Permutations](/Introductory%20Problems/Permutations%20I.cpp)
1. [Number Spiral](/Introductory%20Problems/Number%20Spiral.cpp)
1. [Two Knights](/Introductory%20Problems/Two%20Knights.cpp)
1. [Two Sets](/Introductory%20Problems/Two%20Sets%20I.cpp)
1. [Bit Strings](/Introductory%20Problems/Bit%20Strings.cpp)
1. [Trailing Zeros](/Introductory%20Problems/Trailing%20Zeros.cpp)
1. [Coin Piles](/Introductory%20Problems/Coin%20Piles.cpp)
1. [Palindrome Reorder](/Introductory%20Problems/Palindrome%20Reorder.cpp)
1. [Gray Code](/Introductory%20Problems/Gray%20Code.cpp)
1. [Tower of Hanoi](/Introductory%20Problems/Tower%20of%20Hanoi.cpp)
1. [Creating Strings](/Introductory%20Problems/Creating%20Strings%20I.cpp)
1. [Apple Division](/Introductory%20Problems/Apple%20Division.cpp)
1. [Chessboard and Queens](/Introductory%20Problems/Chessboard%20and%20Queens.cpp)
1. [Digit Queries](/Introductory%20Problems/Digit%20Queries.cpp)
1. [Grid Paths](/Introductory%20Problems/Grid%20Paths%20I.cpp)

## Sorting and Searching
1. [Distinct Numbers](/Sorting%20and%20Searching/Distinct%20Numbers.cpp)
1. [Apartments](/Sorting%20and%20Searching/Apartments.cpp)
1. [Ferris Wheel](/Sorting%20and%20Searching/Ferris%20Wheel.cpp)
1. [Concert Tickets](/Sorting%20and%20Searching/Concert%20Tickets.cpp)
1. [Restaurant Customers](/Sorting%20and%20Searching/Restaurant%20Customers.cpp)
1. [Movie Festival](/Sorting%20and%20Searching/Movie%20Festival%20I.cpp)
1. [Sum of Two Values](/Sorting%20and%20Searching/Sum%20of%20Two%20Values.cpp)
1. [Maximum Subarray Sum](/Sorting%20and%20Searching/Maximum%20Subarray%20Sum%20I.cpp)
1. [Stick Lengths](/Sorting%20and%20Searching/Stick%20Lengths.cpp)
1. [Missing Coin Sum](/Sorting%20and%20Searching/Missing%20Coin%20Sum.cpp)
1. [Collecting Numbers](/Sorting%20and%20Searching/Collecting%20Numbers%20I.cpp)
1. [Collecting Numbers II](/Sorting%20and%20Searching/Collecting%20Numbers%20II.cpp)
1. [Playlist](/Sorting%20and%20Searching/Playlist.cpp)
1. [Towers](/Sorting%20and%20Searching/Towers.cpp)
1. [Traffic Lights](/Sorting%20and%20Searching/Traffic%20Lights.cpp)
1. [Josephus Problem I](/Sorting%20and%20Searching/Josephus%20Problem%20I.cpp)
1. [Josephus Problem II](/Sorting%20and%20Searching/Josephus%20Problem%20II.cpp)
1. [Nested Ranges Check](/Sorting%20and%20Searching/Nested%20Ranges%20Check.cpp)
1. [Nested Ranges Count](/Sorting%20and%20Searching/Nested%20Ranges%20Count.cpp)
1. [Room Allocation](/Sorting%20and%20Searching/Room%20Allocation.cpp)
1. [Factory Machines](/Sorting%20and%20Searching/Factory%20Machines.cpp)
1. [Tasks and Deadlines](/Sorting%20and%20Searching/Tasks%20and%20Deadlines.cpp)
1. [Reading Books](/Sorting%20and%20Searching/Reading%20Books.cpp)
1. [Sum of Three Values](/Sorting%20and%20Searching/Sum%20of%20Three%20Values.cpp)
1. [Sum of Four Values](/Sorting%20and%20Searching/Sum%20of%20Four%20Values.cpp)
1. [Nearest Smaller Values](/Sorting%20and%20Searching/Nearest%20Smaller%20Values.cpp)
1. [Subarray Sums I](/Sorting%20and%20Searching/Subarray%20Sums%20I.cpp)
1. [Subarray Sums II](/Sorting%20and%20Searching/Subarray%20Sums%20II.cpp)
1. [Subarray Divisibility](/Sorting%20and%20Searching/Subarray%20Divisibility.cpp)
1. [Subarray Distinct Values](/Sorting%20and%20Searching/Subarray%20Distinct%20Values.cpp)
1. [Array Division](/Sorting%20and%20Searching/Array%20Division.cpp)
1. [Sliding Median](/Sorting%20and%20Searching/Sliding%20Median.cpp)
1. [Sliding Cost](/Sorting%20and%20Searching/Sliding%20Cost.cpp)
1. [Movie Festival II](/Sorting%20and%20Searching/Movie%20Festival%20II.cpp)
1. [Maximum Subarray Sum II](/Sorting%20and%20Searching/Maximum%20Subarray%20Sum%20II.cpp)

## Dynamic Programming

1. [Dice Combinations](/Dynamic%20Programming/Dice%20Combinations.cpp)
1. [Minimizing Coins](/Dynamic%20Programming/Minimizing%20Coins.cpp)
1. [Coin Combinations I](/Dynamic%20Programming/Coin%20Combinations%20I.cpp)
1. [Coin Combinations II](/Dynamic%20Programming/Coin%20Combinations%20II.cpp)
1. [Removing Digits](/Dynamic%20Programming/Removing%20Digits%20I.cpp)
1. [Grid Paths](/Dynamic%20Programming/Grid%20Paths%20II.cpp)
1. [Book Shop](/Dynamic%20Programming/Book%20Shop%20I.cpp)
1. [Array Description](/Dynamic%20Programming/Array%20Description.cpp)
1. [Counting Towers](/Dynamic%20Programming/Counting%20Towers.cpp)
1. [Edit Distance](/Dynamic%20Programming/Edit%20Distance.cpp)
1. [Rectangle Cutting](/Dynamic%20Programming/Rectangle%20Cutting.cpp)
1. [Money Sums](/Dynamic%20Programming/Money%20Sums.cpp)
1. [Removal Game](/Dynamic%20Programming/Removal%20Game.cpp)
1. [Two Sets II](/Dynamic%20Programming/Two%20Sets%20II.cpp)
1. [Increasing Subsequence](/Dynamic%20Programming/Increasing%20Subsequence.cpp)
1. [Projects](/Dynamic%20Programming/Projects.cpp)
1. [Elevator Rides](/Dynamic%20Programming/Elevator%20Rides.cpp)
1. [Counting Tilings](/Dynamic%20Programming/Counting%20Tilings.cpp)
1. [Counting Numbers](/Dynamic%20Programming/Counting%20Numbers.cpp)

## Graph Algorithms

1. [Counting Rooms](/Graph%20Algorithms/Counting%20Rooms.cpp)
1. [Labyrinth](/Graph%20Algorithms/Labyrinth.cpp)
1. [Building Roads](/Graph%20Algorithms/Building%20Roads.cpp)
1. [Message Route](/Graph%20Algorithms/Message%20Route.cpp)
1. [Building Teams](/Graph%20Algorithms/Building%20Teams.cpp)
1. [Round Trip](/Graph%20Algorithms/Round%20Trip%20I.cpp)
1. [Monsters](/Graph%20Algorithms/Monsters.cpp)
1. [Shortest Routes I](/Graph%20Algorithms/Shortest%20Routes%20I.cpp)
1. [Shortest Routes II](/Graph%20Algorithms/Shortest%20Routes%20II.cpp)
1. [High Score](/Graph%20Algorithms/High%20Score.cpp)
1. [Flight Discount](/Graph%20Algorithms/Flight%20Discount.cpp)
1. [Cycle Finding](/Graph%20Algorithms/Cycle%20Finding.cpp)
1. [Flight Routes](/Graph%20Algorithms/Flight%20Routes.cpp)
1. [Round Trip II](/Graph%20Algorithms/Round%20Trip%20II.cpp)
1. [Course Schedule](/Graph%20Algorithms/Course%20Schedule%20I.cpp)
1. [Longest Flight Route](/Graph%20Algorithms/Longest%20Flight%20Route.cpp)
1. [Game Routes](/Graph%20Algorithms/Game%20Routes.cpp)
1. [Investigation](/Graph%20Algorithms/Investigation.cpp)
1. [Planets Queries I](/Graph%20Algorithms/Planets%20Queries%20I.cpp)
1. [Planets Queries II](/Graph%20Algorithms/Planets%20Queries%20II.cpp)
1. [Planets Cycles](/Graph%20Algorithms/Planets%20Cycles.cpp)
1. [Road Reparation](/Graph%20Algorithms/Road%20Reparation.cpp)
1. [Road Construction](/Graph%20Algorithms/Road%20Construction.cpp)
1. [Flight Routes Check](/Graph%20Algorithms/Flight%20Routes%20Check.cpp)
1. [Planets and Kingdoms](/Graph%20Algorithms/Planets%20and%20Kingdoms.cpp)
1. [Giant Pizza](/Graph%20Algorithms/Giant%20Pizza.cpp)
1. [Coin Collector](/Graph%20Algorithms/Coin%20Collector.cpp)
1. [Mail Delivery](/Graph%20Algorithms/Mail%20Delivery.cpp)
1. [De Bruijn Sequence](/Graph%20Algorithms/De%20Bruijn%20Sequence.cpp)
1. [Teleporters Path](/Graph%20Algorithms/Teleporters%20Path.cpp)
1. [Hamiltonian Flights](/Graph%20Algorithms/Hamiltonian%20Flights.cpp)
1. [Knight's Tour](/Graph%20Algorithms/Knights%20Tour.cpp)
1. [Download Speed](/Graph%20Algorithms/Download%20Speed.cpp)
1. [Police Chase](/Graph%20Algorithms/Police%20Chase.cpp)
1. [School Dance](/Graph%20Algorithms/School%20Dance.cpp)
1. [Distinct Routes](/Graph%20Algorithms/Distinct%20Routes%20I.cpp)

## Range Queries

1. [Static Range Sum Queries](/Range%20Queries/Static%20Range%20Sum%20Queries.cpp)
1. [Static Range Minimum Queries](/Range%20Queries/Static%20Range%20Minimum%20Queries.cpp)
1. [Dynamic Range Sum Queries](/Range%20Queries/Dynamic%20Range%20Sum%20Queries.cpp)
1. [Dynamic Range Minimum Queries](/Range%20Queries/Dynamic%20Range%20Minimum%20Queries.cpp)
1. [Range Xor Queries](/Range%20Queries/Range%20Xor%20Queries.cpp)
1. [Range Update Queries](/Range%20Queries/Range%20Update%20Queries.cpp)
1. [Forest Queries](/Range%20Queries/Forest%20Queries%20I.cpp)
1. [Hotel Queries](/Range%20Queries/Hotel%20Queries.cpp)
1. [List Removals](/Range%20Queries/List%20Removals.cpp)
1. [Salary Queries](/Range%20Queries/Salary%20Queries.cpp)
1. [Prefix Sum Queries](/Range%20Queries/Prefix%20Sum%20Queries.cpp)
1. [Pizzeria Queries](/Range%20Queries/Pizzeria%20Queries.cpp)
1. [Subarray Sum Queries](/Range%20Queries/Subarray%20Sum%20Queries.cpp)
1. [Distinct Values Queries](/Range%20Queries/Distinct%20Values%20Queries.cpp)
1. [Increasing Array Queries](/Range%20Queries/Increasing%20Array%20Queries.cpp)
1. [Forest Queries II](/Range%20Queries/Forest%20Queries%20II.cpp)
1. [Range Updates and Sums](/Range%20Queries/Range%20Updates%20and%20Sums.cpp)
1. [Polynomial Queries](/Range%20Queries/Polynomial%20Queries.cpp)
1. [Range Queries and Copies](/Range%20Queries/Range%20Queries%20and%20Copies.cpp)

## Tree Algorithms

1. [Subordinates](/Tree%20Algorithms/Subordinates.cpp)
1. [Tree Matching](/Tree%20Algorithms/Tree%20Matching.cpp)
1. [Tree Diameter](/Tree%20Algorithms/Tree%20Diameter.cpp)
1. [Tree Distances I](/Tree%20Algorithms/Tree%20Distances%20I.cpp)
1. [Tree Distances II](/Tree%20Algorithms/Tree%20Distances%20II.cpp)
1. [Company Queries I](/Tree%20Algorithms/Company%20Queries%20I.cpp)
1. [Company Queries II](/Tree%20Algorithms/Company%20Queries%20II.cpp)
1. [Distance Queries](/Tree%20Algorithms/Distance%20Queries.cpp)
1. [Counting Paths](/Tree%20Algorithms/Counting%20Paths.cpp)
1. [Subtree Queries](/Tree%20Algorithms/Subtree%20Queries.cpp)
1. [Path Queries](/Tree%20Algorithms/Path%20Queries%20I.cpp)
1. [Path Queries II](/Tree%20Algorithms/Path%20Queries%20II.cpp)
1. [Distinct Colors](/Tree%20Algorithms/Distinct%20Colors.cpp)
1. [Finding a Centroid](/Tree%20Algorithms/Finding%20a%20Centroid.cpp)
1. [Fixed-Length Paths I](/Tree%20Algorithms/Fixed%20Length%20Paths%20I.cpp)
1. [Fixed-Length Paths II](/Tree%20Algorithms/Fixed%20Length%20Paths%20II.cpp)

## Mathematics

1. [Josephus Queries](/Mathematics/Josephus%20Queries.cpp)
1. [Exponentiation](/Mathematics/Exponentiation%20I.cpp)
1. [Exponentiation II](/Mathematics/Exponentiation%20II.cpp)
1. [Counting Divisors](/Mathematics/Counting%20Divisors.cpp)
1. [Common Divisors](/Mathematics/Common%20Divisors.cpp)
1. [Sum of Divisors](/Mathematics/Sum%20of%20Divisors.cpp)
1. [Divisor Analysis](/Mathematics/Divisor%20Analysis.cpp)
1. [Prime Multiples](/Mathematics/Prime%20Multiples.cpp)
1. [Counting Coprime Pairs](/Mathematics/Counting%20Coprime%20Pairs.cpp)
1. [Binomial Coefficients](/Mathematics/Binomial%20Coefficients.cpp)
1. [Creating Strings II](/Mathematics/Creating%20Strings%20II.cpp)
1. [Distributing Apples](/Mathematics/Distributing%20Apples.cpp)
1. [Christmas Party](/Mathematics/Christmas%20Party.cpp)
1. [Bracket Sequences I](/Mathematics/Bracket%20Sequences%20I.cpp)
1. [Bracket Sequences II](/Mathematics/Bracket%20Sequences%20II.cpp)
1. [Counting Necklaces](/Mathematics/Counting%20Necklaces.cpp)
1. [Counting Grids](/Mathematics/Counting%20Grids.cpp)
1. [Fibonacci Numbers](/Mathematics/Fibonacci%20Numbers.cpp)
1. [Throwing Dice](/Mathematics/Throwing%20Dice.cpp)
1. [Graph Paths I](/Mathematics/Graph%20Paths%20I.cpp)
1. [Graph Paths II](/Mathematics/Graph%20Paths%20II.cpp)
1. [Dice Probability](/Mathematics/Dice%20Probability.cpp)
1. [Moving Robots](/Mathematics/Moving%20Robots.cpp)
1. [Candy Lottery](/Mathematics/Candy%20Lottery.cpp)
1. [Inversion Probability](/Mathematics/Inversion%20Probability.cpp)
1. [Stick Game](/Mathematics/Stick%20Game.cpp)
1. [Nim Game I](/Mathematics/Nim%20Game%20I.cpp)
1. [Nim Game II](/Mathematics/Nim%20Game%20II.cpp)
1. [Stair Game](/Mathematics/Stair%20Game.cpp)
1. [Grundy's Game](/Mathematics/Grundy's%20Game.cpp)
1. [Another Game](/Mathematics/Another%20Game.cpp)

## String Algorithms

1. [Word Combinations](/String%20Algorithms/Word%20Combinations.cpp)
1. [String Matching](/String%20Algorithms/String%20Matching.cpp)
1. [Finding Borders](/String%20Algorithms/Finding%20Borders.cpp)
1. [Finding Periods](/String%20Algorithms/Finding%20Periods.cpp)
1. [Minimal Rotation](/String%20Algorithms/Minimal%20Rotation.cpp)
1. [Longest Palindrome](/String%20Algorithms/Longest%20Palindrome.cpp)
1. [Required Substring](/String%20Algorithms/Required%20Substring.cpp)
1. [Palindrome Queries](/String%20Algorithms/Palindrome%20Queries.cpp)
1. [Finding Patterns](/String%20Algorithms/Finding%20Patterns.cpp)
1. [Counting Patterns](/String%20Algorithms/Counting%20Patterns.cpp)
1. [Pattern Positions](/String%20Algorithms/Pattern%20Positions.cpp)
1. [Distinct Substrings](/String%20Algorithms/Distinct%20Substrings.cpp)
1. [Repeating Substring](/String%20Algorithms/Repeating%20Substring.cpp)
1. [String Functions](/String%20Algorithms/String%20Functions.cpp)
1. [Substring Order I](/String%20Algorithms/Substring%20Order%20I.cpp)
1. [Substring Order II](/String%20Algorithms/Substring%20Order%20II.cpp)
1. [Substring Distribution](/String%20Algorithms/Substring%20Distribution.cpp)


## Geometry

1. [Point Location Test](/Geometry/Point%20Location%20Test.cpp)
1. [Line Segment Intersection](/Geometry/Line%20Segment%20Intersection.cpp)
1. [Polygon Area](/Geometry/Polygon%20Area.cpp)
1. [Point in Polygon](/Geometry/Point%20in%20Polygon.cpp)
1. [Polygon Lattice Points](/Geometry/Polygon%20Lattice%20Points.cpp)
1. [Minimum Euclidean Distance](/Geometry/Minimum%20Euclidean%20Distance.cpp)
1. [Convex Hull](/Geometry/Convex%20Hull.cpp)

## Advanced Techniques

1. [Meet in the Middle](/Advanced%20Techniques/Meet%20in%20the%20Middle.cpp)
1. [Hamming Distance](/Advanced%20Techniques/Hamming%20Distance.cpp)
1. [Beautiful Subgrids](/Advanced%20Techniques/Beautiful%20Subgrids.cpp)
1. [Reachable Nodes](/Advanced%20Techniques/Reachable%20Nodes.cpp)
1. [Reachability Queries](/Advanced%20Techniques/Reachability%20Queries.cpp)
1. [Cut and Paste](/Advanced%20Techniques/Cut%20and%20Paste.cpp)
1. [Substring Reversals](/Advanced%20Techniques/Substring%20Reversals.cpp)
1. [Reversals and Sums](/Advanced%20Techniques/Reversals%20and%20Sums.cpp)
1. [Necessary Roads](/Advanced%20Techniques/Necessary%20Roads.cpp)
1. [Necessary Cities](/Advanced%20Techniques/Necessary%20Cities.cpp)
1. [Eulerian Subgraphs](/Advanced%20Techniques/Eulerian%20Subgraphs.cpp)
1. [Monster Game I](/Advanced%20Techniques/Monster%20Game%20I.cpp)
1. [Monster Game II](/Advanced%20Techniques/Monster%20Game%20II.cpp)
1. [Subarray Squares](/Advanced%20Techniques/Subarray%20Squares.cpp)
1. [Houses and Schools](/Advanced%20Techniques/Houses%20and%20Schools.cpp)
1. [Knuth Division](/Advanced%20Techniques/Knuth%20Division.cpp)
1. [Apples and Bananas](/Advanced%20Techniques/Apples%20and%20Bananas.cpp)
1. [One Bit Positions](/Advanced%20Techniques/One%20Bit%20Positions.cpp)
1. [Signal Processing](/Advanced%20Techniques/Signal%20Processing.cpp)
1. [New Roads Queries](/Advanced%20Techniques/New%20Roads%20Queries.cpp)
1. [Dynamic Connectivity](/Advanced%20Techniques/Dynamic%20Connectivity.cpp)
1. [Parcel Delivery](/Advanced%20Techniques/Parcel%20Delivery.cpp)
1. [Task Assignment](/Advanced%20Techniques/Task%20Assignment.cpp)
1. [Distinct Routes II](/Advanced%20Techniques/Distinct%20Routes%20II.cpp)

## Additional Problems

1. [Shortest Subsequence](/Additional%20Problems/Shortest%20Subsequence.cpp)
1. [Counting Bits](/Additional%20Problems/Counting%20Bits.cpp)
1. [Swap Game](/Additional%20Problems/Swap%20Game.cpp)
1. [Prüfer Code](/Additional%20Problems/Prufer%20Code.cpp)
1. [Acyclic Graph Edges](/Additional%20Problems/Acyclic%20Graph%20Edges.cpp)
1. [Strongly Connected Edges](/Additional%20Problems/Strongly%20Connected%20Edges.cpp)
1. [Even Outdegree Edges](/Additional%20Problems/Even%20Outdegree%20Edges.cpp)
1. [Multiplication Table](/Additional%20Problems/Multiplication%20Table.cpp)
1. [Advertisement](/Additional%20Problems/Advertisement.cpp)
1. [Special Substrings](/Additional%20Problems/Special%20Substrings.cpp)
1. [Permutation Inversions](/Additional%20Problems/Permutation%20Inversions.cpp)
1. [Maximum Xor Subarray](/Additional%20Problems/Maximum%20Xor%20Subarray.cpp)
1. [Movie Festival Queries](/Additional%20Problems/Movie%20Festival%20Queries.cpp)
1. [Chess Tournament](/Additional%20Problems/Chess%20Tournament.cpp)
1. [Tree Traversals](/Additional%20Problems/Tree%20Traversals.cpp)
1. [Network Renovation](/Additional%20Problems/Network%20Renovation.cpp)
1. [Graph Girth](/Additional%20Problems/Graph%20Girth.cpp)
1. [Intersection Points](/Additional%20Problems/Intersection%20Points.cpp)
1. [Inverse Inversions](/Additional%20Problems/Inverse%20Inversions.cpp)
1. [Monotone Subsequences](/Additional%20Problems/Monotone%20Subsequences.cpp)
1. [String Reorder](/Additional%20Problems/String%20Reorder.cpp)
1. [Stack Weights](/Additional%20Problems/Stack%20Weights.cpp)
1. [Pyramid Array](/Additional%20Problems/Pyramid%20Array.cpp)
1. [Increasing Subsequence II](/Additional%20Problems/Increasing%20Subsequence%20II.cpp)
1. [String Removals](/Additional%20Problems/String%20Removals.cpp)
1. [Bit Inversions](/Additional%20Problems/Bit%20Inversions.cpp)
1. [Xor Pyramid](/Additional%20Problems/Xor%20Pyramid.cpp)
1. [Writing Numbers](/Additional%20Problems/Writing%20Numbers.cpp)
1. [String Transform](/Additional%20Problems/String%20Transform.cpp)
1. Letter Pair Move Game
1. [Maximum Building I](/Additional%20Problems/Maximum%20Building%20I.cpp)
1. [Sorting Methods](/Additional%20Problems/Sorting%20Methods.cpp)
1. [Cyclic Array](/Additional%20Problems/Cyclic%20Array.cpp)
1. [List of Sums](/Additional%20Problems/List%20of%20Sums.cpp)
1. [Increasing Array II](/Additional%20Problems/Increasing%20Array%20II.cpp)
1. [Food Division](/Additional%20Problems/Food%20Division.cpp)
1. Bit Problem
1. [Swap Round Sorting](/Additional%20Problems/Swap%20Round%20Sorting.cpp)
1. Binary Subsequences
1. [Tree Isomorphism I](/Additional%20Problems/Tree%20Isomorphism%20I.cpp)
1. [Counting Sequences](/Additional%20Problems/Counting%20Sequences.cpp)
1. [Critical Cities](/Additional%20Problems/Critical%20Cities.cpp)
1. [School Excursion](/Additional%20Problems/School%20Excursion.cpp)
1. [Coin Grid](/Additional%20Problems/Coin%20Grid.cpp)
1. Robot Path
1. [Programmers and Artists](/Additional%20Problems/Programmers%20and%20Artists.cpp)
1. [Course Schedule II](/Additional%20Problems/Course%20Schedule%20II.cpp)
1. Removing Digits II
1. [Coin Arrangement](/Additional%20Problems/Coin%20Arrangement.cpp)
1. [Counting Bishops](/Additional%20Problems/Counting%20Bishops.cpp)
1. [Grid Puzzle I](/Additional%20Problems/Grid%20Puzzle%20I.cpp)
1. [Grid Puzzle II](/Additional%20Problems/Grid%20Puzzle%20II.cpp)
1. [Empty String](/Additional%20Problems/Empty%20String.cpp)
1. [Grid Paths](/Additional%20Problems/Grid%20Paths%20III.cpp)
1. [Bit Substrings](/Additional%20Problems/Bit%20Substrings.cpp)
1. [Reversal Sorting](/Additional%20Problems/Reversal%20Sorting.cpp)
1. Counting Reorders
1. [Book Shop II](/Additional%20Problems/Book%20Shop%20II.cpp)
1. [Network Breakdown](/Additional%20Problems/Network%20Breakdown.cpp)
1. [Visiting Cities](/Additional%20Problems/Visiting%20Cities.cpp)
1. [Missing Coin Sum Queries](/Additional%20Problems/Missing%20Coin%20Sum%20Queries.cpp)
1. [Number Grid](/Additional%20Problems/Number%20Grid.cpp)
1. Maximum Building II
1. Filling Trominos
1. [Stick Divisions](/Additional%20Problems/Stick%20Divisions.cpp)
1. [Coding Company](/Additional%20Problems/Coding%20Company.cpp)
1. [Flight Route Requests](/Additional%20Problems/Flight%20Route%20Requests.cpp)
1. Two Stacks Sorting
1. [Tree Isomorphism II](/Additional%20Problems/Tree%20Isomorphism%20II.cpp)
1. Forbidden Cities
1. [Area of Rectangles](/Additional%20Problems/Area%20of%20Rectangles.cpp)
1. [Grid Completion](/Additional%20Problems/Grid%20Completion.cpp)
1. [Creating Offices](/Additional%20Problems/Creating%20Offices.cpp)
1. [Permutations II](/Additional%20Problems/Permutations%20II.cpp)
1. [Functional Graph Distribution](/Additional%20Problems/Functional%20Graph%20Distribution.cpp)
1. New Flight Routes
1. Grid Path Construction