﻿using AutonomoApp.Business.Models;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;

namespace AutonomoApp.Data.Mappings
{
    public class EnderecoMapping : IEntityTypeConfiguration<Endereco>
    {
        public void Configure(EntityTypeBuilder<Endereco> builder)
        {
            builder.HasKey(p => p.Id);

            builder.Property(c => c.Logradouro)
                .IsRequired(false)
                .HasColumnType("varchar(55)");

            builder.Property(c => c.Numero)
                .IsRequired(false)
                .HasColumnType("varchar(50)");

            builder.Property(c => c.Cep)
                .IsRequired()
                .HasColumnType("varchar(8)");

            builder.Property(c => c.Complemento)
                .IsRequired(false)
                .HasColumnType("varchar(250)");

            builder.Property(c => c.Bairro)
                .IsRequired(false)
                .HasColumnType("varchar(100)");

            builder.Property(c => c.Cidade)
                .IsRequired(false)
                .HasColumnType("varchar(100)");

            builder.Property(c => c.Estado)
                .IsRequired(false)
                .HasColumnType("varchar(50)");

            //builder.ToTable("AAEnderecos");
        }
    }
}