﻿using System.Globalization;
using Microsoft.AspNetCore.Localization;

namespace AutonomoApp.WebApi.Configuration;

public static class GlobalizationConfig
{
    public static IApplicationBuilder UseGlobalizationConfig(this IApplicationBuilder app)
    {

        var defaultCulture = new CultureInfo("pt-BR");
        var localizationOptions = new RequestLocalizationOptions()
        {
            DefaultRequestCulture = new RequestCulture(defaultCulture),
            SupportedCultures = new List<CultureInfo> { defaultCulture },
            SupportedUICultures = new List<CultureInfo> { defaultCulture }
        };

        app.UseRequestLocalization(localizationOptions);
        return app;
    }
}