# JingOS
### The World’s First Linux-Based OS Designed for Tablets

JingOS is a 'convergent' Linux-based open-source mobile OS for tablets and mobile devices.
It can run Linux apps and Android apps.
It is created to allow natural control by touch, pencil, keyboard, and trackpad.

[Download JingOS](https://en.jingos.com)

Here are some other links:

[JingPad A1](https://en.jingos.com/jingpad-a1/) - The World’s First Consumer-Level Linux Tablet.
[Buy JingPad A1](http://shop.jingos.com)

## Newsletter and Community 
[Mailing List](http://hk.mikecrm.com/pg5E05S)\
[Discord Channel](https://discord.gg/xEwDGW7RnJ)\
[Telegram Channel](https://t.me/JingOS_Linux)\
[Twitter](http://www.twitter.com/jingos_official)\
[YouTube](https://www.youtube.com/c/JingOS-team/videos)\
[Facebook Page](https://www.facebook.com/JingOSfb)\
[Matrix Room](https://matrix.to/#/#jingos:matrix.org)\
[Mastodon social](https://mastodon.social/@jingos_official)

![](https://en-cdn.jingos.com/wp-content/uploads/brizy/143/assets/images/iW=667&iH=438&oX=0&oY=2&cW=667&cH=435/Lark20201228-151833.png)

## Our Open-Source Project

[JingCore-WindowManger](https://github.com/JingOS-team/jing-kwin)\
JingCore-WindowManger is based on KDE Kwin, it is used to manage the application
windows. More gestures and other functions that are specially
designed for a Tablet OS are added.

[JingCore-CommonComponents](https://github.com/JingOS-team/jing-kirigami)\
JingCore-CommonComponents is based on KDE Kirigami. It adds more well-designed components for a Tablet OS.
  
[JingSystemui-Launcher](https://github.com/JingOS-team/jing-plasma-phone-components)\
This is the Launcher of JingOS, it includes Home, Dock, Notification, Control
Panel. It is based on KDE plasma-phone-components.

[JingApps-Photos](https://www.youtube.com/watch?v=3E0ADUIiFzA)\
Jing-Photos is based on Koko. It is beautifully designed photo app that conforms to the
JingOS style and combines both, tablet and desktop experience.
  
[JingApps-Kalk](https://github.com/JingOS-team/jing-kalk)\
Jing-Kalk is based on Kalk. Jing-Kalk is the calculator app of JingOS. Its style is reshaped to perfectly
blend into the JingOS UI and it supports both tablet and desktop mode.
  
[JingApps-Haruna Video Player](https://github.com/JingOS-team/jing-haruna)\
Jing-Haruna is an open-source video player built with Qt/QML on top of libmpv.

[JingApps-KRecorder](https://github.com/JingOS-team/jing-krecorder)\
Jing-KRecorder is based on KRecorder. It is JingOS' audio recorder app with a clean design, that
matches the JingOS style. It unifies smooth tablet and desktop usage in one app.

[JingApps-KClock](https://github.com/JingOS-team/jing-kclock)\
Jing-KClock is the clock app of JingOS and it is based on KClock. Its neat design is created to conform to
the JingOS style. It is compatible to tablet and desktop mode.

[JingApps-Media-Player](https://github.com/JingOS-team/jing-media-player)\
Jing-Media-Player is based on Vvave. It allows to record and playback audio and
video files. The UI is adapted to the JingOS style and it delivers a great user experience
on both tablet and desktop devices.

### Mobile & Desktop Experience Come Together

![](https://en-cdn.jingos.com/wp-content/uploads/brizy/3730/assets/images/iW=2006&iH=1254&oX=0&oY=0&cW=2006&cH=1254/os-2@2x.jpg)

JingOS is not only a tablet OS, but also a desktop OS. In tablet mode, you can
watch movies, read books, play games using the mobile apps in JingOS.
For productivity you can connect
a keyboard and a trackpad/mouse to switch to desktop mode. Then you can write
documents, and even do coding.

### Mobile First, Well Designed

![](https://en-cdn.jingos.com/wp-content/uploads/brizy/3730/assets/images/iW=2212&iH=1552&oX=0&oY=0&cW=2212&cH=1552/os-4@2x.jpg)

JingOS is designed to be a mobile-first tablet OS. It comes with a lot of
beautifully designed icons and animation effects.\
It is the most beautiful mobile Linux ever!\
JingOS even supports multi-touch gestures, which is very important for modern
tablets.

### JingOS Supports Linux Apps and Android Apps

![](https://en-cdn.jingos.com/wp-content/uploads/brizy/3730/assets/images/iW=2280&iH=820&oX=0&oY=0&cW=2280&cH=820/a1-10@2x.jpg)

We connect Linux and Android apps through technology, making JingOS a
‘convergent’ Linux OS.
You can use Linux desktop apps for productivity, and use Android apps for
entertainment.
More and more apps are coming to our AppStore.

*Android apps native support only available for ARM-based devices

### Support for Trackpad Gestures

![](https://en-cdn.jingos.com/wp-content/uploads/2021/01/05-2.gif)

JingOS has also optimized gestures for the trackpad.
You can use trackpad gestures similar to the screen gestures.
This provides you a better experience when you are using your device in laptop mode.

## About us

JingOS is a product of Jingling Tech. Jing/鲸 means whale, and Ling/鲮 means
dace fish in Chinese. The logo of Jingling consist of two intertwined fishes which stands for a
small ecosystem.\
We have a team of very experienced Linux experts who had previously worked at
Lenovo, Alibaba, Samsung, Canonical/Ubuntu, Trolltech and other famous IT
companies.

We are based in Beijing and California.

## FAQ

Is JingOS free and open-source?

> Yes, JingOS has been open-sourced here on GitHub. And the image files of JingOS can be downloaded from our website.

What is JingOS based on?

> JingOS is based on Ubuntu 20.04, KDE Frameworks 5.75, and Plasma Mobile 5.20.

<!--What’s the roadmap of JingOS?

> I posted about Roadmap v1.0 of JingOS 90 in January. I will update the roadmap
  every quarter.

If JingOS is a tablet OS, does it require apps to respect the life cycle, like
what happens when suspended? How does it manage permission? Is there a
permission system like iOS? Are the apps sandboxed? If it can just run Linux
apps, how would they respect life cycle, permission, and stuff? Will you use
snap/flatpak for the permissions system?

> Life-cycle management API will come with JingOS v0.8 in March, apps designed
  for JingOS can be suspended like any other tablet OSs. The permission system
  and app sandbox are still in discussion, not decided yet.

Compared to other Linux distros, is JingOS optimized for tablet only in the UI /
specialized apps, or are there performance tweaks/features as well. Is it
basically like a gnome / KDE but with a tablet first focussed, or are there any
“lower-level” differences? What kind of lower-level differences? Drivers?
Performance enhancements? What will it help Linux do on tablets especially?

> JingOS v0.6 is mostly optimized only in the UI and specialized apps. But
  JingOS v0.8 would have lots of lower differences, like performance
  enhancements.

Do apps have to be created for JingOS to work well? Could I use Spotify or
Discord apps on it, or would there need to be JingOS versions first? JingOS just
run normal Linux apps, right? So we should be able to build and run Flutter
desktop apps on it? Will JingOS support android apps? To fill the gap with
missing popular apps.

> Linux apps (.deb, etc.) can run in JingOS well. You can run Android apps in
  the JingOS ARM version after v1.0 in June.-->
  
Can JingOS run Android apps?
> JingOS ARM for JingPad A1 can run Android apps. For more information, please go to Wiki


## Roadmap

* JingOS v0.6: was released on Jan 31, 2021. It has been tested on Surface Pro
  6 and Huawei Matebook 14. It is a preview version of JingOS. You have the
  control panel and notification center on your Linux tablets just like the
  iPad! You can check the preview video of the JingOS v0.6 here 302.
  
* JingOS v0.8: was released on Mar 31, 2021. It contains a huge amount of updates,
  including the JingOS App Store, Settings, File Managers, etc. Also a totally new
  virtual keyboard designed for Linux was added. With v0.8 comes OTA functionality. 
  Several other devices were tested with JingOS v0.8.
  
* JingOS v0.9: was released on May 31, 2021. Support for different resolutions, setting wallpapers,
  file (de)compression was added. The Notification Center and Control Panel were upgraded with the Gaussian blur effect. 
  With v0.9 the password can be complex, i.e. can contain characters, digits and symbols. The mouse click accuracy was improved and several shortcuts were created.

* JingOS v1.0 ARM: We released this version on September 28th, 2021. 
* JingOS V1.1 ARM: Released on Nov. 6, 2021
* JingOS V1.1.1 ARM: Released on Nov.30, 2021
* JingOS V1.2 ARM: Released on Jan. 20, 2022

<!--
#### We will release updates every month after June.

### About open-sourcing:

> JingOS is based on Ubuntu 20.04, KDE v5.75, Plasma Mobile 5.20. We will
  replace the framework from Plasma Mobile to JDE (Jing Desktop Environment)
  later this year.
-->
## Press

[Press Coverage](https://jingos.feishu.cn/sheets/shtcnTr6q3mmLsQyTSg99KRVMGc) -
All Media about JingOS and JingPad

## Contact us

Email: service@jingos.com
