# **Cryptocurrency Investment Simulator**

<img align="right" alt="CIS-LOGO" width="150px" src="https://i.postimg.cc/tTQJm5hY/cis-logo.png"/>

**Goal:** College degree qualification project for University of Latvia <br/>
**Framework:** ASP.NET Core 6 <br/>
**Pattern:** Model-View-Controller <br/>
**Services:** Auth0 and CoinMarketCap API

---

**Description** <br/>
The purpose of this qualification project is to develop a useful website for investors who make their investments in the cryptocurrency market.
The goal is to provide an investor with a convenient, reliable and easy to-use environment to practice their market skills through simulated investments.
Investors can view real-time price charts and buy cryptocurrencies using pre-allocated, artificial money in their wallet. 
With the help of CoinMarketCap API charts reflect real market data, but investments are just imitations. 
In addition, it is possible to add leverage to transactions, which gives you the opportunity to test its benefits and risks. 
Immediately after making the first transaction, the investor starts receiving a transparent analysis of the contents of his 
currency wallets, capital changes and other successes.

---

**Naming conventions for test projects** <br/>
Test classes are named ClassNameTests.cs (for example: MarketControllerTests.cs). <br/>
Test methods are named MethodName_TestScenario_ExpectedResult (for example: InserUser_MissingData_ThrowsException).

---

**Other information** <br/>
Database table scripts and specific data insertion scripts can be found under ExternalCode. <br/>
None of the branches have been deleted, so they can be pulled and used to view the historical state of the project. <br/>
Unit tests use xUnit and functional tests use Selenium WebDriver.

---

<img src='https://i.postimg.cc/Jh0kbWkY/page-landing.png' alt='page-landing' width="1280px"/> <br/>
<img src='https://i.postimg.cc/ncTrTPZy/login-register.png' alt='login-register' width="1280px"/>
<img src='https://i.postimg.cc/JhX1w6V4/page-home2.png' alt='page-home2' width="1280px"/> <br/>
<img src='https://i.postimg.cc/Df67K4Ds/page-market.png' alt='page-market' width="1280px"/> <br/>
<img src='https://i.postimg.cc/k4cP9Lj9/page-btcchart.png' alt='page-btcchart' width="1280px"/> <br/>
<img src='https://i.postimg.cc/rwr6zDhf/page-btcbuysell.png' alt='page-btcbuysell' width="1280px"/> <br/>
<img src='https://i.postimg.cc/Zq81F1z3/page-portfolio.png' alt='page-portfolio' width="1189px"/>
