<!-- START HeaderSmall.mustache -->
<br />
<div align="center">
  <a href="https://github.com/Jax-Core/JaxCore">
    <img src="https://raw.githubusercontent.com/Jax-Core/ReadME-Template/main/Resources/Icons/JaxCore.png" alt="Logo" width="80" height="80">
  </a>

<h3 align="center">JaxCore</h3>
  <p align="center">
    A beautiful set of tools and widgets to spice up your desktop.
    <br />
    <a href="https://discord.gg/JmgehPSDD6">Help, Report Bugs & Request Features »</a>
  </p>
</div>

<!-- END HeaderSmall.mustache -->
<!-- START ShieldsFull.mustache -->
<p align="center">
  <img alt="Latest by date" src="https://img.shields.io/github/v/tag/Jax-Core/JaxCore?label=Version&style=for-the-badge" />
  <img alt="Releases" src="https://img.shields.io/github/downloads/Jax-Core/JaxCore/total?style=for-the-badge" />
  <img alt="Release date" src="https://img.shields.io/github/release-date/Jax-Core/JaxCore?label=Last%20Update&style=for-the-badge" />
  <img alt="Discord" src="https://img.shields.io/discord/880445067754610688?label=Discord%20server&style=for-the-badge" />
  <img alt="Github" src="https://img.shields.io/github/license/Jax-Core/JaxCore?style=for-the-badge" />
</p><!-- END ShieldsFull.mustache -->

## About 👀

![GithubBanner](https://user-images.githubusercontent.com/80020581/173227081-761ae822-6c83-4a10-9093-a3117c2cffd7.png)

JaxCore is a collection of utility modules designed to improve your desktop experience and increase your productivity. Core is a configuration hub that allows for quick access to settings, updates, and new releases.

JaxCore (configuration hub) acts as a settings menu for all JaxCore modules, while providing continuous support for patch / feature updates. It also allows you to access other modules more quickly!

## Screenshots 🖼️
You can check out what you're desktop can look like [here](https://github.com/Jax-Core/JaxCore/blob/main/Screenshots.md)!

## Prerequisites 🖥️
- **Windows 10 (x64)** or above
- > 6GB RAM, > 4 Core CPU
- For older systems, **Powershell v5.1 or newer** is required. Upgrade powershell **[here](https://docs.microsoft.com/en-us/powershell/scripting/windows-powershell/install/installing-windows-powershell?view=powershell-7.2#upgrading-existing-windows-powershell)**!

## Installation ✅
**By Powershell CLI:**
Run the following command in Powershell to install the latest version of JaxCore.

(To launch Powershell as an Admin: `Win + R` -> `powershell` -> Press `CTRL + SHIFT + ENTER` on your keyboard. Powershell can also be launched via Windows Search.)

```
iwr -useb "https://raw.githubusercontent.com/Jax-Core/JaxCore/master/CoreInstaller.ps1" | iex
```
For other methods or changing install location, check out the [FAQs](https://jaxcore.gitbook.io/core/getting-started/faqs/jaxcore-faqs#installation)
<br />
<br />

## Core Widgets and Modules ☑️

### Currently Avaiable Modules 💠
1. [YourFlyouts](https://github.com/Jax-Core/YourFlyouts)
1. [YourMixer](https://github.com/Jax-Core/YourMixer)
1. [Keylaunch](https://github.com/Jax-Core/Keylaunch)
1. [IdleStyle](https://github.com/Jax-Core/IdleStyle)
1. [ValliStart](https://github.com/Jax-Core/ValliStart)
1. [QuickNote](https://github.com/Jax-Core/QuickNote)
1. [MIUI-Shade](https://github.com/Jax-Core/MIUI-Shade)
1. [Keystrokes](https://github.com/Jax-Core/Keystrokes)

### Currently Available Widgets 📦
1. [ModularVisualizer](https://github.com/Jax-Core/ModularVisualizer)
2. [ModularClocks](https://github.com/Jax-Core/Modularclocks)
3. [ModularPlayers](https://github.com/Jax-Core/ModularPlayers)
5. [Plainext](https://github.com/Jax-Core/Plainext)
4. [Combilaunch](https://github.com/Jax-Core/Combilaunch) (This widget does not require you to have JaxCore installed.)


## Help and Documentation ❔
- If you are interested in learning more about JaxCore, its structure, or how to develop modules/widgets, please see [JaxCore's Documentation](https://jaxcore.gitbook.io/core/).
- Join the [Core Community Discord Server](https://discord.gg/JmgehPSDD6) for more help.


## Credits
The following table lists out the external plugins used to make JaxCore and all of it's modules and widgets.
| Plugin | Creator |
| ------------- | ------------- |
| [AudioAnalyzer](https://forum.rainmeter.net/viewtopic.php?t=31091) | rxtd |
| [FrostedGlass](https://forum.rainmeter.net/viewtopic.php?t=23106) | theAzack9 | 
| [FileChoose](https://forum.rainmeter.net/viewtopic.php?t=33767) | SetSukka | 
| [magickmeter](https://github.com/khanhas/MagickMeter) | [@khanhas](https://github.com/khanhas) | 
| [ConfigActive](https://forum.rainmeter.net/viewtopic.php?t=28720) | jsMorley | 
| [Focus](https://forum.rainmeter.net/viewtopic.php?t=37989) | [@deathcrafter](https://github.com/deathcrafter) | 
| [Mouse](https://github.com/NighthawkSLO/Mouse.dll/) | [@NighthawkSLO](https://github.com/NighthawkSLO) | 
| [MouseXY](https://forum.rainmeter.net/viewtopic.php?t=22900) | Fawxy | 
| [PowershellRM](https://github.com/khanhas/PowershellRM) | [@khanhas](https://github.com/khanhas) | 
| [ShowInToolbar](https://forum.rainmeter.net/viewtopic.php?t=25334) | theAzack9 | 
| [HotKey](https://github.com/brianferguson/HotKey.dll) | [@brianferguson](https://github.com/brianferguson) | 
| [Chameleon](https://github.com/socks-the-fox/Chameleon) | socks-the-fox | 
| [IsFullScreen](https://forum.rainmeter.net/viewtopic.php?t=28305) | jsMorley | 
| [WebNowPlaying](https://github.com/tjhrulz/WebNowPlaying) | Rainmeter team | 
| [Drag&Drop](https://forum.rainmeter.net/viewtopic.php?t=23107) | theAzack9 | 
| [MediaPlayer](https://github.com/i2002/RainmeterMediaPlayer) | [@i2002](https://github.com/i2002) | 
| [AppVolume](https://github.com/khanhas/AppVolumePlugin) | Original [@khanhas](https://github.com/khanhas) Remastered [@deathcrafter](https://github.com/deathcrafter) |
| [TrayIcon](https://github.com/deathcrafter/PluginTrayIcon) | [@deathcrafter](https://github.com/deathcrafter) | 
| [SysColor](https://github.com/brianferguson/SysColor.dll) | [@brianferguson](https://github.com/brianferguson) | 

The following table lists the external technologies used for JaxCore.
| Technology | Creator | 
| ------------- | ------------- |
| [AutoHotkey](https://www.autohotkey.com/) | AHK Team | 
| [RainRGB](https://forum.rainmeter.net/viewtopic.php?t=6215) | jsMorley | 

<!-- START Footer.mustache -->

## Need assistance?
* Join the [CoreCommunity Discord Server](https://discord.gg/JmgehPSDD6) for help
* or [Create an issue](https://github.com/Jax-Core/JaxCore)

## Say Hi!
* Follow me on 👨‍💻 [Github](https://github.com/EnhancedJax) and stay updated on new things that I make
* You can also watch me on 🐦 [DeviantArt](https://www.deviantart.com/jaxoriginals) instead
* Message me on 🗨️ [Discord](https://discord.gg/JmgehPSDD6)

---

<p align="center">
<i>Made with ❤️ by Jax</i>
   <br/><br/>
   <img src="https://raw.githubusercontent.com/Jax-Core/ReadME-Template/main/Resources/Assets/Logo.png"  width="32" height="32"/>
</p><!-- END Footer.mustache -->
